/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class MaterialReqQtyRefCheck
extends AbstractCheckingItem {
    @Override
    protected String getInvCheckingItemName() {
        return "MaterialReqQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        String sourceBillType = invUpdPara.getSourceBillType();
        String coreBillType = invUpdPara.getCoreBillType();
        if (invUpdPara.getBizAction().getValue() == 109 && coreBillType.equals("901")) {
            this.subContractOrderUnAuditCheck(ctx, invUpdPara);
        }
        if (invUpdPara.getBizAction().getValue() != 103) {
            return;
        }
        boolean isReversed = invUpdPara.isReversed();
        if (!isReversed) {
            if (sourceBillType.equals("103")) {
                this.purInCheck(ctx, invUpdPara);
            } else if (sourceBillType.equals("104")) {
                this.materialReqRtCheck(ctx, invUpdPara);
            } else if (sourceBillType.equals("160")) {
                this.materialRequestCheck(ctx, invUpdPara);
            } else if (sourceBillType.equals("901")) {
                this.subContractOrderCheck(ctx, invUpdPara);
            }
        } else if ("901".equals(coreBillType)) {
            this.reversedSubCheck(ctx, invUpdPara);
        } else {
            this.reversedCheck(ctx, invUpdPara);
        }
    }

    private void subContractOrderUnAuditCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append(" SELECT A.FTotalIssueBaseQty - B.FBaseQty - A.FTOTALISSUERETURNBASEQTY  FBaseQty, ");
            sqlBuff.append(" B.FBaseQty as bFBaseQty,B.FCOREBILLENTRYID as FCOREBILLENTRYID ");
            sqlBuff.append(" FROM T_SM_SubMaterialList A ");
            sqlBuff.append(" INNER JOIN (select sum(FBaseQty) as FBaseQty,FCOREBILLENTRYID as FCOREBILLENTRYID,FIsReturn,FBillID ");
            sqlBuff.append("  from  ").append(tempTableName).append(" group by FCOREBILLENTRYID,FIsReturn,FBillID) ");
            sqlBuff.append("  B ON A.FID = B.FCOREBILLENTRYID  ");
            sqlBuff.append(" inner join t_im_materialreqbill bill on bill.fid = B.FBillID");
            sqlBuff.append(" inner join T_SCM_BizType bizType on bizType.fid = bill.FBIZTYPEID");
            sqlBuff.append(" and bizType.fid != '").append("iwoAAAALL80kB0Nc").append("'");
            sqlBuff.append("  where B.FIsReturn = 1 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                hs.put(rs.getString("FCOREBILLENTRYID"), rs.getBigDecimal("FBaseQty").abs());
                if (++errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.ISSUEQTYLESSTHANRETURNQTY);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void purInCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("ABS(A.FCanDirectReqBaseQty) - ABS(B.FBaseQty) as FBaseQty,");
            sqlBuff.append("ABS(B.FBaseQty) as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_Purinwarehsentry A INNER JOIN ");
            sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MATERIALREQ_QTY_NOMATHCH_PURIN);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void materialReqRtCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("C.FTOTALISSUEBASEQTY - C.FTOTALISSUERETURNBASEQTY -  B.FBaseQty as FBaseQty,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_MaterialReqBillEntry A INNER JOIN ");
            sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            sqlBuff.append("INNER JOIN T_SM_SubMaterialList C on A.FSOURCEBILLENTRYID = C.FId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MATERIALRT_NOMATCH_MATERIALREQ);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void materialRequestCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("A.FApprovedBaseQty*(1 + decimal(ISNULL(A.FQuarityOverRate,0)/100,21,8) ) -  A.FTotalFinishBaseQty  - B.FBaseQty as FBaseQty,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_MaterialRequestBillEntry A INNER JOIN ");
            sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            sqlBuff.append(" Where A.FQuarityUnCtrl = 0 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MATERIALREQ_NOMATCH_MATERIALREQUEST);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void subContractOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block8: {
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sqlBuff = new StringBuffer();
            String tempTableName = invUpdPara.getTempTableName();
            HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
            int errors = 0;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                sqlBuff.append("SELECT FIsReturn,");
                sqlBuff.append(" case when FIsReturn = 1 then (case when A.FIsQtyUnCtrl = 0 then (A.FBaseQty + A.FTotalIssueReNeedBaseQty - A.FTotalIssueBaseQty - B.FBaseQty) else 0 end)");
                sqlBuff.append(" else (A.FTOTALISSUEBASEQTY - A.FTOTALISSUERETURNBASEQTY -  B.FBaseQty) end as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_SM_SubMaterialList A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId,FIsReturn,FBillID from  " + tempTableName + " group by FSourceBillEntryId,FIsReturn,FBillID)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                sqlBuff.append(" inner join t_im_materialreqbill bill on bill.fid = B.FBillID");
                sqlBuff.append(" inner join T_SCM_BizType bizType on bizType.fid = bill.FBIZTYPEID");
                sqlBuff.append(" and bizType.fid != '").append("iwoAAAALL80kB0Nc").append("'");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                boolean FIsReturn = false;
                while (rs.next()) {
                    if ("-1".equals(rs.getString("FIsReturn"))) {
                        FIsReturn = true;
                    }
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors <= 0) break block8;
                if (FIsReturn) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MATERIALRT_NOMATCH_MATERIALREQ);
                    break block8;
                }
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MATERIALREQ_QTY_NOMATHCH_SUBCON);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    protected void reversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String billEntryTable = invUpdPara.getBillEntryTable();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - FReturnBaseQty - A.FReverseBaseQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM " + billEntryTable + " A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void reversedSubCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String billEntryTable = invUpdPara.getBillEntryTable();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - FReturnBaseQty - A.FReverseBaseQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("ABS(A.FSubUnWriteOffBaseQty) - B.FBaseQty as FScBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM " + billEntryTable + " A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1 && rs.getBigDecimal(2).signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FScBaseQty"));
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

