/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class MoveInWarehsQtyRefCheck
extends AbstractCheckingItem {
    @Override
    protected String getInvCheckingItemName() {
        return "MoveInWarehsQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        if (invUpdPara.getBizAction().getValue() != 103) {
            return;
        }
        String coreBillType = invUpdPara.getCoreBillType();
        if ("140".equals(coreBillType)) {
            this.moveInCheck(ctx, invUpdPara);
        }
    }

    protected void moveInCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append(" decimal(decimal(A.FBaseQty,21,8)*(1 + decimal(A.FQuarityOverRate/100 ,21,8)),21,8) -  A.FReceiptBaseQty  - B.FBaseQty as FBaseQty,");
                sqlBuff.append("A.FIssueBaseQty -  A.FReceiptBaseQty  - B.FBaseQty as FBaseQty2,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId, ");
                sqlBuff.append("A.FQuarityUnCtrl as FQuarityUnCtrl, ");
                sqlBuff.append("A.FQuarityOverRate as FQuarityOverRate, ");
                sqlBuff.append("A.FQuarityArreRate as FQuarityArreRate ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                sqlBuff.append("Where A.FQuarityUnCtrl = 0 ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEIN_QTY_NOMATHCH_STORETRANS);
                }
                sqlBuff.setLength(0);
                errors = 0;
                hs.clear();
                sqlBuff.append("SELECT ");
                sqlBuff.append(" abs(decimal(A.FIssueBaseQty*(1 + decimal(ISNULL(A.FQuarityOverRate,0)/100,21,8)),21,8)) ");
                sqlBuff.append(" - abs(A.FReceiptBaseQty) ");
                sqlBuff.append(" - abs(B.FBaseQty) as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                sqlBuff.append("WHERE A.FQuarityUnCtrl = 0");
                PreparedStatement stmt1 = null;
                ResultSet rs1 = null;
                stmt1 = conn.prepareStatement(sqlBuff.toString());
                rs1 = stmt1.executeQuery();
                while (rs1.next()) {
                    if (rs1.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs1.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs1.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs1.getString("FCoreBillEntryId"), rs1.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEIN_QTY_NOMATHCH_STORETRANS);
                }
            } else {
                this.reversedCheck(ctx, invUpdPara);
            }
        }
        catch (SQLException ex) {
            Logger.error((Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }
}

