/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractReWriteOrder;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MoveInWarehsReWrtie
extends AbstractReWriteOrder {
    @Override
    void reWriteCoreOrder(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, EASBizException, BOSException {
        boolean isUnAudit;
        String tempTableName = invUpdPara.getTempTableName();
        String coreBillType = invUpdPara.getCoreBillType();
        boolean isReversed = invUpdPara.isReversed();
        String sign = isReversed ? "-" : "+";
        BizActionEnum bizAction = invUpdPara.getBizAction();
        boolean bl = isUnAudit = bizAction.getValue() == 109;
        if (isUnAudit) {
            sign = sign.equals("+") ? "-" : "+";
        }
        String updateSQL = "update T_IM_StockTransferBillEntry set FReceiptQty = ?,FReceiptBaseQty = ? where fid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        String fid = null;
        int qtyPrecision = 2;
        BigDecimal baseQty = null;
        BigDecimal receiptQty = null;
        BigDecimal receiptBaseQty = null;
        BigDecimal baseConvsRate = null;
        StringBuffer sql = new StringBuffer();
        if (coreBillType.equals("140")) {
            sql.append("select b.FID,b.FReceiptQty,b.FReceiptBaseQty,a.FBaseQty,a.FBaseConvsRate,a.FQtyPrecision ");
            sql.append("from T_IM_StockTransferBillEntry b Inner join ( ");
            sql.append("select FCoreBillEntryId,FQtyPrecision,FBaseConvsRate,sum(FBaseQty) as FBaseQty ");
            sql.append("from " + tempTableName + " ");
            sql.append("group by FCoreBillEntryId,FQtyPrecision,FBaseConvsRate ");
            sql.append(") a on b.fid = a.FCoreBillEntryId ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(updateSQL);
                while (rs.next()) {
                    fid = rs.getString("FID");
                    qtyPrecision = rs.getInt("FQtyPrecision");
                    baseQty = rs.getBigDecimal("FBaseQty").setScale(8, 4);
                    receiptQty = rs.getBigDecimal("FReceiptQty").setScale(8, 4);
                    receiptBaseQty = rs.getBigDecimal("FReceiptBaseQty").setScale(8, 4);
                    baseConvsRate = rs.getBigDecimal("FBaseConvsRate").setScale(8, 4);
                    if (sign.equals("+")) {
                        receiptQty = receiptQty.add(baseQty.divide(baseConvsRate, qtyPrecision, 4));
                        receiptBaseQty = receiptBaseQty.add(baseQty);
                    } else {
                        receiptQty = receiptQty.subtract(baseQty.divide(baseConvsRate, qtyPrecision, 4));
                        receiptBaseQty = receiptBaseQty.subtract(baseQty);
                    }
                    stmt.setBigDecimal(1, receiptQty);
                    stmt.setBigDecimal(2, receiptBaseQty);
                    stmt.setString(3, fid);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((ResultSet)rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        String sql2 = "select distinct FCoreBillId from " + tempTableName;
        try {
            JdbcRowSet rs = (JdbcRowSet)DbUtil.executeQuery((Context)ctx, (String)sql2);
            if (coreBillType.equals("140")) {
                while (rs.next()) {
                    this.setStockTransStatus(ctx, rs.getString("FCoreBillId"), tempTableName);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("set coreBillStatus exception : " + sql2, (Throwable)e);
        }
        if (isReversed) {
            sql.setLength(0);
            sql.append("update T_IM_StockTransferBillEntry set (FID,FReceiptQty) = ");
            sql.append("(select ");
            sql.append("T_IM_StockTransferBillEntry.FID,");
            sql.append("T_IM_StockTransferBillEntry.FReceiptQty - a.FBaseQty from ");
            sql.append("(select sum(t.FBaseQty) as FBaseQty,");
            sql.append("t.FCoreBillEntryId as FCoreBillEntryId ");
            sql.append("from T_IM_MoveInwarehsBillEntry p," + tempTableName + " t ");
            sql.append("where p.FID = t.FCoreBillEntryId ");
            sql.append("group by t.FCoreBillEntryId");
            sql.append(") a ");
            sql.append("where");
            sql.append("  T_IM_StockTransferBillEntry.fid = a.FCoreBillEntryId");
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    void reWriteSourceOrder(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, EASBizException, BOSException {
        IRowSet rs;
        boolean isUnAudit;
        String tempTableName = invUpdPara.getTempTableName();
        String sourceBilltype = invUpdPara.getSourceBillType();
        boolean isReversed = invUpdPara.isReversed();
        BizActionEnum bizAction = invUpdPara.getBizAction();
        String sign = "+";
        String unSign = "-";
        if (isReversed) {
            sign = sign.equals("+") ? "-" : "+";
            unSign = unSign.equals("+") ? "-" : "+";
        }
        boolean bl = isUnAudit = bizAction.getValue() == 109;
        if (isUnAudit) {
            sign = sign.equals("+") ? "-" : "+";
            unSign = unSign.equals("+") ? "-" : "+";
        }
        String updateSQL = "update T_IM_StockTransferBillEntry set FAssociateQty = ? where fid = ?";
        String updateMoveIssueSQL = "update T_IM_MoveIssueBillEntry set FTotalInWarehsQty = ?,FCanInwarehsBaseQty = ? where fid = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        String fid = null;
        int qtyPrecision = 2;
        BigDecimal baseQty = null;
        BigDecimal associateQty = null;
        BigDecimal totalInWarehsQty = null;
        BigDecimal canInwarehsBaseQty = null;
        BigDecimal baseConvsRate = null;
        StringBuffer sql = new StringBuffer();
        if (sourceBilltype.equals("140") || sourceBilltype.equals("107")) {
            if (isReversed) {
                sql.append("Select a.FID,a.FAssociateQty,b.FBaseQty ");
                sql.append("from T_IM_StockTransferBillEntry a Inner join ( ");
                sql.append("select b.FSourceBillEntryId,sum(a.FBaseQty) as FBaseQty ");
                sql.append("from " + tempTableName + " a ");
                sql.append("Inner join T_IM_MoveInWarehsBillEntry b on b.FID = a.FSourceBillEntryId ");
                sql.append("group by b.FSourceBillEntryId ");
                sql.append(") b on a.FID = b.FSourceBillEntryId");
            } else {
                sql.append("Select a.FID,a.FAssociateQty,b.FBaseQty ");
                sql.append("from T_IM_StockTransferBillEntry a Inner join ( ");
                sql.append("select FSourceBillEntryId,sum(FBaseQty) as FBaseQty ");
                sql.append("from " + tempTableName + " ");
                sql.append("group by FSourceBillEntryId ");
                sql.append(") b on a.FID = b.FSourceBillEntryId");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(updateSQL);
                while (rs.next()) {
                    fid = rs.getString("FID");
                    baseQty = rs.getBigDecimal("FBaseQty").setScale(8, 4);
                    associateQty = rs.getBigDecimal("FAssociateQty").setScale(8, 4);
                    associateQty = unSign.equals("+") ? associateQty.add(baseQty) : associateQty.subtract(baseQty);
                    stmt.setBigDecimal(1, associateQty);
                    stmt.setString(2, fid);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((ResultSet)rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        sql = new StringBuffer();
        if (sourceBilltype.equals("106") || sourceBilltype.equals("107")) {
            if (isReversed) {
                sql.append("select a.FID,a.FTotalInWarehsQty,a.FCanInwarehsBaseQty,b.FBaseQty,b.FBaseConvsRate,b.FQtyPrecision ");
                sql.append("from T_IM_MoveIssueBillEntry a Inner join ( ");
                sql.append("select b.FSourceBillEntryId,FQtyPrecision,FBaseConvsRate, sum(a.FBaseQty) as FBaseQty ");
                sql.append("from " + tempTableName + " a ");
                sql.append("inner join T_IM_MoveInWarehsBillEntry b on b.FID = a.FSourceBillEntryId ");
                sql.append("group by b.FSourceBillEntryId,FQtyPrecision,FBaseConvsRate ");
                sql.append(") b on b.FSourceBillEntryId = a.FID ");
            } else {
                sql.append("select a.FID,a.FTotalInWarehsQty,a.FCanInwarehsBaseQty,b.FBaseQty,b.FBaseConvsRate,b.FQtyPrecision ");
                sql.append("from T_IM_MoveIssueBillEntry a Inner join ( ");
                sql.append("select FSourceBillEntryId,FQtyPrecision,FBaseConvsRate, sum(FBaseQty) as FBaseQty ");
                sql.append("from " + tempTableName + " ");
                sql.append("group by FSourceBillEntryId,FQtyPrecision,FBaseConvsRate ");
                sql.append(") b on b.FSourceBillEntryId = a.FID ");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(updateMoveIssueSQL);
                while (rs.next()) {
                    fid = rs.getString("FID");
                    qtyPrecision = rs.getInt("FQtyPrecision");
                    baseQty = rs.getBigDecimal("FBaseQty").setScale(8, 4);
                    totalInWarehsQty = rs.getBigDecimal("FTotalInWarehsQty").setScale(8, 4);
                    canInwarehsBaseQty = rs.getBigDecimal("FCanInwarehsBaseQty").setScale(8, 4);
                    baseConvsRate = rs.getBigDecimal("FBaseConvsRate").setScale(8, 4);
                    totalInWarehsQty = sign.equals("+") ? totalInWarehsQty.add(baseQty.divide(baseConvsRate, qtyPrecision, 4)) : totalInWarehsQty.subtract(baseQty.divide(baseConvsRate, qtyPrecision, 4));
                    canInwarehsBaseQty = unSign.equals("+") ? canInwarehsBaseQty.add(baseQty) : canInwarehsBaseQty.subtract(baseQty);
                    stmt.setBigDecimal(1, totalInWarehsQty);
                    stmt.setBigDecimal(2, canInwarehsBaseQty);
                    stmt.setString(3, fid);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
        }
        if (isReversed) {
            this.rewriteReversedSource(ctx, invUpdPara);
        }
    }
}

