/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class MoveIssueQtyRefCheck
extends AbstractCheckingItem {
    @Override
    protected String getInvCheckingItemName() {
        return "MoveIssueQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        String sourceBillType = invUpdPara.getSourceBillType();
        String coreBillType = invUpdPara.getCoreBillType();
        if (coreBillType.equals("140") && invUpdPara.bizAction.getValue() == 109) {
            this.stockTransferCoreBillCheck(ctx, invUpdPara);
        }
        if (invUpdPara.bizAction.getValue() == 109) {
            return;
        }
        if (coreBillType.equals("140")) {
            this.moveIssueCheck(ctx, invUpdPara, true);
        }
        if (sourceBillType.equals("140")) {
            this.moveIssueCheck(ctx, invUpdPara, false);
        } else {
            boolean isReversed = invUpdPara.isReversed();
            if (isReversed) {
                this.reversedCheck(ctx, invUpdPara);
            }
        }
    }

    protected void moveIssueCheck(Context ctx, WriteBackParamInfo invUpdPara, boolean isCheckCoreBill) throws InvUpdateException, BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block17: {
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sqlBuff = new StringBuffer();
            boolean isReversed = invUpdPara.isReversed();
            String tempTableName = invUpdPara.getTempTableName();
            HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
            int errors = 0;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (!isReversed) {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("decimal(A.FBaseQty*(1 + decimal(ISNULL(A.FQuarityOverRate,0)/100,21,8)),21,8) -  A.FIssueBaseQty  - B.FBaseQty as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId, ");
                    sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId, ");
                    sqlBuff.append("A.FQuarityUnCtrl as FQuarityUnCtrl, ");
                    sqlBuff.append("A.FQuarityOverRate as FQuarityOverRate, ");
                    sqlBuff.append("A.FQuarityArreRate as FQuarityArreRate ");
                    sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FSourceBillEntryId,FCoreBillEntryId)  B ");
                    if (isCheckCoreBill) {
                        sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                    } else {
                        sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                    }
                    sqlBuff.append("Where A.FQuarityUnCtrl = 0 ");
                    stmt = conn.prepareStatement(sqlBuff.toString());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                        if (fBaseQty == null || fBaseQty.signum() != -1) continue;
                        BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(fBaseQty);
                        if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                            if (isCheckCoreBill) {
                                hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                            } else {
                                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                            }
                            ++errors;
                        }
                        if (errors < 5) continue;
                        break;
                    }
                    if (errors > 0) {
                        if (isCheckCoreBill) {
                            this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEISSUE_QTY_NOMATHCH_STORETRANS);
                        } else {
                            this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.MOVEISSUE_QTY_NOMATHCH_STORETRANS);
                        }
                    }
                    break block17;
                }
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty, ");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEISSUEREVERSEQTY_NOMATCH_MOVEINWAREHS);
                }
                this.reversedCheck(ctx, invUpdPara);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void stockTransferCoreBillCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
            sqlBuff.append("B.FBaseQty as bFBaseQty, ");
            sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
            sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEISSUEREVERSEQTY_NOMATCH_MOVEINWAREHS2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    protected void reversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String billEntryTable = invUpdPara.getBillEntryTable();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - A.FReverseBaseQty - A.FTotalInWarehsQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM " + billEntryTable + " A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

