/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class PurInWarehsQtyRefCheck
extends AbstractCheckingItem {
    @Override
    protected String getInvCheckingItemName() {
        return "PurInWarehsQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws BOSException, EASBizException {
        TransactionTypeInfo transType;
        if (invUpdPara.getBizAction().getValue() != 103) {
            return;
        }
        String sourceBillType = invUpdPara.getSourceBillType();
        String coreBillType = invUpdPara.getCoreBillType();
        boolean isReversed = invUpdPara.isReversed();
        if (coreBillType.equals("220")) {
            TransactionTypeInfo transType2 = invUpdPara.getTransType();
            if (transType2.getRiType() == null || transType2.getRiType().getBizDirection().getValue() != -1) {
                this.purOrderCheck(ctx, invUpdPara);
            }
        } else if (coreBillType.equals("250")) {
            this.purReturnCheck(ctx, invUpdPara, true);
        } else if (coreBillType.equals("140")) {
            this.stockTransferCheck(ctx, invUpdPara);
        } else if (coreBillType.equals("141")) {
            this.transferOrderCheck(ctx, invUpdPara);
        } else if ("901".equals(coreBillType) && ((transType = invUpdPara.getTransType()).getRiType() == null || transType.getRiType().getBizDirection().getValue() != -1)) {
            this.subContractOrderCheck(ctx, invUpdPara);
        }
        if (sourceBillType.equals("101")) {
            this.purRecvCheck(ctx, invUpdPara);
        } else if (sourceBillType.equals("103")) {
            this.purInwarehsCheck(ctx, invUpdPara);
        } else if (!"140".equals(coreBillType) && !"141".equals(coreBillType) && "102".equals(sourceBillType)) {
            this.saleIssueCheck(ctx, invUpdPara);
        } else if (sourceBillType.equals("250") && !coreBillType.equals("250")) {
            this.purReturnCheck(ctx, invUpdPara, false);
        }
        if (isReversed) {
            if ("901".equals(coreBillType)) {
                this.reversedSubCheck(ctx, invUpdPara);
            } else {
                this.reversedCheck(ctx, invUpdPara);
            }
        }
    }

    protected void purOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                sqlBuff.append("- A.FTotalReceiptBaseQty - B.FBaseQty");
                sqlBuff.append(" + A.ftotalSupplyStockBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_SM_PurOrderEntry A INNER JOIN ");
                sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                sqlBuff.append(" inner join t_bd_multimeasureunit M ");
                sqlBuff.append(" on (A.FUnitID=M.fmeasureunitid and A.FMaterialID = M.FMaterialID)");
                sqlBuff.append("WHERE A.FIsQuantityUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.PURIN_QTY_NOMATHCH_PURORD);
                }
            }
            sqlBuff = new StringBuffer();
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("datediff(DD,A.FDeliveryDate,B.FBizDate) + A.FDeliverAdvanceDay as advanceDay,");
                sqlBuff.append("datediff(DD,B.FBizDate,A.FDeliveryDate) + A.FDeliverDeferralDay as deferralDay,");
                sqlBuff.append("dateadd(DD,-1*A.FDeliverAdvanceDay,A.FDeliveryDate) as advanceDate,");
                sqlBuff.append("dateadd(DD,A.FDeliverDeferralDay,A.FDeliveryDate) as deferralDate,");
                sqlBuff.append("B.FSeq as FSeq ");
                sqlBuff.append("FROM T_SM_PurOrderEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                sqlBuff.append("WHERE A.FIsTimeUnCtrl = 0 ");
                sqlBuff.append("AND A.FTotalReceiptQty < A.Fqty ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                String info = "; ";
                while (rs.next()) {
                    if (rs.getInt(1) >= 0 && rs.getInt(2) >= 0) continue;
                    StringBuffer dateRange = new StringBuffer();
                    dateRange.append("(").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(3).toString())).append(",").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(4).toString())).append(")");
                    info = info + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRangeInfo", (String[])new String[]{String.valueOf(rs.getInt(5)), dateRange.toString()});
                    throw new InvUpdateException(InvUpdateException.PURIN_DATE_NOMATHCH_PURORD, new String[]{info});
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void purReturnCheck(Context ctx, WriteBackParamInfo invUpdPara, boolean isCoreBill) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty - ISNULL(A.FReturnedBaseQty,0) - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_SM_PurReturnsEntry A INNER JOIN ");
                if (isCoreBill) {
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                } else {
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSOURCEBILLENTRYID as FCoreBillEntryId from  " + tempTableName + " group by FSOURCEBILLENTRYID)  B ");
                }
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1).signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.PURIN_QTY_NOMATHCH_PURRET);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void stockTransferCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FQuarityOverRate,0),21,8))/100,21,8) ");
                sqlBuff.append("- A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                sqlBuff.append("WHERE A.FQuarityUnCtrl = 0 ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.PURIN_QTY_NOMATHCH_MOVEISSUE);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        block15: {
            BizActionEnum bizAction;
            boolean isUnAudit;
            String sign = invUpdPara.isReversed() ? "+" : "-";
            TransactionTypeInfo transType = invUpdPara.getTransType();
            if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
                sign = sign.equals("+") ? "-" : "+";
            }
            boolean bl = isUnAudit = (bizAction = invUpdPara.getBizAction()).getValue() == 109;
            if (isUnAudit) {
                sign = sign.equals("+") ? "-" : "+";
            }
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            StringBuffer sqlBuff = new StringBuffer();
            boolean isReversed = invUpdPara.isReversed();
            String tempTableName = invUpdPara.getTempTableName();
            HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
            int errors = 0;
            try {
                ResultSet rs1;
                PreparedStatement stmt1;
                block16: {
                    conn = EJBFactory.getConnection((Context)ctx);
                    if (isReversed) break block15;
                    String checkFieldName = "";
                    if (SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction((TransactionTypeInfo)transType, (Context)ctx)) {
                        checkFieldName = "FRECEIPTBASEQTY";
                    } else if (SCMBaseCommonUtil.isInWarehsSubInvTransaction((TransactionTypeInfo)transType)) {
                        checkFieldName = "FTOTALPURRETURNBASEQTY";
                    }
                    sqlBuff.append("SELECT A.FBaseQty as afbaseqty, ");
                    sqlBuff.append("abs(A.FBaseQty) + decimal((decimal(abs(A.FBaseQty),21,8)*decimal(ISNULL(A.FQtyOverRate,0),21,8))/100,21,8) ");
                    sqlBuff.append(" - abs(A." + checkFieldName + ") ");
                    sqlBuff.append(" - abs(B.FBaseQty) as FBaseQty, ");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                    sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                    sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                    sqlBuff.append("WHERE A.fnotcontrolqty = 0");
                    stmt = conn.prepareStatement(sqlBuff.toString());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                        BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                        BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                        if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        if (++errors < 5) continue;
                        break;
                    }
                    if (errors > 0) {
                        this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.PURIN_QTY_NOMATHCH_MOVEISSUE);
                        break block15;
                    }
                    if (isUnAudit || !SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction((TransactionTypeInfo)transType, (Context)ctx)) break block15;
                    sqlBuff.setLength(0);
                    errors = 0;
                    hs.clear();
                    sqlBuff.append("SELECT ");
                    sqlBuff.append(" abs(decimal(A.FIssueBaseQty*(1 + decimal(ISNULL(A.FQtyOverRate,0)/100,21,8)),21,8)) ");
                    sqlBuff.append(" - abs(A.FReceiptBaseQty) ");
                    sqlBuff.append(" - abs(B.FBaseQty) as FBaseQty, ");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                    sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                    sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                    sqlBuff.append("WHERE A.fnotcontrolqty = 0");
                    stmt1 = null;
                    rs1 = null;
                    try {
                        stmt1 = conn.prepareStatement(sqlBuff.toString());
                        rs1 = stmt1.executeQuery();
                        while (rs1.next()) {
                            if (rs1.getBigDecimal("FBaseQty").signum() != -1) continue;
                            BigDecimal fBaseQty = rs1.getBigDecimal("FBaseQty");
                            BigDecimal allowQty = rs1.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                            if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                            hs.put(rs1.getString("FCoreBillEntryId"), rs1.getBigDecimal("FBaseQty"));
                            if (++errors < 5) continue;
                            break;
                        }
                        if (errors <= 0) break block16;
                        this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.TRANSFERORDER_RECEIPTQTY_NOMATHCH_ISSUEQTY);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs1, (Statement)stmt1);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs1, (Statement)stmt1);
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
            }
        }
    }

    protected void purInwarehsCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        TransactionTypeInfo transType = invUpdPara.getTransType();
        boolean isReturn = false;
        if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
            isReturn = true;
        }
        if (!isReturn) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FUnReturnedBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_IM_PurInwarehsEntry A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
                sqlBuff.append("inner join t_im_purinwarehsbill bill on bill.fid = A.fparentid and bill.fpurchasetype=0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.PURINWAREHSRTQTY_NOTENOUGH);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void purRecvCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        String coreBillType = invUpdPara.getCoreBillType();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        NumericExceptionSubItem errorTip = InvUpdateException.PURIN_QTY_NOMATHCH_PURRCV;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                StringBuffer sql = new StringBuffer();
                String FSourceBillId = "";
                boolean isManuRec = false;
                sql.append("select top 1 a.FSourceBillId as FSourceBillId from ").append(tempTableName).append(" t,").append("T_IM_PurReceivalEntry a where a.fid = t.FSourceBillEntryId ");
                JdbcRowSet rowSet = (JdbcRowSet)DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    FSourceBillId = rowSet.getString("FSourceBillId");
                }
                if (FSourceBillId == null || FSourceBillId.equals("")) {
                    isManuRec = true;
                }
                if (isManuRec) {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("abs(A.FBaseQty) + decimal((decimal(abs(A.FBaseQty) - abs(A.freversebaseqty),21,8)*decimal(ISNULL(abs(B.FReceiveOverRate),0),21,8))/100,21,8) ").append("- abs(A.FReceiptBaseQty) - abs(A.freversebaseqty) - abs(A.FCheckReturnedBaseQty) - abs(B.FBaseQty) as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                    sqlBuff.append("FROM T_IM_PurReceivalEntry A INNER JOIN ");
                    sqlBuff.append("(select sum(t.FBaseQty) as FBaseQty,").append("max(isnull(d.FReceiveTopRatio,0)) as FReceiveOverRate,").append("t.FSourceBillEntryId as FSourceBillEntryId ").append("from  ").append(tempTableName).append(" t ").append("left join T_ORG_UnitRelation b  on t.fstorageorgunitid = b.ffromunitid ").append("left join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID  ").append("left join T_BD_MaterialPurchasing d ").append(" on d.fmaterialid = t.fmaterialid and d.forgunit = b.ftounitid  ").append("where ").append("c.FFromType = ").append(4).append(" ").append("and c.FToType = ").append(3).append(" ").append("and b.fisdefault = 1 ").append("group by t.FSourceBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                } else if (coreBillType != null && coreBillType.equals("220")) {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(C.FReceiveOverRate,0),21,8))/100,21,8)");
                    sqlBuff.append(" - A.FReceiptBaseQty - A.freversebaseqty - A.FCheckReturnedBaseQty - B.FBaseQty as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                    sqlBuff.append("FROM T_IM_PurReceivalEntry A  ");
                    sqlBuff.append("LEFT JOIN T_SM_PurOrderEntry C ON  C.FID =  A.FPurOrderEntryID INNER JOIN ");
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                    sqlBuff.append("WHERE ( C.FIsQuantityUnCtrl = 0 or C.FIsQuantityUnCtrl is null)");
                } else if (coreBillType != null && coreBillType.equals("901")) {
                    sqlBuff.append("SELECT ").append("\r\n");
                    sqlBuff.append("A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)").append("\r\n");
                    sqlBuff.append("*decimal(ISNULL(C.FReceiveOverRate,0),21,8))/100,21,8)").append("\r\n");
                    sqlBuff.append(" - A.FReceiptBaseQty - A.freversebaseqty -A.FCheckReturnedBaseQty- B.FBaseQty as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                    sqlBuff.append("FROM T_IM_PurReceivalEntry A  ");
                    sqlBuff.append("LEFT JOIN T_SM_SubContractOrderEntry C ON  (C.FID =  A.FPurOrderEntryID OR C.FID =  A.FSOURCEBILLENTRYID) INNER JOIN ");
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                    sqlBuff.append("WHERE ( C.FIsQtyUnCtrl = 0 or C.FIsQtyUnCtrl is null)");
                    errorTip = InvUpdateException.SUBIN_QTY_NOMATHCH_SUBREC;
                } else {
                    return;
                }
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1).signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, errorTip);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void saleIssueCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FUnInBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_IM_SaleIssueEntry A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() > 0) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.PURINWAREHS_QTY_NOMATH_SALEISSUE);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    @Override
    protected void reversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("ABS(A.FUnWriteOffBaseQty) - B.FBaseQty as FBaseQty,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_PurInWarehsEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            sqlBuff.append("WHERE A.FIsPresent = 0 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() == -1) {
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                }
                if (errors < 5) continue;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - A.FReverseBaseQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_PurInWarehsEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            sqlBuff.append("WHERE A.FIsPresent = 1 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void subContractOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FTotalInStockNeedBaseQty + A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                sqlBuff.append(" - B.FBaseQty - A.FTotalReceiptBaseQty  as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM t_sm_subcontractorderentry A INNER JOIN ");
                sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from " + tempTableName + " group by FCoreBillEntryId) B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                sqlBuff.append("WHERE A.FIsQtyUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.SUBIN_QTY_NOMATHCH_SUBORD);
                }
            }
            sqlBuff = new StringBuffer();
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("datediff(DD,A.FDeliveryDate,B.FBizDate) + A.FDeliverAdvanceDay as advanceDay,");
                sqlBuff.append("datediff(DD,B.FBizDate,A.FDeliveryDate) + A.FDeliverDeferralDay as deferralDay,");
                sqlBuff.append("dateadd(DD,-1*A.FDeliverAdvanceDay,A.FDeliveryDate) as advanceDate,");
                sqlBuff.append("dateadd(DD,A.FDeliverDeferralDay,A.FDeliveryDate) as deferralDate,");
                sqlBuff.append("B.FSeq as FSeq ");
                sqlBuff.append("FROM t_sm_subcontractorderentry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                sqlBuff.append("WHERE A.FIsTimeUnCtrl = 0");
                sqlBuff.append(" and A.FTotalReceiptQty < A.FQty ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                String[] infoStr = new String[]{""};
                String info = "; ";
                while (rs.next()) {
                    if (rs.getInt(1) >= 0 && rs.getInt(2) >= 0) continue;
                    StringBuffer dateRange = new StringBuffer();
                    dateRange.append("(").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(3).toString())).append(",").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(4).toString())).append(")");
                    info = info + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRangeInfo", (String[])new String[]{String.valueOf(rs.getInt(5)), dateRange.toString()});
                    throw new InvUpdateException(InvUpdateException.SUBIN_DATE_NOMATHCH_SUBORD, new String[]{info});
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    private void reversedSubCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("ABS(A.FUnWriteOffBaseQty) - B.FBaseQty as FBaseQty,");
            sqlBuff.append("ABS(A.FSCUnWrittenOffBaseQty) - B.FBaseQty as FScBaseQty,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId,");
            sqlBuff.append("A.FDosingType as FDosingType ");
            sqlBuff.append("FROM T_IM_PurInWarehsEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            sqlBuff.append("WHERE A.FIsPresent = 0 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            BigDecimal fBaseQty = SCMConstant.BIGDECIMAL_ZERO;
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() == -1 || rs.getBigDecimal("FScBaseQty").signum() == -1) {
                    if (4 == rs.getInt("FDosingType") || 4 == rs.getInt("FDosingType")) {
                        fBaseQty = rs.getBigDecimal("FBaseQty");
                        if (fBaseQty.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                            hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("bFBaseQty"));
                            ++errors;
                        }
                    } else {
                        fBaseQty = rs.getBigDecimal("FBaseQty").compareTo(rs.getBigDecimal("FScBaseQty")) < 0 ? rs.getBigDecimal("FBaseQty") : rs.getBigDecimal("FScBaseQty");
                        BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                        if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                            hs.put(rs.getString("FSourceBillEntryId"), fBaseQty);
                            ++errors;
                        }
                    }
                }
                if (errors < 5) continue;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - A.FReverseBaseQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_PurInWarehsEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            sqlBuff.append("WHERE A.FIsPresent = 1 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

