/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRecvQtyRefCheck
extends AbstractCheckingItem {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.invupdate.PurRecvQtyRefCheck");

    @Override
    protected String getInvCheckingItemName() {
        return "PurRecvQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        String sourceBillType = invUpdPara.getSourceBillType();
        String coreBillType = invUpdPara.getCoreBillType();
        if (invUpdPara.getBizAction().getValue() == 103) {
            if (sourceBillType.equals("220")) {
                this.purRecvCheck(ctx, invUpdPara);
            } else if ("901".equals(sourceBillType)) {
                this.subContractRecvCheck(ctx, invUpdPara);
            } else if ("101".equals(sourceBillType)) {
                this.purReversedCheck(ctx, invUpdPara);
            }
        } else if (invUpdPara.getBizAction().getValue() == 109) {
            String tableName = null;
            if ("101".equals(sourceBillType) && "220".equals(coreBillType)) {
                tableName = "T_SM_PurOrderEntry";
                this.purQtyCheck(ctx, invUpdPara, tableName, true);
            } else if ("101".equals(sourceBillType) && "901".equals(coreBillType)) {
                tableName = "t_sm_subcontractorderentry";
                this.purQtyCheck(ctx, invUpdPara, tableName, false);
            }
        }
    }

    protected void purQtyCheck(Context ctx, WriteBackParamInfo invUpdPara, String tableName, Boolean isPurOrder) throws InvUpdateException, BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block10: {
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sqlBuff = new StringBuffer();
            boolean isReversed = invUpdPara.isReversed();
            String tempTableName = invUpdPara.getTempTableName();
            HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
            int errors = 0;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                sqlBuff.append("SELECT ");
                if (isPurOrder.booleanValue()) {
                    sqlBuff.append("A.FTotalSupplyStockBaseQty + A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                } else {
                    sqlBuff.append("A.FTotalInStockNeedBaseQty + A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                }
                sqlBuff.append("- A.FTotalReceiveBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryID as FCoreBillEntryID ");
                sqlBuff.append("FROM ").append(tableName).append(" A INNER JOIN ");
                sqlBuff.append("(select  decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryID as FCoreBillEntryID from  " + tempTableName + " group by FCoreBillEntryID)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryID  ");
                if (isPurOrder.booleanValue()) {
                    sqlBuff.append("WHERE A.FIsQuantityUnCtrl = 0");
                } else {
                    sqlBuff.append("WHERE A.FIsQtyUnCtrl = 0");
                }
                logger.info((Object)sqlBuff);
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    logger.info((Object)("rs.getBigDecimal(FBaseQty).signum():" + rs.getBigDecimal("FBaseQty").signum()));
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    logger.info((Object)("fBaseQty.abs().subtract(allowQty).signum():" + fBaseQty.abs().subtract(allowQty).signum()));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FCoreBillEntryID"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors <= 0) break block10;
                if (isPurOrder.booleanValue()) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.PURREV_QTY_NOMATCH_PURORD, "FCoreBillEntryID");
                    break block10;
                }
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SUBREC_QTY_NOMATHCH_SUBORD, "FCoreBillEntryID");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void purRecvCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            BigDecimal allowQty;
            BigDecimal fBaseQty;
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                logger.info((Object)"--------------Test----------");
                logger.info((Object)"--------------Begin to Check qty----------");
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FTotalSupplyStockBaseQty + A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                sqlBuff.append("- A.FTotalReceiveBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_SM_PurOrderEntry A INNER JOIN ");
                sqlBuff.append("(select  decimal(sum(FBaseQty),21,8) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                sqlBuff.append("WHERE A.FIsQuantityUnCtrl = 0");
                logger.info((Object)sqlBuff);
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    logger.info((Object)("rs.getBigDecimal(FBaseQty).signum():" + rs.getBigDecimal("FBaseQty").signum()));
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    fBaseQty = rs.getBigDecimal("FBaseQty");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    logger.info((Object)("fBaseQty.abs().subtract(allowQty).signum():" + fBaseQty.abs().subtract(allowQty).signum()));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.PURREV_QTY_NOMATCH_PURORD, "FSourceBillEntryId");
                }
            } else {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty - A.FReverseBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_IM_PurReceivalEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    fBaseQty = rs.getBigDecimal("FBaseQty");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE, "FSourceBillEntryId");
                }
                this.reversedCheck(ctx, invUpdPara);
            }
            sqlBuff = new StringBuffer();
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("datediff(DD,A.FDeliveryDate,B.FBizDate) + A.FDeliverAdvanceDay as advanceDay,");
                sqlBuff.append("datediff(DD,B.FBizDate,A.FDeliveryDate) + A.FDeliverDeferralDay as deferralDay,");
                sqlBuff.append("dateadd(DD,-1*A.FDeliverAdvanceDay,A.FDeliveryDate) as advanceDate,");
                sqlBuff.append("dateadd(DD,A.FDeliverDeferralDay,A.FDeliveryDate) as deferralDate,");
                sqlBuff.append("B.FSeq as FSeq ");
                sqlBuff.append("FROM T_SM_PurOrderEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
                sqlBuff.append("WHERE A.FIsTimeUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                String info = "; ";
                while (rs.next()) {
                    if (rs.getInt(1) >= 0 && rs.getInt(2) >= 0) continue;
                    StringBuffer dateRange = new StringBuffer();
                    dateRange.append("(").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(3).toString())).append(",").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(4).toString())).append(")");
                    info = info + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRangeInfo", (String[])new String[]{String.valueOf(rs.getInt(5)), dateRange.toString()});
                    throw new InvUpdateException(InvUpdateException.PURREV_DATE_NOMATCH_PURORD, new String[]{info});
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void purReversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - abs(A.FReverseBaseQty) - abs(A.FReceiptBaseQty) - abs(A.FCheckReturnedBaseQty) - abs(B.FBaseQty)  as FBaseQty,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_PurReceivalEntry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            sqlBuff.append(" ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.PURREC_QTY_NOMATHCH_PURRCV, "FSourceBillEntryId");
            }
            this.reversedCheck(ctx, invUpdPara);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void showQtyRefCheckError(Context ctx, String tempTable, HashMap errorHs, NumericExceptionSubItem numException, String billEntryId) throws InvUpdateException, BOSException {
        IRowSet rs = null;
        Set keyset = errorHs.keySet();
        StringBuffer errorStr = new StringBuffer();
        String sql = "";
        String sqlin = "";
        Object[] errorArr = new String[1];
        String locName = this.getLocName(ctx);
        String fsourcebillentryid2 = "";
        HashMap<String, String> hsSeq = new HashMap<String, String>();
        HashMap<String, String> hsContent = new HashMap<String, String>();
        try {
            Iterator it = keyset.iterator();
            boolean isfirst = true;
            while (it.hasNext()) {
                sqlin = sqlin + ",'" + (String)it.next() + "'";
            }
            sqlin = sqlin.substring(1);
            String sqlStr = sql = "select  d.fseq as fseq,d." + billEntryId + " as " + billEntryId + ",a." + locName + " as fmaterialname,c." + locName + " as funitname ,b.FBaseConvsRate as FBaseConvsRate,b.FQtyPrecision as FQtyPrecision from " + tempTable + " d  left join t_bd_material a on    a.fid = d.fmaterialid left join t_bd_multimeasureunit b on b.fmaterialid = d.fmaterialid and b.fmeasureunitid = d.funitid  left join t_bd_measureunit c on c.fid = d.funitid  where  d." + billEntryId + " in (" + sqlin + ") order by d.fseq ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"QtyCheckError", (Context)ctx);
            while (rs.next()) {
                String qtyStr;
                BigDecimal qty;
                String content;
                fsourcebillentryid2 = rs.getString(billEntryId);
                if (hsSeq.containsKey(fsourcebillentryid2)) {
                    String fseq = (String)hsSeq.get(fsourcebillentryid2);
                    fseq = fseq + "," + String.valueOf(rs.getInt("fseq"));
                    hsSeq.put(fsourcebillentryid2, fseq);
                    continue;
                }
                hsSeq.put(fsourcebillentryid2, String.valueOf(rs.getInt("fseq")));
                if (rs.getString("fmaterialname") != null) {
                    content = rs.getString("fmaterialname");
                    qty = (BigDecimal)errorHs.get(fsourcebillentryid2);
                    qty = qty.setScale(rs.getInt("FQtyPrecision"), 4);
                    qty = qty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), 4);
                    qtyStr = InvAppUtils.getDecimalFormatString(ctx, qty, qty.scale());
                    content = MessageFormat.format(errorMsg, hsSeq.get(fsourcebillentryid2), rs.getString("fmaterialname"), qtyStr, rs.getString("funitname"));
                    if (qty.signum() == 0 && isfirst) {
                        String measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                        content = content + "\n" + measureUnitTransError;
                        isfirst = false;
                    }
                    hsContent.put(fsourcebillentryid2, content);
                    continue;
                }
                content = "";
                qty = (BigDecimal)errorHs.get(fsourcebillentryid2);
                qty = qty.abs();
                qtyStr = InvAppUtils.getDecimalFormatString(ctx, qty, qty.scale());
                String materialName = rs.getString("fmaterialname");
                if (materialName == null) {
                    materialName = rs.getString("FNoNumMaterialName");
                }
                content = MessageFormat.format(errorMsg, hsSeq.get(fsourcebillentryid2), materialName, qtyStr, rs.getString("funitname"));
                if (qty.signum() == 0 && isfirst) {
                    String measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                    content = content + "\n" + measureUnitTransError;
                    isfirst = false;
                }
                hsContent.put(fsourcebillentryid2, content);
            }
            for (String fsourcebillentryid2 : keyset) {
                errorStr.append("\n");
                errorStr.append((String)hsContent.get(fsourcebillentryid2));
            }
            errorArr[0] = errorStr.toString();
            throw new InvUpdateException(numException, errorArr);
        }
        catch (SQLException ex) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
        }
    }

    protected void subContractRecvCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            BigDecimal allowQty;
            BigDecimal fBaseQty;
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FTotalInStockNeedBaseQty + A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(A.FReceiveOverRate,0),21,8))/100,21,8) ");
                sqlBuff.append("- A.FTotalReceiveBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM t_sm_subcontractorderentry A INNER JOIN ");
                sqlBuff.append("(select  decimal(sum(FBaseQty),21,8) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                sqlBuff.append("WHERE A.FIsQtyUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    fBaseQty = rs.getBigDecimal("FBaseQty");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SUBREC_QTY_NOMATHCH_SUBORD, "FSourceBillEntryId");
                }
            } else {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty - A.FReverseBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM t_im_purreceivalentry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    fBaseQty = rs.getBigDecimal("FBaseQty");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE, "FSourceBillEntryId");
                }
                this.reversedCheck(ctx, invUpdPara);
            }
            sqlBuff = new StringBuffer();
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("datediff(DD,A.FDeliveryDate,B.FBizDate) + A.FDeliverAdvanceDay as advanceDay,");
                sqlBuff.append("datediff(DD,B.FBizDate,A.FDeliveryDate) + A.FDeliverDeferralDay as deferralDay,");
                sqlBuff.append("dateadd(DD,-1*A.FDeliverAdvanceDay,A.FDeliveryDate) as advanceDate,");
                sqlBuff.append("dateadd(DD,A.FDeliverDeferralDay,A.FDeliveryDate) as deferralDate,");
                sqlBuff.append("B.FSeq as FSeq ");
                sqlBuff.append("FROM t_sm_subcontractorderentry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
                sqlBuff.append("WHERE A.FIsTimeUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                String info = "; ";
                while (rs.next()) {
                    if (rs.getInt(1) >= 0 && rs.getInt(2) >= 0) continue;
                    StringBuffer dateRange = new StringBuffer();
                    dateRange.append("(").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(3).toString())).append(",").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(4).toString())).append(")");
                    info = info + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRangeInfo", (String[])new String[]{String.valueOf(rs.getInt(5)), dateRange.toString()});
                    throw new InvUpdateException(InvUpdateException.PURREV_DATE_NOMATCH_PURORD, new String[]{info});
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

