/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.AbstractCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class SaleIssueQtyRefCheck
extends AbstractCheckingItem {
    @Override
    protected String getInvCheckingItemName() {
        return "SaleIssueQtyRefCheck";
    }

    @Override
    protected void doCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        String sourceBillType = invUpdPara.getSourceBillType();
        String coreBillType = invUpdPara.getCoreBillType();
        String bizTypeId = invUpdPara.getBizType();
        TransactionTypeInfo transType = invUpdPara.getTransType();
        boolean isReturn = false;
        if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
            isReturn = true;
        }
        if (invUpdPara.bizAction.getValue() == 109) {
            if (coreBillType.equals("140")) {
                this.stockTransferCoreBillCheck(ctx, invUpdPara);
            } else if (coreBillType.equals("141") && !isReturn) {
                this.transferOrderCoreBillCheck(ctx, invUpdPara);
            }
            return;
        }
        if (sourceBillType.equals("320") || sourceBillType.equals("190")) {
            this.saleSendCheck(ctx, invUpdPara);
        } else if (sourceBillType.equals("102")) {
            if (!bizTypeId.equals("d8e80652-0113-1000-e000-04c5c0a812202407435C") || transType.getRiType().getBizDirection().getValue() != 1) {
                this.saleIssueRtCheck(ctx, invUpdPara);
            }
        } else if (sourceBillType.equals("350")) {
            this.saleReturnCheck(ctx, invUpdPara);
        }
        if (coreBillType.equals("310")) {
            boolean isSettlementSale = false;
            if ("102".equals(sourceBillType) && transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == 1 && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                isSettlementSale = true;
            }
            if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
                isReturn = true;
            }
            if (!isReturn && !isSettlementSale) {
                this.saleOrderCheck(ctx, invUpdPara);
            }
            if (sourceBillType.equals("350")) {
                this.saleReturnCheck(ctx, invUpdPara);
            }
        } else if (coreBillType.equals("350")) {
            if (!sourceBillType.equals("102")) {
                this.saleReturnCheck(ctx, invUpdPara);
            }
        } else if (coreBillType.equals("140")) {
            this.stockTransferCheck(ctx, invUpdPara);
        } else if (coreBillType.equals("141")) {
            this.transferOrderCheck(ctx, invUpdPara);
        }
        boolean isReversed = invUpdPara.isReversed();
        if (isReversed) {
            this.reversedCheck(ctx, invUpdPara);
        }
    }

    protected void saleOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                BizActionEnum bizAction;
                boolean isUnAudit;
                String sign = invUpdPara.isReversed() ? "+" : "-";
                TransactionTypeInfo transType = invUpdPara.getTransType();
                if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
                    sign = sign.equals("+") ? "-" : "+";
                }
                boolean bl = isUnAudit = (bizAction = invUpdPara.getBizAction()).getValue() == 109;
                if (isUnAudit) {
                    sign = sign.equals("+") ? "-" : "+";
                }
                sqlBuff.append("SELECT A.FBaseQty as afbaseqty, ");
                sqlBuff.append(" decimal((decimal((isnull(A.FBaseQty,0) - isnull(A.FTotalReversedBaseQty,0)),21,8)*decimal((1+ISNULL(A.FSendOverRate,0)/100),21,8)),21,8) ");
                sqlBuff.append(" - isnull(A.FTotalIssueBaseQty,0) ");
                sqlBuff.append(" + round(decimal(isnull(A.FTotalSupplyStockQty,0)*isnull(M.FBaseConvsRate,0),21,8),isnull(baseM.FQtyPrecision,0)) ");
                sqlBuff.append(sign).append(" isnull(B.FBaseQty,0) as FBaseQty, ");
                sqlBuff.append("isnull(B.FBaseQty,0) as bFBaseQty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_SD_SaleOrderEntry A INNER JOIN ");
                sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                sqlBuff.append(" inner join t_bd_multimeasureunit M ");
                sqlBuff.append(" on (A.FUnitID=M.fmeasureunitid and A.FMaterialID = M.FMaterialID)");
                sqlBuff.append(" inner join t_bd_multimeasureunit baseM ");
                sqlBuff.append(" on (A.FBaseUnitID = baseM.fmeasureunitid and A.FMaterialID = baseM.FMaterialID) ");
                sqlBuff.append(" WHERE A.FQuantityUnCtrl = 0");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() == rs.getBigDecimal("afbaseqty").signum()) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                    hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    if (++errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_SALEORD);
                }
            }
            sqlBuff = new StringBuffer();
            if (!isReversed) {
                TransactionTypeInfo transType = invUpdPara.getTransType();
                if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
                } else {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("datediff(DD,A.FSendDate,B.FBizDate) + ISNULL(A.FSendAdvanceDay,0) AS advanceDay,");
                    sqlBuff.append("datediff(DD,B.FBizDate,A.FSendDate) + ISNULL(A.FSendDeferralDay,0) AS deferralDay,");
                    sqlBuff.append("dateadd(DD,-1 * ISNULL(A.FSendAdvanceDay,0),A.FSendDate) as advanceDate,");
                    sqlBuff.append("dateadd(DD,ISNULL(A.FSendDeferralDay,0),A.FSendDate) as deferralDate,");
                    sqlBuff.append("B.FSeq as FSeq ");
                    sqlBuff.append("FROM T_SD_SaleOrderEntry A INNER JOIN ");
                    sqlBuff.append(" " + tempTableName + " B ");
                    sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                    sqlBuff.append("WHERE A.FTimeUnCtrl = 0");
                    stmt = conn.prepareStatement(sqlBuff.toString());
                    rs = stmt.executeQuery();
                    String info = "; ";
                    while (rs.next()) {
                        if (rs.getInt(1) >= 0 && rs.getInt(2) >= 0) continue;
                        StringBuffer dateRange = new StringBuffer();
                        dateRange.append("(").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(3).toString())).append(",").append(DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getDate(4).toString())).append(")");
                        info = info + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AllowDateRangeInfo", (String[])new String[]{String.valueOf(rs.getInt(5)), dateRange.toString()});
                        throw new InvUpdateException(InvUpdateException.SALEISSU_DATE_NOMATCH_SALEORD, new String[]{info});
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void saleSendCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                String coreBillType = invUpdPara.getCoreBillType();
                if (coreBillType.equals("141")) {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("A.FBaseQty + decimal((decimal(A.FBaseQty,21,8)*decimal(ISNULL(C.FQtyOverRate,0),21,8))/100,21,8) ");
                    sqlBuff.append("- isnull(A.FTotalReversedBaseQty,0) - A.FShippedBaseQty - B.FBaseQty as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                    sqlBuff.append("FROM T_SD_PostRequisitionEntry A INNER JOIN ");
                    sqlBuff.append("T_IM_TransferOrderBillEntry C ON C.FID =  A.FStockTransferBillEntryID INNER JOIN ");
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                    sqlBuff.append("WHERE C.FNotControlQty = 0");
                } else if (coreBillType.equals("310")) {
                    String sourceBillType = invUpdPara.getSourceBillType();
                    if (sourceBillType.equals("190")) {
                        sqlBuff.append("SELECT ");
                        sqlBuff.append("decimal((decimal((isnull(A.FBaseQty,0) - isnull(A.FTotalReversedBaseQty,0)),21,8)*decimal((1+ISNULL(C.FSendOverRate,0)/100),21,8)),21,8) - ISNULL(A.FShippedBaseQty,0) - ISNULL(B.FBaseQty,0) as FBaseQty,");
                        sqlBuff.append("B.FBaseQty as bFBaseQty,");
                        sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                        sqlBuff.append("FROM T_SD_PostRequisitionEntry A INNER JOIN ");
                        sqlBuff.append("T_SD_SaleOrderEntry C ON C.FID =  A.FSaleOrderEntryID INNER JOIN ");
                        sqlBuff.append("(select sum(tempTbl.FBaseQty) as FBaseQty,CE.FSourceBillEntryId as FSourceBillEntryId from ");
                        sqlBuff.append(tempTableName).append(" tempTbl inner join T_DT_CARRYBILLENTRY CE on CE.fid = tempTbl.FSourceBillEntryId ");
                        sqlBuff.append("group by CE.FSourceBillEntryId)  B ");
                        sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                        sqlBuff.append("WHERE C.FQuantityUnCtrl = 0");
                    } else {
                        sqlBuff.append("SELECT ");
                        sqlBuff.append("decimal((decimal((isnull(A.FBaseQty,0) - isnull(A.FTotalReversedBaseQty,0)),21,8)*decimal((1+ISNULL(C.FSendOverRate,0)/100),21,8)),21,8) - ISNULL(A.FShippedBaseQty,0) - ISNULL(B.FBaseQty,0) as FBaseQty,");
                        sqlBuff.append("B.FBaseQty as bFBaseQty,");
                        sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                        sqlBuff.append("FROM T_SD_PostRequisitionEntry A INNER JOIN ");
                        sqlBuff.append("T_SD_SaleOrderEntry C ON C.FID =  A.FSaleOrderEntryID INNER JOIN ");
                        sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                        sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                        sqlBuff.append("WHERE C.FQuantityUnCtrl = 0");
                    }
                } else {
                    sqlBuff.append("SELECT ");
                    sqlBuff.append("A.FBaseQty - isnull(A.FTotalReversedBaseQty,0) - A.FShippedBaseQty - B.FBaseQty as FBaseQty,");
                    sqlBuff.append("B.FBaseQty as bFBaseQty,");
                    sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                    sqlBuff.append("FROM T_SD_PostRequisitionEntry A INNER JOIN ");
                    sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                    sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                }
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1).signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    if (coreBillType.equals("141")) {
                        this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_POSTREQUISITION);
                    } else if (coreBillType.equals("310")) {
                        this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_POSTREQUISITION);
                    } else {
                        this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_POSTREQUISITION);
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void saleReturnCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty - A.FReturnsBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_SD_SaleReturnsEntry A INNER JOIN ");
                sqlBuff.append("T_SD_SaleReturns C on A.FParentID = C.FId INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                sqlBuff.append(" where A.FQuantityUnCtrl = 0 ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1).signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_SALERT);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void stockTransferCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FBaseQty - A.FIssueBaseQty - B.FBaseQty as fbaseqty,");
                sqlBuff.append("B.FBaseQty as bfbaseqty,");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("fbaseqty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_STORETRANS);
                }
            } else {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty, ");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEIN_QTY_NOMATHCH_MOVEISSUE);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferOrderCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block20: {
            BizActionEnum bizAction;
            boolean isUnAudit;
            if (invUpdPara.isReversed() && "141".equals(invUpdPara.getCoreBillType())) {
                return;
            }
            String sign = invUpdPara.isReversed() ? "+" : "-";
            TransactionTypeInfo transType = invUpdPara.getTransType();
            if (transType.getRiType() != null && transType.getRiType().getBizDirection().getValue() == -1) {
                sign = sign.equals("+") ? "-" : "+";
            }
            boolean bl = isUnAudit = (bizAction = invUpdPara.getBizAction()).getValue() == 109;
            if (isUnAudit) {
                sign = sign.equals("+") ? "-" : "+";
            }
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sqlBuff = new StringBuffer();
            boolean isReversed = invUpdPara.isReversed();
            String tempTableName = invUpdPara.getTempTableName();
            HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
            int errors = 0;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (!isReversed) {
                    ResultSet rs1;
                    PreparedStatement stmt1;
                    block21: {
                        String checkFieldName = "";
                        if (SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)transType)) {
                            checkFieldName = "FISSUEBASEQTY";
                        } else if (SCMBaseCommonUtil.isIssueWarehsAddInvTransaction((TransactionTypeInfo)transType)) {
                            checkFieldName = "FTOTALSALERETURNBASEQTY";
                        }
                        sqlBuff.append("SELECT  abs(A.FBaseQty) as afbaseqty,");
                        sqlBuff.append("abs(A." + checkFieldName + "),");
                        sqlBuff.append("abs(A.FBaseQty)  - abs(A." + checkFieldName + ")  + decimal((decimal(abs(A.FBaseQty),21,8)*decimal(A.FQtyOverRate,21,8))/100,21,8) ");
                        sqlBuff.append(" - abs(B.FBaseQty) as fbaseqty,");
                        sqlBuff.append("abs(B.FBaseQty) as bfbaseqty,");
                        sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                        sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                        sqlBuff.append("(select decimal(sum(abs(FBaseQty)),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                        sqlBuff.append("ON A.FID = B.FCoreBillEntryId");
                        sqlBuff.append(" and FNotControlQty = 0 ");
                        stmt = conn.prepareStatement(sqlBuff.toString());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            if (rs.getBigDecimal("fbaseqty").signum() != -1) continue;
                            BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                            BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                            if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                                hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                                ++errors;
                            }
                            if (errors < 5) continue;
                            break;
                        }
                        if (errors > 0) {
                            this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.SALEISSU_QTY_NOMATCH_POSTREQ);
                            break block20;
                        }
                        if (!isUnAudit || !SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)transType)) break block20;
                        sqlBuff.setLength(0);
                        errors = 0;
                        hs.clear();
                        sqlBuff.append("SELECT ");
                        sqlBuff.append(" abs(A.FIssueBaseQty) ");
                        sqlBuff.append(" - abs(A.FReceiptBaseQty) ");
                        sqlBuff.append(" - abs(B.FBaseQty) as FBaseQty, ");
                        sqlBuff.append("B.FBaseQty as bFBaseQty,");
                        sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                        sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                        sqlBuff.append("(select decimal(sum(FBaseQty),21,8) as FBaseQty,FCoreBillEntryId as FCoreBillEntryId from  " + tempTableName + " group by FCoreBillEntryId)  B ");
                        sqlBuff.append("ON A.FID = B.FCoreBillEntryId  ");
                        sqlBuff.append("WHERE A.fnotcontrolqty = 0");
                        stmt1 = null;
                        rs1 = null;
                        try {
                            stmt1 = conn.prepareStatement(sqlBuff.toString());
                            rs1 = stmt1.executeQuery();
                            while (rs1.next()) {
                                if (rs1.getBigDecimal("FBaseQty").signum() != -1) continue;
                                BigDecimal fBaseQty = rs1.getBigDecimal("FBaseQty");
                                BigDecimal allowQty = rs1.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                                if (fBaseQty.abs().subtract(allowQty).signum() != 1) continue;
                                hs.put(rs1.getString("FCoreBillEntryId"), rs1.getBigDecimal("FBaseQty"));
                                if (++errors < 5) continue;
                                break;
                            }
                            if (errors <= 0) break block21;
                            this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.TRANSFERORDER_RECEIPTQTY_NOMATHCH_ISSUEQTY);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs1, (Statement)stmt1);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs1, (Statement)stmt1);
                    break block20;
                }
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty, ");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                sqlBuff.append(" " + tempTableName + " B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEIN_QTY_NOMATHCH_MOVEISSUE);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void stockTransferCoreBillCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed && invUpdPara.bizAction.getValue() == 109) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty, ");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_StockTransferBillEntry A INNER JOIN ");
                sqlBuff.append(" (select sum(fbaseqty) as fbaseqty,FCoreBillEntryId as FCoreBillEntryId from " + tempTableName + " group by FCoreBillEntryId ) B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEIN_QTY_NOMATHCH_MOVEISSUE);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void transferOrderCoreBillCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed && invUpdPara.bizAction.getValue() == 109) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("A.FIssueBaseQty - A.FReceiptBaseQty - B.FBaseQty as FBaseQty, ");
                sqlBuff.append("B.FBaseQty as bFBaseQty, ");
                sqlBuff.append("B.FCoreBillEntryId as FCoreBillEntryId ");
                sqlBuff.append("FROM T_IM_TransferOrderBillEntry A INNER JOIN ");
                sqlBuff.append(" (select sum(fbaseqty) as fbaseqty,FCoreBillEntryId as FCoreBillEntryId from " + tempTableName + " group by FCoreBillEntryId ) B ");
                sqlBuff.append("ON A.FID = B.FCoreBillEntryId ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal("FBaseQty").signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FCoreBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError2(ctx, tempTableName, hs, InvUpdateException.MOVEISSUEREVERSEQTY_NOMATCH_MOVEINWAREHS2);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    protected void saleIssueRtCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        boolean isReversed = invUpdPara.isReversed();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("abs(A.FBaseQty) - A.FReturnBaseQty - A.FReverseBaseQty - B.FBaseQty as FBaseQty,");
                sqlBuff.append("B.FBaseQty as bFBaseQty,");
                sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
                sqlBuff.append("FROM T_IM_SaleIssueEntry A INNER JOIN ");
                sqlBuff.append("(select sum(FBaseQty) as FBaseQty,FSourceBillEntryId as FSourceBillEntryId from  " + tempTableName + " group by FSourceBillEntryId)  B ");
                sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
                stmt = conn.prepareStatement(sqlBuff.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1).signum() != -1) continue;
                    BigDecimal fBaseQty = rs.getBigDecimal("FBaseQty");
                    BigDecimal allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                    if (errors < 5) continue;
                    break;
                }
                if (errors > 0) {
                    this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALERT_NOMATHCH_SALEISSUE);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    @Override
    protected void reversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        int errors2 = 0;
        try {
            BigDecimal allowQty;
            BigDecimal fBaseQty;
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("ABS(A.FUnWriteOffBaseQty) - B.FBaseQty as FBaseQty,");
            sqlBuff.append("abs(A.FBaseQty) - A.FTotalInWarehsQty - B.FBaseQty as FBaseQty2,");
            sqlBuff.append("B.FBaseQty as bFBaseQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM T_IM_Saleissueentry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId  ");
            sqlBuff.append("WHERE A.FIsPresent = 0 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() == -1) {
                    fBaseQty = rs.getBigDecimal("FBaseQty");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                        ++errors;
                    }
                }
                if (errors >= 5) break;
                if (rs.getBigDecimal("FBaseQty2").signum() == -1) {
                    fBaseQty = rs.getBigDecimal("FBaseQty2");
                    allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                    if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                        hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty2"));
                        ++errors;
                    }
                }
                if (errors2 < 5) continue;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT ");
            sqlBuff.append("abs(A.FBaseQty) - A.FReverseBaseQty - B.FBaseQty as fbaseqty,");
            sqlBuff.append("B.FBaseQty as bfbaseqty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM t_im_saleissueentry A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            sqlBuff.append("WHERE A.FIsPresent = 1 ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1).signum() != -1) continue;
                fBaseQty = rs.getBigDecimal("FBaseQty");
                allowQty = rs.getBigDecimal("bFBaseQty").multiply(new BigDecimal("0.0001"));
                if (fBaseQty.abs().subtract(allowQty).signum() == 1) {
                    hs.put(rs.getString("FSourceBillEntryId"), rs.getBigDecimal("FBaseQty"));
                    ++errors;
                }
                if (errors < 5) continue;
                break;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
            if (errors2 > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.SALEISSUEREVERSEQTY_ENOUGH_CANISSUE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

