/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.bizCenter.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.bizCenter.WHManStateEnum;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignCollection;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignFactory;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignInfo;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManBizException;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManCollection;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManFactory;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManInfo;
import com.kingdee.eas.scm.im.inv.bizCenter.app.AbstractWarehouseManAssignControllerBean;
import com.kingdee.eas.scm.util.app.db.SysTempTableHelper;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WarehouseManAssignControllerBean
extends AbstractWarehouseManAssignControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.bizCenter.app.WarehouseManAssignControllerBean");

    @Override
    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        WarehouseManAssignInfo info = (WarehouseManAssignInfo)model;
        String storageOrgFilter = "id in " + this.getMainOrgFilter(ctx);
        map.put("storageOrgFilter", storageOrgFilter);
        if (info.getStorageOrg() == null) {
            return map;
        }
        StorageOrgUnitInfo storageOrgUnitInfo = info.getStorageOrg();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("cu.longNumber"));
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitInfo.getId().toString()), sic);
        map.put("cuId", sou.getId().toString());
        String filter_mst = this.getMaterialStandardFilterByCU(ctx, sou.getCU());
        map.put("filter_mst", filter_mst);
        map.put("isWarehouseByMSAssignQuery", this.getWarehouseParamValue(ctx, sou.getId().toString()));
        return map;
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehouseManAssignInfo billInfo = (WarehouseManAssignInfo)model;
        billInfo.setCreateTime(new Timestamp(new Date().getTime()));
        UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        billInfo.setCreator(aUserInfo);
        StorageOrgUnitInfo sou1 = null;
        StorageOrgUnitInfo sou = null;
        if (billInfo.getStorageOrg() != null) {
            sou = billInfo.getStorageOrg();
        } else {
            sou1 = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "warehousemanassign_addnew");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("cu.id"));
            sic.add(new SelectorItemInfo("cu.longNumber"));
            sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(sou1.getId().toString()), sic);
        }
        if (sou == null) {
            return billInfo;
        }
        if (sou.getCU() != null) {
            billInfo.setCU(sou.getCU());
            billInfo.setMaterialGroupStandard(this.getDefaultMaterialStadard(ctx, sou.getCU()));
        }
        billInfo.setStorageOrg(sou);
        billInfo.setStatus(WHManStateEnum.NEW);
        return billInfo;
    }

    @Override
    protected Map _getDataForOrgChanged(Context ctx, Map requestMap) throws BOSException, EASBizException {
        String orgId = requestMap.get("orgId").toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("cu.longNumber"));
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
        map.put("cuId", sou.getCU().getId().toString());
        MaterialGroupStandardInfo info = this.getDefaultMaterialStadard(ctx, sou.getCU());
        map.put("materialGroupStandard", info);
        map.put("filter_mst", this.getMaterialStandardFilterByCU(ctx, sou.getCU()));
        map.put("isWarehouseByMSAssignQuery", this.getWarehouseParamValue(ctx, sou.getId().toString()));
        return map;
    }

    private boolean getWarehouseParamValue(Context ctx, String orgId) throws BOSException, EASBizException {
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String purPram = ipc.getParamValue((IObjectPK)new ObjectUuidPK(orgId), "INM008");
        boolean purParamValue = false;
        if (purPram != null && purPram.equals("true") || purPram.equals("1")) {
            purParamValue = true;
        }
        return purParamValue;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        sb.append("update T_SCM_WarehouseManAssign set FStatus = 2 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus=1 ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        sb.append("update T_SCM_WarehouseManAssign set FStatus = 1 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus=2 ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected List _batchSave(Context ctx, Map dataMap) throws BOSException, EASBizException {
        ArrayList msgList = new ArrayList();
        String billId = (String)dataMap.get("billId");
        String souJson = (String)dataMap.get("storageOrg");
        String materialGroupStandardJson = (String)dataMap.get("materialGroupStandard");
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)souJson, StorageOrgUnitInfo.class);
        MaterialGroupStandardInfo materialGroupStandard = (MaterialGroupStandardInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)materialGroupStandardJson, MaterialGroupStandardInfo.class);
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        String entryJson = (String)dataMap.get("entry");
        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray(entryJson);
            String mateiralGroupJson = null;
            String mateiralJson = null;
            String warehouseJson = null;
            String warehouseManJson = null;
            JSONObject jsonObject = null;
            WarehouseManAssignInfo info = null;
            WarehouseManAssignCollection objColl = new WarehouseManAssignCollection();
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonObject = (JSONObject)jsonArray.get(i);
                info = new WarehouseManAssignInfo();
                info.setStorageOrg(sou);
                info.setStatus(WHManStateEnum.SAVED);
                info.setMaterialGroupStandard(materialGroupStandard);
                info.setCreateTime(serverDate);
                info.setCreator(aUserInfo);
                MaterialGroupInfo mateiralGroup = null;
                MaterialInfo mateiral = null;
                WarehouseInfo warehouse = null;
                WarehouseManInfo warehouseMan = null;
                if (jsonObject.has("materialGroup")) {
                    mateiralGroupJson = jsonObject.getString("materialGroup");
                    mateiralGroup = (MaterialGroupInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)mateiralGroupJson, MaterialGroupInfo.class);
                }
                if (jsonObject.has("material")) {
                    mateiralJson = jsonObject.getString("material");
                    mateiral = (MaterialInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)mateiralJson, MaterialInfo.class);
                }
                if (jsonObject.has("warehouse")) {
                    warehouseJson = jsonObject.getString("warehouse");
                    warehouse = (WarehouseInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)warehouseJson, WarehouseInfo.class);
                }
                if (jsonObject.has("whman")) {
                    warehouseManJson = jsonObject.getString("whman");
                    warehouseMan = (WarehouseManInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)warehouseManJson, WarehouseManInfo.class);
                }
                info.setMaterialGroup(mateiralGroup);
                info.setMaterial(mateiral);
                info.setWarehouse(warehouse);
                info.setWhman(warehouseMan);
                objColl.add(info);
            }
            if (objColl != null && objColl.size() > 0) {
                if (billId != null && !StringUtils.isEmpty((String)billId)) {
                    objColl.get(0).setId(BOSUuid.read((String)billId));
                }
                this.checkBeforeSave(ctx, objColl);
                this._saveBatchData(ctx, (IObjectCollection)objColl);
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        return msgList;
    }

    private void checkBeforeSave(Context ctx, WarehouseManAssignCollection objColl) throws BOSException, EASBizException {
        if (objColl == null || objColl.size() == 0) {
            return;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String key = "";
        WarehouseManAssignInfo taskInfo = null;
        for (int i = 0; i < objColl.size(); ++i) {
            key = "";
            taskInfo = objColl.get(i);
            if (taskInfo.getMaterialGroup() != null) {
                key = key + taskInfo.getMaterialGroup().getId().toString();
            }
            if (taskInfo.getMaterial() != null) {
                key = key + taskInfo.getMaterial().getId().toString();
            }
            if (taskInfo.getWarehouse() != null) {
                key = key + taskInfo.getWarehouse().getId().toString();
            }
            if (taskInfo.getWhman() != null) {
                key = key + taskInfo.getWhman().getId().toString();
            }
            if (result.containsKey(key)) {
                throw new WarehouseManBizException(WarehouseManBizException.SAVE_ERROR_2, new Object[]{i + 1});
            }
            result.put(key, i);
        }
        String[][] tableFields = new String[][]{{"FType", "int"}, {"FSeq", "int"}};
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            SysTempTableHelper helper = new SysTempTableHelper(ctx, con);
            String tempTable = helper.createTempTable(ctx, tableFields);
            WarehouseManAssignInfo warehouseManAssignInfo = null;
            Object info = null;
            StringBuilder sql = new StringBuilder();
            StringBuilder sqlInsert = new StringBuilder();
            sqlInsert.append("insert into ").append(tempTable).append(" (FType,FSeq) ");
            BigDecimal amount = BigDecimal.ZERO;
            int size = objColl.size();
            for (int i = 0; i < size; ++i) {
                warehouseManAssignInfo = objColl.get(i);
                sql.setLength(0);
                sql.append((CharSequence)sqlInsert);
                sql.append("select 2 as FType,").append(String.valueOf(i + 1)).append(" as FSeq ");
                sql.append(" from T_SCM_WarehouseManAssign w ");
                sql.append(" where 1 = 1 ");
                if (warehouseManAssignInfo.getStorageOrg() != null) {
                    sql.append(" and w.FStorageOrgID = '" + warehouseManAssignInfo.getStorageOrg().getId().toString() + "'");
                }
                if (warehouseManAssignInfo.getMaterialGroupStandard() != null) {
                    sql.append(" and w.FMaterialGroupStandardID = '" + warehouseManAssignInfo.getMaterialGroupStandard().getId().toString() + "'");
                }
                if (warehouseManAssignInfo.getMaterialGroup() != null) {
                    sql.append(" and w.FMaterialGroupID = '" + warehouseManAssignInfo.getMaterialGroup().getId().toString() + "'");
                } else {
                    sql.append(" and w.FMaterialGroupID is null ");
                }
                if (warehouseManAssignInfo.getMaterial() != null) {
                    sql.append(" and w.FMaterialID = '" + warehouseManAssignInfo.getMaterial().getId().toString() + "'");
                } else {
                    sql.append(" and w.FMaterialID is null ");
                }
                if (warehouseManAssignInfo.getWarehouse() != null) {
                    sql.append(" and w.FWarehouseID = '" + warehouseManAssignInfo.getWarehouse().getId().toString() + "'");
                } else {
                    sql.append(" and w.FWarehouseID is null ");
                }
                if (warehouseManAssignInfo.getWhman() != null) {
                    sql.append(" and w.FWhmanID = '" + warehouseManAssignInfo.getWhman().getId().toString() + "'");
                } else {
                    sql.append(" and w.FWhmanID is null ");
                }
                if (warehouseManAssignInfo.getId() != null) {
                    sql.append(" and w.FID <> '" + warehouseManAssignInfo.getId().toString() + "'");
                }
                stmt.addBatch(sql.toString());
            }
            stmt.executeBatch();
            sql.setLength(0);
            sql.append("select FType,FSeq from ").append(tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    if (rs.getInt("FType") == 1 || rs.getInt("FType") != 2) continue;
                    throw new WarehouseManBizException(WarehouseManBizException.SAVE_ERROR_2, new Object[]{rs.getInt("FSeq")});
                }
            }
            helper.releaseTempTable(tempTable);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    @Override
    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        HashMap<Object, ObjectBaseInfo> map = new HashMap<Object, ObjectBaseInfo>();
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            WarehouseManAssignInfo bill = new WarehouseManAssignInfo();
            this._createNewData(ctx, (IObjectValue)bill);
            map.put(bill, bill);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            view.setFilter(filter);
            WarehouseManCollection coll = WarehouseManFactory.getLocalInstance(ctx).getWarehouseManCollection(view);
            map.put("bill", coll.get(0));
        }
        return map;
    }

    public String getMainOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), this.getMainOrgType(), null, this.getPermissionItem());
        OrgUnitCollection stoOrgColl = new OrgUnitCollection();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            idSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (!this.getMainOrgType().equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isOUSealup", (Object)new Boolean(false), CompareType.EQUALS));
        }
        view.setFilter(filter);
        stoOrgColl = this.getOrgUnitCollForOrgType(ctx, this.getMainOrgType(), view);
        return this.getOrgFilterStr(ctx, stoOrgColl);
    }

    private OrgUnitCollection getOrgUnitCollForOrgType(Context ctx, OrgType orgType, EntityViewInfo view) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitColl = new OrgUnitCollection();
        switch (orgType.getValue()) {
            case 0: {
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 1: {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 2: {
                ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 3: {
                IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 4: {
                IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
            case 24: {
                ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        orgUnitColl.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return orgUnitColl;
            }
        }
        return null;
    }

    public String getOrgFilterStr(Context ctx, OrgUnitCollection orgCollection) {
        if (orgCollection == null || orgCollection.size() == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < orgCollection.size(); ++i) {
            sb.append("'").append(orgCollection.get(i).getId().toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public String getPermissionItem() {
        return "warehousemanassign_addnew";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    private MaterialGroupStandardInfo getDefaultMaterialStadard(Context ctx, CtrlUnitInfo cu) throws BOSException, EASBizException {
        IMaterialGroupStandard imst = MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
        MaterialGroupStandardCollection mstColl = imst.getMaterialGroupStandardCollection("select id,number,name,standardtype where CU.id = '" + cu.getId().toString() + "' or CU.id = '00000000-0000-0000-0000-000000000000CCE7AED4'");
        MaterialGroupStandardInfo mstInfo = null;
        if (mstColl != null && mstColl.size() > 0) {
            int defaultIndex = 0;
            int size = mstColl.size();
            for (int index = 0; index < size; ++index) {
                if (!mstColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            mstInfo = mstColl.get(defaultIndex);
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            mstInfo = imst.getMaterialGroupStandardInfo((IObjectPK)new ObjectUuidPK("dR8lnQEPEADgAAWKwKgSxZeb4R8="), sic);
        }
        return mstInfo;
    }

    private String getMaterialStandardFilterByCU(Context ctx, CtrlUnitInfo cu) throws BOSException {
        if (cu == null) {
            return null;
        }
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        return filterInfoCU.toString();
    }

    protected List _getWarehouseManAssignList(Context ctx, List souList, List whmanList) throws BOSException {
        int i;
        ArrayList<WarehouseManAssignInfo> whmanAssignList = new ArrayList<WarehouseManAssignInfo>();
        if (souList == null || souList.size() == 0 || whmanList == null || whmanList.size() == 0) {
            return null;
        }
        HashSet<String> souSet = new HashSet<String>();
        HashSet whmanSet = new HashSet();
        int count = souList.size();
        for (i = 0; i < count; ++i) {
            souSet.add(((StorageOrgUnitInfo)souList.get(i)).getId().toString());
        }
        count = whmanList.size();
        for (i = 0; i < count; ++i) {
            souSet.add(((WarehouseManInfo)whmanList.get(i)).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", souSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("whman.id", whmanSet, CompareType.INCLUDE));
        view.setFilter(filter);
        WarehouseManAssignCollection whmanColl = WarehouseManAssignFactory.getRemoteInstance().getWarehouseManAssignCollection(view);
        HashMap<String, WarehouseManAssignInfo> keyMap = new HashMap<String, WarehouseManAssignInfo>();
        WarehouseManAssignInfo temp = null;
        WarehouseManAssignInfo whmanAssignInfo = null;
        int count2 = whmanColl.size();
        for (int i2 = 0; i2 < count2; ++i2) {
            whmanAssignInfo = whmanColl.get(i2);
            String key = whmanAssignInfo.getWhman().getId().toString() + whmanAssignInfo.getStorageOrg().getId().toString() + whmanAssignInfo.getWarehouse().getId().toString();
            temp = (WarehouseManAssignInfo)keyMap.get(key);
            if (temp != null) {
                if (temp.getMaterial() != null) continue;
                whmanAssignList.remove(temp);
                whmanAssignList.add(whmanAssignInfo);
                keyMap.put(key, whmanAssignInfo);
                continue;
            }
            whmanAssignList.add(whmanAssignInfo);
            keyMap.put(key, whmanAssignInfo);
        }
        return whmanAssignList;
    }

    @Override
    protected IObjectCollection _getAssignList(Context ctx) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        WarehouseManInfo whman = null;
        WarehouseManCollection whmanColl = WarehouseManFactory.getLocalInstance(ctx).getWarehouseManCollection(view);
        if (whmanColl == null || whmanColl.size() == 0) {
            return null;
        }
        whman = whmanColl.get(0);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("whman.id", (Object)whman.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
        view.setFilter(filter);
        WarehouseManAssignCollection whmanAssignColl = WarehouseManAssignFactory.getLocalInstance(ctx).getWarehouseManAssignCollection(view);
        return whmanAssignColl;
    }
}

