/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.bizCenter.app.takedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.bizframework.billconfig.util.BillConfigureCache;
import com.kingdee.eas.bizframework.bizcenter.BillTypeInfo;
import com.kingdee.eas.bizframework.bizplatform.app.takedata.PlatFormTakeData;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignFactory;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignInfo;
import com.kingdee.eas.scm.im.inv.bizCenter.app.takedata.IInvTakeData;
import java.util.HashMap;

public class InvTakeDataImpl
extends PlatFormTakeData
implements IInvTakeData {
    private boolean hasWarehouse = false;
    private boolean hasMaterialGroup = false;

    protected String getJoinSql() throws BOSException, EASBizException {
        String joinSql = super.getJoinSql();
        if (joinSql.indexOf("T_BD_MaterialGroup") != -1) {
            this.hasMaterialGroup = true;
        }
        if (joinSql.indexOf("WAREHOUSE") != -1) {
            this.hasWarehouse = true;
        }
        StringBuffer join = new StringBuffer();
        join.append(joinSql);
        if (!this.hasMaterialGroup) {
            join.append(" \n ").append("LEFT OUTER JOIN T_BD_MaterialGroup AS \"MATERIALGROUP\"");
            join.append(" \n ").append("ON \"MATERIAL\".FMaterialGroupID = \"MATERIALGROUP\".FID");
        }
        return join.toString();
    }

    protected String getWhereSql() throws BOSException, EASBizException {
        String whereSql = super.getWhereSql();
        StringBuffer oql = new StringBuffer();
        BillTypeInfo billTypeInfo = this.jobConfigInfo.getSrcBillType();
        String mainOrgProperty = this.getStorageOrgUnitName();
        if (mainOrgProperty == null && (mainOrgProperty = billTypeInfo.getString("mainOrgProperty")) == null) {
            return whereSql;
        }
        IObjectCollection coll = this.getAssignList(this.ctx);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        oql.append(whereSql);
        oql.append(" and (");
        WarehouseManAssignInfo assignInfo = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            assignInfo = (WarehouseManAssignInfo)coll.getObject(i);
            if (i != 0) {
                oql.append(" or ");
            }
            oql.append(" ( ");
            oql.append("\"" + mainOrgProperty + "\"").append(".FID = '").append(assignInfo.getStorageOrg().getId().toString()).append("'");
            if (assignInfo.getMaterial() != null) {
                oql.append(" and \"MATERIALGROUP\".FID = '").append(assignInfo.getMaterialGroup().getId().toString()).append("'");
                oql.append(" and \"MATERIAL\".FID = '").append(assignInfo.getMaterial().getId().toString()).append("'");
            } else {
                oql.append(" and \"MATERIALGROUP\".fnumber LIKE '").append(assignInfo.getMaterialGroup().getNumber()).append("%'");
            }
            EntityObjectInfo entity = BillConfigureCache.getEntityObjectInfo((Context)this.ctx, (String)billTypeInfo.getBillBosType());
            String billInfo = entity.getObjectValueClass();
            Class<?> c = null;
            IObjectValue objectValue = null;
            try {
                c = Class.forName(billInfo);
                Object instance = c.newInstance();
                objectValue = (IObjectValue)instance;
                if (objectValue instanceof InvBillBaseInfo) {
                    oql.append(" and (\"warehouse\".FID = '").append(assignInfo.getWarehouse().getId().toString()).append("'");
                    oql.append(" or  \"warehouse\".FID IS NULL)");
                } else if (billTypeInfo.getBillBosType().equals("2239F30A") || billTypeInfo.getBillBosType().equals("5C2A1F0C")) {
                    oql.append(" and (\"MOVEINWAREHOUSE\".FID = '").append(assignInfo.getWarehouse().getId().toString()).append("'");
                    oql.append(" or   \"MOVEOUTWAREHOUSE\".FID = '").append(assignInfo.getWarehouse().getId().toString()).append("'");
                    oql.append(" or   (\"MOVEINWAREHOUSE\".FID IS NULL");
                    oql.append(" and   \"MOVEOUTWAREHOUSE\".FID IS NULL))");
                } else if (this.hasWarehouse) {
                    oql.append(" and (\"").append(this.getWarehouseName()).append("\".FID = '").append(assignInfo.getWarehouse().getId().toString()).append("'");
                    oql.append(" or  \"").append(this.getWarehouseName()).append("\".FID IS NULL)");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            oql.append(" ) ");
        }
        oql.append(" ) ");
        return oql.toString();
    }

    private IObjectCollection getAssignList(Context ctx) throws BOSException, EASBizException {
        IObjectCollection coll = WarehouseManAssignFactory.getLocalInstance(ctx).getAssignList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        WarehouseManAssignInfo info = null;
        if (coll.size() > 1) {
            int i;
            int count = coll.size();
            for (i = 0; i < count; ++i) {
                info = (WarehouseManAssignInfo)coll.getObject(i);
                if (info.getMaterial() == null) continue;
                map.put(info.getMaterialGroup().getId().toString(), true);
            }
            for (i = 0; i < coll.size(); ++i) {
                boolean hasExist;
                info = (WarehouseManAssignInfo)coll.getObject(i);
                boolean bl = hasExist = map.get(info.getMaterialGroup().getId().toString()) == null ? false : (Boolean)map.get(info.getMaterialGroup().getId().toString());
                if (info.getMaterial() != null || !hasExist) continue;
                coll.removeObject(i);
                --i;
            }
        }
        return coll;
    }

    @Override
    public String getStorageOrgUnitName() throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String getWarehouseName() throws BOSException, EASBizException {
        return "warehouse";
    }
}

