/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.invconfig.app.AbstractSQLDataAccessFacadeControllerBean;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class SQLDataAccessFacadeControllerBean
extends AbstractSQLDataAccessFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected IRowSet _getRowSet(Context ctx, String sql, int start, int len) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)len);
            int rowCount = 0;
            int idListSize = this.getCriticalIDSize();
            DynamicRowSet drs = this.createRowSet((ResultSet)rs);
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= drs.getMetaData().getColumnCount(); ++i) {
                    this.populateRowSetCell(drs, (ResultSet)rs, i);
                }
                drs.insertRow();
                if (idListSize == 0 || ++rowCount <= idListSize) continue;
                throw new FetchedTooMuchRowsException("fetched too much rows:" + rowCount + " SQL: " + sql);
            }
            drs.beforeFirst();
            return drs;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private DynamicRowSet createRowSet(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i < colCount + 1; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }

    private String getLimitForRealPage(int dbType, String sql, int start, int end) throws BOSException, SqlTranslateException {
        if (dbType == 7 || dbType == 8 || dbType == 2) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(end).toString();
            return sqlLimit.toString();
        }
        if (dbType == 3) {
            return this.getLimitStringForMSSqlSrv(sql, start, end);
        }
        if (dbType == 1 || dbType == 9) {
            return this.getLimitStringForDB2(sql, start, end);
        }
        return "";
    }

    private String getLimitStringForMSSqlSrv(String sql, int start, int end) {
        StringBuffer Sqllimit = new StringBuffer(sql.length() + 100);
        Sqllimit.append("SELECT * FROM (SELECT TOP ").append(end).append(" * FROM (").append(sql).append(")AS T1 ").append(")AS T2 ");
        return "/*dialect*/" + Sqllimit;
    }

    private String getLimitStringForDB2(String sql, int start, int top) {
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("SELECT * from ( SELECT tableA.*,").append(this.getRowNumberForDB2(sql));
        pagingSelect.append(sql.substring(startOfSelect + 6));
        pagingSelect.append(")AS tableA) as temp_ where rownumber_ ");
        pagingSelect.append("between ");
        pagingSelect.append(start);
        pagingSelect.append("+1 and ");
        pagingSelect.append(top);
        return "/*dialect*/" + pagingSelect;
    }

    private String getRowNumberForDB2(String sql) {
        StringBuffer rownumber = new StringBuffer(50);
        rownumber.append("rownumber() over(");
        rownumber.append(") as rownumber_ FROM (SELECT");
        return rownumber.toString();
    }

    @Override
    protected String _createTempTable(Context ctx, String createSQL, String dataSQL, String fieldSQL, Map conditions) throws BOSException, EASBizException {
        String tempTableName = null;
        try {
            TempTablePool pool = TempTablePool.getInstanceForRead((Context)ctx, null);
            tempTableName = pool.createTempTable(createSQL);
            this.insertData(ctx, tempTableName, dataSQL, fieldSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private void insertData(Context ctx, String tempTableName, String dataSQL, String fieldSQL) throws BOSException {
        if (StringUtil.isEmpty((String)dataSQL) || StringUtil.isEmpty((String)fieldSQL)) {
            return;
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTableName);
        insertSQL.append("(").append(fieldSQL).append(") ");
        insertSQL.append(dataSQL).append(";");
        DbUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    @Override
    protected void _dropTable(Context ctx, String tableName) throws BOSException, EASBizException {
        if (tableName != null && tableName.length() != 0) {
            TempTablePool.getInstanceForRead((Context)ctx, null).releaseTable(tableName);
        }
    }

    protected int getCriticalIDSize() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.getCriticalIDList();
    }

    protected void populateRowSetCell(DynamicRowSet drs, ResultSet rs, int i) throws SQLException {
        int type = rs.getMetaData().getColumnType(i);
        Object colValue = rs.getObject(i);
        if (colValue == null) {
            drs.updateNull(i);
        } else {
            switch (type) {
                case -7: {
                    drs.updateByte(i, rs.getByte(i));
                    break;
                }
                case 91: {
                    drs.updateDate(i, rs.getDate(i));
                    break;
                }
                case 92: {
                    drs.updateTime(i, rs.getTime(i));
                    break;
                }
                case 93: {
                    drs.updateTimestamp(i, rs.getTimestamp(i));
                    break;
                }
                case 4: {
                    drs.updateInt(i, rs.getInt(i));
                    break;
                }
                case 6: {
                    drs.updateFloat(i, rs.getFloat(i));
                    break;
                }
                case 3: {
                    drs.updateBigDecimal(i, rs.getBigDecimal(i));
                    break;
                }
                case 8: {
                    drs.updateDouble(i, rs.getDouble(i));
                    break;
                }
                case 5: {
                    drs.updateShort(i, rs.getShort(i));
                    break;
                }
                case -5: {
                    drs.updateLong(i, rs.getLong(i));
                    break;
                }
                default: {
                    drs.updateObject(i, colValue);
                }
            }
        }
    }

    @Override
    protected void _executeBatch(Context ctx, String[] sqls) throws BOSException, EASBizException {
        KsqlUtil.executeBatch((Context)ctx, (String[])sqls);
    }

    @Override
    protected IRowSet _executeQuery(Context ctx, String sql) throws BOSException, EASBizException {
        return KsqlUtil.executeQuery((Context)ctx, (String)sql);
    }
}

