/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.sms;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.sms.AbstractSupportInvMobileFacadeControllerBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SupportInvMobileFacadeControllerBean
extends AbstractSupportInvMobileFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.sms.SupportInvMobileFacadeControllerBean");
    private static String RES = "com.kingdee.eas.scm.im.sms.SupportINVMobileResource";

    @Override
    protected String _getInvMobileSupport(Context ctx, String materialNum, String storageNum, String warehouseNum) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        String result = "";
        if (materialNum == null || materialNum.length() < 1) {
            return "";
        }
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String sql = this.getBaseSql(materialNum, storageNum, warehouseNum);
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                BigDecimal qty = rs.getBigDecimal("FCurStoreQty");
                String mNum = rs.getString("FNumber");
                String mName = rs.getString("FMNAME");
                String sName = rs.getString("FSNAME");
                String wName = rs.getString("FWNAME");
                String uName = rs.getString("FUNAME");
                int qtyPrecision = rs.getInt("FQtyPrecision");
                String qtyp = qty.setScale(qtyPrecision, 4).toString();
                if (mNum != null && mNum.length() > 0) {
                    result = result + mNum;
                }
                if (mName != null && mName.length() > 0) {
                    result = result + "," + mName;
                }
                if (sName != null && sName.length() > 0) {
                    result = result + "," + sName;
                }
                if (wName != null && wName.length() > 0) {
                    result = result + "," + wName;
                }
                result = result + "," + EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"99_SupportInvMobileFacadeControllerBean") + qtyp + uName + ";";
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
        return result;
    }

    private String getBaseSql(String materialNum, String storageNum, String warehouseNum) throws EASBizException, BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT ");
        sqlBuff.append("Sum(T1.FCurStoreQty) AS FCurStoreQty, ");
        sqlBuff.append("T2.FName_L2 AS FMNAME, ");
        sqlBuff.append("T2.FNumber,");
        sqlBuff.append("T3.FName_L2 AS FSNAME,");
        sqlBuff.append("T4.FName_L2 AS FWNAME,");
        sqlBuff.append("T5.FName_L2 AS FUNAME,");
        sqlBuff.append("T6.FQtyPrecision AS FQtyPrecision ");
        sqlBuff.append("FROM  T_IM_Inventory  AS T1 ");
        sqlBuff.append("LEFT OUTER JOIN  T_BD_Material AS  T2 ");
        sqlBuff.append("ON   T1.fmaterialid = T2.fid ");
        sqlBuff.append("LEFT OUTER JOIN T_ORG_Storage AS T3 ");
        sqlBuff.append("ON       T1.fstorageorgunitid = T3.fid ");
        sqlBuff.append("LEFT OUTER JOIN T_DB_WAREHOUSE AS  T4 ");
        sqlBuff.append("ON       T1.fwarehouseid = T4.fid ");
        sqlBuff.append("LEFT OUTER JOIN T_BD_MeasureUnit AS T5 ");
        sqlBuff.append("ON       T1.funitid = T5.fid ");
        sqlBuff.append("LEFT OUTER JOIN t_bd_multimeasureunit AS T6 ");
        sqlBuff.append("ON   (T1.fmaterialid=T6.fmaterialid  AND  T1.funitid= T6.fmeasureunitid ) ");
        sqlBuff.append(" WHERE ");
        sqlBuff.append("T2.FNumber='" + materialNum + "'");
        if (storageNum != null && storageNum.length() > 0) {
            sqlBuff.append(" AND T3.FNumber='" + storageNum + "'");
        }
        if (warehouseNum != null && !warehouseNum.trim().equalsIgnoreCase("*")) {
            sqlBuff.append(" AND T4.FNumber='" + warehouseNum + "'");
        }
        sqlBuff.append(" Group by ");
        sqlBuff.append("T2.FName_L2, ");
        sqlBuff.append("T2.FNumber, ");
        sqlBuff.append("T3.FName_L2, ");
        sqlBuff.append("T4.FName_L2, ");
        sqlBuff.append("T5.FName_L2, ");
        sqlBuff.append("T6.FQtyPrecision ");
        return sqlBuff.toString();
    }
}

