/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.im.inv.vmi.CreateTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.IVMISettleGroup;
import com.kingdee.eas.scm.im.inv.vmi.RecordTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleException;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupCollection;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupInfo;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleRecordInfo;
import com.kingdee.eas.scm.im.inv.vmi.app.calculate.ISettleCalculate;
import com.kingdee.eas.scm.im.inv.vmi.app.helper.VMISettleSQLBuilder;
import com.kingdee.eas.scm.im.inv.vmi.app.service.VirtualBillVMIService;
import com.kingdee.eas.scm.im.inv.vmi.info.ReturnInfo;
import com.kingdee.eas.scm.im.inv.vmi.info.SettleResultInfo;
import com.kingdee.eas.scm.im.inv.vmi.util.ORMappingUtil;
import com.kingdee.eas.scm.im.inv.vmi.util.VMISettleUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractSettleCalculate
implements ISettleCalculate {
    protected Context ctx = null;
    protected BillTypeInfo billType = null;
    protected CompanyOrgUnitInfo companyOrgUnitInfo = null;
    protected FieldDefInfo fieldDefInfo = null;
    protected VMISettleSQLBuilder sqlBuilder = null;
    protected PeriodInfo currPeriod = null;
    protected String tempName = null;
    private CoreBillBaseCollection mergeBillColl = null;
    private Map mergeBillMap = new HashMap();
    private IObjectCollection outVirtualColl = null;
    private Map outVirtualMap = new HashMap();
    private IObjectCollection inVirtualColl = null;
    private Map inVirtualMap = new HashMap();
    private List settleResultList = null;
    private List inBlueList = null;
    private List inRedList = null;
    private List outBlueList = null;
    private List outRedList = null;
    private RptParams param = null;
    private Boolean flag = false;
    private Map<String, Integer> scmCal001Map = new HashMap<String, Integer>();
    private VirtualBillVMIService invVirtrualBillHelper = null;

    public AbstractSettleCalculate(Context ctx, BillTypeInfo billType) {
        this.ctx = ctx;
        this.billType = billType;
    }

    protected void beforeSettle(List settleList, Map params) throws EASBizException, BOSException {
        String companyOrgUnitId = ((CompanyOrgUnitInfo)params.get("companyOrgUnit")).getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("baseExchangeTable.*"));
        selector.add(new SelectorItemInfo("baseCurrency.*"));
        this.companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), selector);
        this.tempName = (String)params.get("tempName");
        this.param = (RptParams)params.get("param");
        this.fieldDefInfo = VMISettleUtil.loadFieldDefInfo(this.ctx, this.billType.getBosType());
        this.sqlBuilder = new VMISettleSQLBuilder(this.ctx, this.fieldDefInfo);
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        this.mergeBillColl = new CoreBillBaseCollection();
        InvBillBaseInfo info = null;
        int size = settleList.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)settleList.get(i);
            this.fillMergeBill(info);
            this.mergeBillColl.addObject((IObjectValue)info);
            this.mergeBillMap.put(info.getId().toString(), info);
        }
        this.invVirtrualBillHelper = new VirtualBillVMIService(this.ctx);
    }

    @Override
    public ReturnInfo settle(List settleList, Map params) throws EASBizException, BOSException {
        this.beforeSettle(settleList, params);
        ReturnInfo returnInfo = this.manualSettle();
        return returnInfo;
    }

    protected ReturnInfo manualSettle() throws EASBizException, BOSException {
        boolean isSuccess = true;
        this.buildVirtualBill();
        this.buildSettleResultList();
        List<IObjectPK> pkList = this.buildSettleRecordList();
        this.updateBill();
        ReturnInfo returnInfo = new ReturnInfo();
        returnInfo.setSuccess(isSuccess);
        returnInfo.setPkList(pkList);
        return returnInfo;
    }

    protected void buildVirtualBill() throws EASBizException, BOSException {
        int i;
        this.inBlueList = new ArrayList();
        this.inRedList = new ArrayList();
        this.outBlueList = new ArrayList();
        this.outRedList = new ArrayList();
        this.outVirtualColl = new CoreBillBaseCollection();
        this.inVirtualColl = new CoreBillBaseCollection();
        CoreBillBaseCollection coll = null;
        BTPTransformResult transformResult = null;
        InvBillBaseInfo mergeBill = null;
        BigDecimal currentVmiSettleQty = null;
        for (int i2 = 0; i2 < this.mergeBillColl.size(); ++i2) {
            coll = new CoreBillBaseCollection();
            mergeBill = (InvBillBaseInfo)this.mergeBillColl.get(i2);
            currentVmiSettleQty = (BigDecimal)mergeBill.get("fixed_currentVmiSettleQty");
            if (BigDecimal.ZERO.compareTo(currentVmiSettleQty) == 0) continue;
            coll.add((CoreBillBaseInfo)mergeBill);
            transformResult = this.getTransformResult(this.ctx, coll, this.getVirtualBotpName(CalculateKindEnum.OUTPUT_WAREHOUSE));
            transformResult.getBills().getObject(0).put("flag", (Object)this.flag);
            this.outVirtualColl.addObject(transformResult.getBills().getObject(0));
            transformResult = this.getTransformResult(this.ctx, coll, this.getVirtualBotpName(CalculateKindEnum.INPUT_WAREHOUSE));
            transformResult.getBills().getObject(0).put("flag", (Object)this.flag);
            this.inVirtualColl.addObject(transformResult.getBills().getObject(0));
        }
        InvBillBaseInfo bill = null;
        InvBillBaseEntryInfo billEntry = null;
        int size = this.inVirtualColl.size();
        for (i = 0; i < size; ++i) {
            bill = (InvBillBaseInfo)this.inVirtualColl.getObject(i);
            billEntry = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
            mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(billEntry.getSourceBillId());
            this.inVirtualMap.put(mergeBill.getId().toString(), bill);
        }
        size = this.outVirtualColl.size();
        for (i = 0; i < size; ++i) {
            bill = (InvBillBaseInfo)this.outVirtualColl.getObject(i);
            billEntry = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
            mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(billEntry.getSourceBillId());
            this.outVirtualMap.put(mergeBill.getId().toString(), bill);
        }
        this.setOutIssueColl();
        this.setInWarehsColl();
        this.saveAndAudit(this.inBlueList, CalculateKindEnum.INPUT_WAREHOUSE);
        this.saveAndAudit(this.outRedList, CalculateKindEnum.OUTPUT_WAREHOUSE);
        this.saveAndAudit(this.inRedList, CalculateKindEnum.INPUT_WAREHOUSE);
        this.saveAndAudit(this.outBlueList, CalculateKindEnum.OUTPUT_WAREHOUSE);
        AccountViewUtil.updateAccountView(this.ctx, this.outVirtualColl);
        AccountViewUtil.updateAccountView(this.ctx, this.inVirtualColl);
    }

    protected void setInWarehsColl() throws EASBizException, BOSException {
        InvUpdateTypeInfo inUpdateType = InvUpdateTypeFactory.getLocalInstance((Context)this.ctx).getInvUpdateTypeInfo("where number = '001'");
        BizTypeInfo vmipurReturn = BizTypeFactory.getLocalInstance((Context)this.ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK("3IS1Qaa0R32+3JPxlVZg5iQHQ1w="));
        InvBillBaseInfo mergeBill = null;
        InvBillBaseEntryInfo mergeBillEntry = null;
        InvBillBaseInfo bill = null;
        InvBillBaseEntryInfo billEntry = null;
        InvBillBaseInfo outBill = null;
        BigDecimal currentVmiSettleQty = null;
        CurrencyInfo currencyInfo = null;
        PurchaseOrgUnitInfo purchaseOrgUnit = null;
        SupplierInfo supplier = null;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        boolean isInTax = false;
        int size = this.inVirtualColl.size();
        for (int i = 0; i < size; ++i) {
            bill = (InvBillBaseInfo)this.inVirtualColl.getObject(i);
            billEntry = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
            mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(billEntry.getSourceBillId());
            mergeBillEntry = (InvBillBaseEntryInfo)mergeBill.getEntries().getObject(0);
            currentVmiSettleQty = (BigDecimal)mergeBill.get("fixed_currentVmiSettleQty");
            currencyInfo = (CurrencyInfo)mergeBill.get("fixed_currencyName");
            purchaseOrgUnit = (PurchaseOrgUnitInfo)mergeBill.get("fixed_purchaseOrgUnitName");
            supplier = (SupplierInfo)mergeBillEntry.get("supplier");
            isInTax = (Boolean)mergeBill.get("fixed_isInTax");
            currentVmiSettleQty = (BigDecimal)mergeBill.get("fixed_currentVmiSettleQty");
            price = (BigDecimal)mergeBill.get("fixed_vmiSettlePrice");
            taxPrice = (BigDecimal)mergeBill.get("fixed_vmiSettleTaxPrice");
            bill.put("supplier", supplier);
            bill.put("currency", currencyInfo);
            bill.put("exchangeRate", mergeBill.get("fixed_exchangeRate"));
            bill.put("companyOrgUnit", this.companyOrgUnitInfo);
            bill.put("isInTax", mergeBill.get("fixed_isInTax"));
            bill.put("isPriceInTax", mergeBill.get("fixed_isPriceInTax"));
            bill.setBizDate(mergeBill.getBizDate());
            bill.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            bill.setCreateTime(new Timestamp(new Date().getTime()));
            bill.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            bill.setAuditTime(new Timestamp(new Date().getTime()));
            bill.setBaseStatus(BillBaseStatusEnum.AUDITED);
            bill.setFiVouchered(false);
            bill.setIsReversed(false);
            bill.setIsReversed(false);
            bill.put("isSysBill", Boolean.TRUE);
            bill.setIsInitBill(false);
            bill.setStorageOrgUnit(billEntry.getStorageOrgUnit());
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) < 0) {
                bill.setTransactionType(InvAppUtils.getTransType(this.ctx, "DawAAAAPoAGwCNyn"));
                bill.setBizType(vmipurReturn);
            } else {
                bill.setTransactionType(InvAppUtils.getTransType(this.ctx, "DawAAAAPoACwCNyn"));
            }
            billEntry.put("taxRate", mergeBill.get("fixed_taxRate"));
            billEntry.put("discountRate", mergeBill.get("fixed_discountRate"));
            billEntry.setCompanyOrgUnit(this.companyOrgUnitInfo);
            billEntry.setIsPresent(mergeBill.getBoolean("fixed_isPresent"));
            billEntry.setInvUpdateType(inUpdateType);
            billEntry.setUnit(mergeBillEntry.getBaseUnit());
            billEntry.put("supplier", supplier);
            billEntry.setQty(currentVmiSettleQty);
            billEntry.setBaseUnit(mergeBillEntry.getBaseUnit());
            billEntry.setBaseQty(currentVmiSettleQty);
            billEntry.setUnVmiSettleBaseQty(BigDecimal.ZERO);
            billEntry.setTotalVmiSettleBaseQty(currentVmiSettleQty);
            billEntry.put("purchaseOrgUnit", purchaseOrgUnit);
            billEntry.put("balanceSupplier", supplier);
            billEntry.put("taxPrice", taxPrice);
            billEntry.put("price", price);
            outBill = (InvBillBaseInfo)this.outVirtualMap.get(mergeBill.getId().toString());
            if (outBill != null && outBill.getEntries().size() > 0) {
                billEntry.put("purOrder", outBill.getId().toString());
                billEntry.put("purOrderEntry", outBill.getEntries().getObject(0).get("id").toString());
                billEntry.put("coreBillType", outBill.getBillType());
                billEntry.put("purOrderNumber", outBill.getNumber());
                billEntry.put("purOrderEntrySeq", outBill.getEntries().getObject(0).get("seq"));
            }
            bill.put("IS_VMI_BIZ", true);
            new PurInAlgorithmForInfo((PurInWarehsBillInfo)bill, this.ctx).revalue();
            bill.put("IS_VMI_BIZ", true);
            this.fillBill(bill, CalculateKindEnum.INPUT_WAREHOUSE, i + 1);
            this.setBillPeriod(bill);
            this.setInBillInfo(bill);
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) > 0) {
                this.inBlueList.add(bill);
                continue;
            }
            this.inRedList.add(bill);
        }
    }

    private void setInBillInfo(InvBillBaseInfo info) throws EASBizException, BOSException {
        String companyOrgId = ((CompanyOrgUnitInfo)info.getObjectValue("companyOrgUnit")).getId().toString();
        Integer paramValue = this.scmCal001Map.get(companyOrgId);
        if (paramValue == null) {
            String value = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyOrgId), "SCM_CAL_001");
            if (StringUtils.isEmpty((String)value)) {
                value = "0";
            }
            paramValue = new Integer(value);
            this.scmCal001Map.put(companyOrgId, paramValue);
        }
        info.put("dischargeType", (int)paramValue);
    }

    private void setBillPeriod(InvBillBaseInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(this.ctx, info.getStorageOrgUnit());
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
        if (period != null) {
            info.setYear(period.getPeriodYear());
            info.setPeriod(period.getPeriodNumber());
        }
        if (info.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(info.getBizDate());
            info.setYear(cal.get(1));
            info.setMonth(cal.get(1) * 100 + (cal.get(2) + 1));
            info.setDay(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
    }

    private void setGuaranteePeriodByLot(InvBillBaseEntryInfo entryInfo) throws BOSException {
        DateOfMinDurabilityInfo dod;
        Map<String, DateOfMinDurabilityInfo> DateOfMinMap = this.getDateOfMinDurabilityMap(entryInfo);
        String key = null;
        if (!StringUtils.isEmpty((String)entryInfo.getLot()) && (dod = DateOfMinMap.get(key = entryInfo.getMaterial().getId().toString() + entryInfo.getLot())) != null) {
            entryInfo.setMfg(dod.getMfg());
            entryInfo.setExp(dod.getExp());
        }
    }

    private Map<String, DateOfMinDurabilityInfo> getDateOfMinDurabilityMap(InvBillBaseEntryInfo entryInfo) throws BOSException {
        HashMap<String, DateOfMinDurabilityInfo> DateOfMinMap = new HashMap<String, DateOfMinDurabilityInfo>();
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> lotSet = new HashSet<String>();
        if (!StringUtils.isEmpty((String)entryInfo.getLot())) {
            materialIdSet.add(entryInfo.getMaterial().getId().toString());
            lotSet.add(entryInfo.getLot());
        }
        StorageOrgUnitInfo sou = entryInfo.getStorageOrgUnit();
        IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance(this.ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("material", materialIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("lot", lotSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        DateOfMinDurabilityCollection coll = ido.getDateOfMinDurabilityCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            DateOfMinDurabilityInfo dod = coll.get(0);
            String key = dod.getMaterial().getId().toString() + dod.getLot();
            DateOfMinMap.put(key, dod);
        }
        return DateOfMinMap;
    }

    private ApprovedSupplierInfo getApprovedSupplierInfo(String materialID, String purOrgID, String supplierID) {
        HashMap<String, Object> materialMap = new HashMap<String, Object>(1);
        materialMap.put(materialID, null);
        Map supplyInfoMap = null;
        try {
            supplyInfoMap = BatchFetchDataUtils.getFetchSupplyInfoMap((Context)this.ctx, materialMap, (String)purOrgID, (String)supplierID, null, (boolean)false, (int)0);
        }
        catch (Exception e) {
            return null;
        }
        FetchSupplyInfo fetchSupplyInfo = (FetchSupplyInfo)supplyInfoMap.get(materialID);
        ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo == null ? null : fetchSupplyInfo.getApprovedSuppInfo();
        return approvedSupplierInfo;
    }

    protected void setStandardCost(InvBillBaseInfo bill, InvBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.ctx);
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MaterialInfo material = entryInfo.getMaterial();
        String materialID = material.getId().toString();
        MaterialCompanyInfoInfo materialCompanyInfo = iMaterial.getCompanyInfo(materialID, this.companyOrgUnitInfo.getId().toString());
        int curPrecision = 0;
        CurrencyInfo currencyInfo = this.companyOrgUnitInfo.getBaseCurrency();
        curPrecision = currencyInfo.getPrecision();
        if (materialCompanyInfo != null && materialCompanyInfo.getStandardCost() != null) {
            MultiMeasureUnitInfo multiMuInfo = immu.getMultiUnit(materialID, entryInfo.getUnit().getId().toString());
            BigDecimal standardCost = BigDecimal.ZERO;
            if (materialCompanyInfo.getStandardCost() != null) {
                standardCost = materialCompanyInfo.getStandardCost();
            }
            BigDecimal unitStandCost = standardCost.multiply(multiMuInfo.getBaseConvsRate()).setScale(material.getPricePrecision(), 4);
            entryInfo.setUnitStandardCost(unitStandCost);
            BigDecimal standCost = unitStandCost.multiply(entryInfo.getQty()).setScale(curPrecision, 4);
            entryInfo.setStandardCost(standCost);
        } else {
            entryInfo.setUnitStandardCost(BigDecimal.ZERO);
            entryInfo.setStandardCost(BigDecimal.ZERO);
        }
    }

    protected void setOutIssueColl() throws EASBizException, BOSException {
        int i;
        InvUpdateTypeInfo outUpdateType = InvUpdateTypeFactory.getLocalInstance((Context)this.ctx).getInvUpdateTypeInfo("where number = '002'");
        InvBillBaseInfo mergeBill = null;
        InvBillBaseEntryInfo mergeBillEntry = null;
        InvBillBaseInfo bill = null;
        InvBillBaseEntryInfo billEntry = null;
        InvBillBaseEntryInfo sourcebillEntry = null;
        BigDecimal currentVmiSettleQty = null;
        SupplierInfo supplier = null;
        BizTypeInfo bizType = this.getBizType();
        TransactionTypeInfo transactionType = this.getTransactionTypeInfo(BizDirectionEnum.REVERSE);
        int size = this.outVirtualColl.size();
        for (i = 0; i < size; ++i) {
            bill = (InvBillBaseInfo)this.outVirtualColl.getObject(i);
            billEntry = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
            mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(billEntry.getSourceBillId());
            sourcebillEntry = (InvBillBaseEntryInfo)mergeBill.getEntries().getObject(0);
            currentVmiSettleQty = (BigDecimal)mergeBill.get("fixed_currentVmiSettleQty");
            if (bill.getTransactionType() == null) {
                bill.setTransactionType(mergeBill.getTransactionType());
            }
            if (sourcebillEntry instanceof SaleIssueEntryInfo && billEntry instanceof SaleIssueEntryInfo) {
                ((SaleIssueEntryInfo)billEntry).setIsIncomeConfirm(((SaleIssueEntryInfo)sourcebillEntry).isIsIncomeConfirm());
            }
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            if (bizType != null) {
                bill.setBizType(bizType);
            }
            if (transactionType == null) continue;
            bill.setTransactionType(transactionType);
        }
        this.getBizInterface(CalculateKindEnum.OUTPUT_WAREHOUSE).handleAfterTransform("SAVE", this.outVirtualColl);
        size = this.outVirtualColl.size();
        for (i = 0; i < size; ++i) {
            bill = (InvBillBaseInfo)this.outVirtualColl.getObject(i);
            billEntry = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
            mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(billEntry.getSourceBillId());
            mergeBillEntry = (InvBillBaseEntryInfo)mergeBill.getEntries().getObject(0);
            supplier = (SupplierInfo)mergeBillEntry.get("supplier");
            currentVmiSettleQty = (BigDecimal)mergeBill.get("fixed_currentVmiSettleQty");
            bill.setBizDate(mergeBill.getBizDate());
            bill.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            bill.setCreateTime(new Timestamp(new Date().getTime()));
            bill.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            bill.setAuditTime(new Timestamp(new Date().getTime()));
            bill.setBaseStatus(BillBaseStatusEnum.AUDITED);
            bill.setFiVouchered(false);
            bill.setIsReversed(false);
            bill.setIsReversed(false);
            bill.put("isSysBill", Boolean.TRUE);
            bill.setIsInitBill(false);
            bill.setStorageOrgUnit(billEntry.getStorageOrgUnit());
            billEntry.setCompanyOrgUnit(this.companyOrgUnitInfo);
            billEntry.setUnVmiSettleBaseQty(BigDecimal.ZERO);
            billEntry.setTotalVmiSettleBaseQty(currentVmiSettleQty);
            billEntry.setInvUpdateType(outUpdateType);
            billEntry.setUnit(mergeBillEntry.getBaseUnit());
            billEntry.put("supplier", supplier);
            billEntry.setQty(currentVmiSettleQty);
            billEntry.setBaseUnit(mergeBillEntry.getBaseUnit());
            billEntry.setBaseQty(currentVmiSettleQty);
            billEntry.put("unReturnedBaseQty", billEntry.getBaseQty().abs());
            this.setGuaranteePeriodByLot(billEntry);
            this.setAssitQty(billEntry);
            this.setStandardCost(bill, billEntry);
            this.fillBill(bill, CalculateKindEnum.OUTPUT_WAREHOUSE, i + 1);
            bill.setSourceBillType(null);
            billEntry.setSourceBillType(null);
            this.setBillPeriod(bill);
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) > 0) {
                this.outBlueList.add(bill);
                continue;
            }
            this.outRedList.add(bill);
        }
    }

    protected void setAssitQty(InvBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.ctx);
        MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId().toString()));
        MeasureUnitInfo assitUnit = material.getAssistUnit();
        BigDecimal assQty = BigDecimal.ZERO;
        if (assitUnit != null) {
            MultiMeasureUnitInfo mmu = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(material.getId().toString(), assitUnit.getId().toString());
            BigDecimal convsRate = mmu.getBaseConvsRate();
            BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal(1);
            BigDecimal bigDecimal = assQty = entryInfo.getBaseQty() != null ? entryInfo.getBaseQty() : BigDecimal.ZERO;
            if (entryInfo.getBaseQty() != null) {
                assQty = entryInfo.getBaseQty().divide(coefficient, mmu.getQtyPrecision(), 4);
            }
        }
        entryInfo.setAssistQty(assQty);
    }

    protected ExchangeRateInfo getExchangeRate(CurrencyInfo currencyInfo, Date bizDate) throws EASBizException, BOSException {
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        CurrencyInfo baseCurrInfo = this.companyOrgUnitInfo.getBaseCurrency();
        sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
        destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        ExchangeTableInfo exchangeTableInfo = this.companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        return exchangeRateInfo;
    }

    protected List<IObjectPK> buildSettleRecordList() throws EASBizException, BOSException {
        VMISettleGroupCollection settleRecordList = new VMISettleGroupCollection();
        VMISettleGroupInfo settleGroupInfo = null;
        SettleResultInfo resultInfo = null;
        for (int i = 0; i < this.settleResultList.size(); ++i) {
            resultInfo = (SettleResultInfo)this.settleResultList.get(i);
            settleGroupInfo = this.createSettleGroupInfo(resultInfo, i);
            settleRecordList.add(settleGroupInfo);
        }
        return this.saveRecord(settleRecordList);
    }

    protected List<IObjectPK> saveRecord(VMISettleGroupCollection recordColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        IVMISettleGroup iVMISettleGroup = VMISettleGroupFactory.getLocalInstance(this.ctx);
        for (int i = 0; i < recordColl.size(); ++i) {
            pkList.add(iVMISettleGroup.save((CoreBaseInfo)recordColl.get(i)));
        }
        return pkList;
    }

    protected VMISettleGroupInfo createSettleGroupInfo(SettleResultInfo info, int index) throws EASBizException, BOSException {
        InvBillBaseInfo bill = info.getMergeBill();
        InvBillBaseInfo outVirtualBill = info.getOutVirtualBill();
        InvBillBaseInfo inVirtualBill = info.getInVirtualBill();
        IObjectCollection srcBillColl = info.getSrcBillColl();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        VMISettleGroupInfo groupInfo = new VMISettleGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date) + index);
        groupInfo.setCompanyOrgUnit(this.companyOrgUnitInfo);
        groupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        groupInfo.setSettleDate(info.getBizDate());
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.ctx));
        groupInfo.setCreateType(CreateTypeEnum.ManualSettle);
        this.createSettleRecordList(outVirtualBill, inVirtualBill, srcBillColl, groupInfo);
        return groupInfo;
    }

    private void createSettleRecordList(InvBillBaseInfo outVirtualBill, InvBillBaseInfo inVirtualBill, IObjectCollection srcBillColl, VMISettleGroupInfo groupInfo) {
        int seq = 0;
        int groupNo = 0;
        BigDecimal currentVmiSettleBaseQty = BigDecimal.ZERO;
        BigDecimal unVmiSettleBaseQty = BigDecimal.ZERO;
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        VMISettleRecordInfo recordInfo = null;
        if (inVirtualBill != null) {
            recordInfo = this.createSettleRecordInfo(groupInfo, inVirtualBill, seq++, groupNo, true);
            entryInfo = (InvBillBaseEntryInfo)inVirtualBill.getEntries().getObject(0);
            currentVmiSettleBaseQty = entryInfo.getTotalVmiSettleBaseQty();
            recordInfo.setCurrentVmiSettleBaseQty(currentVmiSettleBaseQty);
            recordInfo.setUnVmiSettleBaseQty(entryInfo.getUnVmiSettleBaseQty());
            recordInfo.setRecordType(RecordTypeEnum.DestVirtual);
        }
        for (int i = 0; i < srcBillColl.size(); ++i) {
            info = (InvBillBaseInfo)srcBillColl.getObject(i);
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            recordInfo = this.createSettleRecordInfo(groupInfo, info, seq++, groupNo, true);
            currentVmiSettleBaseQty = (BigDecimal)info.get("fixed_currentVmiSettleQty");
            unVmiSettleBaseQty = entryInfo.getUnVmiSettleBaseQty();
            recordInfo.setCurrentVmiSettleBaseQty(currentVmiSettleBaseQty);
            recordInfo.setUnVmiSettleBaseQty(unVmiSettleBaseQty.subtract(currentVmiSettleBaseQty));
            recordInfo.setRecordType(RecordTypeEnum.Src);
        }
        if (outVirtualBill != null) {
            recordInfo = this.createSettleRecordInfo(groupInfo, outVirtualBill, seq++, groupNo, true);
            entryInfo = (InvBillBaseEntryInfo)inVirtualBill.getEntries().getObject(0);
            currentVmiSettleBaseQty = entryInfo.getTotalVmiSettleBaseQty();
            recordInfo.setCurrentVmiSettleBaseQty(currentVmiSettleBaseQty);
            recordInfo.setUnVmiSettleBaseQty(entryInfo.getUnVmiSettleBaseQty());
            recordInfo.setRecordType(RecordTypeEnum.SrcVirtual);
        }
    }

    protected VMISettleRecordInfo createSettleRecordInfo(VMISettleGroupInfo groupInfo, InvBillBaseInfo info, int seq, int groupNO, boolean recordVisible) {
        InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
        VMISettleRecordInfo recordInfo = new VMISettleRecordInfo();
        recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
        recordInfo.setGroupNO(groupNO);
        recordInfo.setSeq(seq);
        recordInfo.setBillType(info.getBillType());
        recordInfo.setBizType(info.getBizType());
        recordInfo.setTransactionType(info.getTransactionType());
        recordInfo.setBillID(info.getId().toString());
        recordInfo.setBillEntryID(entryInfo.getId().toString());
        recordInfo.setBillEntrySeq(entryInfo.getSeq());
        recordInfo.setBillNumber(info.getNumber());
        recordInfo.setBillDate(info.getBizDate());
        recordInfo.setCompanyOrgUnit(entryInfo.getCompanyOrgUnit());
        recordInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        recordInfo.setSupplier((SupplierInfo)entryInfo.get("supplier"));
        recordInfo.setMaterial(entryInfo.getMaterial());
        recordInfo.setLot(entryInfo.getLot());
        recordInfo.setAssistProperty(entryInfo.getAssistProperty());
        recordInfo.setUnit(entryInfo.getUnit());
        recordInfo.setQty(entryInfo.getQty());
        recordInfo.setBaseUnit(entryInfo.getBaseUnit());
        recordInfo.setBaseQty(entryInfo.getBaseQty());
        recordInfo.setWarehouse(entryInfo.getWarehouse());
        recordInfo.setLocation(entryInfo.getLocation());
        recordInfo.setProject(entryInfo.getProject());
        recordInfo.setTrackNumber(entryInfo.getTrackNumber());
        recordInfo.setCalculator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        groupInfo.getEntry().add(recordInfo);
        return recordInfo;
    }

    protected void buildSettleResultList() throws EASBizException, BOSException {
        SettleResultInfo settleResultInfo = null;
        InvBillBaseInfo info = null;
        InvBillBaseInfo inVirtualBill = null;
        InvBillBaseInfo outVirtualBill = null;
        IObjectCollection srcBillColl = null;
        this.settleResultList = new ArrayList();
        for (int i = 0; i < this.mergeBillColl.size(); ++i) {
            settleResultInfo = new SettleResultInfo();
            info = (InvBillBaseInfo)this.mergeBillColl.get(i);
            inVirtualBill = (InvBillBaseInfo)this.inVirtualMap.get(info.getId().toString());
            outVirtualBill = (InvBillBaseInfo)this.outVirtualMap.get(info.getId().toString());
            srcBillColl = this.getDetailListByTotalRecord(this.tempName, (IObjectValue)info);
            settleResultInfo.setBizDate((Date)info.get("settleDate"));
            settleResultInfo.setMergeBill(info);
            settleResultInfo.setInVirtualBill(inVirtualBill);
            settleResultInfo.setOutVirtualBill(outVirtualBill);
            settleResultInfo.setSrcBillColl(srcBillColl);
            this.settleResultList.add(settleResultInfo);
        }
    }

    protected void updateBill() throws BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(this.billType.getEntryTable()).append(" set FUnVmiSettleBaseQty = ?, FTotalVmiSettleBaseQty = ?");
        updateSQL.append(" where FID = ?");
        Connection conn = null;
        PreparedStatement pm = null;
        SettleResultInfo settleResultInfo = null;
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        BigDecimal currentVmiSettleBaseQty = BigDecimal.ZERO;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            pm = conn.prepareStatement(updateSQL.toString());
            for (int i = 0; i < this.settleResultList.size(); ++i) {
                settleResultInfo = (SettleResultInfo)this.settleResultList.get(i);
                for (int j = 0; j < settleResultInfo.getSrcBillColl().size(); ++j) {
                    info = (InvBillBaseInfo)settleResultInfo.getSrcBillColl().getObject(j);
                    entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
                    currentVmiSettleBaseQty = (BigDecimal)info.get("fixed_currentVmiSettleQty");
                    pm.setBigDecimal(1, entryInfo.getUnVmiSettleBaseQty().subtract(currentVmiSettleBaseQty));
                    pm.setBigDecimal(2, entryInfo.getTotalVmiSettleBaseQty().add(currentVmiSettleBaseQty));
                    pm.setString(3, entryInfo.getId().toString());
                    pm.addBatch();
                }
            }
            pm.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, pm);
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (Statement)pm);
    }

    private IObjectCollection getDetailListByTotalRecord(String detailTableName, IObjectValue objectValue) throws BOSException {
        IRowSet rs = null;
        IObjectCollection resultColl = null;
        StringBuffer sb = new StringBuffer();
        String sql = this.getDetailSelectSql(this.ctx, this.fieldDefInfo, this.param);
        sb.append(" select ").append(this.sqlBuilder.getTableSelectSql(false)).append(" from (").append(sql).append(") as temp");
        sb.append("\r\n");
        sb.append(" where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        Object value = null;
        for (int i = 0; i < this.fieldDefInfo.getEntry().size(); ++i) {
            if (!this.fieldDefInfo.getEntry().get(i).isIsMerge()) continue;
            value = ORMappingUtil.getPropertyValue(objectValue, this.fieldDefInfo.getEntry().get(i));
            if (value != null) {
                sb.append(" and ").append(this.fieldDefInfo.getEntry().get(i).getFieldTransferName()).append(" = ? ");
                params.add(value);
                continue;
            }
            sb.append(" and ").append(this.fieldDefInfo.getEntry().get(i).getFieldTransferName()).append(" is NULL");
        }
        sb.append(" and ").append("fixed_currentVmiSettleQty").append(" <> 0");
        try {
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])params.toArray());
            resultColl = ORMappingUtil.rowSetToCollection(rs, this.sqlBuilder, false);
            this.resetData(objectValue, resultColl);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.fillDetailData(resultColl);
        return resultColl;
    }

    public void resetData(IObjectValue objectValue, IObjectCollection resultColl) {
        BigDecimal unVmiSettleBaseQty;
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        ArrayList<InvBillBaseEntryInfo> redEntryList = new ArrayList<InvBillBaseEntryInfo>();
        ArrayList<InvBillBaseEntryInfo> blueEntryList = new ArrayList<InvBillBaseEntryInfo>();
        BigDecimal qty = (BigDecimal)objectValue.get("fixed_currentVmiSettleQty");
        BigDecimal redVmiSettleBaseQty = BigDecimal.ZERO;
        BigDecimal blueVmiSettleBaseQty = BigDecimal.ZERO;
        int size = resultColl.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)resultColl.getObject(i);
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            entryInfo.put("fixed_currentVmiSettleQty", BigDecimal.ZERO);
            entryInfo.put("fixed_unVmiSettleBaseQty", entryInfo.getUnVmiSettleBaseQty());
            if (entryInfo.getUnVmiSettleBaseQty().signum() == -1) {
                redEntryList.add(entryInfo);
                redVmiSettleBaseQty = redVmiSettleBaseQty.add(entryInfo.getUnVmiSettleBaseQty());
            } else {
                blueEntryList.add(entryInfo);
                blueVmiSettleBaseQty = blueVmiSettleBaseQty.add(entryInfo.getUnVmiSettleBaseQty());
            }
            entryList.add(entryInfo);
        }
        if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) == 0) {
            for (InvBillBaseEntryInfo entry : redEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
        } else if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) > 0) {
            for (InvBillBaseEntryInfo entry : redEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            BigDecimal totalVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal curVmiSettleBaseQty = BigDecimal.ZERO;
            unVmiSettleBaseQty = BigDecimal.ZERO;
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                if ((totalVmiSettleBaseQty = totalVmiSettleBaseQty.add(unVmiSettleBaseQty)).add(redVmiSettleBaseQty).compareTo(BigDecimal.ZERO) > 0) {
                    curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(totalVmiSettleBaseQty.add(redVmiSettleBaseQty));
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                    break;
                }
                entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                totalVmiSettleBaseQty = BigDecimal.ZERO;
                for (InvBillBaseEntryInfo entry : blueEntryList) {
                    unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                    if (unVmiSettleBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    if ((totalVmiSettleBaseQty = totalVmiSettleBaseQty.add(unVmiSettleBaseQty)).compareTo(qty) > 0) {
                        curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(totalVmiSettleBaseQty.subtract(qty));
                        entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                        entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                        break;
                    }
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
                }
            }
        } else if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) < 0) {
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.getUnVmiSettleBaseQty());
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            Object totalVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal curVmiSettleBaseQty = BigDecimal.ZERO;
            unVmiSettleBaseQty = BigDecimal.ZERO;
            for (InvBillBaseEntryInfo entry : redEntryList) {
                unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                if (((BigDecimal)(totalVmiSettleBaseQty = ((BigDecimal)totalVmiSettleBaseQty).add(unVmiSettleBaseQty))).add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) < 0) {
                    curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(((BigDecimal)totalVmiSettleBaseQty).add(blueVmiSettleBaseQty));
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                    break;
                }
                entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                totalVmiSettleBaseQty = BigDecimal.ZERO;
                for (InvBillBaseEntryInfo entry : redEntryList) {
                    unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                    if (unVmiSettleBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (((BigDecimal)(totalVmiSettleBaseQty = ((BigDecimal)totalVmiSettleBaseQty).add(unVmiSettleBaseQty))).compareTo(qty) < 0) {
                        curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(((BigDecimal)totalVmiSettleBaseQty).subtract(qty));
                        entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                        entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                        break;
                    }
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
                }
            }
        }
        size = resultColl.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)resultColl.getObject(i);
            BigDecimal unVmiSettleQty = BigDecimal.ZERO;
            BigDecimal curVmiSettleQty = BigDecimal.ZERO;
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(j);
                unVmiSettleQty = unVmiSettleQty.add((BigDecimal)entryInfo.get("fixed_unVmiSettleBaseQty"));
                curVmiSettleQty = curVmiSettleQty.add((BigDecimal)entryInfo.get("fixed_currentVmiSettleQty"));
            }
            info.put("fixed_unVmiSettleBaseQty", unVmiSettleQty);
            info.put("fixed_currentVmiSettleQty", curVmiSettleQty);
        }
    }

    public String getDetailSelectSql(Context ctx, FieldDefInfo fieldDefInfo, RptParams params) {
        this.sqlBuilder = new VMISettleSQLBuilder(ctx, fieldDefInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.getSelectSql(fieldDefInfo, false));
        sql.append("\n");
        sql.append(fieldDefInfo.getQuery().getFromSQL());
        sql.append("\n");
        sql.append(this.sqlBuilder.getWhereSql(params));
        return sql.toString();
    }

    public String getSelectSql(FieldDefInfo config, Boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal.booleanValue()) continue;
            selectSql.append(entryInfo.getFieldTableName()).append(" as ").append(entryInfo.getFieldTransferName()).append(",");
        }
        if (isTotal.booleanValue()) {
            selectSql.append("sum(entry.funVmiSettleBaseQty) as unVmiSettleBaseQty ").append(",");
        } else {
            selectSql.append(" entry.funVmiSettleBaseQty as ").append("fixed_unVmiSettleBaseQty").append(" ,");
            selectSql.append(" entry.funVmiSettleBaseQty as ").append("fixed_currentVmiSettleQty").append(" ,");
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    protected void fillDetailData(IObjectCollection resultColl) {
    }

    protected void saveAndAudit(List billList, CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        InvBillBaseInfo model = null;
        IInvBillBase IInvBillBase2 = this.getBizInterface(calculateKind);
        ArrayList errorList = new ArrayList();
        HashMap errorMap = new HashMap();
        int size = billList.size();
        for (int i = 0; i < size; ++i) {
            model = (InvBillBaseInfo)billList.get(i);
            model.setAuditTime(new Timestamp(new Date().getTime()));
            try {
                IObjectPK id = IInvBillBase2.addnew((CoreBaseInfo)model);
                this.invVirtrualBillHelper.afterAuditBill((IObjectValue)model);
                continue;
            }
            catch (Exception e) {
                InvBillBaseInfo mergeBill = (InvBillBaseInfo)this.mergeBillMap.get(model.getEntries().getObject(0).get("sourceBillId").toString());
                int rowIndex = (Integer)mergeBill.get("rowIndex") + 1;
                throw new VMISettleException(VMISettleException.CREATEVIRTUALERROR, new Object[]{rowIndex, model.getBillType().getName(), e.getMessage()});
            }
        }
    }

    public BTPTransformResult getTransformResult(Context ctx, CoreBillBaseCollection coreBillBaseColl, String botpName) throws EASBizException, BOSException {
        BOTMappingInfo botIsSueMappingInfo = null;
        try {
            botIsSueMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        if (!botIsSueMappingInfo.getExtRule().isIsEffected()) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botIsSueMappingInfo);
        return transformResult;
    }

    protected void fillMergeBill(InvBillBaseInfo bill) throws CodingRuleException, EASBizException, BOSException {
        InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
        bill.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        String number = bill.getNumber();
        if (number == null) {
            // empty if block
        }
        bill.setBaseStatus(BillBaseStatusEnum.AUDITED);
        bill.setBizDate((Date)bill.get("settleDate"));
        entryInfo.setUnit(entryInfo.getBaseUnit());
        entryInfo.setQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
        entryInfo.setBaseQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
        entryInfo.setTotalVmiSettleBaseQty(BigDecimal.ZERO);
        entryInfo.setUnVmiSettleBaseQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
    }

    public String getNewNumber(InvBillBaseInfo bill) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        if (bill.getCU() == null) {
            bill.setCU(bill.getStorageOrgUnit().getCU());
        }
        return iCodingRuleManager.getNumber((IObjectValue)bill, bill.getStorageOrgUnit().getId().toString());
    }

    protected abstract void fillBill(InvBillBaseInfo var1, CalculateKindEnum var2, int var3) throws CodingRuleException, EASBizException, BOSException;

    protected abstract TransactionTypeInfo getTransactionTypeInfo(BizDirectionEnum var1) throws EASBizException, BOSException;

    protected abstract IInvBillBase getBizInterface(CalculateKindEnum var1) throws EASBizException, BOSException;

    protected abstract String getVirtualBotpName(CalculateKindEnum var1);

    protected BizTypeInfo getBizType() throws BOSException, EASBizException {
        return null;
    }
}

