/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.vmi.app.calculate.AbstractSettleCalculate;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OtherIssueBillSettleCalculate
extends AbstractSettleCalculate {
    public OtherIssueBillSettleCalculate(Context ctx, BillTypeInfo billType) {
        super(ctx, billType);
    }

    @Override
    protected String getVirtualBotpName(CalculateKindEnum calculateKind) {
        String botpName = null;
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            botpName = "Otherbill_Otherbill_001";
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            botpName = "Otherbill_PurinwarehsBill_001";
        }
        return botpName;
    }

    @Override
    protected IInvBillBase getBizInterface(CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        IInvBillBase iInvBillBase = null;
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            iInvBillBase = OtherIssueBillFactory.getLocalInstance(this.ctx);
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            iInvBillBase = PurInWarehsBillFactory.getLocalInstance(this.ctx);
        }
        return iInvBillBase;
    }

    @Override
    protected void fillBill(InvBillBaseInfo bill, CalculateKindEnum calculateKind, int seq) throws CodingRuleException, EASBizException, BOSException {
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0177c0a812fd463ED552"));
        bill.setSourceBillType(billTypeInfo);
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            this.setBillNumber(bill, calculateKind, seq);
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            this.setBillNumber(bill, calculateKind, seq);
        }
    }

    protected synchronized void setBillNumber(InvBillBaseInfo bill, CalculateKindEnum calculateKind, int seq) throws CodingRuleException, EASBizException, BOSException {
        String number = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            number = "*VMIOTO_OIssue" + format.format(date) + "-" + seq;
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            number = "*VMIPUR_OIssue" + format.format(date) + "-" + seq;
        }
        bill.setNumber(number);
    }

    @Override
    protected TransactionTypeInfo getTransactionTypeInfo(BizDirectionEnum bizDirection) throws EASBizException, BOSException {
        TransactionTypeInfo transactionTypeInfo = null;
        if (BizDirectionEnum.POSITIVE.equals((Object)bizDirection)) {
            transactionTypeInfo = InvAppUtils.getTransType(this.ctx, "DawAAAAPoCGwCNyn");
        } else if (BizDirectionEnum.REVERSE.equals((Object)bizDirection)) {
            transactionTypeInfo = InvAppUtils.getTransType(this.ctx, "CeUAAAAM2hywCNyn");
        }
        return transactionTypeInfo;
    }
}

