/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.vmi.app.calculate.AbstractSettleCalculate;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SaleIssueBillSettleCalculate
extends AbstractSettleCalculate {
    public SaleIssueBillSettleCalculate(Context ctx, BillTypeInfo billType) {
        super(ctx, billType);
    }

    @Override
    protected String getVirtualBotpName(CalculateKindEnum calculateKind) {
        String botpName = null;
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            botpName = "SaleIssue_SaleIssue_001";
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            botpName = "SaleIssue_PurInwarehsbill_001";
        }
        return botpName;
    }

    @Override
    protected IInvBillBase getBizInterface(CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        IInvBillBase iInvBillBase = null;
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            iInvBillBase = SaleIssueBillFactory.getLocalInstance(this.ctx);
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            iInvBillBase = PurInWarehsBillFactory.getLocalInstance(this.ctx);
        }
        return iInvBillBase;
    }

    @Override
    protected void fillBill(InvBillBaseInfo bill, CalculateKindEnum calculateKind, int seq) throws CodingRuleException, EASBizException, BOSException {
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            this.setBillNumber(bill, calculateKind, seq);
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            this.setBillNumber(bill, calculateKind, seq);
        }
    }

    protected synchronized void setBillNumber(InvBillBaseInfo bill, CalculateKindEnum calculateKind, int seq) throws CodingRuleException, EASBizException, BOSException {
        String number = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)calculateKind)) {
            number = "*VMISIssue_SIssue" + format.format(date) + "-" + seq;
        } else if (CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)calculateKind)) {
            number = "*VMIPUR_SIssue" + format.format(date) + "-" + seq;
        }
        bill.setNumber(number);
    }

    @Override
    protected TransactionTypeInfo getTransactionTypeInfo(BizDirectionEnum bizDirection) throws EASBizException, BOSException {
        TransactionTypeInfo transactionTypeInfo = null;
        if (BizDirectionEnum.REVERSE.equals((Object)bizDirection)) {
            transactionTypeInfo = InvAppUtils.getTransType(this.ctx, "DawAAAAPoA2wCNyn");
        }
        return transactionTypeInfo;
    }

    @Override
    protected BizTypeInfo getBizType() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        IBizType ibt = BizTypeFactory.getLocalInstance((Context)this.ctx);
        return ibt.getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0110-1000-e000-04c5c0a812202407435C"), sic);
    }
}

