/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.helper;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.info.FixedColumnInfo;
import com.kingdee.eas.scm.im.inv.vmi.util.VMISettleUtil;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class VMISettleSQLBuilder {
    private static final List<FixedColumnInfo> fixedColumns = new ArrayList<FixedColumnInfo>(){
        {
            this.add(new FixedColumnInfo("fixed_id", "Varchar(44)", true, true, true, false));
            this.add(new FixedColumnInfo("fixed_purchaseOrgUnit", "Varchar(44)", true, true, true, false));
            this.add(new FixedColumnInfo("fixed_purchaseOrgUnitName", "NVARCHAR(255)", false, true, true, false));
            this.add(new FixedColumnInfo("fixed_unVmiSettleBaseQty", "Numeric(21,8)", false, false, true, true));
            this.add(new FixedColumnInfo("fixed_currentVmiSettleQty", "Numeric(21,8)", false, false, true, true));
            this.add(new FixedColumnInfo("fixed_vmiSettlePrice", "Numeric(21,8)", false, false, true, false));
            this.add(new FixedColumnInfo("fixed_vmiSettleTaxPrice", "Numeric(21,8)", false, false, true, false));
            this.add(new FixedColumnInfo("fixed_vmiSettleLocalPrice", "Numeric(21,8)", true, true, true, false));
            this.add(new FixedColumnInfo("fixed_taxRate", "Numeric(21,8)", false, true, true, false));
            this.add(new FixedColumnInfo("fixed_discountRate", "Numeric(21,8)", false, true, true, false));
            this.add(new FixedColumnInfo("fixed_isPresent", "Int", false, true, true, false));
            this.add(new FixedColumnInfo("fixed_editCtrl", "Int", true, true, true, false));
        }
    };
    private Context ctx = null;
    private FieldDefInfo config = null;

    public VMISettleSQLBuilder(Context ctx, FieldDefInfo config) {
        this.ctx = ctx;
        this.config = config;
    }

    public String getCreateTempTableSQL(boolean isTotal) {
        String tempName = isTotal ? "vmiSettleTotal" : "vmiSettleDetail";
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(tempName).append(" (");
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal) continue;
            sql.append("\n").append(entryInfo.getFieldTransferName()).append(" ").append(this.getSQLDataType(entryInfo)).append(",");
        }
        FixedColumnInfo fixedColumnInfo = null;
        int size2 = fixedColumns.size();
        for (int i = 0; i < size2; ++i) {
            fixedColumnInfo = fixedColumns.get(i);
            if ((!isTotal || !fixedColumnInfo.isForTotal()) && (isTotal || !fixedColumnInfo.isForDetail())) continue;
            sql.append("\n").append(fixedColumnInfo.getColumnName()).append(" ").append(fixedColumnInfo.getDataType()).append(",");
        }
        return sql.substring(0, sql.length() - 1) + ")";
    }

    public String getTotalInsertSql(String detailTableName, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTableName);
        sql.append("(");
        sql.append(this.getInsertSql(true));
        sql.append(")");
        sql.append("\n");
        sql.append("(select ").append(this.getSelectSql(true));
        sql.append("\n");
        sql.append("from ").append(detailTableName);
        sql.append("\n");
        sql.append("group by ").append(this.getGroupBySql()).append(")");
        return sql.toString();
    }

    public String getDetailInsertSql(String detailTableName, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(detailTableName);
        sql.append("(");
        sql.append(this.getInsertSql(false));
        sql.append(")");
        sql.append("\n");
        sql.append("select ").append(this.getSelectSql(false));
        sql.append("\n");
        sql.append(this.config.getQuery().getFromSQL());
        sql.append("\n");
        sql.append(this.getWhereSql(params));
        return sql.toString();
    }

    public String getWhereSql(RptParams params) {
        Set customerIdSet;
        String customerId;
        Set warehouseIdSet;
        String warehouseId;
        Date bizDateTo;
        Set supplierIdSet;
        String supplierIdIds;
        Set storageOrgUnitIdSet;
        String storageOrgUnitIds;
        StringBuffer sql = new StringBuffer();
        sql.append("where ");
        Set companyOrgUnitIdSet = VMISettleUtil.getSelectIds(params.getObject("currentCompanyOrgUnit"));
        String companyOrgUnitIds = VMISettleUtil.getSqlIds(companyOrgUnitIdSet);
        if (companyOrgUnitIds != null) {
            sql.append(" companyOrgUnit.FID  in (").append(companyOrgUnitIds).append(")");
        }
        if ((storageOrgUnitIds = VMISettleUtil.getSqlIds(storageOrgUnitIdSet = VMISettleUtil.getSelectIds(params.getObject("storageOrgUnit")))) != null) {
            sql.append(" and storageOrgUnit.FID  in (").append(storageOrgUnitIds).append(")");
        }
        if ((supplierIdIds = VMISettleUtil.getSqlIds(supplierIdSet = VMISettleUtil.getSelectIds(params.getObject("supplier")))) != null) {
            sql.append(" and supplier.FID  in (").append(supplierIdIds).append(")");
        }
        Object materialFrom = params.getObject("materialFrom");
        MaterialInfo materialTo = (MaterialInfo)params.getObject("materialTo");
        Date bizDateFrom = (Date)params.getObject("bizDateFrom");
        if (bizDateFrom != null) {
            sql.append(" and ").append(this.config.getQuery().getMainTable().getTableAlias()).append(".fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate(bizDateFrom)).append("')");
        }
        if ((bizDateTo = (Date)params.getObject("bizDateTo")) != null) {
            sql.append(" and ").append(this.config.getQuery().getMainTable().getTableAlias()).append(".fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate(bizDateTo)).append("')");
        }
        if (materialFrom != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)materialFrom);
            if (numArray[0] != null) {
                sql.append(" and material.FNumber>='" + numArray[0] + "'");
            } else if (numArray[1] != null) {
                sql.append(" and material.FNumber in (" + numArray[1] + ")");
            }
        }
        if (materialTo != null) {
            sql.append(" and material.FNumber<='" + materialTo.getNumber() + "'");
        }
        if ((warehouseId = VMISettleUtil.getSqlIds(warehouseIdSet = VMISettleUtil.getSelectIds(params.getObject("warehouse")))) != null) {
            sql.append(" and warehouse.FID  in (").append(warehouseId).append(")");
        }
        if ((customerId = VMISettleUtil.getSqlIds(customerIdSet = VMISettleUtil.getSelectIds(params.getObject("customer")))) != null) {
            sql.append(" and customer.FID  in (").append(customerId).append(")");
        }
        sql.append(" and ").append(this.config.getQuery().getMainTable().getTableAlias()).append(".FBaseStatus = 4 ");
        sql.append(" and storeTypePre.fid = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'");
        sql.append(" and entry.funVmiSettleBaseQty <>0");
        return sql.toString();
    }

    public String getInsertSql(boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal) continue;
            selectSql.append(entryInfo.getFieldTransferName()).append(",");
        }
        FixedColumnInfo fixedColumnInfo = null;
        int size2 = fixedColumns.size();
        for (int i = 0; i < size2; ++i) {
            fixedColumnInfo = fixedColumns.get(i);
            if ((!isTotal || !fixedColumnInfo.isForTotal()) && (isTotal || !fixedColumnInfo.isForDetail())) continue;
            selectSql.append(fixedColumnInfo.getColumnName()).append(",");
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    public String getQuerySelectSql(boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal) continue;
            selectSql.append(isTotal ? entryInfo.getFieldTransferName() : entryInfo.getFieldTableName()).append(",");
            if (!entryInfo.getFieldName().equals("baseUnit.name")) continue;
            FixedColumnInfo fixedColumnInfo = null;
            int length = fixedColumns.size();
            for (int j = 0; j < length; ++j) {
                fixedColumnInfo = fixedColumns.get(j);
                if ((!isTotal || !fixedColumnInfo.isForTotal()) && (isTotal || !fixedColumnInfo.isForDetail())) continue;
                selectSql.append(fixedColumnInfo.getColumnName()).append(",");
            }
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    public String getTableSelectSql(boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal) continue;
            selectSql.append(entryInfo.getFieldTransferName()).append(",");
            if (!entryInfo.getFieldName().equals("baseUnit.name")) continue;
            FixedColumnInfo fixedColumnInfo = null;
            int length = fixedColumns.size();
            for (int j = 0; j < length; ++j) {
                fixedColumnInfo = fixedColumns.get(j);
                if ((!isTotal || !fixedColumnInfo.isForTotal()) && (isTotal || !fixedColumnInfo.isForDetail())) continue;
                selectSql.append(fixedColumnInfo.getColumnName()).append(",");
            }
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    public String getSelectSql(boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal) continue;
            selectSql.append(isTotal ? entryInfo.getFieldTransferName() : entryInfo.getFieldTableName()).append(",");
        }
        if (isTotal) {
            selectSql.append("newbosid('88888888'),");
            selectSql.append("null,");
            selectSql.append("null,");
            selectSql.append("sum(").append("fixed_unVmiSettleBaseQty").append(")").append(",");
            selectSql.append("sum(").append("fixed_unVmiSettleBaseQty").append(")").append(",");
            selectSql.append(0).append(",");
            selectSql.append(0).append(",");
            selectSql.append(0).append(",");
            selectSql.append(0).append(",");
            selectSql.append(0).append(",");
            selectSql.append(0).append(",");
            selectSql.append(20).append(",");
        } else {
            selectSql.append(this.getEntryName()).append(".").append("funVmiSettleBaseQty").append(",");
            selectSql.append(this.getEntryName()).append(".").append("funVmiSettleBaseQty").append(",");
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    public String getGroupBySql() {
        StringBuffer groupBySql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = this.config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.config.getEntry().get(i);
            if (!entryInfo.isIsMerge()) continue;
            groupBySql.append(entryInfo.getFieldTransferName()).append(",");
        }
        return groupBySql.substring(0, groupBySql.length() - 1);
    }

    private String getSQLDataType(FieldEntryDefInfo entryInfo) {
        return VMISettleUtil.getDataTypeStr(this.ctx, entryInfo);
    }

    public List<FixedColumnInfo> getFixedColumns() {
        return fixedColumns;
    }

    public FieldDefInfo getConfig() {
        return this.config;
    }

    protected String getEntryName() {
        return "entry";
    }
}

