/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.app.helper.VMISettleSQLBuilder;
import com.kingdee.eas.scm.im.inv.vmi.info.FixedColumnInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Locale;

public class VMISettleTableBuilder {
    private Context ctx = null;
    private RptParams params = null;
    private VMISettleSQLBuilder sqlBuilder = null;

    public VMISettleTableBuilder(Context ctx, VMISettleSQLBuilder sqlBuilder, RptParams params) {
        this.ctx = ctx;
        this.params = params;
        this.sqlBuilder = sqlBuilder;
    }

    public RptTableHeader createTableHeader(Boolean isTotal) throws BOSException {
        RptTableHeader header = new RptTableHeader();
        FieldEntryDefInfo entryInfo = null;
        RptTableColumn col = null;
        ArrayList<FieldEntryDefInfo> entryList = new ArrayList<FieldEntryDefInfo>();
        if (isTotal.booleanValue()) {
            col = new RptTableColumn("tmpField");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("selected");
            col.setWidth(50);
            header.addColumn(col);
        }
        int size = this.sqlBuilder.getConfig().getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.sqlBuilder.getConfig().getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal.booleanValue()) continue;
            col = new RptTableColumn(entryInfo.getFieldTransferName());
            col.setWidth(-1);
            col.setHided(!entryInfo.isIsVisible());
            header.addColumn(col);
            entryList.add(entryInfo);
            if (!entryInfo.getFieldName().equals("baseUnit.name")) continue;
            FixedColumnInfo fixedColumnInfo = null;
            int length = this.sqlBuilder.getFixedColumns().size();
            for (int j = 0; j < length; ++j) {
                fixedColumnInfo = this.sqlBuilder.getFixedColumns().get(j);
                if ((!isTotal.booleanValue() || !fixedColumnInfo.isForTotal()) && (isTotal.booleanValue() || !fixedColumnInfo.isForDetail())) continue;
                col = new RptTableColumn(fixedColumnInfo.getColumnName());
                col.setWidth(-1);
                col.setHided(isTotal != false ? fixedColumnInfo.isTotalHide() : fixedColumnInfo.isDetailHide());
                header.addColumn(col);
            }
        }
        Object[][] labelData = null;
        int count = 0;
        if (isTotal.booleanValue()) {
            labelData = new Object[1][entryList.size() + this.sqlBuilder.getFixedColumns().size() + 2];
            labelData[0][0] = this.getResource(this.ctx, "tmpField");
            labelData[0][1] = this.getResource(this.ctx, "selected");
            count = 2;
        } else {
            labelData = new Object[1][entryList.size() + 2];
        }
        int size2 = entryList.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = (FieldEntryDefInfo)entryList.get(i);
            labelData[0][count] = entryInfo.getFieldAlias();
            ++count;
            if (!entryInfo.getFieldName().equals("baseUnit.name")) continue;
            FixedColumnInfo fixedColumnInfo = null;
            int length = this.sqlBuilder.getFixedColumns().size();
            for (int j = 0; j < length; ++j) {
                fixedColumnInfo = this.sqlBuilder.getFixedColumns().get(j);
                if ((!isTotal.booleanValue() || !fixedColumnInfo.isForTotal()) && (isTotal.booleanValue() || !fixedColumnInfo.isForDetail())) continue;
                labelData[0][count] = this.getResource(this.ctx, fixedColumnInfo.getColumnName());
                ++count;
            }
        }
        header.setLabels(labelData, true);
        return header;
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key, (Locale)ctx.getLocale());
    }
}

