/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VirtualBillVMIService {
    protected static final String CTX_TEMP_CHECKED_BIZDATE = "CTX_CONSTANT_CHECKED_BIZDATE";
    protected static final String CTX_TEMP_BILL_TRANSACTIONTYPE = "CTX_TEMP_BILL_TRANSACTIONTYPE";
    private static HashMap paramMap = new HashMap();
    private Context ctx = null;
    private Context aInvBillBaseInfo;

    public VirtualBillVMIService(Context ctx) throws EASBizException, BOSException {
        this.ctx = ctx;
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
    }

    public void afterAuditBill(IObjectValue model) throws BOSException, EASBizException {
        Boolean value;
        HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)this.ctx).getScmSpecialParams(new String[]{"isRefreshing", "isStartLog"});
        if (map.containsKey("isRefreshing") && (value = (Boolean)map.get("isRefreshing")).booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(this.ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            this.insertLots(this.ctx, (IObjectPK)pk, billInfo);
        }
        if ((paramMap.get("isCloseSerialNum") == null || !((Boolean)paramMap.get("isCloseSerialNum")).booleanValue()) && billInfo.getBizType().getId().toString().equals("kXeUoXWkByTgQKjAYj1F6CQHQ1w=")) {
            this.updateSerialNumInventory(this.ctx, billInfo);
        }
        if (this.isExistMoveAddAverageMaterial(this.ctx, billInfo)) {
            billInfo.put("IS_VMI_BIZ", true);
            this.calculate(this.ctx, billInfo);
            billInfo.remove("IS_VMI_BIZ");
            this.checkEntryMaterial(model);
        }
    }

    private void checkEntryMaterial(IObjectValue model) throws BOSException, InvBizException {
        if (model == null) {
            return;
        }
        boolean falg = false;
        if (!(model instanceof MaterialReqBillInfo) && !(model instanceof SaleIssueBillInfo)) {
            return;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        String table = "T_IM_MATERIALREQBILLENTRY";
        if (model instanceof SaleIssueBillInfo) {
            table = "T_IM_SALEISSUEENTRY";
        }
        if (falg = info.getTransactionType().isIsCalculate()) {
            String companyOrgUnitID = "";
            IObjectCollection entrys = (IObjectCollection)info.get("entry");
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(0);
            if (entry.getCompanyOrgUnit() != null) {
                companyOrgUnitID = entry.getCompanyOrgUnit().getId().toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" select top 1 fseq from " + table + " entry ");
            sb.append(" inner join T_IM_InvUpdateType updateType on entry.FInvUpdateTypeID = updateType.fid ");
            sb.append(" inner join T_IM_STORETYPE storeType on updateType.FStoreTypePreID = storeType.fid ");
            sb.append("inner join T_BD_MATERIALCOMPANYINFO company  ");
            sb.append(" on entry.FMaterialID = company.FMaterialID and company.FCompanyID  = '" + companyOrgUnitID + "' ");
            sb.append(" where entry.Fparentid = '").append(info.getId().toString()).append("' and company.FAccountType = 1 ");
            sb.append(" and entry.FActualCost = 0 and storeType.FIsForwardAmt = 1 and entry.fqty !=0");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            if (rs.size() > 0) {
                throw new InvBizException(InvBizException.MATERIAL_COST_EQUALS);
            }
        }
    }

    public void afterUnPassAudit(IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        BizTypeInfo bizType = aInvBillBaseInfo.getBizType();
        if ((bizType == null || !"mxmcXEczQ52MGxLV1Oyh9SQHQ1w=".equals(bizType.getId().toString()) && !"KVe1UEnNT260YmBCLwKZKSQHQ1w=".equals(bizType.getId().toString())) && this.isExistMoveAddAverageMaterial(this.ctx, aInvBillBaseInfo)) {
            this.calculate(this.ctx, aInvBillBaseInfo);
        }
        if (aInvBillBaseInfo instanceof SaleIssueBillInfo || aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
            ManualWriteOffFacadeFactory.getLocalInstance((Context)this.ctx).inverseWriteOff(new String[]{aInvBillBaseInfo.getId().toString()});
        }
    }

    private void updateInventory(Context ctx, BizActionEnum bizAction, String billID) throws BOSException, EASBizException {
        String bosType = new ObjectUuidPK(billID).getObjectType().toString();
        IBalanceCalculator calculator = BalanceCalculatorFactory.getCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="));
        OperationTypeEnum OPType = OperationTypeEnum.Positive;
        if (!BizActionEnum.AUDIT.equals((Object)bizAction)) {
            OPType = OperationTypeEnum.Reverse;
        }
        calculator.calculate(bosType, billID, OPType);
    }

    void calculate(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (!this.isJumpOrg(aInvBillBaseInfo.getBizType())) {
            CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
        }
    }

    protected void updateSerialNumInventory(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        String billtrypeid = billInfo.getBillType().getId().toString();
        if (!("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billtrypeid) || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billtrypeid))) {
            return;
        }
        boolean isSaleBack = false;
        TransactionTypeInfo tti = null;
        if (!"528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billtrypeid)) {
            if (billInfo.getTransactionType() == null || billInfo.getTransactionType().getId() == null) {
                return;
            }
            tti = billInfo.getTransactionType();
            if (tti.getRiType() == null) {
                tti = this.getTransactionTypeInfo(ctx, billInfo);
                billInfo.setTransactionType(tti);
            }
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtrypeid) && tti.getRiType().getBizDirection().getValue() == -1) {
                isSaleBack = true;
            }
        }
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        InvBillBaseEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        String[] seqUnitIDS = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            if (mapMaterialSeq != null && materialIds[i] != null && mapMaterialSeq.get(materialIds[i]) != null && mapMaterialSeq.get(materialIds[i]) instanceof MaterialInfo) {
                seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            }
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            MaterialInventoryInfo mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getStorageOrgUnit().getId().toString());
            if (mii == null || !mii.isIsSequenceNo() || ibb == null) continue;
            SerialNumberStatusEnum serialNumberStatusEnum = snstatus = "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billtrypeid) ? SerialNumberStatusEnum.INWAREHOUSE : InvCommonUtils.getSnStatusByTranType(tti, ibb.getInvUpdateType(), billInfo.isIsReversed() ^ InvAppUtils.isNegative(billInfo.getTransactionType()));
            if (SerialNumberStatusEnum.NULL == snstatus) continue;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(billInfo.isIsReversed());
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus == SerialNumberStatusEnum.SALE ? snstatus : SerialNumberStatusEnum.INWAREHOUSE);
            snInfo.setBillType(billInfo.getBillType());
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setStorageOrgUnit(ibb.getStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            snInfo.put("isSaleBack", isSaleBack);
            serialNumberInfos[i] = snInfo;
        }
        this.checkBillDuplicateSerialNumber(ctx, billInfo);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance(ctx);
        imsn.checkSerialNumber(true, (IObjectValue[])serialNumberInfos);
        imsn.updateSerialInventory(billInfo);
    }

    private void checkBillDuplicateSerialNumber(Context ctx, InvBillBaseInfo invbillBase) throws InvBizException, BOSException {
        Set<String> serialNumSet;
        if (null == invbillBase || invbillBase.getId() == null) {
            return;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)invbillBase.getId().toString()));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.serialNumber"));
        selector.add(new SelectorItemInfo("entry.id"));
        entityView.setSelector(selector);
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance(ctx);
        MaterialSerialNumberCollection msnCol = imsn.getMaterialSerialNumberCollection(entityView);
        HashMap allSerialNumMap = new HashMap();
        HashMap<MaterialInfo, HashSet<String>> duplicateSerialMap = new HashMap<MaterialInfo, HashSet<String>>();
        int len = msnCol.size();
        for (int i = 0; i < len; ++i) {
            MaterialSerialNumberInfo msn = msnCol.get(i);
            MaterialSerialNumberEntryCollection entryCol = msn.getEntry();
            if (null == entryCol || entryCol.size() <= 0 || msn.getMaterial() == null) continue;
            int size = entryCol.size();
            for (int k = 0; k < size; ++k) {
                MaterialSerialNumberEntryInfo entryInfo = entryCol.get(k);
                String key = msn.getMaterial().getId().toString() + entryInfo.getSerialNumber();
                if (allSerialNumMap.containsKey(key)) {
                    serialNumSet = (Set)duplicateSerialMap.get(msn.getMaterial());
                    if (null == serialNumSet) {
                        serialNumSet = new HashSet<String>();
                        duplicateSerialMap.put(msn.getMaterial(), (HashSet<String>)serialNumSet);
                    }
                    serialNumSet.add(entryInfo.getSerialNumber());
                    continue;
                }
                allSerialNumMap.put(key, null);
            }
        }
        if (duplicateSerialMap.size() > 0) {
            Set keySet = duplicateSerialMap.keySet();
            Iterator iterator = keySet.iterator();
            StringBuffer errorMsg = new StringBuffer();
            while (iterator.hasNext()) {
                MaterialInfo materialInfo = (MaterialInfo)iterator.next();
                errorMsg.append(" (").append(materialInfo.getNumber()).append(": ");
                serialNumSet = (HashSet<String>)duplicateSerialMap.get(materialInfo);
                for (String serialNumber : serialNumSet) {
                    errorMsg.append(serialNumber).append(",");
                }
                errorMsg.setLength(errorMsg.length() - 1);
                errorMsg.append(" ),");
            }
            errorMsg.setLength(errorMsg.length() - 1);
            throw new InvBizException(InvBizException.BILL_HAS_DUPLICATE_SERIALNUMBER, new String[]{errorMsg.toString()});
        }
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    protected void insertLots(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return;
        }
        if (tti.getBillType() == null) {
            tti = this.getTransactionTypeInfo(ctx, aInvBillBaseInfo);
        }
        String billTypeID = tti.getBillType().getId().toString();
        int bizDerection = tti.getRiType().getBizDirection().getValue();
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && bizDerection == 1 || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) && bizDerection == -1 || this.isRITypeForIndustry(ctx, (IObjectValue)aInvBillBaseInfo) && !aInvBillBaseInfo.isIsInitBill() && !aInvBillBaseInfo.isIsReversed() || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) && !this.isNeedInsertLots4PurRec(ctx, aInvBillBaseInfo)) {
                return;
            }
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance(ctx);
            if (aInvBillBaseInfo.getBillType().getId() != null) {
                ido.insertData(pk, aInvBillBaseInfo.getBillType().getId().toString());
            }
        }
    }

    public boolean isNeedSourceBillForIndustry() {
        return true;
    }

    public boolean isRITypeForIndustry(Context ctx, IObjectValue model) {
        return false;
    }

    private boolean isNeedInsertLots4PurRec(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 1 from T_IM_PurReceivalBill bill").append(" inner join T_IM_PurReceivalEntry e on e.fparentid = bill.fid ").append(" inner join T_IM_InvUpdateType invupd on e.finvUpdateTypeID = invupd.fid ").append(" where invupd.FIsNotUpdateInv = 0 and bill.fid = '").append(aInvBillBaseInfo.getId().toString()).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected TransactionTypeInfo getTransactionTypeInfo(Context ctx, InvBillBaseInfo invBillInfo) throws EASBizException, BOSException {
        Map<String, TransactionTypeInfo> transactionTypeMap;
        if (null == invBillInfo || invBillInfo.getTransactionType() == null) {
            return null;
        }
        if (ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE) != null && ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE) instanceof Map) {
            transactionTypeMap = (Map)ctx.get((Object)CTX_TEMP_BILL_TRANSACTIONTYPE);
        } else {
            transactionTypeMap = new HashMap();
            ctx.put((Object)CTX_TEMP_BILL_TRANSACTIONTYPE, transactionTypeMap);
        }
        String transactionTypeId = invBillInfo.getTransactionType().getId().toString();
        TransactionTypeInfo result = null;
        if (transactionTypeMap.containsKey(transactionTypeId)) {
            result = (TransactionTypeInfo)transactionTypeMap.get(transactionTypeId);
        } else {
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("*");
            selectorItemCollection.add("riType.*");
            result = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeId), selectorItemCollection);
            transactionTypeMap.put(transactionTypeId, result);
        }
        if (result == null) {
            result = invBillInfo.getTransactionType();
        }
        return result;
    }

    private boolean isExistMoveAddAverageMaterial(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return false;
        }
        Boolean falg = info.getTransactionType().isIsCalculate();
        if (falg.booleanValue()) {
            HashSet<String> materialIds = new HashSet<String>();
            IObjectCollection entrys = (IObjectCollection)info.get("entry");
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(0);
            String companyOrgUnitID = "";
            if (entry.getCompanyOrgUnit() != null && entry.getCompanyOrgUnit().getId() != null) {
                companyOrgUnitID = entry.getCompanyOrgUnit().getId().toString();
            }
            for (int i = 0; i < entrys.size(); ++i) {
                entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                materialIds.add(entry.getMaterial().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", materialIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("accountType", (Object)1, CompareType.EQUALS));
            return MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        return false;
    }
}

