/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class CheckEntryCoreSourceFieldVRule
extends AbstractServerVRule {
    public CheckEntryCoreSourceFieldVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo aInvbillbaseInfo = (InvBillBaseInfo)bean;
        this.checkEntrySourceBillForBOTP(aInvbillbaseInfo);
        boolean isSameCoreBillType = this.checkEntryCoreBillType(aInvbillbaseInfo);
        if (!isSameCoreBillType) {
            throw new InvBizException(InvBizException.CANNOTSUBMIT_NOTSAMECOREBILL);
        }
    }

    protected void checkEntrySourceBillForBOTP(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (aInvBillBaseInfo.getSourceBillType() != null) {
            IObjectCollection col = aInvBillBaseInfo.getEntries();
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = null;
            String billtypeId = null;
            BillTypeInfo billtype = new BillTypeInfo();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)col.getObject(i);
                if (aInvBillBaseEntryInfo.getSourceBillType() != null) continue;
                if (billtypeId == null) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select fid from t_scm_billtype where fbostype in ").append("(select FSrcEntityID from t_bot_relation where FDestObjectID = '").append(aInvBillBaseInfo.getId().toString()).append("')");
                    IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billtypeId = rs.getString("fid");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                billtype.setId(BOSUuid.read(billtypeId));
                aInvBillBaseInfo.setSourceBillType(billtype);
            }
        }
    }

    protected boolean checkEntryCoreBillType(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
            this.checkEntryCoreBillTypeForPurIn(aInvBillBaseInfo);
        }
        return true;
    }

    protected boolean checkEntryCoreBillTypeForPurIn(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)aInvBillBaseInfo;
        PurInWarehsEntryCollection collection = billInfo.getEntry();
        String coreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            coreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(coreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || coreBillTypeid == null) continue;
            return false;
        }
        return true;
    }
}

