/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.util.RefreshInventoryUtil;

public class CheckIsRefreshingInvVRule
extends AbstractServerVRule {
    public CheckIsRefreshingInvVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz) && !CostAdjustBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        Boolean isRefreshing = false;
        IObjectValue storageOrg = bean.getObjectValue("storageOrgUnit");
        if (storageOrg == null) {
            return;
        }
        String storageOrgId = storageOrg.getString("id");
        isRefreshing = RefreshInventoryUtil.isRefreshInventory(this.getCtx(), storageOrgId);
        if (isRefreshing.booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
    }
}

