/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckProjectTrackNoVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckProjectTrackNoVRule.class);

    public CheckProjectTrackNoVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz) || StockTransferBillInfo.class.isAssignableFrom(clazz) || StockReqInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillBaseInfo billInfo = (SCMBillBaseInfo)bean;
        IObjectCollection entrys = billInfo.getEntries();
        SCMBillEntryBaseInfo entry = null;
        boolean isSpecialBill = false;
        if (billInfo instanceof PurReceivalBillInfo || billInfo instanceof MaterialRequestBillInfo || billInfo instanceof StockTransferBillInfo || billInfo instanceof StockReqInfo || billInfo instanceof TransferOrderBillInfo) {
            isSpecialBill = true;
        }
        boolean isMaterialReqBill = false;
        if (billInfo instanceof MaterialReqBillInfo) {
            isMaterialReqBill = true;
        }
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            boolean isBotp;
            MaterialPlanInfo mpInfo;
            StorageOrgUnitInfo sou;
            entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || entry.getMaterial().getId() == null || (sou = this.getStorageOrgUnitInfo(billInfo, entry)) == null || sou.getId() == null || isMaterialReqBill && (entry.get("qty") == null || ((BigDecimal)entry.get("qty")).compareTo(BigDecimal.ZERO) == 0) || (mpInfo = this.getMaterialPlanInfo(entry.getMaterial().getId().toString(), sou.getId().toString())) == null) continue;
            boolean bl = isBotp = billInfo.getSourceBillType() != null;
            if (isSpecialBill) {
                SCMServerUtils.checkProjectTrackIsNotNull((Context)this.getCtx(), (boolean)isBotp, (int)(j + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)((ProjectInfo)entry.get("project")), (TrackNumberInfo)((TrackNumberInfo)entry.get("trackNumber")));
                continue;
            }
            InvServerUtils.checkProjectTrackIsNotNull(this.getCtx(), isBotp, j + 1, mpInfo, (ProjectInfo)entry.get("project"), (TrackNumberInfo)entry.get("trackNumber"));
        }
    }

    private StorageOrgUnitInfo getStorageOrgUnitInfo(SCMBillBaseInfo info, SCMBillEntryBaseInfo entry) {
        if (info instanceof MaterialRequestBillInfo) {
            return ((MaterialRequestBillEntryInfo)entry).getReceiveStorage();
        }
        if (info instanceof StockTransferBillInfo) {
            return ((StockTransferBillInfo)info).getIssueStorageOrgUnit();
        }
        if (info instanceof StockReqInfo) {
            return ((StockReqInfo)info).getReqStorage();
        }
        if (info instanceof TransferOrderBillInfo) {
            return ((TransferOrderBillEntryInfo)entry).getIssueStorageOrgUnit();
        }
        if (info instanceof InvBillBaseInfo) {
            return ((InvBillBaseInfo)info).getStorageOrgUnit();
        }
        return null;
    }

    private MaterialPlanInfo getMaterialPlanInfo(String materialId, String souId) throws BOSException {
        String key = materialId + souId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_PLAN)) {
            return (MaterialPlanInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_PLAN);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)souId));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("status");
        selector.add("manufactureStrategy.id");
        selector.add("isolatedRule");
        view.setSelector(selector);
        MaterialPlanCollection col = MaterialPlanFactory.getLocalInstance((Context)this.getCtx()).getMaterialPlanCollection(view);
        if (null != col && col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_PLAN);
            return col.get(0);
        }
        return null;
    }
}

