/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.inventoryinit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryInitBillInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class CheckQtyAndAmountVRule
extends AbstractServerVRule {
    public CheckQtyAndAmountVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InventoryInitBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache injectData) {
        super.setInjectData(injectData);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.checkQtyAndAmount(bean);
    }

    protected void checkQtyAndAmount(IObjectValue model) throws BOSException, EASBizException {
        InventoryInitBillInfo billInfo = (InventoryInitBillInfo)model;
        if (billInfo != null && billInfo.getEntry() != null) {
            InventoryInitEntryCollection entryCol = billInfo.getEntry();
            InventoryInitEntryInfo entry = null;
            MaterialCompanyInfoInfo matCouInfo = null;
            StoreTypeInfo storeType = null;
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entry = entryCol.get(i);
                if (entry.getMaterial() == null || entry.getCompanyOrgUnit() == null) continue;
                storeType = entry.getStoreType();
                if (storeType != null && storeType.get("isForwardAmt") == null) {
                    storeType = StoreTypeFactory.getLocalInstance((Context)this.getCtx()).getStoreTypeInfo((IObjectPK)new ObjectUuidPK(storeType.getId()));
                }
                if ((matCouInfo = this.getMaterialCompanyInfo(entry.getMaterial().getId().toString(), entry.getCompanyOrgUnit().getId().toString())).getAccountType().equals((Object)AccountType.MOVE_ADD_AVERAGE) && storeType.isIsForwardAmt()) {
                    if (entry.getAmount() != null && entry.getAmount().compareTo(BigDecimal.ZERO) != 0) continue;
                    throw new InvBizException(InvBizException.MOVE_ADD_AVERAGE_AMOUNT_NOTNULL, new Object[]{i + 1});
                }
                if (entry.getAmount() != null && entry.getAmount().compareTo(BigDecimal.ZERO) != 0 || entry.getQty() != null && entry.getQty().compareTo(BigDecimal.ZERO) != 0) continue;
                throw new InvBizException(InvBizException.QTY_AND_AMOUNT_NOTALLZERO, new Object[]{i + 1});
            }
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String couId) throws BOSException {
        assert (!StringUtils.isEmpty((String)couId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + couId, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + couId, DataTypeEnum.MATERIAL_COMPANY);
        }
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)couId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(sic);
        MaterialCompanyInfoCollection col = iMaterialCompany.getMaterialCompanyInfoCollection(entityViewInfo);
        MaterialCompanyInfoInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + couId, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        return info;
    }
}

