/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleException;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.util.NumericExceptionSubItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckProjectTrackNoVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckProjectTrackNoVRule.class);
    private String entryName;
    private String entry1Name;
    private NumericExceptionSubItem TRACKNUM_IS_NOT_NULL = MatAssembleException.ASS_TRACKNUM_IS_NOT_NULL;
    private NumericExceptionSubItem PROJECTNUM_IS_NOT_NULL = MatAssembleException.ASS_PROJECTNUM_IS_NOT_NULL;
    private NumericExceptionSubItem PROJECTTRACKNUM_IS_NOT_NULL = MatAssembleException.ASS_PROJECTTRACKNUM_IS_NOT_NULL;
    private InvBillBaseInfo invInfo;

    public CheckProjectTrackNoVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        if (MatAssembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entry";
            this.entry1Name = "entry1";
            return true;
        }
        if (MatDisassembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entries";
            this.entry1Name = "entries";
            this.TRACKNUM_IS_NOT_NULL = MatAssembleException.DISASS_TRACKNUM_IS_NOT_NULL;
            this.PROJECTNUM_IS_NOT_NULL = MatAssembleException.DISASS_PROJECTNUM_IS_NOT_NULL;
            this.PROJECTTRACKNUM_IS_NOT_NULL = MatAssembleException.DISASS_PROJECTTRACKNUM_IS_NOT_NULL;
            return true;
        }
        return false;
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.invInfo = (InvBillBaseInfo)bean;
        this.validate(bean, false);
    }

    private MaterialPlanInfo getMaterialPlanInfo(String materialId, String souId) throws BOSException {
        String key = materialId + souId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_PLAN)) {
            return (MaterialPlanInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_PLAN);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)souId));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("status");
        selector.add("manufactureStrategy.id");
        selector.add("isolatedRule");
        view.setSelector(selector);
        MaterialPlanCollection col = MaterialPlanFactory.getLocalInstance((Context)this.getCtx()).getMaterialPlanCollection(view);
        if (null != col && col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_PLAN);
            return col.get(0);
        }
        return null;
    }

    private void validate(IObjectValue bean, boolean isChildEntry) throws BOSException, EASBizException {
        IObjectValue billInfo = bean;
        String entryName = this.entryName;
        if (isChildEntry) {
            entryName = this.entry1Name;
        }
        IObjectCollection entrys = (IObjectCollection)billInfo.get(entryName);
        SCMBillEntryBaseInfo entry = null;
        StorageOrgUnitInfo sou = this.invInfo.getStorageOrgUnit();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
            if (entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                if (sou == null || sou.getId() == null) continue;
                MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(entry.getMaterial().getId().toString(), sou.getId().toString());
                if (mpInfo != null) {
                    if (isChildEntry) {
                        this.checkProjectTrackIsNotNull(this.getCtx(), j + 1, (Integer)billInfo.get("seq"), mpInfo, (ProjectInfo)entry.get("project"), (TrackNumberInfo)entry.get("trackNumber"), isChildEntry);
                    } else {
                        this.checkProjectTrackIsNotNull(this.getCtx(), j + 1, 0, mpInfo, (ProjectInfo)entry.get("project"), (TrackNumberInfo)entry.get("trackNumber"), isChildEntry);
                    }
                }
            }
            if (isChildEntry) continue;
            this.validate((IObjectValue)entry, true);
        }
    }

    private void checkProjectTrackIsNotNull(Context ctx, int rowIdx, int parentSeq, MaterialPlanInfo matPlanInfo, ProjectInfo projectNum, TrackNumberInfo trackNum, boolean isChildEntry) throws EASBizException, BOSException {
        Object[] msg = new String[]{"" + rowIdx};
        if (isChildEntry) {
            msg = new String[]{"" + parentSeq, "" + rowIdx};
        }
        if (matPlanInfo != null && matPlanInfo.getStatus() == UsedStatusEnum.APPROVED) {
            if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && (matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && trackNum == null) {
                if (!isChildEntry) {
                    throw new SCMBillException(SCMBillException.TRACKNUM_IS_NOT_NULL, msg);
                }
                throw new MatAssembleException(this.TRACKNUM_IS_NOT_NULL, msg);
            }
            if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM && projectNum == null) {
                    if (!isChildEntry) {
                        throw new SCMBillException(SCMBillException.PROJECTNUM_IS_NOT_NULL, msg);
                    }
                    throw new MatAssembleException(this.PROJECTNUM_IS_NOT_NULL, msg);
                }
                if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                    if (trackNum == null && projectNum == null) {
                        if (!isChildEntry) {
                            throw new SCMBillException(SCMBillException.PROJECTTRACKNUM_IS_NOT_NULL, msg);
                        }
                        throw new MatAssembleException(this.PROJECTTRACKNUM_IS_NOT_NULL, msg);
                    }
                    if (projectNum == null) {
                        if (!isChildEntry) {
                            throw new SCMBillException(SCMBillException.PROJECTNUM_IS_NOT_NULL, msg);
                        }
                        throw new MatAssembleException(this.PROJECTNUM_IS_NOT_NULL, msg);
                    }
                    if (trackNum == null) {
                        if (!isChildEntry) {
                            throw new SCMBillException(SCMBillException.TRACKNUM_IS_NOT_NULL, msg);
                        }
                        throw new MatAssembleException(this.TRACKNUM_IS_NOT_NULL, msg);
                    }
                }
            }
        }
    }
}

