/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.util.Date;

public class CheckMoveBetweenOrg4MaterialReqVRule
extends AbstractServerVRule {
    public CheckMoveBetweenOrg4MaterialReqVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MaterialReqBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        MaterialReqBillInfo info = (MaterialReqBillInfo)bean;
        this.checkJumpOrgBill4Audit(info);
    }

    private void checkJumpOrgBill4Audit(MaterialReqBillInfo info) throws EASBizException, BOSException {
        if (info.getBizType() != null) {
            PeriodInfo demandPeriod;
            PeriodInfo supplyPeriodInfo;
            String bizTypeID = info.getBizType().getId().toString();
            if (!bizTypeID.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
                return;
            }
            CompanyOrgUnitInfo demandCompanyOrg = info.getDemandCompanyOrgUnit();
            CompanyOrgUnitInfo supplyCompanyOrg = info.getSupplyCompanyOrgUnit();
            boolean isStart = SystemStatusCtrolUtils.isStart((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)supplyCompanyOrg);
            if (!isStart) {
                throw new InvBizException(InvBizException.COMPANY_PERIOD_NOT_START);
            }
            Date bizDate = info.getBizDate();
            PeriodInfo supplyCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)supplyCompanyOrg);
            boolean flag = this.checkBizPeriod(supplyCurrentPeriod, supplyPeriodInfo = PeriodUtils.getPeriodInfo((Context)this.getCtx(), (Date)bizDate, (CompanyOrgUnitInfo)supplyCompanyOrg), true);
            if (flag) {
                throw new InvBizException(InvBizException.COMPANY_NOTPERIOD_OR_ISCOLSE);
            }
            PeriodInfo demandCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)demandCompanyOrg);
            flag = this.checkBizPeriod(demandCurrentPeriod, demandPeriod = PeriodUtils.getPeriodInfo((Context)this.getCtx(), (Date)bizDate, (CompanyOrgUnitInfo)demandCompanyOrg), true);
            if (flag) {
                throw new InvBizException(InvBizException.COMPANY_NOTPERIOD_OR_ISCOLSE);
            }
            boolean demandIsColse = SystemStatusCtrolUtils.isClose((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)demandCompanyOrg);
            boolean supplyIsColse = SystemStatusCtrolUtils.isClose((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)supplyCompanyOrg);
            boolean demandIsAfterCurrentPeriod = this.checkBizPeriod(demandCurrentPeriod, demandPeriod, false);
            boolean supplyIsAfterCurrentPeriod = this.checkBizPeriod(supplyCurrentPeriod, supplyPeriodInfo, false);
            if (demandIsColse && !demandIsAfterCurrentPeriod || supplyIsColse && !supplyIsAfterCurrentPeriod) {
                throw new InvBizException(InvBizException.COMPANY_NOTPERIOD_OR_ISCOLSE);
            }
        }
    }

    private boolean checkBizPeriod(PeriodInfo supplyCurrentPeriod, PeriodInfo supplyPeriodInfo, boolean isBeforeCurrentPeriod) {
        boolean flag = false;
        if (supplyPeriodInfo == null || supplyCurrentPeriod == null) {
            flag = true;
        } else {
            int supplyYear = supplyPeriodInfo.getPeriodYear();
            int supplyNumber = supplyPeriodInfo.getNumber();
            int currentYear = supplyCurrentPeriod.getPeriodYear();
            int currentNumber = supplyCurrentPeriod.getNumber();
            if (isBeforeCurrentPeriod) {
                if (supplyYear < currentYear || supplyYear == currentYear && supplyNumber < currentNumber) {
                    flag = true;
                }
            } else if (supplyYear > currentYear || supplyYear == currentYear && supplyNumber > currentNumber) {
                flag = true;
            }
        }
        return flag;
    }
}

