/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;

public class CheckUnitVRule
extends AbstractServerVRule {
    private static final String resName = "com.kingdee.eas.scm.im.SCM_IMResource";

    public CheckUnitVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MaterialReqBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        MaterialReqBillEntryInfo entryInfo;
        MaterialReqBillInfo info = (MaterialReqBillInfo)bean;
        MaterialReqBillEntryCollection billEntry = info.getEntry();
        boolean hasException = false;
        StringBuffer errorMessage = new StringBuffer();
        String[] materiaIds = new String[billEntry.size()];
        String[] unitIds = new String[billEntry.size()];
        int size = billEntry.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = billEntry.get(i);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unit = entryInfo.getUnit();
            materiaIds[i] = materialInfo.getId().toString();
            unitIds[i] = unit.getId().toString();
        }
        HashMap map = SCMServerUtils.getMultiMeasureUnits((Context)this.getCtx(), (String[])materiaIds, (String[])unitIds);
        String row = ResourceBase.getString((String)resName, (String)"Row", (Locale)this.getCtx().getLocale());
        int size2 = billEntry.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = billEntry.get(i);
            String materialId = materiaIds[i];
            String unitId = unitIds[i];
            Object value = map.get(materialId + unitId);
            if (value != null) continue;
            hasException = true;
            errorMessage.append(ResourceBase.getString((String)resName, (String)"The", (Locale)this.getCtx().getLocale())).append(entryInfo.getSeq()).append(row);
        }
        if (hasException) {
            throw new InvException(InvException.UNIT_NOT_IN_MATERIAL_UNIT_GROUP, (Object[])new String[]{errorMessage.toString()});
        }
    }
}

