/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.materialreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.util.HashMap;

public class CheckMaterialReqData4SubmitVRule
extends AbstractServerVRule {
    public CheckMaterialReqData4SubmitVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MaterialReqBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)bean;
        this.checkForMaterialSupplier(info);
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    private void checkForMaterialSupplier(MaterialReqBillInfo info) throws BOSException, EASBizException {
        if (!this.isJumpOrg(info.getBizType())) {
            return;
        }
        MaterialReqBillEntryCollection entryColl = info.getEntry();
        MaterialReqBillEntryInfo entry = null;
        HashMap<String, String> materialSupplierMap = new HashMap<String, String>();
        boolean isNotDup = false;
        for (int i = 0; i < entryColl.size(); ++i) {
            String supplierID;
            entry = entryColl.get(i);
            String materialID = entry.getMaterial() != null ? entry.getMaterial().getId().toString() : null;
            String string = supplierID = entry.getSupplier() != null ? entry.getSupplier().getId().toString() : null;
            if (materialSupplierMap.containsKey(materialID)) {
                if (materialSupplierMap.get(materialID) == null && supplierID != null) {
                    isNotDup = true;
                    break;
                }
                if (materialSupplierMap.get(materialID) == null || ((String)materialSupplierMap.get(materialID)).equals(supplierID)) continue;
                isNotDup = true;
                break;
            }
            materialSupplierMap.put(materialID, supplierID);
        }
        if (isNotDup) {
            throw new InvBizException(InvBizException.MATERIALREQ_JUMPORG_MATERIALSUPPLIER);
        }
    }
}

