/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.move;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;

public class CheckSourceBillQty4MoveInVRule
extends AbstractServerVRule {
    public CheckSourceBillQty4MoveInVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MoveInWarehsBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        if (bean instanceof MoveInWarehsBillInfo) {
            String tableName = "T_IM_MoveInWarehsBillEntry";
            if (SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableName, (String)((MoveInWarehsBillInfo)bean).getId().toString())) {
                return;
            }
        }
        this.checkSourceBillQty(this.getCtx(), (MoveInWarehsBillInfo)bean);
    }

    private void checkSourceBillQty(Context ctx, MoveInWarehsBillInfo info) throws BOSException, InvBizException {
        BillTypeInfo sourceBillType = info.getEntry().get(0).getSourceBillType();
        String sourceBillTable = null;
        if (sourceBillType == null) {
            return;
        }
        if (sourceBillType.getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
            sourceBillTable = "T_IM_TransferOrderBillEntry";
        }
        if (sourceBillType.getId().toString().equals("50957179-0105-1000-e003-3152c0a812fd463ED552")) {
            sourceBillTable = "T_IM_StockTransferBillEntry";
            return;
        }
        if (sourceBillTable == null) {
            return;
        }
        HashMap<String, BigDecimal> moveInBill = new HashMap<String, BigDecimal>();
        StringBuffer idsb = new StringBuffer();
        MoveInWarehsBillEntryInfo entry = null;
        String soruceBillEntryid = null;
        BigDecimal totalQty = null;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entry = info.getEntry().get(i);
            soruceBillEntryid = entry.getSourceBillEntryId();
            idsb.append("'").append(soruceBillEntryid).append("',");
            totalQty = (BigDecimal)moveInBill.get(soruceBillEntryid);
            totalQty = totalQty == null ? entry.getBaseQty() : totalQty.add(entry.getBaseQty());
            moveInBill.put(soruceBillEntryid, totalQty);
        }
        String ids = idsb.substring(0, idsb.length() - 1);
        StringBuffer sb = new StringBuffer();
        sb.append(" select fid,FIssuebaseQty,FReceiptBaseQty from ").append(sourceBillTable);
        sb.append("  where fid in (").append(ids).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            String soruceEntryID = null;
            BigDecimal issueBaseQty = BigDecimal.ZERO;
            BigDecimal receiptBaseQty = BigDecimal.ZERO;
            BigDecimal qty = BigDecimal.ZERO;
            while (rs.next()) {
                soruceEntryID = rs.getString("fid");
                issueBaseQty = rs.getBigDecimal("FIssuebaseQty");
                receiptBaseQty = rs.getBigDecimal("FReceiptBaseQty");
                if (moveInBill.get(soruceEntryID) == null || (qty = (BigDecimal)moveInBill.get(soruceEntryID)).compareTo(issueBaseQty.subtract(receiptBaseQty)) <= 0) continue;
                throw new InvBizException(InvBizException.MBENTRYQTR_MORE_SOURCEENTRYISSUEQTY);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

