/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.move;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class CheckSourceBillState4MoveInOrOutVRule
extends AbstractServerVRule {
    public CheckSourceBillState4MoveInOrOutVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MoveInWarehsBillInfo.class.isAssignableFrom(clazz) || MoveIssueBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        String tableName = "";
        assert (bean != null);
        if (bean instanceof MoveInWarehsBillInfo) {
            tableName = "T_IM_MoveInWarehsBillEntry";
        } else if (bean instanceof MoveIssueBillInfo) {
            tableName = "T_IM_MoveIssueBillEntry";
        }
        if (!StringUtils.isEmpty((String)tableName) && SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableName, (String)bean.get("id").toString())) {
            return;
        }
        this.checkSourceBillState(this.getCtx(), bean);
    }

    private void checkSourceBillState(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean isBotp;
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        boolean isReversed = info.isIsReversed();
        boolean bl = isBotp = !isReversed && info.getSourceBillType() != null;
        if (!isBotp) {
            return;
        }
        HashSet<String> sourceID = new HashSet<String>();
        if (info.getSourceBillType() == null || info.getSourceBillType().getId() == null) {
            return;
        }
        String sbilltype = info.getSourceBillType().getId().toString();
        if (info instanceof MoveInWarehsBillInfo && "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(sbilltype)) {
            MoveInWarehsBillEntryCollection entrys = ((MoveInWarehsBillInfo)info).getEntry();
            for (int i = 0; i < entrys.size(); ++i) {
                sourceID.add(entrys.get(i).getSourceBillEntryId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("sourceBillEntryId");
            selector.add("parent.sourceBillType.id");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", sourceID, CompareType.INCLUDE));
            view.setSelector(selector);
            view.setFilter(filter);
            MoveIssueBillEntryCollection issueEntrys = MoveIssueBillEntryFactory.getLocalInstance(ctx).getMoveIssueBillEntryCollection(view);
            BillTypeInfo sourceBillType = issueEntrys.get(0).getParent().getSourceBillType();
            if (sourceBillType == null || !"50957179-0105-1000-e003-3152c0a812fd463ED552".equals(sourceBillType.getId().toString())) {
                return;
            }
            sourceID.clear();
            for (int i = 0; i < issueEntrys.size(); ++i) {
                sourceID.add(issueEntrys.get(i).getSourceBillEntryId().toString());
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", sourceID, CompareType.INCLUDE));
            boolean exists = StockTransferBillEntryFactory.getLocalInstance(ctx).exists(filter);
            if (exists) {
                throw new InvUpdateException(InvUpdateException.INMOVEBILL_IS_NOT_AUDITSTATE);
            }
        }
    }
}

