/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.other;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.AdjustException;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class CheckAdjustDiffVEntryQtyRule
extends AbstractServerVRule {
    public CheckAdjustDiffVEntryQtyRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return OtherIssueBillInfo.class.isAssignableFrom(clazz) || OtherInWarehsBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        if (bean instanceof OtherInWarehsBillInfo) {
            this.checkEntryQty4In(this.getCtx(), (OtherInWarehsBillInfo)bean);
        } else {
            this.checkEntryQty4Issue(this.getCtx(), (OtherIssueBillInfo)bean);
        }
    }

    private void checkEntryQty4In(Context ctx, OtherInWarehsBillInfo billInfo) throws AdjustException {
        OtherInWarehsBillEntryCollection entrys = billInfo.getEntry();
        int size = entrys.size();
        boolean isError = false;
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ADJUST_BILL_NUMBER", (Locale)ctx.getLocale(), (Object[])new Object[]{billInfo.getNumber()})).append("\n");
        for (int i = 0; i < size; ++i) {
            OtherInWarehsBillEntryInfo entry = entrys.get(i);
            if (entry.getQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || entry.getBaseQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || entry.getAssistQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
            isError = true;
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"OTHER_QTY_NOT_ALL_ZERO", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1})).append("\n");
        }
        if (isError) {
            throw new AdjustException(AdjustException.PART_NO_DIFFER, new Object[]{sb.toString()});
        }
    }

    private void checkEntryQty4Issue(Context ctx, OtherIssueBillInfo billInfo) throws AdjustException {
        OtherIssueBillEntryCollection entrys = billInfo.getEntry();
        int size = entrys.size();
        boolean isError = false;
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ADJUST_BILL_NUMBER", (Locale)ctx.getLocale(), (Object[])new Object[]{billInfo.getNumber()})).append("\n");
        for (int i = 0; i < size; ++i) {
            OtherIssueBillEntryInfo entry = entrys.get(i);
            if (entry.getQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || entry.getBaseQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || entry.getAssistQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
            isError = true;
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"OTHER_QTY_NOT_ALL_ZERO", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1})).append("\n");
        }
        if (isError) {
            throw new AdjustException(AdjustException.PART_NO_DIFFER, new Object[]{sb.toString()});
        }
    }
}

