/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvImportException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CheckPurInAlgorithmForImportVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurInWarehsBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)bean;
        PurInWarehsEntryCollection entryCol = info.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            PurInWarehsEntryInfo entry = entryCol.get(i);
            this.checkAmount(entry);
            this.checkPurchaseCost(entry);
            this.checkActualCost(entry);
            this.checkPrice(entry);
            this.checkTaxPrice(entry);
            this.checkUnitPurchaseCost(entry);
            this.checkUnitActualCost(entry);
            this.checkExchangeRate(info, entry);
        }
    }

    private void checkPrice(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal amount = entry.getAmount();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal price = entry.getPrice();
        BigDecimal realDiscountRate = SCMConstant.BIGDECIMAL_ONEHUNDRED.subtract(discountRate).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, RoundingMode.HALF_UP);
        boolean success = false;
        if (amount.divide(realDiscountRate, amount.scale() + realDiscountRate.scale(), RoundingMode.HALF_UP).divide(qty, price.scale(), RoundingMode.HALF_UP).compareTo(price) == 0) {
            success = true;
        } else if (price.multiply(qty).multiply(realDiscountRate).setScale(amount.scale(), RoundingMode.HALF_UP).compareTo(amount) == 0) {
            success = true;
        }
        if (!success) {
            throw new InvImportException(InvImportException.PRICE_INVALID);
        }
    }

    private void checkActualCost(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal actualCost = entry.getActualCost();
        BigDecimal purchaseFee = entry.getPurchaseFee();
        BigDecimal materialCost = entry.getMaterialCost();
        BigDecimal purchaseCost = entry.getPurchaseCost();
        if (purchaseFee.add(purchaseCost).add(materialCost).compareTo(actualCost) != 0) {
            throw new InvImportException(InvImportException.ACTUALCOST_INVALID);
        }
    }

    private void checkTaxPrice(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = SCMConstant.BIGDECIMAL_ONEHUNDRED.subtract(entry.getDiscountRate()).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, RoundingMode.HALF_UP);
        BigDecimal taxPrice = entry.getTaxPrice();
        boolean success = false;
        if (taxAmount.divide(qty.multiply(discountRate), taxPrice.scale(), RoundingMode.HALF_UP).compareTo(taxPrice) == 0) {
            success = true;
        } else if (qty.multiply(taxPrice).multiply(discountRate).setScale(taxAmount.scale(), RoundingMode.HALF_UP).compareTo(taxAmount) == 0) {
            success = true;
        }
        if (!success) {
            throw new InvImportException(InvImportException.TAXPRICE_INVALID);
        }
    }

    private void checkUnitPurchaseCost(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal purchaseCost = entry.getPurchaseCost();
        BigDecimal unitPurchaseCost = entry.getUnitPurchaseCost();
        BigDecimal qty = entry.getQty();
        boolean success = false;
        if (purchaseCost.divide(qty, unitPurchaseCost.scale(), RoundingMode.HALF_UP).compareTo(unitPurchaseCost) == 0) {
            success = true;
        } else if (unitPurchaseCost.multiply(qty).setScale(purchaseCost.scale(), RoundingMode.HALF_UP).compareTo(purchaseCost) == 0) {
            success = true;
        }
        if (!success) {
            throw new InvImportException(InvImportException.UNITPURCHASECOST_INVALID);
        }
    }

    private void checkExchangeRate(PurInWarehsBillInfo info, PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal purchaseCost = entry.getPurchaseCost();
        BigDecimal amount = entry.getAmount();
        BigDecimal exchangeRate = info.getExchangeRate();
        boolean success = false;
        if (purchaseCost.multiply(exchangeRate).setScale(amount.scale(), RoundingMode.HALF_UP).compareTo(amount) == 0) {
            success = true;
        } else if (purchaseCost.divide(exchangeRate, amount.scale(), RoundingMode.HALF_UP).compareTo(amount) == 0) {
            success = true;
        }
        if (!success) {
            throw new InvImportException(InvImportException.EXCHANGERATE_INVALID);
        }
    }

    private void checkUnitActualCost(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal qty;
        BigDecimal unitActualCost = entry.getUnitActualCost();
        BigDecimal actualCost = entry.getActualCost();
        if (actualCost.divide(qty = entry.getQty(), unitActualCost.scale(), RoundingMode.HALF_UP).compareTo(unitActualCost) != 0) {
            throw new InvImportException(InvImportException.UNITACTUALCOST_INVALID);
        }
    }

    private void checkAmount(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal tax = entry.getTax();
        BigDecimal amount = entry.getAmount();
        if (taxAmount.subtract(tax).compareTo(amount) != 0) {
            throw new InvImportException(InvImportException.AMOUNT_INVALID);
        }
    }

    private void checkPurchaseCost(PurInWarehsEntryInfo entry) throws InvImportException {
        BigDecimal localTaxAmount = entry.getLocalTaxAmount();
        BigDecimal localTax = entry.getLocalTax();
        BigDecimal purchaseCOst = entry.getPurchaseCost();
        if (localTaxAmount.subtract(localTax).compareTo(purchaseCOst) != 0) {
            throw new InvImportException(InvImportException.PURCHASECOST_INVALID);
        }
    }
}

