/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckSaleIssueCanUnAuditVRule
extends AbstractServerVRule {
    private Map<String, SaleOrderInfo> srcOrderCache = new HashMap<String, SaleOrderInfo>();

    public CheckSaleIssueCanUnAuditVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleIssueBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SaleIssueBillInfo invBillBaseInfo = (SaleIssueBillInfo)bean;
        if (this.isHasBizFlow(invBillBaseInfo)) {
            return;
        }
        boolean isConsReturn = SCMBaseCommonUtil.isConsRtSaleIssueBill((BizTypeInfo)invBillBaseInfo.getBizType(), (TransactionTypeInfo)invBillBaseInfo.getTransactionType());
        if (invBillBaseInfo.getSourceBillType() == null && isConsReturn) {
            String sql = "select * from T_SD_ConsignSaleBillEntry where FSourceBillMID='" + invBillBaseInfo.getId().toString() + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql);
                if (rs != null && rs.next()) {
                    throw new InvBizException(InvBizException.CONSISRETURNS_NOT_UNAUDIT);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        boolean connotUnAudit = true;
        SaleIssueEntryCollection entryCollection = invBillBaseInfo.getEntry();
        BigDecimal zero = new BigDecimal("0.00");
        SaleIssueEntryInfo entry = null;
        if (BillBaseStatusEnum.AUDITED.equals((Object)invBillBaseInfo.getBaseStatus())) {
            BillTypeInfo sourceTypeInfo = invBillBaseInfo.getSourceBillType();
            String sourceType = null;
            if (sourceTypeInfo != null) {
                sourceType = sourceTypeInfo.getId().toString();
                SaleOrderInfo saleOrderInfo = null;
                SaleOrderEntryInfo saleOrderEntry = null;
                String paramID = null;
                int size = entryCollection.size();
                for (int i = 0; i < size && sourceTypeInfo != null; ++i) {
                    String coreType;
                    sourceType = sourceTypeInfo.getId().toString();
                    entry = entryCollection.get(i);
                    if (entry.getCoreBillType() == null || !"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType = entry.getCoreBillType().getId().toString())) break;
                    if (!"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType) || "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceType) || entry.getSaleOrder() == null || entry.getSaleOrgUnit() == null) continue;
                    saleOrderInfo = this.getSrcSaleOrderInfo(entry.getSaleOrder());
                    if (i == 0) {
                        paramID = ParamManager.getParamValue((Context)this.getCtx(), (IObjectPK)new ObjectUuidPK(entryCollection.get(0).getSaleOrgUnit().getId()), (String)"SCM_SALEISSUEBILL_AUDIT");
                    }
                    if (!BillBaseStatusEnum.CLOSED.equals((Object)saleOrderInfo.getBaseStatus())) {
                        SaleOrderEntryCollection saleOrderEntryCollection = saleOrderInfo.getEntries();
                        saleOrderEntry = saleOrderEntryCollection.get((Object)BOSUuid.read((String)entry.getSaleOrderEntry()));
                        if (!saleOrderEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED) || Boolean.valueOf(paramID).booleanValue()) continue;
                        connotUnAudit = false;
                        break;
                    }
                    if (Boolean.valueOf(paramID).booleanValue()) continue;
                    connotUnAudit = false;
                    break;
                }
            }
        }
        if (!connotUnAudit) {
            throw new SCMBillException(SCMBillException.SALEORDERENTRYCLOSED_CONNOTUNAUDIT, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
        if (this.getCtx().get((Object)"isSettleAction") == null) {
            int size = entryCollection.size();
            for (int i = 0; i < size; ++i) {
                entry = entryCollection.get(i);
                if (entry.getTotalSettleQty() == null || entry.getTotalSettleQty().compareTo(zero) == 0) continue;
                throw new SCMBillException(SCMBillException.CHECK_UNSETTLEQTY_UNAUDIT, new Object[]{i + 1 + ""});
            }
        }
    }

    private SaleOrderInfo getSrcSaleOrderInfo(String srcOrderId) throws EASBizException, BOSException {
        SaleOrderInfo result = this.srcOrderCache.get(srcOrderId);
        if (result == null) {
            SelectorItemCollection sic = null;
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseStatus"));
            sic.add(new SelectorItemInfo("entries.baseStatus"));
            result = SaleOrderFactory.getLocalInstance((Context)this.getCtx()).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(srcOrderId), sic);
            this.srcOrderCache.put(srcOrderId, result);
        }
        return result;
    }

    private boolean isHasBizFlow(SaleIssueBillInfo info) throws BOSException {
        boolean isHasValue = false;
        if (info == null) {
            return isHasValue;
        }
        String tableName = "T_IM_SaleIssueEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            idSet.add(info.getEntry().get(i).getId().toString());
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableName, idSet)) {
            isHasValue = true;
        }
        return isHasValue;
    }
}

