/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.TransferOrderBillException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;

public class CheckBotpBillStorageVRule
extends AbstractServerVRule {
    public CheckBotpBillStorageVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)bean;
        if (this.isBotpBill(billInfo, "MmEE6VBsR0KaUDQmebwhP0Y+1VI=") && billInfo.getIssueStorageOrgUnit() == null && billInfo.getReceiptStorageOrgUnit() == null && this.getCtx().get((Object)"TO_CREATE_FROM_STOCKREQ") == null) {
            throw new TransferOrderBillException(TransferOrderBillException.CAN_NOT_CREATE_TO_BY_REQUIRE);
        }
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (this.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }
}

