/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.reservation.IReservationFacade;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationObjectFactory;
import com.kingdee.eas.scm.im.reservation.ReservationObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.app.AbstractReservationControllerBean;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReservationControllerBean
extends AbstractReservationControllerBean {
    private static final long serialVersionUID = 5118027910658876506L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.ReservationControllerBean");
    Map<String, IObjectValue> map = new HashMap<String, IObjectValue>();
    Map<String, ReservationObjectInfo> reservationObjectMap = new HashMap<String, ReservationObjectInfo>();
    List supplyBillReservationDataList = new ArrayList();
    List inventoryIDList = new ArrayList();
    List supplyEntryList = new ArrayList();
    List supplyBillList = new ArrayList();
    ObjectUuidPK reservationObjectPK = null;
    String supplyObjectBosType = "";
    String requireBillEntryId = "";
    ObjectUuidPK requireBillObjectPK = null;
    String requireBillBosType = "";
    String supplyBaseQtyPropertyName = "";
    IObjectCollection supplyObjectCollection;
    InventoryCollection inventoryCollection;
    List inventoryReservationList = new ArrayList();
    List supplyObjectReservationList = new ArrayList();
    Map<String, Set<String>> cancelRequireEntryMap = new HashMap<String, Set<String>>();
    Map<String, Set<String>> cancelSupplyBillMap = new HashMap<String, Set<String>>();
    Map<String, Set<String>> cancelSupplyBillEntryMap = new HashMap<String, Set<String>>();
    static Map<String, String> hasReservationRequireBillMap = new HashMap<String, String>();
    static Map<String, String> hasReservationSupplyObjectMap = new HashMap<String, String>();

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReservationInfo info = this.getReservationInfo(ctx, pk);
        return info.toString();
    }

    String getBillSomething(Context ctx, String id, String propertyName) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        String str = "";
        IObjectValue model = null;
        if (this.map.containsKey(id)) {
            model = this.map.get(id);
        } else {
            ObjectUuidPK pk;
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            model = iDynamicObject.getValue((pk = new ObjectUuidPK(id)).getObjectType(), (IObjectPK)pk);
            if (model != null) {
                this.map.put(id, model);
            }
        }
        if (model != null) {
            str = model.getString(propertyName);
        }
        return str;
    }

    @Override
    protected ArrayList _doObjectReservation(Context ctx, List reservationObjectList) throws BOSException, EASBizException {
        Object pk;
        ArrayList error = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)reservationObjectList)) {
            return error;
        }
        this.getAddReservationObjectInfos(ctx, reservationObjectList, "");
        CoreBaseCollection col = this.handleBillReservationInfo(ctx, reservationObjectList);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return error;
        }
        ReservationInfo info = (ReservationInfo)col.getObject(0);
        Object[] pks = this.saveBatchData(ctx, col);
        if (info != null && info.getReservationObject() != null && !ArrayUtil.isEmpty((Object[])pks) && (pk = pks[0]) != null) {
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"noLogForReservation", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(pk.toString()), (String)info.getReservationObject().getName(), (String)"objectReservation_addnew");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return error;
    }

    private MaterialInventoryInfo getReservationDate(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected ArrayList _cancelReservation(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList.size() <= 0) {
            return null;
        }
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ReservationCollection col = this.getReservationCollection(ctx, view);
        this.checkReservationPermisson(ctx, col);
        this.delete(ctx, filter);
        this.batchHandleCancelReservation(ctx, col);
        ReservationInfo reservationInfo = null;
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            reservationInfo = col.get(i);
            String logInfo = "";
            if (reservationInfo.getRequireBillNum() != null) {
                logInfo = reservationInfo.getRequireBillNum();
            }
            if (reservationInfo.getReservationObject() != null) {
                ReservationObjectInfo reservationObject = null;
                String reservationObjectId = reservationInfo.getReservationObject().getId().toString();
                if (this.reservationObjectMap.containsKey(reservationObjectId)) {
                    reservationObject = this.reservationObjectMap.get(reservationObjectId);
                } else {
                    reservationObject = ReservationObjectFactory.getLocalInstance(ctx).getReservationObjectInfo((IObjectPK)new ObjectUuidPK(reservationObjectId));
                    this.reservationObjectMap.put(reservationObjectId, reservationObject);
                }
                if (reservationObject != null) {
                    logInfo = reservationObject.getNumber();
                }
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"noLogForReservation", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()), (String)logInfo, (String)"reservation_cancel");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return null;
    }

    private void checkReservationPermisson(Context ctx, ReservationCollection col) throws BOSException, EASBizException {
        IObjectPK userId = ctx.getCaller();
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        HashSet<String> cuIdSet = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            ReservationInfo reservationInfo = col.get(i);
            cuIdSet.add(reservationInfo.getCU().getId().toString());
        }
        for (String cuId : cuIdSet) {
            ipermission.checkFunctionPermission(userId, (IObjectPK)new ObjectUuidPK(cuId), "reservation_delete");
        }
    }

    private void batchHandleCancelReservation(Context ctx, ReservationCollection col) throws BOSException, EASBizException {
        this.getCancelReservationObjectInfos(ctx, col);
        this.handleCanelMap(ctx, this.cancelRequireEntryMap, "FREQUIREBILLENTRYID");
        this.handleCanelMap(ctx, this.cancelSupplyBillEntryMap, "FSUPPLIERBILLENTRYID");
        this.handleCanelMap(ctx, this.cancelSupplyBillMap, "FSUPPLIERBILLID");
    }

    @Override
    protected ArrayList _doBillReservation(Context ctx, List reservationBillList) throws BOSException, EASBizException {
        ArrayList<ReservationInfo> error = new ArrayList<ReservationInfo>();
        if (CollectionUtil.isEmpty((Collection)reservationBillList)) {
            return error;
        }
        ReservationInfo info = null;
        BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        int size = reservationBillList.size();
        for (int i = 0; i < size; ++i) {
            info = (ReservationInfo)reservationBillList.get(i);
            try {
                this._addBillReservation(ctx, (IObjectValue)info);
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"noLogForReservation", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getRequireBillNum(), (String)"billReservation_BR");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                continue;
            }
            catch (Exception e) {
                error.add(info);
            }
        }
        return error;
    }

    @Override
    protected IObjectPK _addBillReservation(Context ctx, IObjectValue reservationInfo) throws BOSException, EASBizException {
        if (null == reservationInfo) {
            return null;
        }
        ReservationInfo info = (ReservationInfo)reservationInfo;
        if (StringUtil.isEmpty((String)info.getRequireBillBosType()) || StringUtil.isEmpty((String)info.getRequireBillID()) || StringUtil.isEmpty((String)info.getRequireBillEntryID())) {
            return null;
        }
        String billNum = this.getBillSomething(ctx, info.getRequireBillID(), "number");
        info.setRequireBillNum(billNum);
        String str = this.getBillSomething(ctx, info.getRequireBillEntryID(), "seq");
        if (!StringUtil.isEmpty((String)str)) {
            int seq = Integer.parseInt(str);
            info.setRequireBillEntrySeq(seq);
        }
        String inventoryId = null;
        inventoryId = info.getInventoryID();
        String inventoryID = null;
        inventoryID = info.getInventoryID();
        BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        reservationBaseQty = info.getReservationBaseQty();
        Calendar calendar = Calendar.getInstance(ctx.getLocale());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        info.setReservationBeginDate(new Timestamp(calendar.getTimeInMillis()));
        IObjectPK pk = null;
        if (!StringUtil.isEmpty((String)inventoryID)) {
            InventoryInfo inventory = InventoryFactory.getLocalInstance(ctx).getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryID));
            ReservationUtil.lockInventoryRecords(ctx, inventoryID);
            ReservationModel inventoryReservation = ReservationUtil.getInventoryReservationData(ctx, inventoryID);
            BigDecimal validInvBaseQty = inventory.getBaseQty().subtract(inventoryReservation.getTotalReservationBaseQty());
            if (validInvBaseQty.compareTo(reservationBaseQty) < 0) {
                throw new InvReservationException(InvReservationException.UNRESERVATION_INVENTORY_LESS_THAN_BILLREQUIRE, new Object[0]);
            }
            pk = this.save(ctx, (CoreBaseInfo)info);
        } else {
            if (StringUtil.isEmpty((String)info.getSupplierBillBosType()) || StringUtil.isEmpty((String)info.getSupplierBillID())) {
                return null;
            }
            billNum = this.getBillSomething(ctx, info.getSupplierBillID(), "number");
            info.setSupplierBillNum(billNum);
            String sseq = this.getBillSomething(ctx, info.getSupplierBillEntryID(), "seq");
            if (!StringUtil.isEmpty((String)sseq)) {
                int seq = Integer.parseInt(sseq);
                info.setSupplierBillEntrySeq(seq);
            }
            inventoryId = info.getInventoryID();
            pk = this.save(ctx, (CoreBaseInfo)info);
        }
        if (pk != null) {
            String supplyBillID;
            ObjectUuidPK supplyBillPK;
            EntityObjectInfo supplierentity;
            DataTableInfo suppliertableInfo;
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            String requireBillEntryID = info.getRequireBillEntryID();
            ObjectUuidPK requireBillEntryPK = new ObjectUuidPK(requireBillEntryID);
            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, requireBillEntryPK.getObjectType().toString());
            DataTableInfo tableInfo = entity.getTable();
            if (tableInfo != null) {
                String entryTableName = tableInfo.getName();
                String updateSql = "UPDATE " + entryTableName + " SET " + "FRESERVATIONBILLOBJECTID" + "=FID WHERE FID=?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{requireBillEntryID});
            }
            if (!StringUtil.isEmpty((String)info.getSupplierBillEntryID())) {
                String supplyBillEntryID = info.getSupplierBillEntryID();
                ObjectUuidPK supplyBillEntryPK = new ObjectUuidPK(supplyBillEntryID);
                EntityObjectInfo supplierentity2 = ReservationUtil.getEntityObjectInfo(ctx, supplyBillEntryPK.getObjectType().toString());
                DataTableInfo suppliertableInfo2 = supplierentity2.getTable();
                if (suppliertableInfo2 != null) {
                    String entryTableName = tableInfo.getName();
                    String updateSql = "UPDATE " + entryTableName + " SET " + "FRESERVATIONBILLOBJECTID" + "=FID WHERE FID=?";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{supplyBillEntryID});
                }
            } else if (!StringUtil.isEmpty((String)info.getSupplierBillID()) && (suppliertableInfo = (supplierentity = ReservationUtil.getEntityObjectInfo(ctx, (supplyBillPK = new ObjectUuidPK(supplyBillID = info.getSupplierBillID())).getObjectType().toString())).getTable()) != null) {
                String entryTableName = tableInfo.getName();
                String updateSql = "UPDATE " + entryTableName + " SET " + "FRESERVATIONBILLOBJECTID" + "=FID WHERE FID=?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{supplyBillID});
            }
        }
        return pk;
    }

    @Override
    protected void _noLogForReservation(Context ctx, IObjectPK pk) throws BOSException {
    }

    private List getBillReservationDataList(Context ctx, List reservationBillList) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)reservationBillList)) {
            return list;
        }
        ReservationInfo info = null;
        BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        ArrayList<String> idList = new ArrayList<String>();
        int size = reservationBillList.size();
        for (int i = 0; i < size; ++i) {
            info = (ReservationInfo)reservationBillList.get(i);
            idList.add(info.getSupplierBillEntryID());
        }
        IReservationFacade iReservationFacade = ReservationFacadeFactory.getLocalInstance(ctx);
        iReservationFacade.getReservationData("FSUPPLIERBILLENTRYID", false, idList);
        return list;
    }

    private ReservationModel getBillReservationData(String supplyBillEntryId) {
        ReservationModel reservationModel = new ReservationModel("FSUPPLIERBILLENTRYID");
        if (CollectionUtil.isEmpty((Collection)this.supplyBillReservationDataList) || StringUtil.isEmpty((String)supplyBillEntryId)) {
            return reservationModel;
        }
        int size = this.supplyBillReservationDataList.size();
        for (int i = 0; i < size; ++i) {
            ReservationModel info = (ReservationModel)this.supplyBillReservationDataList.get(i);
            if (!supplyBillEntryId.equals(info.getFieldValue())) continue;
            return info;
        }
        return reservationModel;
    }

    @Override
    protected ArrayList _doBillReservation(Context ctx, List reservationBillList, String reservationBaseQtyPropertyName) throws BOSException, EASBizException {
        PropertyInfo property;
        ArrayList error = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)reservationBillList)) {
            return error;
        }
        this.getAddReservationObjectInfos(ctx, reservationBillList, reservationBaseQtyPropertyName);
        CoreBaseCollection col = this.handleBillReservationInfo(ctx, reservationBillList);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return error;
        }
        String[] entrys = new String[col.size()];
        ReservationInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (ReservationInfo)col.getObject(i);
            entrys[i] = info.getRequireBillEntryID();
        }
        this.saveBatchData(ctx, col);
        if (!StringUtil.isEmpty((String)this.supplyObjectBosType)) {
            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, this.supplyObjectBosType);
            String tableName = entity.getTable().getName();
            property = entity.getPropertyByName("reservationBillObjectId");
            if (property != null) {
                String fieldName = property.getMappingField().getName();
                String updateSql = "UPDATE " + tableName + " AS BILL SET " + fieldName + "=FID WHERE 1=1";
                if (!CollectionUtil.isEmpty((Collection)this.supplyEntryList)) {
                    updateSql = updateSql + " AND EXISTS (SELECT 1 FROM T_IM_RESERVATION AS RESERVATION WHERE RESERVATION.FSUPPLIERBILLENTRYID=BILL.FID)";
                    updateSql = updateSql + " AND FID IN(" + CollectionUtil.convertList2String((List)this.supplyEntryList) + ")";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                } else if (!CollectionUtil.isEmpty((Collection)this.supplyBillList)) {
                    updateSql = updateSql + " AND EXISTS (SELECT 1 FROM T_IM_RESERVATION AS RESERVATION WHERE RESERVATION.FSUPPLIERBILLID=BILL.FID)";
                    updateSql = updateSql + " AND FID IN(" + CollectionUtil.convertList2String((List)this.supplyBillList) + ")";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            }
        }
        if (!StringUtil.isEmpty((String)this.requireBillBosType)) {
            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, this.requireBillBosType);
            String tableName = entity.getTable().getName();
            property = entity.getPropertyByName("reservationBillObjectId");
            if (property != null) {
                for (int i = 0; i < entrys.length; ++i) {
                    String fieldName = property.getMappingField().getName();
                    String updateSql = "UPDATE " + tableName + " AS BILL SET " + fieldName + "=FID WHERE 1=1";
                    if (StringUtil.isEmpty((String)this.requireBillEntryId)) continue;
                    updateSql = updateSql + " AND EXISTS (SELECT 1 FROM T_IM_RESERVATION AS RESERVATION WHERE RESERVATION.FREQUIREBILLENTRYID=BILL.FID)";
                    updateSql = updateSql + " AND BILL.FID=?";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{entrys[i]});
                }
            }
        }
        if (info != null) {
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"noLogForReservation", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getRequireBillNum(), (String)"billReservation_BR");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return error;
    }

    private void getAddReservationObjectInfos(Context ctx, List reservationBillList, String reservationBaseQtyPropertyName) throws BOSException, EASBizException {
        FilterInfo filter;
        this.supplyBaseQtyPropertyName = reservationBaseQtyPropertyName;
        ReservationInfo info = null;
        int size = reservationBillList.size();
        for (int i = 0; i < size; ++i) {
            info = (ReservationInfo)reservationBillList.get(i);
            this.requireBillEntryId = info.getRequireBillEntryID();
            if (this.requireBillObjectPK == null && !StringUtil.isEmpty((String)info.getRequireBillEntryID())) {
                this.requireBillObjectPK = new ObjectUuidPK(info.getRequireBillEntryID());
            }
            if (!StringUtil.isEmpty((String)info.getInventoryID())) {
                this.inventoryIDList.add(info.getInventoryID());
                continue;
            }
            if (!StringUtil.isEmpty((String)info.getSupplierBillEntryID())) {
                if (this.reservationObjectPK == null) {
                    this.reservationObjectPK = new ObjectUuidPK(info.getSupplierBillEntryID());
                }
                this.supplyEntryList.add(info.getSupplierBillEntryID());
                continue;
            }
            if (this.reservationObjectPK == null) {
                this.reservationObjectPK = new ObjectUuidPK(info.getSupplierBillID());
            }
            this.supplyBillList.add(info.getSupplierBillID());
        }
        if (this.requireBillObjectPK != null) {
            this.requireBillBosType = this.requireBillObjectPK.getObjectType().toString();
        }
        BOSObjectType bosType = null;
        if (this.reservationObjectPK != null) {
            bosType = this.reservationObjectPK.getObjectType();
        }
        HashSet idSet = null;
        if (!CollectionUtil.isEmpty((Collection)this.inventoryIDList)) {
            ReservationUtil.lockInventoryRecords(ctx, this.inventoryIDList);
            HashSet set = new HashSet(this.inventoryIDList);
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            this.inventoryCollection = InventoryFactory.getLocalInstance(ctx).getInventoryCollection(view);
            this.supplyObjectReservationList = ReservationUtil.getReservationData(ctx, "FINVENTORYID", this.inventoryIDList);
        } else if (!CollectionUtil.isEmpty((Collection)this.supplyEntryList)) {
            this.supplyObjectReservationList = ReservationUtil.getReservationData(ctx, "FSUPPLIERBILLENTRYID", this.supplyEntryList);
            idSet = new HashSet(this.supplyEntryList);
        } else if (!CollectionUtil.isEmpty((Collection)this.supplyBillList)) {
            idSet = new HashSet(this.supplyBillList);
            this.supplyObjectReservationList = ReservationUtil.getReservationData(ctx, "FSUPPLIERBILLID", this.supplyBillList);
        }
        if (bosType != null && !CollectionUtil.isEmpty(idSet)) {
            this.supplyObjectBosType = bosType.toString();
            EntityViewInfo view = new EntityViewInfo();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            this.supplyObjectCollection = iDynamicObject.getCollection(bosType, view);
        }
    }

    private void getCancelReservationObjectInfos(Context ctx, ReservationCollection col) throws BOSException, EASBizException {
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        ReservationInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            Set<Object> set;
            Set<Object> set2;
            info = col.get(i);
            if (info.getReservationType() != ReservationTypeEnum.ReservationType_Bill) continue;
            this.requireBillEntryId = info.getRequireBillEntryID();
            String requireBillBosType = new ObjectUuidPK(this.requireBillEntryId).getObjectType().toString();
            if (this.cancelRequireEntryMap.containsKey(requireBillBosType)) {
                set2 = this.cancelRequireEntryMap.get(requireBillBosType);
                set2.add(this.requireBillEntryId);
            } else {
                set2 = new HashSet<String>();
                set2.add(this.requireBillEntryId);
                this.cancelRequireEntryMap.put(requireBillBosType, set2);
            }
            String supplyEntryId = info.getSupplierBillEntryID();
            if (!StringUtil.isEmpty((String)supplyEntryId)) {
                Set<Object> set3;
                this.reservationObjectPK = new ObjectUuidPK(info.getSupplierBillEntryID());
                String supplyEntryBosType = this.reservationObjectPK.getObjectType().toString();
                if (this.cancelSupplyBillEntryMap.containsKey(supplyEntryBosType)) {
                    set3 = this.cancelSupplyBillEntryMap.get(supplyEntryBosType);
                    set3.add(supplyEntryId);
                    continue;
                }
                set3 = new HashSet<String>();
                set3.add(supplyEntryId);
                this.cancelSupplyBillEntryMap.put(supplyEntryBosType, set3);
                continue;
            }
            String supplyBillId = info.getSupplierBillID();
            if (StringUtil.isEmpty((String)supplyBillId)) continue;
            String supplyBillBosType = info.getSupplierBillBosType();
            if (this.cancelSupplyBillMap.containsKey(supplyBillBosType)) {
                set = this.cancelSupplyBillMap.get(supplyBillBosType);
                set.add(supplyBillId);
                continue;
            }
            set = new HashSet<String>();
            set.add(supplyBillId);
            this.cancelSupplyBillMap.put(supplyBillBosType, set);
        }
    }

    private void handleCanelMap(Context ctx, Map<String, Set<String>> cancelMap, String matchFieldName) throws BOSException, EASBizException {
        if (CollectionUtil.isEmpty(cancelMap)) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : cancelMap.entrySet()) {
            String bosType = entry.getKey();
            Set<String> set = entry.getValue();
            if (StringUtil.isEmpty((String)bosType)) continue;
            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, bosType);
            String tableName = entity.getTable().getName();
            PropertyInfo property = entity.getPropertyByName("reservationBillObjectId");
            if (property == null) continue;
            String fieldName = property.getMappingField().getName();
            String updateSql = "UPDATE " + tableName + " AS BILL SET " + fieldName + "=null WHERE 1=1";
            if (CollectionUtil.isEmpty(set)) continue;
            updateSql = updateSql + " AND NOT EXISTS (SELECT 1 FROM T_IM_RESERVATION AS RESERVATION WHERE RESERVATION." + matchFieldName + "=BILL.FID)";
            updateSql = updateSql + " AND FID IN(" + CollectionUtil.convertList2String(new ArrayList<String>(set)) + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    private IObjectValue getSupplyObjectInfo(String supplyObjectId) {
        if (CollectionUtil.isEmpty((IObjectCollection)this.supplyObjectCollection) || StringUtil.isEmpty((String)supplyObjectId)) {
            return null;
        }
        IObjectValue model = null;
        int size = this.supplyObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            if (this.supplyObjectCollection.getObject(i) == null || this.supplyObjectCollection.getObject(i).get("id") == null || !supplyObjectId.equals(this.supplyObjectCollection.getObject(i).get("id").toString())) continue;
            return this.supplyObjectCollection.getObject(i);
        }
        return model;
    }

    private InventoryInfo getInventoryInfo(String inventoryId) {
        if (CollectionUtil.isEmpty((AbstractObjectCollection)this.inventoryCollection) || StringUtil.isEmpty((String)inventoryId)) {
            return null;
        }
        InventoryInfo info = null;
        int size = this.inventoryCollection.size();
        for (int i = 0; i < size; ++i) {
            info = this.inventoryCollection.get(i);
            if (info == null || info.getId() == null || !inventoryId.equals(info.getId().toString())) continue;
            return info;
        }
        return null;
    }

    private ReservationModel getSupplyObjectReservationModel(String supplyObjectId) {
        ReservationModel model = new ReservationModel();
        if (CollectionUtil.isEmpty((Collection)this.supplyObjectReservationList) || StringUtil.isEmpty((String)supplyObjectId)) {
            return model;
        }
        int size = this.supplyObjectReservationList.size();
        for (int i = 0; i < size; ++i) {
            ReservationModel info = (ReservationModel)this.supplyObjectReservationList.get(i);
            if (info == null || info.getFieldValue() == null || !supplyObjectId.equals(info.getFieldValue())) continue;
            return info;
        }
        return model;
    }

    static void addRequireBillRecord(String requirBillEntryId) {
        if (hasReservationRequireBillMap.size() >= 100) {
            hasReservationRequireBillMap.clear();
        }
        hasReservationRequireBillMap.put(requirBillEntryId, null);
    }

    static void addSupplyObjectRecord(String suppyObjectId) {
        if (hasReservationSupplyObjectMap.size() >= 100) {
            hasReservationSupplyObjectMap.clear();
        }
        hasReservationSupplyObjectMap.put(suppyObjectId, null);
    }

    private CoreBaseCollection handleBillReservationInfo(Context ctx, List reservationBillList) throws BOSException, EASBizException {
        CoreBaseCollection col = new CoreBaseCollection();
        if (CollectionUtil.isEmpty((Collection)reservationBillList)) {
            return col;
        }
        ReservationInfo oldInfo = null;
        ReservationInfo info = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        int size = reservationBillList.size();
        for (int i = 0; i < size; ++i) {
            oldInfo = (ReservationInfo)reservationBillList.get(i);
            info = (ReservationInfo)oldInfo.clone();
            info.setId(BOSUuid.create((String)"8D307D69"));
            if (ReservationTypeEnum.ReservationType_Bill == info.getReservationType() && (StringUtil.isEmpty((String)info.getRequireBillBosType()) || StringUtil.isEmpty((String)info.getRequireBillID()) || StringUtil.isEmpty((String)info.getRequireBillEntryID()))) continue;
            String billNum = this.getBillSomething(ctx, info.getRequireBillID(), "number");
            info.setRequireBillNum(billNum);
            String str = this.getBillSomething(ctx, info.getRequireBillEntryID(), "seq");
            if (!StringUtil.isEmpty((String)str)) {
                int seq = Integer.parseInt(str);
                info.setRequireBillEntrySeq(seq);
            }
            String inventoryID = null;
            inventoryID = info.getInventoryID();
            BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            reservationBaseQty = info.getReservationBaseQty();
            Calendar calendar = Calendar.getInstance(ctx.getLocale());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            info.setReservationBeginDate(new Timestamp(calendar.getTimeInMillis()));
            if (!StringUtil.isEmpty((String)inventoryID)) {
                InventoryInfo inventory = this.getInventoryInfo(inventoryID);
                ReservationModel inventoryReservation = this.getSupplyObjectReservationModel(inventoryID);
                BigDecimal validInvBaseQty = inventory.getBaseQty().subtract(inventoryReservation.getTotalReservationBaseQty());
                if (validInvBaseQty.compareTo(reservationBaseQty) < 0) {
                    throw new InvReservationException(InvReservationException.UNRESERVATION_INVENTORY_LESS_THAN_BILLREQUIRE, new Object[]{info.getRequireBillNum(), info.getRequireBillEntrySeq()});
                }
            } else {
                if (StringUtil.isEmpty((String)info.getSupplierBillBosType()) || StringUtil.isEmpty((String)info.getSupplierBillID())) continue;
                IObjectValue supplyObject = null;
                ReservationModel reservationModel = null;
                if (!StringUtil.isEmpty((String)info.getSupplierBillEntryID())) {
                    supplyObject = this.getSupplyObjectInfo(info.getSupplierBillEntryID());
                    reservationModel = this.getSupplyObjectReservationModel(info.getSupplierBillEntryID());
                } else {
                    supplyObject = this.getSupplyObjectInfo(info.getSupplierBillID());
                    reservationModel = this.getSupplyObjectReservationModel(info.getSupplierBillID());
                }
                if (supplyObject != null && reservationModel != null && !StringUtil.isEmpty((String)this.supplyBaseQtyPropertyName)) {
                    BigDecimal billReservationBaseQty;
                    BigDecimal vaildBaseQty;
                    BigDecimal billBaseQty = supplyObject.getBigDecimal(this.supplyBaseQtyPropertyName);
                    if (billBaseQty == null) {
                        billBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                    }
                    if (billBaseQty.signum() == -1) {
                        billBaseQty = billBaseQty.negate();
                    }
                    if ((vaildBaseQty = billBaseQty.subtract(billReservationBaseQty = reservationModel.getTotalReservationBaseQty())).compareTo(reservationBaseQty) < 0) {
                        throw new InvReservationException(InvReservationException.UNRESERVATION_SUPPLYBILL_LESS_THAN_BILLREQUIRE, new Object[]{info.getRequireBillNum(), info.getRequireBillEntrySeq()});
                    }
                }
                billNum = this.getBillSomething(ctx, info.getSupplierBillID(), "number");
                info.setSupplierBillNum(billNum);
                String sseq = this.getBillSomething(ctx, info.getSupplierBillEntryID(), "seq");
                if (!StringUtil.isEmpty((String)sseq)) {
                    int seq = Integer.parseInt(sseq);
                    info.setSupplierBillEntrySeq(seq);
                }
            }
            info.setCreator(userInfo);
            col.add((CoreBaseInfo)info);
        }
        return col;
    }

    private IObjectPK addBillReservationInfo(Context ctx, IObjectValue reservationInfo) throws BOSException, EASBizException {
        if (null == reservationInfo) {
            return null;
        }
        ReservationInfo info = (ReservationInfo)reservationInfo;
        info.setId(BOSUuid.create((String)"8D307D69"));
        if (StringUtil.isEmpty((String)info.getRequireBillBosType()) || StringUtil.isEmpty((String)info.getRequireBillID()) || StringUtil.isEmpty((String)info.getRequireBillEntryID())) {
            return null;
        }
        String billNum = this.getBillSomething(ctx, info.getRequireBillID(), "number");
        info.setRequireBillNum(billNum);
        String str = this.getBillSomething(ctx, info.getRequireBillEntryID(), "seq");
        if (!StringUtil.isEmpty((String)str)) {
            int seq = Integer.parseInt(str);
            info.setRequireBillEntrySeq(seq);
        }
        String inventoryID = null;
        inventoryID = info.getInventoryID();
        BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        reservationBaseQty = info.getReservationBaseQty();
        Calendar calendar = Calendar.getInstance(ctx.getLocale());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        info.setReservationBeginDate(new Timestamp(calendar.getTimeInMillis()));
        IObjectPK pk = null;
        if (!StringUtil.isEmpty((String)inventoryID)) {
            InventoryInfo inventory = this.getInventoryInfo(inventoryID);
            ReservationModel inventoryReservation = this.getSupplyObjectReservationModel(inventoryID);
            BigDecimal validInvBaseQty = inventory.getBaseQty().subtract(inventoryReservation.getTotalReservationBaseQty());
            if (validInvBaseQty.compareTo(reservationBaseQty) < 0) {
                throw new InvReservationException(InvReservationException.UNRESERVATION_INVENTORY_LESS_THAN_BILLREQUIRE, new Object[]{info.getRequireBillNum(), info.getRequireBillEntrySeq()});
            }
            pk = this.save(ctx, (CoreBaseInfo)info);
        } else {
            if (StringUtil.isEmpty((String)info.getSupplierBillBosType()) || StringUtil.isEmpty((String)info.getSupplierBillID())) {
                return null;
            }
            IObjectValue supplyObject = null;
            ReservationModel reservationModel = null;
            if (!StringUtil.isEmpty((String)info.getSupplierBillEntryID())) {
                supplyObject = this.getSupplyObjectInfo(info.getSupplierBillEntryID());
                reservationModel = this.getSupplyObjectReservationModel(info.getSupplierBillEntryID());
            } else {
                supplyObject = this.getSupplyObjectInfo(info.getSupplierBillID());
                reservationModel = this.getSupplyObjectReservationModel(info.getSupplierBillID());
            }
            if (supplyObject != null && reservationModel != null && !StringUtil.isEmpty((String)this.supplyBaseQtyPropertyName)) {
                BigDecimal billReservationBaseQty;
                BigDecimal vaildBaseQty;
                BigDecimal billBaseQty = supplyObject.getBigDecimal(this.supplyBaseQtyPropertyName);
                if (billBaseQty == null) {
                    billBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                }
                if (billBaseQty.signum() == -1) {
                    billBaseQty = billBaseQty.negate();
                }
                if ((vaildBaseQty = billBaseQty.subtract(billReservationBaseQty = reservationModel.getTotalReservationBaseQty())).compareTo(reservationBaseQty) < 0) {
                    throw new InvReservationException(InvReservationException.UNRESERVATION_SUPPLYBILL_LESS_THAN_BILLREQUIRE, new Object[]{info.getRequireBillNum(), info.getRequireBillEntrySeq()});
                }
            }
            billNum = this.getBillSomething(ctx, info.getSupplierBillID(), "number");
            info.setSupplierBillNum(billNum);
            String sseq = this.getBillSomething(ctx, info.getSupplierBillEntryID(), "seq");
            if (!StringUtil.isEmpty((String)sseq)) {
                int seq = Integer.parseInt(sseq);
                info.setSupplierBillEntrySeq(seq);
            }
            pk = this.save(ctx, (CoreBaseInfo)info);
        }
        if (pk != null) {
            ObjectUuidPK supplyBillPK;
            String supplyBillID;
            ObjectUuidPK requireBillEntryPK;
            String requireBillEntryID = info.getRequireBillEntryID();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            IObjectValue model = null;
            if (!hasReservationRequireBillMap.containsKey(requireBillEntryID) && (model = iDynamicObject.getValue((requireBillEntryPK = new ObjectUuidPK(requireBillEntryID)).getObjectType(), (IObjectPK)requireBillEntryPK)) != null && model.containsKey("reservationBillObjectId")) {
                model.put("reservationBillObjectId", (Object)requireBillEntryID);
                iDynamicObject.update(requireBillEntryPK.getObjectType(), (IObjectPK)requireBillEntryPK, model);
                ReservationControllerBean.addRequireBillRecord(requireBillEntryID);
            }
            if (!StringUtil.isEmpty((String)info.getSupplierBillEntryID())) {
                ObjectUuidPK supplyBillEntryPK;
                String supplyBillEntryID = info.getSupplierBillEntryID();
                if (!hasReservationSupplyObjectMap.containsKey(supplyBillEntryID) && (model = iDynamicObject.getValue((supplyBillEntryPK = new ObjectUuidPK(supplyBillEntryID)).getObjectType(), (IObjectPK)supplyBillEntryPK)) != null && model.containsKey("reservationBillObjectId")) {
                    model.put("reservationBillObjectId", (Object)supplyBillEntryID);
                    iDynamicObject.update(supplyBillEntryPK.getObjectType(), (IObjectPK)supplyBillEntryPK, model);
                    ReservationControllerBean.addSupplyObjectRecord(supplyBillEntryID);
                }
            } else if (!StringUtil.isEmpty((String)info.getSupplierBillID()) && !hasReservationSupplyObjectMap.containsKey(supplyBillID = info.getSupplierBillID()) && (model = iDynamicObject.getValue((supplyBillPK = new ObjectUuidPK(supplyBillID)).getObjectType(), (IObjectPK)supplyBillPK)) != null && model.containsKey("reservationBillObjectId")) {
                model.put("reservationBillObjectId", (Object)supplyBillID);
                iDynamicObject.update(supplyBillPK.getObjectType(), (IObjectPK)supplyBillPK, model);
                ReservationControllerBean.addSupplyObjectRecord(supplyBillID);
            }
        }
        return pk;
    }

    private boolean hasReservationData(Context ctx, String fieldName, String supplyObjectId) throws BOSException, EASBizException {
        if (ctx == null || StringUtil.isEmpty((String)fieldName) || StringUtil.isEmpty((String)supplyObjectId)) {
            return false;
        }
        String sql = "";
        sql = "SELECT COUNT(0) CNT FROM T_IM_Reservation WHERE " + fieldName + "='" + supplyObjectId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                if (rs.getInt("CNT") <= 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.saveBatchData(ctx, null);
        }
        return false;
    }
}

