/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.im.reservation.IReservationFacade;
import com.kingdee.eas.scm.im.reservation.IReservationSchema;
import com.kingdee.eas.scm.im.reservation.ReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.client.BillReservationSchemaSelectUI;
import com.kingdee.eas.scm.im.reservation.impl.IBillEditReservation;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BillEditReservationImpl
implements IBillEditReservation {
    @Override
    public void doBillEditReservation(IObjectValue model) throws EASBizException, BOSException {
        String cuID;
        ReservationSchemaInfo reservationSchemaInfo;
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = ReservationUtil.getEntityObjectInfo(model.getBOSType().toString());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entries.getObject(i);
                String id = entry.get("ID").toString();
                String reservationBillObjectId = (String)entry.get("reservationBillObjectId");
                if (StringUtil.isEmpty((String)reservationBillObjectId)) {
                    reservationBillObjectId = ReservationUtil.getReservationBillObjectID(null, id);
                }
                if (reservationBillObjectId == null || reservationBillObjectId.equals(id)) continue;
                MsgBox.showWarning((String)ReservationUtil.getResourceString("UPPER_HAS_RESERVATION_CANNOT_RESERVATION"));
                SysUtil.abort();
            }
        }
        String bosType = model.getBOSType().toString();
        ReservationSchemaCollection reservationSchemaCol = ReservationUtil.getBillReservationSchema(null, model, false);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)reservationSchemaCol)) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            SysUtil.abort();
        }
        if ((reservationSchemaInfo = this.getRequireBillReservationSchema(bosType, cuID = ReservationUtil.getCuByModel(null, model))) == null) {
            SysUtil.abort();
        }
        EntityViewInfo requireBillView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        requireBillView.setSelector(sic);
        try {
            FilterInfo requireBillFilter = reservationSchemaInfo.getFilterInfo();
            if (requireBillFilter == null) {
                requireBillFilter = new FilterInfo();
            }
            FilterInfo billFilter = new FilterInfo();
            billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)model.get("id").toString(), CompareType.EQUALS));
            requireBillFilter.mergeFilter(billFilter, "AND");
            requireBillView.setFilter(requireBillFilter);
        }
        catch (Exception requireBillFilter) {
            // empty catch block
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillQueryPK()));
        exec.option().isIgnorePermissionCheck = true;
        exec.setObjectView(requireBillView);
        if (exec.getRowCount() == 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("BILL_NOT_MATCH_CANNOT_RESERVATION"));
            SysUtil.abort();
        }
        HashMap<String, ReservationSchemaInfo> uiContext = new HashMap<String, ReservationSchemaInfo>();
        uiContext.put("RESERVATIONSCHEMA", reservationSchemaInfo);
        uiContext.put("BILLINFO", (ReservationSchemaInfo)model);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.reservation.client.BillReservationOptionUI", uiContext, null, null);
        uiWindow.show();
    }

    private ReservationSchemaInfo getRequireBillReservationSchema(String bosType, String cuID) throws EASBizException, BOSException {
        ReservationSchemaInfo reservationSchemaInfo = null;
        IReservationSchema iReservationSchema = ReservationSchemaFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)bosType, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (cuID != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        }
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        view.setFilter(filter);
        ReservationSchemaCollection col = iReservationSchema.getReservationSchemaCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            reservationSchemaInfo = null;
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            SysUtil.abort();
        }
        if (col.size() == 1) {
            reservationSchemaInfo = col.get(0);
        } else {
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            uiContext.put("BOSTYPE", bosType);
            uiContext.put("ReservationSchemaCollection", (Object)col);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.reservation.client.BillReservationSchemaSelectUI", uiContext, null, null);
            uiWindow.show();
            reservationSchemaInfo = ((BillReservationSchemaSelectUI)uiWindow.getUIObject()).isCancel() ? null : ((BillReservationSchemaSelectUI)uiWindow.getUIObject()).getReservationSchemaInfo();
        }
        return reservationSchemaInfo;
    }

    @Override
    public void replaceObjectReservation2Bill(IObjectValue model, IObjectValue entry) throws EASBizException, BOSException {
        String materialPropertyName;
        String cuID;
        String bosType;
        ReservationSchemaInfo reservationSchemaInfo;
        if (model == null || model.get("id") == null || entry == null || entry.get("id") == null) {
            return;
        }
        String billId = model.get("id").toString();
        String billEntryID = entry.get("id").toString();
        ReservationSchemaCollection reservationSchemaCol = ReservationUtil.getBillReservationSchema(null, model, false);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)reservationSchemaCol)) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            SysUtil.abort();
        }
        if ((reservationSchemaInfo = this.getRequireBillReservationSchema(bosType = model.getBOSType().toString(), cuID = ReservationUtil.getCuByModel(null, model))) == null) {
            SysUtil.abort();
        }
        EntityViewInfo requireBillView = new EntityViewInfo();
        try {
            FilterInfo requireBillFilter = reservationSchemaInfo.getFilterInfo();
            if (requireBillFilter == null) {
                requireBillFilter = new FilterInfo();
            }
            FilterInfo billFilter = new FilterInfo();
            billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
            billFilter.getFilterItems().add(new FilterItemInfo(reservationSchemaInfo.getEntryIDFieldName(), (Object)billEntryID, CompareType.EQUALS));
            requireBillFilter.mergeFilter(billFilter, "AND");
            requireBillView.setFilter(requireBillFilter);
        }
        catch (Exception requireBillFilter) {
            // empty catch block
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillQueryPK()));
        exec.setObjectView(requireBillView);
        if (exec.getRowCount() == 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("BILL_NOT_MATCH_CANNOT_RESERVATION"));
            SysUtil.abort();
        }
        String reservationBillObjectId = ReservationUtil.getReservationBillObjectID(null, billEntryID);
        BigDecimal totalReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        if (!StringUtil.isEmpty((String)reservationBillObjectId)) {
            if (!reservationBillObjectId.equals(billEntryID)) {
                MsgBox.showWarning((String)ReservationUtil.getResourceString("NOT_REQUIREBILL_CANNOT_RESERVATION"));
                SysUtil.abort();
            }
            IReservationFacade iReservationFacade = ReservationFacadeFactory.getRemoteInstance();
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(reservationBillObjectId);
            List list = iReservationFacade.getReservationData("FREQUIREBILLENTRYID", idList);
            ReservationModel reservationModel = null;
            if (!CollectionUtil.isEmpty((Collection)list)) {
                reservationModel = (ReservationModel)list.get(0);
            }
            if (reservationModel != null) {
                totalReservationBaseQty = reservationModel.getTotalReservationBaseQty();
            }
        }
        String baseQtyPropertyName = "";
        baseQtyPropertyName = reservationSchemaInfo.getBaseQtyPropertyName();
        BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
        baseQty = entry.getBigDecimal(baseQtyPropertyName);
        if (totalReservationBaseQty.compareTo(baseQty) >= 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("ENTRY_HAS_RESERVATION_COMPLETE"));
            SysUtil.abort();
        }
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationBaseQty = baseQty.subtract(totalReservationBaseQty);
        HashSet<String> idValueSet = new HashSet<String>();
        EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(null, bosType);
        Map<String, PropertyInfo> propertyMap = ReservationUtil.getEntityProperty(bosType);
        if (propertyMap == null) {
            return;
        }
        HashSet<Object> bosTypeSet = new HashSet<Object>();
        PropertyInfo property = null;
        Set<Map.Entry<String, PropertyInfo>> entrySet = propertyMap.entrySet();
        String propertyName = "";
        for (Map.Entry<String, PropertyInfo> mapEntry : entrySet) {
            IObjectValue propertyModel;
            propertyName = mapEntry.getKey();
            if (model.get(propertyName) != null) {
                if (model.get(propertyName) instanceof IObjectValue) {
                    propertyModel = (IObjectValue)model.get(propertyName);
                    idValueSet.add(propertyModel.get("id").toString());
                }
            } else {
                propertyModel = null;
                String entryPropertyName = "";
                String[] arr = null;
                if (propertyName.indexOf(".") > 0) {
                    arr = propertyName.split(".");
                }
                if (arr == null || arr.length == 0) {
                    arr = propertyName.split("\\.");
                }
                if (entry.get(entryPropertyName = arr.length == 2 ? arr[1] : propertyName) != null) {
                    propertyModel = (IObjectValue)entry.get(entryPropertyName);
                    idValueSet.add(propertyModel.get("id").toString());
                }
            }
            if ((property = mapEntry.getValue()) == null) continue;
            bosTypeSet.add(property.get("linkedBosType"));
        }
        EntityViewInfo reservationView = new EntityViewInfo();
        FilterInfo reservationFilter = new FilterInfo();
        reservationFilter.getFilterItems().add(new FilterItemInfo("reservationObject.state", (Object)1, CompareType.EQUALS));
        String orgId = ReservationUtil.getRequireBillStorageUnit(reservationSchemaInfo, model, entry);
        if (!StringUtil.isEmpty((String)orgId)) {
            reservationFilter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)orgId, CompareType.EQUALS));
        }
        if (entry.get(materialPropertyName = reservationSchemaInfo.getEntryMaterialPropertyName()) != null && entry.get(materialPropertyName) instanceof IObjectValue) {
            IObjectValue material = (IObjectValue)entry.get(materialPropertyName);
            reservationFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.get("id").toString(), CompareType.EQUALS));
        }
        reservationView.setFilter(reservationFilter);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"requireBillBostype", (Object)model.getBOSType().toString());
        uiContext.put((Object)"baseQty", (Object)baseQty);
        uiContext.put((Object)"unReservationBaseQty", (Object)unReservationBaseQty);
        uiContext.put((Object)"billID", (Object)billId);
        uiContext.put((Object)"entryID", (Object)billEntryID);
        uiContext.put((Object)"ObjectReservationView", (Object)reservationView);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.reservation.client.ObjectReservationMatchUI", (Map)uiContext, null, null);
        uiWindow.show();
    }

    @Override
    public void bill2BillReservation(IObjectValue model) throws EASBizException, BOSException {
        this.billReservationConversion(model, "com.kingdee.eas.scm.im.reservation.client.Bill2BillReservationOptionUI");
    }

    @Override
    public void object2BillReservation(IObjectValue model) throws EASBizException, BOSException {
        this.billReservationConversion(model, "com.kingdee.eas.scm.im.reservation.client.Object2BillReservationOptionUI");
    }

    private void billReservationConversion(IObjectValue model, String optionUI) throws EASBizException, BOSException {
        String cuID;
        ReservationSchemaInfo reservationSchemaInfo;
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entries.getObject(i);
                String id = entry.get("ID").toString();
                String reservationBillObjectId = (String)entry.get("reservationBillObjectId");
                if (reservationBillObjectId == null || reservationBillObjectId.equals(id)) continue;
                MsgBox.showWarning((String)ReservationUtil.getResourceString("UPPER_HAS_RESERVATION_CANNOT_RESERVATION"));
                SysUtil.abort();
            }
        }
        String bosType = model.getBOSType().toString();
        ReservationSchemaCollection reservationSchemaCol = ReservationUtil.getBillReservationSchema(null, model, false);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)reservationSchemaCol)) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            SysUtil.abort();
        }
        if ((reservationSchemaInfo = this.getRequireBillReservationSchema(bosType, cuID = ReservationUtil.getCuByModel(null, model))) == null) {
            SysUtil.abort();
        }
        EntityViewInfo requireBillView = new EntityViewInfo();
        try {
            FilterInfo requireBillFilter = reservationSchemaInfo.getFilterInfo();
            if (requireBillFilter == null) {
                requireBillFilter = new FilterInfo();
            }
            FilterInfo billFilter = new FilterInfo();
            billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)model.get("id").toString(), CompareType.EQUALS));
            requireBillFilter.mergeFilter(billFilter, "AND");
            requireBillView.setFilter(requireBillFilter);
        }
        catch (Exception requireBillFilter) {
            // empty catch block
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillQueryPK()));
        exec.setObjectView(requireBillView);
        if (exec.getRowCount() == 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("BILL_NOT_MATCH_CANNOT_RESERVATION"));
            SysUtil.abort();
        }
        HashMap<String, ReservationSchemaInfo> uiContext = new HashMap<String, ReservationSchemaInfo>();
        uiContext.put("RESERVATIONSCHEMA", reservationSchemaInfo);
        uiContext.put("BILLINFO", (ReservationSchemaInfo)model);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(optionUI, uiContext, null, null);
        uiWindow.show();
    }
}

