/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.impl.IReservationEntry;
import com.kingdee.eas.scm.im.reservation.impl.IReservationSplitEntry;
import com.kingdee.eas.scm.im.reservation.util.ReservationBalanceUtil;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InvBalanceReservationSplitEntryImpl
implements IReservationSplitEntry {
    static Map<String, Object> invUpdateMap = new HashMap<String, Object>();
    static Map<String, String> billTransPropertyMap = new HashMap<String, String>();

    @Override
    public void splitReservationEntry(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null == model || null == model.getBOSType()) {
            return;
        }
        String billBosType = model.getBOSType().toString();
        EntityObjectInfo billEntity = ReservationUtil.getEntityObjectInfo(ctx, billBosType);
        String billTranPropertyName = "";
        if (billTransPropertyMap.containsKey(billBosType)) {
            billTranPropertyName = billTransPropertyMap.get(billBosType);
        } else {
            billTranPropertyName = ReservationUtil.getBillTransactionTypePropertyName(billEntity);
            billTransPropertyMap.put(billBosType, billTranPropertyName);
        }
        TransactionTypeInfo transactionTypeInfo = null;
        if (!StringUtil.isEmpty((String)billTranPropertyName)) {
            transactionTypeInfo = (TransactionTypeInfo)model.get(billTranPropertyName);
        }
        if (SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction(transactionTypeInfo, (Context)ctx) || SCMBaseCommonUtil.isIssueWarehsAddInvTransaction((TransactionTypeInfo)transactionTypeInfo)) {
            return;
        }
        BillTypeInfo sourceBillType = (BillTypeInfo)model.get("sourceBillType");
        BillTypeInfo billType = (BillTypeInfo)model.get("billType");
        if (billType != null && sourceBillType != null && billType.getId().toString().equals(sourceBillType.getId().toString())) {
            return;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return;
        }
        String entryId = "";
        String reservationBillObjectId = "";
        String reservationId = "";
        CoreBaseInfo entry = null;
        IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
        ReservationCollection reservationCol = null;
        ReservationInfo reservationInfo = null;
        IInventory iInventory = InventoryFactory.getLocalInstance(ctx);
        IObjectValue newEntry = null;
        String scmSrcBillEntryIdFieldName = "sourceBillEntryId";
        for (int i = 0; i < entries.size(); ++i) {
            ObjectUuidPK srcBillEntryPK;
            entry = (CoreBaseInfo)entries.getObject(i);
            String srcBillEntryId = entry.getString("sourceBillEntryId");
            if (srcBillEntryId != null && (srcBillEntryPK = new ObjectUuidPK(srcBillEntryId)) != null && srcBillEntryPK.getObjectType() != null && entry.getBOSType().toString().equals(srcBillEntryPK.getObjectType().toString())) {
                return;
            }
            entryId = entry.get("ID").toString();
            reservationBillObjectId = (String)entry.get("reservationBillObjectId");
            if (StringUtil.isEmpty((String)reservationBillObjectId) || entryId.equals(reservationBillObjectId) || !StringUtil.isEmpty((String)(reservationId = entry.getString("reservationId")))) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("requireBillEntryID", (Object)reservationBillObjectId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("inventoryID", null, CompareType.NOTEQUALS));
            view.setFilter(filter);
            reservationCol = iReservation.getReservationCollection(view);
            if (CollectionUtil.isEmpty((AbstractObjectCollection)reservationCol)) continue;
            if (!(entry instanceof IReservationEntry)) {
                throw new InvReservationException(InvReservationException.BILL_MUST_IMPELMENTS_INTERFACE);
            }
            IReservationEntry reservationEntry = (IReservationEntry)entry;
            String entryMaterialName = reservationEntry.getEntryMaterialName();
            String entryBaseQtyName = reservationEntry.getEntryBaseQtyName();
            String entryBaseUnitName = reservationEntry.getEntryBaseUnitName();
            String entryQtyName = reservationEntry.getEntryQtyName();
            String entryUnitName = reservationEntry.getEntryUnitName();
            String entryAssistQtyName = reservationEntry.getEntryAssistQtyName();
            String entryAssistUnitName = reservationEntry.getEntryAssistUnitName();
            String entryMfg = "mfg";
            String entryExp = "exp";
            if (StringUtil.isEmpty((String)entryBaseQtyName)) {
                throw new InvReservationException(InvReservationException.GET_ENTRY_BASEQTY_ERROR);
            }
            MaterialInfo material = (MaterialInfo)entry.get(entryMaterialName);
            if (material == null) {
                throw new InvReservationException(InvReservationException.GET_ENTRY_MATERIAL_ERROR);
            }
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)entry.get(entryBaseUnitName);
            MeasureUnitInfo unit = (MeasureUnitInfo)entry.get(entryUnitName);
            MeasureUnitInfo assistUnit = (MeasureUnitInfo)entry.get(entryAssistUnitName);
            BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
            BigDecimal qty = NumericUtil.BIGDECIMAL_ZERO;
            BigDecimal assistQty = NumericUtil.BIGDECIMAL_ZERO;
            baseQty = entry.getBigDecimal(entryBaseQtyName);
            qty = entry.getBigDecimal(entryQtyName);
            assistQty = entry.getBigDecimal(entryAssistQtyName);
            if (baseQty == null) {
                if (entry.getBigDecimal(entryQtyName) != null && unit != null && baseUnit != null) {
                    baseQty = baseUnit.getId().toString().equals(unit.getId().toString()) ? qty : SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)entry.getBigDecimal(entryQtyName), (String)material.getId().toString(), (String)unit.getId().toString(), (String)baseUnit.getId().toString());
                }
                entry.put(entryBaseQtyName, (Object)baseQty);
            }
            if (baseQty == null) {
                throw new InvReservationException(InvReservationException.GET_ENTRY_BASEQTY_ERROR);
            }
            int rsize = reservationCol.size();
            for (int n = 0; n < rsize; ++n) {
                reservationInfo = reservationCol.get(n);
                BigDecimal reservationBaseQty = reservationInfo.getReservationBaseQty();
                BigDecimal reservationAssistQty = reservationInfo.getReservationAssistQty() == null ? NumericUtil.BIGDECIMAL_ZERO : reservationInfo.getReservationAssistQty();
                String inventoryID = reservationInfo.getInventoryID();
                InventoryInfo inventoryInfo = iInventory.getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryID), this.getInventorySelector());
                baseQty = entry.getBigDecimal(entryBaseQtyName);
                if (reservationBaseQty.compareTo(baseQty) > 0) {
                    String storestateId;
                    entry.put("OLD_ENTRY_ID", (Object)entry.getId().toString());
                    Map map = ReservationBalanceUtil.matchInventory(ctx, model, (IObjectValue)entry, inventoryID);
                    BillInventoryConfigInfo config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
                    BillInventoryConfigEntryCollection configEntries = config.getEntry();
                    if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) break;
                    BillInventoryConfigEntryInfo configEntry = null;
                    int msize = configEntries.size();
                    for (int m = 0; m < msize; ++m) {
                        configEntry = configEntries.get(m);
                        if (StringUtil.isEmpty((String)configEntry.getBillProperty())) continue;
                        String billProperty = configEntry.getBillProperty();
                        if ("FStoreTypeID".equals(configEntry.getInvField()) || "FStoreStatusID".equals(configEntry.getInvField())) {
                            entry.put(configEntry.getInvField(), map.get(billProperty));
                            continue;
                        }
                        if (billProperty.indexOf(".") <= 1) continue;
                        entry.put(billProperty.split("\\.")[1], map.get(billProperty));
                    }
                    entry.put(entryBaseQtyName, (Object)baseQty);
                    if (inventoryInfo.getUnit() != null) {
                        BigDecimal qty1 = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty, (String)inventoryInfo.getMaterial().getId().toString(), (String)inventoryInfo.getBaseUnit().getId().toString(), (String)inventoryInfo.getUnit().getId().toString());
                        entry.put(entryQtyName, (Object)qty1);
                    }
                    if (inventoryInfo.getAssistUnit() != null) {
                        BigDecimal assistQty1 = assistQty;
                        entry.put(entryAssistQtyName, (Object)assistQty1);
                        if (reservationBaseQty.compareTo(baseQty) == 0) {
                            entry.put(entryAssistQtyName, (Object)reservationAssistQty);
                        }
                    }
                    entry.put("reservationId", (Object)reservationInfo.getId().toString());
                    if (!(StringUtil.isEmpty((String)inventoryInfo.getLot()) || StringUtil.isEmpty((String)entryMfg) || StringUtil.isEmpty((String)entryExp))) {
                        String lot = inventoryInfo.getLot();
                        StorageOrgUnitInfo sou = inventoryInfo.getStorageOrgUnit();
                        material = inventoryInfo.getMaterial();
                        IDateOfMinDurability iDate = DateOfMinDurabilityFactory.getLocalInstance(ctx);
                        EntityViewInfo dateView = new EntityViewInfo();
                        FilterInfo dateFilter = new FilterInfo();
                        dateFilter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                        dateFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                        dateFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                        dateView.setFilter(dateFilter);
                        DateOfMinDurabilityCollection col = iDate.getDateOfMinDurabilityCollection(dateView);
                        DateOfMinDurabilityInfo dateOfMin = null;
                        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                            dateOfMin = col.get(0);
                        }
                        if (dateOfMin != null) {
                            entry.put(entryMfg, (Object)dateOfMin.getMfg());
                            entry.put(entryExp, (Object)dateOfMin.getExp());
                        }
                    }
                    if (transactionTypeInfo == null) continue;
                    String storeTypeId = entry.get("FStoreTypeID") == null ? null : ((StoreTypeInfo)entry.get("FStoreTypeID")).getId().toString();
                    String string = storestateId = entry.get("FStoreStatusID") == null ? null : ((StoreStateInfo)entry.get("FStoreStatusID")).getId().toString();
                    if (StringUtil.isEmpty((String)storeTypeId) || StringUtil.isEmpty((String)storestateId)) continue;
                    String transId = transactionTypeInfo.getId().toString();
                    String key = transId + storeTypeId + storeTypeId;
                    if (invUpdateMap.containsKey(key)) {
                        entry.put("invUpdateType", invUpdateMap.get(key));
                        continue;
                    }
                    InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType((Context)ctx, (String)transactionTypeInfo.getId().toString(), (String)storeTypeId, (String)storestateId);
                    entry.put("invUpdateType", (Object)invUpdateType);
                    invUpdateMap.put(key, invUpdateType);
                    continue;
                }
                newEntry = (IObjectValue)entry.clone();
                newEntry.put("OLD_ENTRY_ID", (Object)entry.getId().toString());
                String bostype = entry.getBOSType().toString();
                newEntry.put("id", (Object)BOSUuid.create((String)bostype).toString());
                Map map = ReservationBalanceUtil.matchInventory(ctx, model, newEntry, inventoryID);
                Set keySet = map.keySet();
                BillInventoryConfigInfo config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
                BillInventoryConfigEntryCollection configEntries = config.getEntry();
                if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) break;
                BillInventoryConfigEntryInfo configEntry = null;
                int msize = configEntries.size();
                for (int m = 0; m < msize; ++m) {
                    configEntry = configEntries.get(m);
                    if (StringUtil.isEmpty((String)configEntry.getBillProperty())) continue;
                    String billProperty = configEntry.getBillProperty();
                    if ("FStoreTypeID".equals(configEntry.getInvField()) || "FStoreStatusID".equals(configEntry.getInvField())) {
                        newEntry.put(configEntry.getInvField(), map.get(billProperty));
                        continue;
                    }
                    if (billProperty.indexOf(".") <= 1 || !keySet.contains(billProperty)) continue;
                    newEntry.put(billProperty.split("\\.")[1], map.get(billProperty));
                }
                if (transactionTypeInfo != null) {
                    String storestateId;
                    String storeTypeId = newEntry.get("FStoreTypeID") == null ? null : ((StoreTypeInfo)newEntry.get("FStoreTypeID")).getId().toString();
                    String string = storestateId = newEntry.get("FStoreStatusID") == null ? null : ((StoreStateInfo)newEntry.get("FStoreStatusID")).getId().toString();
                    if (!StringUtil.isEmpty((String)storeTypeId) && !StringUtil.isEmpty((String)storestateId)) {
                        String transId = transactionTypeInfo.getId().toString();
                        String key = transId + storeTypeId + storeTypeId;
                        if (invUpdateMap.containsKey(key)) {
                            newEntry.put("invUpdateType", invUpdateMap.get(key));
                        } else {
                            InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType((Context)ctx, (String)transactionTypeInfo.getId().toString(), (String)storeTypeId, (String)storestateId);
                            newEntry.put("invUpdateType", (Object)invUpdateType);
                            invUpdateMap.put(key, invUpdateType);
                        }
                    }
                }
                inventoryInfo = iInventory.getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryID), this.getInventorySelector());
                newEntry.put(entryBaseQtyName, (Object)reservationInfo.getReservationBaseQty());
                BigDecimal newentryqty = NumericUtil.BIGDECIMAL_ZERO;
                if (inventoryInfo.getUnit() != null) {
                    newentryqty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)reservationInfo.getReservationBaseQty(), (String)inventoryInfo.getMaterial().getId().toString(), (String)inventoryInfo.getBaseUnit().getId().toString(), (String)inventoryInfo.getUnit().getId().toString());
                    newEntry.put(entryQtyName, (Object)newentryqty);
                }
                newEntry.put(entryAssistQtyName, (Object)reservationInfo.getReservationAssistQty());
                newEntry.put("reservationId", (Object)reservationInfo.getId().toString());
                entries.insertObject(i, newEntry);
                entry.put(entryBaseQtyName, (Object)baseQty.subtract(reservationBaseQty));
                if (entry.getBigDecimal(entryQtyName) != null && entry.get(entryUnitName) != null) {
                    BigDecimal oldentryqty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)newentryqty, (String)inventoryInfo.getMaterial().getId().toString(), (String)inventoryInfo.getUnit().getId().toString(), (String)((MeasureUnitInfo)entry.get(entryUnitName)).getId().toString());
                    entry.put(entryQtyName, (Object)entry.getBigDecimal(entryQtyName).subtract(oldentryqty));
                }
                if (model instanceof SaleIssueBillInfo && inventoryInfo.getUnit() != null && unit != null && !inventoryInfo.getUnit().getId().toString().equals(unit.getId().toString())) {
                    this.recalPrice(ctx, newEntry, material, unit, inventoryInfo);
                }
                if (assistUnit != null) {
                    BigDecimal b = baseQty.subtract(reservationBaseQty);
                    BigDecimal newAssistQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)b, (String)inventoryInfo.getMaterial().getId().toString(), (String)baseUnit.getId().toString(), (String)assistUnit.getId().toString());
                    entry.put(entryAssistQtyName, (Object)newAssistQty);
                }
                if (StringUtil.isEmpty((String)inventoryInfo.getLot()) || StringUtil.isEmpty((String)entryMfg) || StringUtil.isEmpty((String)entryExp)) continue;
                String lot = inventoryInfo.getLot();
                StorageOrgUnitInfo sou = inventoryInfo.getStorageOrgUnit();
                material = inventoryInfo.getMaterial();
                IDateOfMinDurability iDate = DateOfMinDurabilityFactory.getLocalInstance(ctx);
                EntityViewInfo dateView = new EntityViewInfo();
                FilterInfo dateFilter = new FilterInfo();
                dateFilter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                dateFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                dateFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                dateView.setFilter(dateFilter);
                DateOfMinDurabilityCollection col = iDate.getDateOfMinDurabilityCollection(dateView);
                DateOfMinDurabilityInfo dateOfMin = null;
                if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                    dateOfMin = col.get(0);
                }
                if (dateOfMin == null) continue;
                newEntry.put(entryMfg, (Object)dateOfMin.getMfg());
                newEntry.put(entryExp, (Object)dateOfMin.getExp());
            }
            if (entry.getBigDecimal(entryBaseQtyName).compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
                entries.removeObject((IObjectValue)entry);
                continue;
            }
            entry.put("OLD_ENTRY_ID", (Object)entry.getId().toString());
        }
    }

    @Override
    public void handleBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private SelectorItemCollection getInventorySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("lot"));
        return sic;
    }

    private void recalPrice(Context ctx, IObjectValue newEntry, MaterialInfo material, MeasureUnitInfo unit, InventoryInfo inventoryInfo) throws BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo fromMmu = immu.getMultiUnit(material.getId().toString(), unit.getId().toString());
        MultiMeasureUnitInfo toMmu = immu.getMultiUnit(material.getId().toString(), inventoryInfo.getUnit().getId().toString());
        int precision = material.getPricePrecision();
        if (precision == 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("pricePrecision");
            MaterialInfo mat = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()), selector);
            precision = mat.getPricePrecision();
        }
        if (fromMmu != null && toMmu != null) {
            BigDecimal fromRate = fromMmu.getBaseConvsRate();
            BigDecimal toRate = toMmu.getBaseConvsRate();
            if (fromRate == null) {
                fromRate = BigDecimal.ONE;
            }
            if (toRate == null) {
                toRate = BigDecimal.ONE;
            }
            if (newEntry.getBigDecimal("taxPrice") != null) {
                newEntry.setBigDecimal("taxPrice", newEntry.getBigDecimal("taxPrice").multiply(toRate).divide(fromRate, precision, 4));
            }
            if (newEntry.getBigDecimal("price") != null) {
                newEntry.setBigDecimal("price", newEntry.getBigDecimal("price").multiply(toRate).divide(fromRate, precision, 4));
            }
        }
    }
}

