/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.impl.IReservationBillUnAudit;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import java.util.ArrayList;

public class ReservationBillUnAuditImpl
implements IReservationBillUnAudit {
    @Override
    public void reservationBillUnAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        String billId = model.get("id").toString();
        IReservation iReservation = null;
        iReservation = ctx == null ? ReservationFactory.getRemoteInstance() : ReservationFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoReservation", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reservationBaseQty", (Object)0, CompareType.GREATER));
        filter.setMaskString("(#0 or #1) AND #2 AND #3");
        view.setFilter(filter);
        ReservationCollection col = iReservation.getReservationCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            throw new InvReservationException(InvReservationException.BILL_HAS_HANDLERESERVATION, new Object[]{model.get("number").toString()});
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoReservation", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reservationBaseQty", (Object)0, CompareType.GREATER));
        filter.setMaskString("(#0 or #1) AND #2 AND #3");
        view.setFilter(filter);
        col = iReservation.getReservationCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ReservationInfo reservationInfo = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            reservationInfo = col.get(i);
            idList.add(reservationInfo.getId().toString());
        }
        ReservationUtil.requestMutex(ctx, idList);
        iReservation.cancelReservation(idList);
        ReservationUtil.releaseMutex(ctx, idList);
    }
}

