/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.im.reservation.IReservationEx;
import com.kingdee.eas.scm.im.reservation.IReservationSchema;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationExEntryCollection;
import com.kingdee.eas.scm.im.reservation.ReservationExEntryInfo;
import com.kingdee.eas.scm.im.reservation.ReservationExFactory;
import com.kingdee.eas.scm.im.reservation.ReservationExInfo;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingProperty;
import com.kingdee.eas.scm.im.reservation.model.MatchProperty;
import com.kingdee.eas.scm.im.reservation.model.MatchPropertyCollection;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class ReservationUtil {
    public static final Logger logger = Logger.getLogger(ReservationUtil.class);
    public static final String SPLITMARK = ".";
    public static Map<String, String> billEntryNameMap = new HashMap<String, String>();
    static Map<String, IMetaDataPK> billQueryPKMap = new HashMap<String, IMetaDataPK>();
    static Map<String, BizEnumInfo> enumMap = new HashMap<String, BizEnumInfo>();
    public static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    private static Map<String, PropertyInfo> propertyMap = new HashMap<String, PropertyInfo>();
    public static Map<String, Map<String, PropertyInfo>> entityPropertyMap = new HashMap<String, Map<String, PropertyInfo>>();
    public static Map<String, Boolean> isLinkMap = new HashMap<String, Boolean>();
    static Map<String, ReservationExInfo> reservationExMap = new HashMap<String, ReservationExInfo>();

    public static EntityObjectInfo getEntryEntityObject(EntityObjectInfo parentObject) {
        if (parentObject == null) {
            return null;
        }
        EntityObjectInfo entryEntity = null;
        PropertyCollection col = parentObject.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!ReservationUtil.isEntryProperty(parentObject, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            return relation.getSupplierObject();
        }
        return entryEntity;
    }

    public static String getBillEntryPropertyName(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!ReservationUtil.isEntryProperty(billEntity, property)) continue;
            return property.getName();
        }
        return entryPropertyName;
    }

    public static String getBillEntryPropertyName(String bosTypeID) {
        if (billEntryNameMap.containsKey(bosTypeID)) {
            return billEntryNameMap.get(bosTypeID);
        }
        EntityObjectInfo billEntity = null;
        billEntity = ReservationUtil.getEntityObjectInfo(bosTypeID);
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!ReservationUtil.isEntryProperty(billEntity, property)) continue;
            billEntryNameMap.put(bosTypeID, property.getName());
            return property.getName();
        }
        return entryPropertyName;
    }

    public static LinkPropertyInfo getBillEntryProperty(Context ctx, String bosTypeID) {
        EntityObjectInfo billEntity = null;
        billEntity = ReservationUtil.getEntityObjectInfo(ctx, bosTypeID);
        if (billEntity == null) {
            return null;
        }
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!ReservationUtil.isEntryProperty(billEntity, property)) continue;
            return (LinkPropertyInfo)property;
        }
        return null;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static String getEntryMaterialPropertyName(EntityObjectInfo entryEntity) {
        if (entryEntity == null) {
            return null;
        }
        String materialPropertyName = null;
        PropertyCollection col = entryEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo relation;
            property = col.get(i);
            if (!(property instanceof LinkPropertyInfo) || !"4409E7F0".equals((relation = ((LinkPropertyInfo)property).getRelationship()).getSupplierObject().getBOSType())) continue;
            return property.getName();
        }
        return materialPropertyName;
    }

    public static String getBillTransactionTypePropertyName(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        String transPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo relation;
            property = col.get(i);
            if (!(property instanceof LinkPropertyInfo) || !"B008DCA7".equals((relation = ((LinkPropertyInfo)property).getRelationship()).getSupplierObject().getType().toString())) continue;
            return property.getName();
        }
        return transPropertyName;
    }

    public static KDTable buildTable(String settingStr) {
        KDTable table = new KDTable();
        if (StringUtil.isEmpty((String)settingStr)) {
            return table;
        }
        BillReservationTableSettingCollection tableSettingCol = new BillReservationTableSettingCollection(settingStr);
        List<BillReservationTableSettingProperty> tabSettingCollection = tableSettingCol.getTabSettingCollection();
        IRow row = table.addHeadRow();
        for (BillReservationTableSettingProperty property : tabSettingCollection) {
            IColumn column = table.addColumn();
            column.setKey(property.getFieldName());
            Styles.HorizontalAlignment align = property.isNumeric() ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT;
            column.getStyleAttributes().setHorizontalAlign(align);
            column.getStyleAttributes().setLocked(true);
            column.getStyleAttributes().setHided(!property.isShow());
            column.setWidth(property.getColumnWidth());
            row.getCell(property.getFieldName()).setValue((Object)property.getHeadName());
        }
        return table;
    }

    public static String getQueryPropertyParentAlias(String billQuery, String fieldName) {
        String propertyName = "UNDEFINE";
        if (StringUtil.isEmpty((String)billQuery) || StringUtil.isEmpty((String)fieldName)) {
            return propertyName;
        }
        MetaDataPK billQueryPK = null;
        if (billQueryPKMap.containsKey(billQuery)) {
            billQueryPK = billQueryPKMap.get(billQuery);
        } else {
            billQueryPK = MetaDataPK.create((String)billQuery);
            billQueryPKMap.put(billQuery, (IMetaDataPK)billQueryPK);
        }
        try {
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            QueryFieldInfo field = null;
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                if (!fieldName.equals(((QueryFieldInfo)fields.get(i)).getName())) continue;
                field = (QueryFieldInfo)fields.get(i);
                break;
            }
            if (field == null) {
                return "";
            }
            SubEntityInfo subEntityInfo = field.getPropertyRefs().get(0).getSubEntity();
            if (subEntityInfo != null) {
                return subEntityInfo.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getQueryFeildShowValue(String billQuery, String fieldName) {
        String propertyName = "UNDEFINE";
        if (StringUtil.isEmpty((String)billQuery) || StringUtil.isEmpty((String)fieldName)) {
            return propertyName;
        }
        MetaDataPK billQueryPK = null;
        if (billQueryPKMap.containsKey(billQuery)) {
            billQueryPK = billQueryPKMap.get(billQuery);
        } else {
            billQueryPK = MetaDataPK.create((String)billQuery);
            billQueryPKMap.put(billQuery, (IMetaDataPK)billQueryPK);
        }
        try {
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            QueryFieldInfo field = null;
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                if (!fieldName.equals(((QueryFieldInfo)fields.get(i)).getName())) continue;
                field = (QueryFieldInfo)fields.get(i);
                break;
            }
            if (field == null) {
                return "";
            }
            return field.getShowValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getEntryFieldName(String billBosType, String entryBosType, String billQuery, String fieldName) {
        String propertyName = "UNDEFINE";
        if (StringUtil.isEmpty((String)billBosType) || StringUtil.isEmpty((String)entryBosType) || StringUtil.isEmpty((String)billQuery) || StringUtil.isEmpty((String)fieldName)) {
            return propertyName;
        }
        MetaDataPK billQueryPK = null;
        if (billQueryPKMap.containsKey(billQuery)) {
            billQueryPK = billQueryPKMap.get(billQuery);
        } else {
            billQueryPK = MetaDataPK.create((String)billQuery);
            billQueryPKMap.put(billQuery, (IMetaDataPK)billQueryPK);
        }
        try {
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            QueryFieldInfo field = null;
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                if (!fieldName.equals(((QueryFieldInfo)fields.get(i)).getName())) continue;
                field = (QueryFieldInfo)fields.get(i);
                break;
            }
            if (field == null) {
                return "";
            }
            SubEntityInfo subEntityInfo = field.getPropertyRefs().get(0).getSubEntity();
            JoinInfo joinInfo = null;
            SubEntityInfo leftObject = null;
            SubEntityInfo rightObject = null;
            String leftBosType = "";
            String rightBosType = "";
            joinInfo = field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0);
            if (joinInfo != null) {
                leftObject = (SubEntityInfo)field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0).getLeftObject();
                rightObject = (SubEntityInfo)field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0).getRightObject();
                leftBosType = leftObject.getEntityRef().getType().toString();
                rightBosType = rightObject.getEntityRef().getType().toString();
            } else {
                propertyName = fieldName;
            }
            if (billBosType.equals(leftBosType)) {
                if (entryBosType.equals(rightBosType)) {
                    propertyName = field.getRefPropertyName();
                } else {
                    PropertyInfo property = field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0).getJoinItems().get(0).getLeftField().getPropertyRefs().get(0).getRefProperty();
                    propertyName = property.getName();
                }
            } else if (entryBosType.equals(leftBosType)) {
                field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0).getJoinItems().get(0).getLeftField();
                PropertyInfo property = field.getPropertyRefs().get(0).getSubEntity().getJoinsFromSupplier().get(0).getJoinItems().get(0).getLeftField().getPropertyRefs().get(0).getRefProperty();
                propertyName = property.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertyName;
    }

    public static BizEnumInfo getQueryBizEnumInfo(String billQuery, String fieldName) {
        String key = billQuery + fieldName;
        if (enumMap.containsKey(key)) {
            return enumMap.get(key);
        }
        MetaDataPK billQueryPK = null;
        if (billQueryPKMap.containsKey(billQuery)) {
            billQueryPK = billQueryPKMap.get(billQuery);
        } else {
            billQueryPK = MetaDataPK.create((String)billQuery);
            billQueryPKMap.put(billQuery, (IMetaDataPK)billQueryPK);
        }
        try {
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            QueryFieldInfo field = null;
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                if (!fieldName.equals(((QueryFieldInfo)fields.get(i)).getName())) continue;
                field = (QueryFieldInfo)fields.get(i);
                break;
            }
            if (field == null) {
                return null;
            }
            PropertyInfo property1 = field.getPropertyRefs().get(0).getRefProperty();
            if (property1 instanceof OwnPropertyInfo) {
                BizEnumInfo bizEnum = ((OwnPropertyInfo)property1).getEnumType();
                enumMap.put(key, bizEnum);
                return bizEnum;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getEnumAlias(BizEnumInfo bizEnum, String enumValue) {
        if (bizEnum == null || CollectionUtil.isEmpty((AbstractObjectCollection)bizEnum.getEnumValue()) || enumValue == null) {
            return null;
        }
        BizEnumValueCollection enumCol = bizEnum.getEnumValue();
        BizEnumValueInfo enumInfo = null;
        int size = enumCol.size();
        for (int i = 0; i < size; ++i) {
            enumInfo = enumCol.get(i);
            enumInfo.getValue();
            if (enumInfo.getValue() == enumValue) {
                return enumInfo.getAlias();
            }
            if (!enumInfo.getValue().toString().equals(enumValue)) continue;
            return enumInfo.getAlias();
        }
        return null;
    }

    private static boolean checkHasAutoSchema(Context ctx, String billBosType) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)billBosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)1, CompareType.EQUALS));
        CtrlUnitInfo cu = null;
        cu = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit() : ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cu != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        IReservationSchema iReservationSchema = null == ctx ? ReservationSchemaFactory.getRemoteInstance() : ReservationSchemaFactory.getLocalInstance(ctx);
        ReservationSchemaCollection col = iReservationSchema.getReservationSchemaCollection(view);
        return !CollectionUtil.isEmpty((AbstractObjectCollection)col);
    }

    public static FilterInfo getMatchFilterInfo(MatchPropertyCollection propertyCol, IObjectValue billInfo, IObjectValue curEntryInfo) {
        List<MatchProperty> matchPropertyList = propertyCol.getMatchPropertyList();
        FilterInfo matchFilter = new FilterInfo();
        MatchProperty matchProperty = null;
        int msize = matchPropertyList.size();
        for (int n = 0; n < msize; ++n) {
            matchProperty = matchPropertyList.get(n);
            matchProperty.getSrcProperty().getEntity();
            FilterItemInfo item = ReservationUtil.parseMatchCondition(billInfo, curEntryInfo, matchProperty);
            if (item == null) continue;
            matchFilter.getFilterItems().add(item);
        }
        return matchFilter;
    }

    public static FilterItemInfo parseMatchCondition(IObjectValue srcBillModel, IObjectValue srcEntryModel, MatchProperty matchProperty) {
        String destPropertyName = matchProperty.getDestProperty().getName();
        String srcPropertyName = matchProperty.getSrcProperty().getName();
        return ReservationUtil.parseMatchCondition(srcBillModel, srcEntryModel, destPropertyName, srcPropertyName);
    }

    public static FilterItemInfo parseMatchCondition(IObjectValue srcBillModel, IObjectValue srcEntryModel, String destPropertyName, String srcPropertyName) {
        FilterItemInfo item = null;
        if (srcBillModel.get(srcPropertyName) != null) {
            if (srcBillModel.get(srcPropertyName) instanceof IObjectValue) {
                String srcIdValue = ((IObjectValue)srcBillModel.get(srcPropertyName)).get("id").toString();
                item = new FilterItemInfo(destPropertyName + ".id", (Object)srcIdValue, CompareType.EQUALS);
            } else {
                item = srcBillModel.get(srcPropertyName) instanceof BigDecimal ? new FilterItemInfo(destPropertyName, (Object)((BigDecimal)srcBillModel.get(srcPropertyName)), CompareType.EQUALS) : (srcBillModel.get(srcPropertyName) instanceof Date ? new FilterItemInfo(destPropertyName, (Object)((Date)srcBillModel.get(srcPropertyName)), CompareType.EQUALS) : (srcBillModel.get(srcPropertyName) instanceof String ? new FilterItemInfo(destPropertyName, (Object)((String)srcBillModel.get(srcPropertyName)), CompareType.EQUALS) : (srcBillModel.get(srcPropertyName) instanceof Boolean ? new FilterItemInfo(destPropertyName, (Object)((Boolean)srcBillModel.get(srcPropertyName)), CompareType.EQUALS) : new FilterItemInfo(destPropertyName, (Object)srcBillModel.get(srcPropertyName).toString(), CompareType.EQUALS))));
            }
        } else {
            String entryField = srcPropertyName.substring(srcPropertyName.indexOf(SPLITMARK) + 1);
            if (srcEntryModel.get(entryField) != null) {
                if (srcEntryModel.get(entryField) instanceof IObjectValue) {
                    String srcIdValue = ((IObjectValue)srcEntryModel.get(entryField)).get("id").toString();
                    item = new FilterItemInfo(destPropertyName + ".id", (Object)srcIdValue, CompareType.EQUALS);
                } else {
                    item = srcEntryModel.get(entryField) instanceof BigDecimal ? new FilterItemInfo(destPropertyName, (Object)((BigDecimal)srcEntryModel.get(entryField)), CompareType.EQUALS) : (srcEntryModel.get(entryField) instanceof Date ? new FilterItemInfo(destPropertyName, (Object)((Date)srcEntryModel.get(entryField)), CompareType.EQUALS) : (srcEntryModel.get(entryField) instanceof String ? new FilterItemInfo(destPropertyName, (Object)((String)srcEntryModel.get(entryField)), CompareType.EQUALS) : (srcEntryModel.get(entryField) instanceof Boolean ? new FilterItemInfo(destPropertyName, (Object)((Boolean)srcEntryModel.get(entryField)), CompareType.EQUALS) : new FilterItemInfo(destPropertyName, (Object)srcEntryModel.get(entryField).toString(), CompareType.EQUALS))));
                }
            }
        }
        return item;
    }

    public static FilterInfo getSupplyBillFilter(ReservationSchemaInfo reservationSchemaInfo, ReservationSupplyObjectInfo supplyObject, IObjectValue billInfo, IObjectValue curEntryInfo) throws Exception {
        int dateAhead;
        String srcPropertyName;
        FilterInfo billDataFilter = supplyObject.getFilterInfo();
        if (billDataFilter == null) {
            billDataFilter = new FilterInfo();
        }
        MatchPropertyCollection matchCol = supplyObject.getMatchPropertyCollection(reservationSchemaInfo.getBillFullName());
        List<MatchProperty> matchPropertyList = matchCol.getMatchPropertyList();
        MatchProperty matchProperty = null;
        FilterInfo matchFilter = new FilterInfo();
        int msize = matchPropertyList.size();
        for (int n = 0; n < msize; ++n) {
            matchProperty = matchPropertyList.get(n);
            FilterItemInfo item = ReservationUtil.parseMatchCondition(billInfo, curEntryInfo, matchProperty);
            if (item == null) continue;
            matchFilter.getFilterItems().add(item);
        }
        FilterInfo orgFilter = new FilterInfo();
        String destPropertyName = supplyObject.getOrgField();
        FilterItemInfo orgItem = ReservationUtil.parseMatchCondition(billInfo, curEntryInfo, destPropertyName, srcPropertyName = reservationSchemaInfo.getOrgField());
        if (orgItem != null) {
            orgFilter.getFilterItems().add(orgItem);
        }
        FilterInfo dateFilter = new FilterInfo();
        destPropertyName = supplyObject.getDateField();
        FilterItemInfo dateItem = ReservationUtil.parseDateFilterCondition(billInfo, curEntryInfo, destPropertyName, srcPropertyName = reservationSchemaInfo.getDateField(), dateAhead = supplyObject.getAheadDays());
        if (dateItem != null) {
            dateFilter.getFilterItems().add(dateItem);
        }
        if (billDataFilter != null) {
            billDataFilter.mergeFilter(matchFilter, "AND");
            billDataFilter.mergeFilter(orgFilter, "AND");
            billDataFilter.mergeFilter(dateFilter, "AND");
        }
        return billDataFilter;
    }

    public static FilterItemInfo parseDateFilterCondition(IObjectValue srcBillModel, IObjectValue srcEntryModel, String destPropertyName, String srcPropertyName, int dateAhead) {
        FilterItemInfo item = null;
        if (srcBillModel.get(srcPropertyName) != null) {
            if (srcBillModel.get(srcPropertyName) instanceof IObjectValue) {
                String srcIdValue = ((IObjectValue)srcBillModel.get(srcPropertyName)).get("id").toString();
                item = new FilterItemInfo(destPropertyName + ".id", (Object)srcIdValue, CompareType.LESS_EQUALS);
            } else if (srcBillModel.get(srcPropertyName) instanceof BigDecimal) {
                item = new FilterItemInfo(destPropertyName, (Object)((BigDecimal)srcBillModel.get(srcPropertyName)), CompareType.LESS_EQUALS);
            } else if (srcBillModel.get(srcPropertyName) instanceof Date) {
                Date date = (Date)srcBillModel.get(srcPropertyName);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(date.getTime());
                calendar.add(5, -dateAhead);
                item = new FilterItemInfo(destPropertyName, (Object)calendar.getTime(), CompareType.LESS_EQUALS);
            }
        } else {
            String entryField = srcPropertyName.substring(srcPropertyName.indexOf(SPLITMARK) + 1);
            if (srcEntryModel.get(entryField) != null) {
                if (srcEntryModel.get(entryField) instanceof IObjectValue) {
                    String srcIdValue = ((IObjectValue)srcEntryModel.get(entryField)).get("id").toString();
                    item = new FilterItemInfo(destPropertyName + ".id", (Object)srcIdValue, CompareType.LESS_EQUALS);
                } else if (srcEntryModel.get(entryField) instanceof BigDecimal) {
                    item = new FilterItemInfo(destPropertyName, (Object)((BigDecimal)srcEntryModel.get(entryField)), CompareType.LESS_EQUALS);
                } else if (srcEntryModel.get(entryField) instanceof Date) {
                    Date date = (Date)srcEntryModel.get(entryField);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(date.getTime());
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    calendar.set(14, 999);
                    calendar.add(5, -dateAhead);
                    item = new FilterItemInfo(destPropertyName, (Object)calendar.getTime(), CompareType.LESS_EQUALS);
                }
            }
        }
        return item;
    }

    public static String getRequireBillStorageUnit(ReservationSchemaInfo reservationSchemaInfo, IObjectValue billInfo, IObjectValue curEntryInfo) {
        if (reservationSchemaInfo == null || billInfo == null || curEntryInfo == null) {
            return null;
        }
        String orgField = reservationSchemaInfo.getOrgField();
        if (billInfo.get(orgField) != null) {
            if (billInfo.get(orgField) instanceof IObjectValue) {
                return ((IObjectValue)billInfo.get(orgField)).get("id").toString();
            }
        } else {
            String entryField = orgField.substring(orgField.indexOf(SPLITMARK) + 1);
            if (curEntryInfo.get(entryField) != null && curEntryInfo.get(entryField) instanceof IObjectValue) {
                return ((IObjectValue)curEntryInfo.get(entryField)).get("id").toString();
            }
        }
        return null;
    }

    public static boolean isExistOrgField(ReservationSchemaInfo reservationSchemaInfo, IObjectValue billInfo, IObjectValue curEntryInfo) {
        if (reservationSchemaInfo == null || billInfo == null || curEntryInfo == null) {
            return true;
        }
        String orgField = reservationSchemaInfo.getOrgField();
        if (billInfo.get(orgField) != null) {
            return true;
        }
        String entryField = orgField.substring(orgField.indexOf(SPLITMARK) + 1);
        return curEntryInfo.get(entryField) != null;
    }

    public static boolean checkIsCanHandleReservation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return !CollectionUtil.isEmpty((AbstractObjectCollection)ReservationUtil.getBillReservationSchema(ctx, model, false));
    }

    public static boolean checkIsCanAutoReservation(Context ctx, IObjectValue model) throws Exception, BOSException, EASBizException {
        return ReservationUtil.getBillAutoReservationSchema(ctx, model) != null;
    }

    public static String getCuByModel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String cuID = null;
        if (model instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo baseInfo = (CoreBillBaseInfo)model;
            String property = baseInfo.getBizOrgPropertyName();
            OrgUnitInfo mainOrg = (OrgUnitInfo)baseInfo.get(property);
            if (mainOrg != null && mainOrg.getCU() != null) {
                cuID = mainOrg.getCU().getId().toString();
            } else if (mainOrg != null) {
                String mainOrgID = mainOrg.getId().toString();
                IFullOrgUnit iorg = null;
                iorg = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
                OrgUnitInfo orgInfo = iorg.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
                if (orgInfo != null && orgInfo.getCU() != null) {
                    cuID = orgInfo.getCU().getId().toString();
                }
            }
        }
        if (cuID == null) {
            CtrlUnitInfo cu = (CtrlUnitInfo)model.get("CU");
            if (cu == null) {
                cu = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit() : ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            if (cu != null && cu.getId() != null) {
                cuID = cu.getId().toString();
            }
        }
        return cuID;
    }

    public static ReservationSchemaInfo getBillAutoReservationSchema(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null == model) {
            return null;
        }
        String billBosType = model.getBOSType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)billBosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        String cuId = ReservationUtil.getCuByModel(ctx, model);
        if (cuId != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IReservationSchema iReservationSchema = null == ctx ? ReservationSchemaFactory.getRemoteInstance() : ReservationSchemaFactory.getLocalInstance(ctx);
        ReservationSchemaCollection col = iReservationSchema.getReservationSchemaCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        return col.get(0);
    }

    public static ReservationSchemaCollection getBillReservationSchema(Context ctx, IObjectValue model, boolean isAuto) throws BOSException, EASBizException {
        if (null == model) {
            return null;
        }
        String billBosType = model.getBOSType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)billBosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)isAuto, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        String cuId = ReservationUtil.getCuByModel(ctx, model);
        if (cuId != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IReservationSchema iReservationSchema = null == ctx ? ReservationSchemaFactory.getRemoteInstance() : ReservationSchemaFactory.getLocalInstance(ctx);
        return iReservationSchema.getReservationSchemaCollection(view);
    }

    public static IRowSet getBillRowSet(Context ctx, String sql) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    public static List getReservationData(Context ctx, String fieldName, List idList) throws BOSException, EASBizException {
        ArrayList<ReservationModel> list = new ArrayList<ReservationModel>();
        if (ctx == null || StringUtil.isEmpty((String)fieldName) || CollectionUtil.isEmpty((Collection)idList)) {
            return list;
        }
        String sql = "";
        String ids = CollectionUtil.convertList2String((List)idList);
        sql = "SELECT " + fieldName + " as FID,isnull(SUM(FRESERVATIONQTY), 0) as FTOTALRESERVATIONQTY,isnull(SUM(FRESERVATIONBASEQTY), 0) as FTOTALRESERVATIONBASEQTY,isnull(SUM(FRESERVATIONASSISTQTY), 0) as FTOTALRESERVATIONASSISTQTY FROM T_IM_Reservation WHERE " + fieldName + " IN(" + ids + ") GROUP BY " + fieldName + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ReservationModel reservationModel = null;
            while (rs.next()) {
                reservationModel = new ReservationModel(fieldName);
                reservationModel.setFieldValue(rs.getString("FID"));
                reservationModel.setTotalReservationQty(rs.getBigDecimal("FTOTALRESERVATIONQTY"));
                reservationModel.setTotalReservationBaseQty(rs.getBigDecimal("FTOTALRESERVATIONBASEQTY"));
                reservationModel.setTotalReservationAssistQty(rs.getBigDecimal("FTOTALRESERVATIONASSISTQTY"));
                list.add(reservationModel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static ReservationModel getInventoryReservationData(Context ctx, String inventoryID) throws BOSException, EASBizException {
        ReservationModel reservationModel = new ReservationModel("FINVENTORYID");
        reservationModel.setTotalReservationBaseQty(NumericUtil.BIGDECIMAL_ZERO);
        reservationModel.setTotalReservationQty(NumericUtil.BIGDECIMAL_ZERO);
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(inventoryID);
        List list = ReservationUtil.getReservationData(ctx, "FINVENTORYID", idList);
        if (!CollectionUtil.isEmpty((Collection)list)) {
            reservationModel = (ReservationModel)list.get(0);
        }
        return reservationModel;
    }

    public static String getReservationBillObjectID(Context ctx, String billEntryID) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)billEntryID)) {
            return "";
        }
        String reservationBillObjectID = "";
        ObjectUuidPK billEntryPK = new ObjectUuidPK(billEntryID);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue model = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
        reservationBillObjectID = (String)model.get("reservationBillObjectId");
        return reservationBillObjectID;
    }

    public static String getReservationID(Context ctx, String billEntryID) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)billEntryID)) {
            return "";
        }
        String reservationBillObjectID = "";
        ObjectUuidPK billEntryPK = new ObjectUuidPK(billEntryID);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue model = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
        reservationBillObjectID = (String)model.get("reservationId");
        return reservationBillObjectID;
    }

    public static void lockReservationRecords(Context ctx, String reservationID) throws BOSException, EASBizException {
        if (ctx == null || StringUtil.isEmpty((String)reservationID)) {
            return;
        }
        String updateSql = "UPDATE T_IM_RESERVATION SET FID=FID WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{reservationID});
    }

    public static void lockReservationRecords(Context ctx, List reservationIDList) throws BOSException, EASBizException {
        if (ctx == null || CollectionUtil.isEmpty((Collection)reservationIDList)) {
            return;
        }
        String ids = CollectionUtil.convertList2String((List)reservationIDList);
        String updateSql = "UPDATE T_IM_RESERVATION SET FID=FID WHERE FID IN(" + ids + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static void lockReservationRecords(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        if (ctx == null || CollectionUtil.isEmpty((IObjectCollection)col)) {
            return;
        }
        ArrayList<String> reservationIDList = new ArrayList<String>();
        IObjectValue model = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model = col.getObject(i);
            if (model.get("id") == null) continue;
            reservationIDList.add(model.get("id").toString());
        }
        ReservationUtil.lockReservationRecords(ctx, reservationIDList);
    }

    public static void lockInventoryRecords(Context ctx, String inventoryID) throws BOSException, EASBizException {
        if (ctx == null || StringUtil.isEmpty((String)inventoryID)) {
            return;
        }
        String updateSql = "UPDATE T_IM_INVENTORY SET FID=FID WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{inventoryID});
    }

    public static void lockInventoryRecords(Context ctx, List inventoryIDList) throws BOSException, EASBizException {
        if (ctx == null || CollectionUtil.isEmpty((Collection)inventoryIDList)) {
            return;
        }
        String ids = CollectionUtil.convertList2String((List)inventoryIDList);
        String updateSql = "UPDATE T_IM_INVENTORY SET FID=FID WHERE FID IN(" + ids + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    public static void lockInventoryRecords(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        if (ctx == null || CollectionUtil.isEmpty((IObjectCollection)col)) {
            return;
        }
        ArrayList<String> inventoryIDList = new ArrayList<String>();
        IObjectValue model = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model = col.getObject(i);
            if (model.get("id") == null) continue;
            inventoryIDList.add(model.get("id").toString());
        }
        ReservationUtil.lockInventoryRecords(ctx, inventoryIDList);
    }

    public static boolean checkIsReservationBill(Context ctx, IObjectValue model) {
        if (null == model || null == model.getBOSType()) {
            return false;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return false;
        }
        String entryId = "";
        String reservationBillObjectId = "";
        IObjectValue entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            entryId = entry.get("ID").toString();
            reservationBillObjectId = (String)entry.get("reservationBillObjectId");
            if (StringUtil.isEmpty((String)reservationBillObjectId) || reservationBillObjectId.equals(entryId)) continue;
            return true;
        }
        return false;
    }

    public static EntityObjectInfo getEntityObjectInfo(String bosTypeID) {
        return ReservationUtil.getEntityObjectInfo(null, bosTypeID);
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtil.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    public static Map<String, PropertyInfo> getEntityProperty(String bosType) {
        if (entityPropertyMap.containsKey(bosType)) {
            return entityPropertyMap.get(bosType);
        }
        EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(null, bosType);
        entityPropertyMap.put(bosType, ReservationUtil.getEntityProperty(entity));
        return entityPropertyMap.get(bosType);
    }

    public static Map<String, PropertyInfo> getEntityProperty(Context ctx, String bosType) {
        if (entityPropertyMap.containsKey(bosType)) {
            return entityPropertyMap.get(bosType);
        }
        EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, bosType);
        entityPropertyMap.put(bosType, ReservationUtil.getEntityProperty(entity));
        return entityPropertyMap.get(bosType);
    }

    public static Map<String, PropertyInfo> getEntityProperty(EntityObjectInfo entity) {
        propertyMap.clear();
        ReservationUtil.getEntityProperty(entity, null);
        HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
        map.putAll(propertyMap);
        return map;
    }

    public static void getEntityProperty(EntityObjectInfo entity, String parentName, String parentAlias) {
        if (entity == null) {
            return;
        }
        PropertyCollection coll = entity.getEntityProperties();
        PropertyInfo property = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            property = coll.get(i);
            if (!(property instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo linkEntity = relation.getSupplierObject();
            if (StringUtil.isEmpty((String)parentName)) {
                property.put("fullName", (Object)property.getName());
            } else {
                property.put("fullName", (Object)(parentName + SPLITMARK + property.getName()));
            }
            if (StringUtil.isEmpty((String)parentAlias)) {
                property.put("fullAlias", (Object)property.getAlias());
            } else {
                property.put("fullAlias", (Object)(parentAlias + SPLITMARK + property.getAlias()));
            }
            property.put("linkedBosType", (Object)linkEntity.getType().toString());
            propertyMap.put(property.get("fullName").toString(), property);
            if (!ReservationUtil.isEntryProperty(entity, property)) continue;
            String propertyName = "";
            String propertyAlias = "";
            EntityObjectInfo entryEntity = relation.getSupplierObject();
            propertyName = property.getName();
            propertyAlias = property.getAlias();
            ReservationUtil.getEntityProperty(entryEntity, propertyName, propertyAlias);
        }
    }

    public static boolean isLinkProperty(Context ctx, String bosTypeID, String propertyName) {
        if (StringUtil.isEmpty((String)bosTypeID) || StringUtil.isEmpty((String)propertyName)) {
            return false;
        }
        String key = bosTypeID + propertyName;
        if (isLinkMap.containsKey(key)) {
            return isLinkMap.get(key);
        }
        EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(null, bosTypeID);
        if (entity == null) {
            return false;
        }
        PropertyCollection coll = entity.getEntityProperties();
        PropertyInfo property = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            property = coll.get(i);
            if (!property.getName().equals(propertyName) || !(property instanceof LinkPropertyInfo)) continue;
            isLinkMap.put(key, Boolean.TRUE);
            return true;
        }
        isLinkMap.put(key, Boolean.FALSE);
        return false;
    }

    public static void getEntityProperty(EntityObjectInfo entity, PropertyInfo parent) {
        if (entity == null) {
            return;
        }
        String parentName = "";
        String parentAlias = "";
        if (parent != null) {
            parentName = parent.get("fullName").toString();
            parentAlias = parent.get("fullAlias").toString();
        } else {
            parentAlias = entity.getAlias();
        }
        PropertyCollection coll = entity.getEntityProperties();
        PropertyInfo property = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            property = coll.get(i);
            if (!(property instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo linkEntity = relation.getSupplierObject();
            if (StringUtil.isEmpty((String)parentName)) {
                property.put("fullName", (Object)property.getName());
            } else {
                property.put("fullName", (Object)(parentName + SPLITMARK + property.getName()));
            }
            if (StringUtil.isEmpty((String)parentAlias)) {
                property.put("fullAlias", (Object)property.getAlias());
            } else {
                property.put("fullAlias", (Object)(parentAlias + SPLITMARK + property.getAlias()));
            }
            property.put("linkedBosType", (Object)linkEntity.getType().toString());
            propertyMap.put(property.get("fullName").toString(), property);
            if (!ReservationUtil.isEntryProperty(entity, property)) continue;
            EntityObjectInfo entryEntity = relation.getSupplierObject();
            ReservationUtil.getEntityProperty(entryEntity, property);
        }
    }

    public static void requestMutex(Context ctx, String objectId) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = mutexService.requestObjIDForUpdate(objectId);
        if (!flag) {
            throw new InvReservationException(InvReservationException.OBJECT_ISLOCK);
        }
    }

    public static void requestMutex(Context ctx, List idList) throws BOSException, EASBizException {
        ArrayList<String> requestIdList = new ArrayList<String>();
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map map = mutexService.batchRequestObjIDForUpdate(idList);
        Set set = map.entrySet();
        boolean hasLockId = false;
        for (Map.Entry mapEntry : set) {
            if (((Boolean)mapEntry.getValue()).booleanValue()) {
                requestIdList.add((String)mapEntry.getKey());
                continue;
            }
            hasLockId = true;
        }
        if (hasLockId) {
            ReservationUtil.releaseMutex(ctx, requestIdList);
            throw new InvReservationException(InvReservationException.OBJECT_ISLOCK);
        }
    }

    public static void releaseMutex(Context ctx, String objectId) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseObjIDForUpdate(objectId);
    }

    public static void releaseMutex(Context ctx, List idList) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.batchReleaseObjIDForUpdate(idList);
    }

    public boolean hasGenerateDestBill(Context ctx, IObjectValue model) throws BOSException {
        if (model == null || model.getBOSType() == null || model.get("id") == null) {
            return false;
        }
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)model.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)model.get("id").toString(), CompareType.EQUALS));
        BOTRelationCollection col = iBOTRelation.getCollection(view);
        return !CollectionUtil.isEmpty((AbstractObjectCollection)col);
    }

    public static String getResourceString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)key);
    }

    public static List<String> getBillReservationList(Context ctx, IObjectValue model, boolean isSelf) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return list;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return list;
        }
        IObjectValue entry = null;
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            if (entry == null || entry.get("id") == null) continue;
            String billEntryId = entry.get("id").toString();
            if (entry.get("reservationBillObjectId") == null) {
                ObjectUuidPK billEntryPK = new ObjectUuidPK(billEntryId);
                try {
                    entry = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (entry == null || entry.getString("reservationBillObjectId") == null) continue;
            if (isSelf) {
                if (!billEntryId.equals(entry.getString("reservationBillObjectId"))) continue;
                list.add(entry.getString("reservationBillObjectId"));
                continue;
            }
            if (billEntryId.equals(entry.getString("reservationBillObjectId"))) continue;
            list.add(entry.getString("reservationBillObjectId"));
        }
        String billId = model.get("id").toString();
        ObjectUuidPK billPK = new ObjectUuidPK(billId);
        model = iDynamicObject.getValue(billPK.getObjectType(), (IObjectPK)billPK);
        return list;
    }

    public static List<String> getBillReservationList(Context ctx, IObjectValue model) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return list;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return list;
        }
        IObjectValue entry = null;
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            if (entry == null || entry.get("id") == null) continue;
            if (entry.get("reservationBillObjectId") == null) {
                String billEntryId = entry.get("id").toString();
                ObjectUuidPK billEntryPK = new ObjectUuidPK(billEntryId);
                try {
                    entry = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (entry == null || entry.get("reservationBillObjectId") == null) continue;
            list.add(entry.get("reservationBillObjectId").toString());
        }
        return list;
    }

    public static List<String> getBillReservationList(Context ctx, IObjectValue model, List<IObjectValue> entryList) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return list;
        }
        IObjectCollection entries = null;
        List<Object> endList = new ArrayList();
        if (CollectionUtil.isEmpty(entryList)) {
            entries = (IObjectCollection)model.get("entry");
            if (entries == null) {
                entries = (IObjectCollection)model.get("entries");
            }
            if (entries == null) {
                String entryPropertyName = "";
                EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
                entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
                entries = (IObjectCollection)model.get(entryPropertyName);
            }
            if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    endList.add(entries.getObject(i));
                }
            }
        } else {
            endList = entryList;
        }
        if (CollectionUtil.isEmpty(endList)) {
            return list;
        }
        IObjectValue entry = null;
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        int size = endList.size();
        for (int i = 0; i < size; ++i) {
            entry = (IObjectValue)endList.get(i);
            if (entry == null || entry.get("id") == null) continue;
            if (entry.get("reservationBillObjectId") == null) {
                String billEntryId = entry.get("id").toString();
                ObjectUuidPK billEntryPK = new ObjectUuidPK(billEntryId);
                try {
                    entry = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (entry == null || entry.get("reservationBillObjectId") == null) continue;
            list.add(entry.get("reservationBillObjectId").toString());
        }
        return list;
    }

    public static void succeedSourceBillReservationInfo(Context ctx, IObjectValue model) throws BOSException {
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        String scmSrcBillEntryIdFieldName = "sourceBillEntryId";
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return;
        }
        IObjectValue entry = null;
        IObjectValue srcBillEntry = null;
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            String srcBillEntryId;
            ObjectUuidPK srcBillEntryPK;
            entry = entries.getObject(i);
            if (entry == null || entry.get("sourceBillEntryId") == null || (srcBillEntryPK = new ObjectUuidPK(srcBillEntryId = entry.get("sourceBillEntryId").toString())) != null && srcBillEntryPK.getObjectType() != null && srcBillEntryPK.getObjectType().toString().equals(entry.getBOSType().toString()) || entry.get("reservationBillObjectId") != null) continue;
            try {
                srcBillEntry = iDynamicObject.getValue(srcBillEntryPK.getObjectType(), (IObjectPK)srcBillEntryPK);
                entry.put("reservationBillObjectId", (Object)srcBillEntry.getString("reservationBillObjectId"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getMaterialPrecision(Context ctx, MaterialInfo materialInfo) {
        materialInfo.getBaseUnit();
        materialInfo.getAssistUnit();
    }

    public static BigDecimal getUnitQty(Context ctx, BigDecimal fromQty, String materialID, String fromUnitID, String toUnitID) throws BOSException, EASBizException {
        BigDecimal zero = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal one = NumericUtil.BIGDECIMAL_ONE;
        if (fromQty == null || fromQty.compareTo(zero) == 0 || StringUtil.isEmpty((String)materialID) || StringUtil.isEmpty((String)fromUnitID) || StringUtil.isEmpty((String)toUnitID)) {
            return zero;
        }
        IMultiMeasureUnit immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo fromMmu = immu.getMultiUnit(materialID, fromUnitID);
        MultiMeasureUnitInfo toMmu = immu.getMultiUnit(materialID, toUnitID);
        if (fromMmu == null || toMmu == null) {
            return zero;
        }
        BigDecimal fromRate = fromMmu.getBaseConvsRate();
        BigDecimal toRate = toMmu.getBaseConvsRate();
        if (fromRate == null) {
            fromRate = one;
        }
        if (toRate == null) {
            toRate = one;
        }
        return fromQty.multiply(fromRate).divide(toRate, toMmu.getQtyPrecision(), 4);
    }

    public static BigDecimal getMultiMeasureConvsRate(Context ctx, String materialID, String fromUnitID, String toUnitID) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal(0.0);
        BigDecimal one = new BigDecimal(1.0);
        if (StringUtil.isEmpty((String)materialID) || StringUtil.isEmpty((String)fromUnitID) || StringUtil.isEmpty((String)toUnitID)) {
            return zero;
        }
        IMultiMeasureUnit immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo fromMmu = immu.getMultiUnit(materialID, fromUnitID);
        MultiMeasureUnitInfo toMmu = immu.getMultiUnit(materialID, toUnitID);
        if (fromMmu == null || toMmu == null) {
            return zero;
        }
        BigDecimal fromRate = fromMmu.getBaseConvsRate();
        BigDecimal toRate = toMmu.getBaseConvsRate();
        if (fromRate == null) {
            fromRate = one;
        }
        if (toRate == null) {
            toRate = one;
        }
        return fromRate.divide(toRate);
    }

    public static BigDecimal getConvsPrice(Context ctx, String materialID, String fromUnitID, String toUnitID, BigDecimal fromPrice, int pricePrecision) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal(0.0);
        BigDecimal one = new BigDecimal(1.0);
        if (StringUtil.isEmpty((String)materialID) || StringUtil.isEmpty((String)fromUnitID) || StringUtil.isEmpty((String)toUnitID)) {
            return zero;
        }
        IMultiMeasureUnit immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo fromMmu = immu.getMultiUnit(materialID, fromUnitID);
        MultiMeasureUnitInfo toMmu = immu.getMultiUnit(materialID, toUnitID);
        if (fromMmu == null || toMmu == null) {
            return zero;
        }
        BigDecimal fromRate = fromMmu.getBaseConvsRate();
        BigDecimal toRate = toMmu.getBaseConvsRate();
        if (fromRate == null) {
            fromRate = one;
        }
        if (toRate == null) {
            toRate = one;
        }
        return fromPrice.multiply(toRate).divide(fromRate, pricePrecision, 4);
    }

    public static List<String> getSelectEntryIDSet(KDTable tblMain, String entryIdColunmName) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        if (tblMain == null || tblMain.getSelectManager() == null || StringUtil.isEmpty((String)entryIdColunmName)) {
            return list;
        }
        if (tblMain.getColumn(entryIdColunmName) == null) {
            return list;
        }
        int size = tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            IRow row = null;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = tblMain.getRow(i);
                if (StringUtil.isEmpty((String)row.getCell(entryIdColunmName).getValue().toString())) continue;
                list.add(row.getCell(entryIdColunmName).getValue().toString());
            }
        }
        return list;
    }

    public static List<IObjectValue> getSelectEntryCollection(KDTable tblMain) throws BOSException, EASBizException {
        ArrayList<IObjectValue> entries = new ArrayList<IObjectValue>();
        if (tblMain == null || tblMain.getSelectManager() == null) {
            return entries;
        }
        int size = tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            IRow row = null;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = tblMain.getRow(i);
                if (row.getUserObject() == null) continue;
                entries.add((IObjectValue)row.getUserObject());
            }
        }
        return entries;
    }

    public void invokeBillEditReservation(IObjectValue model) {
        String className = "com.kingdee.eas.scm.im.reservation.service.BillEditReservationService";
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = Class.forName("com.kingdee.eas.scm.im.reservation.service.BillEditReservationService");
            constructor = clazz.getConstructor(new Class[0]);
            Object billEditReservationService = constructor.newInstance(new Object[0]);
            Method brMethod = clazz.getDeclaredMethod("doBillEditReservation", IObjectValue.class);
            Method o2bMethod = clazz.getDeclaredMethod("object2BillReservation", IObjectValue.class);
            Method b2bMethod = clazz.getDeclaredMethod("bill2BillReservation", IObjectValue.class);
            brMethod.invoke(billEditReservationService, model);
            o2bMethod.invoke(billEditReservationService, model);
            b2bMethod.invoke(billEditReservationService, model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IObjectCollection getBillReservationSchema(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        String billBosType = model.getBOSType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)billBosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        String cuId = ReservationUtil.getCuByModel(ctx, model);
        if (cuId != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        return iDynamicObject.getCollection(BOSObjectType.create((String)"8D307D69"), view);
    }

    public static void showReservationMessageBar(KDLabel lblMsg, String msg) {
        Color SHOW_MESSAGE_BG_OK;
        Icon SHOW_MESSAGE_ICON_OK;
        final KDLabel barLabel = lblMsg;
        Color SHOW_MESSAGE_FG_DEFAULT = new Color(255, 246, 0);
        barLabel.setForeground(SHOW_MESSAGE_FG_DEFAULT);
        Icon icon = SHOW_MESSAGE_ICON_OK = EASResource.getIcon((String)"imgState_cue_1");
        final Color bg = SHOW_MESSAGE_BG_OK = new Color(15, 136, 40);
        String message = msg;
        final String nextMessage = null;
        if (icon != null) {
            barLabel.setIcon(icon);
        }
        if (message != null && message.length() > 0) {
            barLabel.setText(message);
        } else {
            barLabel.setText(nextMessage);
        }
        if (bg != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 1; ++i) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setBackground(bg);
                                    barLabel.setOpaque(true);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(1000L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setOpaque(false);
                                    barLabel.repaint();
                                }
                            });
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        if (nextMessage == null || nextMessage.length() == 0) {
                            barLabel.setIcon(null);
                        }
                        barLabel.setText(nextMessage);
                        barLabel.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)e);
                    }
                }
            }).start();
        }
    }

    public static boolean removeHasCompleteReservationRow(KDTable table, String columnName) {
        if (table == null || StringUtil.isEmpty((String)columnName) || table.getColumn(columnName) == null) {
            return false;
        }
        int moveCount = 0;
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            IRow row = table.getRow(i);
            if (row.getCell(columnName).getValue() == null) {
                table.remove(i);
                ++moveCount;
                continue;
            }
            BigDecimal value = (BigDecimal)row.getCell(columnName).getValue();
            if (value.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) continue;
            table.removeRow(i);
            ++moveCount;
        }
        return moveCount > 0;
    }

    public static ReservationExInfo getReservationExInfo(Context ctx, String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        ReservationExInfo reservationExInfo = null;
        if (reservationExMap.containsKey(id)) {
            reservationExInfo = reservationExMap.get(id);
        } else {
            try {
                IReservationEx iResEx = ctx != null ? ReservationExFactory.getLocalInstance(ctx) : ReservationExFactory.getRemoteInstance();
                reservationExInfo = iResEx.getReservationExInfo((IObjectPK)new ObjectUuidPK(id));
                if (reservationExInfo != null) {
                    reservationExMap.put(id, reservationExInfo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reservationExInfo;
    }

    public static void matchReservationEx(Context ctx, ReservationInfo reservationInfo, ReservationSchemaInfo reservationSchemaInfo, IObjectValue srcBillModel, IObjectValue srcEntryModel) {
        if (reservationInfo == null || reservationSchemaInfo == null || StringUtil.isEmpty((String)reservationSchemaInfo.getReservationEx())) {
            return;
        }
        if (srcBillModel == null && srcEntryModel == null) {
            return;
        }
        String id = reservationSchemaInfo.getReservationEx();
        ReservationExInfo reservationExInfo = null;
        try {
            reservationExInfo = ReservationUtil.getReservationExInfo(ctx, id);
            if (reservationExInfo == null || UseStatusEnum.ACTIVE != reservationExInfo.getState()) {
                return;
            }
            ReservationExEntryCollection col = reservationExInfo.getEntry();
            if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                return;
            }
            ReservationExEntryInfo reservationExEntryInfo = null;
            String fieldName = "";
            String billFieldName = "";
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reservationExEntryInfo = col.get(i);
                fieldName = reservationExEntryInfo.getFieldName();
                billFieldName = reservationExEntryInfo.getBillFieldName();
                if (srcBillModel.get(billFieldName) != null) {
                    reservationInfo.put(fieldName, srcBillModel.get(billFieldName));
                    continue;
                }
                String entryField = billFieldName.substring(billFieldName.indexOf(SPLITMARK) + 1);
                if (srcEntryModel.get(entryField) == null) continue;
                reservationInfo.put(fieldName, srcEntryModel.get(entryField));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

