/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.app.AbstractInOutStoreGatherReportFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.util.RptParamSqlUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InOutStoreGatherReportFacadeControllerBean
extends AbstractInOutStoreGatherReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    public static final String NEWLINE = "\t\n";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.InOutStoreGatherReportFacadeControllerBean");
    private String orgTempTableStr = "orgTempTable";
    private String leafStorageOrgUnitStr = "leafStorageOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private String resMapStr = "resMap";
    private String loc = "L2";
    private String[][] invTableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}};
    private int maxIndex = 2;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        Boolean ckBxShowsumRow;
        CacheFields cacheFields = new CacheFields();
        this.getPerm(ctx, cacheFields, params);
        this.loc = this.getLoc(ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString(this.orgTempTableStr), ctx);
        String tempTable_Temp = null;
        String tempTable = null;
        String orgTempTable = null;
        params.setObject("idList", null);
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        HashMap<String, String> resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, resMap);
        this.initRITypeColName(ctx, params, cacheFields);
        long lstart = 0L;
        long begin = 0L;
        long lstop = 0L;
        logger.info((Object)"==============================================");
        logger.info((Object)"########### buildStorageOrgTable start ");
        lstart = System.currentTimeMillis();
        orgTempTable = this.createTempTable(ctx, this.buildStorageOrgTable(ctx, orgTempTable, params));
        params.setString(this.orgTempTableStr, orgTempTable);
        this.insertDataToStorageOrgTable(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### buildStorageOrgTable end : " + (lstop - lstart)));
        logger.info((Object)"########### CreateTempTable start ");
        lstart = System.currentTimeMillis();
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params, cacheFields));
        params.setString("tempTable", tempTable);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### CreateTempTable end : " + (lstop - lstart)));
        logger.info((Object)"########### CreateTempTable_temp start ");
        lstart = System.currentTimeMillis();
        tempTable_Temp = this.createTempTable(ctx, this.getCreateTempTable(tempTable_Temp, params, cacheFields));
        params.setString("tempTable_Temp", tempTable_Temp);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### CreateTempTable_temp end : " + (lstop - lstart)));
        String gatherTempTable = null;
        String detailTempTable = null;
        try {
            detailTempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable_Temp, params, cacheFields));
            if (!ckBxOnlyShowDetail.booleanValue()) {
                gatherTempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable_Temp, params, cacheFields));
                TempTablePool.getInstance((Context)ctx).createIndex(gatherTempTable, "KSQL_SEQ", false, false);
            }
            TempTablePool.getInstance((Context)ctx).createIndex(detailTempTable, "KSQL_SEQ", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"########### CreateTempTable_temp start ");
        lstart = System.currentTimeMillis();
        this.updateStorageOrgBeingDate(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### updateStorageOrgBeingDate end : " + (lstop - lstart)));
        logger.info((Object)"########### insertBillDateToTempTable NOMaterializedView start ");
        lstart = System.currentTimeMillis();
        this.insertBillDateToTempTable(ctx, orgTempTable, params, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertBillDateToTempTable NOMaterializedView end: " + (lstop - lstart)));
        logger.info((Object)"########### updateNoAmtPermssion start ");
        lstart = System.currentTimeMillis();
        this.updateNoAmtPermssion(ctx, params, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### updateNoAmtPermssion end : " + (lstop - lstart)));
        logger.info((Object)"########### groupTempTable start ");
        lstart = System.currentTimeMillis();
        this.groupTempTable(ctx, orgTempTable, params, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### groupTempTable end : " + (lstop - lstart)));
        if (!ckBxOnlyShowDetail.booleanValue()) {
            logger.info((Object)"########### levelTempTable start ");
            lstart = System.currentTimeMillis();
            this.levelTempTable(ctx, orgTempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### levelTempTable end : " + (lstop - lstart)));
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateEnd(ctx, tempTable, params, 0, cacheFields);
            this.updateEnd(ctx, tempTable, params, 1, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
            logger.info((Object)"########### deleteNoInOut start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.deleteNoInOut(ctx, tempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### deleteNoInOut end : " + (lstop - lstart)));
            logger.info((Object)"########### levelTempTableGroup start ");
            lstart = System.currentTimeMillis();
            this.levelTempTableGroup(ctx, orgTempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### levelTempTableGroup end : " + (lstop - lstart)));
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            for (int index = 2; index <= this.maxIndex; ++index) {
                this.updateEnd(ctx, tempTable, params, index, cacheFields);
            }
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
        } else {
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateEnd(ctx, tempTable, params, -10, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
            logger.info((Object)"########### deleteNoInOut start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.deleteNoInOut(ctx, tempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### deleteNoInOut end : " + (lstop - lstart)));
        }
        if (!ckBoxLevelGather.booleanValue() && ckBxByStatUnit.booleanValue()) {
            logger.info((Object)"########### updateStatUnit start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateStatUnit(ctx, tempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateStatUnit end : " + (lstop - lstart)));
        }
        logger.info((Object)"########### insertNeedInfo start ");
        lstart = System.currentTimeMillis();
        this.insertNeedInfo(ctx, orgTempTable, params, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertNeedInfo end: " + (lstop - lstart)));
        logger.info((Object)"########### finalUpdateTempTable start ");
        lstart = System.currentTimeMillis();
        this.finalUpdateTempTable(ctx, orgTempTable, params, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### finalUpdateTempTable end : " + (lstop - lstart)));
        Boolean ckBoxShowGatherLine = (Boolean)params.getObject("ckBoxShowGatherLine");
        if (ckBoxShowGatherLine.booleanValue()) {
            logger.info((Object)"########### viewTotalLine start ");
            lstart = System.currentTimeMillis();
            this.viewTotalLine(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### viewTotalLine end : " + (lstop - lstart)));
        }
        if ((ckBxShowsumRow = (Boolean)params.getObject("ckBxShowsumRow")).booleanValue()) {
            logger.info((Object)"########### addsumRow start ");
            lstart = System.currentTimeMillis();
            this.addsumRow(ctx, orgTempTable, params, cacheFields);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### addsumRow end : " + (lstop - lstart)));
        }
        StringBuffer countSql = new StringBuffer();
        tempTable = params.getString("tempTable");
        countSql.append("select count(1) cc from ").append(tempTable).append("  where flevel = 1");
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        this.copyToNewTempTable(ctx, detailTempTable, tempTable, params, cacheFields, 1);
        if (!ckBxOnlyShowDetail.booleanValue()) {
            this.copyToNewTempTable(ctx, gatherTempTable, tempTable, params, cacheFields, 0);
        }
        RptTableHeader header = this.getReportHeader(params, cacheFields);
        RptParams result = new RptParams();
        if (!ckBxOnlyShowDetail.booleanValue()) {
            result.setString("tempTable", gatherTempTable);
            result.setString("detailTempTable", detailTempTable);
        } else {
            result.setString("tempTable", detailTempTable);
        }
        this.dropTempTable(ctx, tempTable);
        result.setString(this.orgTempTableStr, orgTempTable);
        result.setInt("totalCount", count);
        result.setObject("header", (Object)header);
        result.setObject("riTypeColMap", (Object)cacheFields.riTypeColMap);
        result.setObject("queryHeader", (Object)this.buildQueryHead(ctx, params, cacheFields));
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### total time: " + (lstop - begin)));
        return result;
    }

    private void copyToNewTempTable(Context ctx, String newTempTable, String tempTable, RptParams params, CacheFields cacheFields, int isDetailTable) throws BOSException, EASBizException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(newTempTable).append("(");
        sb.append(this.getSelects(cacheFields, true));
        sb.append(")");
        sb.append(" select ");
        sb.append(this.getSelects(cacheFields, false));
        sb.append(" from ").append(tempTable);
        sb.append(" where  1 = 1");
        if (isDetailTable == 0 || ckBxOnlyShowDetail.booleanValue()) {
            sb.append(" and flevel = 1");
        } else {
            sb.append(" and flevel <> 1");
        }
        if (ckBxOnlyShowDetail.booleanValue()) {
            sb.append(" order by Findex");
        } else {
            sb.append(" order by Findex desc");
        }
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            sb.append(",FMaterialCostType");
        } else {
            sb.append(",FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FAssistProperty,FProjectNumber,FTrackNumber,FId ");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSelects(CacheFields cacheFields, boolean hasKsqlSeq) {
        StringBuffer sb = new StringBuffer();
        if (hasKsqlSeq) {
            sb.append("KSQL_SEQ,");
        }
        sb.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,FLot,FAssistPropertyID,FOriBeginQty,");
        int len = cacheFields.riColName.length;
        for (int i = 0; i < len; ++i) {
            sb.append(cacheFields.riColName[i]).append(",");
        }
        sb.append("FMaterialGroupName,FMaterialGroupNumber,FMaterialNumber,FMaterialName,FShortName,FMaterialSize,FAssistProperty,FBaseUnit,FAssistUnit,FStorageOrgName,FWarehouseName,");
        sb.append("FWarehouseNumber,FLocationName,flevel,fisleaf,fparentid,FMaterialGroupID,FMaterialCostType,FMaterialCostTypeName,FBlockID,FStatUnitID,FisfinalData,FProjectID,");
        sb.append("FTrackNumberID,FProjectNumber,FProjectName,FTrackNumber,FTrackName");
        return sb.toString();
    }

    private Map buildQueryHead(Context ctx, RptParams params, CacheFields cacheFields) {
        HashMap<String, Boolean> queryHeader = new HashMap<String, Boolean>();
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        queryHeader.put("FShortName", ckBxShowMShortName);
        queryHeader.put("FAssistProperty", ckBxShowAsstAttr);
        queryHeader.put("FWarehouseName", ckBxShowWhs);
        queryHeader.put("FLocationName", ckBxShowLocation);
        queryHeader.put("FLot", ckBxShowLot);
        queryHeader.put("FProjectNumber", ckBxShowProject);
        queryHeader.put("FProjectName", ckBxShowProject);
        queryHeader.put("FTrackNumber", ckBxShowTrackNum);
        queryHeader.put("FTrackName", ckBxShowTrackNum);
        for (int i = 0; i < cacheFields.riColHeaderName.length; ++i) {
            queryHeader.put(cacheFields.riColHeaderName[i], this.isShow(params, cacheFields.riColHeaderName[i], cacheFields));
        }
        return queryHeader;
    }

    private void getPerm(Context ctx, CacheFields cacheFields, RptParams params) throws BOSException, EASBizException {
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inoutstoregatherreport_view");
        Object[] storageOrg = (Object[])params.getObject("fullStorageOrgUnit");
        Set orgUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, storageOrg);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"bd_material_view", (String)"m", (String)"h");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"warehous_view", (String)"wh", (String)"h");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            cacheFields.hMatPermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
            cacheFields.matpermSql = (String)matpermRuleMap.get("PERM_WHERE");
            if (!StringUtil.isEmpty((String)cacheFields.matpermSql)) {
                cacheFields.matpermSql = " AND (" + cacheFields.matpermSql + ") ";
            }
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            cacheFields.hWarePermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
            cacheFields.warepermSql = (String)warepermRuleMap.get("PERM_WHERE");
            if (!StringUtil.isEmpty((String)cacheFields.warepermSql)) {
                cacheFields.warepermSql = " AND (" + cacheFields.warepermSql + ") ";
            }
        }
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    private String buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table TempReportTable (");
        sql.append("fid varchar(44) not null  primary key ,");
        sql.append("fname_" + this.loc + "  nvarchar(255),");
        sql.append("fparentid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int,");
        sql.append("fbegindate datetime,");
        sql.append("fbeginyear int,");
        sql.append("fbeginperiod int ");
        sql.append(")");
        return sql.toString();
    }

    private void insertDataToStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            Set authorizedStorageOrgUnit = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inoutstoregatherreport_view");
            Set author = InvServerUtils.getSelAuthorUnit(authorizedStorageOrgUnit, (Object[])params.getObject("fullStorageOrgUnit"));
            Object[] storageOrg = author.toArray();
            String orgSql = "insert into " + orgTempTable + "(fid,fname_" + this.loc + " ,fparentid,flevel,fisleaf,fbegindate,fbeginyear,fbeginperiod) values(?,?,?,?,?,to_date('1999-01-01'),?,?)";
            ps = con.prepareStatement(orgSql);
            if (storageOrg != null) {
                long start = System.currentTimeMillis();
                logger.info((Object)"########### insert into buildStorageOrgTable start ");
                int n = storageOrg.length;
                for (int i = 0; i < n; ++i) {
                    Integer fisleaf;
                    String fid = ((OrgUnitInfo)storageOrg[i]).get("id").toString();
                    Integer flevel = (Integer)((OrgUnitInfo)storageOrg[i]).get("level");
                    String fname = (String)((OrgUnitInfo)storageOrg[i]).get("name");
                    OrgUnitInfo parent = (OrgUnitInfo)((OrgUnitInfo)storageOrg[i]).get("parent");
                    Integer n2 = fisleaf = ((OrgUnitInfo)storageOrg[i]).isIsLeaf() ? new Integer("1") : new Integer("0");
                    if (fisleaf == 1) {
                        v.add(fid);
                    }
                    if (flevel > maxLevel) {
                        maxLevel = flevel;
                    }
                    String fparentid = parent == null ? null : parent.getId().toString();
                    ps.setString(1, fid);
                    ps.setString(2, fname);
                    ps.setString(3, fparentid);
                    ps.setInt(4, flevel);
                    ps.setInt(5, fisleaf);
                    ps.setInt(6, 1999);
                    ps.setInt(7, 1);
                    ps.addBatch();
                }
                ps.executeBatch();
                long end = System.currentTimeMillis();
                logger.info((Object)("########### insert into buildStorageOrgTable end " + (end - start)));
            }
            params.setObject(this.leafStorageOrgUnitStr, (Object)v.toArray());
            params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
        }
        catch (Exception e) {
            try {
                throw new BOSException("sqlBatch execute exception : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
        this.close(con, ps);
    }

    private void updateStorageOrgBeingDate(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        Date dateFrom = (Date)params.getObject("dateFrom");
        PeriodInfo periodInfo = IMRptUtils.getPeriodInfo(ctx, dateFrom, this.getPeriodTypeId(ctx, orgTempTable));
        if (periodInfo == null) {
            periodInfo = IMRptUtils.getPeriodInfo(ctx, dateFrom);
        }
        if (periodInfo == null) {
            return;
        }
        String periodBegin = IMRptUtils.getFilterBeginDate(periodInfo.getBeginDate());
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(orgTempTable).append(" as t set(fid,fbegindate,fbeginyear,fbeginperiod) = (");
        sql.append("select a.fid,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fbegindate ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fbegindate ").append("else to_date('").append(periodBegin).append("') end as fbegindate,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodyear ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodyear ").append("else ").append(periodInfo.getPeriodYear()).append(" end as fbeginyear,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodnumber ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodnumber ").append("else ").append(periodInfo.getPeriodNumber()).append(" end as fbegindate ").append("from ").append(orgTempTable).append(" a ").append("inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid ").append("inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID ").append("inner join t_org_company d on  b.ftounitid = d.fid ").append("inner join T_BD_SystemStatusCtrol e on e.FCompanyID = d.fid ").append("inner join T_BD_SystemStatus f on e.FSystemStatusID = f.fid ").append("inner join t_bd_period g on e.fstartperiodid = g.fid ").append("inner join t_bd_period h on e.fcurrentperiodid = h.fid ").append("where ").append("c.FFromType = ").append(4).append(" ").append("and c.FToType = ").append(1).append(" ").append("and  f.fname = ").append(2).append(" ");
        sql.append("and t.fid = a.fid )");
        this.executeSQL(ctx, sql.toString());
    }

    private String getCreateTempTable(String tempTable, RptParams params, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("KSQL_SEQ INT IDENTITY(1,1),");
        sql.append("FID Varchar(44),");
        sql.append("FIndex int default 0,");
        sql.append("FCompanyOrgUnitID Varchar(44),");
        sql.append("FStorageOrgUnitID Varchar(44),");
        sql.append("FWarehouseID Varchar(44),");
        sql.append("FLocationID Varchar(44),");
        sql.append("FMaterialID Varchar(44),");
        sql.append("FLot nvarchar(1000),");
        sql.append("FAssistPropertyID Varchar(44),");
        sql.append("FOriBeginQty Decimal(28,10) not null default 0,");
        int len = cacheFields.riColName.length;
        for (int i = 0; i < len; ++i) {
            sql.append(cacheFields.riColName[i]).append(" Decimal(28,10) not null default 0,");
        }
        sql.append("FMaterialGroupName nvarchar(255),");
        sql.append("FMaterialGroupNumber nvarchar(255),");
        sql.append("FMaterialNumber nvarchar(255),");
        sql.append("FMaterialName nvarchar(255),");
        sql.append("FShortName nvarchar(255),");
        sql.append("FMaterialSize nvarchar(255),");
        sql.append("FAssistProperty nvarchar(1000),");
        sql.append("FBaseUnit nvarchar(255),");
        sql.append("FAssistUnit nvarchar(255),");
        sql.append("FStorageOrgName nvarchar(255),");
        sql.append("FWarehouseName nvarchar(255),");
        sql.append("FWarehouseNumber nvarchar(255),");
        sql.append("FLocationName nvarchar(255),");
        sql.append("flevel int,");
        sql.append("fisleaf int,");
        sql.append("fparentid varchar(44),");
        sql.append("FMaterialGroupID varchar(44),");
        sql.append("FMaterialCostType char(2),");
        sql.append("FMaterialCostTypeName varchar(44),");
        sql.append("FBlockID varchar(44),");
        sql.append("FStatUnitID varchar(44),");
        sql.append("FisfinalData int default 0");
        sql.append(",FProjectID varchar(44)");
        sql.append(",FTrackNumberID varchar(44)");
        sql.append(",FProjectNumber nvarchar(80)");
        sql.append(",FProjectName nvarchar(255)");
        sql.append(",FTrackNumber nvarchar(80)");
        sql.append(",FTrackName nvarchar(255)");
        sql.append(");");
        return sql.toString();
    }

    private void updateNoAmtPermssion(Context ctx, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        Vector orgVct = (Vector)params.getObject("amtPermssionOrg");
        sql.append("update ").append(tempTable).append(" ").append("set ").append("FBeginAmt =0,FCostAdjInAmt=0,FCostAdjOutAmt=0,FMoveInAmt=0,FMoveOutAmt=0 ");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            sql.append(",").append(cacheFields.riColName[i + 3]).append("=0");
        }
        sql.append(" where fstorageorgunitid in (");
        if (orgVct != null && orgVct.size() > 0) {
            Object[] orgIDs = orgVct.toArray();
            for (int i = 0; i < orgIDs.length; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'").append(orgIDs[i]).append("'");
            }
        }
        sql.append(")");
        if (orgVct != null && orgVct.size() > 0) {
            this.executeSQL(ctx, sql.toString());
        }
    }

    private void groupTempTable(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        sql.append(this.getInsertFiledsSql(params, true, cacheFields)).append(" ").append("select ").append("newbosid('88888888'),0 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,");
        if (ckBxShowWhs.booleanValue()) {
            sql.append(" FWarehouseID,  ");
        } else {
            sql.append(" '1',  ");
        }
        if (ckBxShowLocation.booleanValue()) {
            sql.append(" FLocationID,  ");
        } else {
            sql.append(" '1',  ");
        }
        sql.append(" FMaterialID,");
        if (ckBxShowLot.booleanValue()) {
            sql.append(" FLot,  ");
        } else {
            sql.append(" '1', ");
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            sql.append(" FAssistPropertyID,  ");
        } else {
            sql.append(" '1', ");
        }
        if (ckBxShowProject.booleanValue()) {
            sql.append("FProjectID,");
        } else {
            sql.append("'1',");
        }
        if (ckBxShowTrackNum.booleanValue()) {
            sql.append("FTrackNumberID,");
        } else {
            sql.append("'1',");
        }
        sql.append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" ").append("group by ").append("FCompanyOrgUnitID,FStorageOrgUnitID ");
        sql.append(",FMaterialID");
        if (ckBxShowWhs.booleanValue()) {
            sql.append(" ,FWarehouseID  ");
        }
        if (ckBxShowLocation.booleanValue()) {
            sql.append(" ,FLocationID  ");
        }
        if (ckBxShowLot.booleanValue()) {
            sql.append(" ,FLot  ");
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            sql.append(" ,FAssistPropertyID ");
        }
        if (ckBxShowProject.booleanValue()) {
            sql.append(" ,FProjectID  ");
        }
        if (ckBxShowTrackNum.booleanValue()) {
            sql.append(" ,FTrackNumberID  ");
        }
        tempTable = (String)params.getObject("tempTable");
        String tempTable_temp = (String)params.getObject("tempTable_Temp");
        String sqlTrunc = " TRUNCATE TABLE " + tempTable + " ;";
        sql.append(";");
        sql.append(sqlTrunc);
        super.executeBatchUpdate(ctx, sql.toString().split(";"));
        params.setString("tempTable", tempTable_temp);
        params.setString("tempTable_Temp", tempTable);
    }

    private void exchangeTemptable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = (String)params.getObject("tempTable");
        String tempTable_temp = (String)params.getObject("tempTable_Temp");
        String sqlTrunc = " TRUNCATE TABLE " + tempTable + " ;";
        this.executeUpdate(sqlTrunc, null, ctx);
        params.setString("tempTable", tempTable_temp);
        params.setString("tempTable_Temp", tempTable);
    }

    private void updateStatUnit(Context ctx, String tempTable, RptParams params, CacheFields cacheFields) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTable).append(" set FOriBeginQty = FBeginQty ");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" set (FStatUnitID,").append("FBeginQty,FriInQty,FriOutQty,FEndQty,").append("FMoveInQty,FMoveOutQty,");
        sql.append("FStateAdjustInQty,FStateAdjustOutQty,FDecomposeInQty,FDecomposeOutQty");
        String bizRISQL = this.getBizRITypeSQL(null, true, false, false, false, cacheFields);
        if (bizRISQL != null) {
            sql.append(",").append(bizRISQL);
        }
        sql.append(") = (select fmeasureunitid,").append("round(decimal(FBeginQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FriInQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FriOutQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FEndQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision) ,").append("round(decimal(FMoveInQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision), ").append("round(decimal(FMoveOutQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FStateAdjustInQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FStateAdjustOutQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FDecomposeInQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FDecomposeOutQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision)");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            sql.append(", round(decimal(").append(cacheFields.riColName[i]).append(",21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision)");
        }
        sql.append(" from t_bd_multimeasureunit mm ").append("where ").append(tempTable).append(".fmaterialid = mm.fmaterialid and mm.fisstatunit = 1 ").append(")");
        this.executeSQL(ctx, sql.toString());
    }

    private void groupTempTableForWhsLot(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        String tempTable = params.getString("tempTable");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        StringBuffer sql = new StringBuffer();
        if (ckBxShowWhs.booleanValue() && ckBxShowLocation.booleanValue() && ckBxShowLot.booleanValue() && ckBxShowAsstAttr.booleanValue() && ckBxShowProject.booleanValue() && ckBxShowTrackNum.booleanValue() || !ckBxShowWhs.booleanValue() && !ckBxShowLocation.booleanValue() && !ckBxShowLot.booleanValue() && !ckBxShowAsstAttr.booleanValue() && !ckBxShowProject.booleanValue() && !ckBxShowTrackNum.booleanValue()) {
            sql.append("update ").append(tempTable).append(" set FIndex = 0");
            this.executeSQL(ctx, sql.toString());
        } else {
            sql.append(this.getInsertFiledsSql(params, cacheFields)).append(" ").append("select ").append("newbosid('88888888'),0 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,").append(ckBxShowWhs != false ? "" : " null as ").append("FWarehouseID,").append(ckBxShowLocation != false ? "" : " null as ").append("FLocationID,").append("FMaterialID,").append(ckBxShowLot != false ? "" : "null as ").append("FLot,").append(ckBxShowAsstAttr != false ? "" : "null as ").append("FAssistPropertyID,").append(ckBxShowProject != false ? "" : "null as ").append("FProjectID,").append(ckBxShowTrackNum != false ? "" : "null as ").append("FTrackNumberID,").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" ").append("group by ").append("FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID").append(ckBxShowWhs != false ? ",FWarehouseID" : "").append(ckBxShowLocation != false ? ",FLocationID" : "").append(ckBxShowLot != false ? ",FLot" : "").append(ckBxShowAsstAttr != false ? ",FAssistPropertyID" : "").append(ckBxShowProject != false ? ",FProjectID" : "").append(ckBxShowTrackNum != false ? ",FTrackNumberID" : "");
            String sqlDel = "delete from " + tempTable + " where Findex = -1 ";
            sql.append(";");
            sql.append(sqlDel);
            super.executeBatchUpdate(ctx, sql.toString().split(";"));
        }
    }

    private void levelTempTable(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        this.levelToStorageOrg(ctx, orgTempTable, params, cacheFields);
    }

    protected void levelTempTableGroup(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws EASBizException, BOSException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        if (ckBoxLevelGather.booleanValue()) {
            this.updateNeedInfo(ctx, orgTempTable, params);
            if (ckBxByStatUnit.booleanValue()) {
                this.updateStatUnit(ctx, params.getString("tempTable"), params, cacheFields);
            }
            this.levelToRootOrg(ctx, orgTempTable, params, cacheFields);
            if (coBoxGatherCondition == 0) {
                this.levelByMaterialGroup(ctx, orgTempTable, params, cacheFields);
            }
        } else {
            this.levelByStorageOrg(ctx, orgTempTable, params, cacheFields);
        }
    }

    private void levelToStorageOrg(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        boolean isUseTempTable_temp = false;
        if (!(ckBxShowWhs.booleanValue() || ckBxShowLocation.booleanValue() || ckBxShowLot.booleanValue() || ckBxShowAsstAttr.booleanValue() || ckBxShowProject.booleanValue() || ckBxShowTrackNum.booleanValue())) {
            isUseTempTable_temp = true;
        }
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append(this.getInsertFiledsSql(params, isUseTempTable_temp, cacheFields));
        sql.append("select ").append("newbosid('88888888'),1 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,FMaterialID,null as FLot,null as FAssistPropertyID,").append("null as FProjectID,null as FTrackNumberID,").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" ").append("group by ").append("FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID ");
        this.executeSQL(ctx, sql.toString());
        if (isUseTempTable_temp) {
            String sqlDel = "delete from " + tempTable + " where Findex = 0 ";
            this.executeSQL(ctx, sqlDel);
            this.exchangeTemptable(ctx, params);
        }
    }

    private void updateNeedInfo(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        if (coBoxGatherCondition == 0) {
            sql.append("update ").append(tempTable).append(" set (fmaterialgroupid) = ").append("(select top 1 isnull(g.Fid, 'X') from t_bd_material m ").append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ").append(" left join T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID  ").append("where m.fid = ").append(tempTable).append(".fmaterialid").append(" and MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("')  ");
        } else {
            sql.append("update ").append(tempTable).append(" set (FMaterialCostType) = ").append("(select to_char(mc.FStoreType) from T_BD_MaterialCost mc ").append("where mc.fmaterialid = ").append(tempTable).append(".fmaterialid ").append("and mc.FOrgUnit = ").append(tempTable).append(".FCompanyOrgUnitID").append(")");
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void levelToRootOrg(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String storageorgid = "";
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        RptRowSet rs = this.executeQuery("select top 1 fid as fstorageorgunitid  from " + orgTempTable + " where flevel is not null order by flevel asc", null, ctx);
        if (rs.next()) {
            storageorgid = rs.getString("fstorageorgunitid");
        }
        sql.append(this.getInsertFiledsSql(params, new String[]{coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType"}, cacheFields));
        sql.append("select ").append("newbosid('88888888'),2 as Findex,null as FCompanyOrgUnitID,").append("'").append(storageorgid).append("' as FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FAssistPropertyID,").append("null as FProjectID,null as FTrackNumberID,").append(coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType").append(",").append("sum(FriInQty),sum(FriInAssQty),sum(FriInAmt),").append("sum(FriOutQty),sum(FriOutAssQty),sum(FriOutAmt),").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" ").append("where Findex <> 0 ").append("group by ").append(coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType");
        this.executeSQL(ctx, sql.toString());
    }

    private void levelByStorageOrg(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String sqle = "";
        String tempTable = params.getString("tempTable");
        int level = (Integer)params.getObject(this.maxLevelStr);
        sql.append(this.getInsertFiledsSql(params, cacheFields)).append(" ");
        sql.append("select ").append("newbosid('88888888'),2 as FIndex,null as FCompanyOrgUnitID,b.fparentid as FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,a.FMaterialID,null as FLot,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" a,").append(orgTempTable).append(" b where a.fstorageorgunitid = b.fid and  b.flevel =");
        StringBuffer sb = new StringBuffer(1024);
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " and findex <>0 group by b.fparentid,a.fmaterialid ";
            sb.append(sqle + ";");
        }
        if (sb.length() > 0) {
            super.executeBatchUpdate(ctx, sb.toString().split(";"));
        }
    }

    private void levelByMaterialGroup(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sqlReplace = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer sqltotal = new StringBuffer();
        StringBuffer sqltotal1 = new StringBuffer();
        String sqle = "";
        String sqlSum = "";
        String sqlSum1 = "";
        String tempTable = params.getString("tempTable");
        String tempTable_temp = params.getString("tempTable_Temp");
        this.maxIndex = 3;
        int level = this.getMaterialGroupMaxLevel(ctx, tempTable, params);
        params.setInt("maxMaterialGroupLevel", level);
        params.setString("tempTable", tempTable_temp);
        sqlReplace.append(this.getInsertFiledsSql(params, new String[]{"FMaterialGroupID"}, cacheFields)).append(" ");
        sqlReplace.append("select ").append("newbosid('88888888'),3 as FIndex,null as FCompanyOrgUnitID,a.FStorageOrgUnitID as FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,b.fid as FMaterialGroupID,").append("sum(FriInQty),sum(FriInAssQty),sum(FriInAmt),").append("sum(FriOutQty),sum(FriOutAssQty),sum(FriOutAmt),").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" a,").append("t_bd_materialgroup b where a.fmaterialgroupid = b.fid and  b.flevel =");
        params.setString("tempTable", tempTable);
        insertSql.append(this.getInsertFiledsSql(params, new String[]{"FMaterialGroupID"}, cacheFields)).append(" ");
        sql.append("select ").append("newbosid('88888888'),3 as FIndex,null as FCompanyOrgUnitID,a.FStorageOrgUnitID as FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,b.fparentid as FMaterialGroupID,").append("sum(FriInQty),sum(FriInAssQty),sum(FriInAmt),").append("sum(FriOutQty),sum(FriOutAssQty),sum(FriOutAmt),").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" a,").append("t_bd_materialgroup b where a.fmaterialgroupid = b.fid and  b.flevel =");
        sqltotal1.append("select ").append("newbosid('88888888'),4 as FIndex,null as FCompanyOrgUnitID,a.FStorageOrgUnitID as FStorageOrgUnitID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,a.FMaterialGroupID as FMaterialGroupID,").append("sum(FriInQty),sum(FriInAssQty),sum(FriInAmt),").append("sum(FriOutQty),sum(FriOutAssQty),sum(FriOutAmt),").append(this.getGroupFiledsSql(params, cacheFields)).append(" ").append("from ").append(tempTable).append(" a,").append("t_bd_materialgroup b where a.fmaterialgroupid = b.fid and  b.flevel =");
        sqltotal.append("select b.fparentid as FMaterialGroupID from ").append(tempTable).append(" c,").append("t_bd_materialgroup b where c.fmaterialgroupid = b.fid and  b.flevel =");
        StringBuffer sb = new StringBuffer(1024);
        for (int i = level; i > 0; --i) {
            if (1 == i) {
                sqle = sqlReplace.toString() + i + " and findex >= 2 group by b.fid,a.FStorageOrgUnitID ";
                sb.append(sqle + ";");
                continue;
            }
            sqle = insertSql.toString() + sql.toString() + i + " and findex >= 2 group by b.fparentid,a.FStorageOrgUnitID ";
            sb.append(sqle + ";");
            int j = i - 1;
            sqlSum = sqltotal.toString() + i + " and findex >= 2 group by b.fparentid,c.FStorageOrgUnitID ";
            sqlSum1 = insertSql.toString() + sqltotal1.toString() + j + " and findex >= 2 and FMaterialGroupID in(" + sqlSum + ") group by a.FMaterialGroupID,a.FStorageOrgUnitID ";
            sb.append(sqlSum1 + ";");
            sb.append("delete from ").append(tempTable).append(" where FMaterialGroupID in (" + sqlSum + ") and findex >= 2 and findex <4 ");
            sb.append(";");
        }
        sb.append("delete from ").append(tempTable).append(" where fid in (select b.fid from ").append(tempTable).append(" b, t_bd_materialgroup c  where b.fmaterialgroupid = c.fid and c.flevel = 1 and b.findex >= 2);");
        sb.append(" insert into ").append(tempTable).append(" (").append(this.getSelects(cacheFields, false)).append(")").append(" select ").append(this.getSelects(cacheFields, false)).append(" from ").append(tempTable_temp).append(" ;");
        if (sb.length() > 0) {
            super.executeBatchUpdate(ctx, sb.toString().split(";"));
        }
    }

    private String getInsertFiledsSql(RptParams params, boolean isUseTempTable_Temp, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        if (isUseTempTable_Temp) {
            tempTable = params.getString("tempTable_Temp");
        }
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,FLot,FAssistPropertyID,").append("FProjectID,FTrackNumberID,").append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FCostAdjInAmt,FCostAdjOutAmt,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,").append("FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,").append("FStateAdjustOutQty,FStateAdjustOutAssQty,").append("FDecomposeInQty,FDecomposeInAssQty,").append("FDecomposeOutQty,FDecomposeOutAssQty");
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            sql.append(",").append(bizRISQL);
        }
        sql.append(", Fendqty, FEndAssQty, FEndAmt");
        sql.append(") ");
        return sql.toString();
    }

    private String getInsertFiledsSql(RptParams params, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert /*+append*/ into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,FLot,FAssistPropertyID,").append("FProjectID,FTrackNumberID,").append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FCostAdjInAmt,FCostAdjOutAmt,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,").append("FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,").append("FStateAdjustOutQty,FStateAdjustOutAssQty,").append("FDecomposeInQty,FDecomposeInAssQty,").append("FDecomposeOutQty,FDecomposeOutAssQty");
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            sql.append(",").append(bizRISQL);
        }
        sql.append(", Fendqty, FEndAssQty, FEndAmt");
        sql.append(") ");
        return sql.toString();
    }

    private String getInsertFiledsSql(RptParams params, String[] addFields, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        StringBuffer fields = new StringBuffer();
        String tempTable = params.getString("tempTable");
        for (int i = 0; i < addFields.length; ++i) {
            fields.append(addFields[i]).append(",");
        }
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,FLot,FAssistPropertyID,").append("FProjectID,FTrackNumberID,").append(fields).append("FriInQty,FriInAssQty,FriInAmt,").append("FriOutQty,FriOutAssQty,FriOutAmt,").append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FCostAdjInAmt,FCostAdjOutAmt,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,").append("FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,").append("FStateAdjustOutQty,FStateAdjustOutAssQty,").append("FDecomposeInQty,FDecomposeInAssQty,").append("FDecomposeOutQty,FDecomposeOutAssQty");
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            sql.append(",").append(bizRISQL);
        }
        sql.append(", Fendqty, FEndAssQty, FEndAmt");
        sql.append(") ");
        return sql.toString();
    }

    private String getGroupFiledsSql(RptParams params, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("sum(FBeginQty),sum(FBeginAmt),sum(FBeginAssQty),").append("sum(FCostAdjInAmt),sum(FCostAdjOutAmt),").append("sum(FMoveInQty),sum(FMoveInAssQty),sum(FMoveInAmt),").append("sum(FMoveOutQty),sum(FMoveOutAssQty),sum(FMoveOutAmt),").append("sum(FStateAdjustInQty),sum(FStateAdjustInAssQty),").append("sum(FStateAdjustOutQty),sum(FStateAdjustOutAssQty),").append("sum(FDecomposeInQty),sum(FDecomposeInAssQty),").append("sum(FDecomposeOutQty),sum(FDecomposeOutAssQty)");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            sql.append(",sum(").append(cacheFields.riColName[i]).append(")");
            sql.append(",sum(").append(cacheFields.riColName[i + 1]).append(")");
            sql.append(",sum(").append(cacheFields.riColName[i + 3]).append(")");
        }
        sql.append(",sum(FendQty),sum(FEndAssQty),sum(FEndAmt) ");
        return sql.toString();
    }

    private int getMaterialGroupMaxLevel(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int maxLevel = 1;
        sql.append("select isnull(max(b.flevel),0) as flevel from " + tempTable + " a ");
        sql.append("left join t_bd_materialgroup b on a.fmaterialgroupid = b.fid ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        if (rs.next()) {
            maxLevel = rs.getInt("flevel");
        }
        return maxLevel;
    }

    private void deleteNoInOut(Context ctx, String tempTable, RptParams params, CacheFields cacheFields) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList riTypeInQty = (ArrayList)cacheFields.riTypeMap.get("riTypeInQty");
        ArrayList riTypeOutQty = (ArrayList)cacheFields.riTypeMap.get("riTypeOutQty");
        int coBoxZeroCondition = params.getInt("coBoxZeroCondition");
        if (coBoxZeroCondition == 1) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FCostAdjInAmt = 0 and FMoveInQty = 0 ").append("and FStateAdjustInQty = 0 ").append("and FDecomposeInQty = 0 ");
            int size = riTypeInQty.size();
            for (int i = 0; i < size; ++i) {
                sql.append(" and ").append(riTypeInQty.get(i)).append(" = 0 ");
            }
        } else if (coBoxZeroCondition == 2) {
            sql.append("delete from ").append(tempTable).append(" where ").append(" FMoveOutQty = 0 ").append("and FStateAdjustOutQty =0 ").append("and FDecomposeOutQty =0 ");
            int size = riTypeOutQty.size();
            for (int i = 0; i < size; ++i) {
                sql.append(" and ").append(riTypeOutQty.get(i)).append(" = 0 ");
            }
        } else if (coBoxZeroCondition == 3) {
            sql.append("delete from ").append(tempTable).append(" where ").append(" FMoveInQty = 0 and   FMoveOutQty =0 ").append("and FStateAdjustInQty = 0 and   FStateAdjustOutQty =0 ").append("and FDecomposeInQty = 0 and   FDecomposeOutQty =0 ");
            int len = cacheFields.riColName.length;
            for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
                sql.append(" and ").append(cacheFields.riColName[i]).append(" = 0 ");
            }
        } else if (coBoxZeroCondition == 4) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FBeginQty = 0  ");
        } else if (coBoxZeroCondition == 5) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty = 0 ");
        } else if (coBoxZeroCondition == 6) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty <> 0 ");
        } else if (coBoxZeroCondition == 7) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty <> 0 or FEndAmt = 0 ");
        } else if (coBoxZeroCondition == 8) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FBeginQty = 0 ").append("and FBeginAmt = 0 ").append("and FCostAdjInAmt = 0 and   FCostAdjOutAmt =0 ").append("and FMoveInQty = 0 and   FMoveOutQty =0 ").append("and FStateAdjustInQty = 0 and   FStateAdjustOutQty =0 ").append("and FDecomposeInQty = 0 and   FDecomposeOutQty =0 ");
            int len = cacheFields.riColName.length;
            for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
                sql.append(" and ").append(cacheFields.riColName[i]).append(" = 0 ");
                sql.append(" and ").append(cacheFields.riColName[i + 3]).append(" = 0 ");
            }
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void updateEnd(Context ctx, String tempTable, RptParams params, int index, CacheFields cacheFields) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList riTypeInQty = (ArrayList)cacheFields.riTypeMap.get("riTypeInQty");
        ArrayList riTypeInAssQty = (ArrayList)cacheFields.riTypeMap.get("riTypeInAssQty");
        ArrayList riTypeInAmt = (ArrayList)cacheFields.riTypeMap.get("riTypeInAmt");
        ArrayList riTypeOutQty = (ArrayList)cacheFields.riTypeMap.get("riTypeOutQty");
        ArrayList riTypeOutAssQty = (ArrayList)cacheFields.riTypeMap.get("riTypeOutAssQty");
        ArrayList riTypeOutAmt = (ArrayList)cacheFields.riTypeMap.get("riTypeOutAmt");
        String riTypeSQL = this.getSQL4UpdateEnd(riTypeInQty, riTypeOutQty);
        sql.append("update ").append(tempTable).append(" set ").append("FEndQty = FBeginQty ");
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInQty ");
        }
        if (params.getBoolean("ckBxStatusAdjIn")) {
            sql.append(" + FStateAdjustInQty ");
        }
        if (params.getBoolean("ckBxDecomposeIn")) {
            sql.append(" + FDecomposeInQty ");
        }
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" - FMoveOutQty ");
        }
        if (params.getBoolean("ckBxStatusAdjOut")) {
            sql.append(" - FStateAdjustOutQty ");
        }
        if (params.getBoolean("ckBxDecomposeOut")) {
            sql.append(" - FDecomposeOutQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeInAmt, riTypeOutAmt);
        sql.append(", FEndAmt = FBeginAmt ");
        if (params.getBoolean("ckBxCostAdjIn")) {
            sql.append(" + FCostAdjInAmt ");
        }
        if (params.getBoolean("ckBxCostAdjOut")) {
            sql.append(" - FCostAdjOutAmt ");
        }
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInAmt ");
        }
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" - FMoveOutAmt ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeInAssQty, riTypeOutAssQty);
        sql.append(", FEndAssQty = FBeginAssQty ");
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInAssQty ");
        }
        if (params.getBoolean("ckBxStatusAdjIn")) {
            sql.append(" + FStateAdjustInAssQty ");
        }
        if (params.getBoolean("ckBxDecomposeIn")) {
            sql.append(" + FDecomposeInAssQty ");
        }
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" - FMoveOutAssQty ");
        }
        if (params.getBoolean("ckBxStatusAdjOut")) {
            sql.append(" - FStateAdjustOutAssQty ");
        }
        if (params.getBoolean("ckBxDecomposeOut")) {
            sql.append(" - FDecomposeOutAssQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeInQty, null);
        sql.append(", FriInQty = 0");
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInQty ");
        }
        if (params.getBoolean("ckBxStatusAdjIn")) {
            sql.append(" + FStateAdjustInQty ");
        }
        if (params.getBoolean("ckBxDecomposeIn")) {
            sql.append(" + FDecomposeInQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeInAssQty, null);
        sql.append(", FriInAssQty = 0");
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInAssQty ");
        }
        if (params.getBoolean("ckBxStatusAdjIn")) {
            sql.append(" + FStateAdjustInAssQty ");
        }
        if (params.getBoolean("ckBxDecomposeIn")) {
            sql.append(" + FDecomposeInAssQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeInAmt, null);
        sql.append(", FriInAmt = 0 ");
        if (params.getBoolean("ckBxCostAdjIn")) {
            sql.append(" + FCostAdjInAmt ");
        }
        if (params.getBoolean("ckBxLocIn")) {
            sql.append(" + FMoveInAmt ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeOutQty, null);
        sql.append(", FriOutQty = 0");
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" + FMoveOutQty ");
        }
        if (params.getBoolean("ckBxStatusAdjOut")) {
            sql.append(" + FStateAdjustOutQty ");
        }
        if (params.getBoolean("ckBxDecomposeOut")) {
            sql.append(" + FDecomposeOutQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeOutAssQty, null);
        sql.append(", FriOutAssQty = 0");
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" + FMoveOutAssQty ");
        }
        if (params.getBoolean("ckBxStatusAdjOut")) {
            sql.append(" + FStateAdjustOutAssQty ");
        }
        if (params.getBoolean("ckBxDecomposeOut")) {
            sql.append(" + FDecomposeOutAssQty ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        riTypeSQL = this.getSQL4UpdateEnd(riTypeOutAmt, null);
        sql.append(",  FriOutAmt = 0 ");
        if (params.getBoolean("ckBxCostAdjOut")) {
            sql.append(" + FCostAdjOutAmt ");
        }
        if (params.getBoolean("ckBxLocOut")) {
            sql.append(" + FMoveOutAmt ");
        }
        if (riTypeSQL != null) {
            sql.append(riTypeSQL);
        }
        if (index != -10) {
            sql.append(" where findex = " + index);
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void insertNeedInfo(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlIn = new StringBuffer();
        sqlIn.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FMaterialGroupName,FMaterialGroupNumber,FMaterialNumber,").append("FMaterialName,FShortName,FMaterialSize,FAssistProperty,FAssistPropertyID,FProjectNumber,FProjectName,FTrackNumber,FTrackName,").append("FBaseUnit,FAssistUnit,FStorageOrgName,FWarehouseName,FWarehouseNumber,FLocationName,").append("FBeginQty,FBeginAmt,FriInQty,FriInAmt,FriOutQty,FriOutAmt,").append("FCostAdjInAmt,FCostAdjOutAmt,").append("FEndQty,FEndAmt,").append("FBeginAssQty,FriInAssQty,FriOutAssQty,FEndAssQty,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeInQty,FDecomposeInAssQty,FDecomposeOutQty,FDecomposeOutAssQty,");
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            sqlIn.append(bizRISQL).append(",");
        }
        sqlIn.append("flevel,fisleaf,fparentid,FStorageOrgUnitID,FWarehouseID,");
        sqlIn.append("FMaterialID,FLot,FMaterialGroupID,FMaterialCostType,FBlockID,FStatUnitID,Fisfinaldata,FOriBeginQty").append(") ");
        if (ckBoxLevelGather.booleanValue()) {
            if (coBoxGatherCondition == 0) {
                sql.append(sqlIn);
                sql.append("Select ");
                sql.append("t.FID as FID,t.FIndex as FIndex,");
                sql.append("ISNULL(g.FName_" + this.loc + ",'X')  as FMaterialGroupName,");
                sql.append("ISNULL(g.FNumber,'X') as FMaterialGroupNumber,");
                sql.append("m.FNumber as FMaterialNumber,m.FName_" + this.loc + "  as FMaterialName,m.FShortName\u3000as FShortName,");
                sql.append("SUBSTRING(m.FModel,1,255) as FMaterialSize,");
                sql.append("SUBSTRING(asst.FName_" + this.loc + ",1,255) as FAssistProperty,");
                sql.append("asst.FID as FAssistPropertyID,");
                sql.append("project.FNumber as FProjectNumber,");
                sql.append("project.FName_" + this.loc + " as FProjectName,");
                sql.append("track.FNumber as FTrackNumber,");
                sql.append("track.FName_" + this.loc + " as FTrackName,");
                sql.append("u.FName_" + this.loc + "  as FBaseUnit,");
                sql.append("u2.FName_" + this.loc + "  as FAssistUnit,");
                sql.append("o.FName_" + this.loc + "  as FStorageOrgName,");
                sql.append("wh.FName_" + this.loc + "  as FWarehouseName,");
                sql.append("wh.FNumber as FWarehouseNumber,");
                sql.append("lo.FName_" + this.loc + "  as FLocationName,");
                sql.append("t.FBeginQty,t.FBeginAmt,t.FriInQty,t.FriInAmt,t.FriOutQty,t.FriOutAmt,").append("t.FCostAdjInAmt,t.FCostAdjOutAmt,t.FEndQty,t.FEndAmt,").append("t.FBeginAssQty,t.FriInAssQty,t.FriOutAssQty,t.FEndAssQty,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeInQty,FDecomposeInAssQty,FDecomposeOutQty,FDecomposeOutAssQty,");
                bizRISQL = this.getBizRITypeSQL("t.", true, true, false, true, cacheFields);
                if (bizRISQL != null) {
                    sql.append(bizRISQL).append(",");
                }
                sql.append("g.flevel,g.fisleaf,ISNULL(g.fparentid,'X'),t.FStorageOrgUnitID,t.FWarehouseID,");
                sql.append("t.FMaterialID,t.FLot,ISNULL(g.FID,'X') as FMaterialGroupID,'-1' as FMaterialCostType,ISNULL(t.FBlockID,'X') as FBlockID, t.FStatUnitID,1 as Fisfinaldata,t.FOriBeginQty  ");
                sql.append("From ").append(tempTable).append(" t ");
                sql.append("left Join T_BD_Material m On t.FMaterialID = m.FID ");
                sql.append("INNER JOIN " + orgTempTable + " o ON t.FStorageOrgUnitID = o.FID ");
                sql.append("LEFT JOIN T_BD_MeasureUnit u ON ").append(ckBxByStatUnit ? "t.FStatUnitID" : "m.FBaseUnit").append(" = u.FID ");
                sql.append("LEFT JOIN T_BD_MeasureUnit u2 ON m.FAssistUnit = u2.FID ");
                sql.append("LEFT JOIN T_BD_MaterialGroup g on ISNULL(t.FMaterialGroupID,'X') = ISNULL(g.FID,'X') ");
                sql.append("LEFT JOIN T_DB_Warehouse wh on t.FWarehouseID = wh.FID ");
                sql.append("LEFT JOIN T_DB_Location lo on t.FLocationID = lo.FID ");
                sql.append("LEFT JOIN  T_BD_AsstAttrValue asst ON t.FAssistPropertyID = asst.FID ");
                sql.append("LEFT JOIN T_MM_Project project on t.FProjectID = project.FID ");
                sql.append("LEFT JOIN T_MM_TrackNumber track on t.FTrackNumberID = track.FID ");
            } else {
                sql.append(sqlIn).append("Select ").append("t.FID as FID,t.FIndex as FIndex,").append("g.FName_" + this.loc + "  as FMaterialGroupName,").append("g.FNumber as FMaterialGroupNumber,").append("m.FNumber as FMaterialNumber,").append("isnull(m.FName_" + this.loc + " ,'" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"129_InOutStoreGatherReportFacadeControllerBean", (Locale)ctx.getLocale()) + "') as FMaterialName,").append("isnull(m.FShortName,'') as FShortName,").append("SUBSTRING(m.FModel,1,255) as FMaterialSize,").append("SUBSTRING(asst.FName_" + this.loc + ",1,255) as FAssistProperty,").append("asst.FID as FAssistPropertyID,").append("project.FNumber as FProjectNumber,").append("project.FName_" + this.loc + " as FProjectName,").append("track.FNumber as FTrackNumber,").append("track.FName_" + this.loc + " as FTrackName,").append("u.FName_" + this.loc + "  as FBaseUnit,").append("u2.FName_" + this.loc + "  as FAssistUnit,").append("o.FName_" + this.loc + "  as FStorageOrgName,").append("wh.FName_" + this.loc + "  as FWarehouseName,").append("wh.FNumber as FWarehouseNumber,").append("lo.FName_" + this.loc + "  as FLocationName,");
                sql.append("t.FBeginQty,t.FBeginAmt,t.FriInQty,t.FriInAmt,t.FriOutQty,t.FriOutAmt,").append("t.FCostAdjInAmt,t.FCostAdjOutAmt,t.FEndQty,t.FEndAmt,").append("t.FBeginAssQty,t.FriInAssQty,t.FriOutAssQty,t.FEndAssQty,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeInQty,FDecomposeInAssQty,FDecomposeOutQty,FDecomposeOutAssQty,");
                bizRISQL = this.getBizRITypeSQL("t.", true, true, false, true, cacheFields);
                if (bizRISQL != null) {
                    sql.append(bizRISQL).append(",");
                }
                sql.append("0 as flevel,0 as fisleaf,null as fparentid,t.FStorageOrgUnitID,t.FWarehouseID,").append("t.FMaterialID,t.FLot,g.FID as FMaterialGroupID,t.FMaterialCostType as FMaterialCostType,t.FBlockID as FBlockID, t.FStatUnitID,1 as Fisfinaldata,t.FOriBeginQty ").append("From ").append(tempTable).append(" t ").append("LEFT Join T_BD_Material m On t.FMaterialID = m.FID ").append("INNER JOIN " + orgTempTable + " o ON t.FStorageOrgUnitID = o.FID ").append("LEFT JOIN T_BD_MeasureUnit u ON ").append(ckBxByStatUnit ? "t.FStatUnitID" : "m.FBaseUnit").append(" = u.FID ").append("LEFT JOIN T_BD_MeasureUnit u2 ON m.FAssistUnit = u2.FID ").append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ").append(" left join T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID  ").append("LEFT JOIN T_DB_Warehouse wh on t.FWarehouseID = wh.FID ").append("LEFT JOIN T_DB_Location lo on t.FLocationID = lo.FID ").append("LEFT JOIN  T_BD_AsstAttrValue asst ON t.FAssistPropertyID = asst.FID ").append("LEFT JOIN T_MM_Project project on t.FProjectID = project.FID ").append("LEFT JOIN T_MM_TrackNumber track on t.FTrackNumberID = track.FID ").append(" where MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ");
            }
        } else {
            sql.append(sqlIn).append("Select ").append("t.FID as FID,t.FIndex as FIndex,").append("g.FName_" + this.loc + "  as FMaterialGroupName,").append("g.FNumber as FMaterialGroupNumber,").append("m.FNumber as FMaterialNumber,m.FName_" + this.loc + "  as FMaterialName,m.FShortName as FShortName,").append("SUBSTRING(m.FModel,1,255) as FMaterialSize,").append("SUBSTRING(asst.FName_" + this.loc + ",1,255) as FAssistProperty,").append("asst.FID as FAssistPropertyID,").append("project.FNumber as FProjectNumber,").append("project.FName_" + this.loc + " as FProjectName,").append("track.FNumber as FTrackNumber,").append("track.FName_" + this.loc + " as FTrackName,").append("u.FName_" + this.loc + "  as FBaseUnit,").append("u2.FName_" + this.loc + " as FAssistUnit,").append("o.FName_" + this.loc + "  as FStorageOrgName,").append("wh.FName_" + this.loc + "  as FWarehouseName,").append("wh.FNumber as FWarehouseNumber,").append("lo.FName_" + this.loc + " as FLocationName,");
            sql.append("t.FBeginQty,t.FBeginAmt,t.FriInQty,t.FriInAmt,t.FriOutQty,t.FriOutAmt,").append("t.FCostAdjInAmt,t.FCostAdjOutAmt,t.FEndQty,t.FEndAmt,").append("t.FBeginAssQty,t.FriInAssQty,t.FriOutAssQty,t.FEndAssQty,").append("FMoveInQty,FMoveInAssQty,FMoveInAmt,FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeInQty,FDecomposeInAssQty,FDecomposeOutQty,FDecomposeOutAssQty,");
            bizRISQL = this.getBizRITypeSQL("t.", true, true, false, true, cacheFields);
            if (bizRISQL != null) {
                sql.append(bizRISQL).append(",");
            }
            sql.append("o.flevel,o.fisleaf,o.fparentid,t.FStorageOrgUnitID,t.FWarehouseID,").append("t.FMaterialID,t.FLot,g.FID as FMaterialGroupID,'-1' as FMaterialCostType,t.FBlockID as FBlockID, t.FStatUnitID,1 as Fisfinaldata,t.FOriBeginQty ").append("From ").append(tempTable).append(" t ").append("Inner Join T_BD_Material m On t.FMaterialID = m.FID ").append("INNER JOIN " + orgTempTable + " o ON t.FStorageOrgUnitID = o.FID ").append("INNER JOIN T_BD_MeasureUnit u ON ").append(ckBxByStatUnit ? "t.FStatUnitID" : "m.FBaseUnit").append(" = u.FID ").append("LEFT JOIN T_BD_MeasureUnit u2 ON m.FAssistUnit = u2.FID ").append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ").append(" left join T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID  ").append("LEFT JOIN T_DB_Warehouse wh on t.FWarehouseID = wh.FID ").append("LEFT JOIN T_DB_Location lo on t.FLocationID = lo.FID ").append("LEFT JOIN  T_BD_AsstAttrValue asst ON t.FAssistPropertyID = asst.FID ").append("LEFT JOIN T_MM_Project project on t.FProjectID = project.FID ").append("LEFT JOIN T_MM_TrackNumber track on t.FTrackNumberID = track.FID ").append(" where MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ");
        }
        sql.append(";");
        sql.append("delete from " + tempTable + " where Fisfinaldata = 0 ");
        super.executeBatchUpdate(ctx, sql.toString().split(";"));
    }

    private void finalUpdateTempTable(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer sql;
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        String tempTable = params.getString("tempTable");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        if (ckBxOnlyShowDetail.booleanValue()) {
            this.executeSQL(ctx, "update " + tempTable + " set fisleaf = 1,flevel = 1 ");
            return;
        }
        if (ckBoxLevelGather.booleanValue()) {
            if (coBoxGatherCondition == 0) {
                sql = new StringBuffer();
                sql.append("update " + tempTable + " set fisleaf = 0 where findex >= 2 ");
                sql.append(";");
                sql.append("update " + tempTable + " set fisleaf = 0, flevel =1 where findex >= 2 and flevel is null and fmaterialgroupid = 'X'");
                sql.append(";");
                sql.append("update " + tempTable + " set fisleaf = 1, flevel = flevel + 1,fparentid = fmaterialgroupid  where findex = 1 ");
                sql.append(";");
                sql.append("update " + tempTable + " set fisleaf = 1, flevel = ISNULL(flevel,1) + 1,fparentid = fmaterialgroupid  where findex = 1 and flevel is null and fmaterialgroupid = 'X'");
                sql.append(";");
                sql.append("update " + tempTable + " set  flevel = flevel + 1  where findex = 0 ");
                sql.append(";");
                sql.append("update " + tempTable + " set  flevel = ISNULL(flevel,1) + 1  where findex = 0 and flevel is null and fmaterialgroupid = 'X'");
                super.executeBatchUpdate(ctx, sql.toString().split(";"));
                StringBuffer sql2 = new StringBuffer();
                sql2.append("select mg.fid as fid,flongnumber as flongnumber from t_bd_materialGroup mg left join ").append(tempTable).append(" t on mg.fid = t.fmaterialgroupid where ").append(" t.flevel = 1");
                RptRowSet rs = this.executeQuery(sql2.toString(), null, ctx);
                StringBuffer sql3 = new StringBuffer();
                while (rs.next()) {
                    sql3.append("update ").append(tempTable).append(" set (FBlockID) = (").append("select '").append(rs.getString("fid")).append("' ").append("from t_bd_materialgroup g where ").append(tempTable).append(".fmaterialgroupid = g.fid and (").append(" (g.flongnumber = '").append(rs.getString("flongnumber")).append("' ").append("or g.flongnumber like '").append(rs.getString("flongnumber")).append("!%') ").append("))");
                    sql3.append(";");
                }
                if (rs.next()) {
                    super.executeBatchUpdate(ctx, sql3.toString().split(";"));
                }
            } else {
                sql = new StringBuffer();
                sql.append("update " + tempTable + " set flevel = 1 where findex = 2");
                sql.append(";");
                sql.append("update " + tempTable + " set flevel = 2,fisleaf = 1,fparentid = FMaterialCostType where findex = 1");
                sql.append(";");
                sql.append("update " + tempTable + " set flevel = 2,fparentid = FMaterialCostType where findex = 0");
                super.executeBatchUpdate(ctx, sql.toString().split(";"));
            }
        }
        if (ckBxShowWhs.booleanValue() || ckBxShowLocation.booleanValue() || ckBxShowLot.booleanValue() || ckBxShowAsstAttr.booleanValue() || ckBxShowProject.booleanValue() || ckBxShowTrackNum.booleanValue()) {
            sql = new StringBuffer();
            sql.append("update " + tempTable + " set fisleaf = 0 where findex = 1 ");
            sql.append(";");
            sql.append("update " + tempTable + " set fisleaf = 0, flevel =1 where findex = 1 and flevel is null and fmaterialgroupid = 'X'");
            sql.append(";");
            sql.append("update " + tempTable + " set fisleaf = 1,flevel = flevel + 1 where findex = 0 ");
            sql.append(";");
            sql.append("update " + tempTable + " set fisleaf = 1,flevel = ISNULL(flevel,1) + 1 where findex = 0 and flevel is null and fmaterialgroupid = 'X'");
            super.executeBatchUpdate(ctx, sql.toString().split(";"));
        } else {
            this.executeSQL(ctx, "delete from " + tempTable + " where findex = 0");
        }
        int spinQtyPrecision = params.getInt("spinQtyPrecission");
        int spinAmtPrecision = params.getInt("spinAmountPrecission");
        int spinAssistQtyPrecision = params.getInt("spinAssQtyPrecission");
        StringBuffer sqlb = new StringBuffer();
        sqlb.append("update ").append(tempTable).append(" set ").append("FBeginQty = round(FBeginQty,").append(spinQtyPrecision).append("),").append("FBeginAmt = round(FBeginAmt,").append(spinAmtPrecision).append("),").append("FriInQty = round(FriInQty,").append(spinQtyPrecision).append("),").append("FriInAmt = round(FriInAmt,").append(spinAmtPrecision).append("),").append("FriOutQty = round(FriOutQty,").append(spinQtyPrecision).append("),").append("FriOutAmt = round(FriOutAmt,").append(spinAmtPrecision).append("),").append("FEndQty = round(FEndQty,").append(spinQtyPrecision).append("),").append("FEndAmt = round(FEndAmt,").append(spinAmtPrecision).append("),").append("FBeginAssQty = round(FBeginAssQty,").append(spinAssistQtyPrecision).append("),").append("FriInAssQty = round(FriInAssQty,").append(spinAssistQtyPrecision).append("),").append("FriOutAssQty = round(FriOutAssQty,").append(spinAssistQtyPrecision).append("),").append("FEndAssQty = round(FEndAssQty,").append(spinAssistQtyPrecision).append("),").append("FMoveInAssQty = round(FMoveInAssQty,").append(spinAssistQtyPrecision).append("),").append("FMoveOutAssQty = round(FMoveOutAssQty,").append(spinAssistQtyPrecision).append(")");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            sqlb.append(",").append(cacheFields.riColName[i]).append("=round(").append(cacheFields.riColName[i]).append(",").append(spinQtyPrecision).append(") ");
            sqlb.append(",").append(cacheFields.riColName[i + 1]).append("=round(").append(cacheFields.riColName[i + 1]).append(",").append(spinAssistQtyPrecision).append(") ");
            sqlb.append(",").append(cacheFields.riColName[i + 3]).append("=round(").append(cacheFields.riColName[i + 3]).append(",").append(spinAmtPrecision).append(") ");
        }
        this.executeSQL(ctx, sqlb.toString());
    }

    private void viewTotalLine(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer sb = new StringBuffer(128);
        sb.append("delete from " + tempTable + " where flevel <> 1").append(";");
        sb.append("update " + tempTable + " set fisleaf = 1").append(";");
        super.executeBatchUpdate(ctx, sb.toString().split(";"));
    }

    private void addsumRow(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer insertCols = new StringBuffer();
        StringBuffer sumCols = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        insertCols.append(" FID ,");
        insertCols.append("FBeginQty ,");
        insertCols.append("FBeginAmt ,");
        insertCols.append("FriInQty ,");
        insertCols.append("FriInAmt ,");
        insertCols.append("FriOutQty ,");
        insertCols.append("FriOutAmt ,");
        insertCols.append("FCostAdjInAmt ,");
        insertCols.append("FCostAdjOutAmt ,");
        insertCols.append("FMoveInQty ,");
        insertCols.append("FMoveInAmt ,");
        insertCols.append("FMoveOutQty ,");
        insertCols.append("FMoveOutAmt ,");
        insertCols.append("FEndQty ,");
        insertCols.append("FEndAmt ,");
        insertCols.append("FBeginAssQty ,");
        insertCols.append("FriInAssQty ,");
        insertCols.append("FriOutAssQty ,");
        insertCols.append("FMoveInAssQty ,");
        insertCols.append("FMoveOutASSQty ,");
        insertCols.append("FEndAssQty ,");
        insertCols.append("FStateAdjustInQty ,");
        insertCols.append("FStateAdjustInAssQty ,");
        insertCols.append("FStateAdjustOutQty ,");
        insertCols.append("FStateAdjustOutAssQty ,");
        insertCols.append("FDecomposeInQty ,");
        insertCols.append("FDecomposeInAssQty ,");
        insertCols.append("FDecomposeOutQty ,");
        insertCols.append("FDecomposeOutAssQty ,");
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            insertCols.append(bizRISQL).append(", ");
        }
        insertCols.append("FStorageOrgName ,");
        insertCols.append("flevel ,");
        insertCols.append("fisleaf ");
        sumCols.append("newbosid('88888888'),");
        sumCols.append("ISNULL(sum(FBeginQty),0) ,");
        sumCols.append("ISNULL(sum(FBeginAmt),0) ,");
        sumCols.append("ISNULL(sum(FriInQty),0) ,");
        sumCols.append("ISNULL(sum(FriInAmt),0) ,");
        sumCols.append("ISNULL(sum(FriOutQty),0) ,");
        sumCols.append("ISNULL(sum(FriOutAmt),0) ,");
        sumCols.append("ISNULL(sum(FCostAdjInAmt),0) ,");
        sumCols.append("ISNULL(sum(FCostAdjOutAmt),0) ,");
        sumCols.append("ISNULL(sum(FMoveInQty),0) ,");
        sumCols.append("ISNULL(sum(FMoveInAmt),0) ,");
        sumCols.append("ISNULL(sum(FMoveOutQty),0) ,");
        sumCols.append("ISNULL(sum(FMoveOutAmt),0) ,");
        sumCols.append("ISNULL(sum(FEndQty),0) ,");
        sumCols.append("ISNULL(sum(FEndAmt),0) ,");
        sumCols.append("ISNULL(sum(FBeginAssQty),0) ,");
        sumCols.append("ISNULL(sum(FriInAssQty ),0),");
        sumCols.append("ISNULL(sum(FriOutAssQty),0) ,");
        sumCols.append("ISNULL(sum(FMoveInAssQty),0) ,");
        sumCols.append("ISNULL(sum(FMoveOutAssQty),0) ,");
        sumCols.append("ISNULL(sum(FEndAssQty),0) ,");
        sumCols.append("ISNULL(sum(FStateAdjustInQty),0) ,");
        sumCols.append("ISNULL(sum(FStateAdjustInAssQty),0) ,");
        sumCols.append("ISNULL(sum(FStateAdjustOutQty),0) ,");
        sumCols.append("ISNULL(sum(FStateAdjustOutAssQty),0) ,");
        sumCols.append("ISNULL(sum(FDecomposeInQty),0) ,");
        sumCols.append("ISNULL(sum(FDecomposeInAssQty),0) ,");
        sumCols.append("ISNULL(sum(FDecomposeOutQty),0) ,");
        sumCols.append("ISNULL(sum(FDecomposeOutAssQty),0) ,");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            sumCols.append("ISNULL(sum(").append(cacheFields.riColName[i]).append("),0), ");
            sumCols.append("ISNULL(sum(").append(cacheFields.riColName[i + 1]).append("),0), ");
            sumCols.append("ISNULL(sum(").append(cacheFields.riColName[i + 3]).append("),0), ");
        }
        sumCols.append("'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz' ,");
        sumCols.append("1 ,");
        sumCols.append("0 ");
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" (").append(insertCols).append(" ) SELECT ");
        sql.append(sumCols);
        sql.append(" FROM ").append(tempTable);
        sql.append(" WHERE flevel = 1 ");
        this.executeSQL(ctx, sql.toString());
    }

    private HashMap<String, String> getResource(Context ctx, RptParams params) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        resMap.put("materialNumber", SCMUtils.getResource((String)resFile, (String)"materialNumber", (Context)ctx));
        resMap.put("materialName", SCMUtils.getResource((String)resFile, (String)"materialName", (Context)ctx));
        resMap.put("materialModel", SCMUtils.getResource((String)resFile, (String)"materialModel", (Context)ctx));
        resMap.put("baseUnit", SCMUtils.getResource((String)resFile, (String)"baseUnit", (Context)ctx));
        resMap.put("storageOrgUnit", SCMUtils.getResource((String)resFile, (String)"storageOrgUnit", (Context)ctx));
        resMap.put("beginInvQty", SCMUtils.getResource((String)resFile, (String)"beginInvQty", (Context)ctx));
        resMap.put("endInvQty", SCMUtils.getResource((String)resFile, (String)"endInvQty", (Context)ctx));
        resMap.put("qty", SCMUtils.getResource((String)resFile, (String)"qty", (Context)ctx));
        resMap.put("amount", SCMUtils.getResource((String)resFile, (String)"amount", (Context)ctx));
        resMap.put("price", SCMUtils.getResource((String)resFile, (String)"price", (Context)ctx));
        resMap.put("materialCostType", SCMUtils.getResource((String)resFile, (String)"materialCostType", (Context)ctx));
        resMap.put("materialType", SCMUtils.getResource((String)resFile, (String)"materialType", (Context)ctx));
        resMap.put("lot", SCMUtils.getResource((String)resFile, (String)"lot", (Context)ctx));
        resMap.put("warehouse", SCMUtils.getResource((String)resFile, (String)"warehouse", (Context)ctx));
        resMap.put("location", SCMUtils.getResource((String)resFile, (String)"location", (Context)ctx));
        resMap.put("none", SCMUtils.getResource((String)resFile, (String)"none", (Context)ctx));
        resMap.put("statUnit", SCMUtils.getResource((String)resFile, (String)"statUnit", (Context)ctx));
        resMap.put("assistQty", SCMUtils.getResource((String)resFile, (String)"assistQty", (Context)ctx));
        resMap.put("assistUnit", SCMUtils.getResource((String)resFile, (String)"assistUnit2", (Context)ctx));
        resMap.put("riIn", SCMUtils.getResource((String)resFile, (String)"riIn", (Context)ctx));
        resMap.put("riOut", SCMUtils.getResource((String)resFile, (String)"riOut", (Context)ctx));
        resMap.put("CostAdjIn", SCMUtils.getResource((String)resFile, (String)"costAdjIn", (Context)ctx));
        resMap.put("CostAdjOut", SCMUtils.getResource((String)resFile, (String)"costAdjOut", (Context)ctx));
        resMap.put("MoveIn", SCMUtils.getResource((String)resFile, (String)"MoveIn", (Context)ctx));
        resMap.put("MoveOut", SCMUtils.getResource((String)resFile, (String)"MoveOut", (Context)ctx));
        resMap.put("StateAdjustIn", SCMUtils.getResource((String)resFile, (String)"StateAdjustIn", (Context)ctx));
        resMap.put("StateAdjustOut", SCMUtils.getResource((String)resFile, (String)"StateAdjustOut", (Context)ctx));
        resMap.put("DecomposeIn", SCMUtils.getResource((String)resFile, (String)"DecomposeIn", (Context)ctx));
        resMap.put("DecomposeOut", SCMUtils.getResource((String)resFile, (String)"DecomposeOut", (Context)ctx));
        resMap.put("storePeriod", SCMUtils.getResource((String)resFile, (String)"storePeriod", (Context)ctx));
        resMap.put("assistProperty", SCMUtils.getResource((String)resFile, (String)"assistProperty", (Context)ctx));
        resMap.put("projectNumber", SCMUtils.getResource((String)resFile, (String)"projectNumber", (Context)ctx));
        resMap.put("projectName", SCMUtils.getResource((String)resFile, (String)"projectName", (Context)ctx));
        resMap.put("trackNumber", SCMUtils.getResource((String)resFile, (String)"trackNumber", (Context)ctx));
        resMap.put("trackName", SCMUtils.getResource((String)resFile, (String)"trackName", (Context)ctx));
        resMap.put("shortName", SCMUtils.getResource((String)resFile, (String)"shortName", (Context)ctx));
        return resMap;
    }

    protected String querySql(RptParams params, CacheFields cacheFields) throws BOSException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        String tempTable = params.getString("tempTable");
        String filedName = "FMaterialGroupName";
        StringBuffer sql = new StringBuffer();
        int pricePrecision = params.getInt("spinPricePrecission");
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            filedName = "FMaterialCostTypeName";
        }
        sql.append("Select ").append(filedName).append(",").append("FMaterialNumber,FMaterialName,").append(ckBxShowMShortName ? "FShortName," : "").append("trim(FMaterialSize) as FMaterialSize,").append(ckBxShowAsstAttr ? "trim(FAssistProperty) as FAssistProperty," : "").append("FBaseUnit,").append("FAssistUnit,").append("FStorageOrgName,").append(ckBxShowWhs ? "FWarehouseName," : "").append(ckBxShowLocation ? "FLocationName," : "").append(ckBxShowLot ? "FLot," : "").append(ckBxShowProject ? "FProjectNumber," : "").append(ckBxShowProject ? "FProjectName," : "").append(ckBxShowTrackNum ? "FTrackNumber," : "").append(ckBxShowTrackNum ? "FTrackName," : "");
        sql.append("FBeginQty,FBeginAssQty,").append("case FBeginQty when 0 then 0 else round(FBeginAmt/FBeginQty,").append(pricePrecision).append(") end as FBeginPrice,").append("FBeginAmt,").append("FriInQty,FriInAssQty,").append("case FriInQty when 0 then 0 else round(FriInAmt/FriInQty,").append(pricePrecision).append(") end as FriInPrice,").append("FriInAmt,");
        Object[] riType = (Object[])params.getObject("RIType");
        RecIssueTypeInfo riTypeInfo = null;
        ArrayList<RecIssueTypeInfo> riTypeIn = new ArrayList<RecIssueTypeInfo>();
        ArrayList<RecIssueTypeInfo> riTypeOut = new ArrayList<RecIssueTypeInfo>();
        RecIssueTypeCollection riCol = new RecIssueTypeCollection();
        if (riType != null) {
            int i;
            int len = riType.length;
            for (i = 0; i < len; ++i) {
                riCol.add((RecIssueTypeInfo)riType[i]);
            }
            riCol.sort("number");
            int size = riCol.size();
            for (i = 0; i < size; ++i) {
                riTypeInfo = riCol.get(i);
                if (RIEnum.Receive == riTypeInfo.getRI()) {
                    riTypeIn.add(riCol.get(i));
                    continue;
                }
                if (RIEnum.Issue != riTypeInfo.getRI()) continue;
                riTypeOut.add(riCol.get(i));
            }
        }
        if (riTypeIn.size() == 0 && riTypeOut.size() > 0) {
            sql.append("FCostAdjInAmt,").append("FMoveInQty,FMoveInAssQty,").append("case FMoveInQty when 0 then 0 else round(FMoveInAmt/FMoveInQty,").append(pricePrecision).append(") end as FMoveInPrice,").append("FMoveInAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FDecomposeInQty,FDecomposeInAssQty,").append("FriOutQty,FriOutAssQty,").append("case FriOutQty when 0 then 0 else round(FriOutAmt/FriOutQty,").append(pricePrecision).append(") end as FriOutPrice,").append("FriOutAmt,");
        }
        int riTypeFlag = 0;
        int len = cacheFields.riColHeaderName.length;
        for (int i = 0; i < len; ++i) {
            if (riTypeIn.size() == 0 && riTypeOut.size() > 0) {
                if (!cacheFields.riColHeaderName[i].startsWith("FRIType")) continue;
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i]).append("),");
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i + 1]).append("),");
                sql.append(" case ").append(cacheFields.riColHeaderName[i]).append(" when 0 then 0 else round(").append(cacheFields.riColHeaderName[i + 3]).append("/").append(cacheFields.riColHeaderName[i]).append(",").append(pricePrecision).append(") end as ").append(cacheFields.riColHeaderName[i + 2]).append(",");
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i + 3]).append("),");
                i += 3;
                continue;
            }
            if (cacheFields.riColHeaderName[i].startsWith("FRIType")) {
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i]).append("),");
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i + 1]).append("),");
                sql.append(" case ").append(cacheFields.riColHeaderName[i]).append(" when 0 then 0 else round(").append(cacheFields.riColHeaderName[i + 3]).append("/").append(cacheFields.riColHeaderName[i]).append(",").append(pricePrecision).append(") end as ").append(cacheFields.riColHeaderName[i + 2]).append(",");
                sql.append(" abs( ").append(cacheFields.riColHeaderName[i + 3]).append("),");
                i += 3;
                ++riTypeFlag;
                continue;
            }
            if (riTypeFlag <= 0) continue;
            sql.append("FCostAdjInAmt,").append("FMoveInQty,FMoveInAssQty,").append("case FMoveInQty when 0 then 0 else round(FMoveInAmt/FMoveInQty,").append(pricePrecision).append(") end as FMoveInPrice,").append("FMoveInAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FDecomposeInQty,FDecomposeInAssQty,").append("FriOutQty,FriOutAssQty,").append("case FriOutQty when 0 then 0 else round(FriOutAmt/FriOutQty,").append(pricePrecision).append(") end as FriOutPrice,").append("FriOutAmt,");
            riTypeFlag = -99;
        }
        if (cacheFields.riTypeIndex == cacheFields.riColHeaderName.length) {
            sql.append("FCostAdjInAmt,").append("FMoveInQty,FMoveInAssQty,").append("case FMoveInQty when 0 then 0 else round(FMoveInAmt/FMoveInQty,").append(pricePrecision).append(") end as FMoveInPrice,").append("FMoveInAmt,").append("FStateAdjustInQty,FStateAdjustInAssQty,FDecomposeInQty,FDecomposeInAssQty,").append("FriOutQty,FriOutAssQty,").append("case FriOutQty when 0 then 0 else round(FriOutAmt/FriOutQty,").append(pricePrecision).append(") end as FriOutPrice,").append("FriOutAmt,");
        }
        sql.append("FCostAdjOutAmt,FMoveOutQty,FMoveOutAssQty,").append("case FMoveOutQty when 0 then 0 else round(FMoveOutAmt/FMoveOutQty,").append(pricePrecision).append(") end as FMoveOutPrice,").append("FMoveOutAmt,").append("FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeOutQty,FDecomposeOutAssQty,").append("FEndQty,FEndAssQty,").append("case FEndQty when 0 then 0 else round(FEndAmt/FEndQty,").append(pricePrecision).append(") end as FEndPrice,").append("FEndAmt,");
        sql.append("flevel,fisleaf,fparentid,FStorageOrgUnitID,(case FWarehouseID when '1' then null else FWarehouseID end) as FWarehouseID,").append("FMaterialID,FMaterialGroupID,FMaterialCostType,FBlockID,FIndex ,FAssistPropertyID,FStatUnitID,FProjectID,FTrackNumberID,FOriBeginQty ").append("From ").append(tempTable).append(" ");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        CacheFields cacheFields = new CacheFields();
        HashMap<String, String> resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, resMap);
        this.initRITypeColName(ctx, params, cacheFields);
        StringBuffer sql = new StringBuffer(this.querySql(params, cacheFields));
        RptRowSet rs = null;
        int start = from + 1;
        int end = from + len;
        sql.append(" where KSQL_SEQ >=").append(start).append(" and KSQL_SEQ <=").append(end);
        sql.append(" Order by KSQL_SEQ ASC");
        RptParams pp = new RptParams();
        if (params.containsKey("isReport") && params.getBoolean("isReport")) {
            IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            pp.setObject("IRowset", (Object)irs);
        } else {
            rs = this.executeQuery(sql.toString(), null, ctx);
            pp.setObject("rowset", (Object)rs);
        }
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        CacheFields cacheFields = new CacheFields();
        HashMap<String, String> resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, resMap);
        this.initRITypeColName(ctx, params, cacheFields);
        String findex = params.getString("findex");
        StringBuffer sql = new StringBuffer();
        if (ckBoxLevelGather.booleanValue()) {
            sql.append(this.querySql(params, cacheFields)).append(" where ");
            if (coBoxGatherCondition == 0) {
                if ("2".equals(findex)) {
                    sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex = 1 ").append("order by FMaterialNumber");
                } else if ("1".equals(findex)) {
                    sql.append(" fmaterialid = '").append(params.getString("fmaterialid")).append("' and findex = 0 ").append("order by fwarehouseid,flot,FAssistProperty,FProjectNumber,FTrackNumber ");
                } else {
                    sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex<> 0 ").append("order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FAssistProperty,FProjectNumber,FTrackNumber ");
                }
            } else {
                if ("2".equals(findex)) {
                    if (params.getString("fparentid") == null || params.getString("fparentid").equals("X")) {
                        sql.append(" fparentid is null").append(" and findex = 1 ");
                    } else {
                        sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex = 1 ");
                    }
                    sql.append("order by FMaterialNumber,fwarehouseid,flot,FAssistProperty,FProjectNumber,FTrackNumber");
                } else if ("1".equals(findex)) {
                    sql.append(" fmaterialid = '").append(params.getString("fmaterialid")).append("' and findex = 0 ").append("order by fwarehouseid,flot,FAssistProperty,FProjectNumber,FTrackNumber");
                }
                if ("0".equals(findex) && sql.toString().trim().endsWith("where")) {
                    sql = sql.delete(sql.toString().lastIndexOf("where"), sql.toString().length());
                }
            }
        } else {
            sql.append(this.querySql(params, cacheFields)).append(" where fmaterialid='").append(params.getString("fmaterialid")).append("' ");
            if ("1".equals(findex)) {
                sql.append("and fstorageorgunitid = '").append(params.getString("fstorageorgunitid")).append("' ").append("and findex = 0 ").append("order by fwarehouseid,flot,FAssistProperty,FProjectNumber,FTrackNumber ");
            } else {
                sql.append("and fparentid='").append(params.getString("fparentid")).append("' ").append("and findex <> 0 ").append("order by fwarehouseid,flot,FAssistProperty ,FProjectNumber,FTrackNumber ");
            }
        }
        RptRowSet rs = start <= -1 && count <= -1 ? this.executeQuery(sql.toString(), null, ctx) : this.executeQuery(sql.toString(), null, start, count, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  fid from " + param.getString("tempTable") + " where flevel = 1 Order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,flot,FAssistProperty,FProjectNumber,FTrackNumber,FId  ";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    protected RptParams _getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException {
        StringBuffer fid = new StringBuffer(" FId IN (  '").append(idList.get(0).toString()).append("'");
        CacheFields cacheFields = new CacheFields();
        HashMap<String, String> resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, resMap);
        this.initRITypeColName(ctx, params, cacheFields);
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", '").append(idList.get(i).toString()).append("'");
        }
        fid.append(" ) ");
        String rsList = this.querySql(params, cacheFields) + "  where " + fid.toString() + " Order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FProjectNumber,FTrackNumber ";
        RptRowSet rs = this.executeQuery(rsList, null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptTableHeader getReportHeader(RptParams params, CacheFields cacheFields) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        col = new RptTableColumn("FMaterialGroupName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(80);
        col.setFormatPattern("@");
        header.addColumn(col);
        col = new RptTableColumn("FMaterialName");
        col.setWidth(100);
        col.setFormatPattern("@");
        header.addColumn(col);
        if (ckBxShowMShortName.booleanValue()) {
            col = new RptTableColumn("FShortName");
            col.setWidth(100);
            header.addColumn(col);
        }
        col = new RptTableColumn("FMaterialSize");
        col.setWidth(100);
        header.addColumn(col);
        if (ckBxShowAsstAttr.booleanValue()) {
            col = new RptTableColumn("FAssistProperty");
            col.setWidth(100);
            header.addColumn(col);
        }
        col = new RptTableColumn("FBaseUnit");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAssistUnit");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgName");
        col.setWidth(150);
        header.addColumn(col);
        if (ckBxShowWhs.booleanValue()) {
            col = new RptTableColumn("FWarehouseName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowLocation.booleanValue()) {
            col = new RptTableColumn("FLocationName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowLot.booleanValue()) {
            col = new RptTableColumn("FLot");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowProject.booleanValue()) {
            col = new RptTableColumn("FProjectNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FProjectName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowTrackNum.booleanValue()) {
            col = new RptTableColumn("FTrackNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FTrackName");
            col.setWidth(100);
            header.addColumn(col);
        }
        for (int i = 0; i < cacheFields.riColHeaderName.length; ++i) {
            boolean isHide = !this.isShow(params, cacheFields.riColHeaderName[i], cacheFields);
            this.setRptColunm(header, cacheFields.riColHeaderName[i], 2, isHide);
        }
        this.setReportHead4Hide(header);
        int arrayLength = 22;
        if (ckBxShowWhs.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowLocation.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowLot.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowMShortName.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowProject.booleanValue()) {
            arrayLength += 2;
        }
        if (ckBxShowTrackNum.booleanValue()) {
            arrayLength += 2;
        }
        Object[][] labels = this.getReportHeadLables(arrayLength += cacheFields.riColHeaderName.length, params, cacheFields);
        header.setLabels(labels, true);
        return header;
    }

    protected Object[][] getReportHeadLables(int arrayLength, RptParams params, CacheFields cacheFields) {
        Object[][] labels = new Object[2][arrayLength];
        HashMap resMap = (HashMap)params.getObject(this.resMapStr);
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowProject = (Boolean)params.getObject("ckBxShowProject");
        Boolean ckBxShowTrackNum = (Boolean)params.getObject("ckBxShowTrackNum");
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        int m = 0;
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            labels[0][m] = (String)resMap.get("materialCostType");
            ++m;
        } else {
            labels[0][m] = (String)resMap.get("materialType");
            ++m;
        }
        labels[0][m] = (String)resMap.get("materialNumber");
        labels[0][++m] = (String)resMap.get("materialName");
        ++m;
        if (ckBxShowMShortName.booleanValue()) {
            labels[0][m] = (String)resMap.get("shortName");
            ++m;
        }
        labels[0][m] = (String)resMap.get("materialModel");
        ++m;
        if (ckBxShowAsstAttr.booleanValue()) {
            labels[0][m] = (String)resMap.get("assistProperty");
            ++m;
        }
        if (ckBxByStatUnit.booleanValue()) {
            labels[0][m] = (String)resMap.get("statUnit");
            ++m;
        } else {
            labels[0][m] = (String)resMap.get("baseUnit");
            ++m;
        }
        labels[0][m] = (String)resMap.get("assistUnit");
        labels[0][++m] = (String)resMap.get("storageOrgUnit");
        ++m;
        if (ckBxShowWhs.booleanValue()) {
            labels[0][m] = (String)resMap.get("warehouse");
            ++m;
        }
        if (ckBxShowLocation.booleanValue()) {
            labels[0][m] = (String)resMap.get("location");
            ++m;
        }
        if (ckBxShowLot.booleanValue()) {
            labels[0][m] = (String)resMap.get("lot");
            ++m;
        }
        if (ckBxShowProject.booleanValue()) {
            labels[0][m] = (String)resMap.get("projectNumber");
            labels[0][++m] = (String)resMap.get("projectName");
            ++m;
        }
        if (ckBxShowTrackNum.booleanValue()) {
            labels[0][m] = (String)resMap.get("trackNumber");
            labels[0][++m] = (String)resMap.get("trackName");
            ++m;
        }
        for (int i = 0; i < cacheFields.riColBlockName.length; ++i) {
            String blockName = (String)resMap.get(cacheFields.riColBlockName[i]);
            labels[0][m] = blockName;
            ++m;
            if (!(cacheFields.riColBlockName[i].startsWith("CostAdj") || cacheFields.riColBlockName[i].startsWith("Move") || cacheFields.riColBlockName[i].startsWith("StateAdjust") || cacheFields.riColBlockName[i].startsWith("Decompose"))) {
                labels[0][m] = blockName;
                labels[0][++m] = blockName;
                labels[0][++m] = blockName;
                ++m;
                continue;
            }
            if (cacheFields.riColBlockName[i].startsWith("StateAdjust") || cacheFields.riColBlockName[i].startsWith("Decompose")) {
                labels[0][m] = blockName;
                ++m;
                continue;
            }
            if (!cacheFields.riColBlockName[i].startsWith("Move")) continue;
            labels[0][m] = blockName;
            labels[0][++m] = blockName;
            labels[0][++m] = blockName;
            ++m;
        }
        labels[0][m] = "level";
        labels[0][++m] = "isLeaf";
        labels[0][++m] = "FParentID";
        labels[0][++m] = "FStorageOrgID";
        labels[0][++m] = "FWarehouseID";
        labels[0][++m] = "FMaterialID";
        labels[0][++m] = "FMaterialGroupID";
        labels[0][++m] = "FMaterialCostType";
        labels[0][++m] = "FBlockID";
        labels[0][++m] = "FIndex";
        labels[0][++m] = "FAssistPropertyID";
        labels[0][++m] = "FStatUnitID";
        labels[0][++m] = "FProjectID";
        labels[0][++m] = "FTrackNumberID";
        labels[0][++m] = "FOriBeginQty";
        m = 0;
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            labels[1][m] = (String)resMap.get("materialCostType");
            ++m;
        } else {
            labels[1][m] = (String)resMap.get("materialType");
            ++m;
        }
        labels[1][m] = (String)resMap.get("materialNumber");
        labels[1][++m] = (String)resMap.get("materialName");
        ++m;
        if (ckBxShowMShortName.booleanValue()) {
            labels[1][m] = (String)resMap.get("shortName");
            ++m;
        }
        labels[1][m] = (String)resMap.get("materialModel");
        ++m;
        if (ckBxShowAsstAttr.booleanValue()) {
            labels[1][m] = (String)resMap.get("assistProperty");
            ++m;
        }
        if (ckBxByStatUnit.booleanValue()) {
            labels[1][m] = (String)resMap.get("statUnit");
            ++m;
        } else {
            labels[1][m] = (String)resMap.get("baseUnit");
            ++m;
        }
        labels[1][m] = (String)resMap.get("assistUnit");
        labels[1][++m] = (String)resMap.get("storageOrgUnit");
        ++m;
        if (ckBxShowWhs.booleanValue()) {
            labels[1][m] = (String)resMap.get("warehouse");
            ++m;
        }
        if (ckBxShowLocation.booleanValue()) {
            labels[1][m] = (String)resMap.get("location");
            ++m;
        }
        if (ckBxShowLot.booleanValue()) {
            labels[1][m] = (String)resMap.get("lot");
            ++m;
        }
        if (ckBxShowProject.booleanValue()) {
            labels[1][m] = (String)resMap.get("projectNumber");
            labels[1][++m] = (String)resMap.get("projectName");
            ++m;
        }
        if (ckBxShowTrackNum.booleanValue()) {
            labels[1][m] = (String)resMap.get("trackNumber");
            labels[1][++m] = (String)resMap.get("trackName");
            ++m;
        }
        String qty = (String)resMap.get("qty");
        String assistQty = (String)resMap.get("assistQty");
        String price = (String)resMap.get("price");
        String amout = (String)resMap.get("amount");
        for (int i = 0; i < cacheFields.riColBlockName.length; ++i) {
            if (!cacheFields.riColBlockName[i].startsWith("CostAdj")) {
                labels[1][m] = qty;
                labels[1][++m] = assistQty;
                ++m;
            }
            if (!(cacheFields.riColBlockName[i].startsWith("CostAdj") || cacheFields.riColBlockName[i].startsWith("StateAdjust") || cacheFields.riColBlockName[i].startsWith("Decompose"))) {
                labels[1][m] = price;
                ++m;
            }
            if (!(cacheFields.riColBlockName[i].startsWith("Move") || cacheFields.riColBlockName[i].startsWith("StateAdjust") || cacheFields.riColBlockName[i].startsWith("Decompose"))) {
                labels[1][m] = cacheFields.riColBlockName[i].startsWith("CostAdjIn") ? " " + amout : (cacheFields.riColBlockName[i].startsWith("CostAdjOut") ? amout + " " : amout);
                ++m;
            }
            if (!cacheFields.riColBlockName[i].startsWith("Move")) continue;
            labels[1][m] = " " + amout;
            ++m;
        }
        labels[1][m] = "level";
        labels[1][++m] = "isLeaf";
        labels[1][++m] = "FParentID";
        labels[1][++m] = "FStorageOrgID";
        labels[1][++m] = "FWarehouseID";
        labels[1][++m] = "FMaterialID";
        labels[1][++m] = "FMaterialGroupID";
        labels[1][++m] = "FMaterialCostType";
        labels[1][++m] = "FBlockID";
        labels[1][++m] = "FIndex";
        labels[1][++m] = "FAssistPropertyID";
        labels[1][++m] = "FStatUnitID";
        labels[1][++m] = "FProjectID";
        labels[1][++m] = "FTrackNumberID";
        labels[1][++m] = "FOriBeginQty";
        return labels;
    }

    protected void setReportHead4Hide(RptTableHeader header) {
        boolean isHideCol = true;
        RptTableColumn col = null;
        col = new RptTableColumn("Flevel");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("Fisleaf");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FParentID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouseID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("fmaterialid");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialGroupID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialCostType");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FBlockID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FAssistPropertyID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FStatUnitID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FProjectID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FTrackNumberID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FOriBeginQty");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
    }

    private boolean isShow(RptParams params, String colName, CacheFields cacheFields) {
        if (colName.indexOf("riIn") > -1) {
            return (Boolean)params.getObject("ckBxIn") != false && this.isQtyAmtPriceShow(params, colName);
        }
        if (colName.indexOf("riOut") > -1) {
            return (Boolean)params.getObject("ckBxOut") != false && this.isQtyAmtPriceShow(params, colName);
        }
        if (colName.indexOf("CostAdjIn") > -1) {
            return (Boolean)params.getObject("ckBxCostAdjIn") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("CostAdjOut") > -1) {
            return (Boolean)params.getObject("ckBxCostAdjOut") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("MoveInQty") > -1 || colName.indexOf("MoveInAmt") > -1 || colName.indexOf("MoveInPrice") > -1) {
            return (Boolean)params.getObject("ckBxLocIn") != false && this.isShowMoveInOut(params) && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("MoveOutQty") > -1 || colName.indexOf("MoveOutAmt") > -1 || colName.indexOf("MoveOutPrice") > -1) {
            return (Boolean)params.getObject("ckBxLocOut") != false && this.isShowMoveInOut(params) && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("MoveInAssQty") > -1) {
            return this.isShowMoveInOut(params) && this.isQtyAmtPriceShow(params, colName) && (Boolean)params.getObject("ckBxLocIn") != false && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("MoveOutAssQty") > -1) {
            return this.isShowMoveInOut(params) && this.isQtyAmtPriceShow(params, colName) && (Boolean)params.getObject("ckBxLocOut") != false && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("Begin") > -1 || colName.indexOf("End") > -1) {
            return this.isQtyAmtPriceShow(params, colName);
        }
        if (colName.startsWith("FRIType")) {
            return this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("StateAdjustInQty") > -1) {
            return (Boolean)params.getObject("ckBxStatusAdjIn") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("StateAdjustOutQty") > -1) {
            return (Boolean)params.getObject("ckBxStatusAdjOut") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("StateAdjustInAssQty") > -1) {
            return (Boolean)params.getObject("ckBxStatusAdjIn") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("StateAdjustOutAssQty") > -1) {
            return (Boolean)params.getObject("ckBxStatusAdjOut") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("DecomposeInQty") > -1) {
            return (Boolean)params.getObject("ckBxDecomposeIn") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("DecomposeOutQty") > -1) {
            return (Boolean)params.getObject("ckBxDecomposeOut") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("DecomposeInAssQty") > -1) {
            return (Boolean)params.getObject("ckBxDecomposeIn") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        if (colName.indexOf("DecomposeOutAssQty") > -1) {
            return (Boolean)params.getObject("ckBxDecomposeOut") != false && this.isQtyAmtPriceShow(params, colName) && !cacheFields.isShowAllRIType;
        }
        return true;
    }

    private boolean isShowMoveInOut(RptParams params) {
        boolean flag = false;
        String[] paramNames = new String[]{"ckBxLocIn", "ckBxLocOut"};
        int length = paramNames.length;
        for (int i = 0; i < length; ++i) {
            if (!((Boolean)params.getObject(paramNames[i])).booleanValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isQtyAmtPriceShow(RptParams params, String colName) {
        Boolean ckBxShowQty = (Boolean)params.getObject("ckBxShowQty");
        Boolean ckBxShowAmt = (Boolean)params.getObject("ckBxShowAmt");
        Boolean ckBxShowPrice = (Boolean)params.getObject("ckBxShowPrice");
        Boolean ckBxShowAssistQty = (Boolean)params.getObject("ckBxShowAssistQty");
        if (colName.indexOf("AssQty") != -1) {
            return ckBxShowAssistQty;
        }
        if (colName.indexOf("Qty") != -1) {
            return ckBxShowQty;
        }
        if (colName.indexOf("Amt") != -1) {
            return ckBxShowAmt;
        }
        if (colName.indexOf("Price") != -1) {
            return ckBxShowPrice;
        }
        return true;
    }

    private void setRptColunm(RptTableHeader header, String colName, int position, boolean isHide) {
        RptTableColumn col = new RptTableColumn(colName);
        col.setWidth(isHide ? -1 : 100);
        col.setAligment(position);
        col.setHided(isHide);
        header.addColumn(col);
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private void insertBillDateToTempTable(Context ctx, String orgTempTable, RptParams params, CacheFields cacheFields) throws BOSException, EASBizException {
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### handleInitData start ");
        lstart = System.currentTimeMillis();
        this.handleInitData(ctx, params, orgTempTable, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### handleInitData end: " + (lstop - lstart)));
        logger.info((Object)"########### handleBizData start ");
        lstart = System.currentTimeMillis();
        this.handleBizData(ctx, params, orgTempTable, cacheFields);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### handleBizData end: " + (lstop - lstart)));
    }

    private String getInsertInitDataSQL(String tempTable) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,");
        insertSQL.append("FLot,FAssistPropertyID,FProjectID,FTrackNumberID,FBeginQty,FBeginAmt,FBeginAssQty)").append(NEWLINE);
        return insertSQL.toString();
    }

    private String getInsertBizDataSQL(String tempTable, CacheFields cacheFields) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append(NEWLINE);
        insertSQL.append("FBeginQty,FBeginAssQty,FBeginAmt,").append(NEWLINE);
        insertSQL.append("FCostAdjInAmt,FCostAdjOutAmt,FMoveInQty,FMoveInAssQty,FMoveInAmt,FMoveOutQty,FMoveOutAssQty,FMoveOutAmt,").append(NEWLINE);
        insertSQL.append("FStateAdjustInQty,FStateAdjustInAssQty,FStateAdjustOutQty,FStateAdjustOutAssQty,FDecomposeInQty,FDecomposeInAssQty,FDecomposeOutQty,FDecomposeOutAssQty").append(NEWLINE);
        String bizRISQL = this.getBizRITypeSQL(null, true, true, false, true, cacheFields);
        if (bizRISQL != null) {
            insertSQL.append(",").append(bizRISQL).append(NEWLINE);
        }
        insertSQL.append(")");
        return insertSQL.toString();
    }

    private String getInitDataSelectorSQL() {
        StringBuffer selector = new StringBuffer();
        selector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,").append(NEWLINE);
        selector.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,sum(tr.fri * et.FBaseQty) as FBeginQty,").append(NEWLINE);
        selector.append("sum(tr.fri * et.FActualCost) as FBeginAmt,isnull(sum(tr.fri * et.FAssistQty),0) as FBeginAssQty").append(NEWLINE);
        return selector.toString();
    }

    private String getBizBillDataSelectorSQL(CacheFields cacheFields) {
        StringBuffer selector = new StringBuffer();
        selector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,");
        selector.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,").append(NEWLINE);
        selector.append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append(NEWLINE);
        selector.append("0 as FCostAdjInAmt,0 as FCostAdjOutAmt,0 as FMoveInQty,0 as FMoveInAssQty,0 as FMoveInAmt,0 as FMoveOutQty,0 as FMoveOutAssQty,0 as FMoveOutAmt, ").append(NEWLINE);
        selector.append("0 as FStateAdjustInQty,0 as FStateAdjustInAssQty,0 as FStateAdjustOutQty,0 as FStateAdjustOutAssQty,0 as FDecomposeInQty,0 as FDecomposeInAssQty,0 as FDecomposeOutQty,0 as FDecomposeOutAssQty").append(NEWLINE);
        int index = cacheFields.riTypeIndex;
        String[] riTypeIDs = (String[])cacheFields.riTypeMap.get("riTypeIDs");
        if (riTypeIDs == null) {
            return selector.toString();
        }
        int len = riTypeIDs.length;
        for (int i = 0; i < len; ++i) {
            selector.append(", sum(case tr.FRITypeID when '").append(riTypeIDs[i]).append("' then isnull(et.FBaseQty,0) else 0 end) as ").append(cacheFields.riColName[index]).append(NEWLINE);
            selector.append(", sum(case tr.FRITypeID when '").append(riTypeIDs[i]).append("' then isnull(et.FAssistQty,0) else 0 end) as ").append(cacheFields.riColName[index + 1]).append(NEWLINE);
            selector.append(", sum(case tr.FRITypeID when '").append(riTypeIDs[i]).append("' then isnull(et.FActualCost,0) else 0 end) as ").append(cacheFields.riColName[index + 3]).append(NEWLINE);
            index += 4;
        }
        return selector.toString();
    }

    private String getInitBillDataWhereSQL(Context ctx, RptParams params, boolean isCostAdjBill, CacheFields cacheFields) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        Date dateFrom = (Date)params.getObject("dateFrom");
        sqlWhere.append(" where o.fisleaf = 1 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, cacheFields)).append(NEWLINE);
        sqlWhere.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        sqlWhere.append(" and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        if (isCostAdjBill) {
            sqlWhere.append(" and et.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        } else {
            sqlWhere.append(" and (ISNULL(h.fisinitbill, 0) = 0)").append(NEWLINE);
        }
        return sqlWhere.toString();
    }

    private String getBillStoreTypeWhereSQL(String tableName) {
        StringBuffer sqlWhere = new StringBuffer();
        if (this.invTableName[0][0].equals(tableName) || this.invTableName[2][0].equals(tableName) || this.invTableName[4][0].equals(tableName) || this.invTableName[6][0].equals(tableName)) {
            sqlWhere.append(" and ivt.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        }
        if (this.invTableName[1][0].equals(tableName) || this.invTableName[3][0].equals(tableName) || this.invTableName[5][0].equals(tableName) || this.invTableName[7][0].equals(tableName)) {
            sqlWhere.append(" and ivt.FStoreTypePreID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        }
        return sqlWhere.toString();
    }

    private String getBizBillDataWhereSQL(Context ctx, RptParams params, boolean isCostAdjBill, CacheFields cacheFields) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" where o.fisleaf = 1 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, cacheFields)).append(NEWLINE);
        sqlWhere.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        sqlWhere.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        if (isCostAdjBill) {
            sqlWhere.append(" and et.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        } else {
            sqlWhere.append(" and (ISNULL(h.fisinitbill, 0) = 0)").append(NEWLINE);
        }
        return sqlWhere.toString();
    }

    private String getGroupBySQL() {
        String groupByStr = " group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID";
        return groupByStr;
    }

    private String getBillStatusWhereSQL(RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        int coBoxBillStatus = 0;
        if (params.getObject("coBoxBillStatus") != null) {
            coBoxBillStatus = params.getInt("coBoxBillStatus");
        }
        if (coBoxBillStatus == 0) {
            sqlWhere.append(" and (h.fbasestatus = 2");
            sqlWhere.append(" or h.fbasestatus = 4");
            sqlWhere.append(" or h.fbasestatus = 7)");
        } else if (coBoxBillStatus == 1) {
            sqlWhere.append(" and (h.fbasestatus = 2)");
        } else if (coBoxBillStatus == 2) {
            sqlWhere.append(" and (h.fbasestatus = 4");
            sqlWhere.append(" or h.fbasestatus = 7)");
        }
        return sqlWhere.toString();
    }

    private String getBizBillDateWhereSQL(RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        Date dateFrom = (Date)params.getObject("dateFrom");
        Date dateTo = (Date)params.getObject("dateTo");
        sqlWhere.append(" and h.fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')");
        sqlWhere.append(" and h.fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate(dateTo)).append("')");
        return sqlWhere.toString();
    }

    private String getInitCostAdjBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer costAdjSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        costAdjSQL.append(this.getInsertInitDataSQL(tempTable));
        costAdjSQL.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,").append(NEWLINE);
        costAdjSQL.append("0 as FBeginQty,sum(case h.FCalculateKind when 1 then  -1* et.FAmount else et.FAmount end) as FBeginAmt,0 as FBeginAssQty").append(NEWLINE);
        costAdjSQL.append("from T_CL_CostAdjustBillEntry et").append(NEWLINE);
        costAdjSQL.append("inner join T_CL_CostAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        costAdjSQL.append(billJoinStr).append(NEWLINE);
        costAdjSQL.append(this.getInitBillDataWhereSQL(ctx, params, true, cacheFields)).append(NEWLINE);
        costAdjSQL.append(this.getGroupBySQL());
        return costAdjSQL.toString();
    }

    private String getBizCostAdjBillSelector(CacheFields cacheFields) {
        StringBuffer costAdjSelector = new StringBuffer();
        costAdjSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,").append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append("sum(case h.FCalculateKind when 1 then 0 else et.FAmount end) as FCostAdjInAmt,").append("sum(case h.FCalculateKind when 1 then et.FAmount else 0 end) as FCostAdjOutAmt, ").append("0 as FMoveInQty, ").append("0 as FMoveInAssQty, ").append("0 as FMoveInAmt, ").append("0 as FMoveOutQty, ").append("0 as FMoveOutAssQty, ").append("0 as FMoveOutAmt, ");
        costAdjSelector.append("0 as FStateAdjustInQty,");
        costAdjSelector.append("0 as FStateAdjustInAssQty,");
        costAdjSelector.append("0 as FStateAdjustOutQty,");
        costAdjSelector.append("0 as FStateAdjustOutAssQty, ");
        costAdjSelector.append("0 as FDecomposeInQty,");
        costAdjSelector.append("0 as FDecomposeInAssQty,");
        costAdjSelector.append("0 as FDecomposeOutQty,");
        costAdjSelector.append("0 as FDecomposeOutAssQty ");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            costAdjSelector.append(", 0 as ").append(cacheFields.riColName[i]);
            costAdjSelector.append(", 0 as ").append(cacheFields.riColName[i + 1]);
            costAdjSelector.append(", 0 as ").append(cacheFields.riColName[i + 3]).append(NEWLINE);
        }
        return costAdjSelector.toString();
    }

    private String getBizCostAdjBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer costAdjSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        costAdjSQL.append(this.getInsertBizDataSQL(tempTable, cacheFields));
        costAdjSQL.append(this.getBizCostAdjBillSelector(cacheFields)).append(NEWLINE);
        costAdjSQL.append("from T_CL_CostAdjustBillEntry et").append(NEWLINE);
        costAdjSQL.append("inner join T_CL_CostAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        costAdjSQL.append(billJoinStr);
        costAdjSQL.append(this.getBizBillDataWhereSQL(ctx, params, true, cacheFields)).append(NEWLINE);
        costAdjSQL.append(this.getGroupBySQL());
        return costAdjSQL.toString();
    }

    private String getInitMoveLocBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer moveLocSQL = new StringBuffer();
        Date dateFrom = (Date)params.getObject("dateFrom");
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        String sqlMoveWhere = this.buildParamWhereStr(ctx, params, cacheFields);
        moveLocSQL.append(this.getInsertInitDataSQL(tempTable));
        moveLocSQL.append("SELECT newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FReceiptLocationID,").append(NEWLINE);
        moveLocSQL.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,SUM(et.FBaseQty) as FBeginQty,SUM(et.FAmount) as FBeginAmt,SUM(et.FAssistQty ) as FBeginAssQty").append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join  T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr.replaceAll("et.FLocationID", "et.FReceiptLocationID"));
        moveLocSQL.append("where o.fisleaf = 1 ");
        moveLocSQL.append(sqlMoveWhere.replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        moveLocSQL.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL().replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(";").append(NEWLINE);
        moveLocSQL.append(this.getInsertInitDataSQL(tempTable));
        moveLocSQL.append("SELECT newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,").append(NEWLINE);
        moveLocSQL.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,(-1) * SUM(et.FBaseQty) as FBeginQty,(-1) * SUM(et.FAmount) as FBeginAmt,(-1) * SUM(et.FAssistQty) as FBeginAssQty").append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join  T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr);
        moveLocSQL.append("where o.fisleaf = 1 ");
        moveLocSQL.append(sqlMoveWhere).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        moveLocSQL.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL());
        return moveLocSQL.toString();
    }

    private String getBizMoveLocSelector(boolean isMoveIn, CacheFields cacheFields) {
        StringBuffer moveLocSelector = new StringBuffer();
        moveLocSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,").append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append("0 as FCostAdjInAmt,").append("0 as FCostAdjOutAmt,");
        if (isMoveIn) {
            moveLocSelector.append("SUM( et.FBaseQty ) as FMoveInQty,").append("SUM( et.FAssistQty ) as FMoveInAssQty,").append("SUM( et.FAmount ) as FMoveInAmt,").append("0 as FMoveOutQty,").append("0 as FMoveOutAssQty,").append("0 as FMoveOutAmt, ");
        } else {
            moveLocSelector.append("0 as FMoveInQty,").append("0 as FMoveInAssQty,").append("0 as FMoveInAmt,").append("SUM( et.FBaseQty ) as FMoveOutQty,").append("SUM( et.FAssistQty ) as FMoveOutAssQty, ").append("SUM( et.FAmount ) as FMoveOutAmt, ");
        }
        moveLocSelector.append("0 as FStateAdjustInQty,");
        moveLocSelector.append("0 as FStateAdjustInAssQty,");
        moveLocSelector.append("0 as FStateAdjustOutQty,");
        moveLocSelector.append("0 as FStateAdjustOutAssQty, ");
        moveLocSelector.append("0 as FDecomposeInQty,");
        moveLocSelector.append("0 as FDecomposeInAssQty,");
        moveLocSelector.append("0 as FDecomposeOutQty,");
        moveLocSelector.append("0 as FDecomposeOutAssQty ");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            moveLocSelector.append(", 0 as ").append(cacheFields.riColName[i]);
            moveLocSelector.append(", 0 as ").append(cacheFields.riColName[i + 1]);
            moveLocSelector.append(", 0 as ").append(cacheFields.riColName[i + 3]).append(NEWLINE);
        }
        return moveLocSelector.toString();
    }

    private String getBizMoveLocBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer moveLocSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        String sqlMoveWhere = this.buildParamWhereStr(ctx, params, cacheFields);
        moveLocSQL.append(this.getInsertBizDataSQL(tempTable, cacheFields));
        moveLocSQL.append(this.getBizMoveLocSelector(true, cacheFields).replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr.replaceAll("et.FLocationID", "et.FReceiptLocationID"));
        moveLocSQL.append("where o.fisleaf = 1");
        moveLocSQL.append(sqlMoveWhere.replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL().replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(";").append(NEWLINE);
        moveLocSQL.append(this.getInsertBizDataSQL(tempTable, cacheFields));
        moveLocSQL.append(this.getBizMoveLocSelector(false, cacheFields)).append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr);
        moveLocSQL.append("where o.fisleaf = 1");
        moveLocSQL.append(sqlMoveWhere).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL());
        return moveLocSQL.toString();
    }

    private void handleInitData(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        this.insertBeginDataForCombinTable(ctx, params, orgTempTable, this.getInsertInitDataSQL(tempTable), cacheFields);
        this.insertBeginDataForInitTable(ctx, params, orgTempTable, this.getInsertInitDataSQL(tempTable), cacheFields);
        this.insertBeginDataForInitTableNoStart(ctx, params, orgTempTable, this.getInsertInitDataSQL(tempTable), cacheFields);
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        int count = this.invTableName.length;
        String[] sqls = new String[count + 2];
        Boolean ckBxShowUpdateInventoryBill = params.getBoolean("ckBxShowUpdateInventoryBill");
        StringBuffer billBuff = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            billBuff.setLength(0);
            billBuff.append(this.getInsertInitDataSQL(tempTable));
            billBuff.append(this.getInitDataSelectorSQL());
            billBuff.append("from ").append(this.invTableName[i][1]).append(" et ").append(NEWLINE);
            billBuff.append("inner join ").append(this.invTableName[i][0]).append(" h on et.fparentid = h.fid").append(NEWLINE);
            billBuff.append("inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid").append(NEWLINE);
            billBuff.append("inner join T_IM_InvUpdateType ivt on ivt.fid = et.finvupdatetypeid").append(NEWLINE);
            if (ckBxShowUpdateInventoryBill.booleanValue()) {
                billBuff.append(" and ivt.FIsNotUpdateInv = 0").append(NEWLINE);
            }
            billBuff.append(billJoinStr);
            billBuff.append(this.getInitBillDataWhereSQL(ctx, params, false, cacheFields)).append(NEWLINE);
            billBuff.append(this.getBillStoreTypeWhereSQL(this.invTableName[i][0])).append(NEWLINE);
            billBuff.append(this.getGroupBySQL()).append(NEWLINE);
            sqls[i] = billBuff.toString();
        }
        sqls[count] = new StringBuffer().append(this.getInitCostAdjBillSQL(ctx, params, orgTempTable, cacheFields)).append(NEWLINE).toString();
        sqls[count + 1] = new StringBuffer().append(this.getInitMoveLocBillSQL(ctx, params, orgTempTable, cacheFields)).append(NEWLINE).toString();
        this.executeBatchUpdate(ctx, sqls);
    }

    private void insertBeginDataForCombinTable(Context ctx, RptParams params, String orgTempTable, String insertStr, CacheFields cacheFields) throws BOSException, EASBizException {
        Date dateTo;
        PeriodInfo dateToperiodInfo;
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### insertBeginDataForCombinTable start ");
        lstart = System.currentTimeMillis();
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'),-2 as FIndex,h.FCompanyOrgUnitID,h.FStorageOrgUnitID,h.FWarehouseID,");
        initSelector.append("h.FLocationID,h.FMaterialID,h.FLot,h.FAssistPropertyID,h.FProjectID,h.FTrackNumberID,");
        initSelector.append("sum(h.FPeriodBeginQty) as FBeginQty,");
        initSelector.append("sum(h.FPeriodBeginActualCost) as FBeginAmt,");
        initSelector.append("sum(h.FPERIODBEGINASSISTQTY) as FBeginAssQty ");
        initSelector.append("from T_IM_InventoryBalance h ");
        initSelector.append("inner join ").append(orgTempTable).append(" o on h.fstorageorgunitid = o.fid ");
        initSelector.append("and h.fyear = o.fbeginyear and h.fperiod = o.fbeginperiod ");
        String initJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, false, cacheFields);
        initJoinStr = initJoinStr.replaceAll("et\\.", "h\\.");
        if (initJoinStr.indexOf("T_BD_MaterialGroupDh.al") >= 0) {
            initJoinStr = initJoinStr.replace("T_BD_MaterialGroupDh.al", "T_BD_MaterialGroupDetial");
        }
        initSelector.append(initJoinStr);
        StringBuffer initExtendWhere = new StringBuffer();
        initExtendWhere.append(" where o.fisleaf = 1 and et.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("' ");
        initExtendWhere.append(this.buildParamWhereStr(ctx, params, cacheFields));
        Boolean ckBxIscalculate = (Boolean)params.getObject("ckBxIscalculate");
        if (!ckBxIscalculate.booleanValue()) {
            initExtendWhere.append(" and (h.FIscalculate = 1 )");
        }
        if ((dateToperiodInfo = IMRptUtils.getPeriodInfo(ctx, dateTo = (Date)params.getObject("dateTo"), this.getPeriodTypeId(ctx, orgTempTable))) != null) {
            initExtendWhere.append(" and (h.fyear * 100 + h.FPERIOD) <=  ").append(dateToperiodInfo.getPeriodYear() * 100 + dateToperiodInfo.getPeriodNumber());
        }
        String initSqlWhere = initExtendWhere.toString().replaceAll("et\\.", "h\\.");
        initSelector.append(initSqlWhere);
        initSelector.append(" Group by h.FCompanyOrgUnitID,h.FStorageOrgUnitID,h.FWarehouseID,h.FMaterialID,h.FLocationID,h.FLot,h.FAssistPropertyID,h.FProjectID,h.FTrackNumberID");
        this.executeSQL(ctx, initSelector.toString());
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertBeginDataForCombinTable end : " + (lstop - lstart)));
    }

    private void insertBeginDataForInitTable(Context ctx, RptParams params, String orgTempTable, String insertStr, CacheFields cacheFields) throws BOSException, EASBizException {
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### insertBeginDataForInitTable start ");
        lstart = System.currentTimeMillis();
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'),-2 as FIndex,h.FCompanyOrgUnitID,h.FStorageOrgUnitID,et.FWarehouseID,");
        initSelector.append("et.FLocationID,et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,");
        initSelector.append("sum(et.FBASEQTY) as FBeginQty,");
        initSelector.append("sum(et.FAMOUNT) as FBeginAmt,");
        initSelector.append("sum(et.FASSISTQTY) as FBeginAssQty ");
        initSelector.append("from T_IM_InventoryInitBill h ");
        initSelector.append("inner join T_IM_InventoryInitEntry et on h.fid = et.fparentid ");
        initSelector.append("inner join T_DB_SOAccreditWH wh1 on h.FStorageOrgUnitID = wh1.FSTORAGEORGID and et.FWarehouseID = wh1.FWAREHOUSEID ");
        initSelector.append("inner join  t_bd_period pe on wh1.FPERIODID = pe.fid ");
        initSelector.append("inner join ").append(orgTempTable).append(" o on h.fstorageorgunitid = o.fid ");
        String initJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, false, cacheFields);
        if (initJoinStr.indexOf("T_BD_MaterialGroupDh.al") >= 0) {
            initJoinStr = initJoinStr.replace("T_BD_MaterialGroupDh.al", "T_BD_MaterialGroupDetial");
        }
        initSelector.append(initJoinStr);
        StringBuffer initExtendWhere = new StringBuffer();
        initExtendWhere.append(" where o.fisleaf = 1 and et.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("' ");
        initExtendWhere.append(this.buildParamWhereStr(ctx, params, cacheFields));
        Date dateTo = (Date)params.getObject("dateTo");
        PeriodInfo dateToperiodInfo = IMRptUtils.getPeriodInfo(ctx, dateTo);
        initExtendWhere.append(" ");
        initExtendWhere.append(" and (o.fbeginyear * 100 + o.fbeginperiod <   pe.FPERIODYear * 100 + pe.FPERIODNUMBER ) ");
        if (dateToperiodInfo != null) {
            initExtendWhere.append(" and ( pe.FPERIODYear * 100 + pe.FPERIODNUMBER <=  ").append(dateToperiodInfo.getPeriodYear() * 100 + dateToperiodInfo.getPeriodNumber()).append(" ) ");
        }
        String initSqlWhere = initExtendWhere.toString();
        initSelector.append(initSqlWhere);
        initSelector.append(" Group by h.FCompanyOrgUnitID,h.FStorageOrgUnitID,et.FWarehouseID,et.FMaterialID,et.FLocationID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID");
        this.executeSQL(ctx, initSelector.toString());
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertBeginDataForInitTable end : " + (lstop - lstart)));
    }

    private void insertBeginDataForInitTableNoStart(Context ctx, RptParams params, String orgTempTable, String insertStr, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'), -2 as FIndex, h.FCompanyOrgUnitID, h.FStorageOrgUnitID, et.FWarehouseID, ");
        initSelector.append("et.FLocationID, et.FMaterialID, et.FLot, et.FAssistPropertyID, et.FProjectID, et.FTrackNumberID, ");
        initSelector.append("sum(et.FBASEQTY) as FBeginQty, ");
        initSelector.append("sum(et.FAMOUNT) as FBeginAmt, ");
        initSelector.append("sum(et.FASSISTQTY) as FBeginAssQty ");
        initSelector.append("from T_IM_InventoryInitBill h ");
        initSelector.append("inner join T_IM_InventoryInitEntry et on h.fid = et.fparentid ");
        initSelector.append("inner join T_DB_SOAccreditWH wh1 on et.FStorageOrgUnitID = wh1.FSTORAGEORGID and et.FWarehouseID = wh1.FWAREHOUSEID ");
        initSelector.append("inner join ").append(orgTempTable).append(" o on h.fstorageorgunitid = o.fid ");
        String initJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, false, cacheFields);
        if (initJoinStr.indexOf("T_BD_MaterialGroupDh.al") >= 0) {
            initJoinStr = initJoinStr.replace("T_BD_MaterialGroupDh.al", "T_BD_MaterialGroupDetial");
        }
        initSelector.append(initJoinStr);
        StringBuffer initExtendWhere = new StringBuffer();
        initExtendWhere.append(" where o.fisleaf = 1 and h.fbasestatus = 4 and  et.FStoreTypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("' ");
        initExtendWhere.append(this.buildParamWhereStr(ctx, params, cacheFields));
        Date dateFrom = (Date)params.getObject("dateFrom");
        Date dateTo = (Date)params.getObject("dateTo");
        initExtendWhere.append(" and h.fbizdate >= to_date('").append(IMRptUtils.getFmtDate(dateFrom)).append("')");
        initExtendWhere.append(" and h.fbizdate <= to_date('").append(IMRptUtils.getFmtDate(dateTo)).append("')");
        initExtendWhere.append(" and wh1.fisstarted = 0 ");
        String initSqlWhere = initExtendWhere.toString();
        initSelector.append(initSqlWhere);
        initSelector.append(" Group by h.FCompanyOrgUnitID, h.FStorageOrgUnitID, et.FWarehouseID, et.FMaterialID, et.FLocationID, et.FLot, et.FAssistPropertyID, et.FProjectID, et.FTrackNumberID");
        this.executeSQL(ctx, initSelector.toString());
    }

    private String buildParamWhereStr(Context ctx, RptParams params, CacheFields cacheFields) throws BOSException {
        String querySql;
        String txtLotLike;
        String querySql2;
        StringBuffer sqlWhere = new StringBuffer();
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        if (params.getObject("materialFrom") != null) {
            querySql2 = this.getParamFromQuerySql(params.getObject("materialFrom"), "m.fnumber", MaterialInfo.class, "getNumber");
            sqlWhere.append(querySql2);
        }
        if (params.getObject("materialTo") != null) {
            querySql2 = RptParamSqlUtil.getQuerySql("m.fnumber", params.getObject("materialTo"), MaterialInfo.class, "getNumber", CompareType.LESS_EQUALS);
            sqlWhere.append(querySql2);
        }
        if (ckBxShowMShortName.booleanValue()) {
            String txtMShortNameFrom = (String)params.getObject("shortNameFrom");
            String txtMShortNameTo = (String)params.getObject("shortNameTo");
            if (txtMShortNameFrom != null && txtMShortNameFrom.trim().length() > 0) {
                if (txtMShortNameFrom.indexOf("'") != -1) {
                    txtMShortNameFrom = txtMShortNameFrom.replaceAll("'", "''");
                }
                sqlWhere.append("and m.FShortName >= '").append(txtMShortNameFrom.trim()).append("' ");
            }
            if (txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                if (txtMShortNameTo.indexOf("'") != -1) {
                    txtMShortNameTo = txtMShortNameTo.replaceAll("'", "''");
                }
                sqlWhere.append("and m.FShortName <= '").append(txtMShortNameTo.trim()).append("' ").append(NEWLINE);
            }
        }
        if (params.getObject("warehouseFrom") != null) {
            querySql2 = this.getParamFromQuerySql(params.getObject("warehouseFrom"), "wh.FNumber", WarehouseInfo.class, "getNumber");
            sqlWhere.append(querySql2);
        }
        if (params.getObject("warehouseTo") != null) {
            String warehouseNumber = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            sqlWhere.append("and wh.FNumber <= '" + warehouseNumber + "' ").append(NEWLINE);
        }
        if (cacheFields.matpermSql != null && cacheFields.matpermSql.length() > 0) {
            sqlWhere.append(cacheFields.matpermSql);
        }
        if (cacheFields.warepermSql != null && cacheFields.warepermSql.length() > 0) {
            sqlWhere.append(cacheFields.warepermSql);
        }
        if (params.getObject("locationFrom") != null) {
            querySql2 = this.getParamFromQuerySql(params.getObject("locationFrom"), "lo.FNumber", LocationInfo.class, "getNumber");
            sqlWhere.append(querySql2);
        }
        if (params.getObject("locationTo") != null) {
            String locationTo = ((LocationInfo)params.getObject("locationTo")).getNumber();
            sqlWhere.append("and lo.FNumber <= '" + locationTo + "' ").append(NEWLINE);
        }
        String txtLotFrom = (String)params.getObject("lotFrom");
        String txtLotTo = (String)params.getObject("lotTo");
        if (txtLotFrom != null && txtLotFrom.trim().length() > 0) {
            sqlWhere.append("and et.FLot >= '").append(txtLotFrom).append("' ");
        }
        if (txtLotTo != null && txtLotTo.trim().length() > 0) {
            sqlWhere.append("and et.FLot <= '").append(txtLotTo).append("' ").append(NEWLINE);
        }
        if ((txtLotLike = (String)params.getObject("txtLotLike")) != null && txtLotLike.trim().length() > 0) {
            sqlWhere.append(" and et.FLot like '%").append(txtLotLike).append("%'").append(NEWLINE);
        }
        if (params.getObject("projectNumFrom") != null) {
            querySql = this.getParamFromQuerySql(params.getObject("projectNumFrom"), "project.fnumber");
            sqlWhere.append(querySql);
        }
        if (params.getObject("projectNumTo") != null && !params.getString("projectNumTo").trim().equals("")) {
            sqlWhere.append("and project.fnumber <= '" + (String)params.getObject("projectNumTo") + "' ");
        }
        if (params.getObject("trackNumFrom") != null) {
            querySql = this.getParamFromQuerySql(params.getObject("trackNumFrom"), "track.fnumber");
            sqlWhere.append(querySql);
        }
        if (params.getObject("trackNumTo") != null && !params.getString("trackNumTo").trim().equals("")) {
            sqlWhere.append("and track.fnumber <= '" + (String)params.getObject("trackNumTo") + "' ");
        }
        if (params.getObject("asstAttrFrom") != null) {
            querySql = this.getParamFromQuerySql(params.getObject("asstAttrFrom"), "asst.FNumber", AsstAttrValueInfo.class, "getNumber");
            sqlWhere.append(querySql);
        }
        if (params.getObject("asstAttrTo") != null) {
            String asstAttrTo = ((AsstAttrValueInfo)params.getObject("asstAttrTo")).getNumber();
            sqlWhere.append("and asst.FNumber <= '" + asstAttrTo + "' ").append(NEWLINE);
        }
        sqlWhere.append(this.getMaterialTypeWhere(ctx, params));
        return sqlWhere.toString();
    }

    private String getMaterialTypeWhere(Context ctx, RptParams params) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        String materialTypeTo = null;
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getLongNumber();
        }
        if (params.getObject("materialTypeFrom") != null || materialTypeTo != null) {
            StringBuffer sql22 = new StringBuffer();
            if (params.getObject("materialTypeFrom") != null) {
                String querySql = this.getMaterialGroupQuerySql(params.getObject("materialTypeFrom"), "g.flongnumber", true);
                sql22.append(querySql);
            }
            if (materialTypeTo != null) {
                if (params.getObject("materialTypeFrom") != null) {
                    sql22.append("and ");
                }
                sql22.append("(g.flongnumber <= '").append(materialTypeTo).append("' ");
                sql22.append(" or g.flongnumber like '").append(materialTypeTo).append("!%')");
            }
            sqlWhere.append(" and (").append(sql22).append(") ");
        }
        return sqlWhere.toString();
    }

    private void handleBizData(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException, EASBizException {
        StringBuffer billBuff = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        int count = this.invTableName.length;
        Boolean ckBxShowUpdateInventoryBill = params.getBoolean("ckBxShowUpdateInventoryBill");
        String[] sqls = new String[count + 4];
        for (int i = 0; i < count; ++i) {
            billBuff.setLength(0);
            billBuff.append(this.getInsertBizDataSQL(tempTable, cacheFields));
            billBuff.append(this.getBizBillDataSelectorSQL(cacheFields));
            billBuff.append("from ").append(this.invTableName[i][1]).append(" et ").append(NEWLINE);
            billBuff.append("inner join ").append(this.invTableName[i][0]).append(" h on et.fparentid = h.fid").append(NEWLINE);
            billBuff.append("inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid").append(NEWLINE);
            billBuff.append("inner join T_IM_InvUpdateType ivt on ivt.fid = et.finvupdatetypeid").append(NEWLINE);
            if (ckBxShowUpdateInventoryBill.booleanValue()) {
                billBuff.append(" and ivt.FIsNotUpdateInv = 0").append(NEWLINE);
            }
            billBuff.append(billJoinStr);
            billBuff.append(this.getBizBillDataWhereSQL(ctx, params, false, cacheFields)).append(NEWLINE);
            billBuff.append(this.getBillStoreTypeWhereSQL(this.invTableName[i][0])).append(NEWLINE);
            sqls[i] = billBuff.append(this.getGroupBySQL()).append(NEWLINE).toString();
        }
        sqls[count] = new StringBuffer().append(this.getBizCostAdjBillSQL(ctx, params, orgTempTable, cacheFields)).append(NEWLINE).toString();
        sqls[count + 1] = new StringBuffer().append(this.getBizMoveLocBillSQL(ctx, params, orgTempTable, cacheFields)).toString();
        sqls[count + 2] = new StringBuffer().append(this.getBizInvStateAdjustBillSQL(ctx, params, orgTempTable, cacheFields)).append(NEWLINE).toString();
        sqls[count + 3] = new StringBuffer().append(this.getBizDecomposeBillSQL(ctx, params, orgTempTable, cacheFields)).append(NEWLINE).toString();
        this.executeBatchUpdate(ctx, sqls);
    }

    private String builderJoinSqlBuffer(String orgTempTable, RptParams params, boolean isJoinOrgTable, CacheFields cacheFields) {
        StringBuffer billJoinBuff = new StringBuffer();
        if (isJoinOrgTable) {
            billJoinBuff.append("inner join ").append(orgTempTable).append(" o on  h.fstorageorgunitid = o.fid ").append(NEWLINE);
        }
        String materialTypeTo = null;
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getNumber();
        }
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        if (params.getObject("materialTypeFrom") != null || materialTypeTo != null || params.getObject("materialFrom") != null || params.getObject("materialTo") != null || params.getObject("shortNameFrom") != null && params.getObject("shortNameFrom").toString().length() > 0 || params.getObject("shortNameTo") != null && params.getObject("shortNameTo").toString().length() > 0 || cacheFields.matpermSql != null && cacheFields.matpermSql.length() > 0) {
            billJoinBuff.append("inner join t_bd_material m on et.fmaterialid = m.fid ").append(NEWLINE);
            if (params.getObject("materialTypeFrom") != null || materialTypeTo != null) {
                billJoinBuff.append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'").append(NEWLINE);
                billJoinBuff.append(" left join T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID ").append(NEWLINE);
            }
        }
        if (cacheFields.hMatPermJoinSql != null) {
            billJoinBuff.append(cacheFields.hMatPermJoinSql);
        }
        if (params.getObject("warehouseFrom") != null || params.getObject("warehouseTo") != null || cacheFields.warepermSql != null) {
            billJoinBuff.append("left join t_db_warehouse wh on et.fwarehouseid = wh.fid ").append(NEWLINE);
            if (cacheFields.hWarePermJoinSql != null) {
                billJoinBuff.append(cacheFields.hWarePermJoinSql);
            }
        }
        if (params.getObject("locationFrom") != null || params.getObject("locationTo") != null) {
            billJoinBuff.append("left join t_db_location lo on et.FLocationID = lo.fid ").append(NEWLINE);
        }
        if (params.getObject("asstAttrFrom") != null || params.getObject("asstAttrTo") != null) {
            billJoinBuff.append("inner join t_bd_asstattrvalue asst on et.FAssistPropertyID = asst.fid ").append(NEWLINE);
        }
        if (params.getObject("projectNumFrom") != null || params.getObject("projectNumTo") != null && !params.getString("projectNumTo").trim().equals("")) {
            billJoinBuff.append("left join T_MM_Project project on et.FProjectID = project.FID ").append(NEWLINE);
        }
        if (params.getObject("trackNumFrom") != null || params.getObject("trackNumTo") != null && !params.getString("trackNumTo").trim().equals("")) {
            billJoinBuff.append("left join T_MM_TrackNumber track on et.FTrackNumberID = track.FID ").append(NEWLINE);
        }
        return billJoinBuff.toString();
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        int[] nArray;
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            SQLThreadPool sqlExecute = new SQLThreadPool(ctx);
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                ps.addBatch(sqls[i]);
                sqlExecute.addSQL(sqls[i]);
            }
            sqlExecute.startWorker();
            nArray = null;
        }
        catch (Exception e) {
            try {
                throw new BOSException("sqlBatch execute exception : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
        this.close(con, ps);
        return nArray;
    }

    private String getPeriodTypeId(Context ctx, String orgTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct d.FAccountPeriodID from " + orgTempTable + " a ").append(" inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid").append(" inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID").append(" inner join t_org_company d on  b.ftounitid = d.fid ").append(" where c.FFromType = ").append(4).append(" and c.FToType = ").append(1);
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        String result = null;
        if (rs.next()) {
            result = rs.getString("FAccountPeriodID");
        }
        return result;
    }

    @Override
    protected RptRowSet _calFootRow(Context ctx, RptParams params) throws BOSException, EASBizException {
        CacheFields cacheFields = new CacheFields();
        HashMap<String, String> resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, resMap);
        this.initRITypeColName(ctx, params, cacheFields);
        StringBuffer sql = new StringBuffer(this.querySql(params, cacheFields));
        sql.append("where flevel = 1 and FStorageOrgName = 'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz'");
        sql.append(" order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FAssistProperty,FId ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        return rs;
    }

    @Override
    protected Map _verifyData(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map.get("isCUCheck") != null) {
            Set ids = (Set)map.get("cuids");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            view.setFilter(filter);
            FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
            if (col.size() > 1) {
                result.put("isCUCheck", Boolean.FALSE);
            } else {
                result.put("isCUCheck", Boolean.TRUE);
            }
            return result;
        }
        if (map.get("Period") != null) {
            result.put("Period", IMRptUtils.getPeriodInfo(ctx, (Date)map.get("Period")));
        }
        HashMap orgUnit = new HashMap();
        if (map.get("StorageOrgUnit") != null) {
            result.put("StorageOrgUnit", this.checkSameCurrencyAndPeriodType(ctx, (Set)map.get("StorageOrgUnit"), orgUnit));
            result.put("orgUnit", orgUnit);
        }
        return result;
    }

    private String checkSameCurrencyAndPeriodType(Context ctx, Set storageOrgIDs, Map orgUnit) throws BOSException {
        if (CollectionUtil.isEmpty((Collection)storageOrgIDs)) {
            return null;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        HashMap<String, String> relationMap = new HashMap<String, String>();
        oql.append("select toUnit.id,fromUnit.id where fromUnit.id in (");
        Iterator it = storageOrgIDs.iterator();
        String id = null;
        boolean isFirst = true;
        while (it.hasNext()) {
            id = (String)it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                oql.append(",");
            }
            oql.append("'").append(id).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl.size() == 0) {
            return "StorageNoAssignCompany";
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        oql = new StringBuffer();
        oql.append("select  id,name,number,baseCurrency.id,isLeaf,accountPeriodType.id where id in (");
        int size = orgRelColl.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            FullOrgUnitInfo toOrgUnit = orgRelColl.get(i).getToUnit();
            relationMap.put(toOrgUnit.getId().toString(), orgRelColl.get(i).getFromUnit().getId().toString());
            oql.append("'").append(toOrgUnit.getId().toString()).append("'");
        }
        oql.append(") order by number");
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        CompanyOrgUnitInfo firstCompanyOrgInfo = null;
        int size2 = companyColl.size();
        for (int i = 0; i < size2; ++i) {
            CompanyOrgUnitInfo companyOrgInfo = companyColl.get(i);
            if (!companyOrgInfo.isIsLeaf()) continue;
            if (firstCompanyOrgInfo == null) {
                firstCompanyOrgInfo = companyOrgInfo;
            }
            if (!firstCompanyOrgInfo.getAccountPeriodType().getId().toString().equals(companyOrgInfo.getAccountPeriodType().getId().toString())) {
                orgUnit.put("org_1", relationMap.get(firstCompanyOrgInfo.getId().toString()));
                orgUnit.put("org_2", relationMap.get(companyOrgInfo.getId().toString()));
                return "DIFF_COMORG_PERIODTYPE";
            }
            if (firstCompanyOrgInfo.getBaseCurrency().getId().toString().equals(companyOrgInfo.getBaseCurrency().getId().toString())) continue;
            orgUnit.put("org_1", relationMap.get(firstCompanyOrgInfo.getId().toString()));
            orgUnit.put("org_2", relationMap.get(companyOrgInfo.getId().toString()));
            return "DIFF_COMORG_CUR";
        }
        return null;
    }

    private void initRITypeColName(Context ctx, RptParams params, CacheFields cacheFields) throws BOSException {
        int i;
        String[] colNameBegin = new String[]{"FBeginQty", "FBeginAssQty", "FBeginPrice", "FBeginAmt", "FriInQty", "FriInAssQty", "FriInPrice", "FriInAmt"};
        String[] colNameInOut = new String[]{"FCostAdjInAmt", "FMoveInQty", "FMoveInAssQty", "FMoveInPrice", "FMoveInAmt", "FStateAdjustInQty", "FStateAdjustInAssQty", "FDecomposeInQty", "FDecomposeInAssQty", "FriOutQty", "FriOutAssQty", "FriOutPrice", "FriOutAmt"};
        String[] colNameEnd = new String[]{"FCostAdjOutAmt", "FMoveOutQty", "FMoveOutAssQty", "FMoveOutPrice", "FMoveOutAmt", "FStateAdjustOutQty", "FStateAdjustOutAssQty", "FDecomposeOutQty", "FDecomposeOutAssQty", "FEndQty", "FEndAssQty", "FEndPrice", "FEndAmt"};
        String[] colBlockNameBegin = new String[]{"beginInvQty", "riIn"};
        String[] colBlockNameInOut = new String[]{"CostAdjIn", "MoveIn", "StateAdjustIn", "DecomposeIn", "riOut"};
        String[] colBlockNameEnd = new String[]{"CostAdjOut", "MoveOut", "StateAdjustOut", "DecomposeOut", "endInvQty"};
        int colLen = colNameBegin.length + colNameInOut.length + colNameEnd.length;
        int colBlockLen = colBlockNameBegin.length + colBlockNameInOut.length + colBlockNameEnd.length;
        this.initRITypeFlag(params, cacheFields);
        Object[] riType = (Object[])params.getObject("RIType");
        if (cacheFields.isShowAllRIType) {
            RecIssueTypeCollection col = RecIssueTypeFactory.getLocalInstance((Context)ctx).getRecIssueTypeCollection();
            riType = col.toArray();
            params.setBoolean("ckBxCostAdjIn", true);
            params.setBoolean("ckBxCostAdjOut", true);
            params.setBoolean("ckBxLocIn", true);
            params.setBoolean("ckBxLocOut", true);
            params.setBoolean("ckBxStatusAdjIn", true);
            params.setBoolean("ckBxStatusAdjOut", true);
            params.setBoolean("ckBxDecomposeIn", true);
            params.setBoolean("ckBxDecomposeOut", true);
        }
        RecIssueTypeInfo riTypeInfo = null;
        ArrayList<RecIssueTypeInfo> riTypeIn = new ArrayList<RecIssueTypeInfo>();
        ArrayList<RecIssueTypeInfo> riTypeOut = new ArrayList<RecIssueTypeInfo>();
        RecIssueTypeCollection riCol = new RecIssueTypeCollection();
        if (riType != null) {
            int i2;
            int len = riType.length;
            for (i2 = 0; i2 < len; ++i2) {
                riCol.add((RecIssueTypeInfo)riType[i2]);
            }
            riCol.sort("number");
            int size = riCol.size();
            for (i2 = 0; i2 < size; ++i2) {
                riTypeInfo = riCol.get(i2);
                if (RIEnum.Receive == riTypeInfo.getRI()) {
                    riTypeIn.add(riCol.get(i2));
                    continue;
                }
                if (RIEnum.Issue != riTypeInfo.getRI()) continue;
                riTypeOut.add(riCol.get(i2));
            }
        }
        if (riType != null) {
            colLen += (riTypeIn.size() + riTypeOut.size()) * 4;
            colBlockLen += riTypeIn.size() + riTypeOut.size();
        }
        cacheFields.riTypeIndex = colNameBegin.length + colNameInOut.length + colNameEnd.length;
        cacheFields.riColName = new String[colLen];
        cacheFields.riColHeaderName = new String[colLen];
        cacheFields.riColBlockName = new String[colBlockLen];
        int index = 0;
        int blockIndex = 0;
        int headIndex = 0;
        ArrayList<String> riTypeInQty = new ArrayList<String>();
        ArrayList<String> riTypeInAssQty = new ArrayList<String>();
        ArrayList<String> riTypeInAmt = new ArrayList<String>();
        ArrayList<String> riTypeOutQty = new ArrayList<String>();
        ArrayList<String> riTypeOutAssQty = new ArrayList<String>();
        ArrayList<String> riTypeOutAmt = new ArrayList<String>();
        ArrayList<String> riTypeIDs = new ArrayList<String>();
        HashMap resMap = (HashMap)params.getObject(this.resMapStr);
        int len = colNameBegin.length;
        for (int i3 = 0; i3 < len; ++i3) {
            cacheFields.riColHeaderName[headIndex] = colNameBegin[i3];
            ++headIndex;
            cacheFields.riColName[index] = colNameBegin[i3];
            ++index;
        }
        for (String cacheFields.riColName[index] : colNameInOut) {
            ++index;
        }
        for (String cacheFields.riColName[index] : colNameEnd) {
            ++index;
        }
        for (String cacheFields.riColBlockName[blockIndex] : colBlockNameBegin) {
            ++blockIndex;
        }
        int number = 0;
        int size = riTypeIn.size();
        for (i = 0; i < size; ++i) {
            riTypeInfo = (RecIssueTypeInfo)riTypeIn.get(i);
            riTypeIDs.add(riTypeInfo.getId().toString());
            cacheFields.riColHeaderName[headIndex] = "FRITypeQty" + number;
            cacheFields.riColHeaderName[headIndex + 1] = "FRITypeAssQty" + number;
            cacheFields.riColHeaderName[headIndex + 2] = "FRITypePrice" + number;
            cacheFields.riColHeaderName[headIndex + 3] = "FRITypeAmt" + number;
            riTypeInQty.add(cacheFields.riColHeaderName[headIndex]);
            riTypeInAssQty.add(cacheFields.riColHeaderName[headIndex + 1]);
            riTypeInAmt.add(cacheFields.riColHeaderName[headIndex + 3]);
            cacheFields.riColName[index] = cacheFields.riColHeaderName[headIndex];
            cacheFields.riColName[index + 1] = cacheFields.riColHeaderName[headIndex + 1];
            cacheFields.riColName[index + 2] = cacheFields.riColHeaderName[headIndex + 2];
            cacheFields.riColName[index + 3] = cacheFields.riColHeaderName[headIndex + 3];
            headIndex += 4;
            index += 4;
            cacheFields.riColBlockName[blockIndex] = "FRITypeQty" + number;
            cacheFields.riTypeColMap.put("FRITypeQty" + number, riTypeInfo.getId().toString());
            resMap.put(cacheFields.riColBlockName[blockIndex], riTypeInfo.getName());
            ++blockIndex;
            ++number;
        }
        for (String cacheFields.riColHeaderName[headIndex] : colNameInOut) {
            ++headIndex;
        }
        int len2 = colBlockNameInOut.length;
        for (i = 0; i < len2; ++i) {
            cacheFields.riColBlockName[blockIndex] = colBlockNameInOut[i];
            ++blockIndex;
        }
        size = riTypeOut.size();
        for (i = 0; i < size; ++i) {
            riTypeInfo = (RecIssueTypeInfo)riTypeOut.get(i);
            riTypeIDs.add(riTypeInfo.getId().toString());
            cacheFields.riColHeaderName[headIndex] = "FRITypeQty" + number;
            cacheFields.riColHeaderName[headIndex + 1] = "FRITypeAssQty" + number;
            cacheFields.riColHeaderName[headIndex + 2] = "FRITypePrice" + number;
            cacheFields.riColHeaderName[headIndex + 3] = "FRITypeAmt" + number;
            riTypeOutQty.add(cacheFields.riColHeaderName[headIndex]);
            riTypeOutAssQty.add(cacheFields.riColHeaderName[headIndex + 1]);
            riTypeOutAmt.add(cacheFields.riColHeaderName[headIndex + 3]);
            cacheFields.riColName[index] = cacheFields.riColHeaderName[headIndex];
            cacheFields.riColName[index + 1] = cacheFields.riColHeaderName[headIndex + 1];
            cacheFields.riColName[index + 2] = cacheFields.riColHeaderName[headIndex + 2];
            cacheFields.riColName[index + 3] = cacheFields.riColHeaderName[headIndex + 3];
            headIndex += 4;
            index += 4;
            cacheFields.riColBlockName[blockIndex] = "FRITypeQty" + number;
            cacheFields.riTypeColMap.put("FRITypeQty" + number, riTypeInfo.getId().toString());
            resMap.put(cacheFields.riColBlockName[blockIndex], riTypeInfo.getName());
            ++blockIndex;
            ++number;
        }
        for (String cacheFields.riColHeaderName[headIndex] : colNameEnd) {
            ++headIndex;
        }
        for (String cacheFields.riColBlockName[blockIndex] : colBlockNameEnd) {
            ++blockIndex;
        }
        cacheFields.riTypeMap.put("riTypeIDs", riTypeIDs.toArray(new String[0]));
        cacheFields.riTypeMap.put("riTypeInQty", riTypeInQty);
        cacheFields.riTypeMap.put("riTypeInAssQty", riTypeInAssQty);
        cacheFields.riTypeMap.put("riTypeInAmt", riTypeInAmt);
        cacheFields.riTypeMap.put("riTypeOutQty", riTypeOutQty);
        cacheFields.riTypeMap.put("riTypeOutAssQty", riTypeOutAssQty);
        cacheFields.riTypeMap.put("riTypeOutAmt", riTypeOutAmt);
    }

    private String getBizRITypeSQL(String tableName, boolean isQty, boolean isAssQty, boolean isPrice, boolean isAmt, CacheFields cacheFields) {
        StringBuffer sql = new StringBuffer();
        String alias = tableName == null ? "" : tableName;
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            if (isQty) {
                sql.append(alias).append(cacheFields.riColName[i]).append(",");
            }
            if (isAssQty) {
                sql.append(alias).append(cacheFields.riColName[i + 1]).append(",");
            }
            if (isPrice) {
                sql.append(alias).append(cacheFields.riColName[i + 2]).append(",");
            }
            if (!isAmt) continue;
            sql.append(alias).append(cacheFields.riColName[i + 3]).append(",");
        }
        if (sql.length() > 0) {
            sql.setLength(sql.length() - 1);
            return sql.toString();
        }
        return null;
    }

    private String getSQL4UpdateEnd(ArrayList in, ArrayList out) {
        int i;
        int size;
        StringBuffer sql = new StringBuffer();
        if (in != null) {
            size = in.size();
            for (i = 0; i < size; ++i) {
                sql.append(" + ").append(in.get(i));
            }
        }
        if (out != null) {
            size = out.size();
            for (i = 0; i < size; ++i) {
                sql.append(" - ").append(out.get(i));
            }
        }
        if (sql.length() == 0) {
            return null;
        }
        return sql.toString();
    }

    private void initRITypeFlag(RptParams params, CacheFields cacheFields) {
        boolean hasRiType = false;
        Object[] riType = (Object[])params.getObject("RIType");
        if (riType != null && riType.length > 0) {
            hasRiType = true;
        }
        cacheFields.isShowAllRIType = !params.getBoolean("ckBxCostAdjIn") && !params.getBoolean("ckBxCostAdjOut") && !params.getBoolean("ckBxLocIn") && !params.getBoolean("ckBxLocOut") && !params.getBoolean("ckBxStatusAdjIn") && !params.getBoolean("ckBxStatusAdjOut") && !params.getBoolean("ckBxDecomposeIn") && !params.getBoolean("ckBxDecomposeOut") && !hasRiType;
    }

    private String getInitInvStateAdjustBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer invStateAdjustSql = new StringBuffer();
        return invStateAdjustSql.toString();
    }

    private String getBizInvStateAdjustBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer invStateAdjustSql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        String sqlMoveWhere = this.buildParamWhereStr(ctx, params, cacheFields);
        invStateAdjustSql.append(this.getInsertBizDataSQL(tempTable, cacheFields));
        invStateAdjustSql.append(this.getBizInvStateAdjustSelector(cacheFields)).append(NEWLINE);
        invStateAdjustSql.append("from T_IM_InvstateAdjustBillEntry et").append(NEWLINE);
        invStateAdjustSql.append("inner join T_IM_InvstateAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        invStateAdjustSql.append(billJoinStr);
        invStateAdjustSql.append("where o.fisleaf = 1");
        invStateAdjustSql.append(sqlMoveWhere).append(NEWLINE);
        invStateAdjustSql.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        invStateAdjustSql.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        invStateAdjustSql.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        invStateAdjustSql.append(this.getGroupBySQL());
        return invStateAdjustSql.toString();
    }

    private String getBizInvStateAdjustSelector(CacheFields cacheFields) {
        StringBuffer invStateAdjustSelector = new StringBuffer();
        invStateAdjustSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,");
        invStateAdjustSelector.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,");
        invStateAdjustSelector.append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,");
        invStateAdjustSelector.append("0 as FCostAdjInAmt,");
        invStateAdjustSelector.append("0 as FCostAdjOutAmt,");
        invStateAdjustSelector.append("0 as FMoveInQty,");
        invStateAdjustSelector.append("0 as FMoveInAssQty,");
        invStateAdjustSelector.append("0 as FMoveInAmt, ");
        invStateAdjustSelector.append("0 as FMoveOutQty,");
        invStateAdjustSelector.append("0 as FMoveOutAssQty, ");
        invStateAdjustSelector.append("0 as FMoveOutAmt, ");
        invStateAdjustSelector.append("SUM( et.FBaseQty ) as FStateAdjustInQty,");
        invStateAdjustSelector.append("SUM( et.FAssistQty ) as FStateAdjustInAssQty,");
        invStateAdjustSelector.append("SUM( et.FBaseQty ) as FStateAdjustOutQty,");
        invStateAdjustSelector.append("SUM( et.FAssistQty ) as FStateAdjustOutAssQty, ");
        invStateAdjustSelector.append("0 as FDecomposeInQty,");
        invStateAdjustSelector.append("0 as FDecomposeInAssQty,");
        invStateAdjustSelector.append("0 as FDecomposeOutQty,");
        invStateAdjustSelector.append("0 as FDecomposeOutAssQty ");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            invStateAdjustSelector.append(", 0 as ").append(cacheFields.riColName[i]);
            invStateAdjustSelector.append(", 0 as ").append(cacheFields.riColName[i + 1]);
            invStateAdjustSelector.append(", 0 as ").append(cacheFields.riColName[i + 3]).append(NEWLINE);
        }
        return invStateAdjustSelector.toString();
    }

    private String getInitDecomposeBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer invDecomposeSql = new StringBuffer();
        return invDecomposeSql.toString();
    }

    private String getBizDecomposeBillSQL(Context ctx, RptParams params, String orgTempTable, CacheFields cacheFields) throws BOSException {
        StringBuffer invDecomposeSql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true, cacheFields);
        String sqlWhere = this.buildParamWhereStr(ctx, params, cacheFields);
        invDecomposeSql.append(this.getInsertBizDataSQL(tempTable, cacheFields));
        invDecomposeSql.append(this.getBizDecomposeSelector(cacheFields)).append(NEWLINE);
        invDecomposeSql.append("from T_IM_DecomposeEntry et").append(NEWLINE);
        invDecomposeSql.append("inner join T_IM_DecomposeBill h on et.fparentid = h.fid").append(NEWLINE);
        invDecomposeSql.append(billJoinStr);
        invDecomposeSql.append("where o.fisleaf = 1");
        invDecomposeSql.append(sqlWhere).append(NEWLINE);
        invDecomposeSql.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        invDecomposeSql.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        invDecomposeSql.append("and et.FStoretypeID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'").append(NEWLINE);
        invDecomposeSql.append(this.getGroupBySQL());
        return invDecomposeSql.toString();
    }

    private String getBizDecomposeSelector(CacheFields cacheFields) {
        StringBuffer invDecomposeSelector = new StringBuffer();
        invDecomposeSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FWarehouseID,et.FLocationID,");
        invDecomposeSelector.append("et.FMaterialID,et.FLot,et.FAssistPropertyID,et.FProjectID,et.FTrackNumberID,");
        invDecomposeSelector.append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,");
        invDecomposeSelector.append("0 as FCostAdjInAmt,");
        invDecomposeSelector.append("0 as FCostAdjOutAmt,");
        invDecomposeSelector.append("0 as FMoveInQty,");
        invDecomposeSelector.append("0 as FMoveInAssQty,");
        invDecomposeSelector.append("0 as FMoveInAmt,");
        invDecomposeSelector.append("0 as FMoveOutQty,");
        invDecomposeSelector.append("0 as FMoveOutAssQty,");
        invDecomposeSelector.append("0 as FMoveOutAmt,");
        invDecomposeSelector.append("0 as FStateAdjustInQty,");
        invDecomposeSelector.append("0 as FStateAdjustInAssQty,");
        invDecomposeSelector.append("0 as FStateAdjustOutQty,");
        invDecomposeSelector.append("0 as FStateAdjustOutAssQty,");
        invDecomposeSelector.append("SUM( et.FBaseQty ) as FDecomposeInQty,");
        invDecomposeSelector.append("SUM( et.FAssistQty ) as FDecomposeInAssQty,");
        invDecomposeSelector.append("SUM( et.FBaseQty ) as FDecomposeOutQty,");
        invDecomposeSelector.append("SUM( et.FAssistQty ) as FDecomposeOutAssQty ");
        int len = cacheFields.riColName.length;
        for (int i = cacheFields.riTypeIndex; i < len; i += 4) {
            invDecomposeSelector.append(", 0 as ").append(cacheFields.riColName[i]);
            invDecomposeSelector.append(", 0 as ").append(cacheFields.riColName[i + 1]);
            invDecomposeSelector.append(", 0 as ").append(cacheFields.riColName[i + 3]).append(NEWLINE);
        }
        return invDecomposeSelector.toString();
    }

    private String getParamFromQuerySql(Object object, String queryField, Class<?> clz, String methodName) {
        try {
            if (object instanceof String) {
                return " AND " + queryField + " >= '" + object.toString() + "' ";
            }
            if (clz.isInstance(object)) {
                Method method = clz.getMethod(methodName, new Class[0]);
                Object result = method.invoke(object, new Object[0]);
                return " AND " + queryField + " >= '" + result.toString() + "' ";
            }
            if (object instanceof List && ((List)object).size() > 0) {
                List objectList = (List)object;
                Method method = clz.getMethod(methodName, new Class[0]);
                StringBuffer queryBuffer = new StringBuffer();
                queryBuffer.append(" AND ").append(queryField).append(" IN (");
                for (Object obj : objectList) {
                    Object result = method.invoke(obj, new Object[0]);
                    queryBuffer.append("'").append(result.toString()).append("',");
                }
                return queryBuffer.substring(0, queryBuffer.length() - 1) + ") ";
            }
            if (object instanceof Object[] && ((Object[])object).length > 0 && clz.isInstance(((Object[])object)[0])) {
                String[] numArray = SCMUtil.getF7Numbers((Object)object);
                if (numArray[0] != null) {
                    return " AND " + queryField + " >= '" + numArray[0] + "' ";
                }
                if (numArray[1] != null) {
                    return " AND " + queryField + " in (" + numArray[1] + ") ";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"setParamFromQuery error", (Throwable)e);
        }
        return "";
    }

    private String getParamFromQuerySql(Object queryParam, String queryField) {
        if (queryParam instanceof String && StringUtils.isNotBlank((String)queryParam.toString())) {
            return "AND " + queryField + " >= '" + queryParam.toString() + "' ";
        }
        if (queryParam instanceof List && ((List)queryParam).size() > 0) {
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("AND ").append(queryField).append(" IN (");
            for (Object entry : (List)queryParam) {
                queryBuffer.append("'").append(entry.toString()).append("',");
            }
            return queryBuffer.substring(0, queryBuffer.length() - 1) + ") ";
        }
        return "";
    }

    private String getMaterialGroupQuerySql(Object materialGroupInfo, String field, boolean isNeedOrLikeFilter) {
        StringBuilder queryBuffer = new StringBuilder();
        if (materialGroupInfo instanceof MaterialGroupInfo) {
            queryBuffer.append(" (" + field + " >= '").append(((MaterialGroupInfo)materialGroupInfo).getLongNumber()).append("' ");
            queryBuffer.append("OR " + field + " LIKE '").append(((MaterialGroupInfo)materialGroupInfo).getLongNumber()).append("!%' )");
        } else if (materialGroupInfo instanceof List && ((List)materialGroupInfo).size() > 0) {
            StringBuilder queryInBuilder = new StringBuilder();
            StringBuilder queryOrBuilder = new StringBuilder();
            queryBuffer.append(" (" + field + " IN (");
            for (MaterialGroupInfo entry : (List)materialGroupInfo) {
                queryInBuilder.append("'").append(entry.getLongNumber()).append("',");
                queryOrBuilder.append("OR " + field + " LIKE '").append(entry.getLongNumber()).append("!%' ");
            }
            queryBuffer.append(queryInBuilder.substring(0, queryInBuilder.length() - 1)).append(") ");
            if (isNeedOrLikeFilter) {
                queryBuffer.append(queryOrBuilder.toString());
            }
            queryBuffer.append(")");
        }
        return queryBuffer.toString();
    }

    class CacheFields {
        public Map riTypeMap = new HashMap();
        public Map riTypeColMap = new HashMap();
        public String[] riColName = null;
        public String[] riColHeaderName = null;
        public String[] riColBlockName = null;
        public int riTypeIndex = 0;
        public boolean isShowAllRIType = false;
        public String matpermSql = null;
        public String hMatPermJoinSql = null;
        public String warepermSql = null;
        public String hWarePermJoinSql = null;

        CacheFields() {
        }
    }

    class SQLThreadPool {
        private Vector sqls = new Vector();
        private int maxThreadCount = 0;
        private int currentThread = 0;
        private boolean isRunning = false;
        private Context ctx;

        public SQLThreadPool(Context ctx) {
            this.ctx = ctx;
        }

        public synchronized void addSQL(String sql) {
            if (!this.isRunning) {
                this.sqls.add(sql);
                this.addCurrentThreadCount();
            }
        }

        public synchronized int getMaxThreadCount() {
            return this.maxThreadCount;
        }

        public synchronized int getCurrentThread() {
            return this.currentThread;
        }

        public synchronized void subtract() {
            --this.maxThreadCount;
            --this.currentThread;
        }

        public synchronized void addMaxThreadCount() {
            ++this.maxThreadCount;
        }

        public synchronized void addCurrentThreadCount() {
            ++this.currentThread;
        }

        public void startWorker() {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            for (String sql : this.sqls) {
                new ThreadWorker(sql, this.ctx).start();
            }
            while (this.getCurrentThread() > 0) {
            }
        }

        class ThreadWorker
        extends Thread {
            private String sql;
            private Context ctx;

            public ThreadWorker(String sql, Context ctx) {
                this.sql = sql;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                while (SQLThreadPool.this.getMaxThreadCount() > 2) {
                }
                SQLThreadPool.this.addMaxThreadCount();
                try {
                    long beforeTime = System.currentTimeMillis();
                    InOutStoreGatherReportFacadeControllerBean.this.executeUpdate(this.sql, null, this.ctx);
                    logger.info((Object)"-----------------------------------");
                    logger.info((Object)this.sql);
                    logger.info((Object)(" spend time is :" + (System.currentTimeMillis() - beforeTime) + "ms"));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                finally {
                    SQLThreadPool.this.subtract();
                }
            }
        }
    }
}

