/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.app.calculate.InvBillPriceCalculate;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.service.SCMPermissionService;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.RptPriceEnum;
import com.kingdee.eas.scm.im.rpt.app.AbstractInteventroyAgeFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InteventroyAgeFacadeControllerBean
extends AbstractInteventroyAgeFacadeControllerBean {
    private static final long serialVersionUID = 5808637951307656796L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.InteventroyAgeFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResourceForInvAge";
    private static final String No_Need_TempTable = "No_Need_TempTable";
    private String matpermSql = null;
    private String rptmatpermSql = null;
    private String matpermJoinSql = null;
    private String warepermSql = null;
    private String rptwarepermSql = null;
    private String warepermJoinSql = null;
    private Map<String, java.util.Date> mapDate = new HashMap<String, java.util.Date>();

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return super._init(ctx, params);
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        long lstart = 0L;
        long begin = 0L;
        long lstop = 0L;
        begin = System.currentTimeMillis();
        logger.info((Object)"==============================================");
        this.dropTempTable(ctx, params.getString("tempTable"));
        this.dropTempTable(ctx, params.getString("orgTempTable"));
        this.isGetAllOrg(ctx, params);
        this.getPerm(ctx, params);
        RptParams result = new RptParams();
        String tempTableName = null;
        String resultTempTable = null;
        try {
            logger.info((Object)"########### createTempTableAndInsertData ##############  ");
            lstart = System.currentTimeMillis();
            tempTableName = this.CreateCurinventory(ctx, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### createTempTableAndInsertData end : " + (lstop - lstart)));
            Boolean IsIntimeStore = (Boolean)params.getObject("IsIntimeStore");
            if (IsIntimeStore.booleanValue()) {
                try {
                    this.createIndexFromTempTable(ctx, tempTableName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            logger.info((Object)"########### updateInventoryPeriod ##############  ");
            lstart = System.currentTimeMillis();
            this.updateInventoryPeriod(ctx, tempTableName, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateInventoryPeriod end:" + (lstop - lstart)));
            logger.info((Object)"########### updatePrice ##############  ");
            lstart = System.currentTimeMillis();
            this.updatePrice(ctx, tempTableName, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updatePrice end:" + (lstop - lstart)));
            logger.info((Object)"########### createShowTempTable ##############  ");
            lstart = System.currentTimeMillis();
            resultTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getCreateResultTempTableSql(ctx, params));
            this.insertResultTempTable(ctx, params, resultTempTable, tempTableName);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### createShowTempTable end:" + (lstop - lstart)));
            this.removeNoAmtAuthorizedOrgData(ctx, params, resultTempTable);
            this.insertTotalRow(ctx, params, resultTempTable);
            logger.info((Object)"########### levelTempTable start ");
            lstart = System.currentTimeMillis();
            this.levelTempTable(ctx, resultTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### levelTempTable end : " + (lstop - lstart)));
            Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
            Boolean ckBoxShowGatherLine = (Boolean)params.getObject("ckBoxShowGatherLine");
            if (ckBoxShowGatherLine.booleanValue()) {
                logger.info((Object)"########### viewTotalLine start ");
                lstart = System.currentTimeMillis();
                this.viewTotalLine(ctx, resultTempTable, params);
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### viewTotalLine end : " + (lstop - lstart)));
            }
            String detailTempTable = null;
            String gatherTempTable = null;
            try {
                detailTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getCreateResultTempTableSql(ctx, params));
                if (ckBoxLevelGather.booleanValue()) {
                    gatherTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getCreateResultTempTableSql(ctx, params));
                    TempTablePool.getInstance((Context)ctx).createIndex(gatherTempTable, "KSQL_SEQ", false, false);
                }
                TempTablePool.getInstance((Context)ctx).createIndex(detailTempTable, "KSQL_SEQ", false, false);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            StringBuffer countSql = new StringBuffer();
            countSql.append("select count(1) cc from ").append(resultTempTable).append("");
            RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            this.copyToNewTempTable(ctx, detailTempTable, resultTempTable, params, 1);
            if (ckBoxLevelGather.booleanValue()) {
                this.copyToNewTempTable(ctx, gatherTempTable, resultTempTable, params, 0);
            }
            if (ckBoxLevelGather.booleanValue()) {
                result.setString("tempTable", gatherTempTable);
                result.setString("detailTempTable", detailTempTable);
            } else {
                result.setString("tempTable", detailTempTable);
            }
            IRowSet idList = this.getIdList(ctx, result);
            this.dropTempTable(ctx, resultTempTable);
            result.setInt("totalCount", count);
            result.setObject("idList", (Object)idList);
            result.setObject("queryHeader", (Object)this.buildQueryHead(ctx, params));
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### total time: " + (lstop - begin)));
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        return result;
    }

    private void removeNoAmtAuthorizedOrgData(Context ctx, RptParams params, String tempTableName) throws BOSException, EASBizException, SQLException {
        FullOrgUnitCollection coll = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(ctx.getCaller(), OrgType.Storage, null, "inventoryAge_view_amount");
        Iterator iterator = coll.iterator();
        HashSet<String> authorizedStorageIdSet = new HashSet<String>();
        while (iterator.hasNext()) {
            FullOrgUnitInfo org = (FullOrgUnitInfo)iterator.next();
            authorizedStorageIdSet.add(org.getId().toString());
        }
        Object[] storageOrgArr = (Object[])params.getObject("storageOrgInfo");
        StringBuilder orgIdSql = new StringBuilder();
        for (Object fullStorageOrg : storageOrgArr) {
            String orgId = ((FullOrgUnitInfo)fullStorageOrg).getId().toString();
            if (authorizedStorageIdSet.contains(orgId)) continue;
            orgIdSql.append("'").append(orgId).append("',");
        }
        if (orgIdSql.length() > 0) {
            ArrayList ageSegmentList = this.getAgeSegment(ctx, params);
            StringBuilder amountField = new StringBuilder();
            for (int i = 0; i < ageSegmentList.size() + 1; ++i) {
                amountField.append("qc_Amount").append(i).append(" = 0,");
            }
            String amountFieldSql = ageSegmentList.size() == 0 ? "" : "," + amountField.substring(0, amountField.length() - 1);
            String orgIdFilterSql = orgIdSql.substring(0, orgIdSql.length() - 1);
            String updatePriceSql = "update " + tempTableName + " set fprice=0,FAmount=0" + amountFieldSql + " where FStorageOrgUnitID in (" + orgIdFilterSql + ")";
            DbUtil.execute((Context)ctx, (String)updatePriceSql);
        }
    }

    private Map buildQueryHead(Context ctx, RptParams params) {
        HashMap<String, Boolean> queryHeader = new HashMap<String, Boolean>();
        boolean isShowWareHouse = params.getBoolean("isShowWareHouse");
        boolean isShowLocation = params.getBoolean("isShowLocation");
        boolean isShowLot = params.getBoolean("isShowLot");
        boolean isShowAssitProperty = params.getBoolean("isShowAssitProperty");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        queryHeader.put("FwareHouseNumber", isShowWareHouse);
        queryHeader.put("FwareHouseName", isShowWareHouse);
        queryHeader.put("FLocation", isShowLocation);
        queryHeader.put("FLot", isShowLot);
        queryHeader.put("FAssitPropertyName", isShowAssitProperty);
        queryHeader.put("FProjectNumber", isShowProject);
        queryHeader.put("FProjectName", isShowProject);
        queryHeader.put("FTrackNumNumber", isShowTrackNum);
        queryHeader.put("FTrackNumName", isShowTrackNum);
        return queryHeader;
    }

    private void viewTotalLine(Context ctx, String resultTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("delete from " + resultTempTable + " where flevel <> 1 and fistotalrow <> 1 ").append(";");
        sb.append("update " + resultTempTable + " set fisleaf = 1").append(";");
        super.executeBatchUpdate(ctx, sb.toString().split(";"));
    }

    private void levelTempTable(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException, SQLException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        if (ckBoxLevelGather.booleanValue()) {
            this.levelToRootOrg(ctx, tempTable, params);
            this.levelByMaterialGroup(ctx, tempTable, params);
        }
    }

    private void levelByMaterialGroup(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String sqle = "";
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        int level = this.getMaterialGroupMaxLevel(ctx, tempTable, params);
        params.setInt("maxMaterialGroupLevel", level);
        sql.append(this.getInsertFiledsSql(ctx, params, tempTable, new String[]{"FMaterialGroupID"})).append(" ");
        sql.append("select newbosid('88888888') Fid,3 as findex,");
        sql.append(this.getGroupFiledsSql(ctx, params)).append(" ");
        sql.append(",b.fparentid as FMaterialGroupID ");
        sql.append("from ").append(tempTable).append(" a inner join ");
        sql.append("t_bd_materialgroup b on a.fmaterialgroupid = b.fid where  b.flevel =");
        StringBuffer sb = new StringBuffer(1024);
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " and findex >= 2  group by b.fparentid  ";
            sb.append(sqle + ";");
        }
        StringBuffer br = new StringBuffer();
        br.append(" update ").append(tempTable).append(" t0 set (FmaterialGroupNumber,FMATERIALGROUP ,FLEVEL,FISLEAF,Fparentid) =  ");
        br.append(" (select mg.fnumber,mg.Fname_").append(lang).append(",mg.flevel,mg.fisleaf,mg.fparentid");
        br.append(" from ");
        br.append(" t_bd_materialgroup mg where mg.fid=t0.FMaterialGroupID)").append("\r\n");
        sb.append(br).append(";");
        br.setLength(0);
        br.append(" update ").append(tempTable).append(" set fisleaf = 1 where findex = 1 ");
        sb.append(br).append(";");
        br.setLength(0);
        br.append(" update ").append(tempTable).append(" set fisleaf = 0 where findex = 2 ");
        sb.append(br).append(";");
        br.setLength(0);
        br.append(" update ").append(tempTable).append(" set flevel = flevel + 1 where findex = 1 ");
        sb.append(br).append(";");
        if (sb.length() > 0) {
            super.executeBatchUpdate(ctx, sb.toString().split(";"));
        }
    }

    private int getMaterialGroupMaxLevel(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int maxLevel = 1;
        sql.append("select isnull(max(b.flevel),0) as flevel from " + tempTable + " a ");
        sql.append("left join t_bd_materialgroup b on a.fmaterialgroupid = b.fid ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        if (rs.next()) {
            maxLevel = rs.getInt("flevel");
        }
        return maxLevel;
    }

    private void levelToRootOrg(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInsertFiledsSql(ctx, params, tempTable, new String[]{"FMaterialGroupID"}));
        sql.append("select newbosid('88888888') Fid,2 as findex,");
        sql.append(this.getGroupFiledsSql(ctx, params)).append(" ");
        sql.append(",a.FMaterialGroupID as FMaterialGroupID");
        sql.append(" from ").append(tempTable).append(" a  where findex = 1 and FIsTotalRow =0 ");
        sql.append(" group by FMaterialGroupID ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getInsertFiledsSql(Context ctx, RptParams params, String tempTable, String[] addFields) throws InvBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer fields = new StringBuffer();
        for (int i = 0; i < addFields.length; ++i) {
            fields.append(addFields[i]).append(",");
        }
        sql.append("insert into ").append(tempTable).append("(");
        sql.append(" Fid,findex ").append("\r\n");
        sql.append(",Fqty,").append("\r\n");
        sql.append(" FPrice,").append("\r\n");
        sql.append(" FAMOUNT").append("\r\n");
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i <= ageSegment.size(); ++i) {
            sql.append(",fqty" + i);
            sql.append(",qc_Amount" + i);
        }
        sql.append(", FMaterialGroupID");
        sql.append(") ");
        return sql.toString();
    }

    private String getGroupFiledsSql(Context ctx, RptParams params) throws InvBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" sum(Fqty) , ").append("\r\n");
        sql.append(" decimal(decimal(sum(FAMOUNT),19,6)/decimal(sum(Fqty),19,6), 19, 6)as FPrice,").append("\r\n");
        sql.append("sum(FAMOUNT)").append("\r\n");
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i < ageSegment.size() + 1; ++i) {
            sql.append(",sum(fqty" + i + ")");
            sql.append(",sum(qc_Amount" + i + ")");
        }
        return sql.toString();
    }

    private void getPerm(Context ctx, RptParams params) throws BOSException {
        Set authorUnitSet = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inventoryAge_view");
        Object[] storageOrgList = (Object[])params.getObject("storageOrgInfo");
        Set cuUnitSets = InvServerUtils.getSelAuthorUnit(authorUnitSet, storageOrgList);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)cuUnitSets, (String)"bd_material_view", (String)"MATERIAL", (String)"ib");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)cuUnitSets, (String)"warehous_view", (String)"WAREHOUSE", (String)"ib");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            this.matpermSql = " and" + (String)matpermRuleMap.get("PERM_WHERE");
            this.matpermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            this.warepermSql = " and" + (String)warepermRuleMap.get("PERM_WHERE");
            this.warepermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
        }
        Map matpermRuleMapS = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)cuUnitSets, (String)"bd_material_view", (String)"MATERIAL", (String)"ENTRY");
        Map warepermRuleMapS = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)cuUnitSets, (String)"warehous_view", (String)"WAREHOUSE", (String)"ENTRY");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMapS)) {
            this.rptmatpermSql = " and" + (String)matpermRuleMapS.get("PERM_WHERE");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMapS)) {
            this.rptwarepermSql = " and" + (String)warepermRuleMapS.get("PERM_WHERE");
        }
    }

    private void insertResultTempTable(Context ctx, RptParams params, String resultTempTable, String tempTableName) throws InvBizException, BOSException {
        Boolean isShowAssitProperty = params.getBoolean("isShowAssitProperty");
        Boolean isShowProject = params.getBoolean("isShowProject");
        Boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        StringBuffer br = new StringBuffer();
        StringBuffer innerClause = new StringBuffer();
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String mgStandardID = "dR8lnQEPEADgAAWKwKgSxZeb4R8=";
        if (params.getObject("materialGroupStandard") != null) {
            mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        }
        br.append("select t1.Fid as fid,storage.fname_").append(lang).append(" as FStorageOrgName,").append("\r\n");
        br.append(" storage.fnumber as FStorageNum,");
        br.append("t1.FStorageOrgUnitID as FStorageOrgUnitID, ").append("\r\n");
        br.append("t1.fmaterialid as fmaterialid, ").append("\r\n");
        br.append("mg.fid as FMaterialGroupID ").append("\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            br.append(",warehouse.fnumber as FwareHouseNumber").append("\r\n");
            br.append(",warehouse.fname_").append(lang).append(" as FwareHouseName").append("\r\n");
            br.append(",t1.FWarehouseID as FWarehouseID").append("\r\n");
            innerClause.append("inner join t_db_warehouse warehouse on warehouse.Fid=t1.FWarehouseID").append("\r\n");
        }
        if (params.getBoolean("isShowType")) {
            br.append(",storeType.fname_").append(lang).append("  as FStoreType").append("\r\n");
            innerClause.append("left join t_im_storetype storeType on storeType.Fid=t1.FInventoryTypeID").append("\r\n");
        }
        if (params.getBoolean("isShowLocation")) {
            br.append(",location.fname_").append(lang).append("  as FLocation").append("\r\n");
            innerClause.append("left join t_db_location location on location.Fid=t1.FLocationId").append("\r\n");
        }
        if (params.getBoolean("isShowLot")) {
            br.append(",t1.Flot as Flot").append("\r\n");
        }
        if (isShowAssitProperty.booleanValue()) {
            br.append(",asst.fname_").append(lang).append(" as FAssitPropertyName").append("\r\n");
            innerClause.append("left join t_bd_asstattrvalue asst on t1.FAssistPropertyID = asst.fid ").append("\r\n");
        }
        if (isShowProject.booleanValue()) {
            br.append(",project.FNumber").append(" as FProjectNumber").append("\r\n");
            br.append(",project.fname_").append(lang).append(" as FProjectName").append("\r\n");
            innerClause.append("left join T_MM_Project project on t1.FProjectID = project.FID  ").append("\r\n");
        }
        if (isShowTrackNum.booleanValue()) {
            br.append(",track.FNumber").append(" as FTrackNumNumber").append("\r\n");
            br.append(",track.fname_").append(lang).append(" as FTrackNumName").append("\r\n");
            innerClause.append("left join T_MM_TrackNumber track on t1.FTrackNumberID = track.FID  ").append("\r\n");
        }
        br.append(",mg.fnumber as FmaterialGroupNumber,mg.Fname_").append(lang).append(" as FmaterialGroup ,  ").append("\r\n");
        br.append("material.fnumber as FmaterialNumber,  ").append("\r\n");
        br.append("material.fname_").append(lang).append(" as FmaterialName,").append("\r\n");
        br.append("material.fmodel as FModel,  ").append("\r\n");
        br.append("meaunit.Fname_").append(lang).append(" as Funit,").append("\r\n");
        br.append("meaunit.fid as Funitid,").append("\r\n");
        br.append("round(t1.Fprice,").append(6).append(")  as FPrice,").append("\r\n");
        br.append("t1.fqty as Fqty,").append("\r\n");
        br.append("round(t1.FActualCost,").append(4).append(") as FAmount").append("\r\n");
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i <= ageSegment.size(); ++i) {
            br.append(",t1.FD" + i + " as fqty" + String.valueOf(i) + "").append("\r\n");
            br.append(",round(T1.FAmount" + String.valueOf(i) + ",").append(4).append(") as qc_Amount" + i + "").append("\r\n");
        }
        br.append(",t1.Flevel as Flevel,").append("\r\n");
        br.append("t1.Fisleaf as Fisleaf, ").append("\r\n");
        br.append("t1.FParentID as FParentID, ").append("\r\n");
        br.append("0 as FIsTotalRow ").append("\r\n");
        br.append("from  ").append(tempTableName).append("  t1").append("\r\n");
        br.append("inner join t_bd_material material on material.fid=t1.FMaterialID").append("\r\n");
        br.append("inner join t_org_storage storage on storage.Fid=t1.FStorageOrgUnitID").append("\r\n");
        br.append("inner join t_bd_measureunit meaunit on meaunit.fid=material.fbaseunit").append("\r\n");
        br.append("inner join  t_bd_materialgroupdetial mgd on mgd.fmaterialid=material.fid and ");
        br.append(" fmaterialgroupstandardid= '").append(mgStandardID).append("' \r\n");
        br.append("inner join t_bd_materialgroup mg on mg.fid=mgd.fmaterialgroupid").append("\r\n");
        br.append(innerClause.toString());
        br.append(" Order by storage.fnumber").append("\r\n");
        br.append(",mg.Fnumber").append("\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            br.append(",warehouse.fnumber").append("\r\n");
        }
        br.append(",material.fnumber").append("\r\n");
        br.append(",t1.Fid");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + resultTempTable + " ");
        sql.append("(fid,FStorageOrgName,FStorageNum,FStorageOrgUnitID,fmaterialid,FMaterialGroupID,");
        if (params.getBoolean("isShowWareHouse")) {
            sql.append("FwareHouseNumber,FwareHouseName,FWarehouseID,");
        }
        if (params.getBoolean("isShowType")) {
            sql.append("FStoreType,");
        }
        if (params.getBoolean("isShowLocation")) {
            sql.append("FLocation,");
        }
        if (params.getBoolean("isShowLot")) {
            sql.append("FLot,");
        }
        if (isShowAssitProperty.booleanValue()) {
            sql.append("FAssitPropertyName,");
        }
        if (isShowProject.booleanValue()) {
            sql.append("FProjectNumber,");
            sql.append("FProjectName,");
        }
        if (isShowTrackNum.booleanValue()) {
            sql.append("FTrackNumNumber,");
            sql.append("FTrackNumName,");
        }
        sql.append(" FmaterialGroupNumber,FmaterialGroup,FmaterialNumber,FmaterialName,FModel,Funit,Funitid,FPrice,Fqty,FAmount");
        for (int i = 0; i <= ageSegment.size(); ++i) {
            sql.append(",fqty" + i);
            sql.append(",qc_Amount" + i);
        }
        sql.append(",Flevel,Fisleaf,FParentID,FIsTotalRow) ");
        sql.append(br.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getCreateResultTempTableSql(Context ctx, RptParams params) throws InvBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("KSQL_SEQ INT IDENTITY(1,1),");
        sql.append("FID varchar(44),\r\n");
        sql.append("FMaterialID varchar(44),\r\n");
        sql.append("FmaterialNumber nvarchar(255),\r\n");
        sql.append("FmaterialName nvarchar(255),\r\n");
        sql.append("FModel nvarchar(255),\r\n");
        sql.append("FMaterialGroupID varchar(44),\r\n");
        sql.append("FmaterialGroupNumber nvarchar(255),\r\n");
        sql.append("FmaterialGroup nvarchar(255),\r\n");
        sql.append("FStorageOrgUnitID varchar(44),\r\n");
        sql.append("FStorageNum nvarchar(255),\r\n");
        sql.append("FStorageOrgName nvarchar(255),\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            sql.append("FWarehouseID varchar(44), \r\n");
            sql.append("FwareHouseNumber nvarchar(80), \r\n");
            sql.append("FwareHouseName nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowType")) {
            sql.append("FStoreType nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowLocation")) {
            sql.append("FLocation nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowLot")) {
            sql.append("Flot nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            sql.append("FAssitPropertyName nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowProject")) {
            sql.append("FProjectNumber nvarchar(80), \r\n");
            sql.append("FProjectName nvarchar(255),\r\n");
        }
        if (params.getBoolean("isShowTrackNum")) {
            sql.append("FTrackNumNumber nvarchar(80), \r\n");
            sql.append("FTrackNumName nvarchar(255),\r\n");
        }
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i <= ageSegment.size(); ++i) {
            sql.append("fqty" + i + " NUMERIC(28,10) DEFAULT 0,\r\n");
            sql.append("qc_Amount" + i + " NUMERIC(28,10) DEFAULT 0,\r\n");
        }
        sql.append("FUnitID varchar(44),\r\n");
        sql.append("Funit nvarchar(255),\r\n");
        sql.append("FQty NUMERIC(28,10) DEFAULT 0,\r\n");
        sql.append("Fprice NUMERIC(28,10) DEFAULT 0,\r\n");
        sql.append("FAmount NUMERIC(28,10) DEFAULT 0,\r\n");
        sql.append("Flevel int DEFAULT 1,\r\n");
        sql.append("Fisleaf int DEFAULT 0,\r\n");
        sql.append("FParentID varchar(44),\r\n");
        sql.append("FIsTotalRow int DEFAULT 0, \r\n");
        sql.append("findex int DEFAULT 1 \r\n");
        sql.append(" )");
        return sql.toString();
    }

    private String getCreateMiddleTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MiddleTempTable (");
        sql.append("FStorageOrgUnitID varchar(44),");
        sql.append("FMaterialID varchar(44),");
        sql.append("FWarehouseID varchar(44),");
        sql.append("FInventoryTypeID varchar(44),");
        sql.append("FLocationId varchar(44),");
        sql.append("FLot varchar(255),");
        sql.append("FAssistPropertyId varchar(44),\r\n");
        sql.append("FProjectId varchar(44), \r\n");
        sql.append("FTrackNumberId varchar(44), \r\n");
        sql.append("FQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        return sql.toString();
    }

    private void insertTotalRow(Context ctx, RptParams params, String tempTableName) throws InvBizException, BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        sql.append(" insert into " + tempTableName + " ").append("(fid,FStorageOrgName");
        for (i = 0; i < ageSegment.size() + 1; ++i) {
            sql.append(",fqty" + i);
            sql.append(",qc_Amount" + i);
        }
        sql.append(",FQty,Fprice,FAmount,FIsTotalRow)");
        sql.append(" select newBosid('88888888') as fid,'").append(ResourceBase.getString((String)resClassName, (String)"total", (Locale)ctx.getLocale())).append("' as  FStorageOrgName");
        for (i = 0; i < ageSegment.size() + 1; ++i) {
            sql.append(",sum(fqty" + i + ") as fqty" + i);
            sql.append(",sum(qc_Amount" + i + ") as qc_Amount" + i);
        }
        sql.append(" ,sum(FQty) as FQty,decimal(decimal(sum(FAmount),28,10)/ (case sum(FQty) when 0 then 1 else decimal(sum(FQty),28,10) end), 28, 10) Fprice,sum(FAmount) FAmount,1 as FIsTotalRow ");
        sql.append(" from " + tempTableName + "");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void createIndexFromTempTable(Context ctx, String tempTableName) throws BOSException {
        String tempTableName_index = "tmp1_" + CalculateUtil.genRandomNum((int)5);
        StringBuffer createIndex = new StringBuffer();
        createIndex.append("create index ").append(tempTableName_index).append(" on ").append(tempTableName).append("\r\n");
        createIndex.append(" (FID,FMaterialID,FStorageOrgUnitID,FCompanyOrgUnitId)");
        DbUtil.execute((Context)ctx, (String)createIndex.toString());
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams result = new RptParams();
        this.isGetAllOrg(ctx, params);
        StringBuffer sql = new StringBuffer(this.getSelectSql(ctx, params));
        RptRowSet rs = null;
        int start = from + 1;
        int end = from + len;
        sql.append(" and KSQL_SEQ >=").append(start).append(" and KSQL_SEQ <=").append(end);
        sql.append(" Order by KSQL_SEQ ASC");
        rs = this.executeQuery(sql.toString(), null, ctx);
        result.setObject("rowset", (Object)rs);
        return result;
    }

    private void isGetAllOrg(Context ctx, RptParams params) throws EASBizException, BOSException {
        if (null != params.getObject("allOrg") && ((Boolean)params.getObject("allOrg")).booleanValue()) {
            SCMPermissionService permSrv = new SCMPermissionService(ctx);
            OrgUnitInfo[] orgs = permSrv.getAuthorizedBizOrgUnit(ctx.getCaller(), OrgType.Storage, "inventoryAge_view");
            params.setObject("storageOrgInfo", (Object)orgs);
        }
    }

    private void copyToNewTempTable(Context ctx, String newTempTable, String tempTable, RptParams params, int isLeaf) throws BOSException, EASBizException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(newTempTable).append("(");
        sb.append(this.getSelects(params, ctx, true));
        sb.append(")");
        sb.append(" select ");
        sb.append(this.getSelects(params, ctx, false));
        sb.append(" from ").append(tempTable);
        sb.append(" where  1 = 1");
        if (isLeaf == 0 || !ckBoxLevelGather.booleanValue()) {
            sb.append(" and (flevel = 1 or fistotalrow = 1)");
        } else {
            sb.append(" and (flevel <> 1 or fistotalrow = 1)");
        }
        sb.append(" Order by fistotalrow,FStorageNum");
        sb.append(",FmaterialGroup");
        if (params.getBoolean("isShowWareHouse")) {
            sb.append(",FwareHouseNumber");
        }
        sb.append(",FmaterialNumber").append("\r\n");
        sb.append(",Fid");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSelects(RptParams params, Context ctx, boolean hasKsqlSeq) throws InvBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        if (hasKsqlSeq) {
            sb.append("KSQL_SEQ,");
        }
        sb.append("FID,FMaterialID,FmaterialNumber,FmaterialName,FModel,FMaterialGroupID,FmaterialGroup,FStorageOrgUnitID,FStorageNum,FStorageOrgName,");
        if (params.getBoolean("isShowWareHouse")) {
            sb.append("FWarehouseID,");
            sb.append("FwareHouseNumber,");
            sb.append("FwareHouseName,");
        }
        if (params.getBoolean("isShowType")) {
            sb.append("FStoreType,");
        }
        if (params.getBoolean("isShowLocation")) {
            sb.append("FLocation,");
        }
        if (params.getBoolean("isShowLot")) {
            sb.append("Flot,");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            sb.append("FAssitPropertyName,");
        }
        if (params.getBoolean("isShowProject")) {
            sb.append("FProjectNumber,");
            sb.append("FProjectName,");
        }
        if (params.getBoolean("isShowTrackNum")) {
            sb.append("FTrackNumNumber,");
            sb.append("FTrackNumName,");
        }
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i <= ageSegment.size(); ++i) {
            sb.append("fqty" + i + ",");
            sb.append("qc_Amount" + i + ",");
        }
        sb.append("FUnitID,");
        sb.append("Funit,");
        sb.append("FQty,");
        sb.append("Fprice,");
        sb.append("FAmount,");
        sb.append("Flevel,");
        sb.append("Fisleaf,");
        sb.append("FParentID,");
        sb.append("FIsTotalRow,");
        sb.append("findex");
        return sb.toString();
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        String findex = params.getString("findex");
        StringBuffer sql = new StringBuffer();
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        if (ckBoxLevelGather.booleanValue()) {
            sql.append(this.getSelectSql(ctx, params)).append(" ");
            if ("2".equals(findex)) {
                sql.append(" and FMaterialGroupid = '").append(params.getString("fparentid")).append("' and findex = 1  ").append("order by FMaterialNumber");
            } else if ("1".equals(findex)) {
                sql.append(" and fmaterialid = '").append(params.getString("fmaterialid")).append("'   ");
            } else {
                sql.append(" and FParentID = '").append(params.getString("fparentid")).append("' and findex <>1 ");
                sql.append("order by FmaterialGroupNumber,FMaterialNumber,flevel ");
            }
        }
        RptRowSet rs = start <= -1 && count <= -1 ? this.executeQuery(sql.toString(), null, ctx) : this.executeQuery(sql.toString(), null, start, count, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        StringBuffer br = new StringBuffer("select  fid from ").append("\r\n");
        br.append(param.getString("tempTable")).append("\r\n");
        return DbUtil.executeQuery((Context)ctx, (String)br.toString());
    }

    protected String getSelectSql(Context ctx, RptParams params) throws BOSException, InvBizException {
        StringBuffer br = new StringBuffer();
        String tempTableName = params.getString("tempTable");
        br.append("select FStorageOrgName as FStorageOrgName").append("\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            br.append(",FwareHouseNumber as FwareHouseNumber").append("\r\n");
            br.append(",FwareHouseName as FwareHouseName").append("\r\n");
            br.append(",FWarehouseID as FWarehouseID").append("\r\n");
        }
        if (params.getBoolean("isShowType")) {
            br.append(",FStoreType  as FStoreType").append("\r\n");
        }
        if (params.getBoolean("isShowLocation")) {
            br.append(",FLocation  as FLocation").append("\r\n");
        }
        if (params.getBoolean("isShowLot")) {
            br.append(",(case when t1.Flot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' then null ");
            br.append(" else t1.Flot end) as Flot").append("\r\n");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            br.append(",t1.FAssitPropertyName as FAssitPropertyName").append("\r\n");
        }
        if (params.getBoolean("isShowProject")) {
            br.append(",t1.FProjectNumber as FProjectNumber").append("\r\n");
            br.append(",t1.FProjectName as FProjectName").append("\r\n");
        }
        if (params.getBoolean("isShowTrackNum")) {
            br.append(",t1.FTrackNumNumber as FTrackNumNumber").append("\r\n");
            br.append(",t1.FTrackNumName as FTrackNumName").append("\r\n");
        }
        br.append(",FmaterialGroup as FmaterialGroup ,  ").append("\r\n");
        br.append("FmaterialNumber as FmaterialNumber,  ").append("\r\n");
        br.append("FmaterialName as FmaterialName,").append("\r\n");
        br.append("FModel as FModel,  ").append("\r\n");
        br.append("Funit as Funit,").append("\r\n");
        br.append("round(FPrice,").append(6).append(")  as FPrice,").append("\r\n");
        br.append("fqty as Fqty,").append("\r\n");
        br.append("round(FAmount,").append(4).append(") as FAmount").append("\r\n");
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        for (int i = 0; i <= ageSegment.size(); ++i) {
            br.append(",fqty" + i + " as fqty" + String.valueOf(i) + "").append("\r\n");
            br.append(",qc_Amount" + String.valueOf(i) + " as qc_Amount" + i + "").append("\r\n");
        }
        br.append(",Flevel as Flevel,").append("\r\n");
        br.append("Findex as findex,").append("\r\n");
        br.append("Fisleaf as Fisleaf, ").append("\r\n");
        br.append("FParentID as FParentID, ").append("\r\n");
        br.append("FStorageOrgUnitID as FStorageOrgUnitID, ").append("\r\n");
        br.append("fmaterialid as fmaterialid, ").append("\r\n");
        br.append("FMaterialGroupID as FMaterialGroupID ").append("\r\n");
        br.append("from  ").append(tempTableName).append("  t1").append("\r\n");
        br.append("where  1 = 1 ").append("\r\n");
        return br.toString();
    }

    protected RptParams _getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException {
        return super._getDataForIdList(ctx, idList, params);
    }

    protected void updatePrice(Context ctx, String tempTableName, RptParams params) throws Exception {
        long lstart = 0L;
        long lstop = 0L;
        Boolean IsPeriodStore = (Boolean)params.getObject("IsPeriodStore");
        Boolean isShowWareHouse = (Boolean)params.getObject("isShowWareHouse");
        Connection conn = this.getConnection(ctx);
        if (!IsPeriodStore.booleanValue()) {
            PeriodInfo period;
            CompanyOrgUnitInfo companyOrgUnitInfo;
            String companyId;
            HashMap<String, Object> hm;
            InvBillPriceCalculate iiwc = new InvBillPriceCalculate();
            String getCompanyId = "select distinct FCompanyOrgUnitId from " + tempTableName;
            IRowSet compaySet = DbUtil.executeQuery((Context)ctx, (String)getCompanyId);
            RptPriceEnum privceSelect = RptPriceEnum.BEGIN_WEIGHTED_AVERAGE_PRICE;
            privceSelect = (RptPriceEnum)((Object)params.getObject("priceSource"));
            if (privceSelect.equals((Object)RptPriceEnum.BEGIN_WEIGHTED_AVERAGE_PRICE)) {
                while (compaySet.next()) {
                    hm = new HashMap<String, Object>();
                    companyId = compaySet.getString("FCompanyOrgUnitId");
                    if (StringUtils.isEmpty((String)companyId)) continue;
                    companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                    period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    hm.put("tempTableName", tempTableName);
                    hm.put("period", period);
                    hm.put("companyOrgUnitId", companyId);
                    hm.put("isShowWareHouse", isShowWareHouse);
                    hm.put("matperm", this.rptmatpermSql);
                    hm.put("wareperm", this.rptwarepermSql);
                    hm.put("matpermJoinsql", this.matpermJoinSql);
                    hm.put("warepermJoinSql", this.warepermJoinSql);
                    logger.info((Object)"########### \u6309\u671f\u521d\u4f59\u989d\u52a0\u6743\u5e73\u5747\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                    lstart = System.currentTimeMillis();
                    ImRptAppUtils.updateBeginWeightedAveragePrice(ctx, hm);
                    lstop = System.currentTimeMillis();
                    logger.info((Object)("########### \u6309\u671f\u521d\u4f59\u989d\u52a0\u6743\u5e73\u5747\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
                }
            }
            if (privceSelect.equals((Object)RptPriceEnum.LAST_TIME_NEW_PAYOUT_PRICE)) {
                while (compaySet.next()) {
                    hm = new HashMap();
                    companyId = compaySet.getString("FCompanyOrgUnitId");
                    if (StringUtils.isEmpty((String)companyId)) continue;
                    companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                    period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    period = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                    hm.put("tempTableName", tempTableName);
                    hm.put("period", period);
                    hm.put("companyOrgUnitId", companyId);
                    hm.put("isPayOut", "true");
                    hm.put("isShowWareHouse", isShowWareHouse);
                    hm.put("matperm", this.rptmatpermSql);
                    hm.put("wareperm", this.rptwarepermSql);
                    hm.put("matpermJoinsql", this.matpermJoinSql);
                    hm.put("warepermJoinSql", this.warepermJoinSql);
                    logger.info((Object)"########### \u4e0a\u671f\u6700\u65b0\u51fa\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                    lstart = System.currentTimeMillis();
                    ImRptAppUtils.updateNewInpourOrPayOutPrice(ctx, hm);
                    lstop = System.currentTimeMillis();
                    logger.info((Object)("########### \u4e0a\u671f\u6700\u65b0\u51fa\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
                }
            }
            if (privceSelect.equals((Object)RptPriceEnum.NEW_INPOUR_PRICE)) {
                while (compaySet.next()) {
                    hm = new HashMap();
                    companyId = compaySet.getString("FCompanyOrgUnitId");
                    if (StringUtils.isEmpty((String)companyId)) continue;
                    companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                    period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    hm.put("tempTableName", tempTableName);
                    hm.put("period", period);
                    hm.put("companyOrgUnitId", companyId);
                    hm.put("isPayOut", "false");
                    hm.put("isShowWareHouse", isShowWareHouse);
                    hm.put("matperm", this.rptmatpermSql);
                    hm.put("wareperm", this.rptwarepermSql);
                    hm.put("matpermJoinsql", this.matpermJoinSql);
                    hm.put("warepermJoinSql", this.warepermJoinSql);
                    logger.info((Object)"########### \u6700\u65b0\u5165\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                    lstart = System.currentTimeMillis();
                    ImRptAppUtils.updateNewInpourOrPayOutPrice(ctx, hm);
                    lstop = System.currentTimeMillis();
                    logger.info((Object)("########### \u6700\u65b0\u5165\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
                }
            }
            if (privceSelect.equals((Object)RptPriceEnum.NEW_PAYOUT_PRICE)) {
                while (compaySet.next()) {
                    hm = new HashMap();
                    companyId = compaySet.getString("FCompanyOrgUnitId");
                    if (StringUtils.isEmpty((String)companyId)) continue;
                    companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                    period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    hm.put("tempTableName", tempTableName);
                    hm.put("period", period);
                    hm.put("companyOrgUnitId", companyId);
                    hm.put("isPayOut", "true");
                    hm.put("isShowWareHouse", isShowWareHouse);
                    hm.put("matperm", this.rptmatpermSql);
                    hm.put("wareperm", this.rptwarepermSql);
                    hm.put("matpermJoinsql", this.matpermJoinSql);
                    hm.put("warepermJoinSql", this.warepermJoinSql);
                    logger.info((Object)"########### \u6700\u65b0\u51fa\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                    lstart = System.currentTimeMillis();
                    ImRptAppUtils.updateNewInpourOrPayOutPrice(ctx, hm);
                    lstop = System.currentTimeMillis();
                    logger.info((Object)("########### \u6700\u65b0\u51fa\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
                }
            }
            if (privceSelect.equals((Object)RptPriceEnum.PLAN_PRICE)) {
                while (compaySet.next()) {
                    String companyId2 = compaySet.getString("FCompanyOrgUnitId");
                    if (StringUtils.isEmpty((String)companyId2)) continue;
                    CompanyOrgUnitInfo companyOrgUnitInfo2 = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo2.setId(BOSUuid.read((String)companyId2));
                    PeriodInfo period2 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo2);
                    CalculateParams calparams = new CalculateParams();
                    calparams.setString("COMPANY_ID", companyId2);
                    logger.info((Object)"########### \u6807\u51c6\u6210\u672c  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                    lstart = System.currentTimeMillis();
                    DbUtil.execute((Context)ctx, (String)iiwc.updateUnitStandardPrice(period2, tempTableName));
                    lstop = System.currentTimeMillis();
                    logger.info((Object)("########### \u6807\u51c6\u6210\u672c  \u7ed3\u675f\uff1a " + (lstop - lstart)));
                }
            }
            StringBuffer updateFPrice = new StringBuffer();
            updateFPrice.append("update ").append(tempTableName).append(" set Fprice=FActualBaseUnitCost ");
            DBUtil.executeUpdate((String)updateFPrice.toString(), (Connection)conn);
        }
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        StringBuffer updatePrice = new StringBuffer();
        updatePrice.append("update ").append(tempTableName).append(" set ").append("\r\n");
        for (int i = 0; i < ageSegment.size() + 1; ++i) {
            updatePrice.append("FAmount").append(i).append("=Fprice*FD").append(i).append(",");
        }
        updatePrice.append("FWriteQty=FWriteQty");
        DBUtil.executeUpdate((String)updatePrice.toString(), (Connection)conn);
        this.close(conn);
    }

    protected void updateInventoryPeriod(Context ctx, String tempTableName, RptParams params) throws Exception {
        ArrayList ageSegment = this.getAgeSegment(ctx, params);
        Date beginDate = null;
        Date endDate = null;
        String insertSql = null;
        CreateTempTableResult temptableResult = null;
        String tempName = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getEndDate(ctx, params));
        beginDate = new Date(cal.getTimeInMillis());
        Connection conn = this.getConnection(ctx);
        String tempZeroTable = this.getJoinTempTableName(ctx, tempTableName, params);
        String middleTempTable = null;
        if (tempZeroTable != null) {
            middleTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getCreateMiddleTempTableSQL());
        }
        for (int i = 0; i < ageSegment.size() && tempZeroTable != null && (insertSql = this.getInWareSql(ctx, params, tempTableName, tempZeroTable, middleTempTable, endDate = (Date)ageSegment.get(i), beginDate)) != null; ++i) {
            temptableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)insertSql, null, (Connection)conn);
            tempName = temptableResult.getTempTable();
            com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)tempName, (String)"FStorageOrgUnitID,FMaterialID,FWAREHOUSEID", (boolean)false);
            DBUtil.executeUpdate((String)this.getUpdateString(ctx, "FD" + i, tempTableName, tempName, params), (Connection)conn);
            cal.setTime(endDate);
            cal.add(5, -1);
            beginDate = new Date(cal.getTimeInMillis());
            this.dropTempTable(ctx, tempName);
        }
        this.dropTempTable(ctx, middleTempTable);
        if (tempZeroTable != null && !No_Need_TempTable.equals(tempZeroTable)) {
            this.dropTempTable(ctx, tempZeroTable);
        }
        StringBuffer updateEnd = new StringBuffer();
        updateEnd.append("update ").append(tempTableName).append(" set FWriteQty=0,FD").append(ageSegment.size()).append("=FWriteQty").append("\r\n");
        updateEnd.append("where FWriteQty>0");
        DBUtil.executeUpdate((String)updateEnd.toString(), (Connection)conn);
        updateEnd.setLength(0);
        updateEnd.append("update ").append(tempTableName).append(" set FWriteQty=0,FD0=FD0+FWriteQty").append("\r\n");
        updateEnd.append("where FWriteQty<0");
        DBUtil.executeUpdate((String)updateEnd.toString(), (Connection)conn);
        this.close(conn);
    }

    protected String getUpdateString(Context ctx, String fieldName, String tempTableName, String tempTableName2, RptParams params) throws BOSException {
        StringBuffer br = new StringBuffer();
        br.append("update ").append(tempTableName).append(" set (FWriteQty,").append(fieldName).append(")=").append("\r\n");
        br.append("( select case when ").append(tempTableName).append(".FWriteQty-" + tempTableName2 + ".Fqty<0 then 0 else ");
        br.append("decimal(" + tempTableName).append(".FWriteQty-" + tempTableName2 + ".fqty,21,6) end,").append("\r\n");
        br.append("case when ").append(tempTableName).append(".FWriteQty-" + tempTableName2 + ".Fqty<0 then ");
        br.append("decimal(" + tempTableName).append(".FWriteQty,21,6) else decimal(" + tempTableName2 + ".fqty,21,6) end").append("\r\n");
        br.append(" from ").append(tempTableName2);
        br.append(" where ").append("\r\n");
        br.append(tempTableName).append(".FStorageOrgUnitID=" + tempTableName2 + ".FStorageOrgUnitID and").append("\r\n");
        br.append(tempTableName).append(".FMaterialID=" + tempTableName2 + ".FMaterialID").append("\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            br.append(" and ").append(tempTableName).append(".FWarehouseID=" + tempTableName2 + ".FWarehouseID").append("\r\n");
        }
        if (params.getBoolean("isShowType")) {
            br.append(" and ").append(tempTableName).append(".FInventoryTypeID=" + tempTableName2 + ".FInventoryTypeID").append("\r\n");
        }
        if (params.getBoolean("isShowLocation")) {
            br.append(" and isnull(").append(tempTableName).append(".FLocationID,'XXXXX')=isnull(" + tempTableName2 + ".FLocationID,'XXXXX')").append("\r\n");
        }
        if (params.getBoolean("isShowLot")) {
            br.append(" and isnull(").append(tempTableName).append(".FLot,'XXXXX')=isnull(" + tempTableName2 + ".FLot,'XXXXX')").append("\r\n");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            br.append(" and isnull(").append(tempTableName).append(".FAssistPropertyID,'XXXXX')=isnull(" + tempTableName2 + ".FAssistPropertyID,'XXXXX')").append("\r\n");
        }
        if (params.getBoolean("isShowProject")) {
            br.append(" and isnull(").append(tempTableName).append(".FProjectID,'XXXXX')=isnull(" + tempTableName2 + ".FProjectID,'XXXXX')").append("\r\n");
        }
        if (params.getBoolean("isShowTrackNum")) {
            br.append(" and isnull(").append(tempTableName).append(".FTracknumberID,'XXXXX')=isnull(" + tempTableName2 + ".FTracknumberID,'XXXXX')").append("\r\n");
        }
        br.append(")").append(" where FWriteQty>0").append("\r\n");
        return br.toString();
    }

    protected String CreateCurinventory(Context ctx, RptParams params) throws Exception {
        Boolean IsIntimeStore = (Boolean)params.getObject("IsIntimeStore");
        Boolean IsPeriodStore = (Boolean)params.getObject("IsPeriodStore");
        StringBuffer br = new StringBuffer();
        String tempName = "";
        Connection conn = this.getConnection(ctx);
        StringBuffer innerJoinSql = new StringBuffer();
        innerJoinSql.append(" inner join t_bd_material material on ib.FMaterialID=material.Fid").append("\r\n");
        innerJoinSql.append(" inner join t_org_storage orgUnit on orgUnit.Fid=ib.FStorageOrgUnitID").append("\r\n");
        innerJoinSql.append(" inner join t_db_warehouse wareHouse on wareHouse.Fid=ib.FWarehouseID").append("\r\n");
        innerJoinSql.append(" inner join t_im_storetype storeType on storeType.Fid=ib.FStoreTypeID").append("\r\n");
        if (params.getObject("assiAsstPropFrom") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropFrom").toString()) || params.getObject("assiAsstPropTo") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropTo").toString())) {
            innerJoinSql.append("inner join t_bd_asstattrvalue asst on ib.FAssistPropertyId = asst.fid ").append("\r\n");
        }
        if (params.getObject("projectNumFrom") instanceof ProjectInfo || params.getObject("projectNumTo") instanceof ProjectInfo) {
            innerJoinSql.append("inner join T_MM_Project project on ib.FProjectID = project.FID ").append("\r\n");
        }
        if (params.getObject("trackNumFrom") instanceof TrackNumberInfo || params.getObject("trackNumTo") instanceof TrackNumberInfo) {
            innerJoinSql.append("inner join T_MM_TrackNumber track on ib.FTrackNumberID = track.FID ").append("\r\n");
        }
        if (this.matpermJoinSql != null) {
            innerJoinSql.append(this.matpermJoinSql);
        }
        if (this.warepermJoinSql != null) {
            innerJoinSql.append(this.warepermJoinSql);
        }
        if (IsPeriodStore.booleanValue()) {
            int spYear = (Integer)params.getObject("spYear");
            int spPeriod = (Integer)params.getObject("spPeriod");
            br.append("select newbosid('88888888') Fid,ib.FStorageOrgUnitID,ib.FMaterialID").append("\r\n");
            if (params.getBoolean("isShowWareHouse")) {
                br.append(",ib.FWarehouseID");
            }
            if (params.getBoolean("isShowType")) {
                br.append(",ib.FStoreTypeID  FInventoryTypeID");
            }
            if (params.getBoolean("isShowLocation")) {
                br.append(",ib.FLocationId");
            }
            if (params.getBoolean("isShowLot")) {
                br.append(",isnull(ib.FLot,'YNi0IQEOEADgBT3mfwAAAcznrtQ=') FLot");
            }
            if (params.getBoolean("isShowAssitProperty")) {
                br.append(",ib.FAssistPropertyID");
            }
            if (params.getBoolean("isShowProject")) {
                br.append(",ib.FProjectID");
            }
            if (params.getBoolean("isShowTrackNum")) {
                br.append(",ib.FTracknumberID");
            }
            br.append(",sum(ib.FPeriodEndQty) Fqty,sum(ib.FPeriodEndQty) FWriteQty,").append("\r\n");
            br.append("decimal(0.0,21,8) FActualCost,").append("\r\n");
            br.append("decimal(0.0,21,8) FPrice").append("\r\n");
            ArrayList ageSegment = this.getAgeSegment(ctx, params);
            for (int i = 0; i < ageSegment.size() + 1; ++i) {
                br.append(",decimal(0.0,21,8) FD" + i);
                br.append(",decimal(0.0,21,8) Famount" + i);
            }
            br.append(",1 flevel");
            br.append(",0 fisleaf");
            br.append(",FStorageOrgUnitID fparentid");
            br.append(" into t_im_inventoryTemp ").append("\r\n");
            br.append(" from t_im_inventorybalance ib").append("\r\n");
            br.append(innerJoinSql);
            br.append(" where ib.Fyear=").append(spYear).append("\r\n");
            br.append(" and ib.FPeriod=").append(spPeriod).append("\r\n");
            br.append(" and material.fid in (");
            br.append(this.getMaterialFilterSql(ctx, params));
            br.append(")");
            br.append(this.getFilter(ctx, params, null)).append("\r\n");
            br.append(this.getGroupby(ctx, params)).append("\r\n");
            CreateTempTableResult temptableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)br.toString(), null, (Connection)conn);
            tempName = temptableResult.getTempTable();
            String indexCol = "FStorageOrgUnitID,FMaterialID";
            if (params.getBoolean("isShowWareHouse")) {
                indexCol = indexCol + ",FWarehouseID";
            }
            if (params.getBoolean("isShowLot")) {
                indexCol = indexCol + ",FLot";
            }
            com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)tempName, (String)indexCol, (boolean)false);
            this.updateActualAmount(ctx, tempName, params);
        }
        if (IsIntimeStore.booleanValue()) {
            br.append("select newbosid('88888888') Fid,ib.FStorageOrgUnitID,ib.FMaterialID").append("\r\n");
            if (params.getBoolean("isShowWareHouse")) {
                br.append(",case when ib.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' then null else ib.FWarehouseID end as FWarehouseID");
            }
            if (params.getBoolean("isShowType")) {
                br.append(",ib.fstoretypeid FInventoryTypeID");
            }
            if (params.getBoolean("isShowLocation")) {
                br.append(",case when ib.FLocationId = '").append("EgkAAABc3XMgX/hq").append("' then null else ib.FLocationId end as FLocationId");
            }
            if (params.getBoolean("isShowLot")) {
                br.append(",ib.FLot");
            }
            if (params.getBoolean("isShowAssitProperty")) {
                br.append(",ib.FAssistPropertyID");
            }
            if (params.getBoolean("isShowProject")) {
                br.append(",ib.FProjectID");
            }
            if (params.getBoolean("isShowTrackNum")) {
                br.append(",ib.FTracknumberID");
            }
            br.append(",sum(ib.fbaseqty) Fqty,sum(ib.fbaseqty) FWriteQty,").append("\r\n");
            br.append("decimal(0.0,21,8) FActualCost,").append("\r\n");
            br.append("decimal(0.0,21,8) FPrice").append("\r\n");
            ArrayList ageSegment = this.getAgeSegment(ctx, params);
            for (int i = 0; i < ageSegment.size() + 1; ++i) {
                br.append(",decimal(0.0,21,8) FD" + i);
                br.append(",decimal(0.0,21,8) Famount" + i);
            }
            br.append(",1 flevel");
            br.append(",0 fisleaf");
            br.append(",0 fdelete");
            br.append(",FStorageOrgUnitID fparentid");
            br.append(",decimal(0.0,21,8) FActualBaseUnitCost");
            br.append(",6 FPricePrecision");
            br.append(",4 FlocalcurrencyPrecision");
            br.append(",ib.FCompanyOrgUnitId");
            br.append(",sum(ib.fbaseqty) Fbaseqty");
            br.append(" into t_im_inventoryTemp ").append("\r\n");
            br.append(" from t_im_inventory ib").append("\r\n");
            br.append(innerJoinSql);
            br.append(" where 1=1").append("\r\n");
            br.append(" and material.fid in (");
            br.append(this.getMaterialFilterSql(ctx, params));
            br.append(")");
            br.append(this.getFilter(ctx, params, null)).append("\r\n");
            br.append(this.getGroupby(ctx, params)).append("\r\n");
            CreateTempTableResult temptableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)br.toString(), null, (Connection)conn);
            tempName = temptableResult.getTempTable();
            String indexCol = "FStorageOrgUnitID,FMaterialID";
            if (params.getBoolean("isShowWareHouse")) {
                indexCol = indexCol + ",FWarehouseID";
            }
            if (params.getBoolean("isShowLot")) {
                indexCol = indexCol + ",FLot";
            }
            com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)tempName, (String)indexCol, (boolean)false);
            this.updateActualAmount(ctx, tempName, params);
            this.updateDefaultValue2Null(ctx, tempName, params);
        }
        this.close(conn);
        return tempName;
    }

    private void updateDefaultValue2Null(Context ctx, String tempName, RptParams params) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (params.getBoolean("isShowWareHouse")) {
            updateSql.append(" update ").append(tempName).append(" set FWarehouseID = null ");
            updateSql.append(" where FWarehouseID = '").append("EgkAAABc3XG76fiu").append("'");
            sqlList.add(updateSql.toString());
            updateSql.setLength(0);
        }
        if (params.getBoolean("isShowLocation")) {
            updateSql.append(" update ").append(tempName).append(" set FLocationId = null ");
            updateSql.append(" where FLocationId = '").append("EgkAAABc3XMgX/hq").append("'");
            sqlList.add(updateSql.toString());
            updateSql.setLength(0);
        }
        if (params.getBoolean("isShowAssitProperty")) {
            updateSql.append(" update ").append(tempName).append(" set FAssistPropertyID = null ");
            updateSql.append(" where FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("'");
            sqlList.add(updateSql.toString());
            updateSql.setLength(0);
        }
        if (params.getBoolean("isShowProject")) {
            updateSql.append(" update ").append(tempName).append(" set FProjectID = null ");
            updateSql.append(" where FProjectID = '").append("EgkAAABc3Xza3gXu").append("'");
            sqlList.add(updateSql.toString());
            updateSql.setLength(0);
        }
        if (params.getBoolean("isShowTrackNum")) {
            updateSql.append(" update ").append(tempName).append(" set FTracknumberID = null ");
            updateSql.append(" where FTracknumberID = '").append("EgkAAABc3X0Ibpg9").append("'");
            sqlList.add(updateSql.toString());
            updateSql.setLength(0);
        }
        String[] sqlArr = new String[sqlList.size()];
        sqlList.toArray(sqlArr);
        com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String[])sqlArr);
    }

    protected void updateActualAmount(Context ctx, String tempName, RptParams params) throws BOSException, SQLException {
        int spYear = (Integer)params.getObject("spYear");
        int spPeriod = (Integer)params.getObject("spPeriod");
        boolean IsIntimeStore = (Boolean)params.getObject("IsIntimeStore");
        String createTableStr = "create table t_rtp_invTpaiukmoun(FStorageOrgUnitID varchar(44),FMaterialID varchar(44), FWareHouseID varchar(44),FLot nvarchar(80),FProjectID varchar(44),FTracknumberID varchar(44),FAssistPropertyID varchar(44),FLocationId varchar(44), fsumactualcost NUMERIC(17,4) null,fsumqty NUMERIC(21,8) null)";
        Connection conn = this.getConnection(ctx);
        StringBuffer br = new StringBuffer();
        String tempAmountName = null;
        if (!IsIntimeStore) {
            tempAmountName = com.kingdee.eas.scm.cal.util.DBUtil.createTempTable((Context)ctx, (String)createTableStr);
            String indexColumns = "FStorageOrgUnitID,FMaterialID";
            if (params.getBoolean("isShowWareHouse")) {
                indexColumns = indexColumns + ",FWarehouseID";
            }
            if (params.getBoolean("isShowLot")) {
                indexColumns = indexColumns + ",FLot";
            }
            com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)tempAmountName, (String)indexColumns, (boolean)false);
            boolean isShowWareHouse = params.getBoolean("isShowWareHouse");
            boolean isShowLocation = params.getBoolean("isShowLocation");
            boolean isShowLot = params.getBoolean("isShowLot");
            boolean isShowAssitProperty = params.getBoolean("isShowAssitProperty");
            boolean isShowProject = params.getBoolean("isShowProject");
            boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
            StringBuffer innerStr = new StringBuffer();
            innerStr.append(" inner join T_ORG_BaseUnit orgUnit on orgUnit.FID=ib.FStorageOrgUnitID").append("\r\n");
            if (this.matpermSql != null) {
                innerStr.append(" inner join t_bd_material material on ib.FMaterialID=material.Fid").append("\r\n");
            }
            if (this.warepermSql != null || params.getObject("warehouseFrom") != null || params.getObject("warehouseTo") != null) {
                innerStr.append(" inner join t_db_warehouse wareHouse on ib.FWarehouseID=wareHouse.Fid").append("\r\n");
            }
            if (params.getObject("storeTypeFrom") != null) {
                innerStr.append(" inner join t_im_storetype storeType on storeType.Fid=ib.FStoreTypeID").append("\r\n");
            }
            if (params.getObject("assiAsstPropFrom") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropFrom").toString()) || params.getObject("assiAsstPropTo") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropTo").toString())) {
                innerStr.append("inner join t_bd_asstattrvalue asst on ib.FAssistPropertyId = asst.fid ").append("\r\n");
            }
            if (params.getObject("projectNumFrom") instanceof ProjectInfo || params.getObject("projectNumTo") instanceof ProjectInfo) {
                innerStr.append("inner join T_MM_Project project on ib.FProjectID = project.FID ").append("\r\n");
            }
            if (params.getObject("trackNumFrom") instanceof TrackNumberInfo || params.getObject("trackNumTo") instanceof TrackNumberInfo) {
                innerStr.append("inner join T_MM_TrackNumber track on ib.FTrackNumberID = track.FID ").append("\r\n");
            }
            innerStr.append(" inner join T_BD_MaterialCompanyInfo matcou on matcou.FMaterialID = ib.FMaterialID and matcou.FCompanyID = ib.FCompanyOrgUnitID").append("\r\n");
            if (isShowWareHouse) {
                br.append("insert into ").append(tempAmountName).append("(FStorageOrgUnitID,FMaterialID,FWareHouseID, fsumactualcost,fsumqty) ");
            } else {
                br.append("insert into ").append(tempAmountName).append("(FStorageOrgUnitID,FMaterialID,fsumactualcost,fsumqty) ");
            }
            br.append("select ib.FStorageOrgUnitID ,ib.FMaterialID,").append("\r\n");
            if (isShowWareHouse) {
                br.append(" ib.FWarehouseID,").append("\r\n");
            }
            br.append("sum(ib.FPeriodEndActualCost) factualcost,sum(ib.FPeriodEndQty) fqty").append("\r\n");
            br.append("from t_im_inventorybalance ib").append("\r\n");
            br.append(innerStr);
            br.append(" where 1=1 and ib.Fyear=").append(spYear).append("\r\n");
            br.append(" and ib.FPeriod=").append(spPeriod).append("\r\n");
            br.append(" and ib.FStoreTypeID in ('181875d5-0105-1000-e000-011ac0a812fd97D461A6',").append("\r\n");
            br.append("'181875d5-0105-1000-e000-0111c0a812fd97D461A6')").append("\r\n");
            br.append(this.getFilter(ctx, params, null)).append("\r\n");
            br.append(" and ib.FMaterialID in (");
            br.append(this.getMaterialFilterSql(ctx, params));
            br.append(")");
            br.append(" and matcou.FACCOUNTTYPE <> 5").append("\r\n");
            if (this.matpermSql != null) {
                br.append(this.matpermSql);
            }
            if (this.warepermSql != null) {
                br.append(this.warepermSql);
            }
            br.append("");
            br.append(" group by ib.FStorageOrgUnitID,ib.FMaterialID");
            if (isShowWareHouse) {
                br.append(" ,ib.FWarehouseID ");
            }
            DBUtil.execute((String)br.toString(), (Connection)conn);
            br.setLength(0);
            br.append("update ").append(tempName).append(" set (FPrice,FActualCost)=").append("\r\n");
            br.append("(select fsumactualcost/(case fsumqty when 0 then 1 else fsumqty end) fprice,").append("\r\n");
            br.append(tempName).append(".fqty*fsumactualcost/(case fsumqty when 0 then 1 else fsumqty end)").append("\r\n");
            br.append("from ").append(tempAmountName).append(" t");
            br.append(" where t.FStorageOrgUnitID=").append(tempName).append(".FStorageOrgUnitID").append("\r\n");
            br.append(" and t.FMaterialID=").append(tempName).append(".FMaterialID ").append("\r\n");
            if (isShowWareHouse) {
                br.append(" and t.FWarehouseID =").append(tempName).append(".FWarehouseID ").append("\r\n");
            }
            br.append(" )");
            DBUtil.executeUpdate((String)br.toString(), (Connection)conn);
            this.dropTempTable(tempAmountName, ctx);
            br.setLength(0);
            tempAmountName = com.kingdee.eas.scm.cal.util.DBUtil.createTempTable((Context)ctx, (String)createTableStr);
            com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)tempAmountName, (String)indexColumns, (boolean)false);
            br.append("insert into ").append(tempAmountName).append("(FStorageOrgUnitID,FMaterialID,");
            if (isShowWareHouse) {
                br.append("FWareHouseID,");
            }
            if (isShowLot) {
                br.append("FLot,");
            }
            if (isShowProject) {
                br.append("FProjectID, ");
            }
            if (isShowTrackNum) {
                br.append("FTrackNumberID, ");
            }
            if (isShowAssitProperty) {
                br.append("FAssistPropertyID, ");
            }
            if (isShowLocation) {
                br.append("FLocationID, ");
            }
            br.append(" fsumactualcost,fsumqty)");
            br.append("select ib.FStorageOrgUnitID ,ib.FMaterialID,").append("\r\n");
            if (isShowWareHouse) {
                br.append("ib.FWarehouseID,").append("\r\n");
            }
            if (isShowLot) {
                br.append("isnull(ib.FLot,'YNi0IQEOEADgBT3mfwAAAcznrtQ='),").append("\r\n");
            }
            if (isShowProject) {
                br.append("FProjectID, ");
            }
            if (isShowTrackNum) {
                br.append("FTrackNumberID, ");
            }
            if (isShowAssitProperty) {
                br.append("FAssistPropertyID, ");
            }
            if (isShowLocation) {
                br.append("FLocationID, ");
            }
            br.append("sum(ib.FPeriodEndActualCost) factualcost,sum(ib.FPeriodEndQty) fqty").append("\r\n");
            br.append("from t_im_inventorybalance ib").append("\r\n");
            br.append(innerStr);
            br.append(" where 1=1 and ib.Fyear=").append(spYear).append("\r\n");
            br.append(" and ib.FPeriod=").append(spPeriod).append("\r\n");
            br.append(" and ib.FStoreTypeID in ('181875d5-0105-1000-e000-011ac0a812fd97D461A6',").append("\r\n");
            br.append("'181875d5-0105-1000-e000-0111c0a812fd97D461A6')").append("\r\n");
            br.append(this.getFilter(ctx, params, null));
            br.append(" and ib.FMaterialID in (");
            br.append(this.getMaterialFilterSql(ctx, params));
            br.append(")");
            br.append(" and matcou.FACCOUNTTYPE = 5").append("\r\n");
            if (this.matpermSql != null) {
                br.append(this.matpermSql);
            }
            if (this.warepermSql != null) {
                br.append(this.warepermSql);
            }
            br.append("");
            br.append(" group by ib.FStorageOrgUnitID,ib.FMaterialID");
            if (isShowWareHouse) {
                br.append(" ,ib.FWarehouseID ");
            }
            if (isShowLot) {
                br.append(",ib.FLot");
            }
            if (isShowProject) {
                br.append(",ib.FProjectID");
            }
            if (isShowTrackNum) {
                br.append(",ib.FTrackNumberID");
            }
            if (isShowAssitProperty) {
                br.append(",ib.FAssistPropertyID");
            }
            if (isShowLocation) {
                br.append(",ib.FLocationID");
            }
            DBUtil.execute((String)br.toString(), (Connection)conn);
            br.setLength(0);
            br.append("update ").append(tempName).append(" set (FPrice,FActualCost)=").append("\r\n");
            br.append("(select fsumactualcost/(case fsumqty when 0 then 1 else fsumqty end) fprice,").append("\r\n");
            br.append("fsumactualcost").append("\r\n");
            br.append("from ").append(tempAmountName).append(" t");
            br.append(" where t.FStorageOrgUnitID=").append(tempName).append(".FStorageOrgUnitID").append("\r\n");
            br.append(" and t.FMaterialID=").append(tempName).append(".FMaterialID ").append("\r\n");
            if (isShowWareHouse) {
                br.append(" and isnull(").append("t").append(".FWarehouseID,'XXXXX')=isnull(" + tempName + ".FWarehouseID,'XXXXX')").append("\r\n");
            }
            if (isShowLot) {
                br.append(" and isnull(").append("t").append(".FLot,'XXXXX')=isnull(" + tempName + ".FLot,'XXXXX')").append("\r\n");
            }
            if (isShowProject) {
                br.append(" and isnull(").append("t").append(".FProjectID,'XXXXX')=isnull(" + tempName + ".FProjectID,'XXXXX')").append("\r\n");
            }
            if (isShowTrackNum) {
                br.append(" and isnull(").append("t").append(".FTrackNumberID,'XXXXX')=isnull(" + tempName + ".FTrackNumberID,'XXXXX')").append("\r\n");
            }
            if (isShowAssitProperty) {
                br.append(" and isnull(").append("t").append(".FAssistPropertyID,'XXXXX')=isnull(" + tempName + ".FAssistPropertyID,'XXXXX')").append("\r\n");
            }
            if (isShowLocation) {
                br.append(" and isnull(").append("t").append(".FLocationID,'XXXXX')=isnull(" + tempName + ".FLocationID,'XXXXX')").append("\r\n");
            }
            br.append(" )");
            DBUtil.executeUpdate((String)br.toString(), (Connection)conn);
            this.dropTempTable(tempAmountName, ctx);
        }
        br.setLength(0);
        br.append("delete from ").append(tempName).append(" where fqty=0 and factualcost=0");
        DBUtil.execute((String)br.toString(), (Connection)conn);
        this.close(conn);
    }

    private String getBillStorageFilter(RptParams params) {
        StringBuffer whereSQL = new StringBuffer();
        Object[] storageOrgList = (Object[])params.getObject("storageOrgInfo");
        whereSQL.append(" and bill.FStorageOrgUnitID IN (");
        for (int i = 0; i < storageOrgList.length; ++i) {
            String storageId = ((FullOrgUnitInfo)storageOrgList[i]).getId().toString();
            if (i > 0) {
                whereSQL.append(",");
            }
            whereSQL.append("'").append(storageId).append("'");
        }
        whereSQL.append(")");
        return whereSQL.toString();
    }

    protected String getFilter(Context ctx, RptParams params, String alias) throws BOSException {
        StringBuffer whereSQl = new StringBuffer();
        Set authorUnitSet = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inventoryAge_view");
        Set cuUnitSets = InvServerUtils.getSelAuthorUnit(authorUnitSet, (Object[])params.getObject("storageOrgInfo"));
        Object[] storageOrgList = cuUnitSets.toArray();
        if (storageOrgList.length != 0) {
            whereSQl.append(" and orgUnit.FID in (");
            for (int i = 0; i < storageOrgList.length; ++i) {
                whereSQl.append("'" + ((OrgUnitInfo)storageOrgList[i]).getId().toString() + "',");
            }
            int index = whereSQl.lastIndexOf(",");
            whereSQl.deleteCharAt(index);
            whereSQl.append(") \r\n  ");
        } else {
            whereSQl.append(" and orgUnit.FID = '").append("111111111111111111111111111=").append("'");
        }
        if (params.getObject("warehouseFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("warehouseFrom"));
            if (numArray[0] != null) {
                whereSQl.append("  and wareHouse.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                whereSQl.append("  and wareHouse.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getObject("warehouseTo") != null) {
            WarehouseInfo wareHouseTo = (WarehouseInfo)params.getObject("warehouseTo");
            whereSQl.append("  and wareHouse.FNumber <='");
            whereSQl.append(wareHouseTo.getNumber() + "' \r\n ");
        }
        if (params.getObject("storeTypeFrom") != null) {
            Object storeType = params.getObject("storeTypeFrom");
            String storetypeNumber = "";
            if (storeType instanceof String) {
                storetypeNumber = "'" + (String)storeType + "'";
            } else if (storeType instanceof StoreTypeInfo) {
                storetypeNumber = "'" + ((StoreTypeInfo)storeType).getNumber() + "'";
            } else {
                Object[] storetypeList = (Object[])storeType;
                for (int i = 0; i < storetypeList.length; ++i) {
                    if (storetypeList[i] == null) continue;
                    storetypeNumber = storetypeNumber + "'" + ((StoreTypeInfo)storetypeList[i]).getNumber() + "',";
                }
                if (storetypeNumber.length() > 0) {
                    int index = storetypeNumber.lastIndexOf(",");
                    storetypeNumber = storetypeNumber.substring(0, index);
                }
            }
            if (storetypeNumber.length() > 0) {
                whereSQl.append(" and storeType.FNumber  in (" + storetypeNumber + ")");
            }
        }
        if (params.getObject("assiAsstPropFrom") instanceof AsstAttrValueInfo) {
            AsstAttrValueInfo asst = (AsstAttrValueInfo)params.getObject("assiAsstPropFrom");
            whereSQl.append(" and asst.fnumber >='");
            whereSQl.append(asst.getNumber() + "' \r\n ");
        } else if (params.getObject("assiAsstPropFrom") instanceof String) {
            String asst = (String)params.getObject("assiAsstPropFrom");
            whereSQl.append(" and asst.fnumber >='");
            whereSQl.append(asst + "' \r\n ");
        }
        if (params.getObject("assiAsstPropTo") instanceof AsstAttrValueInfo) {
            AsstAttrValueInfo asst = (AsstAttrValueInfo)params.getObject("assiAsstPropTo");
            whereSQl.append(" and asst.fnumber  <='");
            whereSQl.append(asst.getNumber() + "' \r\n ");
        } else if (params.getObject("assiAsstPropTo") instanceof String) {
            String asst = (String)params.getObject("assiAsstPropTo");
            whereSQl.append(" and asst.fnumber <='");
            whereSQl.append(asst + "' \r\n ");
        }
        if (params.getObject("projectNumFrom") instanceof ProjectInfo) {
            ProjectInfo project = (ProjectInfo)params.getObject("projectNumFrom");
            whereSQl.append(" and project.fnumber  >='");
            whereSQl.append(project.getNumber() + "' \r\n ");
        }
        if (params.getObject("projectNumTo") instanceof ProjectInfo) {
            ProjectInfo project = (ProjectInfo)params.getObject("projectNumTo");
            whereSQl.append(" and project.fnumber  <='");
            whereSQl.append(project.getNumber() + "' \r\n ");
        }
        if (params.getObject("trackNumFrom") instanceof TrackNumberInfo) {
            TrackNumberInfo track = (TrackNumberInfo)params.getObject("trackNumFrom");
            whereSQl.append(" and track.fnumber  >='");
            whereSQl.append(track.getNumber() + "' \r\n ");
        }
        if (params.getObject("trackNumTo") instanceof TrackNumberInfo) {
            TrackNumberInfo track = (TrackNumberInfo)params.getObject("trackNumTo");
            whereSQl.append(" and track.fnumber  <='");
            whereSQl.append(track.getNumber() + "' \r\n ");
        }
        if (this.matpermSql != null) {
            if (alias != null) {
                String matWhere = this.matpermSql.replaceAll("ib.", alias + ".");
                whereSQl.append(matWhere);
            } else {
                whereSQl.append(this.matpermSql);
            }
        }
        if (this.warepermSql != null) {
            if (alias != null) {
                String wareWhere = this.warepermSql.replaceAll("ib.", alias + ".");
                whereSQl.append(wareWhere);
            } else {
                whereSQl.append(this.warepermSql);
            }
        }
        return whereSQl.toString();
    }

    protected String getGroupby(Context ctx, RptParams params) throws BOSException {
        StringBuffer groupBySQl = new StringBuffer("group by ib.FStorageOrgUnitID,ib.FMaterialID,ib.FCompanyOrgUnitId").append("\r\n");
        Boolean IsIntimeStore = (Boolean)params.getObject("IsIntimeStore");
        if (params.getBoolean("isShowWareHouse")) {
            groupBySQl.append(",ib.FWarehouseID");
        }
        if (params.getBoolean("isShowType") && IsIntimeStore.booleanValue()) {
            groupBySQl.append(",ib.fstoretypeid");
        } else if (params.getBoolean("isShowType")) {
            groupBySQl.append(",ib.FStoreTypeID");
        }
        if (params.getBoolean("isShowLocation")) {
            groupBySQl.append(",ib.FLocationId");
        }
        if (params.getBoolean("isShowLot")) {
            groupBySQl.append(",ib.FLot");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            groupBySQl.append(",ib.FAssistPropertyID");
        }
        if (params.getBoolean("isShowProject")) {
            groupBySQl.append(",ib.FProjectID");
        }
        if (params.getBoolean("isShowTrackNum")) {
            groupBySQl.append(",ib.FTracknumberID");
        }
        return groupBySQl.toString();
    }

    protected ArrayList getAgeSegment(Context ctx, RptParams params) throws BOSException, InvBizException {
        ArrayList alDayValue = (ArrayList)params.getObject("daytitles");
        if (alDayValue.size() == 0) {
            return new ArrayList();
        }
        int[] days = new int[alDayValue.size() - 1];
        for (int i1 = 0; i1 < alDayValue.size() - 1; ++i1) {
            String temp = ((String)alDayValue.get(i1)).substring(((String)alDayValue.get(i1)).indexOf("-") + 1);
            if (temp == null) continue;
            days[i1] = Integer.parseInt(temp);
        }
        int daylen = days.length;
        ArrayList<Date> alDates = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        for (int i1 = 0; i1 < daylen; ++i1) {
            cal.setTime(this.getEndDate(ctx, params));
            cal.add(5, -1 * days[i1]);
            alDates.add(new Date(cal.getTimeInMillis()));
        }
        return alDates;
    }

    protected java.util.Date getEndDate(Context ctx, RptParams params) throws BOSException, InvBizException {
        Boolean IsIntimeStore = (Boolean)params.getObject("IsIntimeStore");
        Boolean IsEndDateStore = (Boolean)params.getObject("IsEndDateStore");
        Boolean IsPeriodStore = (Boolean)params.getObject("IsPeriodStore");
        java.util.Date endDate2 = new java.util.Date();
        if (IsIntimeStore != null && IsIntimeStore.booleanValue()) {
            endDate2 = new java.util.Date();
        }
        if (IsEndDateStore != null && IsEndDateStore.booleanValue()) {
            endDate2 = (java.util.Date)params.getObject("endDate");
        }
        if (IsPeriodStore != null && IsPeriodStore.booleanValue()) {
            int spYear = 0;
            int spPeriod = 0;
            spYear = (Integer)params.getObject("spYear");
            spPeriod = (Integer)params.getObject("spPeriod");
            String key = spYear + "" + spPeriod;
            java.util.Date dateO = this.mapDate.get(key);
            if (dateO == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(spYear), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(spPeriod), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
                PeriodCollection periodInfo = iPeriod.getPeriodCollection(viewInfo);
                if (periodInfo.get(0) != null) {
                    endDate2 = periodInfo.get(0).getEndDate();
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, 1000);
                    endDate2 = cal.getTime();
                }
                this.mapDate.put(key, endDate2);
            } else {
                endDate2 = dateO;
            }
        }
        return endDate2;
    }

    private String getJoinTempTableName(Context ctx, String tempName, RptParams params) throws BOSException {
        String result = null;
        Connection conn = null;
        int FixTempSize = 10000;
        int tempSize = 20000;
        try {
            conn = this.getConnection(ctx);
            String insertTempSql = "select count(1) fcount from " + tempName + " where FWriteQty>0";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)insertTempSql);
            if (ResourceBase.getString((String)resClassName, (String)"tempSize", (Locale)ctx.getLocale()) != null) {
                FixTempSize = Integer.parseInt(ResourceBase.getString((String)resClassName, (String)"tempSize", (Locale)ctx.getLocale()));
            }
            if (rs != null && rs.size() > 0 && rs.next()) {
                tempSize = rs.getInt(1);
            }
            if (tempSize == 0) {
                String string = result;
                return string;
            }
            CreateTempTableResult temptableResult = null;
            if (tempSize < FixTempSize) {
                insertTempSql = "select * into t_rpt_invetoryZeroTemp from " + tempName + " where FWriteQty>0";
                temptableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)insertTempSql, null, (Connection)conn);
                result = temptableResult.getTempTable();
                StringBuffer indexCol = new StringBuffer("FStorageOrgUnitID,FMaterialID");
                if (params.getBoolean("isShowWareHouse")) {
                    indexCol.append(",FWarehouseID");
                }
                if (params.getBoolean("isShowType")) {
                    indexCol.append(",FInventoryTypeID");
                }
                if (params.getBoolean("isShowLocation")) {
                    indexCol.append(",FLocationId");
                }
                if (params.getBoolean("isShowLot")) {
                    indexCol.append(",FLot");
                }
                if (params.getBoolean("isShowAssitProperty")) {
                    indexCol.append(",FAssistPropertyID");
                }
                if (params.getBoolean("isShowProject")) {
                    indexCol.append(",FProjectID");
                }
                if (params.getBoolean("isShowTrackNum")) {
                    indexCol.append(",FTracknumberID");
                }
                com.kingdee.eas.scm.cal.util.DBUtil.createTempTableIndex((Context)ctx, (String)result, (String)indexCol.toString(), (boolean)false);
            } else {
                result = No_Need_TempTable;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
        return result;
    }

    protected String getInWareSql(Context ctx, RptParams params, String tempName, String tempZeroTable, String middleTempTable, Date beginDateObj, Date endDateObj) throws BOSException {
        String beginDate = beginDateObj + " 00:00:00";
        String endDate = endDateObj + " 23:59:59";
        boolean isAddTemp = !No_Need_TempTable.equals(tempZeroTable);
        boolean IsSaleBack = (Boolean)params.getObject("IsSaleBack");
        boolean IsOtherIssueBillBack = (Boolean)params.getObject("IsOtherIssueBillBack");
        boolean IsMaterialBack = (Boolean)params.getObject("IsMaterialBack");
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String clearTableSQL = "Truncate Table " + middleTempTable;
            DBUtil.execute((String)clearTableSQL, (Connection)conn);
            StringBuffer insertSQL = new StringBuffer();
            insertSQL.append("Insert into ").append(middleTempTable);
            insertSQL.append("(FStorageOrgUnitID, FMaterialID, FWarehouseID, FInventoryTypeID, FLocationId, FLot,FAssistPropertyId,FProjectId,FTrackNumberId,FQty)").append("\r\n");
            StringBuffer selectSQL = new StringBuffer();
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_InventoryInitBill", "T_IM_InventoryInitEntry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "t_im_purinwarehsbill", "t_im_purinwarehsentry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            if (params.getBoolean("isShowLocation")) {
                selectSQL.setLength(0);
                selectSQL.append(insertSQL.toString());
                selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_MoveLocationBill", "T_IM_MoveLocationBillEntry", beginDate, endDate, isAddTemp, false));
                DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            }
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_MoveInWarehsBill", "T_IM_MoveInwarehsBillEntry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_OtherInWarehsBill", "T_IM_Otherinwarehsbillentry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_ManufactureRecBill", "t_Im_Manufacturerecbillentry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "T_IM_PurReceivalBill", "T_IM_PurReceivalEntry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            if (IsSaleBack) {
                selectSQL.setLength(0);
                selectSQL.append(insertSQL.toString());
                selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "t_im_saleissuebill", "t_im_saleissueentry", beginDate, endDate, isAddTemp, true));
                DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            }
            if (IsOtherIssueBillBack) {
                selectSQL.setLength(0);
                selectSQL.append(insertSQL.toString());
                selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "t_im_otherissuebill", "t_im_otherissuebillentry", beginDate, endDate, isAddTemp, true));
                DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            }
            if (IsMaterialBack) {
                selectSQL.setLength(0);
                selectSQL.append(insertSQL.toString());
                selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "t_im_materialreqbill", "t_im_materialreqbillentry", beginDate, endDate, isAddTemp, true));
                DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
            }
            selectSQL.setLength(0);
            selectSQL.append(insertSQL.toString());
            selectSQL.append(this.getSelectDetailSQL(ctx, params, tempZeroTable, "t_im_saleissuebill", "t_im_saleissueentry", beginDate, endDate, isAddTemp, false));
            DBUtil.execute((String)selectSQL.toString(), (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
        StringBuffer br = new StringBuffer();
        StringBuffer groupBy = new StringBuffer();
        br.append("select FStorageOrgUnitID,FMaterialID").append("\r\n");
        groupBy.append(" group by FStorageOrgUnitID,FMaterialID");
        if (params.getBoolean("isShowWareHouse")) {
            br.append(",FWarehouseID");
            groupBy.append(",FWarehouseID");
        }
        if (params.getBoolean("isShowType")) {
            br.append(",FInventoryTypeID");
            groupBy.append(",FInventoryTypeID");
        }
        if (params.getBoolean("isShowLocation")) {
            br.append(",FLocationId");
            groupBy.append(",FLocationId");
        }
        if (params.getBoolean("isShowLot")) {
            br.append(",FLot");
            groupBy.append(",FLot");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            br.append(",FAssistPropertyID");
            groupBy.append(",FAssistPropertyID");
        }
        if (params.getBoolean("isShowProject")) {
            br.append(",FProjectID");
            groupBy.append(",FProjectID");
        }
        if (params.getBoolean("isShowTrackNum")) {
            br.append(",FTracknumberID");
            groupBy.append(",FTracknumberID");
        }
        br.append(",SUM(FQty) FQty").append("\r\n");
        br.append(" into t_rtp_inventoryUpdate ").append("\r\n");
        br.append(" from ").append(middleTempTable).append("\r\n");
        br.append(groupBy.toString()).append("\r\n");
        return br.toString();
    }

    private String getSelectDetailSQL(Context ctx, RptParams params, String tempZeroTable, String billTableName, String entryTableName, String beginDate, String endDate, boolean isAddTemp, boolean isBack) throws BOSException {
        boolean isCannibalize = (Boolean)params.getObject("IsCannibalize");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("select bill.fstorageorgunitid FStorageOrgUnitID,billentry.fmaterialid FMaterialID,").append("\r\n");
        sSQL.append("billentry.fwarehouseid FWarehouseID,storeType.Fid FInventoryTypeID,").append("\r\n");
        if (billTableName.equalsIgnoreCase("T_IM_MoveLocationBill")) {
            sSQL.append("billentry.freceiptlocationid FLocationID,").append("\r\n");
        } else {
            sSQL.append("billentry.flocationid FLocationID,").append("\r\n");
        }
        sSQL.append("isnull(billentry.flot,'YNi0IQEOEADgBT3mfwAAAcznrtQ=') flot,").append("\r\n");
        sSQL.append("billentry.FAssistPropertyId FAssistPropertyId, billentry.FProjectId as FProjectId,billentry.FTrackNumberId as FTrackNumberId,");
        if (isBack) {
            sSQL.append(" abs(billentry.fbaseqty) fqty ");
        } else {
            sSQL.append(" billentry.fbaseqty fqty ");
        }
        sSQL.append("from ").append(billTableName).append(" bill").append("\r\n");
        sSQL.append("inner join ").append(entryTableName).append(" billentry on bill.fid=billentry.fparentid").append("\r\n");
        if (!billTableName.equalsIgnoreCase("T_IM_MoveLocationBill") && !billTableName.equalsIgnoreCase("T_IM_InventoryInitBill")) {
            sSQL.append("inner join T_IM_InvUpdateType invUpd on billentry.finvupdatetypeid=invUpd.fid ").append("\r\n");
            if (params.getBoolean("ckBxShowUpdateInventoryBill")) {
                sSQL.append("and invUpd.FIsNotUpdateInv = 0").append("\r\n");
            }
            sSQL.append("inner join t_scm_transactiontype e on bill.ftransactiontypeid = e.fid ");
            sSQL.append("inner join T_IM_RecIssueType riType on e.FRITypeID = riType.fid ");
        }
        if (isBack) {
            sSQL.append("inner join t_im_storetype storeType on storeType.fid=invUpd.fstoretypepreid").append("\r\n");
        } else if (billTableName.equalsIgnoreCase("T_IM_MoveLocationBill") || billTableName.equalsIgnoreCase("T_IM_InventoryInitBill")) {
            sSQL.append("inner join t_im_storetype storeType on storeType.fid=billentry.FStoreTypeID").append("\r\n");
        } else {
            sSQL.append("inner join t_im_storetype storeType on storeType.fid=invUpd.fstoretypeid").append("\r\n");
        }
        sSQL.append("inner join t_org_storage orgUnit on orgUnit.Fid=bill.fstorageorgunitid").append("\r\n");
        sSQL.append("inner join t_bd_material material on billentry.FMaterialID=material.Fid").append("\r\n");
        sSQL.append("inner join t_db_warehouse wareHouse on wareHouse.Fid=billentry.fwarehouseid").append("\r\n");
        if (params.getObject("assiAsstPropFrom") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropFrom").toString()) || params.getObject("assiAsstPropTo") != null && !StringUtil.isEmpty((String)params.getObject("assiAsstPropTo").toString())) {
            sSQL.append("inner join t_bd_asstattrvalue asst on billentry.FAssistPropertyId = asst.fid ").append("\r\n");
        }
        if (params.getObject("projectNumFrom") instanceof ProjectInfo || params.getObject("projectNumTo") instanceof ProjectInfo) {
            sSQL.append("inner join T_MM_Project project on billentry.FProjectID = project.FID ").append("\r\n");
        }
        if (params.getObject("trackNumFrom") instanceof TrackNumberInfo || params.getObject("trackNumTo") instanceof TrackNumberInfo) {
            sSQL.append("inner join T_MM_TrackNumber track on billentry.FTrackNumberID = track.FID ").append("\r\n");
        }
        if ("T_IM_MoveInWarehsBill".equals(billTableName) && !isCannibalize) {
            sSQL.append("inner join T_SCM_BizType bizType on bill.FBizTypeID = bizType.FID ").append("\r\n");
            sSQL.append("inner join T_SCM_BizCategory bizCate on bizType.FBizCategoryID = bizCate.FID ").append("\r\n");
        }
        if (isAddTemp) {
            if (billTableName.equalsIgnoreCase("T_IM_MoveLocationBill")) {
                sSQL.append(this.getJoinTempTable(ctx, params, tempZeroTable, true));
            } else {
                sSQL.append(this.getJoinTempTable(ctx, params, tempZeroTable, false));
            }
        }
        if (this.matpermJoinSql != null) {
            sSQL.append(this.matpermJoinSql);
        }
        if (this.warepermJoinSql != null) {
            sSQL.append(this.warepermJoinSql);
        }
        sSQL.append("where bill.Fbasestatus = 4 and bill.fbizDate >= {").append(beginDate).append("}").append("\r\n");
        sSQL.append("and bill.fbizDate < {").append(endDate).append("}").append("\r\n");
        if (billTableName.equalsIgnoreCase("t_im_materialreqbill")) {
            sSQL.append(" and riType.fnumber = '006' ");
        }
        if (billTableName.equalsIgnoreCase("t_im_saleissuebill")) {
            sSQL.append(" and (riType.fnumber = '004' or riType.fnumber = '015') ");
        }
        sSQL.append(this.getBillStorageFilter(params)).append("\r\n");
        if (!billTableName.equalsIgnoreCase("T_IM_MoveLocationBill") && !billTableName.equalsIgnoreCase("T_IM_InventoryInitBill")) {
            if (isBack) {
                sSQL.append("and invUpd.FExistingQtyPre = 1").append("\r\n");
                sSQL.append("and riType.fbizdirection = -1").append("\r\n");
            } else {
                sSQL.append("and invUpd.FExistingQty = 1").append("\r\n");
                sSQL.append("and riType.fbizdirection = 1").append("\r\n");
            }
        }
        if ("T_IM_MoveInWarehsBill".equals(billTableName) && !isCannibalize) {
            sSQL.append("and bizCate.FId != '88a7587a-e01b-497b-9f86-b8f00ab2fe72A9389020'").append("\r\n");
        }
        sSQL.append(" and material.fid in (");
        sSQL.append(this.getMaterialFilterSql(ctx, params));
        sSQL.append(")");
        sSQL.append(this.getFilter(ctx, params, "bill")).append("\r\n");
        return sSQL.toString();
    }

    protected String getJoinTempTable(Context ctx, RptParams params, String tempZeroTable, boolean isMoveLocationBill) throws BOSException {
        StringBuffer br = new StringBuffer();
        br.append("inner join ").append(tempZeroTable).append(" t ");
        br.append("on t.FStorageOrgUnitID=bill.fstorageorgunitid and t.FMaterialID=billentry.fmaterialid ").append("\r\n");
        if (params.getBoolean("isShowWareHouse")) {
            br.append("and t.FWarehouseID=billentry.fwarehouseid ").append("\r\n");
        }
        if (params.getBoolean("isShowType")) {
            br.append("and t.FInventoryTypeID=storeType.Fid  ").append("\r\n");
        }
        if (params.getBoolean("isShowLocation")) {
            if (isMoveLocationBill) {
                br.append(" and IsNull(t.flocationid, 'XXXX') = IsNull(billentry.FReceiptLocationID, 'XXXX')");
            } else {
                br.append(" and IsNull(t.flocationid, 'XXXX') = IsNull(billentry.FLocationID, 'XXXX')");
            }
        }
        if (params.getBoolean("isShowLot")) {
            br.append("and IsNull(t.FLot, 'YNi0IQEOEADgBT3mfwAAAcznrtQ=') = IsNull(billentry.FLot, 'YNi0IQEOEADgBT3mfwAAAcznrtQ=') ").append("\r\n");
        }
        if (params.getBoolean("isShowAssitProperty")) {
            br.append("and IsNull(t.FAssistPropertyID, 'XXXX') = IsNull(billentry.FAssistPropertyID, 'XXXX') ").append("\r\n");
        }
        if (params.getBoolean("isShowProject")) {
            br.append("and IsNull(t.FProjectID, 'XXXX') = IsNull(billentry.FProjectID, 'XXXX') ").append("\r\n");
        }
        if (params.getBoolean("isShowTrackNum")) {
            br.append("and IsNull(t.FTracknumberID, 'XXXX') = IsNull(billentry.FTracknumberID, 'XXXX') ").append("\r\n");
        }
        return br.toString();
    }

    protected void buildStorageOrgTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table t_org_storageTree(");
        sql.append("fid varchar(44) not null  primary key ,");
        sql.append("fname_l2 varchar(100),");
        sql.append("fparentid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int,");
        sql.append("fbegindate datetime,");
        sql.append("fbeginyear int,");
        sql.append("fbeginperiod int ");
        sql.append(")");
        String orgTempTable = com.kingdee.eas.scm.cal.util.DBUtil.createTempTable((Context)ctx, (String)sql.toString());
        this.executeUpdate(sql.toString(), null, ctx);
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] storageOrg = (Object[])params.getObject("storageOrgInfo");
        String orgSql = "insert into " + orgTempTable + "(fid,fname_l2,fparentid,flevel,fisleaf,fbegindate,fbeginyear,fbeginperiod) values(?,?,?,?,?,to_date('1999-01-01'),?,?)";
        if (storageOrg != null) {
            int n = storageOrg.length;
            for (int i = 0; i < n; ++i) {
                Integer fisleaf;
                String fid = ((StorageOrgUnitInfo)storageOrg[i]).get("id").toString();
                Integer flevel = (Integer)((FullOrgUnitInfo)storageOrg[i]).get("level");
                String fname = (String)((FullOrgUnitInfo)storageOrg[i]).get("name");
                FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)storageOrg[i]).get("parent");
                Integer n2 = fisleaf = ((FullOrgUnitInfo)storageOrg[i]).isIsLeaf() ? new Integer("1") : new Integer("0");
                if (fisleaf == 1) {
                    v.add(fid);
                }
                if (flevel > maxLevel) {
                    maxLevel = flevel;
                }
                String fparentid = parent != null ? parent.getId().toString() : null;
                SqlParams parameters = new SqlParams();
                parameters.addString(fid);
                parameters.addString(fname);
                parameters.addString(fparentid);
                parameters.addInt(flevel.intValue());
                parameters.addInt(fisleaf.intValue());
                parameters.addInt(1999);
                parameters.addInt(1);
                this.executeUpdate(ctx, orgSql, parameters);
            }
        }
        params.setObject("leafStorageOrgUnit", (Object)v.toArray());
        params.setObject("maxLevelStr", (Object)new Integer(maxLevel));
    }

    private String getMaterialFilterSql(Context ctx, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select material.fid from t_bd_material material");
        if (params.getObject("materialGroupStandard") != null) {
            sql.append(" inner join T_BD_MaterialGroupDetial MGD on MGD.FMaterialID = material.fid").append("\r\n");
        }
        if (params.getObject("metClassFrom") != null || params.getObject("metClassTo") != null) {
            sql.append(" inner join t_bd_materialgroup materialGroup1 on materialGroup1.Fid = MGD.fmaterialgroupid").append("\r\n");
            sql.append(" inner join t_bd_materialgroup materialGroup on charindex(materialGroup.flongnumber,materialGroup1.flongnumber) = 1").append("\r\n");
        }
        sql.append(" where 1 = 1").append("\r\n");
        if (params.getObject("materialNumFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialNumFrom"));
            if (numArray[0] != null) {
                sql.append(" and material.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                sql.append(" and material.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getObject("materialNumTo") != null) {
            MaterialInfo materialTo = (MaterialInfo)params.getObject("materialNumTo");
            sql.append(" and material.FNumber  <='");
            sql.append(materialTo.getNumber() + "' \r\n ");
        }
        if (params.getObject("materialGroupStandard") != null) {
            String materialGroupStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
            sql.append(" and MGD.FMATERIALGROUPSTANDARDID = '").append(materialGroupStandardID).append("' \r\n");
        }
        if (params.getObject("metClassFrom") != null) {
            String materialGroupFrom = null;
            if (params.getObject("metClassFrom") instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupFromInfo = (MaterialGroupInfo)params.getObject("metClassFrom");
                materialGroupFrom = materialGroupFromInfo.getNumber();
            } else {
                materialGroupFrom = params.getObject("metClassFrom").toString();
            }
            sql.append(" and materialGroup.FNumber  >='");
            sql.append(materialGroupFrom + "' \r\n ");
        }
        if (params.getObject("metClassTo") != null) {
            String materialGroupTo = null;
            if (params.getObject("metClassTo") instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupToInfo = (MaterialGroupInfo)params.getObject("metClassTo");
                materialGroupTo = materialGroupToInfo.getNumber();
            } else {
                materialGroupTo = params.getObject("metClassTo").toString();
            }
            sql.append(" and materialGroup.FNumber  <='");
            sql.append(materialGroupTo + "' \r\n ");
        }
        return sql.toString();
    }
}

