/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.AbstractInventoryGeneralRptFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.app.InventoryGeneralRptPageHelper;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryGeneralRptFacadeControllerBean
extends AbstractInventoryGeneralRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.InventoryGeneralRptFacadeControllerBean");
    private String warepermSql = null;
    final String invReservationTempTable = "t_im_reservationInventory_temp";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String isForWeb = params.getString("isForWeb");
        if (isForWeb != null) {
            Map map = new InventoryGeneralRptPageHelper(ctx, params.toMap()).createTempTable();
            RptParams result = new RptParams();
            result.putAll(map);
            return result;
        }
        this.getPerm(ctx);
        String tempTable = params.getString("tempTable");
        this.dropTable(tempTable, ctx);
        String sql = "";
        MaterialInfo[] material = (MaterialInfo[])params.getObject("material");
        tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"133_InventoryGeneralRptFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        params.setString("tempTable", tempTable);
        sql = this.getCreateTempTable(ctx, tempTable);
        this.executeSQL(ctx, sql);
        if (material != null) {
            String tempTable_reservationInv = this.getTempTableName("t_im_reservationInventory_temp", ctx);
            String createSql = this.getCreateInvReservationTempTableSql(tempTable_reservationInv);
            this.executeSQL(ctx, createSql);
            String insertSql = this.getInsertInvReservationTempTableSql(tempTable_reservationInv, params);
            this.executeSQL(ctx, insertSql);
            sql = this.getInsertTempTable(ctx, tempTable, tempTable_reservationInv, params);
            this.executeSQL(ctx, sql);
            String updateData = "update " + tempTable + " set FUnReservationQty=isnull(FUsableQty, 0)-isnull(FReservationQty,0),FTotalUnReservationQty=isnull(FtotalQty,0)-isnull(FTotalReservationQty,0),FUnReservationAssistQty=isnull(FAssiUsableQty,0)-isnull(FReservationAssistQty,0),FTotalUnReservationAssistQty=isnull(FAssitotalQty,0)-isnull(FTotalReservationAssistQty,0)";
            this.executeSQL(ctx, updateData);
            this.updateLeaf(ctx, tempTable, params);
            sql = this.getGroup1(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            int queryType = params.getInt("queryType");
            if (queryType == 0) {
                this.levelGroupByStorageOrg(ctx, params);
            } else {
                sql = this.getGroup2(ctx, tempTable, params);
                this.executeSQL(ctx, sql);
                this.updateOrgName(ctx, tempTable, params);
            }
            StringBuffer groupSql = new StringBuffer();
            groupSql.append("select newbosid('88888888') as FId,FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,");
            groupSql.append("FOrgUnitID,FOrgUnitName,FStoreTypeID,FStoreTypeName,FCompanyOrgUnitID,FStorageOrgUnitID,");
            groupSql.append("FWarehouseID,FCompanyOrgUnitName,FStorageOrgUnitName,FParentID,Fisleaf,FLevel, ").append("\r\n");
            groupSql.append("sum(FUsableQty) as FUsableQty,sum(FLockBaseQty) as FLockBaseQty,sum(FWaitCheckQty) as FWaitCheckQty,");
            groupSql.append("sum(FFreezeQuery) as FFreezeQuery,sum(FtotalQty) as FtotalQty,sum(FAssiUsableQty) as FAssiUsableQty,");
            groupSql.append("sum(FAssiLockQty) as FAssiLockQty,sum(FUnReservationAssistQty) as FUnReservationAssistQty,");
            groupSql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,sum(FReservationAssistQty) as FReservationAssistQty,");
            groupSql.append("sum(FTotalReservationAssistQty) as FTotalReservationAssistQty,sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
            groupSql.append("sum(FAssiTotalQty) as FAssiTotalQty,sum(FReservationQty) as FReservationQty,sum(FUnReservationQty) as FUnReservationQty,");
            groupSql.append("sum(FTotalReservationQty) as FTotalReservationQty,sum(FTotalUnReservationQty) as FTotalUnReservationQty,");
            groupSql.append("sum(FTotalUnReservationAssistQty) as FTotalUnReservationAssistQty into temp from " + tempTable);
            groupSql.append(" group by FMaterialID,FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,");
            groupSql.append(" FOrgUnitID,FOrgUnitName,FStoreTypeID,FStoreTypeName,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,");
            groupSql.append("FCompanyOrgUnitName,FStorageOrgUnitName,FParentID,Fisleaf,FLevel ");
            Connection conn = this.getConnection(ctx);
            String finalTempTable = null;
            try {
                CreateTempTableResult temptableResult = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)groupSql.toString(), null, (Connection)conn);
                finalTempTable = temptableResult.getTempTable();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            this.dropTempTable(ctx, tempTable);
            tempTable = finalTempTable;
            updateData = "update " + tempTable + " set FUnReservationQty=isnull(FUsableQty, 0)-isnull(FReservationQty,0),FTotalUnReservationQty=isnull(FtotalQty,0)-isnull(FTotalReservationQty,0),FUnReservationAssistQty=isnull(FAssiUsableQty,0)-isnull(FReservationAssistQty,0),FTotalUnReservationAssistQty=isnull(FAssitotalQty,0)-isnull(FTotalReservationAssistQty,0)";
            this.executeSQL(ctx, updateData);
            this.updateZeroToNull(ctx, tempTable);
            this.dropTempTable(ctx, tempTable_reservationInv);
        }
        String countSql = "select count(1) cc from " + tempTable + " where flevel = 1";
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FOrgUnitID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialNum");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FHelpCode");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBaseUnitName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAssistUnitName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FOrgUnitName");
        col.setWidth(160);
        header.addColumn(col);
        col = new RptTableColumn("FStoreTypeName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FUsableQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FReservationQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FUnReservationQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FLockBaseQty");
        col.setWidth(-1);
        col.setHided(true);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FWaitCheckQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FFreezeQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FTotalQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FTotalReservationQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FTotalUnReservationQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FAssiUsableQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FReservationAssistQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FUnReservationAssistQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FAssiLockQty");
        col.setWidth(-1);
        col.setHided(true);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FAssiWaitCheckQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FAssiFreezeQuery");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FAssiTotalQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FTotalReservationAssistQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FTotalUnReservationAssistQty");
        col.setWidth(100);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyOrgUnitID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouseID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FStoreTypeID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FParentID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("Fisleaf");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FLevel");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)resFile, (String)"OrgID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"MaterialID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"materialNumber", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"materialName", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"materialModel", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"HelpCode", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"baseUnit", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"assistUnit2", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"org", (Context)ctx) + "/" + SCMUtils.getResource((String)resFile, (String)"warehouse", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"storetype", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"usable", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"ReservationQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"UnReservationQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"lock", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"waitcheck", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"freeze", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"totalQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"TotalReservationQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"TotalUnReservationQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"usable", (Context)ctx) + "(" + SCMUtils.getResource((String)resFile, (String)"assistUnit", (Context)ctx) + ")", SCMUtils.getResource((String)resFile, (String)"ReservationAssistQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"UnReservationAssistQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"lock", (Context)ctx) + "(" + SCMUtils.getResource((String)resFile, (String)"assistUnit", (Context)ctx) + ")", SCMUtils.getResource((String)resFile, (String)"waitcheck", (Context)ctx) + "(" + SCMUtils.getResource((String)resFile, (String)"assistUnit", (Context)ctx) + ")", SCMUtils.getResource((String)resFile, (String)"freeze", (Context)ctx) + "(" + SCMUtils.getResource((String)resFile, (String)"assistUnit", (Context)ctx) + ")", SCMUtils.getResource((String)resFile, (String)"totalQty", (Context)ctx) + "(" + SCMUtils.getResource((String)resFile, (String)"assistUnit", (Context)ctx) + ")", SCMUtils.getResource((String)resFile, (String)"TotalReservationAssistQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"TotalUnReservationAssistQty", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"companyOrgUnitID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"storageOrgUnitID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"warehouseID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"FStoreTypeID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"parentID", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"level", (Context)ctx), SCMUtils.getResource((String)resFile, (String)"isLeaf", (Context)ctx)}}, true);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("totalCount", count);
        return result;
    }

    private void getPerm(Context ctx) throws BOSException {
        Set cuUnitSets = InvServerUtils.getAuthorizedf7Orgs(ctx);
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)cuUnitSets, (String)"warehous_view", (String)"b", (String)"a");
        if (warepermRuleMap != null) {
            this.warepermSql = (String)warepermRuleMap.get("PERM_WHERE");
            if (!StringUtil.isEmpty((String)this.warepermSql)) {
                this.warepermSql = " AND (" + this.warepermSql + ") ";
            }
        }
    }

    private String getCreateTempTable(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + tempTable + " (");
        sql.append("FID varchar(44),");
        sql.append("FMaterialID varchar(44),");
        sql.append("FMaterialNum nvarchar(255),");
        sql.append("FMaterialName nvarchar(255),");
        sql.append("FModel nvarchar(255),");
        sql.append("FHelpCode nvarchar(255),");
        sql.append("FBaseUnitName nvarchar(255),");
        sql.append("FAssistUnitName nvarchar(255),");
        sql.append("FOrgUnitID varchar(44),");
        sql.append("FOrgUnitName nvarchar(255),");
        sql.append("FStoreTypeID varchar(44),");
        sql.append("FStoreTypeName nvarchar(255), ");
        sql.append("FUsableQty numeric(31,10) default 0 ,");
        sql.append("FLockBaseQty numeric(31,10) default 0 ,");
        sql.append("FWaitCheckQty numeric(31,10) default 0 ,");
        sql.append("FFreezeQuery numeric(31,10) default 0 ,");
        sql.append("FTotalQty numeric(31,10) default 0 ,");
        sql.append("FAssiUsableQty numeric(31,10) default 0 ,");
        sql.append("FAssiLockQty numeric(31,10) default 0 ,");
        sql.append("FAssiWaitCheckQty numeric(31,10) default 0 ,");
        sql.append("FAssiFreezeQuery numeric(31,10) default 0 ,");
        sql.append("FAssiTotalQty numeric(31,10) default 0 ,");
        sql.append("FCompanyOrgUnitID varchar(44),");
        sql.append("FStorageOrgUnitID varchar(44),");
        sql.append("FWarehouseID varchar(44),");
        sql.append("FCompanyOrgUnitName nvarchar(255),");
        sql.append("FStorageOrgUnitName nvarchar(255),");
        sql.append("FParentID varchar(44),");
        sql.append("Fisleaf int,");
        sql.append("FLevel int ");
        sql.append(",FReservationQty numeric(31,10) default 0 ");
        sql.append(",FUnReservationQty numeric(31,10) default 0 ");
        sql.append(",FTotalReservationQty numeric(31,10) default 0 ");
        sql.append(",FTotalUnReservationQty numeric(31,10) default 0 ");
        sql.append(",FReservationAssistQty numeric(31,10) default 0 ");
        sql.append(",FUnReservationAssistQty numeric(31,10) default 0 ");
        sql.append(",FTotalReservationAssistQty numeric(31,10) default 0 ");
        sql.append(",FTotalUnReservationAssistQty numeric(31,10) default 0 ");
        sql.append(")");
        return sql.toString();
    }

    private String getInsertTempTable(Context ctx, String tempTable, String inventoryTempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        MaterialInfo[] material = (MaterialInfo[])params.getObject("material");
        Object[] storage = (Object[])params.getObject("storageOrgSet");
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("insert into " + tempTable + " ");
        sql.append("select ");
        sql.append("newbosid('88888888'),");
        sql.append("a.FMaterialID as FMaterialID,m.fnumber as FMaterialNum, m.fname_").append(lang).append(" as FMaterialName, ");
        sql.append("m.FModel as FModel, m.FHelpCode as FHelpCode, ");
        sql.append("bu.fname_").append(lang).append(" as FBaseUnitName, au.fname_").append(lang).append(" as FAssistUnitName, ");
        sql.append("a.FWarehouseID as FOrgUnitID, b.fname_").append(lang).append(" as FOrgUnitname, a.FStoreTypeID as FStoreTypeID,d.fname_").append(lang).append(" as FStoreTypeName,");
        sql.append("sum(case c.FStoreStateType when 1 then a.FBaseQty else 0 end ) as FUsableQty,");
        sql.append("sum(a.FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(case c.FStoreStateType when 2 then a.FBaseQty else 0 end ) as FWaitCheckQty,");
        sql.append("sum(case c.FStoreStateType when  3 then a.FBaseQty else 0 end ) as FFreezeQuery,");
        sql.append("sum(case c.FStoreStateType when 1 then a.FBaseQty else 0 end ) + ");
        sql.append("sum(a.FLockBaseQty) +  ");
        sql.append("sum(case c.FStoreStateType when 2 then a.FBaseQty else 0 end ) + ");
        sql.append("sum(case c.FStoreStateType when  3 then a.FBaseQty else 0 end ) ");
        sql.append("as FTotalQty,");
        sql.append("sum(case c.FStoreStateType when  1 then a.FCurStoreAssistQty else 0 end ) as FAssiUsableQty,");
        sql.append("sum(a.FLockAssistQty) as FAssiLockQty,");
        sql.append("sum(case c.FStoreStateType when 2 then a.FCurStoreAssistQty else 0 end ) as FAssiWaitCheckQty,");
        sql.append("sum(case c.FStoreStateType when  3 then a.FCurStoreAssistQty else 0 end ) as FAssiFreezeQuery,");
        sql.append("sum(case c.FStoreStateType when  1 then a.FCurStoreAssistQty else 0 end ) + ");
        sql.append("sum(a.FLockAssistQty) + ");
        sql.append("sum(case c.FStoreStateType when 2 then a.FCurStoreAssistQty else 0 end ) + ");
        sql.append("sum(case c.FStoreStateType when  3 then a.FCurStoreAssistQty else 0 end ) ");
        sql.append("as FAssiTotalQty,");
        sql.append("a.FCompanyorgUnitID as FCompanyorgUnitID,");
        sql.append("a.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sql.append("a.FWarehouseID as FWarehouseID,");
        sql.append("f.FName_").append(lang).append(" as FCompanyOrgUnitName,");
        sql.append("e.FName_").append(lang).append(" as FStorageOrgUnitName,");
        sql.append("a.FStorageOrgUnitID as FParentID,");
        sql.append("1 as Fisleaf,");
        sql.append("3 as FLevel ");
        sql.append(",sum(case c.FStoreStateType when 1 then a.FReservationBaseQty else 0 end ) as FReservationQty,");
        sql.append(" 0 as FUnReservationQty,");
        sql.append("sum(a.FReservationBaseQty) as FTotalReservationQty,");
        sql.append(" 0 as FTotalUnReservationQty,");
        sql.append("sum(case c.FStoreStateType when 1 then a.FReservationAssistQty else 0 end ) as FReservationAssistQty,");
        sql.append(" 0 as FUnReservationAssistQty,");
        sql.append("sum(a.FReservationAssistQty) as FTotalReservationAssistQty,");
        sql.append(" 0 as FTotalUnReservationAssistQty ");
        sql.append("from " + inventoryTempTable + " as a ");
        sql.append("left join  t_db_warehouse b on a.fwarehouseid = b.fid ");
        sql.append("left join  t_im_storestate c on a.fstorestatusid = c.fid ");
        sql.append("inner join  t_im_storetype d on a.fstoretypeid = d.fid ");
        sql.append("inner join t_org_storage e on a.fstorageorgunitid = e.fid ");
        sql.append("inner join t_org_company f on a.fcompanyorgunitid = f.fid ");
        sql.append("inner join T_BD_Material m on a.fmaterialid = m.fid ");
        sql.append("inner join t_bd_measureunit bu on bu.fid = a.FBaseUnitID ");
        sql.append("left join t_bd_measureunit au on au.fid = a.FAssistUnitID ");
        sql.append(" where a.fmaterialid in (" + this.getMaterialIds(material) + ") ");
        String sqlOrg = "";
        int n = storage.length;
        for (int i = 0; i < n; ++i) {
            sqlOrg = sqlOrg + "or a.FStorageOrgUnitID = '" + ((FullOrgUnitInfo)storage[i]).getId().toString() + "' ";
        }
        sqlOrg = storage.length > 0 ? sqlOrg.substring(2, sqlOrg.length()) : "1 = 2 ";
        sql.append(" and ( a.fbaseqty <> 0 or a.flockbaseqty <>0)");
        sql.append(" and (" + sqlOrg + ") ");
        if (this.warepermSql != null) {
            sql.append(this.warepermSql);
        }
        sql.append("group by a.fmaterialid,m.fnumber,m.fname_").append(lang).append(",m.FModel, m.FHelpCode,bu.fname_").append(lang).append(",au.fname_").append(lang).append(",");
        sql.append("a.FCompanyorgunitID,a.FStorageorgunitID,a.FWarehouseID,a.FStoretypeID,b.fname_").append(lang).append(",d.fname_").append(lang).append(",e.fname_").append(lang).append(",");
        sql.append("e.fname_").append(lang).append(",f.fname_").append(lang).append("");
        return sql.toString();
    }

    private StringBuffer getMaterialIds(MaterialInfo[] material) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < material.length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append("'").append(material[i].getId().toString()).append("'");
        }
        return ids;
    }

    private void updateLeaf(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempTable + " set ");
        sql.append("FOrgUnitID = FStorageOrgUnitID,");
        sql.append("FOrgUnitname = FStorageOrgUnitName,");
        sql.append("FParentID = FCompanyorgunitID,");
        sql.append("Fisleaf = 0,");
        sql.append("FLevel = 2");
        sql.append("where ");
        sql.append("FStoreTypeID = '181875d5-0105-1000-e000-011ac0a812fd97D461A6' and FWarehouseID is null");
    }

    private String getGroup1(Context ctx, String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTable + " ");
        sql.append("select ");
        sql.append("newbosid('88888888'),");
        sql.append("FMaterialID, FMaterialNum, FMaterialName, ");
        sql.append("FModel, FHelpCode, ");
        sql.append("FBaseUnitName, FAssistUnitName, ");
        sql.append("FStorageOrgUnitID as FOrgUnitID,");
        sql.append("FStorageOrgUnitName as FOrgUnitName,");
        sql.append("FStoreTypeID as FStoreTypeID,");
        sql.append("FStoreTypeName as FStoreTypeName,");
        sql.append("sum(FUsableQty) as FUsableQty,");
        sql.append("sum(FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) as FtotalQty,");
        sql.append("sum(FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("FCompanyorgUnitID as FCompanyorgUnitID,");
        sql.append("FStorageOrgUnitID as FStorageOrgUnitID,");
        sql.append("null as FWarehouseID,");
        sql.append("FCompanyOrgUnitName as FCompanyOrgUnitName,");
        sql.append("FStorageOrgUnitName as FStorageOrgUnitName,");
        sql.append("FCompanyOrgUnitID as FParentID,");
        sql.append("0 as Fisleaf,");
        sql.append("2 as FLevel ");
        sql.append(",sum(FReservationQty) as FReservationQty");
        sql.append(",sum(FUsableQty) - sum(FReservationQty) as FUnReservationQty");
        sql.append(",sum(FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) - sum(FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) - sum(FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) - sum(FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(" from " + tempTable + " ");
        sql.append(" where flevel = 3 ");
        sql.append(" group by ");
        sql.append(" FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,");
        sql.append(" FStoreTypeName,FStoreTypeID,FCompanyOrgUnitID,FStorageOrgUnitID,FCompanyOrgUnitName,FStorageOrgUnitName ");
        return sql.toString();
    }

    private String getGroup2(Context ctx, String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTable + " ");
        sql.append("select ");
        sql.append("newbosid('88888888'),");
        sql.append("FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,");
        sql.append("FCompanyOrgUnitID as FOrgUnitID,");
        sql.append("FCompanyOrgUnitName as FOrgUnitName,");
        sql.append("FStoreTypeID as FStoreTypeID,");
        sql.append("FStoreTypeName as FStoreTypeName,");
        sql.append("sum(FUsableQty) as FUsableQty,");
        sql.append("sum(FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(FUsableQty) +  sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) as FtotalQty,");
        sql.append("sum(FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("FCompanyorgUnitID as FCompanyorgUnitID,");
        sql.append("null as FStorageOrgUnitID,");
        sql.append("null as FWarehouseID,");
        sql.append("FCompanyOrgUnitName as FCompanyOrgUnitName,");
        sql.append("null as FStorageOrgUnitName,");
        sql.append("null as FParentID,");
        sql.append("0 as Fisleaf,");
        sql.append("1 as FLevel ");
        sql.append(",sum(FReservationQty) as FReservationQty");
        sql.append(",sum(FUsableQty) - sum(FReservationQty) as FUnReservationQty");
        sql.append(",sum(FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) - sum(FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) - sum(FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) - sum(FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(" from " + tempTable + " ");
        sql.append("where flevel = 2 ");
        sql.append("group by ");
        sql.append("FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,");
        sql.append("FStoreTypeName,FStoreTypeID,FCompanyOrgUnitID,FCompanyOrgUnitName ");
        return sql.toString();
    }

    private void updateOrgName(Context ctx, String tempTable, RptParams params) throws BOSException {
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        String companyOrgUnit = SCMUtils.getResource((String)resFile, (String)"companyOrgUnit", (Context)ctx);
        String storageOrgUnit = SCMUtils.getResource((String)resFile, (String)"storageOrgUnit", (Context)ctx);
        String sql = "update " + tempTable + " set FOrgUnitName = FOrgUnitName || '(" + companyOrgUnit + ")' where flevel = 1 ";
        this.executeSQL(ctx, sql);
        sql = "update " + tempTable + " set FOrgUnitName = FOrgUnitName || '(" + storageOrgUnit + ")' where flevel = 2 ";
        this.executeSQL(ctx, sql);
    }

    private void updateZeroToNull(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String[] fields = new String[]{"FUsableQty", "FLockBaseQty", "FWaitCheckQty", "FFreezeQty", "FTotalQty", "FAssiUsableQty", "FAssiLockQty", "FAssiWaitCheckQty", "FAssiFreezeQuery", "FAssiTotalQty"};
        sql.append("update " + tempTable + " set (FUsableQty,FLockBaseQty,FWaitCheckQty,FFreezeQty,");
        sql.append("FAssiUsableQty,FAssiLockQty,FAssiWaitCheckQty,FAssiFreezeQuery,FReservationQty,FUnReservationQty,FTotalReservationQty,FTotalUnReservationQty,FReservationAssistQty,FUnReservationAssistQty,FTotalReservationAssistQty,FTotalUnReservationAssistQty) =  ");
        sql.append("");
    }

    private void levelGroupByStorageOrg(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String orgTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"134_InventoryGeneralRptFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + orgTempTable + " (");
        sql.append("fid varchar(44),");
        sql.append("fname varchar(100),");
        sql.append("fparentid varchar(44),");
        sql.append("frootid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        Object[] storageOrg = (Object[])params.getObject("storageOrgSet");
        sql = new StringBuffer();
        int maxLevel = 0;
        Vector<String> v = new Vector<String>();
        FullOrgUnitInfo orgUnitInfo = null;
        String fLongNumber = null;
        String frootid = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int n = storageOrg.length;
        for (int i = 0; i < n; ++i) {
            orgUnitInfo = (FullOrgUnitInfo)storageOrg[i];
            fLongNumber = (String)orgUnitInfo.get("longNumber");
            map.put(fLongNumber, orgUnitInfo.get("id").toString());
        }
        String pSql = "insert into " + orgTempTable + "(fid,fname,fparentid,frootid,flevel,fisleaf) values(?,?,?,?,?,?)";
        int n2 = storageOrg.length;
        for (int i = 0; i < n2; ++i) {
            Integer fisleaf;
            orgUnitInfo = (FullOrgUnitInfo)storageOrg[i];
            frootid = null;
            fLongNumber = (String)orgUnitInfo.get("longNumber");
            StringBuffer parentLongNumber = new StringBuffer();
            String[] lnSecs = fLongNumber.split("!");
            int m = lnSecs.length - 1;
            for (int j = 0; j < m; ++j) {
                if (j != 0) {
                    parentLongNumber.append("!");
                }
                parentLongNumber.append(lnSecs[j]);
                if (!map.containsKey(parentLongNumber.toString())) continue;
                frootid = (String)map.get(parentLongNumber.toString());
                break;
            }
            if (frootid == null) {
                frootid = (String)map.get(fLongNumber);
            }
            String fid = orgUnitInfo.get("id").toString();
            Integer flevel = (Integer)orgUnitInfo.get("level");
            String fname = (String)orgUnitInfo.get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)orgUnitInfo.get("parent");
            Integer n3 = fisleaf = ((FullOrgUnitInfo)storageOrg[i]).isIsLeaf() ? new Integer("1") : new Integer("0");
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            SqlParams sqlParams = new SqlParams();
            sqlParams.addString(fid);
            if (fname != null) {
                sqlParams.addString(fname);
            } else {
                sqlParams.addString(null);
            }
            if (parent != null) {
                sqlParams.addString(parent.getId().toString());
            } else {
                sqlParams.addString(null);
            }
            sqlParams.addString(frootid);
            sqlParams.addInt(flevel.intValue());
            sqlParams.addInt(fisleaf.intValue());
            this.executeUpdate(pSql, sqlParams, ctx);
        }
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FStorageOrgUnitName,FLevel) = (");
        sql.append("select b.fname,b.flevel + 1 from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FParentID and " + tempTable + ".FWarehouseID is not null ");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FStorageOrgUnitName,FLevel) = (");
        sql.append("select b.fname,b.flevel from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FOrgUnitID ");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        String sqle = "";
        sql = new StringBuffer();
        sql.append("insert into " + tempTable);
        sql.append(" select ");
        sql.append("newbosid('88888888'),");
        sql.append("FMaterialID, FMaterialNum, FMaterialName, ");
        sql.append("FModel, FHelpCode, ");
        sql.append("FBaseUnitName, FAssistUnitName, ");
        sql.append("b.FParentID as FOrgUnitID,");
        sql.append("null as FOrgUnitName,");
        sql.append("a.FStoreTypeID as FStoreTypeID,");
        sql.append("a.FStoreTypeName as FStoreTypeName,");
        sql.append("sum(a.FUsableQty) as FUsableQty,");
        sql.append("sum(a.FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(a.FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(a.FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(a.FUsableQty) +  sum(FLockBaseQty) + sum(a.FWaitCheckQty) + sum(a.FFreezeQuery) as FtotalQty,");
        sql.append("sum(a.FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(a.FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(a.FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(a.FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(a.FAssiUsableQty) + sum(a.FAssiLockQty) + sum(a.FAssiWaitCheckQty) + sum(a.FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("null as FCompanyorgUnitID,");
        sql.append("b.FParentID as FStorageOrgUnitID,");
        sql.append("null as FWarehouseID,");
        sql.append("null as FCompanyOrgUnitName,");
        sql.append("null as FStorageOrgUnitName,");
        sql.append("null as FParentID,");
        sql.append("0 as Fisleaf,");
        sql.append("b.Flevel - 1 as FLevel ");
        sql.append(",sum(a.FReservationQty) as FReservationQty");
        sql.append(",sum(a.FUsableQty) - sum(a.FReservationQty) as FUnReservationQty");
        sql.append(",sum(a.FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(a.FUsableQty) + sum(a.FLockBaseQty) + sum(a.FWaitCheckQty) + sum(a.FFreezeQuery) - sum(a.FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(a.FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(a.FAssiUsableQty) - sum(a.FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(a.FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(a.FAssiUsableQty) + sum(a.FAssiLockQty) + sum(a.FAssiWaitCheckQty) + sum(a.FAssiFreezeQuery) - sum(a.FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(" from  " + tempTable + " a,");
        sql.append(orgTempTable + " b ");
        sql.append(" where a.FOrgUnitID is not null and a.fstorageorgunitid = b.fid and a.fwarehouseid is null and b.flevel = ");
        for (int i = maxLevel; i > 1; --i) {
            sqle = sql.toString() + i + " group by FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,a.FStoreTypeID,a.FStoreTypeName,b.fparentid,b.flevel";
            this.executeSQL(ctx, sqle);
        }
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FOrgUnitName,FStorageOrgUnitName,FParentID) = (");
        sql.append("select b.fname,b.fname,b.fparentid from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FOrgUnitID ");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FCompanyOrgUnitID,FCompanyOrgUnitName) = (");
        sql.append("select b.frootid,'' from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FStorageOrgUnitID ");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        this.dropTable(orgTempTable, ctx);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String isForWeb = params.getString("isForWeb");
        RptRowSet rs = null;
        rs = isForWeb != null ? this.executeQuery("select * from " + params.getString("tempTable") + " where FLevel = 1 order by " + params.getString("groupFieldStr") + "forgunitidpk_hide", null, from, len, ctx) : this.executeQuery(this.getQuerySql(ctx, params) + "where FLevel = 1 order by FMaterialNum, forgunitid,fstoretypeid", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        String flevel = params.getString("flevel");
        int nextlevel = Integer.parseInt(flevel) + 1;
        int levelcount = 0;
        String sql = "";
        String isForWeb = params.getString("isForWeb");
        if (isForWeb != null) {
            Map fieldsParam = (Map)params.getObject("fieldsParam");
            Map fieldTypeMap = (Map)params.getObject("fieldTypeMap");
            Set keySet = fieldsParam.keySet();
            Iterator it = keySet.iterator();
            String whereSql = "";
            String orderSql = "";
            while (it.hasNext()) {
                String value;
                String key = (String)it.next();
                orderSql = orderSql + "," + key;
                if (fieldsParam.get(key) instanceof Integer) {
                    whereSql = whereSql + " and " + key + " = " + fieldsParam.get(key);
                    continue;
                }
                if (fieldsParam.get(key) instanceof Double) {
                    value = new BigDecimal((Double)fieldsParam.get(key)).toString();
                    whereSql = whereSql + " and " + key + " = '" + value + "'";
                    continue;
                }
                value = (String)fieldsParam.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    whereSql = whereSql + " and " + key + " is null ";
                    continue;
                }
                if (DataTypeEnum.Date.getValue().equals(fieldTypeMap.get(key))) {
                    whereSql = whereSql + " and " + key + " = to_date('" + value + "')";
                    continue;
                }
                whereSql = whereSql + " and " + key + " = '" + value + "'";
            }
            sql = "select * from " + params.getString("tempTable") + " where flevel = " + nextlevel + " and fparentid = '" + params.getString("fparentid") + "' " + whereSql + "order by forgunitid " + orderSql;
        } else {
            sql = this.getQuerySql(ctx, params) + " where flevel = " + nextlevel + " and fparentid = '" + params.getString("fparentid") + "' and FMaterialNum = '" + params.getString("FMaterialNum") + "' and FStoreTypeID ='" + params.getString("fstoretypeid") + "' order by forgunitid,fstoretypeid ";
        }
        RptRowSet rs = start <= -1 && count <= -1 ? this.executeQuery(sql, null, ctx) : this.executeQuery(sql, null, start, count, ctx);
        RptParams pp = new RptParams();
        pp.setInt("LevelCount", levelcount);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getQuerySql(Context ctx, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgUnitID,FMaterialID, FMaterialNum, FMaterialName, FModel, FHelpCode, FBaseUnitName, FAssistUnitName,FOrgUnitName,");
        sql.append("FStoreTypeName,FUsableQty,FReservationQty,FUnReservationQty,FLockBaseQty,FWaitCheckQty,FFreezeQuery,");
        sql.append("FTotalQty,FTotalReservationQty,FTotalUnReservationQty,FAssiUsableQty");
        sql.append(",FReservationAssistQty,FUnReservationAssistQty,FAssiLockQty,FAssiWaitCheckQty,FAssiFreezeQuery,FAssiTotalQty,FTotalReservationAssistQty,FTotalUnReservationAssistQty,FCompanyorgUnitID,");
        sql.append("FStorageOrgUnitID,FWarehouseID,FStoreTypeID,FParentID,FLevel,Fisleaf");
        sql.append(" from ");
        sql.append(params.getString("tempTable") + " ");
        return sql.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String getCreateInvReservationTempTableSql(String tempTable) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Create Table ").append(tempTable);
        sb.append("( ");
        sb.append("FID VARCHAR(44) DEFAULT '' NOT NULL");
        sb.append(",FCompanyOrgUnitID VARCHAR(44)");
        sb.append(",FStorageOrgUnitID VARCHAR(44)");
        sb.append(",FWarehouseID VARCHAR(44)");
        sb.append(",FLocationID VARCHAR(44)");
        sb.append(",FStoreTypeID VARCHAR(44)");
        sb.append(",FStoreStatusID VARCHAR(44)");
        sb.append(",FLot NVARCHAR(80)");
        sb.append(",FSupplierID VARCHAR(44)");
        sb.append(",FCustomerID VARCHAR(44)");
        sb.append(",FMaterialID VARCHAR(44)");
        sb.append(",FUnitID VARCHAR(44)");
        sb.append(",FCurStoreQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FAssistUnitID VARCHAR(44)");
        sb.append(",FCurStoreAssistQty NUMERIC(28,16)");
        sb.append(",FBaseQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FAmount NUMERIC(19,4) DEFAULT 0");
        sb.append(",FControlUnitID VARCHAR(44)");
        sb.append(",FBaseUnitID VARCHAR(44)");
        sb.append(",FExp DateTime");
        sb.append(",FAssistPropertyID VARCHAR(44)");
        sb.append(",FLockQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLockBaseQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLockAssistQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLastUpdateTime DateTime NOT NULL ");
        sb.append(",FCreatorID VARCHAR(44)");
        sb.append(",FCreateTime DateTime");
        sb.append(",FLastUpdateUserID VARCHAR(44)");
        sb.append(",FProjectID VARCHAR(44) DEFAULT ''");
        sb.append(",FTrackNumberID VARCHAR(44) DEFAULT ''");
        sb.append(",FReservationBaseQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FReservationAssistQty NUMERIC(28,16) DEFAULT 0");
        sb.append(")");
        return sb.toString();
    }

    private String getInsertInvReservationTempTableSql(String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder(512);
        sql.append("insert into ").append(tempTable);
        sql.append(" select ");
        sql.append(" a.FID");
        sql.append(",FCompanyOrgUnitID");
        sql.append(",FStorageOrgUnitID");
        sql.append(",FWarehouseID");
        sql.append(",FLocationID");
        sql.append(",FStoreTypeID");
        sql.append(",FStoreStatusID");
        sql.append(",FLot");
        sql.append(",FSupplierID");
        sql.append(",FCustomerID");
        sql.append(",FMaterialID");
        sql.append(",FUnitID");
        sql.append(",FCurStoreQty");
        sql.append(",FAssistUnitID");
        sql.append(",FCurStoreAssistQty");
        sql.append(",FBaseQty");
        sql.append(",FAmount");
        sql.append(",a.FControlUnitID");
        sql.append(",FBaseUnitID");
        sql.append(",FExp");
        sql.append(",FAssistPropertyID");
        sql.append(",FLockQty");
        sql.append(",FLockBaseQty");
        sql.append(",FLockAssistQty");
        sql.append(",a.FLastUpdateTime");
        sql.append(",a.FCreatorID");
        sql.append(",a.FCreateTime");
        sql.append(",a.FLastUpdateUserID");
        sql.append(",FProjectID");
        sql.append(",FTrackNumberID");
        sql.append(",FReservationBaseQty");
        sql.append(",FReservationAssistQty");
        sql.append(" from t_im_inventory as a left outer join ");
        sql.append(" (");
        sql.append(" select finventoryid, sum(FReservationBaseQty) as FReservationBaseQty,isnull(sum(FReservationAssistQty), 0) as FReservationAssistQty");
        sql.append(" from t_im_reservation where finventoryid is not null and FReservationBaseQty>0");
        sql.append(" group by finventoryid");
        sql.append(" ) as reservation on a.fid=reservation.finventoryid");
        sql.append(" left outer join t_db_warehouse as b on a.FWarehouseID = b.fid");
        MaterialInfo[] material = (MaterialInfo[])params.getObject("material");
        Object[] storage = (Object[])params.getObject("storageOrgSet");
        sql.append(" where a.fmaterialid in (" + this.getMaterialIds(material) + ") ");
        String sqlOrg = "";
        int n = storage.length;
        for (int i = 0; i < n; ++i) {
            sqlOrg = sqlOrg + "or a.FStorageOrgUnitID = '" + ((FullOrgUnitInfo)storage[i]).getId().toString() + "' ";
        }
        sqlOrg = storage.length > 0 ? sqlOrg.substring(2, sqlOrg.length()) : "1 = 2 ";
        sql.append(" and ( a.fbaseqty <> 0 or a.flockbaseqty <>0)");
        sql.append(" and (" + sqlOrg + ") ");
        if (this.warepermSql != null) {
            sql.append(this.warepermSql);
        }
        return sql.toString();
    }
}

