/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.calculate.InvBillPriceCalculate;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.service.SCMPermissionService;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.RptPriceEnum;
import com.kingdee.eas.scm.im.rpt.app.AbstractMaterialStayRptFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialStayRptFacadeControllerBean
extends AbstractMaterialStayRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.MaterialStayRptFacadeControllerBean");
    String FName = "FName_L2";
    private Context ctx;
    private Calendar cal = Calendar.getInstance();
    private Object[] fullStorageOrgs;
    private String[] warehs;
    private String materialFrom;
    private String mNumbersFrom;
    private String materialTo;
    private String materialGroupStandardId;
    private String materialTypeFrom;
    private String materialTypeTo;
    private String assistFrom;
    private String assistTo;
    private String projectFrom;
    private String projectTo;
    private String trackNumberFrom;
    private String trackNumberTo;
    private String lotFrom;
    private String lotTo;
    private int stayDays;
    private int stayNoInOut;
    private int stayReason = this.stayNoInOut = 0;
    private boolean inCluStansferBill = false;
    private boolean inCluWarehs = false;
    private boolean inCluLocation = false;
    private boolean inCluLot = false;
    private boolean inCluAssist = false;
    private boolean inCluUnit = false;
    private boolean inCluTrackNumber = false;
    private boolean inCluProject = false;
    private int PriceSelect;
    private final String IMRPTMATERIALSTAYRESOURCE_PATH = "com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource";
    private String matpermSql = null;
    private String rptmatpermSql = null;
    private String matpermJoinSql = null;
    private String warepermSql = null;
    private String rptwarepermSql = null;
    private String warepermJoinSql = null;
    private boolean inCluFreeze = false;
    private boolean inCluStoreStatus = false;
    private int stayNoOutAndHasIn = 1;
    private int stayNotOut = 2;
    private boolean showLastBillDate = false;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        try {
            this.ctx = ctx;
            long lstart = 0L;
            long begin = 0L;
            long lstop = 0L;
            begin = System.currentTimeMillis();
            logger.error((Object)"=====================start MaterialStayRptServer=========================");
            this.FName = "FName_" + this.getContext().getLocale().getDisplayName();
            ctx = this.getContext();
            this.isGetAllOrg(ctx, params);
            this.initRptParams(params);
            this.getPerm(ctx);
            logger.info((Object)"########### createTempTable1 ##############  ");
            lstart = System.currentTimeMillis();
            String tempTableMaterialsFromBills = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA ( FMaterialId VARCHAR(44) DEFAULT(''),  FAssistPropertyID varchar(44),  FLot nvarchar(80),  FStorageOrgUnitID varchar(44),  FWarehouseID varchar(44),  FLocationID varchar(44),  FProjectID varchar(44),  FTrackNumberID varchar(44),  FUnitID varchar(44),  FStoreStatusID varchar(44)  ) \n");
            lstop = System.currentTimeMillis();
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempTableMaterialsFromBills, "FMaterialID,FStorageOrgUnitID,FWarehouseID,FLocationID,FAssistPropertyID", false, false);
            logger.error((Object)("########### createTempTable1 end : " + (lstop - lstart)));
            logger.error((Object)"########### insertTempTable1 ##############  ");
            lstart = System.currentTimeMillis();
            this.insertDataToTempTableMaterialsFromBills(tempTableMaterialsFromBills);
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### insertTempTable1 end : " + (lstop - lstart)));
            logger.error((Object)"########### createTempTable2 ##############  ");
            lstart = System.currentTimeMillis();
            String tempStayMaterialTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTableSql());
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### insertTempTable2 end : " + (lstop - lstart)));
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempStayMaterialTable, "FID,FMaterialID,FStorageOrgUnitID,FCompanyOrgUnitId", false, false);
            logger.error((Object)"########### insertTempTable2 ##############  ");
            lstart = System.currentTimeMillis();
            this.insertDataToTempStayMaterialTable(tempStayMaterialTable, tempTableMaterialsFromBills);
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### insertTempTable2 end : " + (lstop - lstart)));
            if (this.stayReason == this.stayNoOutAndHasIn) {
                logger.error((Object)"########### insertDataToTempStayMaterialTableWhileNotOutAndIn ##############  ");
                lstart = System.currentTimeMillis();
                this.insertDataToTempStayMaterialTableWhileNotOutAndIn(tempTableMaterialsFromBills);
                lstop = System.currentTimeMillis();
                logger.error((Object)("########### insertDataToTempStayMaterialTableWhileNotOutAndIn end : " + (lstop - lstart)));
            }
            logger.error((Object)"########### deleteDateForBiz ##############  ");
            lstart = System.currentTimeMillis();
            this.deleteMaterialForStayMaterialTable(tempStayMaterialTable, tempTableMaterialsFromBills);
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### deleteDateForBiz END :  " + (lstop - lstart)));
            lstart = System.currentTimeMillis();
            logger.error((Object)"########### updatePrice ##############  ");
            lstart = System.currentTimeMillis();
            this.updatePriceByAccountType(tempStayMaterialTable);
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### updatePrice End : " + (lstop - lstart)));
            this.updatePriceAndAmount(tempStayMaterialTable);
            if (this.showLastBillDate) {
                logger.error((Object)"########### showLastBillDate ##############  ");
                lstart = System.currentTimeMillis();
                this.insertLastDate(tempStayMaterialTable);
                lstop = System.currentTimeMillis();
                logger.error((Object)("########### showLastBillDate End : " + (lstop - lstart)));
            }
            StringBuffer countSql = new StringBuffer();
            countSql.append("select count(1) cc from ").append(tempStayMaterialTable).append("");
            RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            RptParams result = new RptParams();
            result.setString("tempStayMaterialTable", tempStayMaterialTable);
            result.setInt("verticalCount", count);
            lstop = System.currentTimeMillis();
            logger.error((Object)("########### total time: " + (lstop - begin)));
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempStayMaterialTable);
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableMaterialsFromBills);
            logger.error((Object)"=====================end MaterialStayRptServer=========================");
            return result;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void isGetAllOrg(Context ctx, RptParams params) throws EASBizException, BOSException {
        if (null != params.getObject("allOrg") && ((Boolean)params.getObject("allOrg")).booleanValue()) {
            SCMPermissionService permSrv = new SCMPermissionService(ctx);
            OrgUnitInfo[] orgs = permSrv.getAuthorizedBizOrgUnit(ctx.getCaller(), OrgType.Storage, "MaterialStayReport_view");
            params.setObject("fullStorageOrgs", (Object)orgs);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.isGetAllOrg(ctx, params);
        String tempStayMaterialTable = params.getString("tempStayMaterialTable");
        params.remove("queryType");
        RptRowSet rs = this.executeQuery(this.getResultSql(tempStayMaterialTable, params), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.isGetAllOrg(ctx, params);
        String tempStayMaterialTable = params.getString("tempStayMaterialTable");
        params.remove("queryType");
        RptRowSet rs = this.executeQuery(this.getSumAmoutSql(tempStayMaterialTable), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private Context getContext() {
        return this.ctx;
    }

    private void getPerm(Context ctx) throws BOSException {
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"MaterialStayReport_view");
        Set validUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, this.fullStorageOrgs);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)validUnitSets, (String)"bd_material_view", (String)"MATERIAL", (String)"Bill");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)validUnitSets, (String)"warehous_view", (String)"WAREHOUSE", (String)"Bill");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            this.matpermSql = " and" + (String)matpermRuleMap.get("PERM_WHERE");
            this.matpermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            this.warepermSql = " and" + (String)warepermRuleMap.get("PERM_WHERE");
            this.warepermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
        }
        Map matpermRuleMapS = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)validUnitSets, (String)"bd_material_view", (String)"MATERIAL", (String)"ENTRY");
        Map warepermRuleMapS = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)validUnitSets, (String)"warehous_view", (String)"WAREHOUSE", (String)"ENTRY");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMapS)) {
            this.rptmatpermSql = " and" + (String)matpermRuleMapS.get("PERM_WHERE");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMapS)) {
            this.rptwarepermSql = " and" + (String)warepermRuleMapS.get("PERM_WHERE");
        }
    }

    private void updatePriceAndAmount(String tempStayMaterialTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempStayMaterialTable + " set FAmount = decimal((FActualBaseUnitCost * FBaseQty), 19, 4)");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        if (this.inCluUnit) {
            sql.append("update " + tempStayMaterialTable + " set FPrice = decimal((FAmount/Fqty), 19, 6)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    private Set<String> getNoAmtAuthorizedOrgs() throws BOSException, EASBizException {
        FullOrgUnitCollection coll = PermissionFactory.getLocalInstance((Context)this.ctx).getAuthorizedOrg(this.ctx.getCaller(), OrgType.Storage, null, "MaterialStayReport_view_amount");
        Iterator iterator = coll.iterator();
        HashSet<String> authorizedStorageIdSet = new HashSet<String>();
        while (iterator.hasNext()) {
            FullOrgUnitInfo org = (FullOrgUnitInfo)iterator.next();
            authorizedStorageIdSet.add(org.getId().toString());
        }
        HashSet<String> noAuthStorageOrgIds = new HashSet<String>();
        for (Object fullStorageOrg : this.fullStorageOrgs) {
            String orgId = ((FullOrgUnitInfo)fullStorageOrg).getId().toString();
            if (authorizedStorageIdSet.contains(orgId)) continue;
            noAuthStorageOrgIds.add(orgId);
        }
        return noAuthStorageOrgIds;
    }

    private void updatePriceByAccountType(String tempTableName) throws Exception {
        PeriodInfo period;
        CompanyOrgUnitInfo companyOrgUnitInfo;
        String companyId;
        HashMap<String, Object> hm;
        long lstart = 0L;
        long lstop = 0L;
        InvBillPriceCalculate iiwc = new InvBillPriceCalculate();
        String getCompanyId = "select distinct FCompanyOrgUnitId from " + tempTableName;
        IRowSet compaySet = DbUtil.executeQuery((Context)this.ctx, (String)getCompanyId);
        Set<String> noAuthStorageOrgIds = this.getNoAmtAuthorizedOrgs();
        if (this.PriceSelect == 0) {
            while (compaySet.next()) {
                hm = new HashMap<String, Object>();
                companyId = compaySet.getString("FCompanyOrgUnitId");
                if (companyId == null || noAuthStorageOrgIds.contains(companyId)) continue;
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                hm.put("tempTableName", tempTableName);
                hm.put("period", period);
                hm.put("companyOrgUnitId", companyId);
                hm.put("matperm", this.rptmatpermSql);
                hm.put("wareperm", this.rptwarepermSql);
                hm.put("matpermJoinsql", this.matpermJoinSql);
                hm.put("warepermJoinSql", this.warepermJoinSql);
                hm.put("isShowWareHouse", this.inCluWarehs);
                logger.info((Object)"########### \u6309\u671f\u521d\u4f59\u989d\u52a0\u6743\u5e73\u5747\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                lstart = System.currentTimeMillis();
                ImRptAppUtils.updateBeginWeightedAveragePrice(this.ctx, hm);
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### \u6309\u671f\u521d\u4f59\u989d\u52a0\u6743\u5e73\u5747\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
            }
        }
        if (this.PriceSelect == 5) {
            while (compaySet.next()) {
                hm = new HashMap();
                companyId = compaySet.getString("FCompanyOrgUnitId");
                if (StringUtils.isEmpty((String)companyId) || noAuthStorageOrgIds.contains(companyId)) continue;
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                period = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)period);
                hm.put("tempTableName", tempTableName);
                hm.put("period", period);
                hm.put("companyOrgUnitId", companyId);
                hm.put("isPayOut", "true");
                hm.put("matperm", this.rptmatpermSql);
                hm.put("wareperm", this.rptwarepermSql);
                hm.put("matpermJoinsql", this.matpermJoinSql);
                hm.put("warepermJoinSql", this.warepermJoinSql);
                logger.info((Object)"########### \u4e0a\u671f\u6700\u65b0\u51fa\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                lstart = System.currentTimeMillis();
                ImRptAppUtils.updateNewInpourOrPayOutPrice(this.ctx, hm);
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### \u4e0a\u671f\u6700\u65b0\u51fa\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
            }
        }
        if (this.PriceSelect == 3) {
            while (compaySet.next()) {
                hm = new HashMap();
                companyId = compaySet.getString("FCompanyOrgUnitId");
                if (StringUtils.isEmpty((String)companyId) || noAuthStorageOrgIds.contains(companyId)) continue;
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                hm.put("tempTableName", tempTableName);
                hm.put("period", period);
                hm.put("companyOrgUnitId", companyId);
                hm.put("isPayOut", "false");
                hm.put("matperm", this.rptmatpermSql);
                hm.put("wareperm", this.rptwarepermSql);
                hm.put("matpermJoinsql", this.matpermJoinSql);
                hm.put("warepermJoinSql", this.warepermJoinSql);
                logger.info((Object)"########### \u6700\u65b0\u5165\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                lstart = System.currentTimeMillis();
                ImRptAppUtils.updateNewInpourOrPayOutPrice(this.ctx, hm);
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### \u6700\u65b0\u5165\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
            }
        }
        if (this.PriceSelect == 4) {
            while (compaySet.next()) {
                hm = new HashMap();
                companyId = compaySet.getString("FCompanyOrgUnitId");
                if (StringUtils.isEmpty((String)companyId) || noAuthStorageOrgIds.contains(companyId)) continue;
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                hm.put("tempTableName", tempTableName);
                hm.put("period", period);
                hm.put("companyOrgUnitId", companyId);
                hm.put("isPayOut", "true");
                hm.put("matperm", this.rptmatpermSql);
                hm.put("wareperm", this.rptwarepermSql);
                hm.put("matpermJoinsql", this.matpermJoinSql);
                hm.put("warepermJoinSql", this.warepermJoinSql);
                logger.info((Object)"########### \u6700\u65b0\u51fa\u5e93\u4ef7  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                lstart = System.currentTimeMillis();
                ImRptAppUtils.updateNewInpourOrPayOutPrice(this.ctx, hm);
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### \u6700\u65b0\u51fa\u5e93\u4ef7  \u7ed3\u675f\uff1a " + (lstop - lstart)));
            }
        }
        if (this.PriceSelect == 1) {
            while (compaySet.next()) {
                String companyId2 = compaySet.getString("FCompanyOrgUnitId");
                if (StringUtils.isEmpty((String)companyId2) || noAuthStorageOrgIds.contains(companyId2)) continue;
                CompanyOrgUnitInfo companyOrgUnitInfo2 = new CompanyOrgUnitInfo();
                companyOrgUnitInfo2.setId(BOSUuid.read((String)companyId2));
                PeriodInfo period2 = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo2);
                CalculateParams calparams = new CalculateParams();
                calparams.setString("COMPANY_ID", companyId2);
                logger.info((Object)"########### \u6807\u51c6\u6210\u672c  \u66f4\u65b0\u5355\u4ef7\u5f00\u59cb ##############  ");
                lstart = System.currentTimeMillis();
                DbUtil.execute((Context)this.ctx, (String)iiwc.updateUnitStandardPrice(period2, tempTableName));
                lstop = System.currentTimeMillis();
                logger.info((Object)("########### \u6807\u51c6\u6210\u672c  \u7ed3\u675f\uff1a " + (lstop - lstart)));
            }
        }
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        String materialNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"MaterialNum", (Locale)this.ctx.getLocale());
        String materialName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"MaterialName", (Locale)this.ctx.getLocale());
        String materialModel = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"MaterialModel", (Locale)this.ctx.getLocale());
        String storageNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"StorageNum", (Locale)this.ctx.getLocale());
        String storageName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"StorageName", (Locale)this.ctx.getLocale());
        String baseUnitName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"BaseUnitName", (Locale)this.ctx.getLocale());
        String baseQty = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"BaseQty", (Locale)this.ctx.getLocale());
        String actualBaseUnitCost = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"ActualBaseUnitCost", (Locale)this.ctx.getLocale());
        String amount = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"Amount", (Locale)this.ctx.getLocale());
        reportHeader.addChild("FMaterialNum", materialNum);
        reportHeader.addChild("FMaterialName", materialName);
        reportHeader.addChild("FMaterialModel", materialModel);
        if (this.inCluAssist) {
            String assistPropertyName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"AssistPropertyName", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FAssistPropertyName", assistPropertyName);
        }
        reportHeader.addChild("FStorageNum", storageNum);
        reportHeader.addChild("FStorageName", storageName);
        if (this.inCluStoreStatus) {
            reportHeader.addChild("FStoreStatusName", ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"storeStatus", (Locale)this.ctx.getLocale()));
        }
        if (this.inCluLot) {
            String lot = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"Lot", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FLot", lot);
        }
        if (this.inCluWarehs) {
            String warehouseNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"WarehouseNum", (Locale)this.ctx.getLocale());
            String warehouseName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"WarehouseName", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FWarehouseNum", warehouseNum);
            reportHeader.addChild("FWarehouseName", warehouseName);
        }
        if (this.inCluLocation) {
            String locationNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"LocationNum", (Locale)this.ctx.getLocale());
            String locationName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"LocationName", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FLocationNum", locationNum);
            reportHeader.addChild("FLocationName", locationName);
        }
        if (this.inCluProject) {
            String prjectNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"projectNumber", (Locale)this.ctx.getLocale());
            String prjectName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"projectName", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FProjectNum", prjectNum);
            reportHeader.addChild("FProjectName", prjectName);
        }
        if (this.inCluTrackNumber) {
            String trackNumberNum = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"trackNumberNum", (Locale)this.ctx.getLocale());
            String trackNumberName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"trackNumberName", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FTrackNumberNum", trackNumberNum);
            reportHeader.addChild("FTrackNumberName", trackNumberName);
        }
        int qtyPrecision = filter.getObject("spinQtyPrecission") == null ? 6 : filter.getInt("spinQtyPrecission");
        int amtPrecision = filter.getObject("spinAmountPrecission") == null ? 4 : filter.getInt("spinAmountPrecission");
        int pricePrecision = filter.getObject("spinPricePrecission") == null ? 4 : filter.getInt("spinPricePrecission");
        reportHeader.addChild("FBaseUnitName", baseUnitName);
        ReportHeader sumChild = reportHeader.addChild("FBaseQty", baseQty);
        sumChild.setType(2);
        sumChild.setAlign(3);
        sumChild.setDecimal(qtyPrecision);
        sumChild = reportHeader.addChild("FActualBaseUnitCost", actualBaseUnitCost);
        sumChild.setType(2);
        sumChild.setAlign(3);
        sumChild.setDecimal(pricePrecision);
        if (this.inCluUnit) {
            String unitName = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"UnitName", (Locale)this.ctx.getLocale());
            String qty = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"Qty", (Locale)this.ctx.getLocale());
            reportHeader.addChild("FUnitName", unitName);
            sumChild = reportHeader.addChild("FQty", qty);
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(qtyPrecision);
            String price = ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"Price", (Locale)this.ctx.getLocale());
            sumChild = reportHeader.addChild("FPrice", price);
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(pricePrecision);
        }
        sumChild = reportHeader.addChild("FAmount", amount);
        sumChild.setType(2);
        sumChild.setAlign(3);
        sumChild.setDecimal(amtPrecision);
        if (this.showLastBillDate) {
            reportHeader.addChild("FLastInDate", ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"lastInwarehsDate", (Locale)this.ctx.getLocale()));
            reportHeader.addChild("FLastOutDate", ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"lastIssueDate", (Locale)this.ctx.getLocale()));
        }
        return reportHeader;
    }

    private void deleteMaterialForStayMaterialTable(String tempStayMaterialTable, String tempTableMaterialsFromBills) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + tempStayMaterialTable + " where exists (").append(" select 1 from " + tempTableMaterialsFromBills + " t2 where ").append(" t2.fmaterialid=" + tempStayMaterialTable + ".fmaterialid and t2.FStorageOrgUnitID=" + tempStayMaterialTable + ".FStorageOrgUnitID ");
        if (this.inCluWarehs) {
            sql.append(" and isnull(t2.FWarehouseID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FWarehouseID,'XXXXX') ");
        } else if (this.warehs != null && this.warehs.length > 0) {
            sql.append(" and " + tempStayMaterialTable + ".FWarehouseID is null");
        }
        if (this.inCluAssist) {
            sql.append(" and isnull(t2.FAssistPropertyID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FAssistPropertyID,'XXXXX') ");
        } else if (this.assistFrom != null || this.assistTo != null) {
            sql.append(" and " + tempStayMaterialTable + ".FAssistPropertyID is null");
        }
        if (this.inCluLot) {
            sql.append(" and isnull(t2.Flot,'XXXXX')=isnull(" + tempStayMaterialTable + ".Flot,'XXXXX') ");
        } else if (this.lotFrom != null || this.lotTo != null) {
            sql.append(" and " + tempStayMaterialTable + ".Flot is null ");
        }
        if (this.inCluLocation) {
            sql.append(" and isnull(t2.FLocationID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FLocationID,'XXXXX') ");
        }
        if (this.inCluProject) {
            sql.append(" and isnull(t2.FProjectID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FProjectID,'XXXXX') ");
        } else if (this.projectFrom != null || this.projectTo != null) {
            sql.append(" and " + tempStayMaterialTable + ".FProjectID is null ");
        }
        if (this.inCluTrackNumber) {
            sql.append(" and isnull(t2.FTrackNumberID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FTrackNumberID,'XXXXX') ");
        } else if (this.trackNumberFrom != null || this.trackNumberTo != null) {
            sql.append(" and " + tempStayMaterialTable + ".FTrackNumberID is null ");
        }
        if (this.inCluStoreStatus) {
            sql.append(" and isnull(t2.Fstorestatusid,'XXXXX')=isnull(" + tempStayMaterialTable + ".Fstorestatusid,'XXXXX') ");
        }
        if (this.inCluUnit) {
            sql.append(" and isnull(t2.FUnitID,'XXXXX')=isnull(" + tempStayMaterialTable + ".FUnitID,'XXXXX') ");
        }
        sql.append(")");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from " + tempStayMaterialTable + " where fbaseqty<=0 or fbaseqty is null ");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
    }

    private Object getSelectSqlForStayMaterialTable(String tempStayMaterialTable, String tempTableMaterialsFromBills, String materialGroupTmpTbl) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select  ");
        sql.append("NEWBOSID('88888888'),  ");
        sql.append("Material.FID,  ");
        sql.append("Material.FNumber,  ");
        sql.append("Material." + this.FName + ",");
        sql.append("Material.FModel,  ");
        sql.append("inv.FCompanyOrgUnitID,");
        sql.append("inv.FStorageOrgUnitID,");
        sql.append("Storage.FNumber,");
        sql.append("Storage." + this.FName + ",");
        sql.append("sum(inv.FCurStoreQty),  ");
        sql.append("BaseMeasureUnit.FID,  ");
        sql.append("BaseMeasureUnit." + this.FName + ", ");
        sql.append("sum(inv.FBaseQty),  ");
        sql.append("0,  ");
        sql.append("0  ");
        sql.append(this.getGroupStringByParams4Lot());
        sql.append(" from t_im_inventory inv ").append(" inner join T_Org_Storage storage on storage.fid=inv.FStorageOrgUnitID ").append(" inner join T_BD_Material material on material.fid=inv.FMaterialID ").append(" left join T_DB_WAREHOUSE warehouse on warehouse.fid=inv.FWarehouseID ").append(" left join T_BD_AsstAttrValue AsstAttrValue on AsstAttrValue.fid=inv.FAssistPropertyID ").append(" left join  T_DB_Location Location on inv.FLocationID = Location.FID ").append(" left join  T_MM_PROJECT project on inv.FProjectID = project.FID ").append(" left join  T_MM_TRACKNUMBER trackNumber on inv.FTrackNumberID = trackNumber.FID ").append(" inner join T_BD_MeasureUnit MeasureUnit on inv.FUnitID = MeasureUnit.FID ").append(" inner join T_BD_MeasureUnit BaseMeasureUnit  on inv.FBaseUnitID = BaseMeasureUnit.FID").append(" inner join t_im_storestate StoreStatus on inv.FSTORESTATUSID=StoreStatus.FID");
        if (this.materialTypeFrom != null || this.materialTypeTo != null || this.materialGroupStandardId != null) {
            sql.append(" inner join " + materialGroupTmpTbl + " tmpMG on  tmpMG.FMaterial = material.fid  ");
        }
        if (this.stayReason == this.stayNoOutAndHasIn) {
            StringBuffer joinOn = new StringBuffer("on temp.fmaterialid=inv.fmaterialid ");
            joinOn.append(" and temp.FStorageOrgUnitID=inv.FStorageOrgUnitID ");
            StringBuffer childField = new StringBuffer("fmaterialid ,FSTORAGEORGUNITID ");
            if (this.inCluWarehs) {
                childField.append(",FWarehouseID");
                joinOn.append(" and inv.FWarehouseID = isnull(temp.FWarehouseID,'EgkAAABc3XG76fiu') ");
            }
            if (this.inCluAssist) {
                childField.append(" ,FAssistPropertyID");
                joinOn.append(" and inv.FAssistPropertyID = isnull(temp.FAssistPropertyID ,'EgkAAAA5EWALxvQu') ");
            }
            if (this.inCluLot) {
                childField.append(" ,Flot");
                joinOn.append(" and inv.Flot = isnull(temp.Flot,'YNi0IQEOEADgBT3mfwAAAcznrtQ=') ");
            }
            if (this.inCluLocation) {
                childField.append(" ,FLocationID");
                joinOn.append(" and inv.FLocationID = isnull(temp.FLocationID,'EgkAAABc3XMgX/hq') ");
            }
            if (this.inCluProject) {
                childField.append(" ,FProjectID");
                joinOn.append(" and inv.FProjectID = isnull(temp.FProjectID,'EgkAAABc3Xza3gXu') ");
            }
            if (this.inCluTrackNumber) {
                childField.append(" ,FTrackNumberID");
                joinOn.append(" and inv.FTrackNumberID = isnull(temp.FTrackNumberID,'EgkAAABc3X0Ibpg9') ");
            }
            if (this.inCluStoreStatus) {
                childField.append(" ,Fstorestatusid");
                joinOn.append(" and isnull(inv.Fstorestatusid,'XXXXX')=isnull(temp.Fstorestatusid,'XXXXX') ");
            }
            if (this.inCluUnit) {
                childField.append(" ,FUnitID");
                joinOn.append(" and inv.FUnitID = temp.FUnitID ");
            }
            sql.append(" inner join  ( select " + childField + " from " + tempTableMaterialsFromBills + " group by " + childField + " ) temp ");
            sql.append(joinOn);
        }
        if (this.matpermJoinSql != null) {
            sql.append(this.matpermJoinSql);
        }
        if (this.warepermJoinSql != null) {
            sql.append(this.warepermJoinSql);
        }
        sql.append(this.getSqlWhere("inv"));
        sql.append(" and inv.FStoreTypeID='181875d5-0105-1000-e000-0111c0a812fd97D461A6' ");
        sql.append(" and (inv.FBaseQty>0 or inv.FCurStoreQty>0) ");
        if (!this.inCluFreeze) {
            sql.append(" and StoreStatus.fstorestatetype<>3 ");
        }
        sql.append(this.getSqlGroup());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into " + tempStayMaterialTable + " ").append(" (Fid,FMaterialID, FMaterialNum, FMaterialName, FMaterialModel, ").append("FCompanyOrgUnitID,FStorageOrgUnitID,FStorageNum, FStorageName,FQty, FBaseUnitID,").append("FBaseUnitName, FBaseQty, Fbaseprice, FAmount  ").append(this.getSelectStringByParams() + "\r\n").append(")");
        insertSql.append(sql.toString());
        return insertSql.toString();
    }

    private Object getSelectSqlForTableMaterialsFromBills(String[] table, String tempTable, String materialGroupTmpTbl) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String tableName = table[0];
        String entryName = table[1];
        sql.append(" select distinct entry.fmaterialid,entry.FAssistPropertyID,entry.flot,entry.FStorageOrgUnitID,entry.FWarehouseID,entry.Flocationid");
        sql.append(" ,entry.FUnitID");
        if (tableName.equalsIgnoreCase("T_IM_PURINWAREHSBILL") || tableName.equalsIgnoreCase("T_IM_MANUFACTURERECBILL") || tableName.equalsIgnoreCase("T_IM_OTHERINWAREHSBILL") || tableName.equalsIgnoreCase("T_IM_OTHERINWAREHSBILL") || tableName.equalsIgnoreCase("T_IM_InventoryInitBill") || tableName.equalsIgnoreCase("T_IM_MOVEINWAREHSBILL")) {
            if (tableName.equalsIgnoreCase("T_IM_InventoryInitBill")) {
                sql.append(",entry.fstorestatusid as FStoreStatusID");
            } else {
                sql.append(",updateType.FSTORESTATEID as FStoreStatusID");
            }
        } else if (tableName.equalsIgnoreCase("T_IM_OTHERISSUEBILL")) {
            sql.append(",entry.fstorestatusid as FStoreStatusID");
        } else {
            sql.append(",updateType.FSTORESTATEPREID as FStoreStatusID");
        }
        sql.append(" from " + tableName + " bill").append(" inner join " + entryName + " entry").append(" on bill.fid=entry.fparentid ");
        sql.append(this.getSqlJoinTable("entry", tableName, materialGroupTmpTbl));
        sql.append(this.getSqlWhere(null));
        if (this.stayDays > 0) {
            sql.append(this.getSqlDate());
        } else {
            sql.append(" and 1=2");
        }
        if (tableName.equalsIgnoreCase("T_IM_InventoryInitBill")) {
            sql.append(" and entry.fstoretypeid='181875d5-0105-1000-e000-0111c0a812fd97D461A6' ");
        } else {
            sql.append(" and (updateType.fstoretypeid='181875d5-0105-1000-e000-0111c0a812fd97D461A6' or updateType.fstoretypepreid='181875d5-0105-1000-e000-0111c0a812fd97D461A6')");
        }
        sql.append(" and bill.fbasestatus=4");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO " + tempTable + " \r\n").append("( FMaterialID,FAssistPropertyID,FLot,FStorageOrgUnitID,FWarehouseID,flocationid,FStoreStatusID,FUnitID) \r\n").append("select distinct fmaterialid,FAssistPropertyID,flot,FStorageOrgUnitID,FWarehouseID,Flocationid,FStoreStatusID,FUnitID from (").append(sql.toString()).append(") AS T");
        return insertSql.toString();
    }

    private Object getSqlGroup() {
        StringBuffer sql = new StringBuffer();
        sql.append("group by Material.FID, Material.FNumber, Material." + this.FName + ", ");
        sql.append("Material.FModel, inv.FCompanyOrgUnitID, inv.FStorageOrgUnitID, Storage.Fnumber,Storage." + this.FName + ",");
        sql.append("BaseMeasureUnit.FID, BaseMeasureUnit." + this.FName);
        sql.append(this.getGroupStringByParams());
        return sql.toString();
    }

    private String getGroupStringByParams() {
        StringBuffer str = new StringBuffer();
        if (this.inCluWarehs) {
            str.append(", Warehouse.FID, Warehouse.FNumber, Warehouse." + this.FName);
        }
        if (this.inCluLocation) {
            str.append(", Location.FID, Location.FNumber, Location." + this.FName);
        }
        if (this.inCluProject) {
            str.append(", project.FID, project.FNumber, project." + this.FName);
        }
        if (this.inCluTrackNumber) {
            str.append(", trackNumber.FID, trackNumber.FNumber, trackNumber." + this.FName);
        }
        if (this.inCluAssist) {
            str.append(", AsstAttrValue.FID, SUBSTRING(AsstAttrValue." + this.FName + ", 1, 255)");
        }
        if (this.inCluLot) {
            str.append(", Inv.FLot ");
        }
        if (this.inCluUnit) {
            str.append(", MeasureUnit.FID , MeasureUnit." + this.FName);
        }
        if (this.inCluStoreStatus) {
            str.append(", StoreStatus.FID , StoreStatus." + this.FName);
        }
        return str.toString();
    }

    private String getGroupStringByParams4Lot() {
        StringBuffer str = new StringBuffer();
        if (this.inCluWarehs) {
            str.append(", Warehouse.FID, Warehouse.FNumber, Warehouse." + this.FName);
        }
        if (this.inCluLocation) {
            str.append(", Location.FID, Location.FNumber, Location." + this.FName);
        }
        if (this.inCluProject) {
            str.append(", project.FID, project.FNumber, project." + this.FName);
        }
        if (this.inCluTrackNumber) {
            str.append(", trackNumber.FID, trackNumber.FNumber, trackNumber." + this.FName);
        }
        if (this.inCluAssist) {
            str.append(", AsstAttrValue.FID, SUBSTRING(AsstAttrValue." + this.FName + ", 1, 255)");
        }
        if (this.inCluLot) {
            str.append(", case when Inv.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else Inv.FLot end");
        }
        if (this.inCluUnit) {
            str.append(", MeasureUnit.FID , MeasureUnit." + this.FName);
        }
        if (this.inCluStoreStatus) {
            str.append(", StoreStatus.FID , StoreStatus." + this.FName);
        }
        return str.toString();
    }

    private String getSelectStringByParams() {
        StringBuffer str = new StringBuffer();
        if (this.inCluWarehs) {
            str.append(", FWarehouseID, FWarehouseNum, FWarehouseName ");
        }
        if (this.inCluLocation) {
            str.append(", FLocationID, FLocationNum, FLocationName ");
        }
        if (this.inCluProject) {
            str.append(", FProjectID, FProjectNum, FProjectName ");
        }
        if (this.inCluTrackNumber) {
            str.append(", FTrackNumberID, FTrackNumberNum, FTrackNumberName ");
        }
        if (this.inCluAssist) {
            str.append(", FAssistPropertyID, FAssistPropertyName ");
        }
        if (this.inCluLot) {
            str.append(", FLot");
        }
        if (this.inCluUnit) {
            str.append(", FUnitID, FUnitName");
        }
        if (this.inCluStoreStatus) {
            str.append(", FStoreStatusId,FStoreStatusName ");
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDataToTempTableMaterialsFromBills(String tempTableMaterialsFromBills) throws Exception {
        ArrayList<String[]> tableList = new ArrayList<String[]>();
        if (this.stayReason == this.stayNoInOut) {
            tableList.add(new String[]{"t_im_purinwarehsbill", "T_IM_PurInWarehsEntry"});
            tableList.add(new String[]{"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillentry"});
            tableList.add(new String[]{"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"});
            tableList.add(new String[]{"T_IM_InventoryInitBill", "T_IM_InventoryInitEntry"});
            tableList.add(new String[]{"T_IM_saleissuebill", "T_IM_saleissueentry"});
            tableList.add(new String[]{"T_IM_materialreqbill", "T_IM_materialreqbillentry"});
            tableList.add(new String[]{"t_im_otherissuebill", "t_im_otherissuebillentry"});
            if (this.inCluStansferBill) {
                tableList.add(new String[]{"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"});
                tableList.add(new String[]{"T_IM_Moveissuebill", "T_IM_Moveissuebillentry"});
            }
        } else if (this.stayReason == this.stayNotOut) {
            tableList.add(new String[]{"T_IM_saleissuebill", "T_IM_saleissueentry"});
            tableList.add(new String[]{"T_IM_materialreqbill", "T_IM_materialreqbillentry"});
            tableList.add(new String[]{"t_im_otherissuebill", "t_im_otherissuebillentry"});
            if (this.inCluStansferBill) {
                tableList.add(new String[]{"T_IM_Moveissuebill", "T_IM_Moveissuebillentry"});
            }
        } else if (this.stayReason == this.stayNoOutAndHasIn) {
            tableList.add(new String[]{"t_im_purinwarehsbill", "T_IM_PurInWarehsEntry"});
            tableList.add(new String[]{"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillentry"});
            tableList.add(new String[]{"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"});
            tableList.add(new String[]{"T_IM_InventoryInitBill", "T_IM_InventoryInitEntry"});
            if (this.inCluStansferBill) {
                tableList.add(new String[]{"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"});
            }
        }
        long l1 = System.currentTimeMillis();
        String materialGroupTmpTbl = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA ( FMaterial VARCHAR(44) DEFAULT('')) \n");
        this.insertMgTempTbl(materialGroupTmpTbl);
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(this.ctx, null);
        try {
            for (int i = 0; i < tableList.size(); ++i) {
                String sql = this.getSelectSqlForTableMaterialsFromBills((String[])tableList.get(i), tempTableMaterialsFromBills, materialGroupTmpTbl).toString();
                QueryDataTask thread = new QueryDataTask(lock, ((String[])tableList.get(i))[0], sysTempTableHelper.getConn(), sql.toString());
                lock.addLock(((String[])tableList.get(i))[0]);
                threadPool.addTask((Runnable)thread);
            }
            lock.waitFinish();
        }
        finally {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(materialGroupTmpTbl);
            sysTempTableHelper.releaseConnection();
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l1);
    }

    private void insertLastDate(String tempStayMaterialTable) throws BOSException {
        ArrayList<String[]> outBillList = new ArrayList<String[]>();
        ArrayList<String[]> inBillList = new ArrayList<String[]>();
        inBillList.add(new String[]{"T_IM_PURINWAREHSBILL", "T_IM_PURINWAREHSENTRY"});
        inBillList.add(new String[]{"T_IM_MANUFACTURERECBILL", "T_IM_MANUFACTURERECBILLENTRY"});
        inBillList.add(new String[]{"T_IM_OTHERINWAREHSBILL", "T_IM_OTHERINWAREHSBILLENTRY"});
        outBillList.add(new String[]{"T_IM_SALEISSUEBILL", "T_IM_SALEISSUEENTRY"});
        outBillList.add(new String[]{"T_IM_MATERIALREQBILL", "T_IM_MATERIALREQBILLENTRY"});
        outBillList.add(new String[]{"T_IM_OTHERISSUEBILL", "T_IM_OTHERISSUEBILLENTRY"});
        if (this.inCluStansferBill) {
            inBillList.add(new String[]{"T_IM_MOVEINWAREHSBILL", "T_IM_MOVEINWAREHSBILLENTRY"});
            outBillList.add(new String[]{"T_IM_MOVEISSUEBILL", "T_IM_MOVEISSUEBILLENTRY"});
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update " + tempStayMaterialTable + " set FLastInDate=(").append(" select to_Char(MAX(T.flastbilldate),'YYYY-MM-DD') from (" + this.getLastDateSqlFromBill(inBillList, tempStayMaterialTable, false) + ") T ").append(" where T.FTempId=" + tempStayMaterialTable + ".fid group by T.FTempId)");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        updateSql.setLength(0);
        updateSql.append(" update " + tempStayMaterialTable + " set FLastOutDate=(").append(" select to_Char(MAX(T.flastbilldate),'YYYY-MM-DD') from (" + this.getLastDateSqlFromBill(outBillList, tempStayMaterialTable, true) + ") T ").append(" where T.FTempId=" + tempStayMaterialTable + ".fid group by T.FTempId)");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
    }

    private void insertTotalRow(String tempStayMaterialTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into " + tempStayMaterialTable).append(" (FMaterialNum,FBaseQty,FActualBaseUnitCost,FAmount,FQty,Fprice,FIsTotal) ").append(" select '").append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"total", (Locale)this.ctx.getLocale())).append("' FMaterialNum,sum(FBaseQty) FBaseQty,null FActualBaseUnitCost,").append(" sum(FAmount) FAmount,sum(FQty) FQty,null Fprice,1 ").append(" from " + tempStayMaterialTable);
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getSqlJoinTable(String fromBillName, String tempTable, String materialGroupTmpTbl) {
        StringBuffer sql = new StringBuffer();
        sql.append(" inner join T_Org_Storage storage on storage.fid=bill.FStorageOrgUnitID ").append(" inner join T_BD_Material material on material.fid=" + fromBillName + ".FMaterialID ").append(" left join t_db_location location on location.fid=" + fromBillName + ".FLocationID ").append(" left join T_MM_PROJECT project on project.fid=" + fromBillName + ".FProjectID ").append(" left join T_MM_TRACKNUMBER trackNumber on trackNumber.fid=" + fromBillName + ".FTrackNumberID ");
        if (!tempTable.equals("T_IM_InventoryInitBill")) {
            sql.append(" inner join T_IM_InvUpdateType updateType on updateType.fid = entry.FInvUpdateTypeId ");
        }
        sql.append(" inner join T_DB_WAREHOUSE warehouse on warehouse.fid=" + fromBillName + ".FWarehouseID ");
        if (this.materialTypeFrom != null || this.materialTypeTo != null || this.materialGroupStandardId != null) {
            sql.append(" inner join " + materialGroupTmpTbl + " tmpMG on  tmpMG.FMaterial = material.fid  ");
        }
        if (this.assistFrom != null || this.assistTo != null) {
            sql.append(" left join T_BD_AsstAttrValue AsstAttrValue on AsstAttrValue.fid=" + fromBillName + ".FAssistPropertyID ");
        }
        if (this.matpermJoinSql != null) {
            sql.append(this.matpermJoinSql);
        }
        if (this.warepermJoinSql != null) {
            sql.append(this.warepermJoinSql);
        }
        return sql.toString();
    }

    private String getResultSql(String tempStayMaterialTable, RptParams params) {
        Object pricePresion = params.getObject("spinPricePrecission");
        int price = 4;
        int amt = 4;
        int qty = 6;
        if (pricePresion != null) {
            price = params.getInt("spinPricePrecission");
            amt = params.getInt("spinAmountPrecission");
            qty = params.getInt("spinQtyPrecission");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FMaterialNum,FMaterialName,").append(" FMaterialModel,trim(FAssistPropertyName) as FAssistPropertyName,").append(" FStorageNum,FStorageName,FLot,").append(" FWarehouseNum,FWarehouseName,FLocationNum,FLocationName,FProjectNum,FProjectName, ").append(" FTrackNumberNum,FTrackNumberName,FStoreStatusName,").append(" FBaseUnitName,decimal(FBaseQty,21,").append(qty).append(") as FBaseQty,").append(" isnull(decimal(FActualBaseUnitCost,21,").append(price).append("),0) as FActualBaseUnitCost,").append(" FUnitName,").append(" isnull(decimal(Fqty,21,").append(qty).append("),0) as Fqty,").append(" isnull(decimal(Fprice,21,").append(price).append("),0) as Fprice,").append(" isnull(decimal(FAmount,19,").append(amt).append("),0) as FAmount, ").append(" FLastInDate as FLastInDate,FLastOutDate as FLastOutDate ").append(" from " + tempStayMaterialTable).append(" order by FIsTotal,FStorageNum,");
        sql.append(" FMaterialNum,");
        if (this.inCluAssist) {
            sql.append(" FAssistPropertyName,");
        }
        if (this.inCluStoreStatus) {
            sql.append(" FStoreStatusName,");
        }
        if (this.inCluLot) {
            sql.append(" FLot,");
        }
        if (this.inCluWarehs) {
            sql.append(" FWarehouseNum,");
        }
        if (this.inCluLocation) {
            sql.append(" FLocationNum,");
        }
        if (this.inCluProject) {
            sql.append(" FProjectNum,");
        }
        if (this.inCluTrackNumber) {
            sql.append(" FTrackNumberNum,");
        }
        sql.append(" FBaseUnitName");
        return sql.toString();
    }

    private String getSqlWhere(String alias) throws BOSException, SQLException {
        String sqlwhere;
        StringBuffer sql = new StringBuffer();
        sql.append(" where 1=1 ");
        if (this.fullStorageOrgs != null && this.fullStorageOrgs.length > 0) {
            sql.append(this.getSqlStorageOrgUnits());
        } else {
            sql.append(" and storage.fid = '").append("111111111111111111111111111=").append("'");
        }
        if (this.warehs != null && this.warehs.length > 0) {
            sql.append(this.getSqlWarehs());
        }
        if (this.materialFrom != null) {
            sql.append(" and material.FNumber>='" + this.materialFrom.trim() + "'");
        } else if (this.mNumbersFrom != null) {
            sql.append(" and material.FNumber in (" + this.mNumbersFrom + ")");
        }
        if (this.materialTo != null && !"null".equalsIgnoreCase(this.materialTo)) {
            sql.append(" and material.FNumber<='" + this.materialTo.trim() + "'");
        }
        if (this.assistFrom != null && !"null".equalsIgnoreCase(this.assistFrom)) {
            sql.append(" and AsstAttrValue.fnumber>='" + this.assistFrom + "'");
        }
        if (this.assistTo != null && !"null".equalsIgnoreCase(this.assistTo)) {
            sql.append(" and AsstAttrValue.fnumber<='" + this.assistTo + "'");
        }
        if (this.projectFrom != null && !"null".equalsIgnoreCase(this.projectFrom)) {
            sql.append(" and project.fnumber>='" + this.projectFrom + "'");
        }
        if (this.projectTo != null && !"null".equalsIgnoreCase(this.projectTo)) {
            sql.append(" and project.fnumber<='" + this.projectTo + "'");
        }
        if (this.trackNumberFrom != null && !"null".equalsIgnoreCase(this.trackNumberFrom)) {
            sql.append(" and trackNumber.fnumber>='" + this.trackNumberFrom + "'");
        }
        if (this.trackNumberTo != null && !"null".equalsIgnoreCase(this.trackNumberTo)) {
            sql.append(" and trackNumber.fnumber<='" + this.trackNumberTo + "'");
        }
        if (this.matpermSql != null && this.matpermSql.length() > 0) {
            if (alias != null) {
                sqlwhere = this.matpermSql.replaceAll("Bill.", alias + ".");
                sql.append(sqlwhere);
            } else {
                sql.append(this.matpermSql);
            }
        } else {
            sql.append("");
        }
        if (this.warepermSql != null && this.warepermSql.length() > 0) {
            if (alias != null) {
                sqlwhere = this.warepermSql.replaceAll("Bill.", alias + ".");
                sql.append(sqlwhere);
            } else {
                sql.append(this.warepermSql);
            }
        }
        if (this.lotFrom != null && !"null".equalsIgnoreCase(this.lotFrom)) {
            sql.append(" and entry.flot>='" + this.lotFrom + "'");
        }
        if (this.lotTo != null && !"null".equalsIgnoreCase(this.lotTo)) {
            sql.append(" and entry.flot<='" + this.lotTo + "' ");
        }
        return sql.toString();
    }

    private void insertMgTempTbl(String tempTblName) throws BOSException {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("insert into " + tempTblName + " (FMaterial) ");
        sql2.append("(select distinct mgd.FMATERIALID FMaterial from t_bd_materialGroup mt  inner join t_bd_materialGroup mt1 on charindex(mt.flongnumber,mt1.flongnumber) = 1  inner join T_BD_MaterialGroupDetial as mgd  on mt1.fid = mgd.FMaterialGroupID where mgd.FMaterialGroupStandardID='");
        sql2.append(this.materialGroupStandardId).append("'");
        if (this.materialTypeFrom != null) {
            sql2.append(" and mt.fnumber >= '").append(this.materialTypeFrom.trim()).append("' ");
        }
        if (this.materialTypeTo != null) {
            sql2.append(" and mt.fnumber <= '").append(this.materialTypeTo.trim()).append("' ");
        }
        sql2.append(")");
        DbUtil.execute((Context)this.ctx, (String)sql2.toString());
    }

    private Object getSqlDate() {
        StringBuffer sql = new StringBuffer();
        this.cal = Calendar.getInstance();
        this.cal.set(this.cal.get(1), this.cal.get(2), this.cal.get(5), 23, 59, 59);
        Date endDate = this.cal.getTime();
        this.cal.set(this.cal.get(1), this.cal.get(2), this.cal.get(5) - this.stayDays, 0, 0, 0);
        Date beginDate = this.cal.getTime();
        sql.append(" and ( bill.fbizDate>=to_date('" + IMRptUtils.getFilterBeginDate(beginDate) + "') and bill.fbizDate<=to_date('" + IMRptUtils.getFilterEndDate(endDate) + "') )");
        return sql.toString();
    }

    private Object getSqlMaterialType() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select distinct flongnumber from t_bd_materialGroup mt  inner join T_BD_MaterialGroupDetial as mgd  on mt.fid = mgd.FMaterialGroupID where mgd.FMaterialGroupStandardID='");
        sql2.append(this.materialGroupStandardId).append("'");
        sql2.append(" ORDER BY mt.flongnumber ");
        if (this.materialTypeFrom != null) {
            sql2.append(" and mt.fnumber >= '").append(this.materialTypeFrom.trim()).append("' ");
        }
        if (this.materialTypeTo != null) {
            sql2.append(" and mt.fnumber <= '").append(this.materialTypeTo.trim()).append("' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql2.toString());
        boolean rsFirst = true;
        StringBuffer sql3 = new StringBuffer();
        int i = 0;
        while (rs.next()) {
            String flongnumber = rs.getString("flongnumber");
            ++i;
            if (!rsFirst) {
                sql3.append(" or ");
            } else {
                rsFirst = false;
            }
            sql3.append(" materialGroup.flongnumber = '").append(flongnumber.trim()).append("' ");
        }
        if (i > 0) {
            sql.append(" and ( ").append(sql3).append(" ) ");
        } else {
            sql.append(" and 1 = 2 ");
        }
        return sql.toString();
    }

    private boolean checkParentLongNumberCached(String flongnumber, Map<String, String> mtgLongNumberCache) {
        String[] longNumberArray = flongnumber.split("!");
        boolean isParentCache = false;
        if (longNumberArray.length > 1) {
            for (int longnumberIndex = 0; longnumberIndex < longNumberArray.length - 1; ++longnumberIndex) {
                StringBuffer longnumberbuffer = new StringBuffer();
                for (int j = 0; j <= longnumberIndex; ++j) {
                    if (j != 0) {
                        longnumberbuffer.append("!");
                    }
                    longnumberbuffer.append(longNumberArray[j]);
                }
                if (mtgLongNumberCache.get(longnumberbuffer.toString()) == null) continue;
                isParentCache = true;
                break;
            }
        }
        return isParentCache;
    }

    private Object getSqlWarehs() {
        StringBuffer sql = new StringBuffer();
        sql.append(" and (");
        for (int i = 0; i < this.warehs.length; ++i) {
            if (i != 0) {
                sql.append(" or ");
            }
            sql.append(" warehouse.fnumber='" + this.warehs[i].trim() + "'");
        }
        sql.append(" )");
        return sql.toString();
    }

    private Object getSqlStorageOrgUnits() throws BOSException {
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)this.ctx, (IObjectPK)this.ctx.getCaller(), (String)"MaterialStayReport_view");
        Object[] objects = InvServerUtils.getSelAuthorUnit(cuUnitSets, this.fullStorageOrgs).toArray();
        StringBuffer sql = new StringBuffer();
        sql.append(" and (");
        if (objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (i != 0) {
                    sql.append(" or ");
                }
                sql.append(" storage.fnumber = '" + ((FullOrgUnitInfo)objects[i]).getNumber() + "'");
            }
        } else {
            sql.append(" storage.fid = '").append("111111111111111111111111111=").append("'");
        }
        sql.append(" )");
        return sql.toString();
    }

    private String createTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("FID varchar(44),\r\n");
        sql.append("FMaterialID varchar(44),\r\n");
        sql.append("FMaterialNum nvarchar(255),\r\n");
        sql.append("FMaterialName nvarchar(255),\r\n");
        sql.append("FMaterialModel nvarchar(255),\r\n");
        sql.append("FAssistPropertyID varchar(44),\r\n");
        sql.append("FAssistPropertyName nvarchar(255),\r\n");
        sql.append("FLot nvarchar(255),\r\n");
        sql.append("FCompanyOrgUnitId varchar(44),\r\n");
        sql.append("FStorageOrgUnitID varchar(44),\r\n");
        sql.append("FStorageNum nvarchar(255),\r\n");
        sql.append("FStorageName nvarchar(255),\r\n");
        sql.append("FWarehouseID varchar(44), \r\n");
        sql.append("FWarehouseNum nvarchar(255), \r\n");
        sql.append("FWarehouseName nvarchar(255),\r\n");
        sql.append("FLocationID varchar(44), \r\n");
        sql.append("FLocationNum nvarchar(255), \r\n");
        sql.append("FLocationName nvarchar(255),\r\n");
        sql.append("FProjectID varchar(44), \r\n");
        sql.append("FProjectNum nvarchar(255), \r\n");
        sql.append("FProjectName nvarchar(255),\r\n");
        sql.append("FTrackNumberID varchar(44), \r\n");
        sql.append("FTrackNumberNum nvarchar(255), \r\n");
        sql.append("FTrackNumberName nvarchar(255),\r\n");
        sql.append("FStoreStatusId nvarchar(44), \r\n");
        sql.append("FStoreStatusName nvarchar(255),\r\n");
        sql.append("FLogID nvarchar(255), \r\n");
        sql.append("FBillNumber nvarchar(255), \r\n");
        sql.append("FUnitID varchar(44),\r\n");
        sql.append("FUnitName nvarchar(255),\r\n");
        sql.append("FQty NUMERIC(21,8) DEFAULT 0,\r\n");
        sql.append("FBaseUnitID varchar(44),\r\n");
        sql.append("FBaseUnitName nvarchar(255),\r\n");
        sql.append("FBaseQty NUMERIC(21,8) DEFAULT 0,\r\n");
        sql.append("Fbaseprice NUMERIC(21,8) DEFAULT 0,\r\n");
        sql.append("Fprice NUMERIC(21,8) DEFAULT 0,\r\n");
        sql.append("FAmount NUMERIC(19,4) DEFAULT 0,\r\n");
        sql.append("Fdelete INT DEFAULT 0,\r\n");
        sql.append("FActualBaseUnitCost NUMERIC(21,8) DEFAULT 0,\r\n");
        sql.append("FActualCost NUMERIC(28,11) DEFAULT 0,\r\n");
        sql.append("FPricePrecision int DEFAULT 6,\r\n");
        sql.append("FlocalcurrencyPrecision int DEFAULT 4,\r\n");
        sql.append("FLastInDate nvarchar(255),\r\n");
        sql.append("FLastOutDate nvarchar(255),\r\n");
        sql.append("FIsTotal int DEFAULT 0 \r\n");
        sql.append(" )");
        return sql.toString();
    }

    private String getLastDateSqlFromBill(List tableList, String tempStayMaterialTable, boolean isOutBill) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < tableList.size(); ++i) {
            String tableName = ((String[])tableList.get(i))[0];
            String entryName = ((String[])tableList.get(i))[1];
            if (i != 0) {
                sql.append(" union all ");
            }
            sql.append(" select temp.fid as FTempId,max(bill.fbizDate) as flastbilldate from " + tableName + " bill ");
            sql.append(" inner join " + entryName + " entry on bill.fid=entry.fparentid ");
            sql.append(" inner join " + tempStayMaterialTable + " temp on entry.fmaterialid=temp.fmaterialid ");
            sql.append(" inner join t_scm_transactiontype trantype on trantype.fid=bill.ftransactiontypeid ");
            sql.append(" where bill.FStorageOrgUnitID=temp.FStorageOrgUnitID ");
            if (this.inCluWarehs) {
                sql.append(" and isnull(temp.FWarehouseID,'XXXXXX')=isnull(entry.FWarehouseID,'XXXXXX') ");
            }
            if (this.inCluLocation) {
                sql.append(" and isnull(temp.FLocationID,'XXXXXX')=isnull(entry.FLocationID,'XXXXXX') ");
            }
            if (this.inCluProject) {
                sql.append(" and isnull(temp.FProjectID,'XXXXXX')=isnull(entry.FProjectID,'XXXXXX') ");
            }
            if (this.inCluTrackNumber) {
                sql.append(" and isnull(temp.FTrackNumberID,'XXXXXX')=isnull(entry.FTrackNumberID,'XXXXXX') ");
            }
            if (this.inCluLot) {
                sql.append(" and isnull(temp.FLot,'XXXXXX')=isnull(entry.FLot,'XXXXXX') ");
            }
            if (this.inCluAssist) {
                sql.append(" and isnull(temp.FAssistPropertyID,'XXXXXX')=isnull(entry.FAssistPropertyID,'XXXXXX') ");
            }
            if (tableName.equals("T_IM_OTHERINWAREHSBILL") || tableName.equals("T_IM_OTHERISSUEBILL")) {
                sql.append(" and entry.fstoretypeid='181875d5-0105-1000-e000-0111c0a812fd97D461A6' ");
            } else {
                sql.append(" and (trantype.fstoretypeid='181875d5-0105-1000-e000-0111c0a812fd97D461A6' or trantype.fstoretypepreid='181875d5-0105-1000-e000-0111c0a812fd97D461A6')");
            }
            sql.append(" and bill.FIsReversed = 0 and bill.FBaseStatus = 4 ");
            sql.append(" group by temp.fid ");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) {
        this.fullStorageOrgs = (Object[])params.getObject("fullStorageOrgs");
        this.warehs = params.getObject("warehs") != null ? ((String)params.getObject("warehs")).split(";") : null;
        if (params.getObject("materialFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialFrom"));
            if (numArray[0] != null) {
                this.materialFrom = numArray[0];
            } else if (numArray[1] != null) {
                this.mNumbersFrom = numArray[1];
            }
        }
        this.materialTo = params.getObject("materialTo") != null ? (String)params.getObject("materialTo") : null;
        this.materialTypeFrom = params.getObject("materialTypeFrom") != null ? (String)params.getObject("materialTypeFrom") : null;
        this.materialTypeTo = params.getObject("materialTypeTo") != null ? (String)params.getObject("materialTypeTo") : null;
        this.materialGroupStandardId = params.getObject("materialGroupStandard") != null ? (String)params.getObject("materialGroupStandard") : null;
        this.assistFrom = params.getObject("assistFrom") != null ? (String)params.getObject("assistFrom") : null;
        this.assistTo = params.getObject("assistTo") != null ? (String)params.getObject("assistTo") : null;
        this.projectFrom = params.getObject("projectFrom") != null ? (String)params.getObject("projectFrom") : null;
        this.projectTo = params.getObject("projectTo") != null ? (String)params.getObject("projectTo") : null;
        this.trackNumberFrom = params.getObject("trackNumberFrom") != null ? (String)params.getObject("trackNumberFrom") : null;
        this.trackNumberTo = params.getObject("trackNumberTo") != null ? (String)params.getObject("trackNumberTo") : null;
        this.lotFrom = params.getObject("lotFrom") != null ? (String)params.getObject("lotFrom") : null;
        this.lotTo = params.getObject("lotTo") != null ? (String)params.getObject("lotTo") : null;
        this.stayDays = Integer.parseInt((String)params.getObject("stayDays"));
        this.PriceSelect = Integer.parseInt((String)params.getObject("priceSelect"));
        if ("true".equals((String)params.getObject("stayNoInOut"))) {
            this.stayReason = this.stayNoInOut;
        } else if ("true".equals((String)params.getObject("stayNoOutHasIn"))) {
            this.stayReason = this.stayNoOutAndHasIn;
        } else if ("true".equals((String)params.getObject("stayNoOut"))) {
            this.stayReason = this.stayNotOut;
        }
        this.inCluStansferBill = new Boolean((String)params.getObject("inCluStansferBill"));
        this.inCluFreeze = new Boolean((String)params.getObject("inCluFreeze"));
        this.showLastBillDate = new Boolean((String)params.getObject("showLastBillDate"));
        this.inCluWarehs = new Boolean((String)params.getObject("inCluWarehs"));
        this.inCluLocation = new Boolean((String)params.getObject("inCluLocation"));
        this.inCluProject = new Boolean((String)params.getObject("inCluProject"));
        this.inCluTrackNumber = new Boolean((String)params.getObject("inCluTrackNumber"));
        this.inCluLot = new Boolean((String)params.getObject("inCluLot"));
        this.inCluAssist = new Boolean((String)params.getObject("inCluAssist"));
        this.inCluUnit = new Boolean((String)params.getObject("inCluUnit"));
        this.inCluStoreStatus = new Boolean((String)params.getObject("inCluStoreStatus"));
    }

    private void insertDataToTempStayMaterialTable(String tempStayMaterialTable, String tempTableMaterialsFromBills) throws Exception {
        String materialGroupTmpTbl = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA ( FMaterial VARCHAR(44) DEFAULT('')) \n");
        this.insertMgTempTbl(materialGroupTmpTbl);
        DbUtil.execute((Context)this.getContext(), (String)this.getSelectSqlForStayMaterialTable(tempStayMaterialTable, tempTableMaterialsFromBills, materialGroupTmpTbl).toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(materialGroupTmpTbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDataToTempStayMaterialTableWhileNotOutAndIn(String tempTableMaterialsFromBills) throws Exception {
        DbUtil.execute((Context)this.ctx, (String)("delete from " + tempTableMaterialsFromBills));
        ArrayList<String[]> tableList = new ArrayList<String[]>();
        tableList.add(new String[]{"T_IM_saleissuebill", "T_IM_saleissueentry"});
        tableList.add(new String[]{"T_IM_materialreqbill", "T_IM_materialreqbillentry"});
        tableList.add(new String[]{"t_im_otherissuebill", "t_im_otherissuebillentry"});
        if (this.inCluStansferBill) {
            tableList.add(new String[]{"T_IM_Moveissuebill", "T_IM_Moveissuebillentry"});
        }
        String materialGroupTmpTbl = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA ( FMaterial VARCHAR(44) DEFAULT('')) \n");
        this.insertMgTempTbl(materialGroupTmpTbl);
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(this.ctx, null);
        try {
            for (int i = 0; i < tableList.size(); ++i) {
                String sql = this.getSelectSqlForTableMaterialsFromBills((String[])tableList.get(i), tempTableMaterialsFromBills, materialGroupTmpTbl).toString();
                QueryDataTask thread = new QueryDataTask(lock, ((String[])tableList.get(i))[0], sysTempTableHelper.getConn(), sql.toString());
                lock.addLock(((String[])tableList.get(i))[0]);
                threadPool.addTask((Runnable)thread);
            }
            lock.waitFinish();
        }
        finally {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(materialGroupTmpTbl);
            sysTempTableHelper.releaseConnection();
        }
    }

    protected ReportTitles getReportTitles(String arg0, RptParams arg1) throws BaseException {
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource", (String)"priceBasis", (Locale)this.ctx.getLocale()) + " " + RptPriceEnum.getEnum(Integer.parseInt((String)arg1.getObject("priceSelect"))).getAlias());
        return titles;
    }

    public Integer getRowCount(String tempTable) throws BOSException {
        return 1;
    }

    private String getSumAmoutSql(String tempStayMaterialTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FStorageNum,FStorageName, sum(FAmount) as sumAmount ");
        sql.append(" from " + tempStayMaterialTable);
        sql.append(" group by FStorageNum, FStorageName ");
        return sql.toString();
    }
}

