/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class NewOutStorageGatherReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.NewOutStorageGatherReport");
    private List<String> listReverse = new ArrayList<String>();
    private List<String> listReverseName = new ArrayList<String>();
    public static final String RESOURCE = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private String locFName = "FName_l2";
    private String orgUnit;
    private String dateFrom;
    private String dateTo;
    private String materialNumFrom;
    private String mNumsFrom;
    private String materialNumTo;
    private String trsTypeFrom;
    private String warehouseFrom;
    private String whousesFrom;
    private String warehouseTo;
    private String projectNumFrom;
    private String projectNumTo;
    private String trackNumFrom;
    private String trackNumTo;
    private String isStatByDepart;
    private String isBaseUnitStat;
    private Boolean ckBxShowUpdateInventoryBill;
    private String isDepNull;
    private String materialTypeFrom;
    private String materialTypeTo;
    private String materialGroupStandardId;
    private StringBuffer storageOrgUnitID;
    private Context ctx;
    private String matpermSql = null;
    private String matpermJoinSql = null;
    private String warepermSql = null;
    private String warepermJoinSql = null;
    private String groupDimension;
    private String costCenterFrom;
    private String costCenterTo;

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String materialGroupTmpTbl;
        MaterialGroupInfo mGroup;
        String[] numArray;
        this.ctx = EASEjbFactory.getCtx((String)((Object)((Object)this)).getClass().getName(), (Context)this.getContext());
        this.locFName = this.getLocName("FName");
        this.orgUnit = (String)filter.getObject("OrgUnit", (Object)"");
        if (!StringUtils.isEmpty((String)this.orgUnit)) {
            String[] orgUnits = this.orgUnit.split(";");
            this.orgUnit = "'',";
            for (int i = 0; i < orgUnits.length; ++i) {
                this.orgUnit = this.orgUnit + "'" + orgUnits[i].trim() + "',";
                if (i >= 195) break;
            }
            this.orgUnit = this.orgUnit.substring(0, this.orgUnit.length() - 1);
        }
        String storageOrgUnit = (String)filter.getObject("bizStorageOrgUnit", (Object)"");
        Set<String> orgSet = this.getStroageIds(storageOrgUnit);
        OrgUnitInfo[] storageOrgUnits = this.getStorageOrgs();
        this.storageOrgUnitID = new StringBuffer();
        if (orgSet.size() > 0 && storageOrgUnits != null) {
            for (String storageOrgUnitId : orgSet) {
                for (int i = 0; i < storageOrgUnits.length; ++i) {
                    OrgUnitInfo info = storageOrgUnits[i];
                    if (info == null || !storageOrgUnitId.equals(info.getId().toString())) continue;
                    this.storageOrgUnitID.append("'").append(info.getId()).append("',");
                }
            }
        }
        if (StringUtil.isEmpty((String)this.storageOrgUnitID.toString())) {
            this.storageOrgUnitID.append("'").append("111111111111111111111111111=").append("',");
        }
        this.storageOrgUnitID = new StringBuffer(this.storageOrgUnitID.substring(0, this.storageOrgUnitID.length() - 1));
        this.getPerm(this.getContext(), filter);
        this.dateFrom = (String)filter.getObject("DateFrom", (Object)"");
        this.dateTo = (String)filter.getObject("DateTo", (Object)"");
        if (filter.getObject("MaterialNumFrom") != null) {
            numArray = SCMUtil.getF7Numbers((Object)filter.getObject("MaterialNumFrom"));
            if (numArray[0] != null) {
                this.materialNumFrom = numArray[0];
            } else if (numArray[1] != null) {
                this.mNumsFrom = numArray[1];
            }
        } else {
            this.materialNumFrom = null;
            this.mNumsFrom = null;
        }
        this.materialNumTo = (String)filter.getObject("MaterialNumTo", (Object)"");
        this.trsTypeFrom = (String)filter.getObject("TrsTypeFrom", (Object)"");
        if (this.trsTypeFrom != null && this.trsTypeFrom.length() > 0) {
            String[] trsTypes = this.trsTypeFrom.split(";");
            this.trsTypeFrom = "'',";
            for (int i = 0; i < trsTypes.length; ++i) {
                this.trsTypeFrom = this.trsTypeFrom + "'" + trsTypes[i].trim() + "',";
            }
            this.trsTypeFrom = this.trsTypeFrom.substring(0, this.trsTypeFrom.length() - 1);
        }
        if (filter.getObject("WarehouseFrom") != null) {
            numArray = SCMUtil.getF7Numbers((Object)filter.getObject("WarehouseFrom"));
            if (numArray[0] != null) {
                this.warehouseFrom = numArray[0];
            } else if (numArray[1] != null) {
                this.whousesFrom = numArray[1];
            }
        } else {
            this.warehouseFrom = null;
            this.whousesFrom = null;
        }
        this.warehouseTo = (String)filter.getObject("WarehouseTo", (Object)"");
        this.projectNumFrom = (String)filter.getObject("projectNumFrom", (Object)"");
        this.projectNumTo = (String)filter.getObject("projectNumTo", (Object)"");
        this.trackNumFrom = (String)filter.getObject("trackNumFrom", (Object)"");
        this.trackNumTo = (String)filter.getObject("trackNumTo", (Object)"");
        this.costCenterFrom = (String)filter.getObject("costCenterFrom", (Object)"");
        this.costCenterTo = (String)filter.getObject("costCenterTo", (Object)"");
        this.isStatByDepart = (String)filter.getObject("IsStatByDepart", (Object)"");
        this.isBaseUnitStat = (String)filter.getObject("IsBaseUnitStat", (Object)"");
        this.ckBxShowUpdateInventoryBill = filter.getBoolean("ckBxShowUpdateInventoryBill");
        this.isDepNull = (String)filter.getObject("IsDepNull", (Object)"");
        if (filter.getObject("MaterialTypeFrom") != null) {
            mGroup = this.getMaterialGroup(filter, filter.getObject("MaterialTypeFrom").toString());
            this.materialTypeFrom = mGroup.getLongNumber();
        } else {
            this.materialTypeFrom = null;
        }
        if (filter.getObject("MaterialTypeTo") != null) {
            this.materialTypeTo = filter.getObject("MaterialTypeTo").toString();
            mGroup = this.getMaterialGroup(filter, filter.getObject("MaterialTypeTo").toString());
            this.materialTypeTo = mGroup.getLongNumber();
        } else {
            this.materialTypeTo = null;
        }
        this.materialGroupStandardId = filter.getObject("materialGroupStandard") != null ? (String)filter.getObject("materialGroupStandard") : null;
        this.groupDimension = filter.getObject("groupDimension") != null ? (String)filter.getObject("groupDimension") : "0";
        StringBuffer sbSQL = new StringBuffer();
        this.listReverse = new ArrayList<String>();
        this.listReverseName = new ArrayList<String>();
        try {
            materialGroupTmpTbl = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA ( FMaterialGroupId VARCHAR(44) DEFAULT('')) \n");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        long startGenSql = System.currentTimeMillis();
        this.insertMgTempTbl(filter, materialGroupTmpTbl);
        try {
            if ("0".equals(this.groupDimension)) {
                sbSQL.append(this.getSelectSQL(filter, "adminOrg", materialGroupTmpTbl));
            } else if ("1".equals(this.groupDimension)) {
                sbSQL.append(this.getSelectSQL(filter, "costCenter", materialGroupTmpTbl));
            } else {
                sbSQL.append(this.getSelectSQL(filter, "TRANSACTIONTYPE", materialGroupTmpTbl));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        long endGenSql = System.currentTimeMillis();
        logger.error((Object)("################# --GenSqlSpendTime:" + (endGenSql - startGenSql)));
        long startExecuteSql = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sbSQL.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(materialGroupTmpTbl);
        long endExecuteSql = System.currentTimeMillis();
        logger.error((Object)("################# --ExecuteSqlSpendTime:" + (endExecuteSql - startExecuteSql)));
        long startGetData = System.currentTimeMillis();
        String tempTblName = null;
        try {
            tempTblName = this.getData(rs, filter);
            if (tempTblName == null) {
                tempTblName = this.createTmpTableSQL();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        long endGetData = System.currentTimeMillis();
        logger.error((Object)("################# --GetDataSpendTime:" + (endGetData - startGetData)));
        return tempTblName;
    }

    private MaterialGroupInfo getMaterialGroup(RptParams filter, String mGroupNumber) throws BOSException {
        MaterialGroupInfo mGroup = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)mGroupNumber));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.setFilter(filterInfo);
        MaterialGroupCollection coll = MaterialGroupFactory.getLocalInstance((Context)this.ctx).getMaterialGroupCollection(view);
        if (coll != null && coll.size() > 0) {
            mGroup = coll.get(0);
        }
        return mGroup;
    }

    private String getData(IRowSet rs, RptParams params) throws Exception {
        block25: {
            int i;
            if (!rs.next()) break block25;
            boolean hasNull = false;
            StringBuffer sbSQL = new StringBuffer();
            int qtyPrecision = params.getInt("spinQtyPrecission");
            int amtPrecision = params.getInt("spinAmountPrecission");
            int pricePrecision = params.getInt("spinPricePrecission");
            this.listReverse.add("111111111111111111111111111111");
            this.listReverseName.add(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"185_NewOutStorageGatherReport", (Locale)this.getContext().getLocale()));
            rs.beforeFirst();
            while (rs.next()) {
                String fAdminNumber = this.isNull(rs.getString("FADMINNUM"), "");
                if (this.listReverse.contains(fAdminNumber)) continue;
                if (this.listReverse.size() >= 195) break;
                if ("".equals(fAdminNumber)) {
                    hasNull = true;
                    continue;
                }
                this.listReverse.add(fAdminNumber);
                this.listReverseName.add(rs.getString("FADMINNAME"));
            }
            if (hasNull) {
                this.listReverse.add("");
                this.listReverseName.add(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"184_NewOutStorageGatherReport", (Locale)this.getContext().getLocale()));
            }
            String sTmpTableName = this.createTmpTableSQL();
            rs.beforeFirst();
            rs.next();
            String[] row = new String[6 + 5 * this.listReverse.size()];
            row[0] = this.isNull(rs.getString("FMATERIALID"), "");
            row[1] = this.isNull(rs.getString("FMATERIALNUM"), "");
            row[2] = this.isNull(rs.getString("FMATERIALNAME"), "");
            row[3] = this.isNull(rs.getString("FMATERIALMODEL"), "");
            row[4] = this.isNull(rs.getString("FUNITID"), "");
            row[5] = this.isNull(rs.getString("FUNITNAME"), "");
            for (int i2 = 0; i2 < this.listReverse.size(); ++i2) {
                row[6 + i2 * 5 + 0] = "0";
                row[6 + i2 * 5 + 1] = "0";
                row[6 + i2 * 5 + 2] = "0";
                row[6 + i2 * 5 + 3] = "0";
                row[6 + i2 * 5 + 4] = "0";
            }
            rs.beforeFirst();
            Connection conn = null;
            Statement statement = null;
            boolean countnum = false;
            int count = 0;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                statement = conn.createStatement();
                while (rs.next()) {
                    ++count;
                    boolean isChange = false;
                    String fMaterialID = this.isNull(rs.getString("FMATERIALID"), "");
                    String fMaterialNum = this.isNull(rs.getString("FMATERIALNUM"), "");
                    String fMaterialName = this.isNull(rs.getString("FMATERIALNAME"), "");
                    String fMaterialModel = this.isNull(rs.getString("FMATERIALMODEL"), "");
                    String fUnitID = this.isNull(rs.getString("FUNITID"), "");
                    String fUnitName = this.isNull(rs.getString("FUNITNAME"), "");
                    if (!(fMaterialID.equals(row[0]) && fMaterialNum.equals(row[1]) && fMaterialName.equals(row[2]) && fMaterialModel.equals(row[3]) && fUnitID.equals(row[4]) && fUnitName.equals(row[5]))) {
                        isChange = true;
                    }
                    if (isChange) {
                        int i3;
                        BigDecimal[] dblSum = new BigDecimal[5];
                        for (i3 = 0; i3 < dblSum.length; ++i3) {
                            dblSum[i3] = new BigDecimal("0.0");
                        }
                        for (i3 = 1; i3 < this.listReverse.size(); ++i3) {
                            dblSum[0] = dblSum[0].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 0]))));
                            dblSum[2] = dblSum[2].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 2]))));
                            dblSum[4] = dblSum[4].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 4]))));
                        }
                        if (dblSum[0].compareTo(new BigDecimal(0)) != 0) {
                            if (dblSum[2].compareTo(new BigDecimal(0)) != 0) {
                                dblSum[1] = dblSum[2].divide(dblSum[0], pricePrecision, 4);
                            }
                            if (dblSum[4].compareTo(new BigDecimal(0)) != 0) {
                                dblSum[3] = dblSum[4].divide(dblSum[0], pricePrecision, 4);
                            }
                        }
                        row[6] = dblSum[0].toString();
                        row[7] = dblSum[1].toString();
                        row[8] = dblSum[2].toString();
                        row[9] = dblSum[3].toString();
                        row[10] = dblSum[4].toString();
                        sbSQL = new StringBuffer();
                        sbSQL.append("INSERT INTO " + sTmpTableName + " SELECT ");
                        sbSQL.append("'").append(row[0]).append("',");
                        sbSQL.append("'").append(row[1]).append("',");
                        sbSQL.append("'").append(null != row[2] ? row[2].replace("'", "''") : row[2]).append("',");
                        sbSQL.append("'").append(null != row[3] ? row[3].replace("'", "''") : row[3]).append("',");
                        sbSQL.append("'").append(row[4]).append("',");
                        sbSQL.append("'").append(row[5]).append("',");
                        for (i3 = 0; i3 < this.listReverse.size(); ++i3) {
                            sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 0]).setScale(10, 2))).append(",");
                            sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 1]).setScale(10, 2))).append(",");
                            sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 2]).setScale(10, 2))).append(",");
                            sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 3]).setScale(10, 2))).append(",");
                            sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i3 * 5 + 4]).setScale(10, 2))).append(",");
                        }
                        sbSQL.deleteCharAt(sbSQL.length() - 1);
                        statement.addBatch(sbSQL.toString());
                        row = new String[6 + 5 * this.listReverse.size()];
                        for (i3 = 0; i3 < this.listReverse.size(); ++i3) {
                            row[6 + i3 * 5 + 0] = "0.0";
                            row[6 + i3 * 5 + 1] = "0.0";
                            row[6 + i3 * 5 + 2] = "0.0";
                            row[6 + i3 * 5 + 3] = "0.0";
                            row[6 + i3 * 5 + 4] = "0.0";
                        }
                    }
                    row[0] = this.isNull(rs.getString("FMATERIALID"), "");
                    row[1] = this.isNull(rs.getString("FMATERIALNUM"), "");
                    row[2] = this.isNull(rs.getString("FMATERIALNAME"), "");
                    row[3] = this.isNull(rs.getString("FMATERIALMODEL"), "");
                    row[4] = this.isNull(rs.getString("FUNITID"), "");
                    row[5] = this.isNull(rs.getString("FUNITNAME"), "");
                    String fAdminNumber = this.isNull(rs.getString("FADMINNUM"), "");
                    int index = this.listReverse.indexOf(fAdminNumber);
                    row[6 + index * 5 + 0] = rs.getDouble("FQTY") + "";
                    row[6 + index * 5 + 1] = rs.getDouble("FCOSTPER") + "";
                    row[6 + index * 5 + 2] = rs.getDouble("FACTUALCOST") + "";
                    row[6 + index * 5 + 3] = rs.getDouble("FAMOUNTPER") + "";
                    row[6 + index * 5 + 4] = rs.getDouble("FAMOUNT") + "";
                }
                statement.executeBatch();
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
            sbSQL = new StringBuffer();
            sbSQL.append("INSERT INTO " + sTmpTableName + " SELECT ");
            sbSQL.append("'").append(row[0]).append("',");
            sbSQL.append("'").append(row[1]).append("',");
            sbSQL.append("'").append(null != row[2] ? row[2].replace("'", "''") : row[2]).append("',");
            sbSQL.append("'").append(null != row[3] ? row[3].replace("'", "''") : row[3]).append("',");
            sbSQL.append("'").append(row[4]).append("',");
            sbSQL.append("'").append(row[5]).append("',");
            BigDecimal[] dblSum = new BigDecimal[5];
            for (i = 0; i < dblSum.length; ++i) {
                dblSum[i] = new BigDecimal("0.0");
            }
            for (i = 1; i < this.listReverse.size(); ++i) {
                dblSum[0] = dblSum[0].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 0]))));
                dblSum[2] = dblSum[2].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 2]))));
                dblSum[4] = dblSum[4].add(new BigDecimal(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 4]))));
            }
            if (dblSum[0].compareTo(new BigDecimal(0)) != 0) {
                if (dblSum[2].compareTo(new BigDecimal(0)) != 0) {
                    dblSum[1] = dblSum[2].divide(dblSum[0], pricePrecision, 4);
                }
                if (dblSum[4].compareTo(new BigDecimal(0)) != 0) {
                    dblSum[3] = dblSum[4].divide(dblSum[0], pricePrecision, 4);
                }
            }
            row[6] = dblSum[0].toString();
            row[7] = dblSum[1].toString();
            row[8] = dblSum[2].toString();
            row[9] = dblSum[3].toString();
            row[10] = dblSum[4].toString();
            for (i = 0; i < this.listReverse.size(); ++i) {
                sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 0]))).append(",");
                sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 1]))).append(",");
                sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 2]))).append(",");
                sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 3]))).append(",");
                sbSQL.append(SCMServerUtils.toPlainString((BigDecimal)new BigDecimal(row[6 + i * 5 + 4]))).append(",");
            }
            sbSQL.deleteCharAt(sbSQL.length() - 1);
            DbUtil.execute((Context)this.ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append("INSERT INTO " + sTmpTableName + " SELECT ");
            sbSQL.append("'").append("").append("',");
            sbSQL.append("'").append("").append("',");
            sbSQL.append("'").append("").append("',");
            sbSQL.append("'").append("").append("',");
            sbSQL.append("'").append("").append("',");
            sbSQL.append("'").append(this.getResourceString("totalAccount")).append("',");
            for (i = 0; i < this.listReverse.size(); ++i) {
                sbSQL.append("ROUND(to_decimal(SUM(FReverseCol" + i + "_FQTY),21,8)," + qtyPrecision + "),");
                sbSQL.append("CASE WHEN sum(FReverseCol" + i + "_FQTY)= 0 THEN 0 ELSE ROUND(to_decimal(to_decimal(SUM(FReverseCol" + i + "_FACTUALCOST),21,8) / to_decimal(SUM(FReverseCol" + i + "_FQTY),21,8),21,8)," + pricePrecision + ")END,");
                sbSQL.append("ROUND(to_decimal(SUM(FReverseCol" + i + "_FACTUALCOST),21,8)," + amtPrecision + "),");
                sbSQL.append("CASE WHEN sum(FReverseCol" + i + "_FQTY)= 0 THEN 0 ELSE ROUND(to_decimal(to_decimal(SUM(FReverseCol" + i + "_FAMOUNT),21,8) / to_decimal(SUM(FReverseCol" + i + "_FQTY),21,8),21,8)," + pricePrecision + ") END,");
                sbSQL.append("ROUND(to_decimal(SUM(FReverseCol" + i + "_FAMOUNT),21,8)," + amtPrecision + "),");
            }
            sbSQL.deleteCharAt(sbSQL.length() - 1);
            sbSQL.append(" FROM " + sTmpTableName);
            DbUtil.execute((Context)this.ctx, (String)sbSQL.toString());
            return sTmpTableName;
        }
        return null;
    }

    private void getPerm(Context ctx, RptParams filter) throws BOSException {
        Set cuUnitSets = InvServerUtils.getAuthorizedf7Orgs(ctx, "NewOutStorageGatherReport_view");
        String storageOrgUnit = (String)filter.getObject("bizStorageOrgUnit", (Object)"");
        Object[] storageOrgUnitNumbers = storageOrgUnit.split(";");
        for (int i = 0; i < storageOrgUnitNumbers.length; ++i) {
            storageOrgUnitNumbers[i] = ((String)storageOrgUnitNumbers[i]).trim();
        }
        Set orgUnitSets = this.getSelAuthorUnit(cuUnitSets, storageOrgUnitNumbers);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"bd_material_view", (String)"MATERIAL", (String)"Bill");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"warehous_view", (String)"WAREHOUSE", (String)"Bill");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            this.matpermSql = " and" + (String)matpermRuleMap.get("PERM_WHERE");
            this.matpermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            this.warepermSql = " and" + (String)warepermRuleMap.get("PERM_WHERE");
            this.warepermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
        }
    }

    private String isNull(String instr, String tostr) {
        if (instr == null) {
            return tostr;
        }
        return instr;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        String dateFrom = (String)filter.getObject("DateFrom", (Object)"");
        String dateTo = (String)filter.getObject("DateTo", (Object)"");
        dateFrom = this.getDateFmtString(this.ctx, dateFrom);
        dateTo = this.getDateFmtString(this.ctx, dateTo);
        titles.AddTitle(0, this.getResourceString("bizDate") + "\uff1a" + dateFrom.substring(0, 10) + " " + this.getResourceString("DATE_TO") + " " + dateTo.substring(0, 10));
        String groupDimension = "0";
        if (filter.getObject("groupDimension") != null) {
            groupDimension = (String)filter.getObject("groupDimension");
        }
        if ("0".equals(groupDimension)) {
            titles.AddTitle(2, this.getResourceString("DimensionSum") + this.getResourceString("totalByDept"));
        } else if ("1".equals(groupDimension)) {
            titles.AddTitle(2, this.getResourceString("DimensionSum") + this.getResourceString("totalByCostCenter"));
        } else {
            titles.AddTitle(2, this.getResourceString("DimensionSum") + this.getResourceString("totalByTransactionType"));
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader root = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", root);
        ReportHeader child = root.addChild("FMATERIALNUM", this.getResourceString("materialNumber"));
        dctHeader.put(child.getFieldName(), child);
        child = root.addChild("FMATERIALNAME", this.getResourceString("materialName"));
        dctHeader.put(child.getFieldName(), child);
        child = root.addChild("FMATERIALMODEL", this.getResourceString("materialModel"));
        dctHeader.put(child.getFieldName(), child);
        child = root.addChild("FUNITNAME", this.getResourceString("unit"));
        dctHeader.put(child.getFieldName(), child);
        int qty = filter.getObject("spinQtyPrecission") == null ? 6 : filter.getInt("spinQtyPrecission");
        int amt = filter.getObject("spinAmountPrecission") == null ? 4 : filter.getInt("spinAmountPrecission");
        int price = filter.getObject("spinPricePrecission") == null ? 4 : filter.getInt("spinPricePrecission");
        for (int i = 0; i < this.listReverseName.size(); ++i) {
            String reverseName = this.listReverseName.get(i);
            child = root.addChild("FReverseCol" + i, reverseName);
            dctHeader.put(child.getFieldName(), child);
            ReportHeader sumChild = child.addChild("FReverseCol" + i + "_FQTY", this.getResourceString("qty"));
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(qty);
            dctHeader.put(sumChild.getFieldName(), sumChild);
            sumChild = child.addChild("FReverseCol" + i + "_FCOSTPER", this.getResourceString("rptUnitActualCost"));
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(price);
            dctHeader.put(sumChild.getFieldName(), sumChild);
            sumChild = child.addChild("FReverseCol" + i + "_FACTUALCOST", this.getResourceString("rptActualCost"));
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(amt);
            dctHeader.put(sumChild.getFieldName(), sumChild);
            sumChild = child.addChild("FReverseCol" + i + "_FAMOUNTPER", this.getResourceString("salePrice"));
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(price);
            dctHeader.put(sumChild.getFieldName(), sumChild);
            sumChild = child.addChild("FReverseCol" + i + "_FAMOUNT", this.getResourceString("saleAmount"));
            sumChild.setType(2);
            sumChild.setAlign(3);
            sumChild.setDecimal(amt);
            dctHeader.put(sumChild.getFieldName(), sumChild);
        }
        return root;
    }

    private String getSelectSQL(RptParams filter, String tableAlias, String materialGroupTmpTbl) throws BOSException, SQLException {
        String[][] tables = new String[][]{{"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}};
        int qtyPrecision = filter.getInt("spinQtyPrecission");
        int amtPrecision = filter.getInt("spinAmountPrecission");
        int pricePrecision = filter.getInt("spinPricePrecission");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FMATERIALID\n");
        sql.append(", FMATERIALNUM\n");
        sql.append(", FMATERIALNAME\n");
        sql.append(", FMATERIALMODEL\n");
        sql.append(", FUNITID\n");
        sql.append(", FUNITNAME\n");
        sql.append(", FADMINORGUNITID\n");
        sql.append(", ISNULL(FADMINNAME,'" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"184_NewOutStorageGatherReport", (Locale)this.getContext().getLocale()) + "') FADMINNAME\n");
        sql.append(", FADMINNUM\n");
        sql.append(", round(sum(FQTY)," + qtyPrecision + ") FQTY\n");
        sql.append(", (CASE WHEN ROUND(SUM(FQTY)," + qtyPrecision + ") = 0 THEN 0 else round(to_decimal(SUM(FACTUALCOST),21,8) / SUM(FQTY)," + pricePrecision + ") END) FCOSTPER\n");
        sql.append(", round(sum(FACTUALCOST)," + amtPrecision + ") FACTUALCOST\n");
        sql.append(", (CASE WHEN ROUND(SUM(FQTY)," + qtyPrecision + ") = 0 THEN 0 else round(to_decimal(SUM(FAMOUNT),21,8) / SUM(FQTY)," + pricePrecision + ") END) FAMOUNTPER\n");
        sql.append(", round(sum(FAMOUNT)," + amtPrecision + ") FAMOUNT\n");
        sql.append(" FROM(\n");
        String tableAlais = "Bill";
        for (int i = 0; i < tables.length; ++i) {
            String[] table = tables[i];
            String billTable = table[0];
            tableAlais = billTable.equals("T_IM_MaterialReqBill") ? "BILLENTRY" : "Bill";
            sql.append("SELECT Material.FID FMATERIALID\n");
            sql.append(", Material.FNumber FMATERIALNUM\n");
            sql.append(", Material." + this.locFName + " FMATERIALNAME\n");
            sql.append(", Material.FMODEL FMATERIALMODEL\n");
            sql.append(", Unit.FID FUNITID\n");
            sql.append(", Unit." + this.locFName + " FUNITNAME\n");
            sql.append(", ").append(tableAlias).append(".FID FADMINORGUNITID\n");
            sql.append(", ").append(tableAlias).append("." + this.locFName + " FADMINNAME\n");
            sql.append(", ").append(tableAlias).append(".FNUMBER FADMINNUM\n");
            if ("true".equals(this.isBaseUnitStat)) {
                sql.append(", sum(round(decimal(BillEntry.FQty,21,8)*decimal(enMultiUnit.FBaseConvsRate,21,8)/decimal(multiUnit.FBaseConvsRate,21,8),multiUnit.FQtyPrecision)) FQTY\n");
            } else {
                sql.append(", sum(BillEntry.FBaseQty) FQTY\n");
            }
            sql.append(", sum(BillEntry.FActualCost) FACTUALCOST\n");
            if (billTable.equals("T_IM_SaleIssueBill")) {
                sql.append(", sum(BillEntry.FAmount) FAMOUNT\n");
            } else {
                sql.append(", 0 FAMOUNT \n");
            }
            sql.append("FROM " + billTable + " BILL \n");
            sql.append("INNER JOIN " + table[1] + " BILLENTRY ON Bill.FID = BillEntry.FParentID\n");
            sql.append("INNER JOIN T_IM_InvUpdateType tr on tr.fid = BILLENTRY.FInvUpdateTypeID ");
            if (this.ckBxShowUpdateInventoryBill.booleanValue()) {
                sql.append("and tr.FIsNotUpdateInv  = 0 ");
            }
            sql.append("LEFT OUTER JOIN T_Org_Admin adminOrg ON " + tableAlais + ".FadminOrgUnitID = adminOrg.FID \n");
            sql.append("LEFT OUTER JOIN T_ORG_CostCenter costCenter ON " + tableAlais + ".FCostCenterOrgUnitID = costCenter.FID \n");
            sql.append("INNER JOIN T_SCM_TransactionType TRANSACTIONTYPE ON Bill.FTransactionTypeID = TransactionType.FID \n");
            sql.append("INNER JOIN T_BD_Material MATERIAL ON BillEntry.FMaterialID = Material.FID \n");
            if ("true".equals(this.isBaseUnitStat)) {
                sql.append(" inner join  t_bd_multimeasureunit multiUnit \r\n");
                sql.append(" on Material.FID = multiUnit.FMaterialID \r\n");
                sql.append(" and multiUnit.FIsStatUnit = 1  \r\n");
                sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS unit \r\n");
                sql.append(" ON multiUnit.FMEASUREUNITID = unit.FID \r\n");
                sql.append(" inner join  t_bd_multimeasureunit enMultiUnit ");
                sql.append(" on (enMultiUnit.FMATERIALID = BillEntry.FMATERIALID and enMultiUnit.FMEASUREUNITID = BillEntry.FUNITID) ");
            } else {
                sql.append(" inner join  t_bd_multimeasureunit multiUnit \r\n");
                sql.append(" on Material.FID = multiUnit.FMaterialID \r\n");
                sql.append(" and multiUnit.FIsStatUnit = 1  \r\n");
                sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS unit \r\n");
                sql.append(" ON BILLENTRY.FBaseUnitID = unit.FID \r\n");
            }
            if (this.warehouseFrom != null || this.whousesFrom != null || !this.warehouseTo.equals("") || !"".equals(this.warepermSql)) {
                sql.append("INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON BillEntry.FWarehouseID = Warehouse.FID\n");
            }
            if (!"".equals(this.projectNumFrom) || !"".equals(this.projectNumTo)) {
                sql.append("INNER JOIN T_MM_Project PROJECT on BILLENTRY.FProjectID = project.FID\n");
            }
            if (!"".equals(this.trackNumFrom) || !"".equals(this.trackNumTo)) {
                sql.append("INNER JOIN T_MM_TrackNumber TRACK on BILLENTRY.FTrackNumberID = track.FID\n");
            }
            if (this.materialTypeFrom != null || this.materialTypeTo != null || this.materialGroupStandardId != null) {
                sql.append("inner join T_BD_MaterialGroupDetial as MGD on MGD.FMaterialID = MATERIAL.fid ");
            }
            if (this.materialTypeFrom != null || this.materialTypeTo != null) {
                sql.append(this.getMaterialGroupSql(materialGroupTmpTbl));
            }
            if (this.matpermJoinSql != null) {
                sql.append(this.matpermJoinSql);
            }
            if (this.warepermJoinSql != null) {
                sql.append(this.warepermJoinSql);
            }
            sql.append(this.getSqlWhere(tableAlias));
            if (i == tables.length - 1) continue;
            sql.append("UNION ALL \n");
        }
        sql.append(") temptable\n");
        sql.append("GROUP BY temptable.FMATERIALID\n");
        sql.append(",temptable.FMATERIALNUM\n");
        sql.append(",temptable.FMATERIALNAME\n");
        sql.append(",temptable.FMATERIALMODEL\n");
        sql.append(",temptable.FUNITID\n");
        sql.append(",temptable.FUNITNAME\n");
        sql.append(",temptable.FADMINORGUNITID\n");
        sql.append(",temptable.FADMINNAME\n");
        sql.append(",temptable.FADMINNUM\n");
        sql.append("ORDER BY FMATERIALNUM,FMATERIALNAME,FMATERIALMODEL,FUNITID,FUNITNAME,FADMINNUM\n");
        return sql.toString();
    }

    private String getResourceString(String resName) {
        return ResourceUtil.getString((String)RESOURCE, (String)resName, (Locale)this.getContext().getLocale());
    }

    private String createTmpTableSQL() throws Exception {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_NewOutStorageGatherReport( ");
        createTable.append("FMATERIALID varchar(44)\n");
        createTable.append(", FMATERIALNUM nvarchar(80)\n");
        createTable.append(", FMATERIALNAME nvarchar(255)\n");
        createTable.append(", FMATERIALMODEL nvarchar(255)\n");
        createTable.append(", FUNITID varchar(44)\n");
        createTable.append(", FUNITNAME nvarchar(80)\n");
        for (int i = 0; i < this.listReverse.size(); ++i) {
            createTable.append(", FReverseCol" + i + "_FQTY NUMERIC(21,8)\n");
            createTable.append(", FReverseCol" + i + "_FCOSTPER NUMERIC(21,8)\n");
            createTable.append(", FReverseCol" + i + "_FACTUALCOST NUMERIC(21,8)\n");
            createTable.append(", FReverseCol" + i + "_FAMOUNTPER NUMERIC(21,8)\n");
            createTable.append(", FReverseCol" + i + "_FAMOUNT NUMERIC(21,8)\n");
        }
        createTable.append(" ) ");
        String sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        return sTmpTblName;
    }

    private OrgUnitInfo[] getStorageOrgs() {
        try {
            IObjectPK userID = this.getContext().getCaller();
            IPermission permission = PermissionFactory.getLocalInstance((Context)this.getContext());
            FullOrgUnitCollection fullOrgUnits = permission.getAuthorizedOrg(userID, OrgType.Storage, null, "NewOutStorageGatherReport_view");
            OrgUnitInfo[] results = null;
            if (fullOrgUnits == null || fullOrgUnits.size() == 0) {
                return new OrgUnitInfo[0];
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < fullOrgUnits.size(); ++i) {
                keys.add(fullOrgUnits.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
            view.setFilter(filter);
            IStorageOrgUnit iAdmin = StorageOrgUnitFactory.getLocalInstance((Context)this.getContext());
            StorageOrgUnitCollection collection = iAdmin.getStorageOrgUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                results = new OrgUnitInfo[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    results[i] = collection.get(i);
                }
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getSqlWhere(String tableAlias) throws BOSException, SQLException {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("WHERE Bill.FBaseStatus = 4 AND (Bill.FIsInitBill =  0 OR Bill.FIsInitBill IS NULL)\n");
        sqlWhere.append(" and BILLENTRY.FINVUPDATETYPEID != 'CeUAAAAIdBvC73rf'");
        if (!StringUtils.isEmpty((String)this.orgUnit)) {
            sqlWhere.append("AND adminOrg.FNUMBER IN (" + this.orgUnit + ")\n");
        }
        sqlWhere.append("AND Bill.FStorageOrgUnitID IN (" + this.storageOrgUnitID + ")\n");
        sqlWhere.append("AND Bill.FBizDate >= to_date('" + this.dateFrom + "')\n");
        sqlWhere.append("AND Bill.FBizDate <= to_date('" + this.dateTo + "') \n");
        if (this.materialNumFrom != null) {
            sqlWhere.append("AND MATERIAL.FNUMBER >= '" + this.materialNumFrom + "'\n");
        } else if (this.mNumsFrom != null) {
            sqlWhere.append("AND MATERIAL.FNUMBER in (" + this.mNumsFrom + ")\n");
        }
        if (!this.materialNumTo.trim().equals("")) {
            sqlWhere.append("AND MATERIAL.FNUMBER<='" + this.materialNumTo + "'\n");
        }
        if (!this.trsTypeFrom.trim().equals("")) {
            sqlWhere.append("AND TRANSACTIONTYPE.FNUMBER in (" + this.trsTypeFrom + ")\n");
        }
        if (this.warehouseFrom != null) {
            sqlWhere.append("AND WAREHOUSE.FNUMBER >='" + this.warehouseFrom + "'\n");
        } else if (this.whousesFrom != null) {
            sqlWhere.append("AND WAREHOUSE.FNUMBER in (" + this.whousesFrom + ")\n");
        }
        if (!this.warehouseTo.trim().equals("")) {
            sqlWhere.append("AND WAREHOUSE.FNUMBER<='" + this.warehouseTo + "'\n");
        }
        if (!this.projectNumFrom.equals("")) {
            sqlWhere.append("AND PROJECT.FNUMBER>='" + this.projectNumFrom + "'\n");
        }
        if (!this.projectNumTo.equals("")) {
            sqlWhere.append("AND PROJECT.FNUMBER<='" + this.projectNumTo + "'\n");
        }
        if (!this.trackNumFrom.equals("")) {
            sqlWhere.append("AND TRACK.FNUMBER>='" + this.trackNumFrom + "'\n");
        }
        if (!this.trackNumTo.equals("")) {
            sqlWhere.append("AND TRACK.FNUMBER<='" + this.trackNumTo + "'\n");
        }
        if (!this.costCenterFrom.trim().equals("")) {
            sqlWhere.append("AND costCenter.FNUMBER >='" + this.costCenterFrom + "'\n");
        }
        if (!this.costCenterTo.trim().equals("")) {
            sqlWhere.append("AND costCenter.FNUMBER <='" + this.costCenterTo + "'\n");
        }
        if (this.matpermSql != null && this.matpermSql.length() > 0) {
            sqlWhere.append(this.matpermSql);
        }
        if (this.warepermSql != null && this.warepermSql.length() > 0) {
            sqlWhere.append(this.warepermSql);
        }
        if (!this.materialGroupStandardId.trim().equals("")) {
            sqlWhere.append(" and MGD.FMATERIALGROUPSTANDARDID = '").append(this.materialGroupStandardId).append("' ");
        }
        sqlWhere.append("GROUP BY Material.FID, Material.FNumber, Material." + this.locFName + ", Material.FMODEL, Unit.FID, Unit." + this.locFName + ", " + tableAlias + ".FID, " + tableAlias + "." + this.locFName + ", " + tableAlias + ".FNUMBER \n");
        return sqlWhere.toString();
    }

    private void insertMgTempTbl(RptParams filter, String tempTblName) throws BOSException {
        if (this.materialTypeFrom != null || this.materialTypeTo != null) {
            StringBuffer whereSql = new StringBuffer(" where 1 = 1 ");
            if (this.materialTypeFrom != null) {
                whereSql.append(" and (g.flongnumber >= '").append(this.materialTypeFrom).append("' ");
                whereSql.append(" or g.flongnumber like '").append(this.materialTypeFrom).append("!%') ");
            }
            if (this.materialTypeTo != null) {
                whereSql.append(" and (g.flongnumber <= '").append(this.materialTypeTo).append("' ");
                whereSql.append(" or g.flongnumber like '").append(this.materialTypeTo).append("!%') ");
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into " + tempTblName + " (FMaterialGroupID) ");
            insertSql.append("select fid from t_bd_materialGroup g ").append(whereSql);
            DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        }
    }

    private boolean checkParentLongNumberCached(String flongnumber, Map<String, String> mtgLongNumberCache) {
        String[] longNumberArray = flongnumber.split("!");
        boolean isParentCache = false;
        if (longNumberArray.length > 1) {
            for (int longnumberIndex = 0; longnumberIndex < longNumberArray.length - 1; ++longnumberIndex) {
                StringBuffer longnumberbuffer = new StringBuffer();
                for (int j = 0; j <= longnumberIndex; ++j) {
                    if (j != 0) {
                        longnumberbuffer.append("!");
                    }
                    longnumberbuffer.append(longNumberArray[j]);
                }
                if (mtgLongNumberCache.get(longnumberbuffer.toString()) == null) continue;
                isParentCache = true;
                break;
            }
        }
        return isParentCache;
    }

    private String getLocName(String field) {
        return field + "_" + LocaleUtils.getLocaleString((Locale)this.getContext().getLocale());
    }

    public Context getContext() {
        return super.getContext();
    }

    private Set<String> getStroageIds(String storageOrgUnit) throws SQLDataException {
        HashSet<String> orgSet = new HashSet<String>();
        String[] storageOrgUnits = storageOrgUnit.split(";");
        storageOrgUnit = "'',";
        for (int i = 0; i < storageOrgUnits.length; ++i) {
            storageOrgUnit = storageOrgUnit + "'" + storageOrgUnits[i].trim() + "',";
        }
        storageOrgUnit = storageOrgUnit.substring(0, storageOrgUnit.length() - 1);
        String sql = null;
        sql = "select fid from T_ORG_BaseUnit where fnumber in (" + storageOrgUnit + ")";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            RowSet rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                orgSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgSet;
    }

    private String getDateFmtString(Context ctx, String date) throws BaseException {
        if (!StringUtil.isEmpty((String)date)) {
            date = date.substring(0, date.indexOf(" "));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            HashMap nationMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, orgId, ctx.getLocale().toString());
            DateFormat format = (DateFormat)nationMap.get("dateFormat");
            return format.format(dateFormat.parse(date));
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    private Set getSelAuthorUnit(Set authorUnitSet, Object[] storageOrgNumbers) {
        HashSet<FullOrgUnitInfo> cuUnitSets = new HashSet<FullOrgUnitInfo>();
        Iterator it = authorUnitSet.iterator();
        FullOrgUnitInfo cuUnit = null;
        String orgNumber = null;
        block0: while (it.hasNext()) {
            cuUnit = (FullOrgUnitInfo)it.next();
            for (int i = 0; i < storageOrgNumbers.length; ++i) {
                orgNumber = (String)storageOrgNumbers[i];
                if (!cuUnit.getNumber().equals(orgNumber)) continue;
                cuUnitSets.add(cuUnit);
                continue block0;
            }
        }
        return cuUnitSets;
    }

    private String getMaterialGroupSql(String materialGroupTmpTbl) {
        StringBuffer sql = new StringBuffer();
        sql.append("inner join " + materialGroupTmpTbl + " tmpMG on  tmpMG.FMaterialGroupId = MGD.FMaterialGroupId  ");
        return sql.toString();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + " order by FMATERIALNUM asc"), (int)start, (int)rows);
        return rs;
    }

    public Integer getRowCount(String tempTable) throws BOSException {
        int rowCount = 0;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT count(1) fcount FROM " + tempTable));
        try {
            if (rs.next()) {
                rowCount = rs.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }
}

