/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.app.AbstractOutTransactionGatherRptFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OutTransactionGatherRptFacadeControllerBean
extends AbstractOutTransactionGatherRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.OutTransactionGatherRptFacadeControllerBean");
    private String statProjectNum = null;
    private String statProjectName = null;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = null;
        String sql = "";
        sql = this.getResultSql(ctx, params);
        if (sql.length() > 0) {
            rs = this.executeQuery(sql, null, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getResultSql(Context ctx, RptParams params) throws EASBizException, BOSException {
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (params.getBoolean("isStatByDepart")) {
            this.statProjectNum = "FAdminNumber";
            this.statProjectName = "FAdminName";
        } else {
            this.statProjectNum = "FTransactionNumber";
            this.statProjectName = "FTransactionName";
        }
        StringBuffer sql = new StringBuffer();
        if (!params.getBoolean("isStatBaseUnit")) {
            sql.append("select ");
            sql.append("tempTable.FMaterialNumber, ");
            sql.append("tempTable.FMaterialName, ");
            sql.append("tempTable.FMaterialMode, ");
            sql.append("tempTable." + this.statProjectNum + " ,");
            sql.append("tempTable." + this.statProjectName + " ,");
            sql.append("MeasureUnit.FName_").append(lang).append(", ");
            sql.append("sum(tempTable.FQty), ");
            sql.append("case sum(tempTable.FQty) ");
            sql.append("when 0 ");
            sql.append("then 0 ");
            sql.append("else decimal(sum(tempTable.FActualCost),21,8)/decimal(sum(tempTable.FQty),21,8) end, ");
            sql.append("sum(tempTable.FActualCost), ");
            sql.append("case sum(tempTable.FQty) ");
            sql.append("when 0 ");
            sql.append("then 0 ");
            sql.append("else decimal(sum(tempTable.FAmount),21,8)/decimal(sum(tempTable.FQty),21,8) end,");
            sql.append("sum(tempTable.FAmount), ");
            sql.append("avg(tempTable.FTag) ");
            sql.append("from ");
            sql.append(params.getString("tempTable") + " tempTable ");
            sql.append("inner join T_BD_MeasureUnit MeasureUnit ");
            sql.append("on tempTable.FBaseUnitID = MeasureUnit.FID ");
            sql.append("group by tempTable.FMaterialNumber, ");
            sql.append("tempTable.FMaterialName, ");
            sql.append("tempTable.FMaterialMode, ");
            sql.append("tempTable." + this.statProjectNum + " ,");
            sql.append("tempTable." + this.statProjectName + " ,");
            sql.append("MeasureUnit.FName_").append(lang).append(", ");
            sql.append("tempTable.FTag ");
            sql.append("order by tempTable.FMaterialNumber ASC, tempTable.FTag ASC ");
        } else {
            sql.append("select ");
            sql.append("tempTable.FMaterialNumber, ");
            sql.append("tempTable.FMaterialName, ");
            sql.append("tempTable.FMaterialMode, ");
            sql.append("tempTable." + this.statProjectNum + " ,");
            sql.append("tempTable." + this.statProjectName + " ,");
            sql.append("MeasureUnit.FName_").append(lang).append(", ");
            sql.append("sum(tempTable.FQty) / MultiMeasureUnit.FBaseConvsRate, ");
            sql.append("case (sum(tempTable.FQty) / MultiMeasureUnit.FBaseConvsRate) ");
            sql.append("when 0 ");
            sql.append("then 0 ");
            sql.append("else decimal(sum(tempTable.FActualCost),21,8)/decimal((sum(tempTable.FQty) / MultiMeasureUnit.FBaseConvsRate),21,8) end, ");
            sql.append("sum(tempTable.FActualCost), ");
            sql.append("case (sum(tempTable.FQty) / MultiMeasureUnit.FBaseConvsRate) ");
            sql.append("when 0 ");
            sql.append("then 0 ");
            sql.append("else decimal(sum(tempTable.FAmount),21,8)/decimal((sum(tempTable.FQty) / MultiMeasureUnit.FBaseConvsRate),21,8) end,");
            sql.append("sum(tempTable.FAmount), ");
            sql.append("avg(tempTable.FTag) ");
            sql.append("from ");
            sql.append(params.getString("tempTable") + " tempTable ");
            sql.append("inner join T_BD_MultiMeasureUnit MultiMeasureUnit ");
            sql.append("on tempTable.FMaterialID = MultiMeasureUnit.FMaterialID ");
            sql.append("inner join T_BD_MeasureUnit MeasureUnit ");
            sql.append("on MultiMeasureUnit.FMeasureUnitID = MeasureUnit.FID ");
            sql.append("where FIsStatUnit = 1 ");
            sql.append("group by tempTable.FMaterialNumber, ");
            sql.append("tempTable.FMaterialName, ");
            sql.append("tempTable.FMaterialMode, ");
            sql.append("tempTable." + this.statProjectNum + " ,");
            sql.append("tempTable." + this.statProjectName + " ,");
            sql.append("MeasureUnit.FName_").append(lang).append(", ");
            sql.append("MultiMeasureUnit.FBaseConvsRate, ");
            sql.append("tempTable.FTag ");
            sql.append("order by tempTable.FMaterialNumber ASC, FTag ASC ");
        }
        return sql.toString();
    }

    private String getQuerySql(Context ctx, RptParams params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String[] commbillType = this.getCommBillType();
        sql.append("select ");
        sql.append("* from (");
        int n = commbillType.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sql.append(" union all ");
            }
            sql.append(this.getCommonQuerySql(ctx, commbillType[i], params));
        }
        String[] specialbillType = this.getSpecialBillType();
        int n2 = specialbillType.length;
        for (int i = 0; i < n2; ++i) {
            sql.append(" union all ");
            sql.append(this.getSpecialQuerySql(ctx, specialbillType[i], params));
        }
        sql.append(") wholeTable order by wholeTable.FMaterialNumber, wholeTable.FAdminNumber, wholeTable.FTransactionNumber asc");
        return sql.toString();
    }

    private String[] getCommBillType() {
        String[] billType = new String[]{"106", "104", "108"};
        return billType;
    }

    private String[] getSpecialBillType() {
        String[] billType = new String[]{"102"};
        return billType;
    }

    private String getCommonQuerySql(Context ctx, String billNo, RptParams params) throws EASBizException, BOSException {
        int index;
        String id;
        int size;
        StringBuffer sql = new StringBuffer();
        String billTable = InvCommonUtils.getBillTableName(billNo);
        String billEntryTable = InvCommonUtils.getBillEntryTableName(billNo);
        String FName = "FName_" + ctx.getLocale().getDisplayName();
        sql.append("select ");
        sql.append("Material.FID as FMaterialID, ");
        sql.append("Material.FNumber as FMaterialNumber, ");
        sql.append("Material." + FName + " as FMaterialName, ");
        sql.append("Material.FModel as MaterialMode, ");
        sql.append("Material.FBaseUnit as FBaseUnitID, ");
        sql.append("Admin.FNumber as FAdminNumber, ");
        sql.append("Admin." + FName + " as FAdminName, ");
        sql.append("TransactionType.FNumber as FTransactionNumber, ");
        sql.append("TransactionType." + FName + " as FTransactionName, ");
        sql.append("sum(BillEntry.FBaseQty) as FQty, ");
        sql.append("0 as FUnitActualCost , ");
        sql.append("sum(BillEntry.FActualCost) as FActualCost, ");
        sql.append("0 as FPrice, ");
        sql.append("0 as FAmount, ");
        sql.append("1 as FTag ");
        sql.append("from " + billTable + " Bill ");
        sql.append("inner join " + billEntryTable + " BillEntry ");
        sql.append("on Bill.FID = BillEntry.FParentID ");
        sql.append("left outer join T_Org_Admin Admin ");
        sql.append("on Bill.FadminOrgUnitID = Admin.FID ");
        sql.append("inner join T_SCM_TransactionType TransactionType ");
        sql.append("on Bill.FTransactionTypeID = TransactionType.FID ");
        sql.append("inner join T_BD_Material Material ");
        sql.append("on BillEntry.FMaterialID = Material.FID ");
        sql.append("inner join T_DB_WAREHOUSE Warehouse ");
        sql.append("on BillEntry.FWarehouseID = Warehouse.FID ");
        sql.append("where Bill.FBaseStatus = 4 ");
        sql.append(" and (Bill.FIsInitBill = 0  or Bill.FIsInitBill is null ) ");
        if (params.getObject("materialFrom") != null) {
            String materialFrom = ((MaterialInfo)params.getObject("materialFrom")).getNumber();
            sql.append("and Material.fnumber >='" + materialFrom + "' ");
        }
        if (params.getObject("materialTo") != null) {
            String materialTo = ((MaterialInfo)params.getObject("materialTo")).getNumber();
            sql.append("and Material.fnumber <='" + materialTo + "' ");
        }
        if (params.getObject("fullAdminOrgs") != null && params.getObject("fullAdminOrgs") instanceof Object[]) {
            Object[] objects = (Object[])params.getObject("fullAdminOrgs");
            size = objects.length;
            id = null;
            for (index = 0; index < size; ++index) {
                id = ((AdminOrgUnitInfo)objects[index]).getId().toString();
                if (index == 0) {
                    sql.append("and ( Admin.fid ='" + id + "' ");
                } else {
                    sql.append("or Admin.fid ='" + id + "' ");
                }
                if (index != size - 1) continue;
                sql.append("or Admin.FID is null\r\n");
                sql.append(" ) ");
            }
        }
        if (params.getObject("permmisionOrgs") != null && params.getObject("permmisionOrgs") instanceof FullOrgUnitCollection) {
            FullOrgUnitCollection coll = (FullOrgUnitCollection)params.getObject("permmisionOrgs");
            size = coll.size();
            id = null;
            for (index = 0; index < size; ++index) {
                id = coll.get(index).getId().toString();
                if (index == 0) {
                    sql.append("and ( Bill.FStorageOrgUnitID ='" + id + "' ");
                } else {
                    sql.append("or Bill.FStorageOrgUnitID ='" + id + "' ");
                }
                if (index != size - 1) continue;
                sql.append(" ) ");
            }
        } else {
            sql.append("and  Bill.FStorageOrgUnitID is null ");
        }
        if (params.getObject("transactionTypeFrom") != null) {
            String transactionTypeFrom = ((TransactionTypeInfo)params.getObject("transactionTypeFrom")).getNumber();
            sql.append("and TransactionType.fnumber >='" + transactionTypeFrom + "' ");
        }
        if (params.getObject("transactionTypeTo") != null) {
            String transactionTypeTo = ((TransactionTypeInfo)params.getObject("transactionTypeTo")).getNumber();
            sql.append("and TransactionType.fnumber <='" + transactionTypeTo + "' ");
        }
        if (params.getObject("bizeDateFrom") != null) {
            Date bDate = (Date)params.getObject("bizeDateFrom");
            sql.append("and Bill.fbizdate >= to_date('" + IMRptUtils.getFilterBeginDate(bDate) + "') ");
        }
        if (params.getObject("bizeDateTo") != null) {
            Date eDate = (Date)params.getObject("bizeDateTo");
            sql.append("and Bill.fbizdate <= to_date('" + IMRptUtils.getFilterEndDate(eDate) + "') ");
        }
        if (params.getObject("warehouseFrom") != null) {
            String wareFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
            sql.append("and Warehouse.fnumber >='" + wareFrom + "' ");
        }
        if (params.getObject("warehouseTo") != null) {
            String wareTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            sql.append("and Warehouse.fnumber <='" + wareTo + "' ");
        }
        sql.append("group by ");
        sql.append("Material.FID,");
        sql.append("Material.FNumber,Material." + FName + ",");
        sql.append("Material.FModel,");
        sql.append("Material.FBaseUnit,");
        sql.append("Admin.FNumber,Admin." + FName + ",");
        sql.append("TransactionType.FNumber,TransactionType." + FName + "");
        return sql.toString();
    }

    private String getSpecialQuerySql(Context ctx, String billNo, RptParams params) throws EASBizException, BOSException {
        int index;
        String id;
        int size;
        StringBuffer sql = new StringBuffer();
        String billTable = InvCommonUtils.getBillTableName(billNo);
        String billEntryTable = InvCommonUtils.getBillEntryTableName(billNo);
        String FName = "FName_" + ctx.getLocale().getDisplayName();
        sql.append("select ");
        sql.append("Material.FID as FMaterialID, ");
        sql.append("Material.FNumber as FMaterialNumber, ");
        sql.append("Material." + FName + " as FMaterialName, ");
        sql.append("Material.FModel as MaterialMode, ");
        sql.append("Material.FBaseUnit as FBaseUnitID, ");
        sql.append("Admin.FNumber as FAdminNumber, ");
        sql.append("Admin." + FName + " as FAdminName, ");
        sql.append("TransactionType.FNumber as FTransactionNumber, ");
        sql.append("TransactionType." + FName + " as FTransactionName, ");
        sql.append("sum(BillEntry.FBaseQty) as FQty, ");
        sql.append("0 as FUnitActualCost , ");
        sql.append("sum(BillEntry.FActualCost) as FActualCost, ");
        sql.append("0 as FPrice ,");
        sql.append("sum(BillEntry.FAmount) as FAmount, ");
        sql.append("1 as FTag ");
        sql.append("from " + billTable + " Bill ");
        sql.append("inner join " + billEntryTable + " BillEntry ");
        sql.append("on Bill.FID = BillEntry.FParentID ");
        sql.append("left outer join T_Org_Admin Admin ");
        sql.append("on Bill.FadminOrgUnitID = Admin.FID ");
        sql.append("inner join T_SCM_TransactionType TransactionType ");
        sql.append("on Bill.FTransactionTypeID = TransactionType.FID ");
        sql.append("inner join T_BD_Material Material ");
        sql.append("on BillEntry.FMaterialID = Material.FID ");
        sql.append("inner join T_DB_WAREHOUSE Warehouse ");
        sql.append("on BillEntry.FWarehouseID = Warehouse.FID ");
        sql.append("where Bill.FBaseStatus = 4 ");
        sql.append(" and (Bill.FIsInitBill = 0  or Bill.FIsInitBill is null ) ");
        if (params.getObject("materialFrom") != null) {
            String materialFrom = ((MaterialInfo)params.getObject("materialFrom")).getNumber();
            sql.append("and Material.fnumber >='" + materialFrom + "' ");
        }
        if (params.getObject("materialTo") != null) {
            String materialTo = ((MaterialInfo)params.getObject("materialTo")).getNumber();
            sql.append("and Material.fnumber <='" + materialTo + "' ");
        }
        if (params.getObject("fullAdminOrgs") != null && params.getObject("fullAdminOrgs") instanceof Object[]) {
            Object[] objects = (Object[])params.getObject("fullAdminOrgs");
            size = objects.length;
            id = null;
            for (index = 0; index < size; ++index) {
                id = ((AdminOrgUnitInfo)objects[index]).getId().toString();
                if (index == 0) {
                    sql.append("and ( Admin.fid ='" + id + "' ");
                } else {
                    sql.append("or Admin.fid ='" + id + "' ");
                }
                if (index != size - 1) continue;
                sql.append("or Admin.FID is null\r\n");
                sql.append(" ) ");
            }
        }
        if (params.getObject("permmisionOrgs") != null && params.getObject("permmisionOrgs") instanceof FullOrgUnitCollection) {
            FullOrgUnitCollection coll = (FullOrgUnitCollection)params.getObject("permmisionOrgs");
            size = coll.size();
            id = null;
            for (index = 0; index < size; ++index) {
                id = coll.get(index).getId().toString();
                if (index == 0) {
                    sql.append("and ( Bill.FStorageOrgUnitID ='" + id + "' ");
                } else {
                    sql.append("or Bill.FStorageOrgUnitID ='" + id + "' ");
                }
                if (index != size - 1) continue;
                sql.append(" ) ");
            }
        } else {
            sql.append("and  Bill.FStorageOrgUnitID is null ");
        }
        if (params.getObject("transactionTypeFrom") != null) {
            String transactionTypeFrom = ((TransactionTypeInfo)params.getObject("transactionTypeFrom")).getNumber();
            sql.append("and TransactionType.fnumber >='" + transactionTypeFrom + "' ");
        }
        if (params.getObject("transactionTypeTo") != null) {
            String transactionTypeTo = ((TransactionTypeInfo)params.getObject("transactionTypeTo")).getNumber();
            sql.append("and TransactionType.fnumber <='" + transactionTypeTo + "' ");
        }
        if (params.getObject("bizeDateFrom") != null) {
            Date bDate = (Date)params.getObject("bizeDateFrom");
            sql.append("and Bill.fbizdate >= to_date('" + IMRptUtils.getFilterBeginDate(bDate) + "') ");
        }
        if (params.getObject("bizeDateTo") != null) {
            Date eDate = (Date)params.getObject("bizeDateTo");
            sql.append("and Bill.fbizdate <= to_date('" + IMRptUtils.getFilterEndDate(eDate) + "') ");
        }
        if (params.getObject("warehouseFrom") != null) {
            String wareFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
            sql.append("and Warehouse.fnumber >='" + wareFrom + "' ");
        }
        if (params.getObject("warehouseTo") != null) {
            String wareTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            sql.append("and Warehouse.fnumber <='" + wareTo + "' ");
        }
        sql.append("group by ");
        sql.append("Material.FID,");
        sql.append("Material.FNumber,Material." + FName + ",");
        sql.append("Material.FModel,");
        sql.append("Material.FBaseUnit,");
        sql.append("Admin.FNumber,Admin." + FName + ",");
        sql.append("TransactionType.FNumber,TransactionType." + FName + "");
        return sql.toString();
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        this.dropTable(tempTable, ctx);
        String sql = "";
        tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"201_OutTransactionGatherRptFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        params.setString("tempTable", tempTable);
        sql = this.getCreateTempTable(ctx, tempTable);
        this.executeSQL(ctx, sql);
        sql = this.getInsertTempTable(ctx, tempTable, params);
        this.executeSQL(ctx, sql);
        sql = this.computerTotalComlumns(ctx, tempTable);
        this.executeSQL(ctx, sql);
        params.setString("tempTable", tempTable);
        return params;
    }

    private String computerTotalComlumns(Context ctx, String tempName) {
        StringBuffer stringBuff = new StringBuffer();
        stringBuff.append("insert into " + tempName);
        stringBuff.append(" select ");
        stringBuff.append(" FMaterialID, ");
        stringBuff.append(" FMaterialNumber ,FMaterialName,FMaterialMode,FBaseUnitID, ");
        stringBuff.append(" '','" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"202_OutTransactionGatherRptFacadeControllerBean", (Locale)ctx.getLocale()) + "','','" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"202_OutTransactionGatherRptFacadeControllerBean", (Locale)ctx.getLocale()) + "', ");
        stringBuff.append(" sum(FQty), ");
        stringBuff.append(" case sum(FQty) ");
        stringBuff.append(" when 0 ");
        stringBuff.append(" then 0 ");
        stringBuff.append(" else decimal(sum(FActualCost),21,8)/decimal(sum(FQty),21,8) end, ");
        stringBuff.append(" sum(FActualCost), ");
        stringBuff.append(" case sum(FQty) ");
        stringBuff.append(" when 0 ");
        stringBuff.append(" then 0 ");
        stringBuff.append(" else decimal(sum(FAmount),21,8)/decimal(sum(FQty),21,8) end, ");
        stringBuff.append(" sum(FAmount), ");
        stringBuff.append(" 2 ");
        stringBuff.append(" from " + tempName);
        stringBuff.append(" group by FMaterialID, FBaseUnitID, FMaterialNumber, FMaterialName,FMaterialMode");
        return stringBuff.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String getCreateTempTable(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + tempTable + " (");
        sql.append("FMaterialID varchar(44),");
        sql.append("FMaterialNumber nvarchar(255),");
        sql.append("FMaterialName nvarchar(255),");
        sql.append("FMaterialMode nvarchar(255),");
        sql.append("FBaseUnitID varchar(44),");
        sql.append("FAdminNumber nvarchar(255),");
        sql.append("FAdminName nvarchar(255), ");
        sql.append("FTransactionNumber nvarchar(255),");
        sql.append("FTransactionName nvarchar(255),");
        sql.append("FQty numeric(31,10),");
        sql.append("FUnitActualCost numeric(31,10),");
        sql.append("FActualCost numeric(31,10),");
        sql.append("FPrice numeric(31,10),");
        sql.append("FAmount numeric(31,10), ");
        sql.append("FTag int");
        sql.append(")");
        return sql.toString();
    }

    private String getInsertTempTable(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTable + " ");
        sql.append(this.getQuerySql(ctx, params) + " ");
        return sql.toString();
    }
}

