/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.CarryBillCollection;
import com.kingdee.eas.scm.im.dt.CarryBillEntryCollection;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFactory;
import com.kingdee.eas.scm.im.dt.CarryBillFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.ILogisticsFee;
import com.kingdee.eas.scm.im.dt.LogisticsFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.LogisticsFeeFactory;
import com.kingdee.eas.scm.im.dt.LogisticsFeeInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractCarryBillFacadeControllerBean;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CarryBillFacadeControllerBean
extends AbstractCarryBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.dt.app.CarryBillFacadeControllerBean");

    @Override
    protected List _generateLogisticsFee(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        LinkedHashSet idSet = new LinkedHashSet();
        Iterator iter = idList.iterator();
        while (iter.hasNext()) {
            idSet.add(iter.next());
        }
        Date now = new Date();
        ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ILogisticsFee ilf = LogisticsFeeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(7)));
        filter.setMaskString("#0 AND (#1 OR #2)");
        view.getSelector().add("*");
        view.getSelector().add("feeEntry.*");
        view.setFilter(filter);
        CarryBillCollection srcColl = CarryBillFactory.getLocalInstance(ctx).getCarryBillCollection(view);
        ArrayList<String> destNumberList = new ArrayList<String>();
        int n = srcColl.size();
        for (int i = 0; i < n; ++i) {
            CarryBillInfo srcBill = srcColl.get(i);
            LogisticsFeeInfo destBill = new LogisticsFeeInfo();
            destBill.setId(BOSUuid.create((String)"ED47D50A"));
            destBill.setBizDate(now);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"emdfS9tk/UGnMuPbpL799kY+1VI="));
            destBill.setBillType(billType);
            destBill.setSourceBillType(srcBill.getBillType());
            destBill.setSourceBillId(srcBill.getId().toString());
            destBill.setBizType(srcBill.getBizType());
            destBill.setDistributionType(srcBill.getDistributionType());
            destBill.setTransportOrgUnit(srcBill.getTransportOrgUnit());
            destBill.setCompanyOrgUnit(srcBill.getCompanyOrgUnit());
            destBill.setBaseStatus(BillBaseStatusEnum.ADD);
            int m = srcBill.getFeeEntry().size();
            for (int j = 0; j < m; ++j) {
                CarryBillFeeEntryInfo srcEntry = srcBill.getFeeEntry().get(j);
                if (srcEntry.getUnbalancedQty() == null || srcEntry.getUnbalancedQty().compareTo(DtUtils.ZERO) <= 0) continue;
                LogisticsFeeEntryInfo destEntry = new LogisticsFeeEntryInfo();
                destEntry.setId(BOSUuid.create((String)"D465D988"));
                destEntry.setBalancer(srcEntry.getFeeCarrier());
                destEntry.setDetailLine(srcEntry.getFeeCarryLine());
                destEntry.setFeeItem(srcEntry.getFeeItem());
                destEntry.setTransportType(srcEntry.getFeeTransType());
                destEntry.setMaterial(srcEntry.getFeeMaterial());
                destEntry.setUnit(srcEntry.getFeeUnit());
                destEntry.setQty(srcEntry.getUnbalancedQty());
                destEntry.setBalanceQty(srcEntry.getUnbalancedQty());
                destEntry.setRatingPrice(srcEntry.getFeePrice());
                destEntry.setRatingAmt(srcEntry.getFeePrice().multiply(destEntry.getBalanceQty()));
                destEntry.setBalancePrice(srcEntry.getAgreePrice());
                destEntry.setBalanceAmt(srcEntry.getAgreePrice().multiply(destEntry.getBalanceQty()));
                destEntry.setBaseStatus(EntryBaseStatusEnum.ADD);
                destEntry.setSourceBillId(srcBill.getId().toString());
                destEntry.setSourceBillNumber(srcBill.getNumber());
                destEntry.setSourceBillType(srcBill.getBillType());
                destEntry.setSourceBillEntryId(srcEntry.getId().toString());
                destEntry.setSourceBillEntrySeq(srcEntry.getSeq());
                destEntry.setCoreBillId(srcBill.getId().toString());
                destEntry.setCoreBillNo(srcBill.getNumber());
                destEntry.setCoreBillType(srcBill.getBillType());
                destEntry.setCoreBillEntryId(srcEntry.getId().toString());
                destEntry.setCoreBillEntrySeq(srcEntry.getSeq());
                destBill.setBalancer(srcEntry.getFeeCarrier());
                destBill.getEntry().add(destEntry);
            }
            if (destBill.getEntry().size() <= 0) continue;
            destBill.setNumber(iCodingRule.getNumber((IObjectValue)destBill, destBill.getTransportOrgUnit().getId().toString()));
            destNumberList.add(destBill.getNumber());
            ilf.addnew((CoreBaseInfo)destBill);
            String srcId = srcBill.getId().toString();
            String destId = destBill.getId().toString();
            String srcBosType = srcBill.getBOSType().toString();
            String destBosType = destBill.getBOSType().toString();
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcId, (String)destId, (String)srcBosType, (String)destBosType);
        }
        return destNumberList;
    }

    @Override
    protected Set _getCarriers(Context ctx, String transportId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (transportId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT fid FROM T_DT_Carrier ");
            sql.append("\n where FTransportID = '" + transportId + "' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return set;
    }

    @Override
    protected Set _getCars(Context ctx, String transportId, String carrierId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (transportId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT distinct ce.FCarID FROM T_DT_Carrier c ");
            sql.append("\n INNER JOIN T_DT_CarrierCarEntry ce on c.FID = ce.FParentID ");
            sql.append("\n where c.FTransportID = '" + transportId + "' ");
            if (carrierId != null) {
                sql.append(" and c.FSupplierID = '" + carrierId + "' ");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return set;
    }

    @Override
    protected Set _getDrivers(Context ctx, String transportId, String carrierId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (transportId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT distinct ce.FDriverID FROM T_DT_Carrier c ");
            sql.append("\n INNER JOIN T_DT_CarrierDriverEntry ce on c.FID = ce.FParentID ");
            sql.append("\n where c.FTransportID = '" + transportId + "' ");
            if (carrierId != null) {
                sql.append(" and c.FSupplierID = '" + carrierId + "' ");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return set;
    }

    @Override
    protected Set _getSuppierID(Context ctx, String transportId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (transportId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT distinct fSupplierID FROM T_DT_Carrier ");
            sql.append("\n where FTransportID = '" + transportId + "' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return set;
    }

    @Override
    protected void _checkIn(Context ctx, Map[] checkInMap, String carryBillId) throws BOSException, EASBizException {
        CarryBillInfo info = CarryBillFactory.getLocalInstance(ctx).getCarryBillInfo(" select distributionType,entry.arAssociateQty, entry.qtyActual ,entry.receivedQty, entry.outQtyActual,entry.id where id = '" + carryBillId + "'");
        CarryBillEntryCollection collection = info.getEntry();
        int entrySize = checkInMap.length;
        HashMap checkInData = new HashMap();
        String entryID = null;
        BigDecimal outQtyActual = null;
        BigDecimal qtyActual = null;
        BigDecimal obeyQty = null;
        String checkInRemark = null;
        BigDecimal receivedQty = null;
        BigDecimal coefficient = null;
        Date checkInDate = null;
        DistributionTypeEnum distributionType = info.getDistributionType();
        BigDecimal arAssociateQty = null;
        BigDecimal approWasQty = null;
        BigDecimal approWasbaseQty = null;
        int n = entrySize;
        for (int i = 0; i < n; ++i) {
            checkInData = (HashMap)checkInMap[i];
            entryID = (String)checkInData.get("entryID");
            outQtyActual = (BigDecimal)checkInData.get("outQtyActual");
            qtyActual = (BigDecimal)checkInData.get("qtyActual");
            obeyQty = (BigDecimal)checkInData.get("obeyQty");
            checkInRemark = (String)checkInData.get("checkInRemark");
            receivedQty = (BigDecimal)checkInData.get("receivedQty");
            coefficient = (BigDecimal)checkInData.get("coefficient");
            checkInDate = (Date)checkInData.get("checkInDate");
            approWasQty = (BigDecimal)checkInData.get("approWasQty");
            approWasbaseQty = (BigDecimal)checkInData.get("approWasbaseQty");
            int size = collection.size();
            for (int j = 0; j < size; ++j) {
                BigDecimal subtractCheckIn;
                BigDecimal beforeCheckIn;
                BigDecimal afterCheckIn;
                CarryBillEntryInfo entryInfo = collection.get(j);
                if (!entryID.equals(entryInfo.getId().toString())) continue;
                if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) {
                    arAssociateQty = entryInfo.getArAssociateQty() == null ? DtUtils.ZERO : entryInfo.getArAssociateQty();
                    afterCheckIn = qtyActual.subtract(receivedQty);
                    beforeCheckIn = entryInfo.getQtyActual().subtract(entryInfo.getReceivedQty());
                    subtractCheckIn = afterCheckIn.subtract(beforeCheckIn);
                    if (coefficient != null) {
                        subtractCheckIn = subtractCheckIn.multiply(coefficient);
                        arAssociateQty = arAssociateQty.add(subtractCheckIn);
                        entryInfo.setArAssociateQty(arAssociateQty);
                    }
                    entryInfo.setQtyActual(qtyActual);
                    entryInfo.setObeyQty(obeyQty);
                    entryInfo.setQtyLoss(entryInfo.getOutQtyActual().subtract(qtyActual).subtract(obeyQty));
                    entryInfo.setReceivedLostQty(qtyActual.subtract(entryInfo.getReceivedQty()));
                }
                if (DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType)) {
                    arAssociateQty = entryInfo.getArAssociateQty() == null ? DtUtils.ZERO : entryInfo.getArAssociateQty();
                    afterCheckIn = qtyActual.subtract(receivedQty);
                    beforeCheckIn = entryInfo.getQtyActual().subtract(entryInfo.getReceivedQty());
                    subtractCheckIn = afterCheckIn.subtract(beforeCheckIn);
                    if (coefficient != null) {
                        subtractCheckIn = subtractCheckIn.multiply(coefficient);
                        arAssociateQty = arAssociateQty.add(subtractCheckIn);
                        entryInfo.setArAssociateQty(arAssociateQty);
                    }
                    entryInfo.setQtyActual(qtyActual);
                    entryInfo.setObeyQty(obeyQty);
                    entryInfo.setQtyLoss(entryInfo.getOutQtyActual().subtract(qtyActual).subtract(obeyQty));
                }
                if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType)) {
                    entryInfo.setOutQtyActual(outQtyActual);
                    entryInfo.setReceivedLostQty(outQtyActual.subtract(entryInfo.getReceivedQty()));
                }
                if (DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
                    entryInfo.setOutQtyActual(outQtyActual);
                    entryInfo.setObeyQty(obeyQty);
                    entryInfo.setQtyLoss(entryInfo.getOutQtyActual().subtract(qtyActual).subtract(obeyQty));
                    entryInfo.setReceivedLostQty(qtyActual.subtract(entryInfo.getReceivedQty()));
                }
                entryInfo.setCheckInRemark(checkInRemark);
                if (checkInDate == null) {
                    entryInfo.setCheckInDate(new Date());
                } else {
                    entryInfo.setCheckInDate(checkInDate);
                }
                entryInfo.setApproWasNum(approWasQty);
                entryInfo.setApproWasBaseNum(approWasbaseQty);
            }
        }
        CarryBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(carryBillId), (CoreBaseInfo)info);
    }
}

