/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.DTException;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractDeliveryLineControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DeliveryLineControllerBean
extends AbstractDeliveryLineControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.jh.app.DeliveryLineControllerBean");

    private void checkPermission(Context ctx, DeliveryLineInfo info, String action) throws BOSException, EASBizException {
        if (!info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) {
            if (action.equals("ACTION_CANCEL")) {
                throw new DTException(DTException.CAN_NOT_CANCEL);
            }
            if (action.equals("ACTION_CANCELCANCEL")) {
                throw new DTException(DTException.CAN_NOT_CANCELCANCEL);
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryLineInfo info = (DeliveryLineInfo)model;
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        boolean isAddNew = false;
        if (info.getId() == null || info.getId().toString().trim().length() == 0 || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            isAddNew = true;
        }
        String companyID = null;
        companyID = ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        boolean isNotAddView = this.isNotAddView(ctx, (IObjectValue)info, companyID);
        if (info.getNumber() == null || info.getNumber().toString().equals("")) {
            if (isAddNew && isNotAddView) {
                info.setNumber(this.getNewNumber(ctx, (IObjectValue)info, companyID, ""));
            } else {
                throw new DTException(DTException.CHECKBILLNUMBLANK);
            }
        }
        if (!isNotAddView) {
            try {
                this._checkNumberDup(ctx, (IObjectValue)model);
            }
            catch (EASBizException er) {
                throw new DTException(DTException.DLCHECKDUPLICATED, new Object[]{info.getNumber()});
            }
        }
        try {
            this._checkNameDup(ctx, (IObjectValue)model);
        }
        catch (EASBizException er) {
            throw new DTException(DTException.CHECKDUPLICATED, new Object[]{info.getName()});
        }
        if (BillStatusEnum.newbill.equals((Object)info.getStatus())) {
            info.setStatus(BillStatusEnum.save);
        }
        model = info;
        return super._submit(ctx, model);
    }

    public boolean isNotAddView(Context ctx, IObjectValue bizObject, String org) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.isExist(bizObject, org) && !iCodingRuleManager.isAddView(bizObject, org);
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        DeliveryLineInfo info = (DeliveryLineInfo)model;
        String number = "";
        number = iCodingRuleManager.getNumber((IObjectValue)info, strCompanyID, customString);
        info.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)info)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)info, strCompanyID, customString);
            if (newNumber.equals(info.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            info.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)info)) {
                return this.getNewNumber(ctx, (IObjectValue)info, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DeliveryLineInfo info = (DeliveryLineInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = info.getNumber() == null ? new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)info.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)info.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue arg2) throws BOSException, EASBizException {
        DeliveryLineInfo info = (DeliveryLineInfo)this._getValue(ctx, pk);
        this.checkPermission(ctx, info, "ACTION_CANCEL");
        if (!info.getStatus().equals((Object)BillStatusEnum.enable)) {
            throw new DTException(DTException.BILLNOTENABLE);
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT distinct entry.fid FROM T_DT_DeliveryLineEntry entry inner join T_DT_DeliveryLine head ");
            sql.append(" ON head.FID = entry.FParentID and head.FStatus = 2 ");
            sql.append(" where entry.fdetaillineid = '");
            sql.append(pk.toString());
            sql.append("' ");
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                throw new DTException(DTException.HAVE_DETAILLINE);
            }
            super._cancel(ctx, pk, arg2);
            info.setStatus(BillStatusEnum.disable);
            this._update(ctx, pk, (IObjectValue)info);
        }
        catch (SQLException e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue arg2) throws BOSException, EASBizException {
        DeliveryLineInfo info = (DeliveryLineInfo)this._getValue(ctx, pk);
        this.checkPermission(ctx, info, "ACTION_CANCELCANCEL");
        if (!info.getStatus().equals((Object)BillStatusEnum.save) && !info.getStatus().equals((Object)BillStatusEnum.disable)) {
            throw new DTException(DTException.BILLISENABLE);
        }
        super._cancelCancel(ctx, pk, arg2);
        info.setStatus(BillStatusEnum.enable);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryLineInfo info = (DeliveryLineInfo)model;
        if (info.getId() != null) {
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block5: {
                conn = null;
                stmt = null;
                rs = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT distinct fnumber FROM T_DT_DeliveryLine  ");
                    sql.append(" where fnumber = '");
                    sql.append(info.getNumber());
                    sql.append("' ");
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql.toString());
                    if (!rs.next()) break block5;
                    throw new DTException(DTException.HASNUMBER);
                }
                catch (SQLException e1) {
                    try {
                        throw new BOSException((Throwable)e1);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        return super._addnew(ctx, model);
    }
}

