/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.dt.AbstractDeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.DeliveryLineCollection;
import com.kingdee.eas.scm.im.dt.DeliveryLineEntryInfo;
import com.kingdee.eas.scm.im.dt.DeliveryLineFactory;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.app.DtDataImportUtils;
import com.kingdee.eas.scm.im.dt.util.client.DeliveryLineClientUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class DeliveryLineDataImport
extends AbstractDataTransmission {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private BigDecimal mileValue = new BigDecimal("0.00");
    private DeliveryLineInfo lineBill = null;
    private static String DELIVERYLINE_RESOURCE = "com.kingdee.eas.scm.im.dt.client.JhResource";

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.lineBill = null;
        this.mileValue = new BigDecimal("0.00");
        int keyCursor = 0;
        HashMap<String, Integer> lineEntryMap = new HashMap<String, Integer>();
        for (int i = 0; i < hsData.size(); ++i) {
            DeliveryLineEntryInfo entry;
            Hashtable lineData = (Hashtable)hsData.get(i);
            if (keyCursor == 0) {
                this.lineBill = this.transmitHead(lineData, ctx);
                if (this.lineBill == null) {
                    return null;
                }
            }
            if ((entry = this.transmitEntry(lineData, ctx)) != null) {
                if (entry.getDetailMileage() != null) {
                    this.mileValue = this.mileValue.add(entry.getDetailMileage());
                }
                int seq = this.lineBill.getEntry().size() + 1;
                entry.setSeq(seq);
                entry.setParent(this.lineBill);
                this.lineBill.getEntry().add(entry);
                if (entry.getDetailLine() != null && entry.getDetailLine().getNumber() != null && entry.getDetailLine().getNumber().length() > 0) {
                    if (lineEntryMap.containsKey(entry.getDetailLine().getNumber())) {
                        throw new TaskExternalException(MessageFormat.format(SCMUtils.getResource((String)DELIVERYLINE_RESOURCE, (String)"submit_REPEAT_ENTRY", (Context)ctx), lineEntryMap.get(entry.getDetailLine().getNumber()).toString(), Integer.toString(i + 1)));
                    }
                    lineEntryMap.put(entry.getDetailLine().getNumber(), i + 1);
                }
            }
            ++keyCursor;
        }
        if (this.lineBill.getTotalMileage() != null) {
            BigDecimal totalMile = this.lineBill.getTotalMileage();
            if (this.mileValue.compareTo(ZERO) > 0 && totalMile.compareTo(this.mileValue) != 0) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "DetailMileageNotSame"));
            }
        }
        if (this.lineBill != null && this.lineBill.getBeginStation() != null && this.lineBill.getEndStation() != null && this.lineBill.getEntry().size() > 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("beginStation.name"));
            selector.add(new SelectorItemInfo("endStation.name"));
            AbstractDeliveryLineInfo fristRowdetailBegin = null;
            AbstractDeliveryLineInfo laseRowdetailEnd = null;
            try {
                if (this.lineBill.getEntry() != null && this.lineBill.getEntry().get(0) != null && this.lineBill.getEntry().get(0).getDetailLine() != null) {
                    fristRowdetailBegin = DeliveryLineFactory.getLocalInstance(ctx).getDeliveryLineInfo((IObjectPK)new ObjectUuidPK(this.lineBill.getEntry().get(0).getDetailLine().getId()), selector);
                }
                if (this.lineBill.getEntry() != null && this.lineBill.getEntry().size() > 0 && this.lineBill.getEntry().get(this.lineBill.getEntry().size() - 1) != null && this.lineBill.getEntry().get(this.lineBill.getEntry().size() - 1).getDetailLine() != null) {
                    laseRowdetailEnd = DeliveryLineFactory.getLocalInstance(ctx).getDeliveryLineInfo((IObjectPK)new ObjectUuidPK(this.lineBill.getEntry().get(this.lineBill.getEntry().size() - 1).getDetailLine().getId()), selector);
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (!(fristRowdetailBegin == null || this.lineBill.getBeginStation().getName().equals(fristRowdetailBegin.getBeginStation().getName()) && laseRowdetailEnd != null && this.lineBill.getEndStation().getName().equals(laseRowdetailEnd.getEndStation().getName()))) {
                throw new TaskExternalException(DeliveryLineDataImport.getResource(ctx, "startEndStationNotMatch"));
            }
        }
        return this.lineBill;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeliveryLineInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        this.lineBill = new DeliveryLineInfo();
        Object number = ((DataToken)lineData.get((Object)"lineNumber")).data;
        if (number == null || number.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "NumberNotNull"));
        this.lineBill.setNumber(number.toString().trim());
        String existId = this.getIdFromNumber(number.toString().trim(), ctx);
        if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
            throw new TaskExternalException(number.toString().trim() + DtDataImportUtils.getWarehsManageResource(ctx, "EXISTS"));
        }
        Object name = ((DataToken)lineData.get((Object)"lineName")).data;
        if (name == null || name.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "DeliveLineNameNotNull"));
        this.lineBill.setName(name.toString());
        String existId2 = this.getIdFromName(name.toString().trim(), ctx);
        if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId2)) {
            throw new TaskExternalException(name.toString().trim() + DtDataImportUtils.getWarehsManageResource(ctx, "EXISTS"));
        }
        try {
            Object totalMileageData;
            Object beginStationData = ((DataToken)lineData.get((Object)"beginStation")).data;
            AddressInfo addInfo = null;
            if (beginStationData == null || beginStationData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "BeginStationNotNull"));
            IAddress iadd = AddressFactory.getLocalInstance((Context)ctx);
            AddressCollection acollection = iadd.getAddressCollection(DtDataImportUtils.getFilter(beginStationData.toString().trim()));
            if (acollection == null || acollection.size() <= 0) {
                throw new TaskExternalException(beginStationData.toString() + " " + DtDataImportUtils.getDTDataImportResource(ctx, "BeginStationNotExists"));
            }
            addInfo = acollection.get(0);
            this.lineBill.setBeginStation(addInfo);
            Object endStationData = ((DataToken)lineData.get((Object)"endStation")).data;
            if (endStationData == null || endStationData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "EndStationNotNull"));
            addInfo = null;
            IAddress iadd2 = AddressFactory.getLocalInstance((Context)ctx);
            AddressCollection acollection2 = iadd2.getAddressCollection(DtDataImportUtils.getFilter(endStationData.toString().trim()));
            if (acollection2 == null || acollection2.size() <= 0) throw new TaskExternalException(endStationData.toString() + " " + DtDataImportUtils.getDTDataImportResource(ctx, "EndStationNotExists"));
            addInfo = acollection2.get(0);
            if (this.lineBill.getBeginStation() != null && addInfo != null && this.lineBill.getBeginStation().equals((Object)addInfo)) {
                throw new TaskExternalException(DeliveryLineClientUtils.getResource((String)"startStationEqualsEndStation"));
            }
            this.lineBill.setEndStation(addInfo);
            Object defaultTranTypeData = ((DataToken)lineData.get((Object)"defaultTranType")).data;
            if (defaultTranTypeData == null || defaultTranTypeData.toString().trim().length() <= 0) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "TransportTypeNotNull"));
            }
            TransportTypeEnum transportType = DtDataImportUtils.getTransportTypeEnum(defaultTranTypeData.toString().trim(), ctx);
            this.lineBill.setDefaultTranType(transportType);
            Object defaultCarrierData = ((DataToken)lineData.get((Object)"defaultCarrier")).data;
            if (defaultCarrierData != null && defaultCarrierData.toString().trim().length() > 0) {
                SupplierInfo sInfo = null;
                ISupplier isupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierCollection scollection = isupplier.getSupplierCollection(DtDataImportUtils.getFilter(defaultCarrierData.toString().trim()));
                if (scollection == null || scollection.size() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "CarrierNotNull"));
                sInfo = scollection.get(0);
                if (!sInfo.isIsCarrier()) {
                    throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "IsNotCarrier"));
                }
                this.lineBill.setDefaultCarrier(sInfo);
            }
            if ((totalMileageData = ((DataToken)lineData.get((Object)"totalMileage")).data) == null || totalMileageData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "totalMileageNotNull"));
            try {
                BigDecimal value = new BigDecimal(totalMileageData.toString());
                if (value != null) {
                    if (value.compareTo(ZERO) < 0) {
                        throw new TaskExternalException(value + DtDataImportUtils.getDTDataImportResource(ctx, "totalMileageMustPositive"));
                    }
                    this.lineBill.setTotalMileage(new BigDecimal(totalMileageData.toString().trim()));
                }
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(totalMileageData + DtDataImportUtils.getWarehsManageResource(ctx, "FormatMustBeNumber"));
            }
            Object status = ((DataToken)lineData.get((Object)"status")).data;
            if (status == null || status.toString().trim().length() <= 0) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "StatusNotNull"));
            }
            BillStatusEnum billStatus = DtDataImportUtils.getStatusEnum(status.toString(), ctx);
            this.lineBill.setStatus(billStatus);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.lineBill.setCreator(userInfo);
        Date d = new Date();
        this.lineBill.setCreateTime(new Timestamp(d.getTime()));
        return this.lineBill;
    }

    /*
     * Unable to fully structure code
     */
    private DeliveryLineEntryInfo transmitEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null) {
            return null;
        }
        entryInfo = new DeliveryLineEntryInfo();
        hasEntry = false;
        errorBuffer = new StringBuffer();
        try {
            detailTranTypeData = ((DataToken)hsData.get((Object)"detailTranType")).data;
            if (detailTranTypeData != null && detailTranTypeData.toString().trim().length() > 0) {
                hasEntry = true;
                transportType = DtDataImportUtils.getTransportTypeEnum(detailTranTypeData.toString().trim(), ctx);
                entryInfo.setDetailTranType(transportType);
            } else {
                errorBuffer.append(DtDataImportUtils.getDTDataImportResource(ctx, "TransportTypeNotNull"));
            }
            detailCarrierData = ((DataToken)hsData.get((Object)"detailCarrier")).data;
            if (detailCarrierData != null && detailCarrierData.toString().trim().length() > 0) {
                sInfo = null;
                isupplier = null;
                isupplier = SupplierFactory.getLocalInstance((Context)ctx);
                scollection = null;
                scollection = isupplier.getSupplierCollection(DtDataImportUtils.getFilter(detailCarrierData.toString().trim()));
                if (scollection != null && scollection.size() > 0) {
                    sInfo = scollection.get(0);
                    entryInfo.setDetailCarrier(sInfo);
                } else {
                    errorBuffer.append(" " + DtDataImportUtils.getDTDataImportResource(ctx, "CarrierNotNull"));
                }
            }
            if ((detailMileageData = ((DataToken)hsData.get((Object)"detailMileage")).data) != null && detailMileageData.toString().trim().length() > 0) {
                hasEntry = true;
                try {
                    value = new BigDecimal(detailMileageData.toString());
                    if (value == null) ** GOTO lbl42
                    if (value.compareTo(DeliveryLineDataImport.ZERO) < 0) {
                        throw new TaskExternalException(value + DtDataImportUtils.getDTDataImportResource(ctx, "DetailMileageMustPositive"));
                    }
                    entryInfo.setDetailMileage(new BigDecimal(detailMileageData.toString().trim()));
                }
                catch (NumberFormatException nex) {
                    Logger.error((Throwable)nex);
                    throw new TaskExternalException(detailMileageData + DtDataImportUtils.getWarehsManageResource(ctx, "FormatMustBeNumber"));
                }
            } else {
                errorBuffer.append(" " + DtDataImportUtils.getDTDataImportResource(ctx, "DetailMileageNotNull"));
            }
lbl42:
            // 3 sources

            detailLineData = ((DataToken)hsData.get((Object)"detailLine")).data;
            if (detailLineData != null && detailLineData.toString().trim().length() > 0) {
                hasEntry = true;
                deliverinfo = null;
                idelivery = DeliveryLineFactory.getLocalInstance(ctx);
                dcollection = null;
                dcollection = idelivery.getDeliveryLineCollection(DtDataImportUtils.getFilter(detailLineData.toString().trim()));
                if (dcollection != null && dcollection.size() > 0) {
                    deliverinfo = dcollection.get(0);
                    if (!BillStatusEnum.enable.equals((Object)deliverinfo.getStatus())) {
                        errorBuffer.append(" " + DtDataImportUtils.getDTDataImportResource(ctx, "DetailLineIsNotEnable"));
                    }
                    entryInfo.setDetailLine(deliverinfo);
                } else {
                    errorBuffer.append(" " + DtDataImportUtils.getDTDataImportResource(ctx, "DetailDeliverLineNotExists"));
                }
            } else {
                errorBuffer.append(" " + DtDataImportUtils.getDTDataImportResource(ctx, "DetailDeliverLineNotExists"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (hasEntry && errorBuffer != null && errorBuffer.toString().trim().length() > 0) {
            throw new TaskExternalException(errorBuffer.toString());
        }
        if (!hasEntry) {
            entryInfo = null;
        }
        return entryInfo;
    }

    private boolean isMaterialUsedCodingRule(Context ctx, String orgId) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        DeliveryLineInfo info = new DeliveryLineInfo();
        return iCodingRuleManager.isExist((IObjectValue)info, orgId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNumberByCodingRule(Context ctx, IObjectValue caller) throws BOSException, CodingRuleException, EASBizException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = iCodingRuleManager.getCurrentAppOUID(caller);
        if (!this.isMaterialUsedCodingRule(ctx, orgId)) throw new SCMBillException(SCMBillException.NOCORDRULE);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (!iCodingRuleManager.isExist(caller, orgId)) throw new SCMBillException(SCMBillException.NOCORDRULE);
        if (!iCodingRuleManager.isUseIntermitNumber(caller, orgId)) return iCodingRuleManager.getNumber(caller, orgId);
        return iCodingRuleManager.readNumber(caller, orgId);
    }

    private boolean isOkEntryItem(DeliveryLineInfo lineInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        block8: {
            boolean flag = false;
            Object beginStationData = ((DataToken)hsData.get((Object)"detailBegin")).data;
            try {
                AddressInfo addInfo = null;
                if (beginStationData != null && beginStationData.toString().trim().length() > 0) {
                    IAddress iadd = AddressFactory.getLocalInstance((Context)ctx);
                    AddressCollection acollection = iadd.getAddressCollection(DtDataImportUtils.getFilter(beginStationData.toString().trim()));
                    if (acollection == null || acollection.size() <= 0) {
                        throw new TaskExternalException(beginStationData.toString() + " " + DtDataImportUtils.getDTDataImportResource(ctx, "BeginStationNotExists"));
                    }
                    addInfo = acollection.get(0);
                } else {
                    throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "BeginStationNotNull"));
                }
                lineInfo.setBeginStation(addInfo);
                flag = true;
                Object endStationData = ((DataToken)hsData.get((Object)"detailEnd")).data;
                if (endStationData != null && endStationData.toString().trim().length() > 0) {
                    addInfo = null;
                    IAddress iadd = AddressFactory.getLocalInstance((Context)ctx);
                    AddressCollection acollection = iadd.getAddressCollection(DtDataImportUtils.getFilter(endStationData.toString().trim()));
                    if (acollection == null || acollection.size() <= 0) {
                        throw new TaskExternalException(endStationData.toString() + " " + DtDataImportUtils.getDTDataImportResource(ctx, "EndStationNotExists"));
                    }
                    addInfo = acollection.get(0);
                    lineInfo.setEndStation(addInfo);
                    if (flag) {
                        return true;
                    }
                    break block8;
                }
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "EndStationNotNull"));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        return false;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof DataBaseInfo)) {
            return;
        }
        try {
            DeliveryLineInfo bill = (DeliveryLineInfo)coreBaseInfo;
            String id = this.getIdFromNumber(bill.getNumber(), ctx);
            if (StringUtil.isEmptyString((String)id)) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                coreBaseInfo.setId(BOSUuid.read((String)id));
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(id), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DeliveryLineFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        DeliveryLineCollection collection;
        try {
            collection = DeliveryLineFactory.getLocalInstance(ctx).getDeliveryLineCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    private String getIdFromName(String name, Context ctx) throws TaskExternalException {
        DeliveryLineCollection collection;
        try {
            collection = DeliveryLineFactory.getLocalInstance(ctx).getDeliveryLineCollection("where name ='" + name + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && (currentNumber.data == null || currentNumber.data.toString().length() == 0 || firstNumber.data.equals(currentNumber.data));
    }

    public String getMainField() {
        return "lineNumber";
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.dt.app.DeliveryLineQuery";
    }

    public static String getResource(Context ctx, String strKey) {
        if (StringUtil.isEmptyString((String)strKey)) {
            return null;
        }
        return SCMUtils.getResource((String)DELIVERYLINE_RESOURCE, (String)strKey, (Context)ctx);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"lineNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"lineName", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"beginStation", (Object)rs.getString("beginStation.number"));
            DataImportTools.putToHashtable(result, (Object)"endStation", (Object)rs.getString("endStation.number"));
            DataImportTools.putToHashtable(result, (Object)"defaultTranType", (Object)((Object)TransportTypeEnum.getEnum(rs.getInt("defaultTranType"))));
            DataImportTools.putToHashtable(result, (Object)"defaultCarrier", (Object)rs.getString("defaultCarrier.number"));
            DataImportTools.putToHashtable(result, (Object)"totalMileage", (Object)rs.getString("totalMileage"));
            DataImportTools.putToHashtable(result, (Object)"status", (Object)((Object)BillStatusEnum.getEnum(rs.getInt("status"))));
            DataImportTools.putToHashtable(result, (Object)"detailLine", (Object)rs.getString("detailLine.number"));
            DataImportTools.putToHashtable(result, (Object)"detailBegin", (Object)rs.getString("beginStation1.number"));
            DataImportTools.putToHashtable(result, (Object)"detailEnd", (Object)rs.getString("endStation1.number"));
            DataImportTools.putToHashtable(result, (Object)"detailTranType", (Object)((Object)TransportTypeEnum.getEnum(rs.getInt("entry.detailTranType"))));
            DataImportTools.putToHashtable(result, (Object)"detailCarrier", (Object)rs.getString("detailCarrier.number"));
            DataImportTools.putToHashtable(result, (Object)"detailMileage", (Object)rs.getBigDecimal("entry.detailMileage"));
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtil.isEmptyString((String)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        return oldFilterInfo;
    }
}

