/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.CarrierCollection;
import com.kingdee.eas.scm.im.dt.CarrierFactory;
import com.kingdee.eas.scm.im.dt.CarrierInfo;
import com.kingdee.eas.scm.im.dt.DeliveryLineCollection;
import com.kingdee.eas.scm.im.dt.DeliveryLineFactory;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.FeeLimitCollection;
import com.kingdee.eas.scm.im.dt.FeeLimitEntryInfo;
import com.kingdee.eas.scm.im.dt.FeeLimitFactory;
import com.kingdee.eas.scm.im.dt.FeeLimitInfo;
import com.kingdee.eas.scm.im.dt.ICarrier;
import com.kingdee.eas.scm.im.dt.IDeliveryLine;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.app.DtDataImportUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class FeeLimitDataImport
extends AbstractDataTransmission {
    private static final String[] DATE_BILL_PROPERTY = new String[]{"beginDate", "endDate"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private FeeLimitInfo info = null;
    private Map<String, CarrierInfo> carrierInfoCache = new HashMap<String, CarrierInfo>();

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.info = null;
        int keyCursor = 0;
        StringBuffer entryIds4CheckDup = new StringBuffer();
        HashMap<String, Integer> lineEntryMap = new HashMap<String, Integer>();
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (keyCursor == 0) {
                this.info = this.transmitHead(lineData, ctx);
                if (this.info == null) {
                    return null;
                }
            }
            FeeLimitEntryInfo entry = this.transmitEntry(lineData, ctx);
            int seq = this.info.getEntry().size() + 1;
            entry.setSeq(seq);
            entry.setParent(this.info);
            entryIds4CheckDup.setLength(0);
            if (entry.getFeeItem() != null && entry.getFeeItem().getId() != null && entry.getFeeItem().getId().toString().length() > 0) {
                entryIds4CheckDup.append(entry.getFeeItem().toString());
            }
            if (entry.getDeliveryLine() != null && entry.getDeliveryLine().getId() != null && entry.getDeliveryLine().getId().toString().length() > 0) {
                entryIds4CheckDup.append(entry.getDeliveryLine().getId().toString());
            }
            if (entry.getTransType() != null) {
                entryIds4CheckDup.append(entry.getTransType().getValue());
            }
            if (entry.getUnit() != null && entry.getUnit().getId() != null && entry.getUnit().getId().toString().length() > 0) {
                entryIds4CheckDup.append(entry.getUnit().getId().toString());
            }
            if (entry.getCarrier() != null && entry.getCarrier().getId() != null && entry.getCarrier().getId().toString().length() > 0) {
                entryIds4CheckDup.append(entry.getCarrier().getId().toString());
            }
            if (lineEntryMap.containsKey(entryIds4CheckDup.toString())) {
                throw new TaskExternalException(MessageFormat.format(DtDataImportUtils.getDTDataImportResource(ctx, "REPEAT_ENTRY"), lineEntryMap.get(entryIds4CheckDup.toString()).toString(), new Integer(i + 1).toString()));
            }
            lineEntryMap.put(entryIds4CheckDup.toString(), i + 1);
            this.info.getEntry().add(entry);
            ++keyCursor;
        }
        return this.info;
    }

    private FeeLimitInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        this.info = new FeeLimitInfo();
        Object number = ((DataToken)lineData.get((Object)"number")).data;
        if (number != null && number.toString().trim().length() > 0) {
            this.info.setNumber(number.toString().trim());
            String existId = this.getIdFromNumber(number.toString().trim(), ctx);
            if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                throw new TaskExternalException(number.toString().trim() + DtDataImportUtils.getWarehsManageResource(ctx, "EXISTS"));
            }
        } else {
            throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "NumberNotNull"));
        }
        Object name = ((DataToken)lineData.get((Object)"name")).data;
        if (name == null || name.toString().trim().length() <= 0) {
            throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "NameNotNull"));
        }
        this.info.setName(name.toString());
        try {
            TransportOrgUnitInfo torg;
            Object transportOrgData = ((DataToken)lineData.get((Object)"transportOrg")).data;
            if (transportOrgData != null && transportOrgData.toString().trim().length() > 0) {
                ITransportOrgUnit itrans = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection tcollection = itrans.getTransportOrgUnitCollection(DtDataImportUtils.getFilter(transportOrgData.toString().trim()));
                torg = null;
                if (tcollection == null || tcollection.size() <= 0) {
                    throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "TransportOrgNotExist"));
                }
                torg = tcollection.get(0);
            } else {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "TransportOrgNotNull"));
            }
            SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(torg.getId()), (String)"feeLimit_addnew");
            this.info.setTransportOrg(torg);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < DATE_BILL_PROPERTY.length; ++i) {
                Object date = ((DataToken)lineData.get((Object)FeeLimitDataImport.DATE_BILL_PROPERTY[i])).data;
                if (date == null || date.toString().length() <= 0) continue;
                try {
                    date = df.parse(date.toString());
                }
                catch (ParseException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(DATE_BILL_PROPERTY[i] + DtDataImportUtils.getWarehsManageResource(ctx, "InvalidDateFormat") + date.toString());
                }
                if (date == null || !(date instanceof Date)) continue;
                this.info.setDate(DATE_BILL_PROPERTY[i], (Date)date);
            }
            if (this.info.getBeginDate() == null) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "BeginDateNotNull"));
            }
            if (this.info.getBeginDate() != null && this.info.getEndDate() != null && this.info.getBeginDate().compareTo(this.info.getEndDate()) >= 0) {
                throw new TaskExternalException(this.info.getBeginDate() + "   " + this.info.getEndDate() + DtDataImportUtils.getDTDataImportResource(ctx, "InvalidBeginEndDate"));
            }
            Object status = ((DataToken)lineData.get((Object)"status")).data;
            if (status == null || status.toString().trim().length() <= 0) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "StatusNotNull"));
            }
            BillStatusEnum billStatus = DtDataImportUtils.getStatusEnum(status.toString(), ctx);
            this.info.setStatus(billStatus);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.info.setCreator(userInfo);
        Date d = new Date();
        this.info.setCreateTime(new Timestamp(d.getTime()));
        return this.info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FeeLimitEntryInfo transmitEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null) {
            return null;
        }
        FeeLimitEntryInfo entryInfo = new FeeLimitEntryInfo();
        try {
            Object pricedQtyData;
            Object detailTranTypeData;
            Object feeItemData;
            Object detailLineData = ((DataToken)hsData.get((Object)"deliveryLine")).data;
            if (detailLineData != null && detailLineData.toString().trim().length() > 0) {
                DeliveryLineInfo deliverinfo = null;
                IDeliveryLine idelivery = DeliveryLineFactory.getLocalInstance(ctx);
                DeliveryLineCollection dcollection = null;
                dcollection = idelivery.getDeliveryLineCollection(DtDataImportUtils.getFilter(detailLineData.toString().trim()));
                if (dcollection == null || dcollection.size() <= 0) {
                    throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "DeliveryLineError"));
                }
                deliverinfo = dcollection.get(0);
                entryInfo.setDeliveryLine(deliverinfo);
            }
            if ((feeItemData = ((DataToken)hsData.get((Object)"feeItem")).data) == null || feeItemData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "FeeItemNotNull"));
            ExpenseTypeInfo itemInfo = null;
            IExpenseType iItem = ExpenseTypeFactory.getLocalInstance((Context)ctx);
            ExpenseTypeCollection ecollection = null;
            ecollection = iItem.getExpenseTypeCollection(DtDataImportUtils.getFilter(feeItemData.toString().trim()));
            if (ecollection == null || ecollection.size() <= 0) {
                throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "FeeItemError"));
            }
            itemInfo = ecollection.get(0);
            entryInfo.setFeeItem(itemInfo);
            Object carrierData = ((DataToken)hsData.get((Object)"carrier")).data;
            if (carrierData != null && carrierData.toString().trim().length() > 0) {
                CarrierInfo carrierInfo = null;
                SupplierInfo suppierInfo = null;
                ICarrier iCarrier = CarrierFactory.getLocalInstance(ctx);
                CarrierCollection CarrierCollection2 = null;
                CarrierCollection2 = iCarrier.getCarrierCollection(DtDataImportUtils.getFilter(carrierData.toString().trim()));
                if (CarrierCollection2 != null && CarrierCollection2.size() > 0) {
                    carrierInfo = CarrierCollection2.get(0);
                    suppierInfo = carrierInfo.getSupplier();
                    entryInfo.setCarrier(suppierInfo);
                }
            }
            if ((detailTranTypeData = ((DataToken)hsData.get((Object)"transType")).data) != null && detailTranTypeData.toString().trim().length() > 0) {
                TransportTypeEnum transportType = DtDataImportUtils.getTransportTypeEnum(detailTranTypeData.toString().trim(), ctx);
                entryInfo.setTransType(transportType);
            }
            if ((pricedQtyData = ((DataToken)hsData.get((Object)"pricedQty")).data) == null || pricedQtyData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "PricedQtyNotNull"));
            try {
                BigDecimal value = new BigDecimal(pricedQtyData.toString());
                if (value != null && value.compareTo(ZERO) <= 0) {
                    throw new TaskExternalException(value + DtDataImportUtils.getDTDataImportResource(ctx, "PricedQtyMustPositive"));
                }
                entryInfo.setPricedQty(new BigDecimal(pricedQtyData.toString().trim()).setScale(0, 4));
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(pricedQtyData + DtDataImportUtils.getWarehsManageResource(ctx, "FormatMustBeNumber"));
            }
            Object data = ((DataToken)hsData.get((Object)"unit")).data;
            if (data == null) throw new TaskExternalException(DtDataImportUtils.getWarehsManageResource(ctx, "unitIsNull"));
            String number = data.toString();
            if (number == null || number.trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getWarehsManageResource(ctx, "unitIsNull"));
            IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitCollection collection = imu.getMeasureUnitCollection(DtDataImportUtils.getFilter(number));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + DtDataImportUtils.getWarehsManageResource(ctx, "UnitNotExists"));
            MeasureUnitInfo info = collection.get(0);
            if (info == null) {
                throw new TaskExternalException(data.toString() + " " + DtDataImportUtils.getWarehsManageResource(ctx, "UnitNotExists"));
            }
            entryInfo.setUnit(info);
            Object priceData = ((DataToken)hsData.get((Object)"price")).data;
            if (priceData == null || priceData.toString().trim().length() <= 0) throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "PriceNotNull"));
            try {
                BigDecimal value = new BigDecimal(priceData.toString());
                if (value != null && value.compareTo(ZERO) <= 0) {
                    throw new TaskExternalException(value + DtDataImportUtils.getDTDataImportResource(ctx, "PriceMustPositive"));
                }
                entryInfo.setPrice(new BigDecimal(priceData.toString().trim()).setScale(6, 4));
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(priceData + DtDataImportUtils.getWarehsManageResource(ctx, "FormatMustBeNumber"));
            }
            Object remarkData = ((DataToken)hsData.get((Object)"remark")).data;
            if (remarkData == null || remarkData.toString().trim().length() <= 0) return entryInfo;
            if (remarkData.toString().trim().length() > 200) {
                remarkData = remarkData.toString().trim().substring(0, 200);
            }
            entryInfo.setRemark(remarkData.toString());
            return entryInfo;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + DtDataImportUtils.getWarehsManageResource(ctx, "UnitNotExists"));
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof DataBaseInfo)) {
            return;
        }
        try {
            FeeLimitInfo bill = (FeeLimitInfo)coreBaseInfo;
            String id = this.getIdFromNumber(bill.getNumber(), ctx);
            if (StringUtil.isEmptyString((String)id)) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                coreBaseInfo.setId(BOSUuid.read((String)id));
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(id), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FeeLimitFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        FeeLimitCollection collection;
        try {
            collection = FeeLimitFactory.getLocalInstance(ctx).getFeeLimitCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    private String getIdFromName(String name, Context ctx) throws TaskExternalException {
        FeeLimitCollection collection;
        try {
            collection = FeeLimitFactory.getLocalInstance(ctx).getFeeLimitCollection("where name ='" + name + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && (currentNumber.data == null || currentNumber.data.toString().length() == 0 || firstNumber.data.equals(currentNumber.data));
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.dt.app.FeeLimitQuery";
    }

    public String getMainField() {
        return "number";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"number", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"name", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"transportOrg", (Object)rs.getString("transportOrg.number"));
            DataImportTools.putToHashtable(result, (Object)"beginDate", (Object)rs.getString("beginDate"));
            DataImportTools.putToHashtable(result, (Object)"endDate", (Object)rs.getString("endDate"));
            DataImportTools.putToHashtable(result, (Object)"status", (Object)((Object)BillStatusEnum.getEnum(rs.getInt("status"))));
            DataImportTools.putToHashtable(result, (Object)"feeItem", (Object)rs.getString("feeItem.number"));
            String supplierId = rs.getString("carrier.id");
            String transportOrgId = rs.getString("transportOrg.id");
            CarrierInfo carrierInfo = this.getCarrierInfoBySupplierAndTransport(ctx, supplierId, transportOrgId);
            DataImportTools.putToHashtable(result, (Object)"carrier", (Object)carrierInfo.getNumber());
            DataImportTools.putToHashtable(result, (Object)"deliveryLine", (Object)rs.getString("deliveryLine.number"));
            DataImportTools.putToHashtable(result, (Object)"transType", (Object)((Object)TransportTypeEnum.getEnum(rs.getInt("entry.transType"))));
            DataImportTools.putToHashtable(result, (Object)"pricedQty", (Object)rs.getBigDecimal("entry.pricedQty"));
            DataImportTools.putToHashtable(result, (Object)"unit", (Object)rs.getString("unit.number"));
            DataImportTools.putToHashtable(result, (Object)"price", (Object)rs.getBigDecimal("entry.price"));
            DataImportTools.putToHashtable(result, (Object)"remark", (Object)rs.getString("entry.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private CarrierInfo getCarrierInfoBySupplierAndTransport(Context ctx, String supplierId, String transportOrgId) throws BOSException {
        CarrierInfo carrierInfo = null;
        if (!StringUtil.isEmptyString((String)supplierId) && !StringUtil.isEmptyString((String)transportOrgId)) {
            String key = supplierId + transportOrgId;
            if (this.carrierInfoCache.containsKey(key)) {
                carrierInfo = this.carrierInfoCache.get(key);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("number"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("transport.id", (Object)transportOrgId, CompareType.EQUALS));
                view.setFilter(filterInfo);
                CarrierCollection carrierCollection = CarrierFactory.getLocalInstance(ctx).getCarrierCollection(view);
                if (carrierCollection != null && carrierCollection.size() > 0) {
                    carrierInfo = carrierCollection.get(0);
                }
                if (carrierInfo != null) {
                    this.carrierInfoCache.put(key, carrierInfo);
                }
            }
        }
        if (carrierInfo == null) {
            carrierInfo = new CarrierInfo();
        }
        return carrierInfo;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtil.isEmptyString((String)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        return oldFilterInfo;
    }
}

