/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.dt.FeeLimitEntryInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractFeeLimitEntryControllerBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FeeLimitEntryControllerBean
extends AbstractFeeLimitEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.dt.app.FeeLimitEntryControllerBean");

    @Override
    protected IObjectValue _getFeeLimitPrice(Context ctx, String touID, String feeItemID, String deliveryLineID, String unitID, String carriesID, String bizDate) throws BOSException, EASBizException {
        FeeLimitEntryInfo entry = null;
        entry = this.getFeeLimitPriceByCarries(ctx, touID, feeItemID, deliveryLineID, unitID, carriesID, bizDate);
        if (entry == null) {
            entry = this.getFeeLimitPriceByCarries(ctx, touID, feeItemID, null, unitID, carriesID, bizDate);
        }
        if (entry == null) {
            entry = this.getFeeLimitPriceByCarries(ctx, touID, feeItemID, deliveryLineID, unitID, null, bizDate);
        }
        if (entry == null) {
            entry = this.getFeeLimitPriceByCarries(ctx, touID, feeItemID, null, unitID, null, bizDate);
        }
        return entry;
    }

    private FeeLimitEntryInfo getFeeLimitPriceByCarries(Context ctx, String touID, String feeItemID, String deliveryLineID, String unitID, String carriesID, String bizDate) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            FeeLimitEntryInfo feeLimitEntryInfo;
            if (StringUtils.isEmpty((String)touID) || StringUtils.isEmpty((String)feeItemID)) {
                return null;
            }
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT TOP 1 ");
                sql.append(" head.FID AS HeadID,");
                sql.append(" head.FTransportOrgID AS FTransportOrgID,");
                sql.append(" head.FBeginDate AS FBeginDate,");
                sql.append(" head.FEndDate AS FEndDate,");
                sql.append(" head.FStatus AS FStatus,");
                sql.append(" head.FEffectDate AS FEffectDate,");
                sql.append(" entry.FID AS EntryID,");
                sql.append(" entry.FFeeItemID AS FFeeItemID,");
                sql.append(" entry.FDeliveryLineID AS FDeliveryLineID,");
                sql.append(" entry.FUnitID AS FUnitID,");
                sql.append(" unit.FNumber AS FUnitNumber,");
                sql.append(" unit.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " AS FUnitName,");
                sql.append(" entry.FPrice AS FPrice,");
                sql.append(" entry.FPricedQty AS FPricedQty");
                sql.append(" FROM T_DT_FeeLimit head INNER JOIN T_DT_FeeLimitEntry entry ON head.FID = entry.FParentID");
                sql.append(" INNER JOIN T_BD_MeasureUnit unit ON entry.FUnitID = unit.FID");
                sql.append(" WHERE head.FTransportOrgID = ? AND entry.FFeeItemID = ? ");
                sql.append(" AND head.FStatus = ? ");
                sql.append(" AND ( to_char(head.FBeginDate,'YYYY-MM-DD') <=  '" + bizDate + "')");
                sql.append(" AND ( to_char(head.FEndDate,'YYYY-MM-DD') >=  '" + bizDate + "' OR head.FEndDate IS NULL) ");
                if (StringUtils.isEmpty((String)deliveryLineID)) {
                    sql.append(" AND entry.FDeliveryLineID IS NULL");
                } else {
                    sql.append(" AND entry.FDeliveryLineID = ?");
                }
                if (!StringUtils.isEmpty((String)unitID)) {
                    sql.append(" AND entry.FUnitID = ?");
                }
                if (!StringUtils.isEmpty((String)carriesID)) {
                    sql.append(" AND entry.FCarrierID = '").append(carriesID).append("'");
                } else {
                    sql.append(" AND entry.FCarrierID is null ");
                }
                sql.append(" ORDER BY ABS(DAYOFYEAR(head.fbegindate) - DAYOFYEAR(NOW())) ASC, ");
                sql.append(" head.FBeginDate DESC, head.FEffectDate DESC");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, touID);
                stmt.setString(2, feeItemID);
                stmt.setInt(3, 2);
                if (!StringUtils.isEmpty((String)deliveryLineID)) {
                    stmt.setString(4, deliveryLineID);
                }
                if (!StringUtils.isEmpty((String)unitID)) {
                    if (StringUtils.isEmpty((String)deliveryLineID)) {
                        stmt.setString(4, unitID);
                    } else {
                        stmt.setString(5, unitID);
                    }
                }
                if (!(rs = stmt.executeQuery()).next()) break block14;
                FeeLimitEntryInfo entry = new FeeLimitEntryInfo();
                MeasureUnitInfo unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                unit.setNumber(rs.getString("FUnitNumber"));
                unit.setName(rs.getString("FUnitName"));
                entry.setUnit(unit);
                BigDecimal price = rs.getBigDecimal("FPrice");
                entry.setPrice(price);
                feeLimitEntryInfo = entry;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return feeLimitEntryInfo;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }
}

