/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.DtBillBaseInfo;
import com.kingdee.eas.scm.im.dt.LogisticsFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.LogisticsFeeInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractLogisticsFeeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class LogisticsFeeControllerBean
extends AbstractLogisticsFeeControllerBean {
    private static final long serialVersionUID = -206832504918744537L;

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        LogisticsFeeInfo info = (LogisticsFeeInfo)model;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            LogisticsFeeEntryInfo entry = info.getEntry().get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        super._passAudit(ctx, pk, model);
    }

    @Override
    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String mainTable = this.getMainTableName(ctx, model);
        if (mainTable == null) {
            throw new BOSException("main table name is null!");
        }
        String detailTable = this.getDetailTableName(ctx, model);
        if (detailTable == null) {
            throw new BOSException("detail table name is null!");
        }
        DtBillBaseInfo dtBill = (DtBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement stmtHead = null;
        PreparedStatement stmtEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(mainTable);
            sql.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? WHERE FID = ? ");
            stmtHead = conn.prepareStatement(sql.toString());
            Date now = new Date();
            stmtHead.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            stmtHead.setString(2, aUserInfo.getId().toString());
            stmtHead.setInt(3, 4);
            stmtHead.setString(4, dtBill.getId().toString());
            stmtHead.execute();
            sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(detailTable);
            sql.append(" SET FAssociateQty = FBalanceQty, FBaseStatus = ? WHERE FParentID = ? ");
            stmtEntry = conn.prepareStatement(sql.toString());
            stmtEntry.setInt(1, 4);
            stmtEntry.setString(2, dtBill.getId().toString());
            stmtEntry.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtHead);
                SQLUtils.cleanup(stmtEntry, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtHead);
        SQLUtils.cleanup((Statement)stmtEntry, (Connection)conn);
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LogisticsFeeInfo info = (LogisticsFeeInfo)model;
        info.setBillType(SCMServerUtils.getBillType((String)"emdfS9tk/UGnMuPbpL799kY+1VI="));
        if (info.getEntry() == null) {
            return;
        }
    }

    @Override
    protected String[] getEntryDecimalFields() {
        return new String[]{"qty", "baseQty", "assistQty", "balanceQty", "associateQty", "ratingPrice", "ratingAmt", "balancePrice", "balanceAmt", "totalApQty", "totalApAmt"};
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LogisticsFeeInfo info = (LogisticsFeeInfo)model;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            LogisticsFeeEntryInfo entry = info.getEntry().get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LogisticsFeeInfo info = (LogisticsFeeInfo)model;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            LogisticsFeeEntryInfo entry = info.getEntry().get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, objectValue);
        LogisticsFeeInfo info = (LogisticsFeeInfo)objectValue;
        BOSUuid uuid = info.getCompanyOrgUnit().getBaseCurrency().getId();
        ObjectUuidPK pk = new ObjectUuidPK(uuid);
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk);
        int precision = currencyInfo.getPrecision();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            LogisticsFeeEntryInfo entry = info.getEntry().get(i);
            entry.setRatingAmt(entry.getRatingAmt().setScale(precision, 4));
            entry.setBalanceAmt(entry.getBalanceAmt().setScale(precision, 4));
        }
        this.save(ctx, (CoreBaseInfo)info);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        LogisticsFeeInfo purContractInfo = (LogisticsFeeInfo)this.getValue(ctx, (IObjectPK)pk);
        this.submit(ctx, (CoreBaseInfo)purContractInfo);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

