/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.ITransactionInvUpdateType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.AbstractInvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractInvStateAdjustBillEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractMatAttrChangeBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillEntryCollection;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillFactory;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillFactory;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InvCommonUtils {
    private static HashMap invBillNotoNametableMap = new HashMap();
    private static InvCommonUtils inst = null;
    private static Map<String, SCMBillBaseInfo> billInfoMap = new HashMap<String, SCMBillBaseInfo>();
    private static Map<String, CompanyOrgUnitInfo> companyCache = new HashMap<String, CompanyOrgUnitInfo>();

    private static String getNamebyBillTableName(String billTableName) {
        StringBuffer billName = new StringBuffer();
        return billName.append(billTableName.substring(billTableName.lastIndexOf("_") + 1)).toString();
    }

    private static String[] makeupBillNameTableList(String billName, String entryName) {
        String[] billNameTableList = new String[]{InvCommonUtils.getNamebyBillTableName(billName), InvCommonUtils.getNamebyBillTableName(entryName), billName, entryName};
        return billNameTableList;
    }

    private static void putBillInformation2Map(String billTypeNo, String billName, String entryName) {
        invBillNotoNametableMap.put(billTypeNo.trim(), InvCommonUtils.makeupBillNameTableList(billName, entryName));
    }

    public static String getBillTableName(String billTypeNO) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billTypeNO == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_NUMBER_NOTRIGHT);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billTypeNO);
        if (tableInfo != null) {
            return tableInfo[2];
        }
        return null;
    }

    public static String getBillEntryTableName(String billTypeNO) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billTypeNO == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_NUMBER_NOTRIGHT);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billTypeNO);
        return tableInfo[3];
    }

    public static String getBillTableNameFromBillTypeID(String billTypeID) throws BOSException, EASBizException {
        return InvCommonUtils.getBillTableName(SCMUtils.getBillTypeNOFormBillTypeID((String)billTypeID));
    }

    public static String getBillEntryTableNameFromBillTypeID(String billTypeID) throws BOSException, EASBizException {
        return InvCommonUtils.getBillEntryTableName(SCMUtils.getBillTypeNOFormBillTypeID((String)billTypeID));
    }

    public static String getBillTableNameFromBillType(BillTypeInfo billTypeID) throws BOSException, EASBizException {
        return InvCommonUtils.getBillTableName(SCMUtils.getBillTypeNOFormBillTypeID((String)billTypeID.getId().toString()));
    }

    public static String getBillEntryTableNameFromBillType(BillTypeInfo billTypeID) throws BOSException, EASBizException {
        return InvCommonUtils.getBillEntryTableName(SCMUtils.getBillTypeNOFormBillTypeID((String)billTypeID.getId().toString()));
    }

    public static String getBillName(String billTypeNO) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billTypeNO == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_NUMBER_NOTRIGHT);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billTypeNO);
        return tableInfo[0];
    }

    public static String getBillEntryName(String billTypeNO) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billTypeNO == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_NUMBER_NOTRIGHT);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billTypeNO);
        return tableInfo[1];
    }

    public static String getBillTableName(BillTypeInfo billType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billType == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billType.getNumber());
        return tableInfo[2];
    }

    public static String getBillEntryTableName(BillTypeInfo billType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billType == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billType.getNumber());
        return tableInfo[3];
    }

    public static String getBillName(BillTypeInfo billType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billType == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billType.getNumber());
        return tableInfo[0];
    }

    public static String getBillEntryName(BillTypeInfo billType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (billType == null) {
            throw new InvUpdateException(InvUpdateException.IM_BILLTYPE_NUMBER_NOTRIGHT);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(billType.getNumber());
        return tableInfo[1];
    }

    public static String getBillTableName(TransactionTypeInfo transType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (transType == null) {
            throw new InvUpdateException(InvUpdateException.IM_TRANSTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(transType.getBillType().getNumber());
        return tableInfo[2];
    }

    public static String getBillEntryTableName(TransactionTypeInfo transType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (transType == null) {
            throw new InvUpdateException(InvUpdateException.IM_TRANSTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(transType.getBillType().getNumber());
        return tableInfo[3];
    }

    public static String getBillName(TransactionTypeInfo transType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (transType == null) {
            throw new InvUpdateException(InvUpdateException.IM_TRANSTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(transType.getBillType().getNumber());
        return tableInfo[0];
    }

    public static String getBillEntryName(TransactionTypeInfo transType) throws BOSException, EASBizException {
        InvCommonUtils.staticInitial();
        if (transType == null) {
            throw new InvUpdateException(InvUpdateException.IM_TRANSTYPE_ISNULL);
        }
        String[] tableInfo = (String[])invBillNotoNametableMap.get(transType.getBillType().getNumber());
        return tableInfo[1];
    }

    private static void initInvBillTableMap() {
        String billName = null;
        String billEntryName = null;
        String billTypeNO = null;
        if (!invBillNotoNametableMap.isEmpty()) {
            invBillNotoNametableMap.clear();
        }
        billTypeNO = "110";
        billName = "T_IM_InvStateAdjustBill";
        billEntryName = "T_IM_InvStateAdjustBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "101";
        billName = "T_IM_PurReceivalBill";
        billEntryName = "T_IM_PurReceivalEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "102";
        billName = "T_IM_SaleIssueBill";
        billEntryName = "T_IM_SaleIssueEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "103";
        billName = "T_IM_PurInWarehsBill";
        billEntryName = "T_IM_PurInWarehsEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "104";
        billName = "T_IM_MaterialReqBill";
        billEntryName = "T_IM_MaterialReqBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "160";
        billName = "t_im_materialrequestbill";
        billEntryName = "t_im_materialrequestbillentry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "105";
        billName = "T_IM_ManufactureRecBill";
        billEntryName = "T_IM_ManufactureRecBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "106";
        billName = "T_IM_MoveIssueBill";
        billEntryName = "T_IM_MoveIssueBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "107";
        billName = "T_IM_MoveInWarehsBill";
        billEntryName = "T_IM_MoveInWarehsBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "108";
        billName = "T_IM_OtherIssueBill";
        billEntryName = "T_IM_OtherIssueBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "109";
        billName = "T_IM_OtherInWarehsBill";
        billEntryName = "T_IM_OtherInWarehsBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "120";
        billName = "T_IM_MoveLocationBill";
        billEntryName = "T_IM_MoveLocationBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "100";
        billName = "T_IM_InventoryInitBill";
        billEntryName = "T_IM_InventoryInitEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "130";
        billName = "T_IM_DecomposeBill";
        billEntryName = "T_IM_DecomposeEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "410";
        billName = "T_CL_CostAdjustBill";
        billEntryName = "T_CL_CostAdjustBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "420";
        billName = "T_CL_StandardCostAdjBill";
        billEntryName = "T_CL_StandardCostAdjEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "330";
        billName = "T_AR_Otherbill";
        billEntryName = "T_AR_Otherbillentry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "230";
        billName = "T_AP_Otherbill";
        billEntryName = "T_AP_Otherbillentry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "210";
        billName = "T_SM_PurRequest";
        billEntryName = "T_SM_PurRequestEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "220";
        billName = "T_SM_PurOrder";
        billEntryName = "T_SM_PurOrderEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "310";
        billName = "T_SD_SaleOrder";
        billEntryName = "T_SD_SaleOrderEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "320";
        billName = "T_SD_PostRequisition";
        billEntryName = "T_SD_PostRequisitionEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "140";
        billName = "T_IM_StockTransferBill";
        billEntryName = "T_IM_StockTransferBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "150";
        billName = "T_IM_CountingTask";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "250";
        billName = "T_SM_PurReturns";
        billEntryName = "T_SM_PurReturnsEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "350";
        billName = "T_SD_PurReturns";
        billEntryName = "T_SD_SaleReturnsEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "901";
        billName = "T_SM_SubContractOrder";
        billEntryName = "T_SM_SubContractOrderEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "141";
        billName = "T_IM_TransferOrderBill";
        billEntryName = "T_IM_TransferOrderBillEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
        billTypeNO = "121";
        billName = "T_IM_MatAttrChangeBill";
        billEntryName = "T_IM_MatAttrChangeBeforeEntry";
        InvCommonUtils.putBillInformation2Map(billTypeNO, billName, billEntryName);
    }

    public static synchronized void staticInitial() {
        if (inst == null) {
            try {
                InvCommonUtils.initInvBillTableMap();
                inst = new InvCommonUtils();
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static String fmBigDecm(BigDecimal dec) {
        InvCommonUtils.staticInitial();
        String patten = "##,###.##########";
        DecimalFormat df = new DecimalFormat(patten);
        if (dec != null) {
            return df.format(dec);
        }
        return null;
    }

    public boolean isSCMStart(Context ctx) {
        return true;
    }

    public static String getFmtDate(Date date, String fmtStr) {
        SimpleDateFormat df = new SimpleDateFormat(fmtStr);
        return df.format(date);
    }

    public static String getFmtDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String getFmtDateAndTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static int getNumFromCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int num = cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
        return num;
    }

    public static SelectorItemCollection getTransactionSelectorItemCol() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("isWriteOff"));
        selector.add(new SelectorItemInfo("isManuCostCalculate"));
        selector.add(new SelectorItemInfo("status"));
        selector.add(new SelectorItemInfo("isCalculate"));
        selector.add(new SelectorItemInfo("Scheduled"));
        selector.add(new SelectorItemInfo("cu.id"));
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("billType.number"));
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("billType.billTypeGroup"));
        selector.add(new SelectorItemInfo("billType.Scheduled"));
        selector.add(new SelectorItemInfo("riType.id"));
        selector.add(new SelectorItemInfo("riType.number"));
        selector.add(new SelectorItemInfo("riType.name"));
        selector.add(new SelectorItemInfo("riType.status"));
        selector.add(new SelectorItemInfo("riType.bizDirection"));
        selector.add(new SelectorItemInfo("riType.dataDirection"));
        selector.add(new SelectorItemInfo("rI"));
        return selector;
    }

    public static SelectorItemCollection getTransactionTypeSelectorCollection(boolean isFromBill) {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (isFromBill) {
            selector.add(new SelectorItemInfo("transactionType.id"));
            selector.add(new SelectorItemInfo("transactionType.name"));
            selector.add(new SelectorItemInfo("transactionType.number"));
            selector.add(new SelectorItemInfo("transactionType.isWriteOff"));
            selector.add(new SelectorItemInfo("transactionType.isManuCostCalculate"));
            selector.add(new SelectorItemInfo("transactionType.status"));
            selector.add(new SelectorItemInfo("transactionType.isCalculate"));
            selector.add(new SelectorItemInfo("transactionType.Scheduled"));
            selector.add(new SelectorItemInfo("transactionType.cu.id"));
            selector.add(new SelectorItemInfo("transactionType.billType.id"));
            selector.add(new SelectorItemInfo("transactionType.billType.number"));
            selector.add(new SelectorItemInfo("transactionType.billType.name"));
            selector.add(new SelectorItemInfo("transactionType.billType.billTypeGroup"));
            selector.add(new SelectorItemInfo("transactionType.billType.Scheduled"));
            selector.add(new SelectorItemInfo("transactionType.riType.id"));
            selector.add(new SelectorItemInfo("transactionType.riType.rI"));
            selector.add(new SelectorItemInfo("transactionType.riType.name"));
            selector.add(new SelectorItemInfo("transactionType.riType.number"));
            selector.add(new SelectorItemInfo("transactionType.riType.status"));
            selector.add(new SelectorItemInfo("transactionType.riType.bizDirection"));
            selector.add(new SelectorItemInfo("transactionType.riType.dataDirection"));
            selector.add(new SelectorItemInfo("transactionType.riType.isSysInit"));
            selector.add(new SelectorItemInfo("transactionType.rI"));
        } else {
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("isWriteOff"));
            selector.add(new SelectorItemInfo("isManuCostCalculate"));
            selector.add(new SelectorItemInfo("status"));
            selector.add(new SelectorItemInfo("isCalculate"));
            selector.add(new SelectorItemInfo("Scheduled"));
            selector.add(new SelectorItemInfo("cu.id"));
            selector.add(new SelectorItemInfo("billType.id"));
            selector.add(new SelectorItemInfo("billType.number"));
            selector.add(new SelectorItemInfo("billType.name"));
            selector.add(new SelectorItemInfo("billType.billTypeGroup"));
            selector.add(new SelectorItemInfo("billType.Scheduled"));
            selector.add(new SelectorItemInfo("riType.id"));
            selector.add(new SelectorItemInfo("riType.rI"));
            selector.add(new SelectorItemInfo("riType.name"));
            selector.add(new SelectorItemInfo("riType.number"));
            selector.add(new SelectorItemInfo("riType.status"));
            selector.add(new SelectorItemInfo("riType.bizDirection"));
            selector.add(new SelectorItemInfo("riType.dataDirection"));
            selector.add(new SelectorItemInfo("riType.isSysInit"));
            selector.add(new SelectorItemInfo("rI"));
        }
        return selector;
    }

    public static TransactionTypeInfo getDefaultTransactionType(Context ctx, String billTypeID) throws EASBizException, BOSException {
        CoreBaseCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillType.ID", (Object)billTypeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(InvCommonUtils.getTransactionSelectorItemCol());
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        coll = ctx == null ? TransactionTypeFactory.getRemoteInstance().getCollection(view) : TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (coll != null && coll.size() > 0) {
            return (TransactionTypeInfo)coll.getObject(0);
        }
        return null;
    }

    public static TransactionTypeInfo getDefaultTransactionType(Context ctx, String billTypeID, String bizTypeID) throws EASBizException, BOSException {
        TransactionTypeCollection coll = InvCommonUtils.getDefaultTransactionTypeCol(ctx, billTypeID, bizTypeID);
        HashSet<String> ids = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ids.add(coll.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sif = new SorterItemInfo("scheduled");
        sif.setSortType(SortType.DESCEND);
        SorterItemInfo riType = new SorterItemInfo("riType.bizDirection");
        riType.setSortType(SortType.DESCEND);
        SorterItemInfo number = new SorterItemInfo("number");
        sic.add(sif);
        sic.add(riType);
        sic.add(number);
        view.setSorter(sic);
        view.setSelector(SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("riType", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        ITransactionType itt = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)ctx);
        coll = itt.getTransactionTypeCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            return coll.get(0);
        }
        return null;
    }

    public static TransactionTypeCollection getDefaultTransactionTypeCol(Context ctx, String billTypeID, String bizTypeID) throws EASBizException, BOSException {
        TransactionTypeCollection coll = null;
        coll = ctx == null ? TransactionTypeFactory.getRemoteInstance().getCollection(billTypeID, bizTypeID) : TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(billTypeID, bizTypeID);
        return coll;
    }

    public static TransactionTypeCollection getTransactionTypeColForBOTP(Context ctx, String billTypeID) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        if (!StringUtil.isEmpty((String)billTypeID)) {
            filter.getFilterItems().add(new FilterItemInfo("billtype.id", (Object)billTypeID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        TransactionTypeCollection col = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(view);
        return col;
    }

    public static TransactionTypeCollection getTransactionTypeCollection(Context ctx, String billTypeID, String bizTypeID, EntityViewInfo view) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select trans.fid from t_scm_transactiontype trans inner join t_scm_transbiztype transbiz ").append(" on transbiz.ftransactiontypeid = trans.fid").append(" where transbiz.fbiztypeid = '").append(bizTypeID).append("' and trans.fbilltypeid = '").append(billTypeID).append("' and ").append(" trans.fstatus = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer ids = new StringBuffer();
        try {
            while (rs.next()) {
                ids.append(rs.getString("fid")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        if (ids.length() > 0) {
            FilterInfo filter = view.getFilter();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("riType.id"));
            sic.add(new SelectorItemInfo("riType.bizDirection"));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(sic);
            TransactionTypeCollection col = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(view);
            return col;
        }
        return null;
    }

    public static BizTypeCollection getBizTypeCollection(Context ctx, String billTypeID, EntityViewInfo view) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select biz.fid from t_scm_biztype biz inner join t_scm_billbiztype billbiz on billbiz.fbiztypeid = biz.fid").append(" where billbiz.fbilltypeid = '").append(billTypeID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer ids = new StringBuffer();
        try {
            while (rs.next()) {
                ids.append(rs.getString("fid")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        if (ids.length() > 0) {
            FilterInfo filter = view.getFilter();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            view.setFilter(filter);
            BizTypeCollection bizCol = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeCollection(view);
            return bizCol;
        }
        return null;
    }

    public static TransactionInvUpdateTypeCollection getTransactionInvUpdateTypeCol(Context ctx, EntityViewInfo view) throws EASBizException, BOSException {
        if (null == view) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("invUpdateType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQty"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQtyPre"));
        sic.add(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
        sic.add(new SelectorItemInfo("invUpdateType.scheduled"));
        sic.add(new SelectorItemInfo("invUpdateType.status"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.isForwardAmt"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.isForwardAmt"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.name"));
        sic.add(new SelectorItemInfo("defaults"));
        view.setSelector(sic);
        if (view.getSorter() != null && view.getSorter().size() == 0) {
            SorterItemInfo sortItem = new SorterItemInfo("invUpdateType.number");
            sortItem.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem);
        }
        ITransactionInvUpdateType iInv = null;
        iInv = ctx == null ? TransactionInvUpdateTypeFactory.getRemoteInstance() : TransactionInvUpdateTypeFactory.getLocalInstance((Context)ctx);
        return iInv.getTransactionInvUpdateTypeCollection(view);
    }

    public static InvUpdateTypeInfo getInvUpdateType(Context ctx, String transactionTypeID, String aStoreTypeID, String aStoreStateID) throws EASBizException, BOSException {
        block18: {
            String storeStatePreID;
            String storeTypePreID;
            StoreStateInfo storeStatePre;
            StoreTypeInfo storeTypePre;
            String storeStateID;
            String storeTypeID;
            StoreStateInfo storeState;
            StoreTypeInfo storeType;
            TransactionInvUpdateTypeCollection col;
            block17: {
                if (StringUtil.isEmpty((String)transactionTypeID) || StringUtil.isEmpty((String)aStoreTypeID) || StringUtil.isEmpty((String)aStoreStateID)) {
                    return null;
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)transactionTypeID, CompareType.EQUALS));
                view.setFilter(filterInfo);
                col = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, view);
                ITransactionType iTran = null;
                InvUpdateTypeInfo defaultInvUpdateType = null;
                storeType = null;
                storeState = null;
                storeTypeID = null;
                storeStateID = null;
                storeTypePre = null;
                storeStatePre = null;
                storeTypePreID = null;
                storeStatePreID = null;
                iTran = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)ctx);
                defaultInvUpdateType = iTran.getDefaultInvUpdateType(transactionTypeID);
                if (defaultInvUpdateType == null) break block17;
                storeType = defaultInvUpdateType.getStoreType();
                storeState = defaultInvUpdateType.getStoreState();
                if (storeType != null) {
                    storeTypeID = storeType.getId().toString();
                }
                if (storeState != null) {
                    storeStateID = storeState.getId().toString();
                }
                storeTypePre = defaultInvUpdateType.getStoreTypePre();
                storeStatePre = defaultInvUpdateType.getStoreStatePre();
                if (storeTypePre != null) {
                    storeTypePreID = storeTypePre.getId().toString();
                }
                if (storeStatePre != null) {
                    storeStatePreID = storeStatePre.getId().toString();
                }
                if (aStoreTypeID.equals(storeTypeID) && aStoreStateID.equals(storeStateID) || aStoreTypeID.equals(storeTypePreID) && aStoreStateID.equals(storeStatePreID)) {
                    return defaultInvUpdateType;
                }
                if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) break block18;
                TransactionInvUpdateTypeInfo transactionInvUpdateType = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    transactionInvUpdateType = col.get(i);
                    invUpdateType = transactionInvUpdateType.getInvUpdateType();
                    storeType = invUpdateType.getStoreType();
                    storeState = invUpdateType.getStoreState();
                    if (storeType != null) {
                        storeTypeID = storeType.getId().toString();
                    }
                    if (storeState != null) {
                        storeStateID = storeState.getId().toString();
                    }
                    storeTypePre = invUpdateType.getStoreTypePre();
                    storeStatePre = invUpdateType.getStoreStatePre();
                    if (storeTypePre != null) {
                        storeTypePreID = storeTypePre.getId().toString();
                    }
                    if (storeStatePre != null) {
                        storeStatePreID = storeStatePre.getId().toString();
                    }
                    if ((!aStoreTypeID.equals(storeTypeID) || !aStoreStateID.equals(storeStateID)) && (!aStoreTypeID.equals(storeTypePreID) || !aStoreStateID.equals(storeStatePreID))) continue;
                    return invUpdateType;
                }
                break block18;
            }
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                TransactionInvUpdateTypeInfo transactionInvUpdateType = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    transactionInvUpdateType = col.get(i);
                    invUpdateType = transactionInvUpdateType.getInvUpdateType();
                    storeType = invUpdateType.getStoreType();
                    storeState = invUpdateType.getStoreState();
                    if (storeType != null) {
                        storeTypeID = storeType.getId().toString();
                    }
                    if (storeState != null) {
                        storeStateID = storeState.getId().toString();
                    }
                    storeTypePre = invUpdateType.getStoreTypePre();
                    storeStatePre = invUpdateType.getStoreStatePre();
                    if (storeTypePre != null) {
                        storeTypePreID = storeTypePre.getId().toString();
                    }
                    if (storeStatePre != null) {
                        storeStatePreID = storeStatePre.getId().toString();
                    }
                    if ((!aStoreTypeID.equals(storeTypeID) || !aStoreStateID.equals(storeStateID)) && (!aStoreTypeID.equals(storeTypePreID) || !aStoreStateID.equals(storeStatePreID))) continue;
                    return invUpdateType;
                }
            }
        }
        return null;
    }

    private static ICoreBase getBizInterface(Context ctx, String billTypeID) throws EASBizException, BOSException {
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? PurInWarehsBillFactory.getRemoteInstance() : PurInWarehsBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? PurReceivalBillFactory.getRemoteInstance() : PurReceivalBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? ManufactureRecBillFactory.getRemoteInstance() : ManufactureRecBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? MoveInWarehsBillFactory.getRemoteInstance() : MoveInWarehsBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? OtherInWarehsBillFactory.getRemoteInstance() : OtherInWarehsBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? SaleIssueBillFactory.getRemoteInstance() : SaleIssueBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? MaterialReqBillFactory.getRemoteInstance() : MaterialReqBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? MoveIssueBillFactory.getRemoteInstance() : MoveIssueBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? OtherIssueBillFactory.getRemoteInstance() : OtherIssueBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? MatAttrChangeBillFactory.getRemoteInstance() : MatAttrChangeBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? InvStateAdjustBillFactory.getRemoteInstance() : InvStateAdjustBillFactory.getLocalInstance(ctx);
        }
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            return null == ctx ? StockTransferBillFactory.getRemoteInstance() : StockTransferBillFactory.getLocalInstance(ctx);
        }
        return null;
    }

    public static EntityViewInfo buildInvUpdateTypeEntityView(Context ctx, InvBillBaseInfo info, int index, boolean isF7, CoreBaseCollection sourceBillCollection) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String prefix = "";
        if (!isF7) {
            prefix = "invUpdateType.";
        }
        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "status", (Object)1, CompareType.EQUALS));
        view.setFilter(filterInfo);
        if (info == null || info.getTransactionType() == null || info.getEntries() == null || info.getEntries().getObject(index) == null) {
            return view;
        }
        InvBillBaseEntryInfo entry = null;
        if (info.getEntries().getObject(index) instanceof InvBillBaseEntryInfo) {
            entry = (InvBillBaseEntryInfo)info.getEntries().getObject(index);
        }
        if (entry == null) {
            return view;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)info.getTransactionType().getId().toString(), CompareType.EQUALS));
        String sourceBillID = "";
        String sourceBillEntryID = "";
        String sourceBillTypeID = "";
        String coreBillID = "";
        String coreBillEntryID = "";
        String coreBillTypeID = "";
        sourceBillID = entry.getSourceBillId();
        if (entry.getSourceBillType() != null) {
            sourceBillTypeID = entry.getSourceBillType().getId().toString();
        }
        sourceBillEntryID = entry.getSourceBillEntryId();
        coreBillTypeID = entry.getCoreBillTypeId();
        coreBillID = entry.getCoreBillId();
        coreBillEntryID = entry.getCoreBillEntryId();
        String billID = "";
        String billTypeID = "";
        String billEntryID = "";
        if (SCMBaseCommonUtil.isInvBill((String)sourceBillTypeID)) {
            billID = sourceBillID;
            billTypeID = sourceBillTypeID;
            billEntryID = sourceBillEntryID;
        } else if (SCMBaseCommonUtil.isInvBill((String)coreBillTypeID)) {
            billID = coreBillID;
            billTypeID = coreBillTypeID;
            billEntryID = coreBillEntryID;
        }
        if (StringUtil.isEmpty((String)billID)) {
            view.setFilter(filterInfo);
            return view;
        }
        filterInfo.mergeFilter(InvCommonUtils.getInvUpdateFilterInfo(ctx, info, billID, billTypeID, billEntryID, isF7, sourceBillCollection), "AND");
        view.setFilter(filterInfo);
        return view;
    }

    public static CompanyOrgUnitInfo getCompanyInfoForStorage(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        CompanyOrgUnitInfo ret = companyCache.get(storageOrgUnitID);
        if (ret == null) {
            IOrgUnitRelation iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgUnitID, 4, 1);
            if (ret == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitID, 4, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            companyCache.put(storageOrgUnitID, ret);
        }
        return ret;
    }

    private static SCMBillBaseInfo getBillInfo(String billId, CoreBaseCollection billColl) {
        if (billId != null && !billId.equals("") && billColl != null && billColl.size() > 0) {
            for (int i = 0; i < billColl.size(); ++i) {
                if (!billId.equals(billColl.get(i).get("id").toString())) continue;
                return (SCMBillBaseInfo)billColl.get(i);
            }
        }
        return null;
    }

    private static FilterInfo getInvUpdateFilterInfo(Context ctx, InvBillBaseInfo info, String billID, String billTypeID, String billEntryID, boolean isF7, CoreBaseCollection sourceBillCollection) throws EASBizException, BOSException {
        StringBuffer mask;
        FilterInfo filterInfo;
        block21: {
            SCMBillBaseInfo billInfo;
            String prefix;
            int maskIndex;
            block25: {
                block22: {
                    StoreStateInfo storeStateAfter;
                    StoreTypeInfo storeTypeAfter;
                    StoreStateInfo storeStateBefore;
                    StoreTypeInfo storeTypeBefore;
                    block24: {
                        block23: {
                            block20: {
                                filterInfo = new FilterInfo();
                                mask = new StringBuffer(128);
                                maskIndex = 0;
                                prefix = "";
                                if (!isF7) {
                                    prefix = "invUpdateType.";
                                }
                                AbstractObjectCollection billEntryCol = null;
                                AbstractInvBillBaseEntryInfo billEntryInfo = null;
                                billInfo = InvCommonUtils.getBillInfo(billID, sourceBillCollection);
                                if (billInfo == null) {
                                    return filterInfo;
                                }
                                if (!SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && !SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) break block20;
                                billEntryCol = (AbstractObjectCollection)billInfo.getEntries();
                                if (CollectionUtil.isEmpty((AbstractObjectCollection)billEntryCol)) {
                                    return filterInfo;
                                }
                                int sourceEntrySize = billEntryCol.size();
                                for (int n = 0; n < sourceEntrySize; ++n) {
                                    if (billEntryCol.getObject(n) == null || !billEntryID.equals(((InvBillBaseEntryInfo)billEntryCol.getObject(n)).getId().toString())) continue;
                                    billEntryInfo = (InvBillBaseEntryInfo)billEntryCol.getObject(n);
                                    break;
                                }
                                if (billEntryInfo == null) {
                                    return filterInfo;
                                }
                                InvUpdateTypeInfo soureInvUpdateTypeInfo = billEntryInfo.getInvUpdateType();
                                if (null == soureInvUpdateTypeInfo) break block21;
                                StoreTypeInfo storeType = soureInvUpdateTypeInfo.getStoreType();
                                StoreStateInfo storeState = soureInvUpdateTypeInfo.getStoreState();
                                StoreTypeInfo storeTypePre = soureInvUpdateTypeInfo.getStoreTypePre();
                                StoreStateInfo storeStatePre = soureInvUpdateTypeInfo.getStoreStatePre();
                                if (storeType != null && storeState != null) {
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                                    mask.append("(#" + maskIndex++);
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                                    mask.append(" AND #" + maskIndex++ + ")");
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                                    mask.append(" OR (#" + maskIndex++);
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                                    mask.append(" AND #" + maskIndex++ + ")");
                                }
                                if (storeTypePre != null && storeStatePre != null) {
                                    if (maskIndex > 1) {
                                        mask.append(" OR ");
                                    }
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypePre.getId().toString(), CompareType.EQUALS));
                                    mask.append("(#" + maskIndex++);
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStatePre.getId().toString(), CompareType.EQUALS));
                                    mask.append(" AND #" + maskIndex++ + ")");
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypePre.getId().toString(), CompareType.EQUALS));
                                    mask.append(" OR (#" + maskIndex++);
                                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStatePre.getId().toString(), CompareType.EQUALS));
                                    mask.append(" AND #" + maskIndex++ + ")");
                                }
                                break block21;
                            }
                            if (!"50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) break block22;
                            AbstractMatAttrChangeBeforeEntryInfo beforeChangeEntry = null;
                            MatAttrChangeBeforeEntryCollection entries = ((MatAttrChangeBillInfo)billInfo).getEntry();
                            if (CollectionUtil.isEmpty((AbstractObjectCollection)entries)) {
                                return filterInfo;
                            }
                            int sourceEntrySize = entries.size();
                            for (int n = 0; n < sourceEntrySize; ++n) {
                                if (!billEntryID.equals(entries.get(n).getId().toString())) continue;
                                beforeChangeEntry = entries.get(n);
                                break;
                            }
                            storeTypeBefore = beforeChangeEntry.getStoreType();
                            storeStateBefore = beforeChangeEntry.getStoreStatus();
                            storeTypeAfter = null;
                            storeStateAfter = null;
                            MatAttrChangeAfterEntryCollection afterChangeEntries = beforeChangeEntry.getEntry1();
                            if (!CollectionUtil.isEmpty((AbstractObjectCollection)afterChangeEntries)) {
                                MatAttrChangeAfterEntryInfo afterChangeEntry = afterChangeEntries.get(0);
                                storeTypeAfter = afterChangeEntry.getStoreType();
                                storeStateAfter = afterChangeEntry.getStoreStatus();
                            }
                            if (!(info instanceof OtherIssueBillInfo)) break block23;
                            if (storeTypeBefore == null || storeStateBefore == null) break block21;
                            filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                            mask.append("(#" + maskIndex++);
                            filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                            mask.append(" AND #" + maskIndex++ + ")");
                            filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                            mask.append(" OR (#" + maskIndex++);
                            filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                            mask.append(" AND #" + maskIndex++ + ")");
                            break block21;
                        }
                        if (!(info instanceof OtherInWarehsBillInfo)) break block24;
                        if (storeTypeAfter == null || storeStateAfter == null) break block21;
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                        mask.append("(#" + maskIndex++);
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                        mask.append(" AND #" + maskIndex++ + ")");
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                        mask.append(" OR (#" + maskIndex++);
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                        mask.append(" AND #" + maskIndex++ + ")");
                        break block21;
                    }
                    if (storeTypeBefore != null && storeStateBefore != null) {
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                        mask.append("(#" + maskIndex++);
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                        mask.append(" AND #" + maskIndex++ + ")");
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                        mask.append(" OR (#" + maskIndex++);
                        filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                        mask.append(" AND #" + maskIndex++ + ")");
                    }
                    if (storeTypeAfter == null || storeStateAfter == null) break block21;
                    if (maskIndex > 1) {
                        mask.append(" OR ");
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    break block21;
                }
                if (!"50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) break block25;
                AbstractInvStateAdjustBillEntryInfo invAdjEntry = null;
                InvStateAdjustBillEntryCollection invAdjEntries = (InvStateAdjustBillEntryCollection)billInfo.getEntries();
                if (CollectionUtil.isEmpty((AbstractObjectCollection)invAdjEntries)) {
                    return filterInfo;
                }
                int sourceEntrySize = invAdjEntries.size();
                for (int n = 0; n < sourceEntrySize; ++n) {
                    if (!billEntryID.equals(invAdjEntries.get(n).getId().toString())) continue;
                    invAdjEntry = invAdjEntries.get(n);
                    break;
                }
                StoreTypeInfo storeTypeBefore = invAdjEntry.getStoreType();
                StoreStateInfo storeStateBefore = invAdjEntry.getSrcStoreStatus();
                StoreTypeInfo storeTypeAfter = invAdjEntry.getStoreType();
                StoreStateInfo storeStateAfter = invAdjEntry.getDestStoreStatus();
                if (storeTypeBefore != null && storeStateBefore != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
                if (storeTypeAfter == null || storeStateAfter == null) break block21;
                if (maskIndex > 1) {
                    mask.append(" OR ");
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                mask.append("(#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" OR (#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
                break block21;
            }
            if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
                StockTransferBillEntryCollection stockEntries = ((StockTransferBillInfo)billInfo).getEntry();
                StockTransferBillEntryInfo stockEntry = null;
                int sourceEntrySize = stockEntries.size();
                for (int n = 0; n < sourceEntrySize; ++n) {
                    if (!billEntryID.equals(stockEntries.get(n).getId().toString())) continue;
                    stockEntry = stockEntries.get(n);
                    StoreTypeInfo storeType = stockEntry.getStoreType();
                    StoreStateInfo storeState = stockEntry.getStoreState();
                    if (storeType == null || storeState == null) break;
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    break;
                }
            }
        }
        if (mask.length() > 0) {
            filterInfo.setMaskString(mask.toString());
        }
        return filterInfo;
    }

    public static CoreBaseCollection getSourceBillCollection(Context ctx, IObjectCollection entries) throws EASBizException, BOSException {
        boolean hasSourceBillType = false;
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        String sourceBillTypeID = "";
        InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entries.getObject(0);
        if (entry.getSourceBillType() != null && SCMBaseCommonUtil.isInvBill((String)entry.getSourceBillType().getId().toString())) {
            hasSourceBillType = true;
            sourceBillTypeID = entry.getSourceBillType().getId().toString();
        } else if (entry.getCoreBillTypeId() != null && SCMBaseCommonUtil.isInvBill((String)entry.getCoreBillTypeId())) {
            hasSourceBillType = false;
            sourceBillTypeID = entry.getCoreBillTypeId();
        }
        for (int i = 0; i < entries.size(); ++i) {
            entry = (InvBillBaseEntryInfo)entries.getObject(i);
            if (hasSourceBillType) {
                sourceBillIdSet.add(entry.getSourceBillId());
                continue;
            }
            sourceBillIdSet.add(entry.getCoreBillId());
        }
        CoreBaseCollection billColl = null;
        ICoreBase biz = InvCommonUtils.getBizInterface(ctx, sourceBillTypeID);
        if (biz != null && sourceBillIdSet != null && sourceBillIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", sourceBillIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = InvCommonUtils.getSelector(sourceBillTypeID);
            view.setSelector(sic);
            billColl = biz.getCollection(view);
        }
        return billColl;
    }

    private static SelectorItemCollection getSelector(String billTypeID) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.id"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.name"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.id"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.name"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.id"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.name"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.id"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.name"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.id"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.number"));
            sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.name"));
        } else if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.id"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.number"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.name"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.number"));
            sic.add(new SelectorItemInfo("entry.storeType.id"));
            sic.add(new SelectorItemInfo("entry.storeType.number"));
            sic.add(new SelectorItemInfo("entry.storeType.name"));
            sic.add(new SelectorItemInfo("entry.storeState.id"));
            sic.add(new SelectorItemInfo("entry.storeState.number"));
            sic.add(new SelectorItemInfo("entry.storeState.name"));
        } else if ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.storeType.id"));
            sic.add(new SelectorItemInfo("entry.storeType.number"));
            sic.add(new SelectorItemInfo("entry.storeType.name"));
            sic.add(new SelectorItemInfo("entry.storeStatus.id"));
            sic.add(new SelectorItemInfo("entry.storeStatus.number"));
            sic.add(new SelectorItemInfo("entry.storeStatus.name"));
            sic.add(new SelectorItemInfo("entry.entry1.storeType.id"));
            sic.add(new SelectorItemInfo("entry.entry1.storeType.number"));
            sic.add(new SelectorItemInfo("entry.entry1.storeType.name"));
            sic.add(new SelectorItemInfo("entry.entry1.storeStatus.id"));
            sic.add(new SelectorItemInfo("entry.entry1.storeStatus.number"));
            sic.add(new SelectorItemInfo("entry.entry1.storeStatus.name"));
        } else if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.storeType.id"));
            sic.add(new SelectorItemInfo("entry.storeType.number"));
            sic.add(new SelectorItemInfo("entry.storeType.name"));
            sic.add(new SelectorItemInfo("entry.srcStoreStatus.id"));
            sic.add(new SelectorItemInfo("entry.srcStoreStatus.number"));
            sic.add(new SelectorItemInfo("entry.srcStoreStatus.name"));
            sic.add(new SelectorItemInfo("entry.destStoreStatus.id"));
            sic.add(new SelectorItemInfo("entry.destStoreStatus.number"));
            sic.add(new SelectorItemInfo("entry.destStoreStatus.name"));
        }
        return sic;
    }

    protected FilterInfo buildInvUpdateTypeFilterInfo(Context ctx, InvBillBaseInfo info, int index, boolean isF7, CoreBaseCollection sourceBillCollection) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (info == null || info.getEntries() == null || info.getEntries().getObject(index) == null) {
            return filterInfo;
        }
        InvBillBaseEntryInfo entry = null;
        if (info.getEntries().getObject(index) instanceof InvBillBaseEntryInfo) {
            entry = (InvBillBaseEntryInfo)info.getEntries().getObject(index);
        }
        if (entry == null) {
            return filterInfo;
        }
        String sourceBillID = "";
        String sourceBillEntryID = "";
        String sourceBillTypeID = "";
        String coreBillID = "";
        String coreBillEntryID = "";
        String coreBillTypeID = "";
        sourceBillID = entry.getSourceBillId();
        sourceBillTypeID = entry.getSourceBillType().getId().toString();
        sourceBillEntryID = entry.getSourceBillEntryId();
        coreBillTypeID = entry.getCoreBillTypeId();
        coreBillID = entry.getCoreBillId();
        coreBillEntryID = entry.getCoreBillEntryId();
        if (SCMBaseCommonUtil.isInvBill((String)sourceBillTypeID)) {
            filterInfo = InvCommonUtils.getInvUpdateFilterInfo(ctx, info, sourceBillID, sourceBillTypeID, sourceBillEntryID, isF7, sourceBillCollection);
        } else if (SCMBaseCommonUtil.isInvBill((String)coreBillTypeID)) {
            filterInfo = InvCommonUtils.getInvUpdateFilterInfo(ctx, info, coreBillID, coreBillTypeID, coreBillEntryID, isF7, sourceBillCollection);
        }
        return filterInfo;
    }

    protected FilterInfo buildInvUpdateTypeFilterInfo(Context ctx, InvBillBaseInfo info, InvBillBaseEntryInfo entry, boolean isF7, CoreBaseCollection sourceBillCollection) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (entry == null) {
            return filterInfo;
        }
        String sourceBillID = "";
        String sourceBillEntryID = "";
        String sourceBillTypeID = "";
        String coreBillID = "";
        String coreBillEntryID = "";
        String coreBillTypeID = "";
        sourceBillID = entry.getSourceBillId();
        sourceBillTypeID = entry.getSourceBillType().getId().toString();
        sourceBillEntryID = entry.getSourceBillEntryId();
        coreBillTypeID = entry.getCoreBillTypeId();
        coreBillID = entry.getCoreBillId();
        coreBillEntryID = entry.getCoreBillEntryId();
        if (SCMBaseCommonUtil.isInvBill((String)sourceBillTypeID)) {
            filterInfo = InvCommonUtils.getInvUpdateFilterInfo(ctx, info, sourceBillID, sourceBillTypeID, sourceBillEntryID, isF7, sourceBillCollection);
        } else if (SCMBaseCommonUtil.isInvBill((String)coreBillTypeID)) {
            filterInfo = InvCommonUtils.getInvUpdateFilterInfo(ctx, info, coreBillID, coreBillTypeID, coreBillEntryID, isF7, sourceBillCollection);
        }
        return filterInfo;
    }

    public static InvUpdateTypeInfo getDefaultInvUpdateTypeInfo(Context ctx, EntityViewInfo view) throws EASBizException, BOSException {
        InvUpdateTypeInfo result = null;
        TransactionInvUpdateTypeCollection col = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, view);
        int size = col.size();
        TransactionInvUpdateTypeInfo tranInvUpdate = null;
        for (int i = 0; i < size; ++i) {
            tranInvUpdate = col.get(i);
            if (!tranInvUpdate.isDefaults()) continue;
            result = tranInvUpdate.getInvUpdateType();
            break;
        }
        if (result == null && size > 0) {
            result = col.get(0).getInvUpdateType();
        }
        return result;
    }

    public static SerialNumberStatusEnum getSnStatusByTranType(TransactionTypeInfo ttInfo, InvUpdateTypeInfo invUpdateType, boolean isNagetive) {
        if (ttInfo == null || invUpdateType == null) {
            return SerialNumberStatusEnum.NULL;
        }
        if (!invUpdateType.isExistingQty() && !invUpdateType.isExistingQtyPre()) {
            return SerialNumberStatusEnum.NULL;
        }
        if (!isNagetive && invUpdateType.isExistingQty() && !invUpdateType.isExistingQtyPre() || isNagetive && !invUpdateType.isExistingQty() && invUpdateType.isExistingQtyPre()) {
            return SerialNumberStatusEnum.INWAREHOUSE;
        }
        if (isNagetive && invUpdateType.isExistingQty() && !invUpdateType.isExistingQtyPre() || !isNagetive && !invUpdateType.isExistingQty() && invUpdateType.isExistingQtyPre()) {
            return SerialNumberStatusEnum.SALE;
        }
        return SerialNumberStatusEnum.OUTTHENIN;
    }

    public static boolean isNeedUpdateSerialNumber(InvBillBaseInfo billInfo) {
        String bosType;
        String billtrypeid;
        if (billInfo == null) {
            return false;
        }
        return billInfo.getBillType() != null ? "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtrypeid = billInfo.getBillType().getId().toString()) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billtrypeid) || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billtrypeid) || "50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billtrypeid) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billtrypeid) || "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(billtrypeid) || "CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(billtrypeid) : SCMConstant.BOSTYPE_SALEISSUE.equals(bosType = billInfo.getBOSType().toString()) || SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType) || "A4D04D23".equals(bosType) || "A4D04D24".equals(bosType) || "E3DAFF63".equals(bosType) || "71D272F1".equals(bosType) || "500AB75E".equals(bosType) || "FA1292B4".equals(bosType) || SCMConstant.BOSTYPE_INVENTORYINIT.equals(bosType) || "A4D04D25".equals(bosType) || SCMConstant.BOSTYPE_INVSTATEADJUST.equals(bosType) || "15F2BD83".equals(bosType) || "0074F505".equals(bosType) || "B64A653B".equals(bosType);
    }

    public static InvUpdateTypeInfo getDefaultInvUpdateType(String billTypeID, TransactionTypeInfo tti) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (!SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && !SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) || tti == null) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)tti.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("invUpdateType.status", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        TransactionInvUpdateTypeCollection col = InvCommonUtils.getTransactionInvUpdateTypeCol(null, viewInfo);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        InvUpdateTypeInfo invUpdateType = null;
        TransactionInvUpdateTypeInfo transInvUpdate = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            transInvUpdate = col.get(i);
            if (!transInvUpdate.isDefaults()) continue;
            return transInvUpdate.getInvUpdateType();
        }
        return invUpdateType;
    }

    public static InvUpdateTypeInfo getDefaultWebInvUpdateType(Context ctx, String billTypeID, TransactionTypeInfo tti) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (!SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && !SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) || tti == null) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)tti.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("invUpdateType.status", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        TransactionInvUpdateTypeCollection col = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, viewInfo);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        InvUpdateTypeInfo invUpdateType = null;
        TransactionInvUpdateTypeInfo transInvUpdate = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            transInvUpdate = col.get(i);
            if (!transInvUpdate.isDefaults()) continue;
            return transInvUpdate.getInvUpdateType();
        }
        return invUpdateType;
    }

    public static CostObjectCollection getCostObject(Context ctx, String number, String couID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)couID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        ICostObject iCostObject = ctx == null ? CostObjectFactory.getRemoteInstance() : CostObjectFactory.getLocalInstance((Context)ctx);
        CostObjectCollection coll = iCostObject.getCostObjectCollection(viewInfo);
        return coll;
    }

    public static Map<String, MaterialCompanyInfoInfo> getMaterialCompanyMap(Context ctx, InvBillBaseInfo bill) throws EASBizException, BOSException {
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> couIdSet = new HashSet<String>();
        HashMap<String, MaterialCompanyInfoInfo> matCouMap = new HashMap<String, MaterialCompanyInfoInfo>();
        InvBillBaseEntryInfo entry = null;
        int count = bill.getEntries().size();
        for (int i = 0; i < count; ++i) {
            entry = (InvBillBaseEntryInfo)bill.getEntries().getObject(i);
            if (entry.getMaterial() != null) {
                materialIdSet.add(entry.getMaterial().getId().toString());
            }
            if (entry.getCompanyOrgUnit() == null) continue;
            couIdSet.add(entry.getCompanyOrgUnit().getId().toString());
        }
        if (materialIdSet.size() == 0 || couIdSet.size() == 0) {
            return matCouMap;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", couIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("KAClass.id"));
        sic.add(new SelectorItemInfo("KAClass.name"));
        sic.add(new SelectorItemInfo("KAClass.number"));
        sic.add(new SelectorItemInfo("standardCost"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("calculateType"));
        sic.add(new SelectorItemInfo("materialId"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("mateial.longNumber"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.shortName"));
        sic.add(new SelectorItemInfo("mateial.pricePrecision"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        IMaterialCompanyInfo iMaterialCompanyInfo = null;
        iMaterialCompanyInfo = ctx == null ? MaterialCompanyInfoFactory.getRemoteInstance() : MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection matComColl = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(viewInfo);
        if (matComColl != null && matComColl.size() >= 1) {
            for (int i = 0; i < matComColl.size(); ++i) {
                MaterialCompanyInfoInfo info = matComColl.get(i);
                matCouMap.put(info.getMateial().getId().toString() + info.getCompany().getId().toString(), info);
            }
        }
        return matCouMap;
    }

    public static InvUpdateTypeInfo getDefaultInvUpdateType(Context ctx, String billTypeID, TransactionTypeInfo tti) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (!SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && !SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) || tti == null) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)tti.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("invUpdateType.status", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        TransactionInvUpdateTypeCollection col = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, viewInfo);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        InvUpdateTypeInfo invUpdateType = null;
        TransactionInvUpdateTypeInfo transInvUpdate = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            transInvUpdate = col.get(i);
            if (!transInvUpdate.isDefaults()) continue;
            return transInvUpdate.getInvUpdateType();
        }
        return invUpdateType;
    }

    public static Boolean isSerialRequired(String storageOrgId, Context ctx) throws BOSException, EASBizException {
        Boolean result = true;
        if (StringUtils.isEmpty((String)storageOrgId)) {
            return result;
        }
        IParamControl iParam = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        String paramValue = iParam.getParamValue((IObjectPK)new ObjectUuidPK(storageOrgId), "INM240");
        return Boolean.valueOf(paramValue);
    }
}

