/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvAlgorithm;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public abstract class PurInAlgorithm
extends InvAlgorithm {
    protected void calActualCost(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal purchaseCost = this.getPurchaseCost(i);
        BigDecimal purchaseFee = this.getPurchaseFee(i);
        BigDecimal materialCost = this.getMaterialCost(i);
        this.setActualCost(purchaseCost.add(purchaseFee).add(materialCost).setScale(scale, 4), i);
    }

    @Override
    protected void calByAmount(int i) {
        this.calPriceByAmount(i);
        this.calTaxPrice(i);
        this.calTax(i);
        this.calLocalTax(i);
        this.calTaxAmount(i);
        this.calLocalTaxAmount(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calDiscountAmount(i);
        this.calPurchaseCostByAmount(i);
        this.calUnitPurchaseCostByAmount(i);
        this.calActualCost(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calByPrice(int i) {
        this.calAmount(i);
        this.calTaxPricebyPrice(i);
        this.calTax(i);
        this.calLocalTax(i);
        this.calActualPrice(i);
        this.calTaxAmount(i);
        this.calDiscountAmount(i);
        this.calActualTaxPrice(i);
        this.calLocalTaxAmount(i);
        this.calPurchaseCostByPrice(i);
        this.calUnitPurchaseCostByAmount(i);
        this.calActualCost(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calByPrice4UnitSource(int i) {
        this.calTaxPricebyPrice(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
        this.calUnitPurchaseCostByAmount(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calByTaxAmount(int i) {
        this.calLocalTaxAmount(i);
        this.calTax(i);
        this.calTaxPrice(i);
        this.calActualTaxPrice(i);
        this.calAmount(i);
        this.calPriceByTaxPrice(i);
        this.calActualPrice(i);
        this.calDiscountAmount(i);
        this.calLocalTax(i);
        this.calPurchaseCost(i);
        this.calUnitPurchaseCost(i);
        this.calActualCost(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calByTaxPrice(int i) {
        this.calDiscountAmount(i);
        this.calPriceByTaxPrice(i);
        this.calTaxAmount(i);
        this.calTax(i);
        this.calLocalTaxAmount(i);
        this.calAmount(i);
        this.calLocalTax(i);
        this.calActualTaxPrice(i);
        this.calActualPrice(i);
        this.calPurchaseCost(i);
        this.calUnitPurchaseCost(i);
        this.calActualCost(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calByTaxPrice4UnitSource(int i) {
        this.calPriceByTaxPrice(i);
        this.calActualTaxPrice(i);
        this.calActualPrice(i);
        this.calUnitPurchaseCost(i);
        this.calUnitActualCost(i);
    }

    @Override
    protected void calPriceByAmount(int i) {
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        this.setPrice(price, i);
    }

    protected void calPurchaseCost(int i) {
        int scale = this.getLocalAmountPrecision();
        if (this.isInTax()) {
            BigDecimal localTaxAmount = this.getLocalTaxAmount(i);
            BigDecimal localTax = this.getLocalTax(i);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = localTaxAmount.subtract(localTax);
            purchaseCost = purchaseCost.setScale(scale, 4);
            this.setPurchaseCost(purchaseCost, i);
        } else {
            BigDecimal unitPurchaseCost = this.getUnitPurchaseCost(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = unitPurchaseCost.multiply(qty);
            this.setPurchaseCost(purchaseCost, i);
        }
    }

    protected void reCalPurchaseCost(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal localTaxAmount = this.getLocalTaxAmount(i);
        BigDecimal localTax = this.getLocalTax(i);
        BigDecimal purchaseCost = SysConstant.BIGZERO;
        purchaseCost = localTaxAmount.subtract(localTax);
        purchaseCost = purchaseCost.setScale(scale, 4);
        this.setPurchaseCost(purchaseCost, i);
    }

    protected void calPurchaseCostByAmount(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal exchangerate = this.getExchangeRate();
        BigDecimal amount = this.getAmount(i);
        if (exchangerate.compareTo(SCMConstant.BIGDECIMAL_ONE) == 0) {
            this.setPurchaseCost(amount, i);
        } else if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            this.setPurchaseCost(amount.multiply(exchangerate).setScale(scale, 4), i);
        } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            this.setPurchaseCost(amount.divide(exchangerate, scale, 4), i);
        }
    }

    protected void calPurchaseCostByPrice(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal localTaxAmount = this.getLocalTaxAmount(i);
        BigDecimal localTax = this.getLocalTax(i);
        BigDecimal purchaseCost = SysConstant.BIGZERO;
        purchaseCost = localTaxAmount.subtract(localTax);
        purchaseCost = purchaseCost.setScale(scale, 4);
        this.setPurchaseCost(purchaseCost, i);
    }

    protected void calQty(int i) throws BaseException {
        BigDecimal baseQty = this.getBaseQty(i);
        BigDecimal qty = SysConstant.BIGZERO;
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null && SysConstant.BIGZERO.compareTo(coefficient) != 0) {
                qty = baseQty.divide(coefficient, precision, 4);
            }
        }
        this.setQty(qty, i);
    }

    protected void calStandardCostByUnitStandardCost(int i) {
        BigDecimal qty = this.getQty(i);
        BigDecimal unitStandardCost = this.getUnitStandardCost(i);
        BigDecimal standardCost = unitStandardCost.multiply(qty);
        standardCost = standardCost.setScale(this.getLocalAmountPrecision(), 4);
        this.setStandardCost(standardCost, i);
    }

    @Override
    protected void calTotalTaxAmount() {
    }

    @Override
    protected void calTotalAmount() {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalAmount = totalAmount.add(this.getAmount(i));
        }
        this.setTotalAmount(totalAmount);
    }

    @Override
    protected void calTotalTax() {
    }

    protected void calUnitActualCost(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal actualCost = this.getActualCost(i);
        BigDecimal unitPurchaseCost = this.getUnitPurchaseCost(i);
        if (this.getPurchaseFee(i).compareTo(SysConstant.BIGZERO) == 0 && this.getMaterialCost(i).compareTo(SysConstant.BIGZERO) == 0) {
            this.setUnitActualCost(unitPurchaseCost, i);
        } else if (qty.compareTo(SysConstant.BIGZERO) != 0) {
            this.setUnitActualCost(actualCost.divide(qty, scale, 4), i);
        }
    }

    protected void calUnitPurchaseCost(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (this.isInTax()) {
            BigDecimal purchaseCost = this.getPurchaseCost(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal actualPrice = this.getActualPrice(i);
            BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
            if (SCMConstant.BIGDECIMAL_ONE.compareTo(exchangerate) == 0) {
                this.setUnitPurchaseCost(actualPrice, i);
            } else if (purchaseCost != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
                unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
                this.setUnitPurchaseCost(unitPurchaseCost, i);
            }
        } else {
            BigDecimal actualPrice = this.getActualPrice(i);
            if (exchangerate.compareTo(SysConstant.BIGZERO) != 0) {
                if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    this.setUnitPurchaseCost(actualPrice.multiply(exchangerate).setScale(scale, 4), i);
                } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                    this.setUnitPurchaseCost(actualPrice.divide(exchangerate, scale, 4), i);
                }
            } else {
                this.setUnitPurchaseCost(actualPrice, i);
            }
        }
    }

    protected void reCalUnitPurchaseCost(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal exchangerate = this.getExchangeRate();
        BigDecimal purchaseCost = this.getPurchaseCost(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal actualPrice = this.getActualPrice(i);
        BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
        if (SCMConstant.BIGDECIMAL_ONE.compareTo(exchangerate) == 0) {
            this.setUnitPurchaseCost(actualPrice, i);
        } else if (purchaseCost != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
            unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
            this.setUnitPurchaseCost(unitPurchaseCost, i);
        }
    }

    protected void calUnitPurchaseCostByAmount(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal exchangerate = this.getExchangeRate();
        BigDecimal purchaseCost = this.getPurchaseCost(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal actualPrice = this.getActualPrice(i);
        BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
        if (exchangerate.compareTo(SCMConstant.BIGDECIMAL_ONE) == 0) {
            this.setUnitPurchaseCost(actualPrice, i);
        } else if (purchaseCost != null && qty != null && qty.compareTo(SysConstant.BIGZERO) != 0) {
            unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
            this.setUnitPurchaseCost(unitPurchaseCost, i);
        }
    }

    protected void calUnitStandardCost(int i) throws BOSException, EASBizException {
        BigDecimal coefficient;
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo;
        BigDecimal baseUnitStandardCost = SysConstant.BIGZERO;
        if (this.getMaterial(i) != null && this.getMaterial(i).getId() != null && (aMaterialCompanyInfoInfo = this.getMaterialCompanyInfo(this.getMaterial(i).getId().toString())) != null && aMaterialCompanyInfoInfo.getStandardCost() != null) {
            baseUnitStandardCost = aMaterialCompanyInfoInfo.getStandardCost();
        }
        BigDecimal unitStandardCost = baseUnitStandardCost;
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            unitStandardCost = unitStandardCost.multiply(coefficient).setScale(this.getPricePrecision(i), 4);
        }
        this.setUnitStandardCost(unitStandardCost, i);
    }

    protected abstract BigDecimal getActualCost(int var1);

    protected abstract BigDecimal getActualPrice(int var1);

    @Override
    protected abstract MeasureUnitInfo getAssistUnit(int var1);

    @Override
    protected abstract BigDecimal getBaseQty(int var1);

    protected abstract BigDecimal getLocalAmount(int var1);

    protected abstract BigDecimal getLocalPrice(int var1);

    protected abstract BigDecimal getLocalTax(int var1);

    protected abstract BigDecimal getLocalTaxAmount(int var1);

    @Override
    protected abstract MaterialInfo getMaterial(int var1);

    protected abstract BigDecimal getMaterialCost(int var1);

    protected abstract BigDecimal getPurchaseCost(int var1);

    protected abstract BigDecimal getPurchaseFee(int var1);

    protected abstract StorageOrgUnitInfo getReceiveStorageOrgUnit(int var1);

    protected abstract BigDecimal getReturnBaseQty(int var1);

    protected abstract BigDecimal getStandardCost(int var1);

    @Override
    protected abstract MeasureUnitInfo getUnit(int var1);

    protected abstract BigDecimal getUnitPurchaseCost(int var1);

    protected abstract BigDecimal getUnitStandardCost(int var1);

    protected abstract boolean isIsPresent(int var1);

    protected void reCalTotalFields() {
        BigDecimal totalActualCost = SysConstant.BIGZERO;
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal totalLocalAmount = SysConstant.BIGZERO;
        BigDecimal totalStandardCost = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalActualCost = totalActualCost.add(this.getActualCost(i));
            totalAmount = totalAmount.add(this.getAmount(i));
            totalLocalAmount = totalLocalAmount.add(this.getLocalAmount(i));
            totalStandardCost = totalStandardCost.add(this.getStandardCost(i));
        }
        this.setTotalActualCost(totalActualCost);
        this.setTotalAmount(totalAmount);
        this.setTotalLocalAmount(totalLocalAmount);
        this.setTotalStandardCost(totalStandardCost);
    }

    protected abstract void setActualCost(BigDecimal var1, int var2);

    @Override
    protected abstract void setAssistQty(BigDecimal var1, int var2);

    protected abstract void setAssociateQty(BigDecimal var1, int var2);

    @Override
    protected abstract void setBaseQty(BigDecimal var1, int var2);

    protected abstract void setCanDirectReqBaseQty(BigDecimal var1, int var2);

    protected abstract void setCanDirectReqQty(BigDecimal var1, int var2);

    protected abstract void setCompanyOrgUnit(CompanyOrgUnitInfo var1, int var2);

    protected abstract void setLocalPrice(BigDecimal var1, int var2);

    protected abstract void setPurchaseCost(BigDecimal var1, int var2);

    @Override
    protected abstract void setQty(BigDecimal var1, int var2);

    protected abstract void setReceiveStorageOrgUnit(StorageOrgUnitInfo var1, int var2);

    protected abstract void setReturnBaseQty(BigDecimal var1, int var2);

    protected abstract void setStandardCost(BigDecimal var1, int var2);

    protected abstract void setTotalActualCost(BigDecimal var1);

    protected abstract void setTotalAmount(BigDecimal var1);

    protected abstract void setTotalLocalAmount(BigDecimal var1);

    protected abstract void setTotalStandardCost(BigDecimal var1);

    protected abstract void setUnitActualCost(BigDecimal var1, int var2);

    protected abstract void setUnitPurchaseCost(BigDecimal var1, int var2);

    protected abstract void setUnitStandardCost(BigDecimal var1, int var2);

    protected abstract void setUnReturnedBaseQty(BigDecimal var1, int var2);

    protected abstract void setUnWriteOffAmount(BigDecimal var1, int var2);

    protected abstract void setUnWriteOffBaseQty(BigDecimal var1, int var2);

    protected abstract void setUnWriteOffQty(BigDecimal var1, int var2);

    protected abstract void setWrittenOffAmount(BigDecimal var1, int var2);

    protected abstract void setWrittenOffBaseQty(BigDecimal var1, int var2);

    protected abstract void setWrittenOffQty(BigDecimal var1, int var2);

    @Override
    protected void calTaxAmount(int i) {
        boolean createVirtualBillForMatReq = false;
        if (this.ctx.get((Object)"createVirtualBillForMatReq") != null) {
            createVirtualBillForMatReq = (Boolean)this.ctx.get((Object)"createVirtualBillForMatReq");
        }
        if (this.isInTax() && createVirtualBillForMatReq) {
            int scale = this.getAmountPrecision();
            BigDecimal taxPrice = this.getTaxPrice(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal taxAmount = taxPrice.multiply(qty).multiply(BigDecimal.ONE.subtract(discountRate.divide(new BigDecimal("100"))));
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        } else {
            super.calTaxAmount(i);
        }
    }
}

